/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.CreditNoteCollection;
import com.stripe.model.Customer;
import com.stripe.model.CustomerBalanceTransaction;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.Refund;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CreditNoteCreateParams;
import com.stripe.param.CreditNoteListParams;
import com.stripe.param.CreditNotePreviewParams;
import com.stripe.param.CreditNoteRetrieveParams;
import com.stripe.param.CreditNoteUpdateParams;
import com.stripe.param.CreditNoteVoidCreditNoteParams;
import java.util.Map;
import lombok.Generated;

public class CreditNote
extends ApiResource
implements HasId,
MetadataStore<CreditNote> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_balance_transaction")
    ExpandableField<CustomerBalanceTransaction> customerBalanceTransaction;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="memo")
    String memo;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="number")
    String number;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pdf")
    String pdf;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="refund")
    ExpandableField<Refund> refund;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="voided_at")
    Long voidedAt;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getCustomerBalanceTransaction() {
        return this.customerBalanceTransaction != null ? this.customerBalanceTransaction.getId() : null;
    }

    public void setCustomerBalanceTransaction(String id) {
        this.customerBalanceTransaction = ApiResource.setExpandableFieldId(id, this.customerBalanceTransaction);
    }

    public CustomerBalanceTransaction getCustomerBalanceTransactionObject() {
        return this.customerBalanceTransaction != null ? this.customerBalanceTransaction.getExpanded() : null;
    }

    public void setCustomerBalanceTransactionObject(CustomerBalanceTransaction expandableObject) {
        this.customerBalanceTransaction = new ExpandableField<CustomerBalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getRefund() {
        return this.refund != null ? this.refund.getId() : null;
    }

    public void setRefund(String id) {
        this.refund = ApiResource.setExpandableFieldId(id, this.refund);
    }

    public Refund getRefundObject() {
        return this.refund != null ? this.refund.getExpanded() : null;
    }

    public void setRefundObject(Refund expandableObject) {
        this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
    }

    public static CreditNote create(Map<String, Object> params) throws StripeException {
        return CreditNote.create(params, (RequestOptions)null);
    }

    public static CreditNote create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    public static CreditNote create(CreditNoteCreateParams params) throws StripeException {
        return CreditNote.create(params, (RequestOptions)null);
    }

    public static CreditNote create(CreditNoteCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    public static CreditNote preview(Map<String, Object> params) throws StripeException {
        return CreditNote.preview(params, (RequestOptions)null);
    }

    public static CreditNote preview(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes/preview");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
    }

    public static CreditNote preview(CreditNotePreviewParams params) throws StripeException {
        return CreditNote.preview(params, (RequestOptions)null);
    }

    public static CreditNote preview(CreditNotePreviewParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes/preview");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
    }

    public static CreditNote retrieve(String id) throws StripeException {
        return CreditNote.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CreditNote retrieve(String id, RequestOptions options) throws StripeException {
        return CreditNote.retrieve(id, (Map<String, Object>)null, options);
    }

    public static CreditNote retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
    }

    public static CreditNote retrieve(String id, CreditNoteRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
    }

    public static CreditNoteCollection list(Map<String, Object> params) throws StripeException {
        return CreditNote.list(params, (RequestOptions)null);
    }

    public static CreditNoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
        return ApiResource.requestCollection(url, params, CreditNoteCollection.class, options);
    }

    public static CreditNoteCollection list(CreditNoteListParams params) throws StripeException {
        return CreditNote.list(params, (RequestOptions)null);
    }

    public static CreditNoteCollection list(CreditNoteListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
        return ApiResource.requestCollection(url, params, CreditNoteCollection.class, options);
    }

    public CreditNote update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public CreditNote update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    public CreditNote update(CreditNoteUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CreditNote update(CreditNoteUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    public CreditNote voidCreditNote() throws StripeException {
        return this.voidCreditNote((Map<String, Object>)null, (RequestOptions)null);
    }

    public CreditNote voidCreditNote(RequestOptions options) throws StripeException {
        return this.voidCreditNote((Map<String, Object>)null, options);
    }

    public CreditNote voidCreditNote(Map<String, Object> params) throws StripeException {
        return this.voidCreditNote(params, (RequestOptions)null);
    }

    public CreditNote voidCreditNote(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params) throws StripeException {
        return this.voidCreditNote(params, (RequestOptions)null);
    }

    public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getMemo() {
        return this.memo;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPdf() {
        return this.pdf;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getVoidedAt() {
        return this.voidedAt;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPdf(String pdf) {
        this.pdf = pdf;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setVoidedAt(Long voidedAt) {
        this.voidedAt = voidedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditNote)) {
            return false;
        }
        CreditNote other = (CreditNote)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerBalanceTransaction = this.getCustomerBalanceTransaction();
        String other$customerBalanceTransaction = other.getCustomerBalanceTransaction();
        if (this$customerBalanceTransaction == null ? other$customerBalanceTransaction != null : !this$customerBalanceTransaction.equals(other$customerBalanceTransaction)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$pdf = this.getPdf();
        String other$pdf = other.getPdf();
        if (this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$refund = this.getRefund();
        String other$refund = other.getRefund();
        if (this$refund == null ? other$refund != null : !this$refund.equals(other$refund)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Long this$voidedAt = this.getVoidedAt();
        Long other$voidedAt = other.getVoidedAt();
        return !(this$voidedAt == null ? other$voidedAt != null : !((Object)this$voidedAt).equals(other$voidedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditNote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerBalanceTransaction = this.getCustomerBalanceTransaction();
        result = result * 59 + ($customerBalanceTransaction == null ? 43 : $customerBalanceTransaction.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $pdf = this.getPdf();
        result = result * 59 + ($pdf == null ? 43 : $pdf.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $refund = this.getRefund();
        result = result * 59 + ($refund == null ? 43 : $refund.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Long $voidedAt = this.getVoidedAt();
        result = result * 59 + ($voidedAt == null ? 43 : ((Object)$voidedAt).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

