// Generated by delombok at Mon Dec 09 14:51:13 PST 2019
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.EventListParams;
import com.stripe.param.EventRetrieveParams;
import java.util.Map;

public class Event extends ApiResource implements HasId {
  /**
   * The connected account that originated the event.
   */
  @SerializedName("account")
  String account;
  /**
   * The Stripe API version used to render `data`. *Note: This property is populated only for events
   * on or after October 31, 2014*.
   */
  @SerializedName("api_version")
  String apiVersion;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  @SerializedName("data")
  EventData data;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `event`.
   */
  @SerializedName("object")
  String object;
  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @SerializedName("pending_webhooks")
  Long pendingWebhooks;
  /**
   * Information on the API request that instigated the event.
   */
  @SerializedName("request")
  EventRequest request;
  /**
   * Description of the event (e.g., `invoice.created` or `charge.refunded`).
   */
  @SerializedName("type")
  String type;
  /**
   * @deprecated Use {@link #account} instead (https://stripe.com/docs/upgrades#2017-05-25).
   */
  @Deprecated
  @SerializedName("user_id")
  String userId;

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a href="/docs/api/events/object">event object</a>
   * <code>api_version</code> attribute (not according to your current Stripe API version or <code>
   * Stripe-Version</code> header).
   */
  public static EventCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a href="/docs/api/events/object">event object</a>
   * <code>api_version</code> attribute (not according to your current Stripe API version or <code>
   * Stripe-Version</code> header).
   */
  public static EventCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/events");
    return ApiResource.requestCollection(url, params, EventCollection.class, options);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a href="/docs/api/events/object">event object</a>
   * <code>api_version</code> attribute (not according to your current Stripe API version or <code>
   * Stripe-Version</code> header).
   */
  public static EventCollection list(EventListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a href="/docs/api/events/object">event object</a>
   * <code>api_version</code> attribute (not according to your current Stripe API version or <code>
   * Stripe-Version</code> header).
   */
  public static EventCollection list(EventListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/events");
    return ApiResource.requestCollection(url, params, EventCollection.class, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, EventRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
  }

  /**
   * Get deserialization helper to handle failure due to schema incompatibility. When event API
   * version matches that of the library's pinned version, the following integration pattern is
   * safe.
   *
   * <pre>
   *   Event event = getEvent(); // either from webhook or event endpoint
   *   EventDataObjectDeserializer deserializer = event.getDataObjectDeserializer();
   *   Optional&lt;StripeObject&gt; stripeObject = deserializer.getObject();
   * </pre>
   *
   * You can ensure that webhook events has the same API version by creating webhook endpoint
   * specifying api version](https://stripe.com/docs/api/webhook_endpoints/create) as {@link
   * com.stripe.Stripe#API_VERSION}. For reading from old webhook endpoints or old events with
   * potential schema incompatibility, see {@link EventDataObjectDeserializer#deserialize()} and
   * {@link EventDataObjectDeserializer#deserializeUnsafe()}.
   */
  public EventDataObjectDeserializer getDataObjectDeserializer() {
    return new EventDataObjectDeserializer(apiVersion, type, data.object);
  }

  /**
   * The connected account that originated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  /**
   * The Stripe API version used to render `data`. *Note: This property is populated only for events
   * on or after October 31, 2014*.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApiVersion() {
    return this.apiVersion;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EventData getData() {
    return this.data;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `event`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPendingWebhooks() {
    return this.pendingWebhooks;
  }

  /**
   * Information on the API request that instigated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EventRequest getRequest() {
    return this.request;
  }

  /**
   * Description of the event (e.g., `invoice.created` or `charge.refunded`).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * @deprecated Use {@link #account} instead (https://stripe.com/docs/upgrades#2017-05-25).
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUserId() {
    return this.userId;
  }

  /**
   * The connected account that originated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  /**
   * The Stripe API version used to render `data`. *Note: This property is populated only for events
   * on or after October 31, 2014*.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApiVersion(final String apiVersion) {
    this.apiVersion = apiVersion;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setData(final EventData data) {
    this.data = data;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `event`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingWebhooks(final Long pendingWebhooks) {
    this.pendingWebhooks = pendingWebhooks;
  }

  /**
   * Information on the API request that instigated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequest(final EventRequest request) {
    this.request = request;
  }

  /**
   * Description of the event (e.g., `invoice.created` or `charge.refunded`).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * @deprecated Use {@link #account} instead (https://stripe.com/docs/upgrades#2017-05-25).
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUserId(final String userId) {
    this.userId = userId;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Event)) return false;
    final Event other = (Event) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$apiVersion = this.getApiVersion();
    final java.lang.Object other$apiVersion = other.getApiVersion();
    if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$data = this.getData();
    final java.lang.Object other$data = other.getData();
    if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$pendingWebhooks = this.getPendingWebhooks();
    final java.lang.Object other$pendingWebhooks = other.getPendingWebhooks();
    if (this$pendingWebhooks == null ? other$pendingWebhooks != null : !this$pendingWebhooks.equals(other$pendingWebhooks)) return false;
    final java.lang.Object this$request = this.getRequest();
    final java.lang.Object other$request = other.getRequest();
    if (this$request == null ? other$request != null : !this$request.equals(other$request)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$userId = this.getUserId();
    final java.lang.Object other$userId = other.getUserId();
    if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Event;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $apiVersion = this.getApiVersion();
    result = result * PRIME + ($apiVersion == null ? 43 : $apiVersion.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $data = this.getData();
    result = result * PRIME + ($data == null ? 43 : $data.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $pendingWebhooks = this.getPendingWebhooks();
    result = result * PRIME + ($pendingWebhooks == null ? 43 : $pendingWebhooks.hashCode());
    final java.lang.Object $request = this.getRequest();
    result = result * PRIME + ($request == null ? 43 : $request.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $userId = this.getUserId();
    result = result * PRIME + ($userId == null ? 43 : $userId.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
