// Generated by delombok at Wed Jan 15 15:10:53 PST 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SkuCreateParams;
import com.stripe.param.SkuListParams;
import com.stripe.param.SkuRetrieveParams;
import com.stripe.param.SkuUpdateParams;
import java.util.Map;

public class Sku extends ApiResource implements HasId, MetadataStore<Sku> {
  /**
   * Whether the SKU is available for purchase.
   */
  @SerializedName("active")
  Boolean active;
  /**
   * A dictionary of attributes and values for the attributes defined by the product. If, for
   * example, a product's attributes are `["size", "gender"]`, a valid SKU has the following
   * dictionary of attributes: `{"size": "Medium", "gender": "Unisex"}`.
   */
  @SerializedName("attributes")
  Map<String, String> attributes;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @SerializedName("currency")
  String currency;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The URL of an image for this SKU, meant to be displayable to the customer.
   */
  @SerializedName("image")
  String image;
  @SerializedName("inventory")
  Inventory inventory;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `sku`.
   */
  @SerializedName("object")
  String object;
  /**
   * The dimensions of this SKU for shipping purposes.
   */
  @SerializedName("package_dimensions")
  PackageDimensions packageDimensions;
  /**
   * The cost of the item as a positive integer in the smallest currency unit (that is, 100 cents to
   * charge $1.00, or 100 to charge ¥100, Japanese Yen being a zero-decimal currency).
   */
  @SerializedName("price")
  Long price;
  /**
   * The ID of the product this SKU is associated with. The product must be currently active.
   */
  @SerializedName("product")
  ExpandableField<Product> product;
  @SerializedName("updated")
  Long updated;

  /**
   * Get id of expandable `product` object.
   */
  public String getProduct() {
    return (this.product != null) ? this.product.getId() : null;
  }

  public void setProduct(String id) {
    this.product = ApiResource.setExpandableFieldId(id, this.product);
  }

  /**
   * Get expanded `product`.
   */
  public Product getProductObject() {
    return (this.product != null) ? this.product.getExpanded() : null;
  }

  public void setProductObject(Product expandableObject) {
    this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
  }

  /**
   * Retrieves the details of an existing SKU. Supply the unique SKU identifier from either a SKU
   * creation request or from the product, and Stripe will return the corresponding SKU information.
   */
  public static Sku retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing SKU. Supply the unique SKU identifier from either a SKU
   * creation request or from the product, and Stripe will return the corresponding SKU information.
   */
  public static Sku retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing SKU. Supply the unique SKU identifier from either a SKU
   * creation request or from the product, and Stripe will return the corresponding SKU information.
   */
  public static Sku retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Sku.class, options);
  }

  /**
   * Retrieves the details of an existing SKU. Supply the unique SKU identifier from either a SKU
   * creation request or from the product, and Stripe will return the corresponding SKU information.
   */
  public static Sku retrieve(String id, SkuRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Sku.class, options);
  }

  /**
   * Returns a list of your SKUs. The SKUs are returned sorted by creation date, with the most
   * recently created SKUs appearing first.
   */
  public static SkuCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your SKUs. The SKUs are returned sorted by creation date, with the most
   * recently created SKUs appearing first.
   */
  public static SkuCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
    return ApiResource.requestCollection(url, params, SkuCollection.class, options);
  }

  /**
   * Returns a list of your SKUs. The SKUs are returned sorted by creation date, with the most
   * recently created SKUs appearing first.
   */
  public static SkuCollection list(SkuListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your SKUs. The SKUs are returned sorted by creation date, with the most
   * recently created SKUs appearing first.
   */
  public static SkuCollection list(SkuListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
    return ApiResource.requestCollection(url, params, SkuCollection.class, options);
  }

  /**
   * Updates the specific SKU by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>Note that a SKU’s <code>attributes</code> are not editable. Instead, you would need to
   * deactivate the existing SKU and create a new one with the new attribute values.
   */
  @Override
  public Sku update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific SKU by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>Note that a SKU’s <code>attributes</code> are not editable. Instead, you would need to
   * deactivate the existing SKU and create a new one with the new attribute values.
   */
  @Override
  public Sku update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
  }

  /**
   * Updates the specific SKU by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>Note that a SKU’s <code>attributes</code> are not editable. Instead, you would need to
   * deactivate the existing SKU and create a new one with the new attribute values.
   */
  public Sku update(SkuUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific SKU by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>Note that a SKU’s <code>attributes</code> are not editable. Instead, you would need to
   * deactivate the existing SKU and create a new one with the new attribute values.
   */
  public Sku update(SkuUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
  }

  /**
   * Creates a new SKU associated with a product.
   */
  public static Sku create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new SKU associated with a product.
   */
  public static Sku create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
  }

  /**
   * Creates a new SKU associated with a product.
   */
  public static Sku create(SkuCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new SKU associated with a product.
   */
  public static Sku create(SkuCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
  }

  /**
   * Delete a SKU. Deleting a SKU is only possible until it has been used in an order.
   */
  public Sku delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Delete a SKU. Deleting a SKU is only possible until it has been used in an order.
   */
  public Sku delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Delete a SKU. Deleting a SKU is only possible until it has been used in an order.
   */
  public Sku delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Delete a SKU. Deleting a SKU is only possible until it has been used in an order.
   */
  public Sku delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Sku.class, options);
  }


  public static class Inventory extends StripeObject {
    /** The count of inventory available. Will be present if and only if `type` is `finite`. */
    @SerializedName("quantity")
    Long quantity;
    /** Inventory type. Possible values are `finite`, `bucket` (not quantified), and `infinite`. */
    @SerializedName("type")
    String type;
    /**
     * An indicator of the inventory available. Possible values are `in_stock`, `limited`, and
     * `out_of_stock`. Will be present if and only if `type` is `bucket`.
     */
    @SerializedName("value")
    String value;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuantity() {
      return this.quantity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQuantity(final Long quantity) {
      this.quantity = quantity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
      this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Sku.Inventory)) return false;
      final Sku.Inventory other = (Sku.Inventory) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$quantity = this.getQuantity();
      final java.lang.Object other$quantity = other.getQuantity();
      if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$value = this.getValue();
      final java.lang.Object other$value = other.getValue();
      if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Sku.Inventory;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $quantity = this.getQuantity();
      result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $value = this.getValue();
      result = result * PRIME + ($value == null ? 43 : $value.hashCode());
      return result;
    }
  }

  /**
   * Whether the SKU is available for purchase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  /**
   * A dictionary of attributes and values for the attributes defined by the product. If, for
   * example, a product's attributes are `["size", "gender"]`, a valid SKU has the following
   * dictionary of attributes: `{"size": "Medium", "gender": "Unisex"}`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getAttributes() {
    return this.attributes;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * The URL of an image for this SKU, meant to be displayable to the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getImage() {
    return this.image;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Inventory getInventory() {
    return this.inventory;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `sku`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The dimensions of this SKU for shipping purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PackageDimensions getPackageDimensions() {
    return this.packageDimensions;
  }

  /**
   * The cost of the item as a positive integer in the smallest currency unit (that is, 100 cents to
   * charge $1.00, or 100 to charge ¥100, Japanese Yen being a zero-decimal currency).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPrice() {
    return this.price;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUpdated() {
    return this.updated;
  }

  /**
   * Whether the SKU is available for purchase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  /**
   * A dictionary of attributes and values for the attributes defined by the product. If, for
   * example, a product's attributes are `["size", "gender"]`, a valid SKU has the following
   * dictionary of attributes: `{"size": "Medium", "gender": "Unisex"}`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAttributes(final Map<String, String> attributes) {
    this.attributes = attributes;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The URL of an image for this SKU, meant to be displayable to the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setImage(final String image) {
    this.image = image;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInventory(final Inventory inventory) {
    this.inventory = inventory;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to `sku`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The dimensions of this SKU for shipping purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPackageDimensions(final PackageDimensions packageDimensions) {
    this.packageDimensions = packageDimensions;
  }

  /**
   * The cost of the item as a positive integer in the smallest currency unit (that is, 100 cents to
   * charge $1.00, or 100 to charge ¥100, Japanese Yen being a zero-decimal currency).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrice(final Long price) {
    this.price = price;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpdated(final Long updated) {
    this.updated = updated;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Sku)) return false;
    final Sku other = (Sku) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$attributes = this.getAttributes();
    final java.lang.Object other$attributes = other.getAttributes();
    if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$image = this.getImage();
    final java.lang.Object other$image = other.getImage();
    if (this$image == null ? other$image != null : !this$image.equals(other$image)) return false;
    final java.lang.Object this$inventory = this.getInventory();
    final java.lang.Object other$inventory = other.getInventory();
    if (this$inventory == null ? other$inventory != null : !this$inventory.equals(other$inventory)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$packageDimensions = this.getPackageDimensions();
    final java.lang.Object other$packageDimensions = other.getPackageDimensions();
    if (this$packageDimensions == null ? other$packageDimensions != null : !this$packageDimensions.equals(other$packageDimensions)) return false;
    final java.lang.Object this$price = this.getPrice();
    final java.lang.Object other$price = other.getPrice();
    if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
    final java.lang.Object this$product = this.getProduct();
    final java.lang.Object other$product = other.getProduct();
    if (this$product == null ? other$product != null : !this$product.equals(other$product)) return false;
    final java.lang.Object this$updated = this.getUpdated();
    final java.lang.Object other$updated = other.getUpdated();
    if (this$updated == null ? other$updated != null : !this$updated.equals(other$updated)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Sku;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $attributes = this.getAttributes();
    result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $image = this.getImage();
    result = result * PRIME + ($image == null ? 43 : $image.hashCode());
    final java.lang.Object $inventory = this.getInventory();
    result = result * PRIME + ($inventory == null ? 43 : $inventory.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $packageDimensions = this.getPackageDimensions();
    result = result * PRIME + ($packageDimensions == null ? 43 : $packageDimensions.hashCode());
    final java.lang.Object $price = this.getPrice();
    result = result * PRIME + ($price == null ? 43 : $price.hashCode());
    final java.lang.Object $product = this.getProduct();
    result = result * PRIME + ($product == null ? 43 : $product.hashCode());
    final java.lang.Object $updated = this.getUpdated();
    result = result * PRIME + ($updated == null ? 43 : $updated.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
