/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethodCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentMethodAttachParams;
import com.stripe.param.PaymentMethodCreateParams;
import com.stripe.param.PaymentMethodDetachParams;
import com.stripe.param.PaymentMethodListParams;
import com.stripe.param.PaymentMethodRetrieveParams;
import com.stripe.param.PaymentMethodUpdateParams;
import java.util.Map;
import lombok.Generated;

public class PaymentMethod
extends ApiResource
implements HasId,
MetadataStore<PaymentMethod> {
    @SerializedName(value="au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName(value="billing_details")
    BillingDetails billingDetails;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="card_present")
    CardPresent cardPresent;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ideal")
    Ideal ideal;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName(value="type")
    String type;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static PaymentMethod create(Map<String, Object> params) throws StripeException {
        return PaymentMethod.create(params, (RequestOptions)null);
    }

    public static PaymentMethod create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod create(PaymentMethodCreateParams params) throws StripeException {
        return PaymentMethod.create(params, (RequestOptions)null);
    }

    public static PaymentMethod create(PaymentMethodCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod retrieve(String paymentMethod) throws StripeException {
        return PaymentMethod.retrieve(paymentMethod, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentMethod retrieve(String paymentMethod, RequestOptions options) throws StripeException {
        return PaymentMethod.retrieve(paymentMethod, (Map<String, Object>)null, options);
    }

    public static PaymentMethod retrieve(String paymentMethod, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod retrieve(String paymentMethod, PaymentMethodRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentMethod update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod update(PaymentMethodUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethod update(PaymentMethodUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethodCollection list(Map<String, Object> params) throws StripeException {
        return PaymentMethod.list(params, (RequestOptions)null);
    }

    public static PaymentMethodCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public static PaymentMethodCollection list(PaymentMethodListParams params) throws StripeException {
        return PaymentMethod.list(params, (RequestOptions)null);
    }

    public static PaymentMethodCollection list(PaymentMethodListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public PaymentMethod attach(Map<String, Object> params) throws StripeException {
        return this.attach(params, (RequestOptions)null);
    }

    public PaymentMethod attach(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod attach(PaymentMethodAttachParams params) throws StripeException {
        return this.attach(params, (RequestOptions)null);
    }

    public PaymentMethod attach(PaymentMethodAttachParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod detach() throws StripeException {
        return this.detach((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentMethod detach(RequestOptions options) throws StripeException {
        return this.detach((Map<String, Object>)null, options);
    }

    public PaymentMethod detach(Map<String, Object> params) throws StripeException {
        return this.detach(params, (RequestOptions)null);
    }

    public PaymentMethod detach(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod detach(PaymentMethodDetachParams params) throws StripeException {
        return this.detach(params, (RequestOptions)null);
    }

    public PaymentMethod detach(PaymentMethodDetachParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    @Generated
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    @Generated
    public BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public CardPresent getCardPresent() {
        return this.cardPresent;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Ideal getIdeal() {
        return this.ideal;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    @Generated
    public void setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCardPresent(CardPresent cardPresent) {
        this.cardPresent = cardPresent;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdeal(Ideal ideal) {
        this.ideal = ideal;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethod)) {
            return false;
        }
        PaymentMethod other = (PaymentMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
        AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
        if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
            return false;
        }
        BillingDetails this$billingDetails = this.getBillingDetails();
        BillingDetails other$billingDetails = other.getBillingDetails();
        if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        CardPresent this$cardPresent = this.getCardPresent();
        CardPresent other$cardPresent = other.getCardPresent();
        if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Ideal this$ideal = this.getIdeal();
        Ideal other$ideal = other.getIdeal();
        if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        SepaDebit this$sepaDebit = this.getSepaDebit();
        SepaDebit other$sepaDebit = other.getSepaDebit();
        if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
        result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
        BillingDetails $billingDetails = this.getBillingDetails();
        result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        CardPresent $cardPresent = this.getCardPresent();
        result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Ideal $ideal = this.getIdeal();
        result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        SepaDebit $sepaDebit = this.getSepaDebit();
        result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="bsb_number")
        String bsbNumber;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;

        @Generated
        public String getBsbNumber() {
            return this.bsbNumber;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public void setBsbNumber(String bsbNumber) {
            this.bsbNumber = bsbNumber;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bsbNumber = this.getBsbNumber();
            String other$bsbNumber = other.getBsbNumber();
            if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bsbNumber = this.getBsbNumber();
            result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            return result;
        }
    }

    public static class BillingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingDetails)) {
                return false;
            }
            BillingDetails other = (BillingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class Card
    extends StripeObject {
        @SerializedName(value="brand")
        String brand;
        @SerializedName(value="checks")
        Checks checks;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="funding")
        String funding;
        @SerializedName(value="iin")
        String iin;
        @SerializedName(value="issuer")
        String issuer;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="three_d_secure_usage")
        ThreeDSecureUsage threeDSecureUsage;
        @SerializedName(value="wallet")
        Wallet wallet;

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public Checks getChecks() {
            return this.checks;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Long getExpMonth() {
            return this.expMonth;
        }

        @Generated
        public Long getExpYear() {
            return this.expYear;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getFunding() {
            return this.funding;
        }

        @Generated
        public String getIin() {
            return this.iin;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public ThreeDSecureUsage getThreeDSecureUsage() {
            return this.threeDSecureUsage;
        }

        @Generated
        public Wallet getWallet() {
            return this.wallet;
        }

        @Generated
        public void setBrand(String brand) {
            this.brand = brand;
        }

        @Generated
        public void setChecks(Checks checks) {
            this.checks = checks;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setExpMonth(Long expMonth) {
            this.expMonth = expMonth;
        }

        @Generated
        public void setExpYear(Long expYear) {
            this.expYear = expYear;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setFunding(String funding) {
            this.funding = funding;
        }

        @Generated
        public void setIin(String iin) {
            this.iin = iin;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setThreeDSecureUsage(ThreeDSecureUsage threeDSecureUsage) {
            this.threeDSecureUsage = threeDSecureUsage;
        }

        @Generated
        public void setWallet(Wallet wallet) {
            this.wallet = wallet;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            Checks this$checks = this.getChecks();
            Checks other$checks = other.getChecks();
            if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Long this$expMonth = this.getExpMonth();
            Long other$expMonth = other.getExpMonth();
            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                return false;
            }
            Long this$expYear = this.getExpYear();
            Long other$expYear = other.getExpYear();
            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$funding = this.getFunding();
            String other$funding = other.getFunding();
            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                return false;
            }
            String this$iin = this.getIin();
            String other$iin = other.getIin();
            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            ThreeDSecureUsage this$threeDSecureUsage = this.getThreeDSecureUsage();
            ThreeDSecureUsage other$threeDSecureUsage = other.getThreeDSecureUsage();
            if (this$threeDSecureUsage == null ? other$threeDSecureUsage != null : !((Object)this$threeDSecureUsage).equals(other$threeDSecureUsage)) {
                return false;
            }
            Wallet this$wallet = this.getWallet();
            Wallet other$wallet = other.getWallet();
            return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Card;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            Checks $checks = this.getChecks();
            result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Long $expMonth = this.getExpMonth();
            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
            Long $expYear = this.getExpYear();
            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $funding = this.getFunding();
            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
            String $iin = this.getIin();
            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            ThreeDSecureUsage $threeDSecureUsage = this.getThreeDSecureUsage();
            result = result * 59 + ($threeDSecureUsage == null ? 43 : ((Object)$threeDSecureUsage).hashCode());
            Wallet $wallet = this.getWallet();
            result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
            return result;
        }

        public static class Checks
        extends StripeObject {
            @SerializedName(value="address_line1_check")
            String addressLine1Check;
            @SerializedName(value="address_postal_code_check")
            String addressPostalCodeCheck;
            @SerializedName(value="cvc_check")
            String cvcCheck;

            @Generated
            public String getAddressLine1Check() {
                return this.addressLine1Check;
            }

            @Generated
            public String getAddressPostalCodeCheck() {
                return this.addressPostalCodeCheck;
            }

            @Generated
            public String getCvcCheck() {
                return this.cvcCheck;
            }

            @Generated
            public void setAddressLine1Check(String addressLine1Check) {
                this.addressLine1Check = addressLine1Check;
            }

            @Generated
            public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                this.addressPostalCodeCheck = addressPostalCodeCheck;
            }

            @Generated
            public void setCvcCheck(String cvcCheck) {
                this.cvcCheck = cvcCheck;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Checks)) {
                    return false;
                }
                Checks other = (Checks)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$addressLine1Check = this.getAddressLine1Check();
                String other$addressLine1Check = other.getAddressLine1Check();
                if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                    return false;
                }
                String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                    return false;
                }
                String this$cvcCheck = this.getCvcCheck();
                String other$cvcCheck = other.getCvcCheck();
                return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Checks;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $addressLine1Check = this.getAddressLine1Check();
                result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                String $cvcCheck = this.getCvcCheck();
                result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                return result;
            }
        }

        public static class ThreeDSecureUsage
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ThreeDSecureUsage)) {
                    return false;
                }
                ThreeDSecureUsage other = (ThreeDSecureUsage)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ThreeDSecureUsage;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }

        public static class Wallet
        extends StripeObject {
            @SerializedName(value="amex_express_checkout")
            AmexExpressCheckout amexExpressCheckout;
            @SerializedName(value="apple_pay")
            ApplePay applePay;
            @SerializedName(value="dynamic_last4")
            String dynamicLast4;
            @SerializedName(value="google_pay")
            GooglePay googlePay;
            @SerializedName(value="masterpass")
            Masterpass masterpass;
            @SerializedName(value="samsung_pay")
            SamsungPay samsungPay;
            @SerializedName(value="type")
            String type;
            @SerializedName(value="visa_checkout")
            VisaCheckout visaCheckout;

            @Generated
            public AmexExpressCheckout getAmexExpressCheckout() {
                return this.amexExpressCheckout;
            }

            @Generated
            public ApplePay getApplePay() {
                return this.applePay;
            }

            @Generated
            public String getDynamicLast4() {
                return this.dynamicLast4;
            }

            @Generated
            public GooglePay getGooglePay() {
                return this.googlePay;
            }

            @Generated
            public Masterpass getMasterpass() {
                return this.masterpass;
            }

            @Generated
            public SamsungPay getSamsungPay() {
                return this.samsungPay;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public VisaCheckout getVisaCheckout() {
                return this.visaCheckout;
            }

            @Generated
            public void setAmexExpressCheckout(AmexExpressCheckout amexExpressCheckout) {
                this.amexExpressCheckout = amexExpressCheckout;
            }

            @Generated
            public void setApplePay(ApplePay applePay) {
                this.applePay = applePay;
            }

            @Generated
            public void setDynamicLast4(String dynamicLast4) {
                this.dynamicLast4 = dynamicLast4;
            }

            @Generated
            public void setGooglePay(GooglePay googlePay) {
                this.googlePay = googlePay;
            }

            @Generated
            public void setMasterpass(Masterpass masterpass) {
                this.masterpass = masterpass;
            }

            @Generated
            public void setSamsungPay(SamsungPay samsungPay) {
                this.samsungPay = samsungPay;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setVisaCheckout(VisaCheckout visaCheckout) {
                this.visaCheckout = visaCheckout;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Wallet)) {
                    return false;
                }
                Wallet other = (Wallet)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AmexExpressCheckout this$amexExpressCheckout = this.getAmexExpressCheckout();
                AmexExpressCheckout other$amexExpressCheckout = other.getAmexExpressCheckout();
                if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !((Object)this$amexExpressCheckout).equals(other$amexExpressCheckout)) {
                    return false;
                }
                ApplePay this$applePay = this.getApplePay();
                ApplePay other$applePay = other.getApplePay();
                if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                    return false;
                }
                String this$dynamicLast4 = this.getDynamicLast4();
                String other$dynamicLast4 = other.getDynamicLast4();
                if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                    return false;
                }
                GooglePay this$googlePay = this.getGooglePay();
                GooglePay other$googlePay = other.getGooglePay();
                if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                    return false;
                }
                Masterpass this$masterpass = this.getMasterpass();
                Masterpass other$masterpass = other.getMasterpass();
                if (this$masterpass == null ? other$masterpass != null : !((Object)this$masterpass).equals(other$masterpass)) {
                    return false;
                }
                SamsungPay this$samsungPay = this.getSamsungPay();
                SamsungPay other$samsungPay = other.getSamsungPay();
                if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                VisaCheckout this$visaCheckout = this.getVisaCheckout();
                VisaCheckout other$visaCheckout = other.getVisaCheckout();
                return !(this$visaCheckout == null ? other$visaCheckout != null : !((Object)this$visaCheckout).equals(other$visaCheckout));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Wallet;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AmexExpressCheckout $amexExpressCheckout = this.getAmexExpressCheckout();
                result = result * 59 + ($amexExpressCheckout == null ? 43 : ((Object)$amexExpressCheckout).hashCode());
                ApplePay $applePay = this.getApplePay();
                result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
                String $dynamicLast4 = this.getDynamicLast4();
                result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
                GooglePay $googlePay = this.getGooglePay();
                result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
                Masterpass $masterpass = this.getMasterpass();
                result = result * 59 + ($masterpass == null ? 43 : ((Object)$masterpass).hashCode());
                SamsungPay $samsungPay = this.getSamsungPay();
                result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                VisaCheckout $visaCheckout = this.getVisaCheckout();
                result = result * 59 + ($visaCheckout == null ? 43 : ((Object)$visaCheckout).hashCode());
                return result;
            }

            public static class AmexExpressCheckout
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AmexExpressCheckout)) {
                        return false;
                    }
                    AmexExpressCheckout other = (AmexExpressCheckout)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AmexExpressCheckout;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class ApplePay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ApplePay)) {
                        return false;
                    }
                    ApplePay other = (ApplePay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ApplePay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class GooglePay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GooglePay)) {
                        return false;
                    }
                    GooglePay other = (GooglePay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof GooglePay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class Masterpass
            extends StripeObject {
                @SerializedName(value="billing_address")
                Address billingAddress;
                @SerializedName(value="email")
                String email;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="shipping_address")
                Address shippingAddress;

                @Generated
                public Address getBillingAddress() {
                    return this.billingAddress;
                }

                @Generated
                public String getEmail() {
                    return this.email;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Address getShippingAddress() {
                    return this.shippingAddress;
                }

                @Generated
                public void setBillingAddress(Address billingAddress) {
                    this.billingAddress = billingAddress;
                }

                @Generated
                public void setEmail(String email) {
                    this.email = email;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setShippingAddress(Address shippingAddress) {
                    this.shippingAddress = shippingAddress;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Masterpass)) {
                        return false;
                    }
                    Masterpass other = (Masterpass)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Address this$billingAddress = this.getBillingAddress();
                    Address other$billingAddress = other.getBillingAddress();
                    if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                        return false;
                    }
                    String this$email = this.getEmail();
                    String other$email = other.getEmail();
                    if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Address this$shippingAddress = this.getShippingAddress();
                    Address other$shippingAddress = other.getShippingAddress();
                    return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Masterpass;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Address $billingAddress = this.getBillingAddress();
                    result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                    String $email = this.getEmail();
                    result = result * 59 + ($email == null ? 43 : $email.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Address $shippingAddress = this.getShippingAddress();
                    result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                    return result;
                }
            }

            public static class SamsungPay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SamsungPay)) {
                        return false;
                    }
                    SamsungPay other = (SamsungPay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SamsungPay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class VisaCheckout
            extends StripeObject {
                @SerializedName(value="billing_address")
                Address billingAddress;
                @SerializedName(value="email")
                String email;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="shipping_address")
                Address shippingAddress;

                @Generated
                public Address getBillingAddress() {
                    return this.billingAddress;
                }

                @Generated
                public String getEmail() {
                    return this.email;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Address getShippingAddress() {
                    return this.shippingAddress;
                }

                @Generated
                public void setBillingAddress(Address billingAddress) {
                    this.billingAddress = billingAddress;
                }

                @Generated
                public void setEmail(String email) {
                    this.email = email;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setShippingAddress(Address shippingAddress) {
                    this.shippingAddress = shippingAddress;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof VisaCheckout)) {
                        return false;
                    }
                    VisaCheckout other = (VisaCheckout)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Address this$billingAddress = this.getBillingAddress();
                    Address other$billingAddress = other.getBillingAddress();
                    if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                        return false;
                    }
                    String this$email = this.getEmail();
                    String other$email = other.getEmail();
                    if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Address this$shippingAddress = this.getShippingAddress();
                    Address other$shippingAddress = other.getShippingAddress();
                    return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof VisaCheckout;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Address $billingAddress = this.getBillingAddress();
                    result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                    String $email = this.getEmail();
                    result = result * 59 + ($email == null ? 43 : $email.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Address $shippingAddress = this.getShippingAddress();
                    result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                    return result;
                }
            }
        }
    }

    public static class CardPresent
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CardPresent)) {
                return false;
            }
            CardPresent other = (CardPresent)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CardPresent;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Ideal
    extends StripeObject {
        @SerializedName(value="bank")
        String bank;
        @SerializedName(value="bic")
        String bic;

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ideal)) {
                return false;
            }
            Ideal other = (Ideal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            return !(this$bic == null ? other$bic != null : !this$bic.equals(other$bic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ideal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            return result;
        }
    }

    public static class SepaDebit
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="branch_code")
        String branchCode;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBranchCode() {
            return this.branchCode;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBranchCode(String branchCode) {
            this.branchCode = branchCode;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaDebit)) {
                return false;
            }
            SepaDebit other = (SepaDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$branchCode = this.getBranchCode();
            String other$branchCode = other.getBranchCode();
            if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $branchCode = this.getBranchCode();
            result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            return result;
        }
    }
}

