/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.net.ApiResource;
import com.stripe.net.FormEncoder;
import com.stripe.net.KeyValuePair;
import com.stripe.net.MultipartProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public final class HttpContent {
    private final byte[] byteArrayContent;
    private final String contentType;

    private HttpContent(byte[] byteArrayContent, String contentType) {
        this.byteArrayContent = byteArrayContent;
        this.contentType = contentType;
    }

    public static HttpContent buildFormURLEncodedContent(Collection<KeyValuePair<String, String>> nameValueCollection) throws IOException {
        Objects.requireNonNull(nameValueCollection);
        return new HttpContent(FormEncoder.createQueryString(nameValueCollection).getBytes(ApiResource.CHARSET), String.format("application/x-www-form-urlencoded;charset=%s", ApiResource.CHARSET));
    }

    public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection) throws IOException {
        String boundary = UUID.randomUUID().toString();
        return HttpContent.buildMultipartFormDataContent(nameValueCollection, boundary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection, String boundary) throws IOException {
        Objects.requireNonNull(nameValueCollection);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultipartProcessor multipartProcessor = null;
        try {
            multipartProcessor = new MultipartProcessor(baos, boundary, ApiResource.CHARSET);
            for (KeyValuePair<String, Object> entry : nameValueCollection) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    File file = (File)value;
                    multipartProcessor.addFileField(key, file.getName(), new FileInputStream(file));
                    continue;
                }
                if (value instanceof InputStream) {
                    multipartProcessor.addFileField(key, "blob", (InputStream)value);
                    continue;
                }
                multipartProcessor.addFormField(key, (String)value);
            }
        }
        finally {
            if (multipartProcessor != null) {
                multipartProcessor.finish();
            }
        }
        return new HttpContent(baos.toByteArray(), String.format("multipart/form-data; boundary=%s", boundary));
    }

    @Generated
    public byte[] byteArrayContent() {
        return this.byteArrayContent;
    }

    @Generated
    public String contentType() {
        return this.contentType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpContent)) {
            return false;
        }
        HttpContent other = (HttpContent)o;
        if (!Arrays.equals(this.byteArrayContent(), other.byteArrayContent())) {
            return false;
        }
        String this$contentType = this.contentType();
        String other$contentType = other.contentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.byteArrayContent());
        String $contentType = this.contentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpContent(byteArrayContent=" + Arrays.toString(this.byteArrayContent()) + ", contentType=" + this.contentType() + ")";
    }
}

