/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.TransferCollection;
import com.stripe.model.TransferReversalCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TransferCreateParams;
import com.stripe.param.TransferListParams;
import com.stripe.param.TransferRetrieveParams;
import com.stripe.param.TransferUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Transfer
extends ApiResource
implements MetadataStore<Transfer>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_reversed")
    Long amountReversed;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination")
    ExpandableField<Account> destination;
    @SerializedName(value="destination_payment")
    ExpandableField<Charge> destinationPayment;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reversals")
    TransferReversalCollection reversals;
    @SerializedName(value="reversed")
    Boolean reversed;
    @SerializedName(value="source_transaction")
    ExpandableField<Charge> sourceTransaction;
    @SerializedName(value="source_type")
    String sourceType;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
        this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
        this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getDestinationPayment() {
        return this.destinationPayment != null ? this.destinationPayment.getId() : null;
    }

    public void setDestinationPayment(String id) {
        this.destinationPayment = ApiResource.setExpandableFieldId(id, this.destinationPayment);
    }

    public Charge getDestinationPaymentObject() {
        return this.destinationPayment != null ? this.destinationPayment.getExpanded() : null;
    }

    public void setDestinationPaymentObject(Charge expandableObject) {
        this.destinationPayment = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getSourceTransaction() {
        return this.sourceTransaction != null ? this.sourceTransaction.getId() : null;
    }

    public void setSourceTransaction(String id) {
        this.sourceTransaction = ApiResource.setExpandableFieldId(id, this.sourceTransaction);
    }

    public Charge getSourceTransactionObject() {
        return this.sourceTransaction != null ? this.sourceTransaction.getExpanded() : null;
    }

    public void setSourceTransactionObject(Charge expandableObject) {
        this.sourceTransaction = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public static Transfer create(Map<String, Object> params) throws StripeException {
        return Transfer.create(params, (RequestOptions)null);
    }

    public static Transfer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/transfers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transfer.class, options);
    }

    public static Transfer create(TransferCreateParams params) throws StripeException {
        return Transfer.create(params, (RequestOptions)null);
    }

    public static Transfer create(TransferCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/transfers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transfer.class, options);
    }

    public static TransferCollection list(Map<String, Object> params) throws StripeException {
        return Transfer.list(params, (RequestOptions)null);
    }

    public static TransferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/transfers");
        return ApiResource.requestCollection(url, params, TransferCollection.class, options);
    }

    public static TransferCollection list(TransferListParams params) throws StripeException {
        return Transfer.list(params, (RequestOptions)null);
    }

    public static TransferCollection list(TransferListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/transfers");
        return ApiResource.requestCollection(url, params, TransferCollection.class, options);
    }

    public static Transfer retrieve(String transfer) throws StripeException {
        return Transfer.retrieve(transfer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transfer retrieve(String transfer, RequestOptions options) throws StripeException {
        return Transfer.retrieve(transfer, (Map<String, Object>)null, options);
    }

    public static Transfer retrieve(String transfer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s", ApiResource.urlEncodeId(transfer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transfer.class, options);
    }

    public static Transfer retrieve(String transfer, TransferRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s", ApiResource.urlEncodeId(transfer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transfer.class, options);
    }

    public Transfer update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transfer update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transfer.class, options);
    }

    public Transfer update(TransferUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Transfer update(TransferUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transfer.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountReversed() {
        return this.amountReversed;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public TransferReversalCollection getReversals() {
        return this.reversals;
    }

    @Generated
    public Boolean getReversed() {
        return this.reversed;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountReversed(Long amountReversed) {
        this.amountReversed = amountReversed;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReversals(TransferReversalCollection reversals) {
        this.reversals = reversals;
    }

    @Generated
    public void setReversed(Boolean reversed) {
        this.reversed = reversed;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transfer)) {
            return false;
        }
        Transfer other = (Transfer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountReversed = this.getAmountReversed();
        Long other$amountReversed = other.getAmountReversed();
        if (this$amountReversed == null ? other$amountReversed != null : !((Object)this$amountReversed).equals(other$amountReversed)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$destinationPayment = this.getDestinationPayment();
        String other$destinationPayment = other.getDestinationPayment();
        if (this$destinationPayment == null ? other$destinationPayment != null : !this$destinationPayment.equals(other$destinationPayment)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        TransferReversalCollection this$reversals = this.getReversals();
        TransferReversalCollection other$reversals = other.getReversals();
        if (this$reversals == null ? other$reversals != null : !((Object)this$reversals).equals(other$reversals)) {
            return false;
        }
        Boolean this$reversed = this.getReversed();
        Boolean other$reversed = other.getReversed();
        if (this$reversed == null ? other$reversed != null : !((Object)this$reversed).equals(other$reversed)) {
            return false;
        }
        String this$sourceTransaction = this.getSourceTransaction();
        String other$sourceTransaction = other.getSourceTransaction();
        if (this$sourceTransaction == null ? other$sourceTransaction != null : !this$sourceTransaction.equals(other$sourceTransaction)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transfer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountReversed = this.getAmountReversed();
        result = result * 59 + ($amountReversed == null ? 43 : ((Object)$amountReversed).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $destinationPayment = this.getDestinationPayment();
        result = result * 59 + ($destinationPayment == null ? 43 : $destinationPayment.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        TransferReversalCollection $reversals = this.getReversals();
        result = result * 59 + ($reversals == null ? 43 : ((Object)$reversals).hashCode());
        Boolean $reversed = this.getReversed();
        result = result * 59 + ($reversed == null ? 43 : ((Object)$reversed).hashCode());
        String $sourceTransaction = this.getSourceTransaction();
        result = result * 59 + ($sourceTransaction == null ? 43 : $sourceTransaction.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

