// Generated by delombok at Fri Feb 21 14:34:12 PST 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CouponCreateParams;
import com.stripe.param.CouponListParams;
import com.stripe.param.CouponRetrieveParams;
import com.stripe.param.CouponUpdateParams;
import java.math.BigDecimal;
import java.util.Map;

public class Coupon extends ApiResource implements HasId, MetadataStore<Coupon> {
  /**
   * Amount (in the {@code currency} specified) that will be taken off the subtotal of any invoices
   * for this customer.
   */
  @SerializedName("amount_off")
  Long amountOff;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * If {@code amount_off} has been set, the three-letter <a
   * href="https://stripe.com/docs/currencies">ISO code for the currency</a> of the amount to take
   * off.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * One of {@code forever}, {@code once}, and {@code repeating}. Describes how long a customer who
   * applies this coupon will get the discount.
   */
  @SerializedName("duration")
  String duration;
  /**
   * If {@code duration} is {@code repeating}, the number of months the coupon applies. Null if
   * coupon {@code duration} is {@code forever} or {@code once}.
   */
  @SerializedName("duration_in_months")
  Long durationInMonths;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Maximum number of times this coupon can be redeemed, in total, across all customers, before it
   * is no longer valid.
   */
  @SerializedName("max_redemptions")
  Long maxRedemptions;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * Name of the coupon displayed to customers on for instance invoices or receipts.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code coupon}.
   */
  @SerializedName("object")
  String object;
  /**
   * Percent that will be taken off the subtotal of any invoices for this customer for the duration
   * of the coupon. For example, a coupon with percent_off of 50 will make a %s100 invoice %s50
   * instead.
   */
  @SerializedName("percent_off")
  BigDecimal percentOff;
  /**
   * Date after which the coupon can no longer be redeemed.
   */
  @SerializedName("redeem_by")
  Long redeemBy;
  /**
   * Number of times this coupon has been applied to a customer.
   */
  @SerializedName("times_redeemed")
  Long timesRedeemed;
  /**
   * Taking account of the above properties, whether this coupon can still be applied to a customer.
   */
  @SerializedName("valid")
  Boolean valid;

  /**
   * Returns a list of your coupons.
   */
  public static CouponCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your coupons.
   */
  public static CouponCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/coupons");
    return ApiResource.requestCollection(url, params, CouponCollection.class, options);
  }

  /**
   * Returns a list of your coupons.
   */
  public static CouponCollection list(CouponListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your coupons.
   */
  public static CouponCollection list(CouponListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/coupons");
    return ApiResource.requestCollection(url, params, CouponCollection.class, options);
  }

  /**
   * You can create coupons easily via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. Coupon creation is also accessible via the API if
   * you need to create coupons on the fly.
   *
   * <p>A coupon has either a <code>percent_off</code> or an <code>amount_off</code> and <code>
   * currency</code>. If you set an <code>amount_off</code>, that amount will be subtracted from any
   * invoice’s subtotal. For example, an invoice with a subtotal of 100 will have a final total of 0
   * if a coupon with an <code>amount_off</code> of 200 is applied to it and an invoice with a
   * subtotal of 300 will have a final total of 100 if a coupon with an <code>amount_off</code> of
   * 200 is applied to it.
   */
  public static Coupon create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * You can create coupons easily via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. Coupon creation is also accessible via the API if
   * you need to create coupons on the fly.
   *
   * <p>A coupon has either a <code>percent_off</code> or an <code>amount_off</code> and <code>
   * currency</code>. If you set an <code>amount_off</code>, that amount will be subtracted from any
   * invoice’s subtotal. For example, an invoice with a subtotal of 100 will have a final total of 0
   * if a coupon with an <code>amount_off</code> of 200 is applied to it and an invoice with a
   * subtotal of 300 will have a final total of 100 if a coupon with an <code>amount_off</code> of
   * 200 is applied to it.
   */
  public static Coupon create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/coupons");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Coupon.class, options);
  }

  /**
   * You can create coupons easily via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. Coupon creation is also accessible via the API if
   * you need to create coupons on the fly.
   *
   * <p>A coupon has either a <code>percent_off</code> or an <code>amount_off</code> and <code>
   * currency</code>. If you set an <code>amount_off</code>, that amount will be subtracted from any
   * invoice’s subtotal. For example, an invoice with a subtotal of 100 will have a final total of 0
   * if a coupon with an <code>amount_off</code> of 200 is applied to it and an invoice with a
   * subtotal of 300 will have a final total of 100 if a coupon with an <code>amount_off</code> of
   * 200 is applied to it.
   */
  public static Coupon create(CouponCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * You can create coupons easily via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. Coupon creation is also accessible via the API if
   * you need to create coupons on the fly.
   *
   * <p>A coupon has either a <code>percent_off</code> or an <code>amount_off</code> and <code>
   * currency</code>. If you set an <code>amount_off</code>, that amount will be subtracted from any
   * invoice’s subtotal. For example, an invoice with a subtotal of 100 will have a final total of 0
   * if a coupon with an <code>amount_off</code> of 200 is applied to it and an invoice with a
   * subtotal of 300 will have a final total of 100 if a coupon with an <code>amount_off</code> of
   * 200 is applied to it.
   */
  public static Coupon create(CouponCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/coupons");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Coupon.class, options);
  }

  /**
   * Retrieves the coupon with the given ID.
   */
  public static Coupon retrieve(String coupon) throws StripeException {
    return retrieve(coupon, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the coupon with the given ID.
   */
  public static Coupon retrieve(String coupon, RequestOptions options) throws StripeException {
    return retrieve(coupon, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the coupon with the given ID.
   */
  public static Coupon retrieve(String coupon, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Coupon.class, options);
  }

  /**
   * Retrieves the coupon with the given ID.
   */
  public static Coupon retrieve(String coupon, CouponRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Coupon.class, options);
  }

  /**
   * Updates the metadata of a coupon. Other coupon details (currency, duration, amount_off) are, by
   * design, not editable.
   */
  @Override
  public Coupon update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the metadata of a coupon. Other coupon details (currency, duration, amount_off) are, by
   * design, not editable.
   */
  @Override
  public Coupon update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Coupon.class, options);
  }

  /**
   * Updates the metadata of a coupon. Other coupon details (currency, duration, amount_off) are, by
   * design, not editable.
   */
  public Coupon update(CouponUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the metadata of a coupon. Other coupon details (currency, duration, amount_off) are, by
   * design, not editable.
   */
  public Coupon update(CouponUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Coupon.class, options);
  }

  /**
   * You can delete coupons via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. However, deleting a coupon does not affect any
   * customers who have already applied the coupon; it means that new customers can’t redeem the
   * coupon. You can also delete coupons via the API.
   */
  public Coupon delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * You can delete coupons via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. However, deleting a coupon does not affect any
   * customers who have already applied the coupon; it means that new customers can’t redeem the
   * coupon. You can also delete coupons via the API.
   */
  public Coupon delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * You can delete coupons via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. However, deleting a coupon does not affect any
   * customers who have already applied the coupon; it means that new customers can’t redeem the
   * coupon. You can also delete coupons via the API.
   */
  public Coupon delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * You can delete coupons via the <a href="https://dashboard.stripe.com/coupons">coupon
   * management</a> page of the Stripe dashboard. However, deleting a coupon does not affect any
   * customers who have already applied the coupon; it means that new customers can’t redeem the
   * coupon. You can also delete coupons via the API.
   */
  public Coupon delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Coupon.class, options);
  }

  /**
   * Amount (in the {@code currency} specified) that will be taken off the subtotal of any invoices
   * for this customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountOff() {
    return this.amountOff;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * If {@code amount_off} has been set, the three-letter <a
   * href="https://stripe.com/docs/currencies">ISO code for the currency</a> of the amount to take
   * off.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * One of {@code forever}, {@code once}, and {@code repeating}. Describes how long a customer who
   * applies this coupon will get the discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDuration() {
    return this.duration;
  }

  /**
   * If {@code duration} is {@code repeating}, the number of months the coupon applies. Null if
   * coupon {@code duration} is {@code forever} or {@code once}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDurationInMonths() {
    return this.durationInMonths;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Maximum number of times this coupon can be redeemed, in total, across all customers, before it
   * is no longer valid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getMaxRedemptions() {
    return this.maxRedemptions;
  }

  /**
   * Name of the coupon displayed to customers on for instance invoices or receipts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code coupon}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Percent that will be taken off the subtotal of any invoices for this customer for the duration
   * of the coupon. For example, a coupon with percent_off of 50 will make a %s100 invoice %s50
   * instead.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPercentOff() {
    return this.percentOff;
  }

  /**
   * Date after which the coupon can no longer be redeemed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getRedeemBy() {
    return this.redeemBy;
  }

  /**
   * Number of times this coupon has been applied to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTimesRedeemed() {
    return this.timesRedeemed;
  }

  /**
   * Taking account of the above properties, whether this coupon can still be applied to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getValid() {
    return this.valid;
  }

  /**
   * Amount (in the {@code currency} specified) that will be taken off the subtotal of any invoices
   * for this customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountOff(final Long amountOff) {
    this.amountOff = amountOff;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * If {@code amount_off} has been set, the three-letter <a
   * href="https://stripe.com/docs/currencies">ISO code for the currency</a> of the amount to take
   * off.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * One of {@code forever}, {@code once}, and {@code repeating}. Describes how long a customer who
   * applies this coupon will get the discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDuration(final String duration) {
    this.duration = duration;
  }

  /**
   * If {@code duration} is {@code repeating}, the number of months the coupon applies. Null if
   * coupon {@code duration} is {@code forever} or {@code once}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDurationInMonths(final Long durationInMonths) {
    this.durationInMonths = durationInMonths;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Maximum number of times this coupon can be redeemed, in total, across all customers, before it
   * is no longer valid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMaxRedemptions(final Long maxRedemptions) {
    this.maxRedemptions = maxRedemptions;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * Name of the coupon displayed to customers on for instance invoices or receipts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code coupon}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Percent that will be taken off the subtotal of any invoices for this customer for the duration
   * of the coupon. For example, a coupon with percent_off of 50 will make a %s100 invoice %s50
   * instead.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPercentOff(final BigDecimal percentOff) {
    this.percentOff = percentOff;
  }

  /**
   * Date after which the coupon can no longer be redeemed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRedeemBy(final Long redeemBy) {
    this.redeemBy = redeemBy;
  }

  /**
   * Number of times this coupon has been applied to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTimesRedeemed(final Long timesRedeemed) {
    this.timesRedeemed = timesRedeemed;
  }

  /**
   * Taking account of the above properties, whether this coupon can still be applied to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValid(final Boolean valid) {
    this.valid = valid;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Coupon)) return false;
    final Coupon other = (Coupon) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amountOff = this.getAmountOff();
    final java.lang.Object other$amountOff = other.getAmountOff();
    if (this$amountOff == null ? other$amountOff != null : !this$amountOff.equals(other$amountOff)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$duration = this.getDuration();
    final java.lang.Object other$duration = other.getDuration();
    if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) return false;
    final java.lang.Object this$durationInMonths = this.getDurationInMonths();
    final java.lang.Object other$durationInMonths = other.getDurationInMonths();
    if (this$durationInMonths == null ? other$durationInMonths != null : !this$durationInMonths.equals(other$durationInMonths)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$maxRedemptions = this.getMaxRedemptions();
    final java.lang.Object other$maxRedemptions = other.getMaxRedemptions();
    if (this$maxRedemptions == null ? other$maxRedemptions != null : !this$maxRedemptions.equals(other$maxRedemptions)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$percentOff = this.getPercentOff();
    final java.lang.Object other$percentOff = other.getPercentOff();
    if (this$percentOff == null ? other$percentOff != null : !this$percentOff.equals(other$percentOff)) return false;
    final java.lang.Object this$redeemBy = this.getRedeemBy();
    final java.lang.Object other$redeemBy = other.getRedeemBy();
    if (this$redeemBy == null ? other$redeemBy != null : !this$redeemBy.equals(other$redeemBy)) return false;
    final java.lang.Object this$timesRedeemed = this.getTimesRedeemed();
    final java.lang.Object other$timesRedeemed = other.getTimesRedeemed();
    if (this$timesRedeemed == null ? other$timesRedeemed != null : !this$timesRedeemed.equals(other$timesRedeemed)) return false;
    final java.lang.Object this$valid = this.getValid();
    final java.lang.Object other$valid = other.getValid();
    if (this$valid == null ? other$valid != null : !this$valid.equals(other$valid)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Coupon;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amountOff = this.getAmountOff();
    result = result * PRIME + ($amountOff == null ? 43 : $amountOff.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $duration = this.getDuration();
    result = result * PRIME + ($duration == null ? 43 : $duration.hashCode());
    final java.lang.Object $durationInMonths = this.getDurationInMonths();
    result = result * PRIME + ($durationInMonths == null ? 43 : $durationInMonths.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $maxRedemptions = this.getMaxRedemptions();
    result = result * PRIME + ($maxRedemptions == null ? 43 : $maxRedemptions.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $percentOff = this.getPercentOff();
    result = result * PRIME + ($percentOff == null ? 43 : $percentOff.hashCode());
    final java.lang.Object $redeemBy = this.getRedeemBy();
    result = result * PRIME + ($redeemBy == null ? 43 : $redeemBy.hashCode());
    final java.lang.Object $timesRedeemed = this.getTimesRedeemed();
    result = result * PRIME + ($timesRedeemed == null ? 43 : $timesRedeemed.hashCode());
    final java.lang.Object $valid = this.getValid();
    result = result * PRIME + ($valid == null ? 43 : $valid.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
