// Generated by delombok at Tue Feb 11 15:14:27 PST 2020
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.util.Map;

public class Dispute extends ApiResource implements HasId, MetadataStore<Dispute> {
  /**
   * Disputed amount. Usually the amount of the {@code disputed_transaction}, but can differ
   * (usually because of currency fluctuation or because only part of the order is disputed).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The currency the {@code disputed_transaction} was made in.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The transaction being disputed.
   */
  @SerializedName("disputed_transaction")
  ExpandableField<Transaction> disputedTransaction;
  @SerializedName("evidence")
  Evidence evidence;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @SerializedName("object")
  String object;
  /**
   * Reason for this dispute. One of {@code fraudulent} or {@code other}.
   */
  @SerializedName("reason")
  String reason;
  /**
   * Current status of dispute. One of {@code unsubmitted}, {@code under_review}, {@code won}, or
   * {@code lost}.
   */
  @SerializedName("status")
  String status;

  /**
   * Get ID of expandable {@code disputedTransaction} object.
   */
  public String getDisputedTransaction() {
    return (this.disputedTransaction != null) ? this.disputedTransaction.getId() : null;
  }

  public void setDisputedTransaction(String id) {
    this.disputedTransaction = ApiResource.setExpandableFieldId(id, this.disputedTransaction);
  }

  /**
   * Get expanded {@code disputedTransaction}.
   */
  public Transaction getDisputedTransactionObject() {
    return (this.disputedTransaction != null) ? this.disputedTransaction.getExpanded() : null;
  }

  public void setDisputedTransactionObject(Transaction expandableObject) {
    this.disputedTransaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(DisputeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object.
   */
  public static Dispute create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object.
   */
  public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object.
   */
  public static Dispute create(DisputeCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object.
   */
  public static Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Dispute update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Dispute update(DisputeUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }


  public static class Evidence extends StripeObject {
    /**
     * Evidence to support a fraudulent dispute. This will only be present if your dispute's {@code
     * reason} is {@code fraudulent}.
     */
    @SerializedName("fraudulent")
    EvidenceFraudulent fraudulent;
    /**
     * Evidence to support an uncategorized dispute. This will only be present if your dispute's
     * {@code reason} is {@code other}.
     */
    @SerializedName("other")
    EvidenceOther other;

    /**
     * Evidence to support a fraudulent dispute. This will only be present if your dispute's {@code
     * reason} is {@code fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EvidenceFraudulent getFraudulent() {
      return this.fraudulent;
    }

    /**
     * Evidence to support an uncategorized dispute. This will only be present if your dispute's
     * {@code reason} is {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EvidenceOther getOther() {
      return this.other;
    }

    /**
     * Evidence to support a fraudulent dispute. This will only be present if your dispute's {@code
     * reason} is {@code fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFraudulent(final EvidenceFraudulent fraudulent) {
      this.fraudulent = fraudulent;
    }

    /**
     * Evidence to support an uncategorized dispute. This will only be present if your dispute's
     * {@code reason} is {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOther(final EvidenceOther other) {
      this.other = other;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.Evidence)) return false;
      final Dispute.Evidence other = (Dispute.Evidence) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$fraudulent = this.getFraudulent();
      final java.lang.Object other$fraudulent = other.getFraudulent();
      if (this$fraudulent == null ? other$fraudulent != null : !this$fraudulent.equals(other$fraudulent)) return false;
      final java.lang.Object this$other = this.getOther();
      final java.lang.Object other$other = other.getOther();
      if (this$other == null ? other$other != null : !this$other.equals(other$other)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.Evidence;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $fraudulent = this.getFraudulent();
      result = result * PRIME + ($fraudulent == null ? 43 : $fraudulent.hashCode());
      final java.lang.Object $other = this.getOther();
      result = result * PRIME + ($other == null ? 43 : $other.hashCode());
      return result;
    }
  }


  public static class EvidenceFraudulent extends StripeObject {
    /**
     * Brief freeform text explaining why you are disputing this transaction.
     */
    @SerializedName("dispute_explanation")
    String disputeExplanation;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
     * file evidence supporting your dispute.
     */
    @SerializedName("uncategorized_file")
    ExpandableField<File> uncategorizedFile;

    /**
     * Get ID of expandable {@code uncategorizedFile} object.
     */
    public String getUncategorizedFile() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getId() : null;
    }

    public void setUncategorizedFile(String id) {
      this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
    }

    /**
     * Get expanded {@code uncategorizedFile}.
     */
    public File getUncategorizedFileObject() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getExpanded() : null;
    }

    public void setUncategorizedFileObject(File expandableObject) {
      this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Brief freeform text explaining why you are disputing this transaction.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisputeExplanation() {
      return this.disputeExplanation;
    }

    /**
     * Brief freeform text explaining why you are disputing this transaction.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisputeExplanation(final String disputeExplanation) {
      this.disputeExplanation = disputeExplanation;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceFraudulent)) return false;
      final Dispute.EvidenceFraudulent other = (Dispute.EvidenceFraudulent) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$disputeExplanation = this.getDisputeExplanation();
      final java.lang.Object other$disputeExplanation = other.getDisputeExplanation();
      if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) return false;
      final java.lang.Object this$uncategorizedFile = this.getUncategorizedFile();
      final java.lang.Object other$uncategorizedFile = other.getUncategorizedFile();
      if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceFraudulent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $disputeExplanation = this.getDisputeExplanation();
      result = result * PRIME + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
      final java.lang.Object $uncategorizedFile = this.getUncategorizedFile();
      result = result * PRIME + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
      return result;
    }
  }


  public static class EvidenceOther extends StripeObject {
    /** Brief freeform text explaining why you are disputing this transaction. */
    @SerializedName("dispute_explanation")
    String disputeExplanation;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
     * file evidence supporting your dispute.
     */
    @SerializedName("uncategorized_file")
    ExpandableField<File> uncategorizedFile;

    /** Get ID of expandable {@code uncategorizedFile} object. */
    public String getUncategorizedFile() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getId() : null;
    }

    public void setUncategorizedFile(String id) {
      this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
    }

    /** Get expanded {@code uncategorizedFile}. */
    public File getUncategorizedFileObject() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getExpanded() : null;
    }

    public void setUncategorizedFileObject(File expandableObject) {
      this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisputeExplanation() {
      return this.disputeExplanation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisputeExplanation(final String disputeExplanation) {
      this.disputeExplanation = disputeExplanation;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceOther)) return false;
      final Dispute.EvidenceOther other = (Dispute.EvidenceOther) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$disputeExplanation = this.getDisputeExplanation();
      final java.lang.Object other$disputeExplanation = other.getDisputeExplanation();
      if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) return false;
      final java.lang.Object this$uncategorizedFile = this.getUncategorizedFile();
      final java.lang.Object other$uncategorizedFile = other.getUncategorizedFile();
      if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceOther;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $disputeExplanation = this.getDisputeExplanation();
      result = result * PRIME + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
      final java.lang.Object $uncategorizedFile = this.getUncategorizedFile();
      result = result * PRIME + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
      return result;
    }
  }

  /**
   * Disputed amount. Usually the amount of the {@code disputed_transaction}, but can differ
   * (usually because of currency fluctuation or because only part of the order is disputed).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The currency the {@code disputed_transaction} was made in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Evidence getEvidence() {
    return this.evidence;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Reason for this dispute. One of {@code fraudulent} or {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  /**
   * Current status of dispute. One of {@code unsubmitted}, {@code under_review}, {@code won}, or
   * {@code lost}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Disputed amount. Usually the amount of the {@code disputed_transaction}, but can differ
   * (usually because of currency fluctuation or because only part of the order is disputed).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The currency the {@code disputed_transaction} was made in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidence(final Evidence evidence) {
    this.evidence = evidence;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Reason for this dispute. One of {@code fraudulent} or {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  /**
   * Current status of dispute. One of {@code unsubmitted}, {@code under_review}, {@code won}, or
   * {@code lost}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Dispute)) return false;
    final Dispute other = (Dispute) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$disputedTransaction = this.getDisputedTransaction();
    final java.lang.Object other$disputedTransaction = other.getDisputedTransaction();
    if (this$disputedTransaction == null ? other$disputedTransaction != null : !this$disputedTransaction.equals(other$disputedTransaction)) return false;
    final java.lang.Object this$evidence = this.getEvidence();
    final java.lang.Object other$evidence = other.getEvidence();
    if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Dispute;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $disputedTransaction = this.getDisputedTransaction();
    result = result * PRIME + ($disputedTransaction == null ? 43 : $disputedTransaction.hashCode());
    final java.lang.Object $evidence = this.getEvidence();
    result = result * PRIME + ($evidence == null ? 43 : $evidence.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
