// Generated by delombok at Tue Mar 24 16:42:06 PDT 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CreditNoteCreateParams;
import com.stripe.param.CreditNoteListParams;
import com.stripe.param.CreditNotePreviewParams;
import com.stripe.param.CreditNoteRetrieveParams;
import com.stripe.param.CreditNoteUpdateParams;
import com.stripe.param.CreditNoteVoidCreditNoteParams;
import java.util.List;
import java.util.Map;

public class CreditNote extends ApiResource implements HasId, MetadataStore<CreditNote> {
  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the customer.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Customer balance transaction related to this credit note.
   */
  @SerializedName("customer_balance_transaction")
  ExpandableField<CustomerBalanceTransaction> customerBalanceTransaction;
  /**
   * The integer amount in <strong>%s</strong> representing the amount of the discount that was
   * credited.
   */
  @SerializedName("discount_amount")
  Long discountAmount;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * ID of the invoice.
   */
  @SerializedName("invoice")
  ExpandableField<Invoice> invoice;
  /**
   * Line items that make up the credit note.
   */
  @SerializedName("lines")
  CreditNoteLineItemCollection lines;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @SerializedName("memo")
  String memo;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @SerializedName("number")
  String number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code credit_note}.
   */
  @SerializedName("object")
  String object;
  /**
   * Amount that was credited outside of Stripe.
   */
  @SerializedName("out_of_band_amount")
  Long outOfBandAmount;
  /**
   * The link to download the PDF of the credit note.
   */
  @SerializedName("pdf")
  String pdf;
  /**
   * Reason for issuing this credit note, one of {@code duplicate}, {@code fraudulent}, {@code
   * order_change}, or {@code product_unsatisfactory}.
   */
  @SerializedName("reason")
  String reason;
  /**
   * Refund related to this credit note.
   */
  @SerializedName("refund")
  ExpandableField<Refund> refund;
  /**
   * Status of this credit note, one of {@code issued} or {@code void}. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  @SerializedName("status")
  String status;
  /**
   * The integer amount in <strong>%s</strong> representing the amount of the credit note, excluding
   * tax and discount.
   */
  @SerializedName("subtotal")
  Long subtotal;
  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @SerializedName("tax_amounts")
  List<CreditNote.TaxAmount> taxAmounts;
  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax and discount.
   */
  @SerializedName("total")
  Long total;
  /**
   * Type of this credit note, one of {@code pre_payment} or {@code post_payment}. A {@code
   * pre_payment} credit note means it was issued when the invoice was open. A {@code post_payment}
   * credit note means it was issued when the invoice was paid.
   */
  @SerializedName("type")
  String type;
  /**
   * The time that the credit note was voided.
   */
  @SerializedName("voided_at")
  Long voidedAt;

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customerBalanceTransaction} object.
   */
  public String getCustomerBalanceTransaction() {
    return (this.customerBalanceTransaction != null) ? this.customerBalanceTransaction.getId() : null;
  }

  public void setCustomerBalanceTransaction(String id) {
    this.customerBalanceTransaction = ApiResource.setExpandableFieldId(id, this.customerBalanceTransaction);
  }

  /**
   * Get expanded {@code customerBalanceTransaction}.
   */
  public CustomerBalanceTransaction getCustomerBalanceTransactionObject() {
    return (this.customerBalanceTransaction != null) ? this.customerBalanceTransaction.getExpanded() : null;
  }

  public void setCustomerBalanceTransactionObject(CustomerBalanceTransaction expandableObject) {
    this.customerBalanceTransaction = new ExpandableField<CustomerBalanceTransaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code invoice} object.
   */
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String id) {
    this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
  }

  /**
   * Get expanded {@code invoice}.
   */
  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice expandableObject) {
    this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code refund} object.
   */
  public String getRefund() {
    return (this.refund != null) ? this.refund.getId() : null;
  }

  public void setRefund(String id) {
    this.refund = ApiResource.setExpandableFieldId(id, this.refund);
  }

  /**
   * Get expanded {@code refund}.
   */
  public Refund getRefundObject() {
    return (this.refund != null) ? this.refund.getExpanded() : null;
  }

  public void setRefundObject(Refund expandableObject) {
    this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: record the amount that is or will be credited outside of Stripe
   *       (using <code>out_of_band_amount</code>).
   * </ul>
   *
   * <p>For post-payment credit notes the sum of the refund, credit and outside of Stripe amounts
   * must equal the credit note total.
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: record the amount that is or will be credited outside of Stripe
   *       (using <code>out_of_band_amount</code>).
   * </ul>
   *
   * <p>For post-payment credit notes the sum of the refund, credit and outside of Stripe amounts
   * must equal the credit note total.
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: record the amount that is or will be credited outside of Stripe
   *       (using <code>out_of_band_amount</code>).
   * </ul>
   *
   * <p>For post-payment credit notes the sum of the refund, credit and outside of Stripe amounts
   * must equal the credit note total.
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(CreditNoteCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: record the amount that is or will be credited outside of Stripe
   *       (using <code>out_of_band_amount</code>).
   * </ul>
   *
   * <p>For post-payment credit notes the sum of the refund, credit and outside of Stripe amounts
   * must equal the credit note total.
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(CreditNoteCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Get a preview of a credit note without creating it.
   */
  public static CreditNote preview(Map<String, Object> params) throws StripeException {
    return preview(params, (RequestOptions) null);
  }

  /**
   * Get a preview of a credit note without creating it.
   */
  public static CreditNote preview(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes/preview");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Get a preview of a credit note without creating it.
   */
  public static CreditNote preview(CreditNotePreviewParams params) throws StripeException {
    return preview(params, (RequestOptions) null);
  }

  /**
   * Get a preview of a credit note without creating it.
   */
  public static CreditNote preview(CreditNotePreviewParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes/preview");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, CreditNoteRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return ApiResource.requestCollection(url, params, CreditNoteCollection.class, options);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(CreditNoteListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(CreditNoteListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return ApiResource.requestCollection(url, params, CreditNoteCollection.class, options);
  }

  /**
   * Updates an existing credit note.
   */
  @Override
  public CreditNote update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing credit note.
   */
  @Override
  public CreditNote update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Updates an existing credit note.
   */
  public CreditNote update(CreditNoteUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing credit note.
   */
  public CreditNote update(CreditNoteUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote() throws StripeException {
    return voidCreditNote((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(RequestOptions options) throws StripeException {
    return voidCreditNote((Map<String, Object>) null, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(Map<String, Object> params) throws StripeException {
    return voidCreditNote(params, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params) throws StripeException {
    return voidCreditNote(params, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }


  public static class TaxAmount extends StripeObject {
    /** The amount, in %s, of the tax. */
    @SerializedName("amount")
    Long amount;
    /** Whether this tax amount is inclusive or exclusive. */
    @SerializedName("inclusive")
    Boolean inclusive;
    /** The tax rate that was applied to get this tax amount. */
    @SerializedName("tax_rate")
    ExpandableField<TaxRate> taxRate;

    /** Get ID of expandable {@code taxRate} object. */
    public String getTaxRate() {
      return (this.taxRate != null) ? this.taxRate.getId() : null;
    }

    public void setTaxRate(String id) {
      this.taxRate = ApiResource.setExpandableFieldId(id, this.taxRate);
    }

    /** Get expanded {@code taxRate}. */
    public TaxRate getTaxRateObject() {
      return (this.taxRate != null) ? this.taxRate.getExpanded() : null;
    }

    public void setTaxRateObject(TaxRate expandableObject) {
      this.taxRate = new ExpandableField<TaxRate>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getInclusive() {
      return this.inclusive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInclusive(final Boolean inclusive) {
      this.inclusive = inclusive;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CreditNote.TaxAmount)) return false;
      final CreditNote.TaxAmount other = (CreditNote.TaxAmount) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$inclusive = this.getInclusive();
      final java.lang.Object other$inclusive = other.getInclusive();
      if (this$inclusive == null ? other$inclusive != null : !this$inclusive.equals(other$inclusive)) return false;
      final java.lang.Object this$taxRate = this.getTaxRate();
      final java.lang.Object other$taxRate = other.getTaxRate();
      if (this$taxRate == null ? other$taxRate != null : !this$taxRate.equals(other$taxRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CreditNote.TaxAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $inclusive = this.getInclusive();
      result = result * PRIME + ($inclusive == null ? 43 : $inclusive.hashCode());
      final java.lang.Object $taxRate = this.getTaxRate();
      result = result * PRIME + ($taxRate == null ? 43 : $taxRate.hashCode());
      return result;
    }
  }

  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the amount of the discount that was
   * credited.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDiscountAmount() {
    return this.discountAmount;
  }

  /**
   * Line items that make up the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CreditNoteLineItemCollection getLines() {
    return this.lines;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMemo() {
    return this.memo;
  }

  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNumber() {
    return this.number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code credit_note}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Amount that was credited outside of Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getOutOfBandAmount() {
    return this.outOfBandAmount;
  }

  /**
   * The link to download the PDF of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPdf() {
    return this.pdf;
  }

  /**
   * Reason for issuing this credit note, one of {@code duplicate}, {@code fraudulent}, {@code
   * order_change}, or {@code product_unsatisfactory}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  /**
   * Status of this credit note, one of {@code issued} or {@code void}. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the amount of the credit note, excluding
   * tax and discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSubtotal() {
    return this.subtotal;
  }

  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<CreditNote.TaxAmount> getTaxAmounts() {
    return this.taxAmounts;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax and discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTotal() {
    return this.total;
  }

  /**
   * Type of this credit note, one of {@code pre_payment} or {@code post_payment}. A {@code
   * pre_payment} credit note means it was issued when the invoice was open. A {@code post_payment}
   * credit note means it was issued when the invoice was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The time that the credit note was voided.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getVoidedAt() {
    return this.voidedAt;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the amount of the discount that was
   * credited.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountAmount(final Long discountAmount) {
    this.discountAmount = discountAmount;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Line items that make up the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLines(final CreditNoteLineItemCollection lines) {
    this.lines = lines;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMemo(final String memo) {
    this.memo = memo;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNumber(final String number) {
    this.number = number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code credit_note}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Amount that was credited outside of Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutOfBandAmount(final Long outOfBandAmount) {
    this.outOfBandAmount = outOfBandAmount;
  }

  /**
   * The link to download the PDF of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPdf(final String pdf) {
    this.pdf = pdf;
  }

  /**
   * Reason for issuing this credit note, one of {@code duplicate}, {@code fraudulent}, {@code
   * order_change}, or {@code product_unsatisfactory}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  /**
   * Status of this credit note, one of {@code issued} or {@code void}. Learn more about <a
   * href="https://stripe.com/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the amount of the credit note, excluding
   * tax and discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubtotal(final Long subtotal) {
    this.subtotal = subtotal;
  }

  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxAmounts(final List<CreditNote.TaxAmount> taxAmounts) {
    this.taxAmounts = taxAmounts;
  }

  /**
   * The integer amount in <strong>%s</strong> representing the total amount of the credit note,
   * including tax and discount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotal(final Long total) {
    this.total = total;
  }

  /**
   * Type of this credit note, one of {@code pre_payment} or {@code post_payment}. A {@code
   * pre_payment} credit note means it was issued when the invoice was open. A {@code post_payment}
   * credit note means it was issued when the invoice was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * The time that the credit note was voided.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVoidedAt(final Long voidedAt) {
    this.voidedAt = voidedAt;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CreditNote)) return false;
    final CreditNote other = (CreditNote) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$customerBalanceTransaction = this.getCustomerBalanceTransaction();
    final java.lang.Object other$customerBalanceTransaction = other.getCustomerBalanceTransaction();
    if (this$customerBalanceTransaction == null ? other$customerBalanceTransaction != null : !this$customerBalanceTransaction.equals(other$customerBalanceTransaction)) return false;
    final java.lang.Object this$discountAmount = this.getDiscountAmount();
    final java.lang.Object other$discountAmount = other.getDiscountAmount();
    if (this$discountAmount == null ? other$discountAmount != null : !this$discountAmount.equals(other$discountAmount)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$lines = this.getLines();
    final java.lang.Object other$lines = other.getLines();
    if (this$lines == null ? other$lines != null : !this$lines.equals(other$lines)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$memo = this.getMemo();
    final java.lang.Object other$memo = other.getMemo();
    if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$number = this.getNumber();
    final java.lang.Object other$number = other.getNumber();
    if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$outOfBandAmount = this.getOutOfBandAmount();
    final java.lang.Object other$outOfBandAmount = other.getOutOfBandAmount();
    if (this$outOfBandAmount == null ? other$outOfBandAmount != null : !this$outOfBandAmount.equals(other$outOfBandAmount)) return false;
    final java.lang.Object this$pdf = this.getPdf();
    final java.lang.Object other$pdf = other.getPdf();
    if (this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$refund = this.getRefund();
    final java.lang.Object other$refund = other.getRefund();
    if (this$refund == null ? other$refund != null : !this$refund.equals(other$refund)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$subtotal = this.getSubtotal();
    final java.lang.Object other$subtotal = other.getSubtotal();
    if (this$subtotal == null ? other$subtotal != null : !this$subtotal.equals(other$subtotal)) return false;
    final java.lang.Object this$taxAmounts = this.getTaxAmounts();
    final java.lang.Object other$taxAmounts = other.getTaxAmounts();
    if (this$taxAmounts == null ? other$taxAmounts != null : !this$taxAmounts.equals(other$taxAmounts)) return false;
    final java.lang.Object this$total = this.getTotal();
    final java.lang.Object other$total = other.getTotal();
    if (this$total == null ? other$total != null : !this$total.equals(other$total)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$voidedAt = this.getVoidedAt();
    final java.lang.Object other$voidedAt = other.getVoidedAt();
    if (this$voidedAt == null ? other$voidedAt != null : !this$voidedAt.equals(other$voidedAt)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CreditNote;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $customerBalanceTransaction = this.getCustomerBalanceTransaction();
    result = result * PRIME + ($customerBalanceTransaction == null ? 43 : $customerBalanceTransaction.hashCode());
    final java.lang.Object $discountAmount = this.getDiscountAmount();
    result = result * PRIME + ($discountAmount == null ? 43 : $discountAmount.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $lines = this.getLines();
    result = result * PRIME + ($lines == null ? 43 : $lines.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $memo = this.getMemo();
    result = result * PRIME + ($memo == null ? 43 : $memo.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $number = this.getNumber();
    result = result * PRIME + ($number == null ? 43 : $number.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $outOfBandAmount = this.getOutOfBandAmount();
    result = result * PRIME + ($outOfBandAmount == null ? 43 : $outOfBandAmount.hashCode());
    final java.lang.Object $pdf = this.getPdf();
    result = result * PRIME + ($pdf == null ? 43 : $pdf.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $refund = this.getRefund();
    result = result * PRIME + ($refund == null ? 43 : $refund.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $subtotal = this.getSubtotal();
    result = result * PRIME + ($subtotal == null ? 43 : $subtotal.hashCode());
    final java.lang.Object $taxAmounts = this.getTaxAmounts();
    result = result * PRIME + ($taxAmounts == null ? 43 : $taxAmounts.hashCode());
    final java.lang.Object $total = this.getTotal();
    result = result * PRIME + ($total == null ? 43 : $total.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $voidedAt = this.getVoidedAt();
    result = result * PRIME + ($voidedAt == null ? 43 : $voidedAt.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
