// Generated by delombok at Fri Apr 03 13:20:44 PDT 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentUpdateParams;
import java.util.List;
import java.util.Map;

public class PaymentIntent extends ApiResource implements HasId, MetadataStore<PaymentIntent> {
  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @SerializedName("amount_capturable")
  Long amountCapturable;
  /**
   * Amount that was collected by this PaymentIntent.
   */
  @SerializedName("amount_received")
  Long amountReceived;
  /**
   * ID of the Connect application that created the PaymentIntent.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @SerializedName("canceled_at")
  Long canceledAt;
  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @SerializedName("cancellation_reason")
  String cancellationReason;
  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @SerializedName("capture_method")
  String captureMethod;
  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @SerializedName("charges")
  ChargeCollection charges;
  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that
   * you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a href="https://stripe.com/docs/payments/accept-a-payment">accept a
   * payment</a> and learn about how {@code client_secret} should be handled.
   */
  @SerializedName("client_secret")
  String clientSecret;
  @SerializedName("confirmation_method")
  String confirmationMethod;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the Customer this PaymentIntent belongs to, if one exists.
   *
   * <p>Payment methods attached to other Customers cannot be used with this PaymentIntent.
   *
   * <p>If present in combination with <a
   * href="https://stripe.com/docs/api#payment_intent_object-setup_future_usage">setup_future_usage</a>,
   * this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent
   * has been confirmed and any required actions from the user are complete.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * ID of the invoice that created this PaymentIntent, if it exists.
   */
  @SerializedName("invoice")
  ExpandableField<Invoice> invoice;
  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @SerializedName("last_payment_error")
  StripeError lastPaymentError;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @SerializedName("next_action")
  NextAction nextAction;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) for which the funds of the PaymentIntent are intended. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the payment method used in this PaymentIntent.
   */
  @SerializedName("payment_method")
  ExpandableField<PaymentMethod> paymentMethod;
  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @SerializedName("payment_method_options")
  PaymentMethodOptions paymentMethodOptions;
  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @SerializedName("receipt_email")
  String receiptEmail;
  /**
   * ID of the review associated with this PaymentIntent, if any.
   */
  @SerializedName("review")
  ExpandableField<Review> review;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @SerializedName("setup_future_usage")
  String setupFutureUsage;
  /**
   * Shipping information for this PaymentIntent.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * This is a legacy field that will be removed in the future. It is the ID of the Source object
   * that is associated with this PaymentIntent, if one was supplied.
   */
  @SerializedName("source")
  ExpandableField<PaymentSource> source;
  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @SerializedName("statement_descriptor_suffix")
  String statementDescriptorSuffix;
  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @SerializedName("status")
  String status;
  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @SerializedName("transfer_group")
  String transferGroup;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code invoice} object.
   */
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String id) {
    this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
  }

  /**
   * Get expanded {@code invoice}.
   */
  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice expandableObject) {
    this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentMethod} object.
   */
  public String getPaymentMethod() {
    return (this.paymentMethod != null) ? this.paymentMethod.getId() : null;
  }

  public void setPaymentMethod(String id) {
    this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
  }

  /**
   * Get expanded {@code paymentMethod}.
   */
  public PaymentMethod getPaymentMethodObject() {
    return (this.paymentMethod != null) ? this.paymentMethod.getExpanded() : null;
  }

  public void setPaymentMethodObject(PaymentMethod expandableObject) {
    this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code review} object.
   */
  public String getReview() {
    return (this.review != null) ? this.review.getId() : null;
  }

  public void setReview(String id) {
    this.review = ApiResource.setExpandableFieldId(id, this.review);
  }

  /**
   * Get expanded {@code review}.
   */
  public Review getReviewObject() {
    return (this.review != null) ? this.review.getExpanded() : null;
  }

  public void setReviewObject(Review expandableObject) {
    this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code source} object.
   */
  public String getSource() {
    return (this.source != null) ? this.source.getId() : null;
  }

  public void setSource(String id) {
    this.source = ApiResource.setExpandableFieldId(id, this.source);
  }

  /**
   * Get expanded {@code source}.
   */
  public PaymentSource getSourceObject() {
    return (this.source != null) ? this.source.getExpanded() : null;
  }

  public void setSourceObject(PaymentSource expandableObject) {
    this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(PaymentIntentListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  @Override
  public PaymentIntent update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  @Override
  public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  public PaymentIntent update(PaymentIntentUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  public PaymentIntent update(PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm() throws StripeException {
    return confirm((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(RequestOptions options) throws StripeException {
    return confirm((Map<String, Object>) null, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(PaymentIntentConfirmParams params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(PaymentIntentCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture() throws StripeException {
    return capture((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(RequestOptions options) throws StripeException {
    return capture((Map<String, Object>) null, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(Map<String, Object> params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(PaymentIntentCaptureParams params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }


  public static class NextAction extends StripeObject {
    @SerializedName("redirect_to_url")
    NextActionRedirectToUrl redirectToUrl;
    /**
     * Type of the next action to perform, one of {@code redirect_to_url} or {@code use_stripe_sdk}.
     */
    @SerializedName("type")
    String type;
    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @SerializedName("use_stripe_sdk")
    Map<String, Object> useStripeSdk;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionRedirectToUrl getRedirectToUrl() {
      return this.redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url} or {@code use_stripe_sdk}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getUseStripeSdk() {
      return this.useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirectToUrl(final NextActionRedirectToUrl redirectToUrl) {
      this.redirectToUrl = redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url} or {@code use_stripe_sdk}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUseStripeSdk(final Map<String, Object> useStripeSdk) {
      this.useStripeSdk = useStripeSdk;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextAction)) return false;
      final PaymentIntent.NextAction other = (PaymentIntent.NextAction) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$redirectToUrl = this.getRedirectToUrl();
      final java.lang.Object other$redirectToUrl = other.getRedirectToUrl();
      if (this$redirectToUrl == null ? other$redirectToUrl != null : !this$redirectToUrl.equals(other$redirectToUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$useStripeSdk = this.getUseStripeSdk();
      final java.lang.Object other$useStripeSdk = other.getUseStripeSdk();
      if (this$useStripeSdk == null ? other$useStripeSdk != null : !this$useStripeSdk.equals(other$useStripeSdk)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextAction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $redirectToUrl = this.getRedirectToUrl();
      result = result * PRIME + ($redirectToUrl == null ? 43 : $redirectToUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $useStripeSdk = this.getUseStripeSdk();
      result = result * PRIME + ($useStripeSdk == null ? 43 : $useStripeSdk.hashCode());
      return result;
    }
  }


  public static class NextActionRedirectToUrl extends StripeObject {
    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @SerializedName("url")
    String url;

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionRedirectToUrl)) return false;
      final PaymentIntent.NextActionRedirectToUrl other = (PaymentIntent.NextActionRedirectToUrl) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionRedirectToUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class PaymentMethodOptions extends StripeObject {
    @SerializedName("card")
    Card card;


    public static class Card extends StripeObject {
      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @SerializedName("installments")
      Installments installments;
      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, {@code automatic}, or {@code challenge_only}.
       */
      @SerializedName("request_three_d_secure")
      String requestThreeDSecure;


      public static class Installments extends StripeObject {
        /** Installment plans that may be selected for this PaymentIntent. */
        @SerializedName("available_plans")
        List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> availablePlans;
        /** Whether Installments are enabled for this PaymentIntent. */
        @SerializedName("enabled")
        Boolean enabled;
        /** Installment plan selected for this PaymentIntent. */
        @SerializedName("plan")
        Plan plan;


        public static class Plan extends StripeObject {
          /**
           * For {@code fixed_count} installment plans, this is the number of installment payments
           * your customer will make to their credit card.
           */
          @SerializedName("count")
          Long count;
          /**
           * For {@code fixed_count} installment plans, this is the interval between installment
           * payments your customer will make to their credit card. One of {@code month}.
           */
          @SerializedName("interval")
          String interval;
          @SerializedName("type")
          String type;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getCount() {
            return this.count;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getInterval() {
            return this.interval;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getType() {
            return this.type;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCount(final Long count) {
            this.count = count;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setInterval(final String interval) {
            this.interval = interval;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setType(final String type) {
            this.type = type;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card.Installments.Plan)) return false;
            final PaymentIntent.PaymentMethodOptions.Card.Installments.Plan other = (PaymentIntent.PaymentMethodOptions.Card.Installments.Plan) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$count = this.getCount();
            final java.lang.Object other$count = other.getCount();
            if (this$count == null ? other$count != null : !this$count.equals(other$count)) return false;
            final java.lang.Object this$interval = this.getInterval();
            final java.lang.Object other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof PaymentIntent.PaymentMethodOptions.Card.Installments.Plan;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $count = this.getCount();
            result = result * PRIME + ($count == null ? 43 : $count.hashCode());
            final java.lang.Object $interval = this.getInterval();
            result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            return result;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> getAvailablePlans() {
          return this.availablePlans;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getEnabled() {
          return this.enabled;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Plan getPlan() {
          return this.plan;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAvailablePlans(final List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> availablePlans) {
          this.availablePlans = availablePlans;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEnabled(final Boolean enabled) {
          this.enabled = enabled;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPlan(final Plan plan) {
          this.plan = plan;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card.Installments)) return false;
          final PaymentIntent.PaymentMethodOptions.Card.Installments other = (PaymentIntent.PaymentMethodOptions.Card.Installments) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$availablePlans = this.getAvailablePlans();
          final java.lang.Object other$availablePlans = other.getAvailablePlans();
          if (this$availablePlans == null ? other$availablePlans != null : !this$availablePlans.equals(other$availablePlans)) return false;
          final java.lang.Object this$enabled = this.getEnabled();
          final java.lang.Object other$enabled = other.getEnabled();
          if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
          final java.lang.Object this$plan = this.getPlan();
          final java.lang.Object other$plan = other.getPlan();
          if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.Card.Installments;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $availablePlans = this.getAvailablePlans();
          result = result * PRIME + ($availablePlans == null ? 43 : $availablePlans.hashCode());
          final java.lang.Object $enabled = this.getEnabled();
          result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
          final java.lang.Object $plan = this.getPlan();
          result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Installments getInstallments() {
        return this.installments;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequestThreeDSecure() {
        return this.requestThreeDSecure;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInstallments(final Installments installments) {
        this.installments = installments;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestThreeDSecure(final String requestThreeDSecure) {
        this.requestThreeDSecure = requestThreeDSecure;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card)) return false;
        final PaymentIntent.PaymentMethodOptions.Card other = (PaymentIntent.PaymentMethodOptions.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$installments = this.getInstallments();
        final java.lang.Object other$installments = other.getInstallments();
        if (this$installments == null ? other$installments != null : !this$installments.equals(other$installments)) return false;
        final java.lang.Object this$requestThreeDSecure = this.getRequestThreeDSecure();
        final java.lang.Object other$requestThreeDSecure = other.getRequestThreeDSecure();
        if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $installments = this.getInstallments();
        result = result * PRIME + ($installments == null ? 43 : $installments.hashCode());
        final java.lang.Object $requestThreeDSecure = this.getRequestThreeDSecure();
        result = result * PRIME + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.PaymentMethodOptions)) return false;
      final PaymentIntent.PaymentMethodOptions other = (PaymentIntent.PaymentMethodOptions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.PaymentMethodOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      return result;
    }
  }


  /**
   * Type of installment plan, one of {@code fixed_count}.
   */
  public static class TransferData extends StripeObject {
    /**
     * Amount intended to be collected by this PaymentIntent. A positive integer representing how
     * much to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
     * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
     * currency). The minimum amount is $0.50 US or <a
     * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
     * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
     * for a USD charge of $999,999.99).
     */
    @SerializedName("amount")
    Long amount;
    /**
     * The account (if any) the payment will be attributed to for tax reporting, and where funds
     * from the payment will be transferred to upon payment success.
     */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.TransferData)) return false;
      final PaymentIntent.TransferData other = (PaymentIntent.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountCapturable() {
    return this.amountCapturable;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountReceived() {
    return this.amountReceived;
  }

  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCanceledAt() {
    return this.canceledAt;
  }

  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancellationReason() {
    return this.cancellationReason;
  }

  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCaptureMethod() {
    return this.captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ChargeCollection getCharges() {
    return this.charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that
   * you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a href="https://stripe.com/docs/payments/accept-a-payment">accept a
   * payment</a> and learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getConfirmationMethod() {
    return this.confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getLastPaymentError() {
    return this.lastPaymentError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NextAction getNextAction() {
    return this.nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodOptions getPaymentMethodOptions() {
    return this.paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptEmail() {
    return this.receiptEmail;
  }

  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSetupFutureUsage() {
    return this.setupFutureUsage;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptorSuffix() {
    return this.statementDescriptorSuffix;
  }

  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTransferGroup() {
    return this.transferGroup;
  }

  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountCapturable(final Long amountCapturable) {
    this.amountCapturable = amountCapturable;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountReceived(final Long amountReceived) {
    this.amountReceived = amountReceived;
  }

  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCanceledAt(final Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancellationReason(final String cancellationReason) {
    this.cancellationReason = cancellationReason;
  }

  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaptureMethod(final String captureMethod) {
    this.captureMethod = captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCharges(final ChargeCollection charges) {
    this.charges = charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that
   * you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a href="https://stripe.com/docs/payments/accept-a-payment">accept a
   * payment</a> and learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConfirmationMethod(final String confirmationMethod) {
    this.confirmationMethod = confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastPaymentError(final StripeError lastPaymentError) {
    this.lastPaymentError = lastPaymentError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNextAction(final NextAction nextAction) {
    this.nextAction = nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodOptions(final PaymentMethodOptions paymentMethodOptions) {
    this.paymentMethodOptions = paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptEmail(final String receiptEmail) {
    this.receiptEmail = receiptEmail;
  }

  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSetupFutureUsage(final String setupFutureUsage) {
    this.setupFutureUsage = setupFutureUsage;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptorSuffix(final String statementDescriptorSuffix) {
    this.statementDescriptorSuffix = statementDescriptorSuffix;
  }

  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferGroup(final String transferGroup) {
    this.transferGroup = transferGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentIntent)) return false;
    final PaymentIntent other = (PaymentIntent) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountCapturable = this.getAmountCapturable();
    final java.lang.Object other$amountCapturable = other.getAmountCapturable();
    if (this$amountCapturable == null ? other$amountCapturable != null : !this$amountCapturable.equals(other$amountCapturable)) return false;
    final java.lang.Object this$amountReceived = this.getAmountReceived();
    final java.lang.Object other$amountReceived = other.getAmountReceived();
    if (this$amountReceived == null ? other$amountReceived != null : !this$amountReceived.equals(other$amountReceived)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$canceledAt = this.getCanceledAt();
    final java.lang.Object other$canceledAt = other.getCanceledAt();
    if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
    final java.lang.Object this$cancellationReason = this.getCancellationReason();
    final java.lang.Object other$cancellationReason = other.getCancellationReason();
    if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
    final java.lang.Object this$captureMethod = this.getCaptureMethod();
    final java.lang.Object other$captureMethod = other.getCaptureMethod();
    if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
    final java.lang.Object this$charges = this.getCharges();
    final java.lang.Object other$charges = other.getCharges();
    if (this$charges == null ? other$charges != null : !this$charges.equals(other$charges)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$confirmationMethod = this.getConfirmationMethod();
    final java.lang.Object other$confirmationMethod = other.getConfirmationMethod();
    if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$lastPaymentError = this.getLastPaymentError();
    final java.lang.Object other$lastPaymentError = other.getLastPaymentError();
    if (this$lastPaymentError == null ? other$lastPaymentError != null : !this$lastPaymentError.equals(other$lastPaymentError)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nextAction = this.getNextAction();
    final java.lang.Object other$nextAction = other.getNextAction();
    if (this$nextAction == null ? other$nextAction != null : !this$nextAction.equals(other$nextAction)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodOptions = this.getPaymentMethodOptions();
    final java.lang.Object other$paymentMethodOptions = other.getPaymentMethodOptions();
    if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !this$paymentMethodOptions.equals(other$paymentMethodOptions)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$receiptEmail = this.getReceiptEmail();
    final java.lang.Object other$receiptEmail = other.getReceiptEmail();
    if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) return false;
    final java.lang.Object this$review = this.getReview();
    final java.lang.Object other$review = other.getReview();
    if (this$review == null ? other$review != null : !this$review.equals(other$review)) return false;
    final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
    final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
    if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    final java.lang.Object other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
    if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$transferGroup = this.getTransferGroup();
    final java.lang.Object other$transferGroup = other.getTransferGroup();
    if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentIntent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountCapturable = this.getAmountCapturable();
    result = result * PRIME + ($amountCapturable == null ? 43 : $amountCapturable.hashCode());
    final java.lang.Object $amountReceived = this.getAmountReceived();
    result = result * PRIME + ($amountReceived == null ? 43 : $amountReceived.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $canceledAt = this.getCanceledAt();
    result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
    final java.lang.Object $cancellationReason = this.getCancellationReason();
    result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
    final java.lang.Object $captureMethod = this.getCaptureMethod();
    result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
    final java.lang.Object $charges = this.getCharges();
    result = result * PRIME + ($charges == null ? 43 : $charges.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $confirmationMethod = this.getConfirmationMethod();
    result = result * PRIME + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $lastPaymentError = this.getLastPaymentError();
    result = result * PRIME + ($lastPaymentError == null ? 43 : $lastPaymentError.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nextAction = this.getNextAction();
    result = result * PRIME + ($nextAction == null ? 43 : $nextAction.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodOptions = this.getPaymentMethodOptions();
    result = result * PRIME + ($paymentMethodOptions == null ? 43 : $paymentMethodOptions.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $receiptEmail = this.getReceiptEmail();
    result = result * PRIME + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
    final java.lang.Object $review = this.getReview();
    result = result * PRIME + ($review == null ? 43 : $review.hashCode());
    final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
    result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    result = result * PRIME + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $transferGroup = this.getTransferGroup();
    result = result * PRIME + ($transferGroup == null ? 43 : $transferGroup.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
