/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Plan;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.model.SubscriptionSchedule;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionCancelParams;
import com.stripe.param.SubscriptionCreateParams;
import com.stripe.param.SubscriptionListParams;
import com.stripe.param.SubscriptionRetrieveParams;
import com.stripe.param.SubscriptionUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Subscription
extends ApiResource
implements HasId,
MetadataStore<Subscription> {
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="billing_cycle_anchor")
    Long billingCycleAnchor;
    @SerializedName(value="billing_thresholds")
    BillingThresholds billingThresholds;
    @SerializedName(value="cancel_at")
    Long cancelAt;
    @SerializedName(value="cancel_at_period_end")
    Boolean cancelAtPeriodEnd;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="current_period_end")
    Long currentPeriodEnd;
    @SerializedName(value="current_period_start")
    Long currentPeriodStart;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="days_until_due")
    Long daysUntilDue;
    @SerializedName(value="default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="default_tax_rates")
    List<TaxRate> defaultTaxRates;
    @SerializedName(value="discount")
    Discount discount;
    @SerializedName(value="ended_at")
    Long endedAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="items")
    SubscriptionItemCollection items;
    @SerializedName(value="latest_invoice")
    ExpandableField<Invoice> latestInvoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_pending_invoice_item_invoice")
    Long nextPendingInvoiceItemInvoice;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pause_collection")
    PauseCollection pauseCollection;
    @SerializedName(value="pending_invoice_item_interval")
    PendingInvoiceItemInterval pendingInvoiceItemInterval;
    @SerializedName(value="pending_setup_intent")
    ExpandableField<SetupIntent> pendingSetupIntent;
    @SerializedName(value="pending_update")
    PendingUpdate pendingUpdate;
    @SerializedName(value="plan")
    Plan plan;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="schedule")
    ExpandableField<SubscriptionSchedule> schedule;
    @SerializedName(value="start_date")
    Long startDate;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="tax_percent")
    BigDecimal taxPercent;
    @SerializedName(value="transfer_data")
    Invoice.TransferData transferData;
    @SerializedName(value="trial_end")
    Long trialEnd;
    @SerializedName(value="trial_start")
    Long trialStart;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
        this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    public PaymentMethod getDefaultPaymentMethodObject() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
        this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public String getLatestInvoice() {
        return this.latestInvoice != null ? this.latestInvoice.getId() : null;
    }

    public void setLatestInvoice(String id) {
        this.latestInvoice = ApiResource.setExpandableFieldId(id, this.latestInvoice);
    }

    public Invoice getLatestInvoiceObject() {
        return this.latestInvoice != null ? this.latestInvoice.getExpanded() : null;
    }

    public void setLatestInvoiceObject(Invoice expandableObject) {
        this.latestInvoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getPendingSetupIntent() {
        return this.pendingSetupIntent != null ? this.pendingSetupIntent.getId() : null;
    }

    public void setPendingSetupIntent(String id) {
        this.pendingSetupIntent = ApiResource.setExpandableFieldId(id, this.pendingSetupIntent);
    }

    public SetupIntent getPendingSetupIntentObject() {
        return this.pendingSetupIntent != null ? this.pendingSetupIntent.getExpanded() : null;
    }

    public void setPendingSetupIntentObject(SetupIntent expandableObject) {
        this.pendingSetupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSchedule() {
        return this.schedule != null ? this.schedule.getId() : null;
    }

    public void setSchedule(String id) {
        this.schedule = ApiResource.setExpandableFieldId(id, this.schedule);
    }

    public SubscriptionSchedule getScheduleObject() {
        return this.schedule != null ? this.schedule.getExpanded() : null;
    }

    public void setScheduleObject(SubscriptionSchedule expandableObject) {
        this.schedule = new ExpandableField<SubscriptionSchedule>(expandableObject.getId(), expandableObject);
    }

    public static SubscriptionCollection list(Map<String, Object> params) throws StripeException {
        return Subscription.list(params, (RequestOptions)null);
    }

    public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
        return ApiResource.requestCollection(url, params, SubscriptionCollection.class, options);
    }

    public static SubscriptionCollection list(SubscriptionListParams params) throws StripeException {
        return Subscription.list(params, (RequestOptions)null);
    }

    public static SubscriptionCollection list(SubscriptionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
        return ApiResource.requestCollection(url, params, SubscriptionCollection.class, options);
    }

    public static Subscription create(Map<String, Object> params) throws StripeException {
        return Subscription.create(params, (RequestOptions)null);
    }

    public static Subscription create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public static Subscription create(SubscriptionCreateParams params) throws StripeException {
        return Subscription.create(params, (RequestOptions)null);
    }

    public static Subscription create(SubscriptionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public Subscription update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public Subscription update(SubscriptionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Subscription update(SubscriptionUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public static Subscription retrieve(String subscriptionExposedId) throws StripeException {
        return Subscription.retrieve(subscriptionExposedId, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Subscription retrieve(String subscriptionExposedId, RequestOptions options) throws StripeException {
        return Subscription.retrieve(subscriptionExposedId, (Map<String, Object>)null, options);
    }

    public static Subscription retrieve(String subscriptionExposedId, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
    }

    public static Subscription retrieve(String subscriptionExposedId, SubscriptionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
    }

    public Subscription cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Subscription cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
    }

    public Subscription cancel(SubscriptionCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Subscription cancel(SubscriptionCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
    }

    public Discount deleteDiscount() throws StripeException {
        return this.deleteDiscount(null, null);
    }

    public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
        return this.deleteDiscount(params, null);
    }

    public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s/discount", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCancelAt() {
        return this.cancelAt;
    }

    @Generated
    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    @Generated
    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    @Generated
    public Long getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @Generated
    public List<TaxRate> getDefaultTaxRates() {
        return this.defaultTaxRates;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public SubscriptionItemCollection getItems() {
        return this.items;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNextPendingInvoiceItemInvoice() {
        return this.nextPendingInvoiceItemInvoice;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PauseCollection getPauseCollection() {
        return this.pauseCollection;
    }

    @Generated
    public PendingInvoiceItemInterval getPendingInvoiceItemInterval() {
        return this.pendingInvoiceItemInterval;
    }

    @Generated
    public PendingUpdate getPendingUpdate() {
        return this.pendingUpdate;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public Long getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    @Generated
    public Invoice.TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public Long getTrialStart() {
        return this.trialStart;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setBillingCycleAnchor(Long billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    @Generated
    public void setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCancelAt(Long cancelAt) {
        this.cancelAt = cancelAt;
    }

    @Generated
    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    @Generated
    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    @Generated
    public void setDaysUntilDue(Long daysUntilDue) {
        this.daysUntilDue = daysUntilDue;
    }

    @Generated
    public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
        this.defaultTaxRates = defaultTaxRates;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setItems(SubscriptionItemCollection items) {
        this.items = items;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextPendingInvoiceItemInvoice(Long nextPendingInvoiceItemInvoice) {
        this.nextPendingInvoiceItemInvoice = nextPendingInvoiceItemInvoice;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPauseCollection(PauseCollection pauseCollection) {
        this.pauseCollection = pauseCollection;
    }

    @Generated
    public void setPendingInvoiceItemInterval(PendingInvoiceItemInterval pendingInvoiceItemInterval) {
        this.pendingInvoiceItemInterval = pendingInvoiceItemInterval;
    }

    @Generated
    public void setPendingUpdate(PendingUpdate pendingUpdate) {
        this.pendingUpdate = pendingUpdate;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
    }

    @Generated
    public void setTransferData(Invoice.TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        Long this$billingCycleAnchor = this.getBillingCycleAnchor();
        Long other$billingCycleAnchor = other.getBillingCycleAnchor();
        if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
            return false;
        }
        BillingThresholds this$billingThresholds = this.getBillingThresholds();
        BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        Long this$cancelAt = this.getCancelAt();
        Long other$cancelAt = other.getCancelAt();
        if (this$cancelAt == null ? other$cancelAt != null : !((Object)this$cancelAt).equals(other$cancelAt)) {
            return false;
        }
        Boolean this$cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        Boolean other$cancelAtPeriodEnd = other.getCancelAtPeriodEnd();
        if (this$cancelAtPeriodEnd == null ? other$cancelAtPeriodEnd != null : !((Object)this$cancelAtPeriodEnd).equals(other$cancelAtPeriodEnd)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$currentPeriodEnd = this.getCurrentPeriodEnd();
        Long other$currentPeriodEnd = other.getCurrentPeriodEnd();
        if (this$currentPeriodEnd == null ? other$currentPeriodEnd != null : !((Object)this$currentPeriodEnd).equals(other$currentPeriodEnd)) {
            return false;
        }
        Long this$currentPeriodStart = this.getCurrentPeriodStart();
        Long other$currentPeriodStart = other.getCurrentPeriodStart();
        if (this$currentPeriodStart == null ? other$currentPeriodStart != null : !((Object)this$currentPeriodStart).equals(other$currentPeriodStart)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$daysUntilDue = this.getDaysUntilDue();
        Long other$daysUntilDue = other.getDaysUntilDue();
        if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
            return false;
        }
        String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
        String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
        if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
        List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$endedAt = this.getEndedAt();
        Long other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        SubscriptionItemCollection this$items = this.getItems();
        SubscriptionItemCollection other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$latestInvoice = this.getLatestInvoice();
        String other$latestInvoice = other.getLatestInvoice();
        if (this$latestInvoice == null ? other$latestInvoice != null : !this$latestInvoice.equals(other$latestInvoice)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Long this$nextPendingInvoiceItemInvoice = this.getNextPendingInvoiceItemInvoice();
        Long other$nextPendingInvoiceItemInvoice = other.getNextPendingInvoiceItemInvoice();
        if (this$nextPendingInvoiceItemInvoice == null ? other$nextPendingInvoiceItemInvoice != null : !((Object)this$nextPendingInvoiceItemInvoice).equals(other$nextPendingInvoiceItemInvoice)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PauseCollection this$pauseCollection = this.getPauseCollection();
        PauseCollection other$pauseCollection = other.getPauseCollection();
        if (this$pauseCollection == null ? other$pauseCollection != null : !((Object)this$pauseCollection).equals(other$pauseCollection)) {
            return false;
        }
        PendingInvoiceItemInterval this$pendingInvoiceItemInterval = this.getPendingInvoiceItemInterval();
        PendingInvoiceItemInterval other$pendingInvoiceItemInterval = other.getPendingInvoiceItemInterval();
        if (this$pendingInvoiceItemInterval == null ? other$pendingInvoiceItemInterval != null : !((Object)this$pendingInvoiceItemInterval).equals(other$pendingInvoiceItemInterval)) {
            return false;
        }
        String this$pendingSetupIntent = this.getPendingSetupIntent();
        String other$pendingSetupIntent = other.getPendingSetupIntent();
        if (this$pendingSetupIntent == null ? other$pendingSetupIntent != null : !this$pendingSetupIntent.equals(other$pendingSetupIntent)) {
            return false;
        }
        PendingUpdate this$pendingUpdate = this.getPendingUpdate();
        PendingUpdate other$pendingUpdate = other.getPendingUpdate();
        if (this$pendingUpdate == null ? other$pendingUpdate != null : !((Object)this$pendingUpdate).equals(other$pendingUpdate)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$schedule = this.getSchedule();
        String other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        BigDecimal this$taxPercent = this.getTaxPercent();
        BigDecimal other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        Invoice.TransferData this$transferData = this.getTransferData();
        Invoice.TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
            return false;
        }
        Long this$trialStart = this.getTrialStart();
        Long other$trialStart = other.getTrialStart();
        return !(this$trialStart == null ? other$trialStart != null : !((Object)this$trialStart).equals(other$trialStart));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        Long $billingCycleAnchor = this.getBillingCycleAnchor();
        result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
        BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        Long $cancelAt = this.getCancelAt();
        result = result * 59 + ($cancelAt == null ? 43 : ((Object)$cancelAt).hashCode());
        Boolean $cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        result = result * 59 + ($cancelAtPeriodEnd == null ? 43 : ((Object)$cancelAtPeriodEnd).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $currentPeriodEnd = this.getCurrentPeriodEnd();
        result = result * 59 + ($currentPeriodEnd == null ? 43 : ((Object)$currentPeriodEnd).hashCode());
        Long $currentPeriodStart = this.getCurrentPeriodStart();
        result = result * 59 + ($currentPeriodStart == null ? 43 : ((Object)$currentPeriodStart).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $daysUntilDue = this.getDaysUntilDue();
        result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
        String $defaultPaymentMethod = this.getDefaultPaymentMethod();
        result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        SubscriptionItemCollection $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $latestInvoice = this.getLatestInvoice();
        result = result * 59 + ($latestInvoice == null ? 43 : $latestInvoice.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Long $nextPendingInvoiceItemInvoice = this.getNextPendingInvoiceItemInvoice();
        result = result * 59 + ($nextPendingInvoiceItemInvoice == null ? 43 : ((Object)$nextPendingInvoiceItemInvoice).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PauseCollection $pauseCollection = this.getPauseCollection();
        result = result * 59 + ($pauseCollection == null ? 43 : ((Object)$pauseCollection).hashCode());
        PendingInvoiceItemInterval $pendingInvoiceItemInterval = this.getPendingInvoiceItemInterval();
        result = result * 59 + ($pendingInvoiceItemInterval == null ? 43 : ((Object)$pendingInvoiceItemInterval).hashCode());
        String $pendingSetupIntent = this.getPendingSetupIntent();
        result = result * 59 + ($pendingSetupIntent == null ? 43 : $pendingSetupIntent.hashCode());
        PendingUpdate $pendingUpdate = this.getPendingUpdate();
        result = result * 59 + ($pendingUpdate == null ? 43 : ((Object)$pendingUpdate).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        BigDecimal $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        Invoice.TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        Long $trialStart = this.getTrialStart();
        result = result * 59 + ($trialStart == null ? 43 : ((Object)$trialStart).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class PendingUpdate
    extends StripeObject {
        @SerializedName(value="billing_cycle_anchor")
        Long billingCycleAnchor;
        @SerializedName(value="expires_at")
        Long expiresAt;
        @SerializedName(value="subscription_items")
        List<SubscriptionItem> subscriptionItems;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_from_plan")
        Boolean trialFromPlan;

        @Generated
        public Long getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Long getExpiresAt() {
            return this.expiresAt;
        }

        @Generated
        public List<SubscriptionItem> getSubscriptionItems() {
            return this.subscriptionItems;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public Boolean getTrialFromPlan() {
            return this.trialFromPlan;
        }

        @Generated
        public void setBillingCycleAnchor(Long billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Generated
        public void setSubscriptionItems(List<SubscriptionItem> subscriptionItems) {
            this.subscriptionItems = subscriptionItems;
        }

        @Generated
        public void setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
        }

        @Generated
        public void setTrialFromPlan(Boolean trialFromPlan) {
            this.trialFromPlan = trialFromPlan;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingUpdate)) {
                return false;
            }
            PendingUpdate other = (PendingUpdate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$billingCycleAnchor = this.getBillingCycleAnchor();
            Long other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
                return false;
            }
            Long this$expiresAt = this.getExpiresAt();
            Long other$expiresAt = other.getExpiresAt();
            if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                return false;
            }
            List<SubscriptionItem> this$subscriptionItems = this.getSubscriptionItems();
            List<SubscriptionItem> other$subscriptionItems = other.getSubscriptionItems();
            if (this$subscriptionItems == null ? other$subscriptionItems != null : !((Object)this$subscriptionItems).equals(other$subscriptionItems)) {
                return false;
            }
            Long this$trialEnd = this.getTrialEnd();
            Long other$trialEnd = other.getTrialEnd();
            if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
                return false;
            }
            Boolean this$trialFromPlan = this.getTrialFromPlan();
            Boolean other$trialFromPlan = other.getTrialFromPlan();
            return !(this$trialFromPlan == null ? other$trialFromPlan != null : !((Object)this$trialFromPlan).equals(other$trialFromPlan));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingUpdate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
            Long $expiresAt = this.getExpiresAt();
            result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
            List<SubscriptionItem> $subscriptionItems = this.getSubscriptionItems();
            result = result * 59 + ($subscriptionItems == null ? 43 : ((Object)$subscriptionItems).hashCode());
            Long $trialEnd = this.getTrialEnd();
            result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
            Boolean $trialFromPlan = this.getTrialFromPlan();
            result = result * 59 + ($trialFromPlan == null ? 43 : ((Object)$trialFromPlan).hashCode());
            return result;
        }
    }

    public static class PendingInvoiceItemInterval
    extends StripeObject {
        @SerializedName(value="interval")
        String interval;
        @SerializedName(value="interval_count")
        Long intervalCount;

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getIntervalCount() {
            return this.intervalCount;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setIntervalCount(Long intervalCount) {
            this.intervalCount = intervalCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingInvoiceItemInterval)) {
                return false;
            }
            PendingInvoiceItemInterval other = (PendingInvoiceItemInterval)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$intervalCount = this.getIntervalCount();
            Long other$intervalCount = other.getIntervalCount();
            return !(this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingInvoiceItemInterval;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $intervalCount = this.getIntervalCount();
            result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
            return result;
        }
    }

    public static class PauseCollection
    extends StripeObject {
        @SerializedName(value="behavior")
        String behavior;
        @SerializedName(value="resumes_at")
        Long resumesAt;

        @Generated
        public String getBehavior() {
            return this.behavior;
        }

        @Generated
        public Long getResumesAt() {
            return this.resumesAt;
        }

        @Generated
        public void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Generated
        public void setResumesAt(Long resumesAt) {
            this.resumesAt = resumesAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PauseCollection)) {
                return false;
            }
            PauseCollection other = (PauseCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$behavior = this.getBehavior();
            String other$behavior = other.getBehavior();
            if (this$behavior == null ? other$behavior != null : !this$behavior.equals(other$behavior)) {
                return false;
            }
            Long this$resumesAt = this.getResumesAt();
            Long other$resumesAt = other.getResumesAt();
            return !(this$resumesAt == null ? other$resumesAt != null : !((Object)this$resumesAt).equals(other$resumesAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PauseCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $behavior = this.getBehavior();
            result = result * 59 + ($behavior == null ? 43 : $behavior.hashCode());
            Long $resumesAt = this.getResumesAt();
            result = result * 59 + ($resumesAt == null ? 43 : ((Object)$resumesAt).hashCode());
            return result;
        }
    }

    public static class BillingThresholds
    extends StripeObject {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="reset_billing_cycle_anchor")
        Boolean resetBillingCycleAnchor;

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public Boolean getResetBillingCycleAnchor() {
            return this.resetBillingCycleAnchor;
        }

        @Generated
        public void setAmountGte(Long amountGte) {
            this.amountGte = amountGte;
        }

        @Generated
        public void setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingThresholds)) {
                return false;
            }
            BillingThresholds other = (BillingThresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountGte = this.getAmountGte();
            Long other$amountGte = other.getAmountGte();
            if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                return false;
            }
            Boolean this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            Boolean other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
            return !(this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !((Object)this$resetBillingCycleAnchor).equals(other$resetBillingCycleAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingThresholds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountGte = this.getAmountGte();
            result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
            Boolean $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            result = result * 59 + ($resetBillingCycleAnchor == null ? 43 : ((Object)$resetBillingCycleAnchor).hashCode());
            return result;
        }
    }
}

