/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ChargeCollection;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntentCollection;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntent
extends ApiResource
implements HasId,
MetadataStore<PaymentIntent> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_capturable")
    Long amountCapturable;
    @SerializedName(value="amount_received")
    Long amountReceived;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="capture_method")
    String captureMethod;
    @SerializedName(value="charges")
    ChargeCollection charges;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="confirmation_method")
    String confirmationMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="last_payment_error")
    StripeError lastPaymentError;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="review")
    ExpandableField<Review> review;
    @SerializedName(value="setup_future_usage")
    String setupFutureUsage;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="source")
    ExpandableField<PaymentSource> source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String id) {
        this.review = ApiResource.setExpandableFieldId(id, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review expandableObject) {
        this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
    }

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String id) {
        this.source = ApiResource.setExpandableFieldId(id, this.source);
    }

    public PaymentSource getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(PaymentSource expandableObject) {
        this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public static PaymentIntent create(Map<String, Object> params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
    }

    public static PaymentIntent retrieve(String intent) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, options);
    }

    public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent update(PaymentIntentUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentIntent update(PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent capture() throws StripeException {
        return this.capture((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent capture(RequestOptions options) throws StripeException {
        return this.capture((Map<String, Object>)null, options);
    }

    public PaymentIntent capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountCapturable() {
        return this.amountCapturable;
    }

    @Generated
    public Long getAmountReceived() {
        return this.amountReceived;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public ChargeCollection getCharges() {
        return this.charges;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public StripeError getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountCapturable(Long amountCapturable) {
        this.amountCapturable = amountCapturable;
    }

    @Generated
    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    @Generated
    public void setCharges(ChargeCollection charges) {
        this.charges = charges;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastPaymentError(StripeError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setSetupFutureUsage(String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
        this.statementDescriptorSuffix = statementDescriptorSuffix;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent other = (PaymentIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountCapturable = this.getAmountCapturable();
        Long other$amountCapturable = other.getAmountCapturable();
        if (this$amountCapturable == null ? other$amountCapturable != null : !((Object)this$amountCapturable).equals(other$amountCapturable)) {
            return false;
        }
        Long this$amountReceived = this.getAmountReceived();
        Long other$amountReceived = other.getAmountReceived();
        if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$captureMethod = this.getCaptureMethod();
        String other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
            return false;
        }
        ChargeCollection this$charges = this.getCharges();
        ChargeCollection other$charges = other.getCharges();
        if (this$charges == null ? other$charges != null : !((Object)this$charges).equals(other$charges)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$confirmationMethod = this.getConfirmationMethod();
        String other$confirmationMethod = other.getConfirmationMethod();
        if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        StripeError this$lastPaymentError = this.getLastPaymentError();
        StripeError other$lastPaymentError = other.getLastPaymentError();
        if (this$lastPaymentError == null ? other$lastPaymentError != null : !((Object)this$lastPaymentError).equals(other$lastPaymentError)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        String this$setupFutureUsage = this.getSetupFutureUsage();
        String other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountCapturable = this.getAmountCapturable();
        result = result * 59 + ($amountCapturable == null ? 43 : ((Object)$amountCapturable).hashCode());
        Long $amountReceived = this.getAmountReceived();
        result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $captureMethod = this.getCaptureMethod();
        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        ChargeCollection $charges = this.getCharges();
        result = result * 59 + ($charges == null ? 43 : ((Object)$charges).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $confirmationMethod = this.getConfirmationMethod();
        result = result * 59 + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        StripeError $lastPaymentError = this.getLastPaymentError();
        result = result * 59 + ($lastPaymentError == null ? 43 : ((Object)$lastPaymentError).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        String $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="redirect_to_url")
        NextActionRedirectToUrl redirectToUrl;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="use_stripe_sdk")
        Map<String, Object> useStripeSdk;

        @Generated
        public NextActionRedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getUseStripeSdk() {
            return this.useStripeSdk;
        }

        @Generated
        public void setRedirectToUrl(NextActionRedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUseStripeSdk(Map<String, Object> useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NextActionRedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            NextActionRedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$useStripeSdk = this.getUseStripeSdk();
            Map<String, Object> other$useStripeSdk = other.getUseStripeSdk();
            return !(this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NextActionRedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $useStripeSdk = this.getUseStripeSdk();
            result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
            return result;
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="card")
        Card card;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            return !(this$card == null ? other$card != null : !((Object)this$card).equals(other$card));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="request_three_d_secure")
            String requestThreeDSecure;

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public String getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public void setInstallments(Installments installments) {
                this.installments = installments;
            }

            @Generated
            public void setRequestThreeDSecure(String requestThreeDSecure) {
                this.requestThreeDSecure = requestThreeDSecure;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Installments this$installments = this.getInstallments();
                Installments other$installments = other.getInstallments();
                if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                    return false;
                }
                String this$requestThreeDSecure = this.getRequestThreeDSecure();
                String other$requestThreeDSecure = other.getRequestThreeDSecure();
                return !(this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Installments $installments = this.getInstallments();
                result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                String $requestThreeDSecure = this.getRequestThreeDSecure();
                result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                return result;
            }

            public static class Installments
            extends StripeObject {
                @SerializedName(value="available_plans")
                List<Plan> availablePlans;
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="plan")
                Plan plan;

                @Generated
                public List<Plan> getAvailablePlans() {
                    return this.availablePlans;
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Plan getPlan() {
                    return this.plan;
                }

                @Generated
                public void setAvailablePlans(List<Plan> availablePlans) {
                    this.availablePlans = availablePlans;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public void setPlan(Plan plan) {
                    this.plan = plan;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Installments)) {
                        return false;
                    }
                    Installments other = (Installments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<Plan> this$availablePlans = this.getAvailablePlans();
                    List<Plan> other$availablePlans = other.getAvailablePlans();
                    if (this$availablePlans == null ? other$availablePlans != null : !((Object)this$availablePlans).equals(other$availablePlans)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                        return false;
                    }
                    Plan this$plan = this.getPlan();
                    Plan other$plan = other.getPlan();
                    return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Installments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<Plan> $availablePlans = this.getAvailablePlans();
                    result = result * 59 + ($availablePlans == null ? 43 : ((Object)$availablePlans).hashCode());
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    Plan $plan = this.getPlan();
                    result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
                    return result;
                }

                public static class Plan
                extends StripeObject {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setCount(Long count) {
                        this.count = count;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Plan)) {
                            return false;
                        }
                        Plan other = (Plan)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$count = this.getCount();
                        Long other$count = other.getCount();
                        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Plan;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $count = this.getCount();
                        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class NextActionRedirectToUrl
    extends StripeObject {
        @SerializedName(value="return_url")
        String returnUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionRedirectToUrl)) {
                return false;
            }
            NextActionRedirectToUrl other = (NextActionRedirectToUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionRedirectToUrl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }
}

