// Generated by delombok at Fri Apr 10 10:13:42 PDT 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.FileCreateParams;
import com.stripe.param.FileListParams;
import java.util.Map;

public class File extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * A filename for the file, suitable for saving to a filesystem.
   */
  @SerializedName("filename")
  String filename;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  @SerializedName("links")
  FileLinkCollection links;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The purpose of the file. Possible values are {@code business_icon}, {@code business_logo},
   * {@code customer_signature}, {@code dispute_evidence}, {@code finance_report_run}, {@code
   * identity_document}, {@code pci_document}, {@code sigma_scheduled_query}, or {@code
   * tax_document_user_upload}.
   */
  @SerializedName("purpose")
  String purpose;
  /**
   * The size in bytes of the file object.
   */
  @SerializedName("size")
  Long size;
  /**
   * A user friendly title for the document.
   */
  @SerializedName("title")
  String title;
  /**
   * The type of the file returned (e.g., {@code csv}, {@code pdf}, {@code jpg}, or {@code png}).
   */
  @SerializedName("type")
  String type;
  /**
   * The URL from which the file can be downloaded using your live secret API key.
   */
  @SerializedName("url")
  String url;

  /**
   * To upload a file to Stripe, you’ll need to send a request of type {@code multipart/form-data}.
   * The request should contain the file you would like to upload, as well as the parameters for
   * creating a file.
   */
  public static File create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To upload a file to Stripe, you’ll need to send a request of type {@code multipart/form-data}.
   * The request should contain the file you would like to upload, as well as the parameters for
   * creating a file.
   */
  public static File create(FileCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To upload a file to Stripe, you’ll need to send a request of type {@code multipart/form-data}.
   * The request should contain the file you would like to upload, as well as the parameters for
   * creating a file.
   */
  public static File create(FileCreateParams params, RequestOptions options) throws StripeException {
    checkNullTypedParams(classUrl(File.class, Stripe.getUploadBase()), params);
    return create(params.toMap(), options);
  }

  /**
   * To upload a file to Stripe, you’ll need to send a request of type {@code multipart/form-data}.
   * The request should contain the file you would like to upload, as well as the parameters for
   * creating a file.
   */
  public static File create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(File.class, Stripe.getUploadBase()), params, File.class, options);
  }

  /**
   * Returns a list of the files that your account has access to. The files are returned sorted by
   * creation date, with the most recently created files appearing first.
   */
  public static FileCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * Returns a list of the files that your account has access to. The files are returned sorted by
   * creation date, with the most recently created files appearing first.
   */
  public static FileCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(File.class), params, FileCollection.class, options);
  }

  /**
   * Returns a list of the files that your account has access to. The files are returned sorted by
   * creation date, with the most recently created files appearing first.
   */
  public static FileCollection list(FileListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of the files that your account has access to. The files are returned sorted by
   * creation date, with the most recently created files appearing first.
   */
  public static FileCollection list(FileListParams params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(File.class), params, FileCollection.class, options);
  }

  /**
   * Retrieves the details of an existing file object. Supply the unique file ID from a file, and
   * Stripe will return the corresponding file object.
   */
  public static File retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing file object. Supply the unique file ID from a file, and
   * Stripe will return the corresponding file object.
   */
  public static File retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieves the details of an existing file object. Supply the unique file ID from a file, and
   * Stripe will return the corresponding file object.
   */
  public static File retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(File.class, id), params, File.class, options);
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * A filename for the file, suitable for saving to a filesystem.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFilename() {
    return this.filename;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FileLinkCollection getLinks() {
    return this.links;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The purpose of the file. Possible values are {@code business_icon}, {@code business_logo},
   * {@code customer_signature}, {@code dispute_evidence}, {@code finance_report_run}, {@code
   * identity_document}, {@code pci_document}, {@code sigma_scheduled_query}, or {@code
   * tax_document_user_upload}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPurpose() {
    return this.purpose;
  }

  /**
   * The size in bytes of the file object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSize() {
    return this.size;
  }

  /**
   * A user friendly title for the document.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTitle() {
    return this.title;
  }

  /**
   * The type of the file returned (e.g., {@code csv}, {@code pdf}, {@code jpg}, or {@code png}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The URL from which the file can be downloaded using your live secret API key.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUrl() {
    return this.url;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * A filename for the file, suitable for saving to a filesystem.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFilename(final String filename) {
    this.filename = filename;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLinks(final FileLinkCollection links) {
    this.links = links;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The purpose of the file. Possible values are {@code business_icon}, {@code business_logo},
   * {@code customer_signature}, {@code dispute_evidence}, {@code finance_report_run}, {@code
   * identity_document}, {@code pci_document}, {@code sigma_scheduled_query}, or {@code
   * tax_document_user_upload}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPurpose(final String purpose) {
    this.purpose = purpose;
  }

  /**
   * The size in bytes of the file object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSize(final Long size) {
    this.size = size;
  }

  /**
   * A user friendly title for the document.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTitle(final String title) {
    this.title = title;
  }

  /**
   * The type of the file returned (e.g., {@code csv}, {@code pdf}, {@code jpg}, or {@code png}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * The URL from which the file can be downloaded using your live secret API key.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUrl(final String url) {
    this.url = url;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof File)) return false;
    final File other = (File) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$filename = this.getFilename();
    final java.lang.Object other$filename = other.getFilename();
    if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$links = this.getLinks();
    final java.lang.Object other$links = other.getLinks();
    if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$purpose = this.getPurpose();
    final java.lang.Object other$purpose = other.getPurpose();
    if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) return false;
    final java.lang.Object this$size = this.getSize();
    final java.lang.Object other$size = other.getSize();
    if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
    final java.lang.Object this$title = this.getTitle();
    final java.lang.Object other$title = other.getTitle();
    if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$url = this.getUrl();
    final java.lang.Object other$url = other.getUrl();
    if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof File;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $filename = this.getFilename();
    result = result * PRIME + ($filename == null ? 43 : $filename.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $links = this.getLinks();
    result = result * PRIME + ($links == null ? 43 : $links.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $purpose = this.getPurpose();
    result = result * PRIME + ($purpose == null ? 43 : $purpose.hashCode());
    final java.lang.Object $size = this.getSize();
    result = result * PRIME + ($size == null ? 43 : $size.hashCode());
    final java.lang.Object $title = this.getTitle();
    result = result * PRIME + ($title == null ? 43 : $title.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $url = this.getUrl();
    result = result * PRIME + ($url == null ? 43 : $url.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
