/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.PaymentIntent;
import com.stripe.model.Plan;
import com.stripe.model.SetupIntent;
import com.stripe.model.Sku;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.checkout.SessionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.checkout.SessionCreateParams;
import com.stripe.param.checkout.SessionListParams;
import com.stripe.param.checkout.SessionRetrieveParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Session
extends ApiResource
implements HasId {
    @SerializedName(value="billing_address_collection")
    String billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="display_items")
    List<DisplayItem> displayItems;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="locale")
    String locale;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="mode")
    String mode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="setup_intent")
    ExpandableField<SetupIntent> setupIntent;
    @SerializedName(value="submit_type")
    String submitType;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="success_url")
    String successUrl;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSetupIntent() {
        return this.setupIntent != null ? this.setupIntent.getId() : null;
    }

    public void setSetupIntent(String id) {
        this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
    }

    public SetupIntent getSetupIntentObject() {
        return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
    }

    public void setSetupIntentObject(SetupIntent expandableObject) {
        this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public static SessionCollection list(Map<String, Object> params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.requestCollection(url, params, SessionCollection.class, options);
    }

    public static SessionCollection list(SessionListParams params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(SessionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.requestCollection(url, params, SessionCollection.class, options);
    }

    public static Session retrieve(String session) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Session retrieve(String session, RequestOptions options) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, options);
    }

    public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    public static Session create(Map<String, Object> params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public static Session create(SessionCreateParams params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    @Generated
    public String getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public List<DisplayItem> getDisplayItems() {
        return this.displayItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getSubmitType() {
        return this.submitType;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @Generated
    public void setBillingAddressCollection(String billingAddressCollection) {
        this.billingAddressCollection = billingAddressCollection;
    }

    @Generated
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @Generated
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @Generated
    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    @Generated
    public void setDisplayItems(List<DisplayItem> displayItems) {
        this.displayItems = displayItems;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setSubmitType(String submitType) {
        this.submitType = submitType;
    }

    @Generated
    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$billingAddressCollection = this.getBillingAddressCollection();
        String other$billingAddressCollection = other.getBillingAddressCollection();
        if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) {
            return false;
        }
        String this$cancelUrl = this.getCancelUrl();
        String other$cancelUrl = other.getCancelUrl();
        if (this$cancelUrl == null ? other$cancelUrl != null : !this$cancelUrl.equals(other$cancelUrl)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerEmail = this.getCustomerEmail();
        String other$customerEmail = other.getCustomerEmail();
        if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) {
            return false;
        }
        List<DisplayItem> this$displayItems = this.getDisplayItems();
        List<DisplayItem> other$displayItems = other.getDisplayItems();
        if (this$displayItems == null ? other$displayItems != null : !((Object)this$displayItems).equals(other$displayItems)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$setupIntent = this.getSetupIntent();
        String other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) {
            return false;
        }
        String this$submitType = this.getSubmitType();
        String other$submitType = other.getSubmitType();
        if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$successUrl = this.getSuccessUrl();
        String other$successUrl = other.getSuccessUrl();
        return !(this$successUrl == null ? other$successUrl != null : !this$successUrl.equals(other$successUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Session;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $billingAddressCollection = this.getBillingAddressCollection();
        result = result * 59 + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
        String $cancelUrl = this.getCancelUrl();
        result = result * 59 + ($cancelUrl == null ? 43 : $cancelUrl.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerEmail = this.getCustomerEmail();
        result = result * 59 + ($customerEmail == null ? 43 : $customerEmail.hashCode());
        List<DisplayItem> $displayItems = this.getDisplayItems();
        result = result * 59 + ($displayItems == null ? 43 : ((Object)$displayItems).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $setupIntent = this.getSetupIntent();
        result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        String $submitType = this.getSubmitType();
        result = result * 59 + ($submitType == null ? 43 : $submitType.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $successUrl = this.getSuccessUrl();
        result = result * 59 + ($successUrl == null ? 43 : $successUrl.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class DisplayItem
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="custom")
        Custom custom;
        @SerializedName(value="plan")
        Plan plan;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="sku")
        Sku sku;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Custom getCustom() {
            return this.custom;
        }

        @Generated
        public Plan getPlan() {
            return this.plan;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public Sku getSku() {
            return this.sku;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setCustom(Custom custom) {
            this.custom = custom;
        }

        @Generated
        public void setPlan(Plan plan) {
            this.plan = plan;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setSku(Sku sku) {
            this.sku = sku;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisplayItem)) {
                return false;
            }
            DisplayItem other = (DisplayItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            Custom this$custom = this.getCustom();
            Custom other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            Plan this$plan = this.getPlan();
            Plan other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            Sku this$sku = this.getSku();
            Sku other$sku = other.getSku();
            if (this$sku == null ? other$sku != null : !((Object)this$sku).equals(other$sku)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DisplayItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            Custom $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            Plan $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            Sku $sku = this.getSku();
            result = result * 59 + ($sku == null ? 43 : ((Object)$sku).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Custom
        extends StripeObject {
            @SerializedName(value="description")
            String description;
            @SerializedName(value="images")
            List<String> images;
            @SerializedName(value="name")
            String name;

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public List<String> getImages() {
                return this.images;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setImages(List<String> images) {
                this.images = images;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Custom)) {
                    return false;
                }
                Custom other = (Custom)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                List<String> this$images = this.getImages();
                List<String> other$images = other.getImages();
                if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Custom;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                List<String> $images = this.getImages();
                result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }
    }
}

