// Generated by delombok at Thu Mar 05 19:23:46 PST 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CountrySpecListParams;
import com.stripe.param.CountrySpecRetrieveParams;
import java.util.List;
import java.util.Map;

public class CountrySpec extends ApiResource implements HasId {
  /**
   * The default currency for this country. This applies to both payment methods and bank accounts.
   */
  @SerializedName("default_currency")
  String defaultCurrency;
  /**
   * Unique identifier for the object. Represented as the ISO country code for this country.
   */
  @SerializedName("id")
  String id;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code country_spec}.
   */
  @SerializedName("object")
  String object;
  /**
   * Currencies that can be accepted in the specific country (for transfers).
   */
  @SerializedName("supported_bank_account_currencies")
  Map<String, List<String>> supportedBankAccountCurrencies;
  /**
   * Currencies that can be accepted in the specified country (for payments).
   */
  @SerializedName("supported_payment_currencies")
  List<String> supportedPaymentCurrencies;
  /**
   * Payment methods available in the specified country. You may need to enable some payment methods
   * (e.g., <a href="https://stripe.com/docs/ach">ACH</a>) on your account before they appear in
   * this list. The {@code stripe} payment method refers to <a
   * href="https://stripe.com/docs/connect/destination-charges">charging through your platform</a>.
   */
  @SerializedName("supported_payment_methods")
  List<String> supportedPaymentMethods;
  /**
   * Countries that can accept transfers from the specified country.
   */
  @SerializedName("supported_transfer_countries")
  List<String> supportedTransferCountries;
  @SerializedName("verification_fields")
  VerificationFields verificationFields;

  /**
   * Lists all Country Spec objects available in the API.
   */
  public static CountrySpecCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Lists all Country Spec objects available in the API.
   */
  public static CountrySpecCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/country_specs");
    return ApiResource.requestCollection(url, params, CountrySpecCollection.class, options);
  }

  /**
   * Lists all Country Spec objects available in the API.
   */
  public static CountrySpecCollection list(CountrySpecListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Lists all Country Spec objects available in the API.
   */
  public static CountrySpecCollection list(CountrySpecListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/country_specs");
    return ApiResource.requestCollection(url, params, CountrySpecCollection.class, options);
  }

  /**
   * Returns a Country Spec for a given Country code.
   */
  public static CountrySpec retrieve(String country) throws StripeException {
    return retrieve(country, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Returns a Country Spec for a given Country code.
   */
  public static CountrySpec retrieve(String country, RequestOptions options) throws StripeException {
    return retrieve(country, (Map<String, Object>) null, options);
  }

  /**
   * Returns a Country Spec for a given Country code.
   */
  public static CountrySpec retrieve(String country, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/country_specs/%s", ApiResource.urlEncodeId(country)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CountrySpec.class, options);
  }

  /**
   * Returns a Country Spec for a given Country code.
   */
  public static CountrySpec retrieve(String country, CountrySpecRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/country_specs/%s", ApiResource.urlEncodeId(country)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CountrySpec.class, options);
  }


  public static class VerificationFields extends StripeObject {
    @SerializedName("company")
    Details company;
    @SerializedName("individual")
    Details individual;


    public static class Details extends StripeObject {
      /** Additional fields which are only required for some users. */
      @SerializedName("additional")
      List<String> additional;
      /** Fields which every account must eventually provide. */
      @SerializedName("minimum")
      List<String> minimum;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAdditional() {
        return this.additional;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getMinimum() {
        return this.minimum;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAdditional(final List<String> additional) {
        this.additional = additional;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMinimum(final List<String> minimum) {
        this.minimum = minimum;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CountrySpec.VerificationFields.Details)) return false;
        final CountrySpec.VerificationFields.Details other = (CountrySpec.VerificationFields.Details) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$additional = this.getAdditional();
        final java.lang.Object other$additional = other.getAdditional();
        if (this$additional == null ? other$additional != null : !this$additional.equals(other$additional)) return false;
        final java.lang.Object this$minimum = this.getMinimum();
        final java.lang.Object other$minimum = other.getMinimum();
        if (this$minimum == null ? other$minimum != null : !this$minimum.equals(other$minimum)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CountrySpec.VerificationFields.Details;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $additional = this.getAdditional();
        result = result * PRIME + ($additional == null ? 43 : $additional.hashCode());
        final java.lang.Object $minimum = this.getMinimum();
        result = result * PRIME + ($minimum == null ? 43 : $minimum.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Details getCompany() {
      return this.company;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Details getIndividual() {
      return this.individual;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCompany(final Details company) {
      this.company = company;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIndividual(final Details individual) {
      this.individual = individual;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CountrySpec.VerificationFields)) return false;
      final CountrySpec.VerificationFields other = (CountrySpec.VerificationFields) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$company = this.getCompany();
      final java.lang.Object other$company = other.getCompany();
      if (this$company == null ? other$company != null : !this$company.equals(other$company)) return false;
      final java.lang.Object this$individual = this.getIndividual();
      final java.lang.Object other$individual = other.getIndividual();
      if (this$individual == null ? other$individual != null : !this$individual.equals(other$individual)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CountrySpec.VerificationFields;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $company = this.getCompany();
      result = result * PRIME + ($company == null ? 43 : $company.hashCode());
      final java.lang.Object $individual = this.getIndividual();
      result = result * PRIME + ($individual == null ? 43 : $individual.hashCode());
      return result;
    }
  }

  /**
   * The default currency for this country. This applies to both payment methods and bank accounts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDefaultCurrency() {
    return this.defaultCurrency;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code country_spec}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Currencies that can be accepted in the specific country (for transfers).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, List<String>> getSupportedBankAccountCurrencies() {
    return this.supportedBankAccountCurrencies;
  }

  /**
   * Currencies that can be accepted in the specified country (for payments).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedPaymentCurrencies() {
    return this.supportedPaymentCurrencies;
  }

  /**
   * Payment methods available in the specified country. You may need to enable some payment methods
   * (e.g., <a href="https://stripe.com/docs/ach">ACH</a>) on your account before they appear in
   * this list. The {@code stripe} payment method refers to <a
   * href="https://stripe.com/docs/connect/destination-charges">charging through your platform</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedPaymentMethods() {
    return this.supportedPaymentMethods;
  }

  /**
   * Countries that can accept transfers from the specified country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedTransferCountries() {
    return this.supportedTransferCountries;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VerificationFields getVerificationFields() {
    return this.verificationFields;
  }

  /**
   * The default currency for this country. This applies to both payment methods and bank accounts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultCurrency(final String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }

  /**
   * Unique identifier for the object. Represented as the ISO country code for this country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code country_spec}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Currencies that can be accepted in the specific country (for transfers).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedBankAccountCurrencies(final Map<String, List<String>> supportedBankAccountCurrencies) {
    this.supportedBankAccountCurrencies = supportedBankAccountCurrencies;
  }

  /**
   * Currencies that can be accepted in the specified country (for payments).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedPaymentCurrencies(final List<String> supportedPaymentCurrencies) {
    this.supportedPaymentCurrencies = supportedPaymentCurrencies;
  }

  /**
   * Payment methods available in the specified country. You may need to enable some payment methods
   * (e.g., <a href="https://stripe.com/docs/ach">ACH</a>) on your account before they appear in
   * this list. The {@code stripe} payment method refers to <a
   * href="https://stripe.com/docs/connect/destination-charges">charging through your platform</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedPaymentMethods(final List<String> supportedPaymentMethods) {
    this.supportedPaymentMethods = supportedPaymentMethods;
  }

  /**
   * Countries that can accept transfers from the specified country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedTransferCountries(final List<String> supportedTransferCountries) {
    this.supportedTransferCountries = supportedTransferCountries;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerificationFields(final VerificationFields verificationFields) {
    this.verificationFields = verificationFields;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CountrySpec)) return false;
    final CountrySpec other = (CountrySpec) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$defaultCurrency = this.getDefaultCurrency();
    final java.lang.Object other$defaultCurrency = other.getDefaultCurrency();
    if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
    final java.lang.Object other$supportedBankAccountCurrencies = other.getSupportedBankAccountCurrencies();
    if (this$supportedBankAccountCurrencies == null ? other$supportedBankAccountCurrencies != null : !this$supportedBankAccountCurrencies.equals(other$supportedBankAccountCurrencies)) return false;
    final java.lang.Object this$supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
    final java.lang.Object other$supportedPaymentCurrencies = other.getSupportedPaymentCurrencies();
    if (this$supportedPaymentCurrencies == null ? other$supportedPaymentCurrencies != null : !this$supportedPaymentCurrencies.equals(other$supportedPaymentCurrencies)) return false;
    final java.lang.Object this$supportedPaymentMethods = this.getSupportedPaymentMethods();
    final java.lang.Object other$supportedPaymentMethods = other.getSupportedPaymentMethods();
    if (this$supportedPaymentMethods == null ? other$supportedPaymentMethods != null : !this$supportedPaymentMethods.equals(other$supportedPaymentMethods)) return false;
    final java.lang.Object this$supportedTransferCountries = this.getSupportedTransferCountries();
    final java.lang.Object other$supportedTransferCountries = other.getSupportedTransferCountries();
    if (this$supportedTransferCountries == null ? other$supportedTransferCountries != null : !this$supportedTransferCountries.equals(other$supportedTransferCountries)) return false;
    final java.lang.Object this$verificationFields = this.getVerificationFields();
    final java.lang.Object other$verificationFields = other.getVerificationFields();
    if (this$verificationFields == null ? other$verificationFields != null : !this$verificationFields.equals(other$verificationFields)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CountrySpec;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $defaultCurrency = this.getDefaultCurrency();
    result = result * PRIME + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
    result = result * PRIME + ($supportedBankAccountCurrencies == null ? 43 : $supportedBankAccountCurrencies.hashCode());
    final java.lang.Object $supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
    result = result * PRIME + ($supportedPaymentCurrencies == null ? 43 : $supportedPaymentCurrencies.hashCode());
    final java.lang.Object $supportedPaymentMethods = this.getSupportedPaymentMethods();
    result = result * PRIME + ($supportedPaymentMethods == null ? 43 : $supportedPaymentMethods.hashCode());
    final java.lang.Object $supportedTransferCountries = this.getSupportedTransferCountries();
    result = result * PRIME + ($supportedTransferCountries == null ? 43 : $supportedTransferCountries.hashCode());
    final java.lang.Object $verificationFields = this.getVerificationFields();
    result = result * PRIME + ($verificationFields == null ? 43 : $verificationFields.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object. Represented as the ISO country code for this country.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
