/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.AuthorizationCollection;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.MerchantData;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.AuthorizationApproveParams;
import com.stripe.param.issuing.AuthorizationDeclineParams;
import com.stripe.param.issuing.AuthorizationListParams;
import com.stripe.param.issuing.AuthorizationRetrieveParams;
import com.stripe.param.issuing.AuthorizationUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Authorization
extends ApiResource
implements MetadataStore<Authorization>,
BalanceTransactionSource {
    @SerializedName(value="approved")
    Boolean approved;
    @SerializedName(value="authorization_method")
    String authorizationMethod;
    @SerializedName(value="authorized_amount")
    Long authorizedAmount;
    @SerializedName(value="authorized_currency")
    String authorizedCurrency;
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="cardholder")
    ExpandableField<Cardholder> cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="held_amount")
    Long heldAmount;
    @SerializedName(value="held_currency")
    String heldCurrency;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_held_amount_controllable")
    Boolean isHeldAmountControllable;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="merchant_data")
    MerchantData merchantData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_authorized_amount")
    Long pendingAuthorizedAmount;
    @SerializedName(value="pending_held_amount")
    Long pendingHeldAmount;
    @SerializedName(value="request_history")
    List<RequestHistory> requestHistory;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transactions")
    List<Transaction> transactions;
    @SerializedName(value="verification_data")
    VerificationData verificationData;
    @SerializedName(value="wallet_provider")
    String walletProvider;

    public String getCardholder() {
        return this.cardholder != null ? this.cardholder.getId() : null;
    }

    public void setCardholder(String id) {
        this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
    }

    public Cardholder getCardholderObject() {
        return this.cardholder != null ? this.cardholder.getExpanded() : null;
    }

    public void setCardholderObject(Cardholder expandableObject) {
        this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
    }

    public static AuthorizationCollection list(Map<String, Object> params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
        return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
    }

    public static AuthorizationCollection list(AuthorizationListParams params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(AuthorizationListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
        return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
    }

    public static Authorization retrieve(String authorization) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Authorization retrieve(String authorization, RequestOptions options) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, options);
    }

    public static Authorization retrieve(String authorization, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
    }

    public static Authorization retrieve(String authorization, AuthorizationRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
    }

    public Authorization update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Authorization update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization update(AuthorizationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Authorization update(AuthorizationUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization approve() throws StripeException {
        return this.approve((Map<String, Object>)null, (RequestOptions)null);
    }

    public Authorization approve(RequestOptions options) throws StripeException {
        return this.approve((Map<String, Object>)null, options);
    }

    public Authorization approve(Map<String, Object> params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Authorization approve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization approve(AuthorizationApproveParams params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Authorization approve(AuthorizationApproveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization decline() throws StripeException {
        return this.decline((Map<String, Object>)null, (RequestOptions)null);
    }

    public Authorization decline(RequestOptions options) throws StripeException {
        return this.decline((Map<String, Object>)null, options);
    }

    public Authorization decline(Map<String, Object> params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    public Authorization decline(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization decline(AuthorizationDeclineParams params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    public Authorization decline(AuthorizationDeclineParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    @Generated
    public Boolean getApproved() {
        return this.approved;
    }

    @Generated
    public String getAuthorizationMethod() {
        return this.authorizationMethod;
    }

    @Generated
    public Long getAuthorizedAmount() {
        return this.authorizedAmount;
    }

    @Generated
    public String getAuthorizedCurrency() {
        return this.authorizedCurrency;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getHeldAmount() {
        return this.heldAmount;
    }

    @Generated
    public String getHeldCurrency() {
        return this.heldCurrency;
    }

    @Generated
    public Boolean getIsHeldAmountControllable() {
        return this.isHeldAmountControllable;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getPendingAuthorizedAmount() {
        return this.pendingAuthorizedAmount;
    }

    @Generated
    public Long getPendingHeldAmount() {
        return this.pendingHeldAmount;
    }

    @Generated
    public List<RequestHistory> getRequestHistory() {
        return this.requestHistory;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public VerificationData getVerificationData() {
        return this.verificationData;
    }

    @Generated
    public String getWalletProvider() {
        return this.walletProvider;
    }

    @Generated
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    @Generated
    public void setAuthorizationMethod(String authorizationMethod) {
        this.authorizationMethod = authorizationMethod;
    }

    @Generated
    public void setAuthorizedAmount(Long authorizedAmount) {
        this.authorizedAmount = authorizedAmount;
    }

    @Generated
    public void setAuthorizedCurrency(String authorizedCurrency) {
        this.authorizedCurrency = authorizedCurrency;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setHeldAmount(Long heldAmount) {
        this.heldAmount = heldAmount;
    }

    @Generated
    public void setHeldCurrency(String heldCurrency) {
        this.heldCurrency = heldCurrency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsHeldAmountControllable(Boolean isHeldAmountControllable) {
        this.isHeldAmountControllable = isHeldAmountControllable;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMerchantData(MerchantData merchantData) {
        this.merchantData = merchantData;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingAuthorizedAmount(Long pendingAuthorizedAmount) {
        this.pendingAuthorizedAmount = pendingAuthorizedAmount;
    }

    @Generated
    public void setPendingHeldAmount(Long pendingHeldAmount) {
        this.pendingHeldAmount = pendingHeldAmount;
    }

    @Generated
    public void setRequestHistory(List<RequestHistory> requestHistory) {
        this.requestHistory = requestHistory;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Generated
    public void setVerificationData(VerificationData verificationData) {
        this.verificationData = verificationData;
    }

    @Generated
    public void setWalletProvider(String walletProvider) {
        this.walletProvider = walletProvider;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$approved = this.getApproved();
        Boolean other$approved = other.getApproved();
        if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
            return false;
        }
        String this$authorizationMethod = this.getAuthorizationMethod();
        String other$authorizationMethod = other.getAuthorizationMethod();
        if (this$authorizationMethod == null ? other$authorizationMethod != null : !this$authorizationMethod.equals(other$authorizationMethod)) {
            return false;
        }
        Long this$authorizedAmount = this.getAuthorizedAmount();
        Long other$authorizedAmount = other.getAuthorizedAmount();
        if (this$authorizedAmount == null ? other$authorizedAmount != null : !((Object)this$authorizedAmount).equals(other$authorizedAmount)) {
            return false;
        }
        String this$authorizedCurrency = this.getAuthorizedCurrency();
        String other$authorizedCurrency = other.getAuthorizedCurrency();
        if (this$authorizedCurrency == null ? other$authorizedCurrency != null : !this$authorizedCurrency.equals(other$authorizedCurrency)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        String this$cardholder = this.getCardholder();
        String other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$heldAmount = this.getHeldAmount();
        Long other$heldAmount = other.getHeldAmount();
        if (this$heldAmount == null ? other$heldAmount != null : !((Object)this$heldAmount).equals(other$heldAmount)) {
            return false;
        }
        String this$heldCurrency = this.getHeldCurrency();
        String other$heldCurrency = other.getHeldCurrency();
        if (this$heldCurrency == null ? other$heldCurrency != null : !this$heldCurrency.equals(other$heldCurrency)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$isHeldAmountControllable = this.getIsHeldAmountControllable();
        Boolean other$isHeldAmountControllable = other.getIsHeldAmountControllable();
        if (this$isHeldAmountControllable == null ? other$isHeldAmountControllable != null : !((Object)this$isHeldAmountControllable).equals(other$isHeldAmountControllable)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        MerchantData this$merchantData = this.getMerchantData();
        MerchantData other$merchantData = other.getMerchantData();
        if (this$merchantData == null ? other$merchantData != null : !((Object)this$merchantData).equals(other$merchantData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$pendingAuthorizedAmount = this.getPendingAuthorizedAmount();
        Long other$pendingAuthorizedAmount = other.getPendingAuthorizedAmount();
        if (this$pendingAuthorizedAmount == null ? other$pendingAuthorizedAmount != null : !((Object)this$pendingAuthorizedAmount).equals(other$pendingAuthorizedAmount)) {
            return false;
        }
        Long this$pendingHeldAmount = this.getPendingHeldAmount();
        Long other$pendingHeldAmount = other.getPendingHeldAmount();
        if (this$pendingHeldAmount == null ? other$pendingHeldAmount != null : !((Object)this$pendingHeldAmount).equals(other$pendingHeldAmount)) {
            return false;
        }
        List<RequestHistory> this$requestHistory = this.getRequestHistory();
        List<RequestHistory> other$requestHistory = other.getRequestHistory();
        if (this$requestHistory == null ? other$requestHistory != null : !((Object)this$requestHistory).equals(other$requestHistory)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<Transaction> this$transactions = this.getTransactions();
        List<Transaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        VerificationData this$verificationData = this.getVerificationData();
        VerificationData other$verificationData = other.getVerificationData();
        if (this$verificationData == null ? other$verificationData != null : !((Object)this$verificationData).equals(other$verificationData)) {
            return false;
        }
        String this$walletProvider = this.getWalletProvider();
        String other$walletProvider = other.getWalletProvider();
        return !(this$walletProvider == null ? other$walletProvider != null : !this$walletProvider.equals(other$walletProvider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Authorization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $approved = this.getApproved();
        result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
        String $authorizationMethod = this.getAuthorizationMethod();
        result = result * 59 + ($authorizationMethod == null ? 43 : $authorizationMethod.hashCode());
        Long $authorizedAmount = this.getAuthorizedAmount();
        result = result * 59 + ($authorizedAmount == null ? 43 : ((Object)$authorizedAmount).hashCode());
        String $authorizedCurrency = this.getAuthorizedCurrency();
        result = result * 59 + ($authorizedCurrency == null ? 43 : $authorizedCurrency.hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        String $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : $cardholder.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $heldAmount = this.getHeldAmount();
        result = result * 59 + ($heldAmount == null ? 43 : ((Object)$heldAmount).hashCode());
        String $heldCurrency = this.getHeldCurrency();
        result = result * 59 + ($heldCurrency == null ? 43 : $heldCurrency.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $isHeldAmountControllable = this.getIsHeldAmountControllable();
        result = result * 59 + ($isHeldAmountControllable == null ? 43 : ((Object)$isHeldAmountControllable).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        MerchantData $merchantData = this.getMerchantData();
        result = result * 59 + ($merchantData == null ? 43 : ((Object)$merchantData).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $pendingAuthorizedAmount = this.getPendingAuthorizedAmount();
        result = result * 59 + ($pendingAuthorizedAmount == null ? 43 : ((Object)$pendingAuthorizedAmount).hashCode());
        Long $pendingHeldAmount = this.getPendingHeldAmount();
        result = result * 59 + ($pendingHeldAmount == null ? 43 : ((Object)$pendingHeldAmount).hashCode());
        List<RequestHistory> $requestHistory = this.getRequestHistory();
        result = result * 59 + ($requestHistory == null ? 43 : ((Object)$requestHistory).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<Transaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        VerificationData $verificationData = this.getVerificationData();
        result = result * 59 + ($verificationData == null ? 43 : ((Object)$verificationData).hashCode());
        String $walletProvider = this.getWalletProvider();
        result = result * 59 + ($walletProvider == null ? 43 : $walletProvider.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class VerificationData
    extends StripeObject {
        @SerializedName(value="address_line1_check")
        String addressLine1Check;
        @SerializedName(value="address_zip_check")
        String addressZipCheck;
        @SerializedName(value="authentication")
        String authentication;
        @SerializedName(value="cvc_check")
        String cvcCheck;
        @SerializedName(value="expiry_check")
        String expiryCheck;
        @SerializedName(value="three_d_secure")
        ThreeDSecure threeDSecure;

        @Generated
        public String getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public String getAddressZipCheck() {
            return this.addressZipCheck;
        }

        @Generated
        public String getAuthentication() {
            return this.authentication;
        }

        @Generated
        public String getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public String getExpiryCheck() {
            return this.expiryCheck;
        }

        @Generated
        public ThreeDSecure getThreeDSecure() {
            return this.threeDSecure;
        }

        @Generated
        public void setAddressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
        }

        @Generated
        public void setAddressZipCheck(String addressZipCheck) {
            this.addressZipCheck = addressZipCheck;
        }

        @Generated
        public void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Generated
        public void setCvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
        }

        @Generated
        public void setExpiryCheck(String expiryCheck) {
            this.expiryCheck = expiryCheck;
        }

        @Generated
        public void setThreeDSecure(ThreeDSecure threeDSecure) {
            this.threeDSecure = threeDSecure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationData)) {
                return false;
            }
            VerificationData other = (VerificationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addressLine1Check = this.getAddressLine1Check();
            String other$addressLine1Check = other.getAddressLine1Check();
            if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                return false;
            }
            String this$addressZipCheck = this.getAddressZipCheck();
            String other$addressZipCheck = other.getAddressZipCheck();
            if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) {
                return false;
            }
            String this$authentication = this.getAuthentication();
            String other$authentication = other.getAuthentication();
            if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
                return false;
            }
            String this$cvcCheck = this.getCvcCheck();
            String other$cvcCheck = other.getCvcCheck();
            if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
                return false;
            }
            String this$expiryCheck = this.getExpiryCheck();
            String other$expiryCheck = other.getExpiryCheck();
            if (this$expiryCheck == null ? other$expiryCheck != null : !this$expiryCheck.equals(other$expiryCheck)) {
                return false;
            }
            ThreeDSecure this$threeDSecure = this.getThreeDSecure();
            ThreeDSecure other$threeDSecure = other.getThreeDSecure();
            return !(this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerificationData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addressLine1Check = this.getAddressLine1Check();
            result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
            String $addressZipCheck = this.getAddressZipCheck();
            result = result * 59 + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
            String $authentication = this.getAuthentication();
            result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
            String $cvcCheck = this.getCvcCheck();
            result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
            String $expiryCheck = this.getExpiryCheck();
            result = result * 59 + ($expiryCheck == null ? 43 : $expiryCheck.hashCode());
            ThreeDSecure $threeDSecure = this.getThreeDSecure();
            result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
            return result;
        }
    }

    public static class ThreeDSecure
    extends StripeObject {
        @SerializedName(value="result")
        String result;

        @Generated
        public String getResult() {
            return this.result;
        }

        @Generated
        public void setResult(String result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreeDSecure)) {
                return false;
            }
            ThreeDSecure other = (ThreeDSecure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThreeDSecure;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }
    }

    public static class RequestHistory
    extends StripeObject {
        @SerializedName(value="approved")
        Boolean approved;
        @SerializedName(value="authorized_amount")
        Long authorizedAmount;
        @SerializedName(value="authorized_currency")
        String authorizedCurrency;
        @SerializedName(value="created")
        Long created;
        @SerializedName(value="held_amount")
        Long heldAmount;
        @SerializedName(value="held_currency")
        String heldCurrency;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="violated_authorization_controls")
        List<ViolatedAuthorizationControl> violatedAuthorizationControls;

        @Generated
        public Boolean getApproved() {
            return this.approved;
        }

        @Generated
        public Long getAuthorizedAmount() {
            return this.authorizedAmount;
        }

        @Generated
        public String getAuthorizedCurrency() {
            return this.authorizedCurrency;
        }

        @Generated
        public Long getCreated() {
            return this.created;
        }

        @Generated
        public Long getHeldAmount() {
            return this.heldAmount;
        }

        @Generated
        public String getHeldCurrency() {
            return this.heldCurrency;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public List<ViolatedAuthorizationControl> getViolatedAuthorizationControls() {
            return this.violatedAuthorizationControls;
        }

        @Generated
        public void setApproved(Boolean approved) {
            this.approved = approved;
        }

        @Generated
        public void setAuthorizedAmount(Long authorizedAmount) {
            this.authorizedAmount = authorizedAmount;
        }

        @Generated
        public void setAuthorizedCurrency(String authorizedCurrency) {
            this.authorizedCurrency = authorizedCurrency;
        }

        @Generated
        public void setCreated(Long created) {
            this.created = created;
        }

        @Generated
        public void setHeldAmount(Long heldAmount) {
            this.heldAmount = heldAmount;
        }

        @Generated
        public void setHeldCurrency(String heldCurrency) {
            this.heldCurrency = heldCurrency;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setViolatedAuthorizationControls(List<ViolatedAuthorizationControl> violatedAuthorizationControls) {
            this.violatedAuthorizationControls = violatedAuthorizationControls;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestHistory)) {
                return false;
            }
            RequestHistory other = (RequestHistory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$approved = this.getApproved();
            Boolean other$approved = other.getApproved();
            if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
                return false;
            }
            Long this$authorizedAmount = this.getAuthorizedAmount();
            Long other$authorizedAmount = other.getAuthorizedAmount();
            if (this$authorizedAmount == null ? other$authorizedAmount != null : !((Object)this$authorizedAmount).equals(other$authorizedAmount)) {
                return false;
            }
            String this$authorizedCurrency = this.getAuthorizedCurrency();
            String other$authorizedCurrency = other.getAuthorizedCurrency();
            if (this$authorizedCurrency == null ? other$authorizedCurrency != null : !this$authorizedCurrency.equals(other$authorizedCurrency)) {
                return false;
            }
            Long this$created = this.getCreated();
            Long other$created = other.getCreated();
            if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
                return false;
            }
            Long this$heldAmount = this.getHeldAmount();
            Long other$heldAmount = other.getHeldAmount();
            if (this$heldAmount == null ? other$heldAmount != null : !((Object)this$heldAmount).equals(other$heldAmount)) {
                return false;
            }
            String this$heldCurrency = this.getHeldCurrency();
            String other$heldCurrency = other.getHeldCurrency();
            if (this$heldCurrency == null ? other$heldCurrency != null : !this$heldCurrency.equals(other$heldCurrency)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            List<ViolatedAuthorizationControl> this$violatedAuthorizationControls = this.getViolatedAuthorizationControls();
            List<ViolatedAuthorizationControl> other$violatedAuthorizationControls = other.getViolatedAuthorizationControls();
            return !(this$violatedAuthorizationControls == null ? other$violatedAuthorizationControls != null : !((Object)this$violatedAuthorizationControls).equals(other$violatedAuthorizationControls));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestHistory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $approved = this.getApproved();
            result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
            Long $authorizedAmount = this.getAuthorizedAmount();
            result = result * 59 + ($authorizedAmount == null ? 43 : ((Object)$authorizedAmount).hashCode());
            String $authorizedCurrency = this.getAuthorizedCurrency();
            result = result * 59 + ($authorizedCurrency == null ? 43 : $authorizedCurrency.hashCode());
            Long $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
            Long $heldAmount = this.getHeldAmount();
            result = result * 59 + ($heldAmount == null ? 43 : ((Object)$heldAmount).hashCode());
            String $heldCurrency = this.getHeldCurrency();
            result = result * 59 + ($heldCurrency == null ? 43 : $heldCurrency.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            List<ViolatedAuthorizationControl> $violatedAuthorizationControls = this.getViolatedAuthorizationControls();
            result = result * 59 + ($violatedAuthorizationControls == null ? 43 : ((Object)$violatedAuthorizationControls).hashCode());
            return result;
        }

        public static class ViolatedAuthorizationControl
        extends StripeObject {
            @SerializedName(value="entity")
            String entity;
            @SerializedName(value="name")
            String name;

            @Generated
            public String getEntity() {
                return this.entity;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setEntity(String entity) {
                this.entity = entity;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ViolatedAuthorizationControl)) {
                    return false;
                }
                ViolatedAuthorizationControl other = (ViolatedAuthorizationControl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$entity = this.getEntity();
                String other$entity = other.getEntity();
                if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ViolatedAuthorizationControl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $entity = this.getEntity();
                result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }
    }
}

