// Generated by delombok at Fri Mar 13 12:29:44 PDT 2020
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderPayParams extends ApiRequestParams {
  /**
   * A fee in %s that will be applied to the order and transferred to the application owner's Stripe
   * account. The request must be made with an OAuth key or the {@code Stripe-Account} header in
   * order to take an application fee. For more information, see the application fees <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">documentation</a>.
   */
  @SerializedName("application_fee")
  Long applicationFee;
  /**
   * The ID of an existing customer that will be charged for this order. If no customer was attached
   * to the order at creation, either {@code source} or {@code customer} is required. Otherwise, the
   * specified customer will be charged instead of the one attached to the order.
   */
  @SerializedName("customer")
  String customer;
  /**
   * The email address of the customer placing the order. Required if not previously specified for
   * the order.
   */
  @SerializedName("email")
  String email;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. Individual keys can be unset by
   * posting an empty value to them. All keys can be unset by posting an empty value to {@code
   * metadata}.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * A <a href="https://stripe.com/docs/api#tokens">Token</a>'s or a <a
   * href="https://stripe.com/docs/api#sources">Source</a>'s ID, as returned by <a
   * href="https://stripe.com/docs/elements">Elements</a>. If no customer was attached to the order
   * at creation, either {@code source} or {@code customer} is required. Otherwise, the specified
   * source will be charged intead of the customer attached to the order.
   */
  @SerializedName("source")
  String source;

  private OrderPayParams(Long applicationFee, String customer, String email, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata, String source) {
    this.applicationFee = applicationFee;
    this.customer = customer;
    this.email = email;
    this.expand = expand;
    this.extraParams = extraParams;
    this.metadata = metadata;
    this.source = source;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private Long applicationFee;
    private String customer;
    private String email;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private Map<String, String> metadata;
    private String source;

    /** Finalize and obtain parameter instance from this builder. */
    public OrderPayParams build() {
      return new OrderPayParams(this.applicationFee, this.customer, this.email, this.expand, this.extraParams, this.metadata, this.source);
    }

    /**
     * A fee in %s that will be applied to the order and transferred to the application owner's
     * Stripe account. The request must be made with an OAuth key or the {@code Stripe-Account}
     * header in order to take an application fee. For more information, see the application fees <a
     * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">documentation</a>.
     */
    public Builder setApplicationFee(Long applicationFee) {
      this.applicationFee = applicationFee;
      return this;
    }

    /**
     * The ID of an existing customer that will be charged for this order. If no customer was
     * attached to the order at creation, either {@code source} or {@code customer} is required.
     * Otherwise, the specified customer will be charged instead of the one attached to the order.
     */
    public Builder setCustomer(String customer) {
      this.customer = customer;
      return this;
    }

    /**
     * The email address of the customer placing the order. Required if not previously specified for
     * the order.
     */
    public Builder setEmail(String email) {
      this.email = email;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderPayParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderPayParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * OrderPayParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link OrderPayParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * OrderPayParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link OrderPayParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }

    /**
     * A <a href="https://stripe.com/docs/api#tokens">Token</a>'s or a <a
     * href="https://stripe.com/docs/api#sources">Source</a>'s ID, as returned by <a
     * href="https://stripe.com/docs/elements">Elements</a>. If no customer was attached to the
     * order at creation, either {@code source} or {@code customer} is required. Otherwise, the
     * specified source will be charged intead of the customer attached to the order.
     */
    public Builder setSource(String source) {
      this.source = source;
      return this;
    }
  }

  /**
   * A fee in %s that will be applied to the order and transferred to the application owner's Stripe
   * account. The request must be made with an OAuth key or the {@code Stripe-Account} header in
   * order to take an application fee. For more information, see the application fees <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">documentation</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFee() {
    return this.applicationFee;
  }

  /**
   * The ID of an existing customer that will be charged for this order. If no customer was attached
   * to the order at creation, either {@code source} or {@code customer} is required. Otherwise, the
   * specified customer will be charged instead of the one attached to the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  /**
   * The email address of the customer placing the order. Required if not previously specified for
   * the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. Individual keys can be unset by
   * posting an empty value to them. All keys can be unset by posting an empty value to {@code
   * metadata}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * A <a href="https://stripe.com/docs/api#tokens">Token</a>'s or a <a
   * href="https://stripe.com/docs/api#sources">Source</a>'s ID, as returned by <a
   * href="https://stripe.com/docs/elements">Elements</a>. If no customer was attached to the order
   * at creation, either {@code source} or {@code customer} is required. Otherwise, the specified
   * source will be charged intead of the customer attached to the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSource() {
    return this.source;
  }
}
