/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.AccountCollection;
import com.stripe.model.Address;
import com.stripe.model.CapabilityCollection;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.File;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentSource;
import com.stripe.model.Person;
import com.stripe.model.PersonCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.AccountCapabilitiesParams;
import com.stripe.param.AccountCreateParams;
import com.stripe.param.AccountListParams;
import com.stripe.param.AccountPersonsParams;
import com.stripe.param.AccountRejectParams;
import com.stripe.param.AccountRetrieveParams;
import com.stripe.param.AccountUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Account
extends ApiResource
implements MetadataStore<Account>,
PaymentSource {
    @SerializedName(value="business_profile")
    BusinessProfile businessProfile;
    @SerializedName(value="business_type")
    String businessType;
    @SerializedName(value="capabilities")
    Capabilities capabilities;
    @SerializedName(value="charges_enabled")
    Boolean chargesEnabled;
    @SerializedName(value="company")
    Company company;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="default_currency")
    String defaultCurrency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="details_submitted")
    Boolean detailsSubmitted;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="external_accounts")
    ExternalAccountCollection externalAccounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="individual")
    Person individual;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payouts_enabled")
    Boolean payoutsEnabled;
    @SerializedName(value="requirements")
    Requirements requirements;
    @SerializedName(value="settings")
    Settings settings;
    @SerializedName(value="tos_acceptance")
    TosAcceptance tosAcceptance;
    @SerializedName(value="type")
    String type;

    public static Account retrieve() throws StripeException {
        return Account.retrieve((Map<String, Object>)null, (RequestOptions)null);
    }

    public static Account retrieve(RequestOptions options) throws StripeException {
        return Account.retrieve((Map<String, Object>)null, options);
    }

    public static Account retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public static Account retrieve(AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public static Account retrieve(String account) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Account retrieve(String account, RequestOptions options) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, options);
    }

    public static Account retrieve(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public static Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account update(AccountUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Account update(AccountUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
        return ApiResource.requestCollection(url, params, AccountCollection.class, options);
    }

    public static AccountCollection list(AccountListParams params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(AccountListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
        return ApiResource.requestCollection(url, params, AccountCollection.class, options);
    }

    public static Account create(Map<String, Object> params) throws StripeException {
        return Account.create(params, (RequestOptions)null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public static Account create(AccountCreateParams params) throws StripeException {
        return Account.create(params, (RequestOptions)null);
    }

    public static Account create(AccountCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account delete() throws StripeException {
        return this.delete(null, null);
    }

    public Account delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Account delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Account.class, options);
    }

    public Account reject(Map<String, Object> params) throws StripeException {
        return this.reject(params, (RequestOptions)null);
    }

    public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account reject(AccountRejectParams params) throws StripeException {
        return this.reject(params, (RequestOptions)null);
    }

    public Account reject(AccountRejectParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public PersonCollection persons() throws StripeException {
        return this.persons((Map<String, Object>)null, (RequestOptions)null);
    }

    public PersonCollection persons(Map<String, Object> params) throws StripeException {
        return this.persons(params, (RequestOptions)null);
    }

    public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, PersonCollection.class, options);
    }

    public PersonCollection persons(AccountPersonsParams params) throws StripeException {
        return this.persons(params, (RequestOptions)null);
    }

    public PersonCollection persons(AccountPersonsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, PersonCollection.class, options);
    }

    public CapabilityCollection capabilities() throws StripeException {
        return this.capabilities((Map<String, Object>)null, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(Map<String, Object> params) throws StripeException {
        return this.capabilities(params, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, CapabilityCollection.class, options);
    }

    public CapabilityCollection capabilities(AccountCapabilitiesParams params) throws StripeException {
        return this.capabilities(params, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(AccountCapabilitiesParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, CapabilityCollection.class, options);
    }

    @Generated
    public BusinessProfile getBusinessProfile() {
        return this.businessProfile;
    }

    @Generated
    public String getBusinessType() {
        return this.businessType;
    }

    @Generated
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    @Generated
    public Company getCompany() {
        return this.company;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    @Generated
    public Person getIndividual() {
        return this.individual;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getPayoutsEnabled() {
        return this.payoutsEnabled;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setBusinessProfile(BusinessProfile businessProfile) {
        this.businessProfile = businessProfile;
    }

    @Generated
    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Generated
    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Generated
    public void setChargesEnabled(Boolean chargesEnabled) {
        this.chargesEnabled = chargesEnabled;
    }

    @Generated
    public void setCompany(Company company) {
        this.company = company;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDetailsSubmitted(Boolean detailsSubmitted) {
        this.detailsSubmitted = detailsSubmitted;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setExternalAccounts(ExternalAccountCollection externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndividual(Person individual) {
        this.individual = individual;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPayoutsEnabled(Boolean payoutsEnabled) {
        this.payoutsEnabled = payoutsEnabled;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setTosAcceptance(TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BusinessProfile this$businessProfile = this.getBusinessProfile();
        BusinessProfile other$businessProfile = other.getBusinessProfile();
        if (this$businessProfile == null ? other$businessProfile != null : !((Object)this$businessProfile).equals(other$businessProfile)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        Capabilities this$capabilities = this.getCapabilities();
        Capabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        Boolean this$chargesEnabled = this.getChargesEnabled();
        Boolean other$chargesEnabled = other.getChargesEnabled();
        if (this$chargesEnabled == null ? other$chargesEnabled != null : !((Object)this$chargesEnabled).equals(other$chargesEnabled)) {
            return false;
        }
        Company this$company = this.getCompany();
        Company other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$detailsSubmitted = this.getDetailsSubmitted();
        Boolean other$detailsSubmitted = other.getDetailsSubmitted();
        if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !((Object)this$detailsSubmitted).equals(other$detailsSubmitted)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ExternalAccountCollection this$externalAccounts = this.getExternalAccounts();
        ExternalAccountCollection other$externalAccounts = other.getExternalAccounts();
        if (this$externalAccounts == null ? other$externalAccounts != null : !((Object)this$externalAccounts).equals(other$externalAccounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Person this$individual = this.getIndividual();
        Person other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Boolean this$payoutsEnabled = this.getPayoutsEnabled();
        Boolean other$payoutsEnabled = other.getPayoutsEnabled();
        if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !((Object)this$payoutsEnabled).equals(other$payoutsEnabled)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        TosAcceptance this$tosAcceptance = this.getTosAcceptance();
        TosAcceptance other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BusinessProfile $businessProfile = this.getBusinessProfile();
        result = result * 59 + ($businessProfile == null ? 43 : ((Object)$businessProfile).hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        Capabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        Boolean $chargesEnabled = this.getChargesEnabled();
        result = result * 59 + ($chargesEnabled == null ? 43 : ((Object)$chargesEnabled).hashCode());
        Company $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $detailsSubmitted = this.getDetailsSubmitted();
        result = result * 59 + ($detailsSubmitted == null ? 43 : ((Object)$detailsSubmitted).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ExternalAccountCollection $externalAccounts = this.getExternalAccounts();
        result = result * 59 + ($externalAccounts == null ? 43 : ((Object)$externalAccounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Person $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Boolean $payoutsEnabled = this.getPayoutsEnabled();
        result = result * 59 + ($payoutsEnabled == null ? 43 : ((Object)$payoutsEnabled).hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        TosAcceptance $tosAcceptance = this.getTosAcceptance();
        result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TosAcceptance
    extends StripeObject {
        @SerializedName(value="date")
        Long date;
        @SerializedName(value="ip")
        String ip;
        @SerializedName(value="user_agent")
        String userAgent;

        @Generated
        public Long getDate() {
            return this.date;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public void setDate(Long date) {
            this.date = date;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TosAcceptance)) {
                return false;
            }
            TosAcceptance other = (TosAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$date = this.getDate();
            Long other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TosAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }
    }

    public static class SettingsPayouts
    extends StripeObject {
        @SerializedName(value="debit_negative_balances")
        Boolean debitNegativeBalances;
        @SerializedName(value="schedule")
        PayoutSchedule schedule;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public Boolean getDebitNegativeBalances() {
            return this.debitNegativeBalances;
        }

        @Generated
        public PayoutSchedule getSchedule() {
            return this.schedule;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
            this.debitNegativeBalances = debitNegativeBalances;
        }

        @Generated
        public void setSchedule(PayoutSchedule schedule) {
            this.schedule = schedule;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsPayouts)) {
                return false;
            }
            SettingsPayouts other = (SettingsPayouts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
            Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
            if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
                return false;
            }
            PayoutSchedule this$schedule = this.getSchedule();
            PayoutSchedule other$schedule = other.getSchedule();
            if (this$schedule == null ? other$schedule != null : !((Object)this$schedule).equals(other$schedule)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsPayouts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
            result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
            PayoutSchedule $schedule = this.getSchedule();
            result = result * 59 + ($schedule == null ? 43 : ((Object)$schedule).hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class SettingsPayments
    extends StripeObject {
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="statement_descriptor_kana")
        String statementDescriptorKana;
        @SerializedName(value="statement_descriptor_kanji")
        String statementDescriptorKanji;

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public String getStatementDescriptorKana() {
            return this.statementDescriptorKana;
        }

        @Generated
        public String getStatementDescriptorKanji() {
            return this.statementDescriptorKanji;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public void setStatementDescriptorKana(String statementDescriptorKana) {
            this.statementDescriptorKana = statementDescriptorKana;
        }

        @Generated
        public void setStatementDescriptorKanji(String statementDescriptorKanji) {
            this.statementDescriptorKanji = statementDescriptorKanji;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsPayments)) {
                return false;
            }
            SettingsPayments other = (SettingsPayments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
                return false;
            }
            String this$statementDescriptorKana = this.getStatementDescriptorKana();
            String other$statementDescriptorKana = other.getStatementDescriptorKana();
            if (this$statementDescriptorKana == null ? other$statementDescriptorKana != null : !this$statementDescriptorKana.equals(other$statementDescriptorKana)) {
                return false;
            }
            String this$statementDescriptorKanji = this.getStatementDescriptorKanji();
            String other$statementDescriptorKanji = other.getStatementDescriptorKanji();
            return !(this$statementDescriptorKanji == null ? other$statementDescriptorKanji != null : !this$statementDescriptorKanji.equals(other$statementDescriptorKanji));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsPayments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            String $statementDescriptorKana = this.getStatementDescriptorKana();
            result = result * 59 + ($statementDescriptorKana == null ? 43 : $statementDescriptorKana.hashCode());
            String $statementDescriptorKanji = this.getStatementDescriptorKanji();
            result = result * 59 + ($statementDescriptorKanji == null ? 43 : $statementDescriptorKanji.hashCode());
            return result;
        }
    }

    public static class SettingsDashboard
    extends StripeObject {
        @SerializedName(value="display_name")
        String displayName;
        @SerializedName(value="timezone")
        String timezone;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getTimezone() {
            return this.timezone;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsDashboard)) {
                return false;
            }
            SettingsDashboard other = (SettingsDashboard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$timezone = this.getTimezone();
            String other$timezone = other.getTimezone();
            return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsDashboard;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $timezone = this.getTimezone();
            result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
            return result;
        }
    }

    public static class SettingsCardPayments
    extends StripeObject {
        @SerializedName(value="decline_on")
        DeclineChargeOn declineOn;
        @SerializedName(value="statement_descriptor_prefix")
        String statementDescriptorPrefix;

        @Generated
        public DeclineChargeOn getDeclineOn() {
            return this.declineOn;
        }

        @Generated
        public String getStatementDescriptorPrefix() {
            return this.statementDescriptorPrefix;
        }

        @Generated
        public void setDeclineOn(DeclineChargeOn declineOn) {
            this.declineOn = declineOn;
        }

        @Generated
        public void setStatementDescriptorPrefix(String statementDescriptorPrefix) {
            this.statementDescriptorPrefix = statementDescriptorPrefix;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsCardPayments)) {
                return false;
            }
            SettingsCardPayments other = (SettingsCardPayments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DeclineChargeOn this$declineOn = this.getDeclineOn();
            DeclineChargeOn other$declineOn = other.getDeclineOn();
            if (this$declineOn == null ? other$declineOn != null : !((Object)this$declineOn).equals(other$declineOn)) {
                return false;
            }
            String this$statementDescriptorPrefix = this.getStatementDescriptorPrefix();
            String other$statementDescriptorPrefix = other.getStatementDescriptorPrefix();
            return !(this$statementDescriptorPrefix == null ? other$statementDescriptorPrefix != null : !this$statementDescriptorPrefix.equals(other$statementDescriptorPrefix));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsCardPayments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DeclineChargeOn $declineOn = this.getDeclineOn();
            result = result * 59 + ($declineOn == null ? 43 : ((Object)$declineOn).hashCode());
            String $statementDescriptorPrefix = this.getStatementDescriptorPrefix();
            result = result * 59 + ($statementDescriptorPrefix == null ? 43 : $statementDescriptorPrefix.hashCode());
            return result;
        }
    }

    public static class SettingsBranding
    extends StripeObject {
        @SerializedName(value="icon")
        ExpandableField<File> icon;
        @SerializedName(value="logo")
        ExpandableField<File> logo;
        @SerializedName(value="primary_color")
        String primaryColor;
        @SerializedName(value="secondary_color")
        String secondaryColor;

        public String getIcon() {
            return this.icon != null ? this.icon.getId() : null;
        }

        public void setIcon(String id) {
            this.icon = ApiResource.setExpandableFieldId(id, this.icon);
        }

        public File getIconObject() {
            return this.icon != null ? this.icon.getExpanded() : null;
        }

        public void setIconObject(File expandableObject) {
            this.icon = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getLogo() {
            return this.logo != null ? this.logo.getId() : null;
        }

        public void setLogo(String id) {
            this.logo = ApiResource.setExpandableFieldId(id, this.logo);
        }

        public File getLogoObject() {
            return this.logo != null ? this.logo.getExpanded() : null;
        }

        public void setLogoObject(File expandableObject) {
            this.logo = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getPrimaryColor() {
            return this.primaryColor;
        }

        @Generated
        public String getSecondaryColor() {
            return this.secondaryColor;
        }

        @Generated
        public void setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
        }

        @Generated
        public void setSecondaryColor(String secondaryColor) {
            this.secondaryColor = secondaryColor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsBranding)) {
                return false;
            }
            SettingsBranding other = (SettingsBranding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$icon = this.getIcon();
            String other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$logo = this.getLogo();
            String other$logo = other.getLogo();
            if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
                return false;
            }
            String this$primaryColor = this.getPrimaryColor();
            String other$primaryColor = other.getPrimaryColor();
            if (this$primaryColor == null ? other$primaryColor != null : !this$primaryColor.equals(other$primaryColor)) {
                return false;
            }
            String this$secondaryColor = this.getSecondaryColor();
            String other$secondaryColor = other.getSecondaryColor();
            return !(this$secondaryColor == null ? other$secondaryColor != null : !this$secondaryColor.equals(other$secondaryColor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsBranding;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $logo = this.getLogo();
            result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
            String $primaryColor = this.getPrimaryColor();
            result = result * 59 + ($primaryColor == null ? 43 : $primaryColor.hashCode());
            String $secondaryColor = this.getSecondaryColor();
            result = result * 59 + ($secondaryColor == null ? 43 : $secondaryColor.hashCode());
            return result;
        }
    }

    public static class Settings
    extends StripeObject {
        @SerializedName(value="bacs_debit_payments")
        BacsDebitPayments bacsDebitPayments;
        @SerializedName(value="branding")
        SettingsBranding branding;
        @SerializedName(value="card_payments")
        SettingsCardPayments cardPayments;
        @SerializedName(value="dashboard")
        SettingsDashboard dashboard;
        @SerializedName(value="payments")
        SettingsPayments payments;
        @SerializedName(value="payouts")
        SettingsPayouts payouts;

        @Generated
        public BacsDebitPayments getBacsDebitPayments() {
            return this.bacsDebitPayments;
        }

        @Generated
        public SettingsBranding getBranding() {
            return this.branding;
        }

        @Generated
        public SettingsCardPayments getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public SettingsDashboard getDashboard() {
            return this.dashboard;
        }

        @Generated
        public SettingsPayments getPayments() {
            return this.payments;
        }

        @Generated
        public SettingsPayouts getPayouts() {
            return this.payouts;
        }

        @Generated
        public void setBacsDebitPayments(BacsDebitPayments bacsDebitPayments) {
            this.bacsDebitPayments = bacsDebitPayments;
        }

        @Generated
        public void setBranding(SettingsBranding branding) {
            this.branding = branding;
        }

        @Generated
        public void setCardPayments(SettingsCardPayments cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setDashboard(SettingsDashboard dashboard) {
            this.dashboard = dashboard;
        }

        @Generated
        public void setPayments(SettingsPayments payments) {
            this.payments = payments;
        }

        @Generated
        public void setPayouts(SettingsPayouts payouts) {
            this.payouts = payouts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BacsDebitPayments this$bacsDebitPayments = this.getBacsDebitPayments();
            BacsDebitPayments other$bacsDebitPayments = other.getBacsDebitPayments();
            if (this$bacsDebitPayments == null ? other$bacsDebitPayments != null : !((Object)this$bacsDebitPayments).equals(other$bacsDebitPayments)) {
                return false;
            }
            SettingsBranding this$branding = this.getBranding();
            SettingsBranding other$branding = other.getBranding();
            if (this$branding == null ? other$branding != null : !((Object)this$branding).equals(other$branding)) {
                return false;
            }
            SettingsCardPayments this$cardPayments = this.getCardPayments();
            SettingsCardPayments other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !((Object)this$cardPayments).equals(other$cardPayments)) {
                return false;
            }
            SettingsDashboard this$dashboard = this.getDashboard();
            SettingsDashboard other$dashboard = other.getDashboard();
            if (this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard)) {
                return false;
            }
            SettingsPayments this$payments = this.getPayments();
            SettingsPayments other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            SettingsPayouts this$payouts = this.getPayouts();
            SettingsPayouts other$payouts = other.getPayouts();
            return !(this$payouts == null ? other$payouts != null : !((Object)this$payouts).equals(other$payouts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BacsDebitPayments $bacsDebitPayments = this.getBacsDebitPayments();
            result = result * 59 + ($bacsDebitPayments == null ? 43 : ((Object)$bacsDebitPayments).hashCode());
            SettingsBranding $branding = this.getBranding();
            result = result * 59 + ($branding == null ? 43 : ((Object)$branding).hashCode());
            SettingsCardPayments $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : ((Object)$cardPayments).hashCode());
            SettingsDashboard $dashboard = this.getDashboard();
            result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
            SettingsPayments $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            SettingsPayouts $payouts = this.getPayouts();
            result = result * 59 + ($payouts == null ? 43 : ((Object)$payouts).hashCode());
            return result;
        }

        public static class BacsDebitPayments
        extends StripeObject {
            @SerializedName(value="display_name")
            String displayName;

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebitPayments)) {
                    return false;
                }
                BacsDebitPayments other = (BacsDebitPayments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebitPayments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                return result;
            }
        }
    }

    public static class Requirements
    extends StripeObject {
        @SerializedName(value="current_deadline")
        Long currentDeadline;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }
    }

    public static class PayoutSchedule
    extends StripeObject {
        @SerializedName(value="delay_days")
        Long delayDays;
        @SerializedName(value="interval")
        String interval;
        @SerializedName(value="monthly_anchor")
        Long monthlyAnchor;
        @SerializedName(value="weekly_anchor")
        String weeklyAnchor;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getMonthlyAnchor() {
            return this.monthlyAnchor;
        }

        @Generated
        public String getWeeklyAnchor() {
            return this.weeklyAnchor;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setMonthlyAnchor(Long monthlyAnchor) {
            this.monthlyAnchor = monthlyAnchor;
        }

        @Generated
        public void setWeeklyAnchor(String weeklyAnchor) {
            this.weeklyAnchor = weeklyAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayoutSchedule)) {
                return false;
            }
            PayoutSchedule other = (PayoutSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$monthlyAnchor = this.getMonthlyAnchor();
            Long other$monthlyAnchor = other.getMonthlyAnchor();
            if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                return false;
            }
            String this$weeklyAnchor = this.getWeeklyAnchor();
            String other$weeklyAnchor = other.getWeeklyAnchor();
            return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PayoutSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $monthlyAnchor = this.getMonthlyAnchor();
            result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
            String $weeklyAnchor = this.getWeeklyAnchor();
            result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
            return result;
        }
    }

    public static class DeclineChargeOn
    extends StripeObject {
        @SerializedName(value="avs_failure")
        Boolean avsFailure;
        @SerializedName(value="cvc_failure")
        Boolean cvcFailure;

        @Generated
        public Boolean getAvsFailure() {
            return this.avsFailure;
        }

        @Generated
        public Boolean getCvcFailure() {
            return this.cvcFailure;
        }

        @Generated
        public void setAvsFailure(Boolean avsFailure) {
            this.avsFailure = avsFailure;
        }

        @Generated
        public void setCvcFailure(Boolean cvcFailure) {
            this.cvcFailure = cvcFailure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclineChargeOn)) {
                return false;
            }
            DeclineChargeOn other = (DeclineChargeOn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$avsFailure = this.getAvsFailure();
            Boolean other$avsFailure = other.getAvsFailure();
            if (this$avsFailure == null ? other$avsFailure != null : !((Object)this$avsFailure).equals(other$avsFailure)) {
                return false;
            }
            Boolean this$cvcFailure = this.getCvcFailure();
            Boolean other$cvcFailure = other.getCvcFailure();
            return !(this$cvcFailure == null ? other$cvcFailure != null : !((Object)this$cvcFailure).equals(other$cvcFailure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeclineChargeOn;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $avsFailure = this.getAvsFailure();
            result = result * 59 + ($avsFailure == null ? 43 : ((Object)$avsFailure).hashCode());
            Boolean $cvcFailure = this.getCvcFailure();
            result = result * 59 + ($cvcFailure == null ? 43 : ((Object)$cvcFailure).hashCode());
            return result;
        }
    }

    public static class Company
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        Person.JapanAddress addressKana;
        @SerializedName(value="address_kanji")
        Person.JapanAddress addressKanji;
        @SerializedName(value="directors_provided")
        Boolean directorsProvided;
        @SerializedName(value="executives_provided")
        Boolean executivesProvided;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="name_kana")
        String nameKana;
        @SerializedName(value="name_kanji")
        String nameKanji;
        @SerializedName(value="owners_provided")
        Boolean ownersProvided;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="structure")
        String structure;
        @SerializedName(value="tax_id_provided")
        Boolean taxIdProvided;
        @SerializedName(value="tax_id_registrar")
        String taxIdRegistrar;
        @SerializedName(value="vat_id_provided")
        Boolean vatIdProvided;
        @SerializedName(value="verification")
        Verification verification;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Person.JapanAddress getAddressKana() {
            return this.addressKana;
        }

        @Generated
        public Person.JapanAddress getAddressKanji() {
            return this.addressKanji;
        }

        @Generated
        public Boolean getDirectorsProvided() {
            return this.directorsProvided;
        }

        @Generated
        public Boolean getExecutivesProvided() {
            return this.executivesProvided;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNameKana() {
            return this.nameKana;
        }

        @Generated
        public String getNameKanji() {
            return this.nameKanji;
        }

        @Generated
        public Boolean getOwnersProvided() {
            return this.ownersProvided;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getStructure() {
            return this.structure;
        }

        @Generated
        public Boolean getTaxIdProvided() {
            return this.taxIdProvided;
        }

        @Generated
        public String getTaxIdRegistrar() {
            return this.taxIdRegistrar;
        }

        @Generated
        public Boolean getVatIdProvided() {
            return this.vatIdProvided;
        }

        @Generated
        public Verification getVerification() {
            return this.verification;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setAddressKana(Person.JapanAddress addressKana) {
            this.addressKana = addressKana;
        }

        @Generated
        public void setAddressKanji(Person.JapanAddress addressKanji) {
            this.addressKanji = addressKanji;
        }

        @Generated
        public void setDirectorsProvided(Boolean directorsProvided) {
            this.directorsProvided = directorsProvided;
        }

        @Generated
        public void setExecutivesProvided(Boolean executivesProvided) {
            this.executivesProvided = executivesProvided;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNameKana(String nameKana) {
            this.nameKana = nameKana;
        }

        @Generated
        public void setNameKanji(String nameKanji) {
            this.nameKanji = nameKanji;
        }

        @Generated
        public void setOwnersProvided(Boolean ownersProvided) {
            this.ownersProvided = ownersProvided;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setStructure(String structure) {
            this.structure = structure;
        }

        @Generated
        public void setTaxIdProvided(Boolean taxIdProvided) {
            this.taxIdProvided = taxIdProvided;
        }

        @Generated
        public void setTaxIdRegistrar(String taxIdRegistrar) {
            this.taxIdRegistrar = taxIdRegistrar;
        }

        @Generated
        public void setVatIdProvided(Boolean vatIdProvided) {
            this.vatIdProvided = vatIdProvided;
        }

        @Generated
        public void setVerification(Verification verification) {
            this.verification = verification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Company)) {
                return false;
            }
            Company other = (Company)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Person.JapanAddress this$addressKana = this.getAddressKana();
            Person.JapanAddress other$addressKana = other.getAddressKana();
            if (this$addressKana == null ? other$addressKana != null : !((Object)this$addressKana).equals(other$addressKana)) {
                return false;
            }
            Person.JapanAddress this$addressKanji = this.getAddressKanji();
            Person.JapanAddress other$addressKanji = other.getAddressKanji();
            if (this$addressKanji == null ? other$addressKanji != null : !((Object)this$addressKanji).equals(other$addressKanji)) {
                return false;
            }
            Boolean this$directorsProvided = this.getDirectorsProvided();
            Boolean other$directorsProvided = other.getDirectorsProvided();
            if (this$directorsProvided == null ? other$directorsProvided != null : !((Object)this$directorsProvided).equals(other$directorsProvided)) {
                return false;
            }
            Boolean this$executivesProvided = this.getExecutivesProvided();
            Boolean other$executivesProvided = other.getExecutivesProvided();
            if (this$executivesProvided == null ? other$executivesProvided != null : !((Object)this$executivesProvided).equals(other$executivesProvided)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$nameKana = this.getNameKana();
            String other$nameKana = other.getNameKana();
            if (this$nameKana == null ? other$nameKana != null : !this$nameKana.equals(other$nameKana)) {
                return false;
            }
            String this$nameKanji = this.getNameKanji();
            String other$nameKanji = other.getNameKanji();
            if (this$nameKanji == null ? other$nameKanji != null : !this$nameKanji.equals(other$nameKanji)) {
                return false;
            }
            Boolean this$ownersProvided = this.getOwnersProvided();
            Boolean other$ownersProvided = other.getOwnersProvided();
            if (this$ownersProvided == null ? other$ownersProvided != null : !((Object)this$ownersProvided).equals(other$ownersProvided)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$structure = this.getStructure();
            String other$structure = other.getStructure();
            if (this$structure == null ? other$structure != null : !this$structure.equals(other$structure)) {
                return false;
            }
            Boolean this$taxIdProvided = this.getTaxIdProvided();
            Boolean other$taxIdProvided = other.getTaxIdProvided();
            if (this$taxIdProvided == null ? other$taxIdProvided != null : !((Object)this$taxIdProvided).equals(other$taxIdProvided)) {
                return false;
            }
            String this$taxIdRegistrar = this.getTaxIdRegistrar();
            String other$taxIdRegistrar = other.getTaxIdRegistrar();
            if (this$taxIdRegistrar == null ? other$taxIdRegistrar != null : !this$taxIdRegistrar.equals(other$taxIdRegistrar)) {
                return false;
            }
            Boolean this$vatIdProvided = this.getVatIdProvided();
            Boolean other$vatIdProvided = other.getVatIdProvided();
            if (this$vatIdProvided == null ? other$vatIdProvided != null : !((Object)this$vatIdProvided).equals(other$vatIdProvided)) {
                return false;
            }
            Verification this$verification = this.getVerification();
            Verification other$verification = other.getVerification();
            return !(this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Company;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Person.JapanAddress $addressKana = this.getAddressKana();
            result = result * 59 + ($addressKana == null ? 43 : ((Object)$addressKana).hashCode());
            Person.JapanAddress $addressKanji = this.getAddressKanji();
            result = result * 59 + ($addressKanji == null ? 43 : ((Object)$addressKanji).hashCode());
            Boolean $directorsProvided = this.getDirectorsProvided();
            result = result * 59 + ($directorsProvided == null ? 43 : ((Object)$directorsProvided).hashCode());
            Boolean $executivesProvided = this.getExecutivesProvided();
            result = result * 59 + ($executivesProvided == null ? 43 : ((Object)$executivesProvided).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $nameKana = this.getNameKana();
            result = result * 59 + ($nameKana == null ? 43 : $nameKana.hashCode());
            String $nameKanji = this.getNameKanji();
            result = result * 59 + ($nameKanji == null ? 43 : $nameKanji.hashCode());
            Boolean $ownersProvided = this.getOwnersProvided();
            result = result * 59 + ($ownersProvided == null ? 43 : ((Object)$ownersProvided).hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $structure = this.getStructure();
            result = result * 59 + ($structure == null ? 43 : $structure.hashCode());
            Boolean $taxIdProvided = this.getTaxIdProvided();
            result = result * 59 + ($taxIdProvided == null ? 43 : ((Object)$taxIdProvided).hashCode());
            String $taxIdRegistrar = this.getTaxIdRegistrar();
            result = result * 59 + ($taxIdRegistrar == null ? 43 : $taxIdRegistrar.hashCode());
            Boolean $vatIdProvided = this.getVatIdProvided();
            result = result * 59 + ($vatIdProvided == null ? 43 : ((Object)$vatIdProvided).hashCode());
            Verification $verification = this.getVerification();
            result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
            return result;
        }

        public static class Verification
        extends StripeObject {
            @SerializedName(value="document")
            VerificationDocument document;

            @Generated
            public VerificationDocument getDocument() {
                return this.document;
            }

            @Generated
            public void setDocument(VerificationDocument document) {
                this.document = document;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Verification)) {
                    return false;
                }
                Verification other = (Verification)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                VerificationDocument this$document = this.getDocument();
                VerificationDocument other$document = other.getDocument();
                return !(this$document == null ? other$document != null : !((Object)this$document).equals(other$document));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Verification;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                VerificationDocument $document = this.getDocument();
                result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
                return result;
            }

            public static class VerificationDocument
            extends StripeObject {
                @SerializedName(value="back")
                ExpandableField<File> back;
                @SerializedName(value="details")
                String details;
                @SerializedName(value="details_code")
                String detailsCode;
                @SerializedName(value="front")
                ExpandableField<File> front;

                public String getBack() {
                    return this.back != null ? this.back.getId() : null;
                }

                public void setBack(String id) {
                    this.back = ApiResource.setExpandableFieldId(id, this.back);
                }

                public File getBackObject() {
                    return this.back != null ? this.back.getExpanded() : null;
                }

                public void setBackObject(File expandableObject) {
                    this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                public String getFront() {
                    return this.front != null ? this.front.getId() : null;
                }

                public void setFront(String id) {
                    this.front = ApiResource.setExpandableFieldId(id, this.front);
                }

                public File getFrontObject() {
                    return this.front != null ? this.front.getExpanded() : null;
                }

                public void setFrontObject(File expandableObject) {
                    this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getDetails() {
                    return this.details;
                }

                @Generated
                public String getDetailsCode() {
                    return this.detailsCode;
                }

                @Generated
                public void setDetails(String details) {
                    this.details = details;
                }

                @Generated
                public void setDetailsCode(String detailsCode) {
                    this.detailsCode = detailsCode;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof VerificationDocument)) {
                        return false;
                    }
                    VerificationDocument other = (VerificationDocument)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$back = this.getBack();
                    String other$back = other.getBack();
                    if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
                        return false;
                    }
                    String this$details = this.getDetails();
                    String other$details = other.getDetails();
                    if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                        return false;
                    }
                    String this$detailsCode = this.getDetailsCode();
                    String other$detailsCode = other.getDetailsCode();
                    if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) {
                        return false;
                    }
                    String this$front = this.getFront();
                    String other$front = other.getFront();
                    return !(this$front == null ? other$front != null : !this$front.equals(other$front));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof VerificationDocument;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $back = this.getBack();
                    result = result * 59 + ($back == null ? 43 : $back.hashCode());
                    String $details = this.getDetails();
                    result = result * 59 + ($details == null ? 43 : $details.hashCode());
                    String $detailsCode = this.getDetailsCode();
                    result = result * 59 + ($detailsCode == null ? 43 : $detailsCode.hashCode());
                    String $front = this.getFront();
                    result = result * 59 + ($front == null ? 43 : $front.hashCode());
                    return result;
                }
            }
        }
    }

    public static class Capabilities
    extends StripeObject {
        @SerializedName(value="au_becs_debit_payments")
        String auBecsDebitPayments;
        @SerializedName(value="card_issuing")
        String cardIssuing;
        @SerializedName(value="card_payments")
        String cardPayments;
        @SerializedName(value="jcb_payments")
        String jcbPayments;
        @SerializedName(value="legacy_payments")
        String legacyPayments;
        @SerializedName(value="tax_reporting_us_1099_k")
        String taxReportingUs1099K;
        @SerializedName(value="tax_reporting_us_1099_misc")
        String taxReportingUs1099Misc;
        @SerializedName(value="transfers")
        String transfers;

        @Generated
        public String getAuBecsDebitPayments() {
            return this.auBecsDebitPayments;
        }

        @Generated
        public String getCardIssuing() {
            return this.cardIssuing;
        }

        @Generated
        public String getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public String getJcbPayments() {
            return this.jcbPayments;
        }

        @Generated
        public String getLegacyPayments() {
            return this.legacyPayments;
        }

        @Generated
        public String getTaxReportingUs1099K() {
            return this.taxReportingUs1099K;
        }

        @Generated
        public String getTaxReportingUs1099Misc() {
            return this.taxReportingUs1099Misc;
        }

        @Generated
        public String getTransfers() {
            return this.transfers;
        }

        @Generated
        public void setAuBecsDebitPayments(String auBecsDebitPayments) {
            this.auBecsDebitPayments = auBecsDebitPayments;
        }

        @Generated
        public void setCardIssuing(String cardIssuing) {
            this.cardIssuing = cardIssuing;
        }

        @Generated
        public void setCardPayments(String cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setJcbPayments(String jcbPayments) {
            this.jcbPayments = jcbPayments;
        }

        @Generated
        public void setLegacyPayments(String legacyPayments) {
            this.legacyPayments = legacyPayments;
        }

        @Generated
        public void setTaxReportingUs1099K(String taxReportingUs1099K) {
            this.taxReportingUs1099K = taxReportingUs1099K;
        }

        @Generated
        public void setTaxReportingUs1099Misc(String taxReportingUs1099Misc) {
            this.taxReportingUs1099Misc = taxReportingUs1099Misc;
        }

        @Generated
        public void setTransfers(String transfers) {
            this.transfers = transfers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities other = (Capabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$auBecsDebitPayments = this.getAuBecsDebitPayments();
            String other$auBecsDebitPayments = other.getAuBecsDebitPayments();
            if (this$auBecsDebitPayments == null ? other$auBecsDebitPayments != null : !this$auBecsDebitPayments.equals(other$auBecsDebitPayments)) {
                return false;
            }
            String this$cardIssuing = this.getCardIssuing();
            String other$cardIssuing = other.getCardIssuing();
            if (this$cardIssuing == null ? other$cardIssuing != null : !this$cardIssuing.equals(other$cardIssuing)) {
                return false;
            }
            String this$cardPayments = this.getCardPayments();
            String other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) {
                return false;
            }
            String this$jcbPayments = this.getJcbPayments();
            String other$jcbPayments = other.getJcbPayments();
            if (this$jcbPayments == null ? other$jcbPayments != null : !this$jcbPayments.equals(other$jcbPayments)) {
                return false;
            }
            String this$legacyPayments = this.getLegacyPayments();
            String other$legacyPayments = other.getLegacyPayments();
            if (this$legacyPayments == null ? other$legacyPayments != null : !this$legacyPayments.equals(other$legacyPayments)) {
                return false;
            }
            String this$taxReportingUs1099K = this.getTaxReportingUs1099K();
            String other$taxReportingUs1099K = other.getTaxReportingUs1099K();
            if (this$taxReportingUs1099K == null ? other$taxReportingUs1099K != null : !this$taxReportingUs1099K.equals(other$taxReportingUs1099K)) {
                return false;
            }
            String this$taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
            String other$taxReportingUs1099Misc = other.getTaxReportingUs1099Misc();
            if (this$taxReportingUs1099Misc == null ? other$taxReportingUs1099Misc != null : !this$taxReportingUs1099Misc.equals(other$taxReportingUs1099Misc)) {
                return false;
            }
            String this$transfers = this.getTransfers();
            String other$transfers = other.getTransfers();
            return !(this$transfers == null ? other$transfers != null : !this$transfers.equals(other$transfers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Capabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $auBecsDebitPayments = this.getAuBecsDebitPayments();
            result = result * 59 + ($auBecsDebitPayments == null ? 43 : $auBecsDebitPayments.hashCode());
            String $cardIssuing = this.getCardIssuing();
            result = result * 59 + ($cardIssuing == null ? 43 : $cardIssuing.hashCode());
            String $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : $cardPayments.hashCode());
            String $jcbPayments = this.getJcbPayments();
            result = result * 59 + ($jcbPayments == null ? 43 : $jcbPayments.hashCode());
            String $legacyPayments = this.getLegacyPayments();
            result = result * 59 + ($legacyPayments == null ? 43 : $legacyPayments.hashCode());
            String $taxReportingUs1099K = this.getTaxReportingUs1099K();
            result = result * 59 + ($taxReportingUs1099K == null ? 43 : $taxReportingUs1099K.hashCode());
            String $taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
            result = result * 59 + ($taxReportingUs1099Misc == null ? 43 : $taxReportingUs1099Misc.hashCode());
            String $transfers = this.getTransfers();
            result = result * 59 + ($transfers == null ? 43 : $transfers.hashCode());
            return result;
        }
    }

    public static class BusinessProfile
    extends StripeObject {
        @SerializedName(value="mcc")
        String mcc;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="product_description")
        String productDescription;
        @SerializedName(value="support_address")
        Address supportAddress;
        @SerializedName(value="support_email")
        String supportEmail;
        @SerializedName(value="support_phone")
        String supportPhone;
        @SerializedName(value="support_url")
        String supportUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getMcc() {
            return this.mcc;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public Address getSupportAddress() {
            return this.supportAddress;
        }

        @Generated
        public String getSupportEmail() {
            return this.supportEmail;
        }

        @Generated
        public String getSupportPhone() {
            return this.supportPhone;
        }

        @Generated
        public String getSupportUrl() {
            return this.supportUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Generated
        public void setSupportAddress(Address supportAddress) {
            this.supportAddress = supportAddress;
        }

        @Generated
        public void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Generated
        public void setSupportPhone(String supportPhone) {
            this.supportPhone = supportPhone;
        }

        @Generated
        public void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BusinessProfile)) {
                return false;
            }
            BusinessProfile other = (BusinessProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mcc = this.getMcc();
            String other$mcc = other.getMcc();
            if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$productDescription = this.getProductDescription();
            String other$productDescription = other.getProductDescription();
            if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                return false;
            }
            Address this$supportAddress = this.getSupportAddress();
            Address other$supportAddress = other.getSupportAddress();
            if (this$supportAddress == null ? other$supportAddress != null : !((Object)this$supportAddress).equals(other$supportAddress)) {
                return false;
            }
            String this$supportEmail = this.getSupportEmail();
            String other$supportEmail = other.getSupportEmail();
            if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
                return false;
            }
            String this$supportPhone = this.getSupportPhone();
            String other$supportPhone = other.getSupportPhone();
            if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
                return false;
            }
            String this$supportUrl = this.getSupportUrl();
            String other$supportUrl = other.getSupportUrl();
            if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BusinessProfile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mcc = this.getMcc();
            result = result * 59 + ($mcc == null ? 43 : $mcc.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $productDescription = this.getProductDescription();
            result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
            Address $supportAddress = this.getSupportAddress();
            result = result * 59 + ($supportAddress == null ? 43 : ((Object)$supportAddress).hashCode());
            String $supportEmail = this.getSupportEmail();
            result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
            String $supportPhone = this.getSupportPhone();
            result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
            String $supportUrl = this.getSupportUrl();
            result = result * 59 + ($supportUrl == null ? 43 : $supportUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }
}

