/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Address;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFee;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ChargeCollection;
import com.stripe.model.Customer;
import com.stripe.model.Dispute;
import com.stripe.model.ExpandableField;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.Order;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.RefundCollection;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.Transfer;
import com.stripe.model.radar.Rule;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ChargeCaptureParams;
import com.stripe.param.ChargeCreateParams;
import com.stripe.param.ChargeListParams;
import com.stripe.param.ChargeRetrieveParams;
import com.stripe.param.ChargeUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Charge
extends ApiResource
implements MetadataStore<Charge>,
BalanceTransactionSource {
    @SerializedName(value="alternate_statement_descriptors")
    AlternateStatementDescriptors alternateStatementDescriptors;
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_refunded")
    Long amountRefunded;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee")
    ExpandableField<ApplicationFee> applicationFee;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="authorization_code")
    String authorizationCode;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="billing_details")
    PaymentMethod.BillingDetails billingDetails;
    @SerializedName(value="calculated_statement_descriptor")
    String calculatedStatementDescriptor;
    @SerializedName(value="captured")
    Boolean captured;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination")
    ExpandableField<Account> destination;
    @SerializedName(value="dispute")
    ExpandableField<Dispute> dispute;
    @SerializedName(value="disputed")
    Boolean disputed;
    @SerializedName(value="failure_code")
    String failureCode;
    @SerializedName(value="failure_message")
    String failureMessage;
    @SerializedName(value="fraud_details")
    FraudDetails fraudDetails;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="level3")
    Level3 level3;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="order")
    ExpandableField<Order> order;
    @SerializedName(value="outcome")
    Outcome outcome;
    @SerializedName(value="paid")
    Boolean paid;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="receipt_number")
    String receiptNumber;
    @SerializedName(value="receipt_url")
    String receiptUrl;
    @SerializedName(value="refunded")
    Boolean refunded;
    @SerializedName(value="refunds")
    RefundCollection refunds;
    @SerializedName(value="review")
    ExpandableField<Review> review;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="source")
    PaymentSource source;
    @SerializedName(value="source_transfer")
    ExpandableField<Transfer> sourceTransfer;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer")
    ExpandableField<Transfer> transfer;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getApplicationFee() {
        return this.applicationFee != null ? this.applicationFee.getId() : null;
    }

    public void setApplicationFee(String id) {
        this.applicationFee = ApiResource.setExpandableFieldId(id, this.applicationFee);
    }

    public ApplicationFee getApplicationFeeObject() {
        return this.applicationFee != null ? this.applicationFee.getExpanded() : null;
    }

    public void setApplicationFeeObject(ApplicationFee expandableObject) {
        this.applicationFee = new ExpandableField<ApplicationFee>(expandableObject.getId(), expandableObject);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
        this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
        this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getDispute() {
        return this.dispute != null ? this.dispute.getId() : null;
    }

    public void setDispute(String id) {
        this.dispute = ApiResource.setExpandableFieldId(id, this.dispute);
    }

    public Dispute getDisputeObject() {
        return this.dispute != null ? this.dispute.getExpanded() : null;
    }

    public void setDisputeObject(Dispute expandableObject) {
        this.dispute = new ExpandableField<Dispute>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getOrder() {
        return this.order != null ? this.order.getId() : null;
    }

    public void setOrder(String id) {
        this.order = ApiResource.setExpandableFieldId(id, this.order);
    }

    public Order getOrderObject() {
        return this.order != null ? this.order.getExpanded() : null;
    }

    public void setOrderObject(Order expandableObject) {
        this.order = new ExpandableField<Order>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String id) {
        this.review = ApiResource.setExpandableFieldId(id, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review expandableObject) {
        this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
    }

    public String getSourceTransfer() {
        return this.sourceTransfer != null ? this.sourceTransfer.getId() : null;
    }

    public void setSourceTransfer(String id) {
        this.sourceTransfer = ApiResource.setExpandableFieldId(id, this.sourceTransfer);
    }

    public Transfer getSourceTransferObject() {
        return this.sourceTransfer != null ? this.sourceTransfer.getExpanded() : null;
    }

    public void setSourceTransferObject(Transfer expandableObject) {
        this.sourceTransfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
    }

    public String getTransfer() {
        return this.transfer != null ? this.transfer.getId() : null;
    }

    public void setTransfer(String id) {
        this.transfer = ApiResource.setExpandableFieldId(id, this.transfer);
    }

    public Transfer getTransferObject() {
        return this.transfer != null ? this.transfer.getExpanded() : null;
    }

    public void setTransferObject(Transfer expandableObject) {
        this.transfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
    }

    public static ChargeCollection list(Map<String, Object> params) throws StripeException {
        return Charge.list(params, (RequestOptions)null);
    }

    public static ChargeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
        return ApiResource.requestCollection(url, params, ChargeCollection.class, options);
    }

    public static ChargeCollection list(ChargeListParams params) throws StripeException {
        return Charge.list(params, (RequestOptions)null);
    }

    public static ChargeCollection list(ChargeListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
        return ApiResource.requestCollection(url, params, ChargeCollection.class, options);
    }

    public static Charge create(Map<String, Object> params) throws StripeException {
        return Charge.create(params, (RequestOptions)null);
    }

    public static Charge create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    public static Charge create(ChargeCreateParams params) throws StripeException {
        return Charge.create(params, (RequestOptions)null);
    }

    public static Charge create(ChargeCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    public static Charge retrieve(String charge) throws StripeException {
        return Charge.retrieve(charge, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Charge retrieve(String charge, RequestOptions options) throws StripeException {
        return Charge.retrieve(charge, (Map<String, Object>)null, options);
    }

    public static Charge retrieve(String charge, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Charge.class, options);
    }

    public static Charge retrieve(String charge, ChargeRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Charge.class, options);
    }

    public Charge update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Charge update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    public Charge update(ChargeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Charge update(ChargeUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    public Charge capture() throws StripeException {
        return this.capture((Map<String, Object>)null, (RequestOptions)null);
    }

    public Charge capture(RequestOptions options) throws StripeException {
        return this.capture((Map<String, Object>)null, options);
    }

    public Charge capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public Charge capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    public Charge capture(ChargeCaptureParams params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public Charge capture(ChargeCaptureParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
    }

    @Generated
    public AlternateStatementDescriptors getAlternateStatementDescriptors() {
        return this.alternateStatementDescriptors;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Generated
    public PaymentMethod.BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    @Generated
    public String getCalculatedStatementDescriptor() {
        return this.calculatedStatementDescriptor;
    }

    @Generated
    public Boolean getCaptured() {
        return this.captured;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getDisputed() {
        return this.disputed;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public FraudDetails getFraudDetails() {
        return this.fraudDetails;
    }

    @Generated
    public Level3 getLevel3() {
        return this.level3;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Outcome getOutcome() {
        return this.outcome;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    @Generated
    public Boolean getRefunded() {
        return this.refunded;
    }

    @Generated
    public RefundCollection getRefunds() {
        return this.refunds;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public PaymentSource getSource() {
        return this.source;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAlternateStatementDescriptors(AlternateStatementDescriptors alternateStatementDescriptors) {
        this.alternateStatementDescriptors = alternateStatementDescriptors;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Generated
    public void setBillingDetails(PaymentMethod.BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    @Generated
    public void setCalculatedStatementDescriptor(String calculatedStatementDescriptor) {
        this.calculatedStatementDescriptor = calculatedStatementDescriptor;
    }

    @Generated
    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDisputed(Boolean disputed) {
        this.disputed = disputed;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setFraudDetails(FraudDetails fraudDetails) {
        this.fraudDetails = fraudDetails;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLevel3(Level3 level3) {
        this.level3 = level3;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    @Generated
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    @Generated
    public void setRefunds(RefundCollection refunds) {
        this.refunds = refunds;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSource(PaymentSource source) {
        this.source = source;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
        this.statementDescriptorSuffix = statementDescriptorSuffix;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Charge)) {
            return false;
        }
        Charge other = (Charge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AlternateStatementDescriptors this$alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        AlternateStatementDescriptors other$alternateStatementDescriptors = other.getAlternateStatementDescriptors();
        if (this$alternateStatementDescriptors == null ? other$alternateStatementDescriptors != null : !((Object)this$alternateStatementDescriptors).equals(other$alternateStatementDescriptors)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountRefunded = this.getAmountRefunded();
        Long other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$applicationFee = this.getApplicationFee();
        String other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        PaymentMethod.BillingDetails this$billingDetails = this.getBillingDetails();
        PaymentMethod.BillingDetails other$billingDetails = other.getBillingDetails();
        if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
            return false;
        }
        String this$calculatedStatementDescriptor = this.getCalculatedStatementDescriptor();
        String other$calculatedStatementDescriptor = other.getCalculatedStatementDescriptor();
        if (this$calculatedStatementDescriptor == null ? other$calculatedStatementDescriptor != null : !this$calculatedStatementDescriptor.equals(other$calculatedStatementDescriptor)) {
            return false;
        }
        Boolean this$captured = this.getCaptured();
        Boolean other$captured = other.getCaptured();
        if (this$captured == null ? other$captured != null : !((Object)this$captured).equals(other$captured)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        Boolean this$disputed = this.getDisputed();
        Boolean other$disputed = other.getDisputed();
        if (this$disputed == null ? other$disputed != null : !((Object)this$disputed).equals(other$disputed)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        FraudDetails this$fraudDetails = this.getFraudDetails();
        FraudDetails other$fraudDetails = other.getFraudDetails();
        if (this$fraudDetails == null ? other$fraudDetails != null : !((Object)this$fraudDetails).equals(other$fraudDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        Level3 this$level3 = this.getLevel3();
        Level3 other$level3 = other.getLevel3();
        if (this$level3 == null ? other$level3 != null : !((Object)this$level3).equals(other$level3)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        Outcome this$outcome = this.getOutcome();
        Outcome other$outcome = other.getOutcome();
        if (this$outcome == null ? other$outcome != null : !((Object)this$outcome).equals(other$outcome)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        String this$receiptUrl = this.getReceiptUrl();
        String other$receiptUrl = other.getReceiptUrl();
        if (this$receiptUrl == null ? other$receiptUrl != null : !this$receiptUrl.equals(other$receiptUrl)) {
            return false;
        }
        Boolean this$refunded = this.getRefunded();
        Boolean other$refunded = other.getRefunded();
        if (this$refunded == null ? other$refunded != null : !((Object)this$refunded).equals(other$refunded)) {
            return false;
        }
        RefundCollection this$refunds = this.getRefunds();
        RefundCollection other$refunds = other.getRefunds();
        if (this$refunds == null ? other$refunds != null : !((Object)this$refunds).equals(other$refunds)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        PaymentSource this$source = this.getSource();
        PaymentSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$sourceTransfer = this.getSourceTransfer();
        String other$sourceTransfer = other.getSourceTransfer();
        if (this$sourceTransfer == null ? other$sourceTransfer != null : !this$sourceTransfer.equals(other$sourceTransfer)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transfer = this.getTransfer();
        String other$transfer = other.getTransfer();
        if (this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Charge;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlternateStatementDescriptors $alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        result = result * 59 + ($alternateStatementDescriptors == null ? 43 : ((Object)$alternateStatementDescriptors).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : $applicationFee.hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        PaymentMethod.BillingDetails $billingDetails = this.getBillingDetails();
        result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
        String $calculatedStatementDescriptor = this.getCalculatedStatementDescriptor();
        result = result * 59 + ($calculatedStatementDescriptor == null ? 43 : $calculatedStatementDescriptor.hashCode());
        Boolean $captured = this.getCaptured();
        result = result * 59 + ($captured == null ? 43 : ((Object)$captured).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        Boolean $disputed = this.getDisputed();
        result = result * 59 + ($disputed == null ? 43 : ((Object)$disputed).hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        FraudDetails $fraudDetails = this.getFraudDetails();
        result = result * 59 + ($fraudDetails == null ? 43 : ((Object)$fraudDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        Level3 $level3 = this.getLevel3();
        result = result * 59 + ($level3 == null ? 43 : ((Object)$level3).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        Outcome $outcome = this.getOutcome();
        result = result * 59 + ($outcome == null ? 43 : ((Object)$outcome).hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        String $receiptUrl = this.getReceiptUrl();
        result = result * 59 + ($receiptUrl == null ? 43 : $receiptUrl.hashCode());
        Boolean $refunded = this.getRefunded();
        result = result * 59 + ($refunded == null ? 43 : ((Object)$refunded).hashCode());
        RefundCollection $refunds = this.getRefunds();
        result = result * 59 + ($refunds == null ? 43 : ((Object)$refunds).hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        PaymentSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $sourceTransfer = this.getSourceTransfer();
        result = result * 59 + ($sourceTransfer == null ? 43 : $sourceTransfer.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transfer = this.getTransfer();
        result = result * 59 + ($transfer == null ? 43 : $transfer.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="ach_credit_transfer")
        AchCreditTransfer achCreditTransfer;
        @SerializedName(value="ach_debit")
        AchDebit achDebit;
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="bitcoin")
        Bitcoin bitcoin;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="multibanco")
        Multibanco multibanco;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="sepa_credit_transfer")
        SepaCreditTransfer sepaCreditTransfer;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="stripe_account")
        StripeAccount stripeAccount;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="wechat")
        Wechat wechat;

        @Generated
        public AchCreditTransfer getAchCreditTransfer() {
            return this.achCreditTransfer;
        }

        @Generated
        public AchDebit getAchDebit() {
            return this.achDebit;
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Bitcoin getBitcoin() {
            return this.bitcoin;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Multibanco getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public SepaCreditTransfer getSepaCreditTransfer() {
            return this.sepaCreditTransfer;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public StripeAccount getStripeAccount() {
            return this.stripeAccount;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Wechat getWechat() {
            return this.wechat;
        }

        @Generated
        public void setAchCreditTransfer(AchCreditTransfer achCreditTransfer) {
            this.achCreditTransfer = achCreditTransfer;
        }

        @Generated
        public void setAchDebit(AchDebit achDebit) {
            this.achDebit = achDebit;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBitcoin(Bitcoin bitcoin) {
            this.bitcoin = bitcoin;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setInteracPresent(InteracPresent interacPresent) {
            this.interacPresent = interacPresent;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setMultibanco(Multibanco multibanco) {
            this.multibanco = multibanco;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setSepaCreditTransfer(SepaCreditTransfer sepaCreditTransfer) {
            this.sepaCreditTransfer = sepaCreditTransfer;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setStripeAccount(StripeAccount stripeAccount) {
            this.stripeAccount = stripeAccount;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setWechat(Wechat wechat) {
            this.wechat = wechat;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AchCreditTransfer this$achCreditTransfer = this.getAchCreditTransfer();
            AchCreditTransfer other$achCreditTransfer = other.getAchCreditTransfer();
            if (this$achCreditTransfer == null ? other$achCreditTransfer != null : !((Object)this$achCreditTransfer).equals(other$achCreditTransfer)) {
                return false;
            }
            AchDebit this$achDebit = this.getAchDebit();
            AchDebit other$achDebit = other.getAchDebit();
            if (this$achDebit == null ? other$achDebit != null : !((Object)this$achDebit).equals(other$achDebit)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Bitcoin this$bitcoin = this.getBitcoin();
            Bitcoin other$bitcoin = other.getBitcoin();
            if (this$bitcoin == null ? other$bitcoin != null : !((Object)this$bitcoin).equals(other$bitcoin)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Multibanco this$multibanco = this.getMultibanco();
            Multibanco other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            SepaCreditTransfer this$sepaCreditTransfer = this.getSepaCreditTransfer();
            SepaCreditTransfer other$sepaCreditTransfer = other.getSepaCreditTransfer();
            if (this$sepaCreditTransfer == null ? other$sepaCreditTransfer != null : !((Object)this$sepaCreditTransfer).equals(other$sepaCreditTransfer)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            StripeAccount this$stripeAccount = this.getStripeAccount();
            StripeAccount other$stripeAccount = other.getStripeAccount();
            if (this$stripeAccount == null ? other$stripeAccount != null : !((Object)this$stripeAccount).equals(other$stripeAccount)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Wechat this$wechat = this.getWechat();
            Wechat other$wechat = other.getWechat();
            return !(this$wechat == null ? other$wechat != null : !((Object)this$wechat).equals(other$wechat));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AchCreditTransfer $achCreditTransfer = this.getAchCreditTransfer();
            result = result * 59 + ($achCreditTransfer == null ? 43 : ((Object)$achCreditTransfer).hashCode());
            AchDebit $achDebit = this.getAchDebit();
            result = result * 59 + ($achDebit == null ? 43 : ((Object)$achDebit).hashCode());
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Bitcoin $bitcoin = this.getBitcoin();
            result = result * 59 + ($bitcoin == null ? 43 : ((Object)$bitcoin).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Multibanco $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            SepaCreditTransfer $sepaCreditTransfer = this.getSepaCreditTransfer();
            result = result * 59 + ($sepaCreditTransfer == null ? 43 : ((Object)$sepaCreditTransfer).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            StripeAccount $stripeAccount = this.getStripeAccount();
            result = result * 59 + ($stripeAccount == null ? 43 : ((Object)$stripeAccount).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Wechat $wechat = this.getWechat();
            result = result * 59 + ($wechat == null ? 43 : ((Object)$wechat).hashCode());
            return result;
        }

        public static class Wechat
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Wechat)) {
                    return false;
                }
                Wechat other = (Wechat)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Wechat;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class StripeAccount
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StripeAccount)) {
                    return false;
                }
                StripeAccount other = (StripeAccount)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StripeAccount;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="branch_code")
            String branchCode;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBranchCode() {
                return this.branchCode;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBranchCode(String branchCode) {
                this.branchCode = branchCode;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$branchCode = this.getBranchCode();
                String other$branchCode = other.getBranchCode();
                if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                return !(this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $branchCode = this.getBranchCode();
                result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                return result;
            }
        }

        public static class SepaCreditTransfer
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="iban")
            String iban;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIban() {
                return this.iban;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIban(String iban) {
                this.iban = iban;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaCreditTransfer)) {
                    return false;
                }
                SepaCreditTransfer other = (SepaCreditTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$iban = this.getIban();
                String other$iban = other.getIban();
                return !(this$iban == null ? other$iban != null : !this$iban.equals(other$iban));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaCreditTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $iban = this.getIban();
                result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Multibanco
        extends StripeObject {
            @SerializedName(value="entity")
            String entity;
            @SerializedName(value="reference")
            String reference;

            @Generated
            public String getEntity() {
                return this.entity;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public void setEntity(String entity) {
                this.entity = entity;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$entity = this.getEntity();
                String other$entity = other.getEntity();
                if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $entity = this.getEntity();
                result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class InteracPresent
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="emv_auth_data")
            String emvAuthData;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="read_method")
            String readMethod;
            @SerializedName(value="receipt")
            Receipt receipt;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getEmvAuthData() {
                return this.emvAuthData;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public Receipt getReceipt() {
                return this.receipt;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setEmvAuthData(String emvAuthData) {
                this.emvAuthData = emvAuthData;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public void setReceipt(Receipt receipt) {
                this.receipt = receipt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$emvAuthData = this.getEmvAuthData();
                String other$emvAuthData = other.getEmvAuthData();
                if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                    return false;
                }
                Receipt this$receipt = this.getReceipt();
                Receipt other$receipt = other.getReceipt();
                return !(this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $emvAuthData = this.getEmvAuthData();
                result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                Receipt $receipt = this.getReceipt();
                result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
                return result;
            }

            public static class Receipt
            extends StripeObject {
                @SerializedName(value="account_type")
                String accountType;
                @SerializedName(value="application_cryptogram")
                String applicationCryptogram;
                @SerializedName(value="application_preferred_name")
                String applicationPreferredName;
                @SerializedName(value="authorization_code")
                String authorizationCode;
                @SerializedName(value="authorization_response_code")
                String authorizationResponseCode;
                @SerializedName(value="cardholder_verification_method")
                String cardholderVerificationMethod;
                @SerializedName(value="dedicated_file_name")
                String dedicatedFileName;
                @SerializedName(value="terminal_verification_results")
                String terminalVerificationResults;
                @SerializedName(value="transaction_status_information")
                String transactionStatusInformation;

                @Generated
                public String getAccountType() {
                    return this.accountType;
                }

                @Generated
                public String getApplicationCryptogram() {
                    return this.applicationCryptogram;
                }

                @Generated
                public String getApplicationPreferredName() {
                    return this.applicationPreferredName;
                }

                @Generated
                public String getAuthorizationCode() {
                    return this.authorizationCode;
                }

                @Generated
                public String getAuthorizationResponseCode() {
                    return this.authorizationResponseCode;
                }

                @Generated
                public String getCardholderVerificationMethod() {
                    return this.cardholderVerificationMethod;
                }

                @Generated
                public String getDedicatedFileName() {
                    return this.dedicatedFileName;
                }

                @Generated
                public String getTerminalVerificationResults() {
                    return this.terminalVerificationResults;
                }

                @Generated
                public String getTransactionStatusInformation() {
                    return this.transactionStatusInformation;
                }

                @Generated
                public void setAccountType(String accountType) {
                    this.accountType = accountType;
                }

                @Generated
                public void setApplicationCryptogram(String applicationCryptogram) {
                    this.applicationCryptogram = applicationCryptogram;
                }

                @Generated
                public void setApplicationPreferredName(String applicationPreferredName) {
                    this.applicationPreferredName = applicationPreferredName;
                }

                @Generated
                public void setAuthorizationCode(String authorizationCode) {
                    this.authorizationCode = authorizationCode;
                }

                @Generated
                public void setAuthorizationResponseCode(String authorizationResponseCode) {
                    this.authorizationResponseCode = authorizationResponseCode;
                }

                @Generated
                public void setCardholderVerificationMethod(String cardholderVerificationMethod) {
                    this.cardholderVerificationMethod = cardholderVerificationMethod;
                }

                @Generated
                public void setDedicatedFileName(String dedicatedFileName) {
                    this.dedicatedFileName = dedicatedFileName;
                }

                @Generated
                public void setTerminalVerificationResults(String terminalVerificationResults) {
                    this.terminalVerificationResults = terminalVerificationResults;
                }

                @Generated
                public void setTransactionStatusInformation(String transactionStatusInformation) {
                    this.transactionStatusInformation = transactionStatusInformation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Receipt)) {
                        return false;
                    }
                    Receipt other = (Receipt)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$accountType = this.getAccountType();
                    String other$accountType = other.getAccountType();
                    if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                        return false;
                    }
                    String this$applicationCryptogram = this.getApplicationCryptogram();
                    String other$applicationCryptogram = other.getApplicationCryptogram();
                    if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                        return false;
                    }
                    String this$applicationPreferredName = this.getApplicationPreferredName();
                    String other$applicationPreferredName = other.getApplicationPreferredName();
                    if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                        return false;
                    }
                    String this$authorizationCode = this.getAuthorizationCode();
                    String other$authorizationCode = other.getAuthorizationCode();
                    if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                        return false;
                    }
                    String this$authorizationResponseCode = this.getAuthorizationResponseCode();
                    String other$authorizationResponseCode = other.getAuthorizationResponseCode();
                    if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                        return false;
                    }
                    String this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    String other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
                    if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) {
                        return false;
                    }
                    String this$dedicatedFileName = this.getDedicatedFileName();
                    String other$dedicatedFileName = other.getDedicatedFileName();
                    if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                        return false;
                    }
                    String this$terminalVerificationResults = this.getTerminalVerificationResults();
                    String other$terminalVerificationResults = other.getTerminalVerificationResults();
                    if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                        return false;
                    }
                    String this$transactionStatusInformation = this.getTransactionStatusInformation();
                    String other$transactionStatusInformation = other.getTransactionStatusInformation();
                    return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Receipt;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $accountType = this.getAccountType();
                    result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                    String $applicationCryptogram = this.getApplicationCryptogram();
                    result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
                    String $applicationPreferredName = this.getApplicationPreferredName();
                    result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
                    String $authorizationCode = this.getAuthorizationCode();
                    result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
                    String $authorizationResponseCode = this.getAuthorizationResponseCode();
                    result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
                    String $cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    result = result * 59 + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
                    String $dedicatedFileName = this.getDedicatedFileName();
                    result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
                    String $terminalVerificationResults = this.getTerminalVerificationResults();
                    result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
                    String $transactionStatusInformation = this.getTransactionStatusInformation();
                    result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
                    return result;
                }
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="emv_auth_data")
            String emvAuthData;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="read_method")
            String readMethod;
            @SerializedName(value="receipt")
            Receipt receipt;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getEmvAuthData() {
                return this.emvAuthData;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public Receipt getReceipt() {
                return this.receipt;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setEmvAuthData(String emvAuthData) {
                this.emvAuthData = emvAuthData;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public void setReceipt(Receipt receipt) {
                this.receipt = receipt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$emvAuthData = this.getEmvAuthData();
                String other$emvAuthData = other.getEmvAuthData();
                if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                    return false;
                }
                Receipt this$receipt = this.getReceipt();
                Receipt other$receipt = other.getReceipt();
                return !(this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $emvAuthData = this.getEmvAuthData();
                result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                Receipt $receipt = this.getReceipt();
                result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
                return result;
            }

            public static class Receipt
            extends StripeObject {
                @SerializedName(value="application_cryptogram")
                String applicationCryptogram;
                @SerializedName(value="application_preferred_name")
                String applicationPreferredName;
                @SerializedName(value="authorization_code")
                String authorizationCode;
                @SerializedName(value="authorization_response_code")
                String authorizationResponseCode;
                @SerializedName(value="cardholder_verification_method")
                String cardholderVerificationMethod;
                @SerializedName(value="dedicated_file_name")
                String dedicatedFileName;
                @SerializedName(value="terminal_verification_results")
                String terminalVerificationResults;
                @SerializedName(value="transaction_status_information")
                String transactionStatusInformation;

                @Generated
                public String getApplicationCryptogram() {
                    return this.applicationCryptogram;
                }

                @Generated
                public String getApplicationPreferredName() {
                    return this.applicationPreferredName;
                }

                @Generated
                public String getAuthorizationCode() {
                    return this.authorizationCode;
                }

                @Generated
                public String getAuthorizationResponseCode() {
                    return this.authorizationResponseCode;
                }

                @Generated
                public String getCardholderVerificationMethod() {
                    return this.cardholderVerificationMethod;
                }

                @Generated
                public String getDedicatedFileName() {
                    return this.dedicatedFileName;
                }

                @Generated
                public String getTerminalVerificationResults() {
                    return this.terminalVerificationResults;
                }

                @Generated
                public String getTransactionStatusInformation() {
                    return this.transactionStatusInformation;
                }

                @Generated
                public void setApplicationCryptogram(String applicationCryptogram) {
                    this.applicationCryptogram = applicationCryptogram;
                }

                @Generated
                public void setApplicationPreferredName(String applicationPreferredName) {
                    this.applicationPreferredName = applicationPreferredName;
                }

                @Generated
                public void setAuthorizationCode(String authorizationCode) {
                    this.authorizationCode = authorizationCode;
                }

                @Generated
                public void setAuthorizationResponseCode(String authorizationResponseCode) {
                    this.authorizationResponseCode = authorizationResponseCode;
                }

                @Generated
                public void setCardholderVerificationMethod(String cardholderVerificationMethod) {
                    this.cardholderVerificationMethod = cardholderVerificationMethod;
                }

                @Generated
                public void setDedicatedFileName(String dedicatedFileName) {
                    this.dedicatedFileName = dedicatedFileName;
                }

                @Generated
                public void setTerminalVerificationResults(String terminalVerificationResults) {
                    this.terminalVerificationResults = terminalVerificationResults;
                }

                @Generated
                public void setTransactionStatusInformation(String transactionStatusInformation) {
                    this.transactionStatusInformation = transactionStatusInformation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Receipt)) {
                        return false;
                    }
                    Receipt other = (Receipt)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$applicationCryptogram = this.getApplicationCryptogram();
                    String other$applicationCryptogram = other.getApplicationCryptogram();
                    if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                        return false;
                    }
                    String this$applicationPreferredName = this.getApplicationPreferredName();
                    String other$applicationPreferredName = other.getApplicationPreferredName();
                    if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                        return false;
                    }
                    String this$authorizationCode = this.getAuthorizationCode();
                    String other$authorizationCode = other.getAuthorizationCode();
                    if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                        return false;
                    }
                    String this$authorizationResponseCode = this.getAuthorizationResponseCode();
                    String other$authorizationResponseCode = other.getAuthorizationResponseCode();
                    if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                        return false;
                    }
                    String this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    String other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
                    if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) {
                        return false;
                    }
                    String this$dedicatedFileName = this.getDedicatedFileName();
                    String other$dedicatedFileName = other.getDedicatedFileName();
                    if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                        return false;
                    }
                    String this$terminalVerificationResults = this.getTerminalVerificationResults();
                    String other$terminalVerificationResults = other.getTerminalVerificationResults();
                    if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                        return false;
                    }
                    String this$transactionStatusInformation = this.getTransactionStatusInformation();
                    String other$transactionStatusInformation = other.getTransactionStatusInformation();
                    return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Receipt;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $applicationCryptogram = this.getApplicationCryptogram();
                    result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
                    String $applicationPreferredName = this.getApplicationPreferredName();
                    result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
                    String $authorizationCode = this.getAuthorizationCode();
                    result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
                    String $authorizationResponseCode = this.getAuthorizationResponseCode();
                    result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
                    String $cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    result = result * 59 + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
                    String $dedicatedFileName = this.getDedicatedFileName();
                    result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
                    String $terminalVerificationResults = this.getTerminalVerificationResults();
                    result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
                    String $transactionStatusInformation = this.getTransactionStatusInformation();
                    result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
                    return result;
                }
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="checks")
            Checks checks;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="three_d_secure")
            ThreeDSecure threeDSecure;
            @SerializedName(value="wallet")
            Wallet wallet;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public Checks getChecks() {
                return this.checks;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Boolean getMoto() {
                return this.moto;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public ThreeDSecure getThreeDSecure() {
                return this.threeDSecure;
            }

            @Generated
            public Wallet getWallet() {
                return this.wallet;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setChecks(Checks checks) {
                this.checks = checks;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setInstallments(Installments installments) {
                this.installments = installments;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMoto(Boolean moto) {
                this.moto = moto;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setThreeDSecure(ThreeDSecure threeDSecure) {
                this.threeDSecure = threeDSecure;
            }

            @Generated
            public void setWallet(Wallet wallet) {
                this.wallet = wallet;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                Checks this$checks = this.getChecks();
                Checks other$checks = other.getChecks();
                if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                Installments this$installments = this.getInstallments();
                Installments other$installments = other.getInstallments();
                if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                Boolean this$moto = this.getMoto();
                Boolean other$moto = other.getMoto();
                if (this$moto == null ? other$moto != null : !((Object)this$moto).equals(other$moto)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                ThreeDSecure this$threeDSecure = this.getThreeDSecure();
                ThreeDSecure other$threeDSecure = other.getThreeDSecure();
                if (this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure)) {
                    return false;
                }
                Wallet this$wallet = this.getWallet();
                Wallet other$wallet = other.getWallet();
                return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                Checks $checks = this.getChecks();
                result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                Installments $installments = this.getInstallments();
                result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                Boolean $moto = this.getMoto();
                result = result * 59 + ($moto == null ? 43 : ((Object)$moto).hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                ThreeDSecure $threeDSecure = this.getThreeDSecure();
                result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
                Wallet $wallet = this.getWallet();
                result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                return result;
            }

            public static class Wallet
            extends StripeObject {
                @SerializedName(value="amex_express_checkout")
                AmexExpressCheckout amexExpressCheckout;
                @SerializedName(value="apple_pay")
                ApplePay applePay;
                @SerializedName(value="dynamic_last4")
                String dynamicLast4;
                @SerializedName(value="google_pay")
                GooglePay googlePay;
                @SerializedName(value="masterpass")
                Masterpass masterpass;
                @SerializedName(value="samsung_pay")
                SamsungPay samsungPay;
                @SerializedName(value="type")
                String type;
                @SerializedName(value="visa_checkout")
                VisaCheckout visaCheckout;

                @Generated
                public AmexExpressCheckout getAmexExpressCheckout() {
                    return this.amexExpressCheckout;
                }

                @Generated
                public ApplePay getApplePay() {
                    return this.applePay;
                }

                @Generated
                public String getDynamicLast4() {
                    return this.dynamicLast4;
                }

                @Generated
                public GooglePay getGooglePay() {
                    return this.googlePay;
                }

                @Generated
                public Masterpass getMasterpass() {
                    return this.masterpass;
                }

                @Generated
                public SamsungPay getSamsungPay() {
                    return this.samsungPay;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public VisaCheckout getVisaCheckout() {
                    return this.visaCheckout;
                }

                @Generated
                public void setAmexExpressCheckout(AmexExpressCheckout amexExpressCheckout) {
                    this.amexExpressCheckout = amexExpressCheckout;
                }

                @Generated
                public void setApplePay(ApplePay applePay) {
                    this.applePay = applePay;
                }

                @Generated
                public void setDynamicLast4(String dynamicLast4) {
                    this.dynamicLast4 = dynamicLast4;
                }

                @Generated
                public void setGooglePay(GooglePay googlePay) {
                    this.googlePay = googlePay;
                }

                @Generated
                public void setMasterpass(Masterpass masterpass) {
                    this.masterpass = masterpass;
                }

                @Generated
                public void setSamsungPay(SamsungPay samsungPay) {
                    this.samsungPay = samsungPay;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public void setVisaCheckout(VisaCheckout visaCheckout) {
                    this.visaCheckout = visaCheckout;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Wallet)) {
                        return false;
                    }
                    Wallet other = (Wallet)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    AmexExpressCheckout this$amexExpressCheckout = this.getAmexExpressCheckout();
                    AmexExpressCheckout other$amexExpressCheckout = other.getAmexExpressCheckout();
                    if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !((Object)this$amexExpressCheckout).equals(other$amexExpressCheckout)) {
                        return false;
                    }
                    ApplePay this$applePay = this.getApplePay();
                    ApplePay other$applePay = other.getApplePay();
                    if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                        return false;
                    }
                    String this$dynamicLast4 = this.getDynamicLast4();
                    String other$dynamicLast4 = other.getDynamicLast4();
                    if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                        return false;
                    }
                    GooglePay this$googlePay = this.getGooglePay();
                    GooglePay other$googlePay = other.getGooglePay();
                    if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                        return false;
                    }
                    Masterpass this$masterpass = this.getMasterpass();
                    Masterpass other$masterpass = other.getMasterpass();
                    if (this$masterpass == null ? other$masterpass != null : !((Object)this$masterpass).equals(other$masterpass)) {
                        return false;
                    }
                    SamsungPay this$samsungPay = this.getSamsungPay();
                    SamsungPay other$samsungPay = other.getSamsungPay();
                    if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                        return false;
                    }
                    VisaCheckout this$visaCheckout = this.getVisaCheckout();
                    VisaCheckout other$visaCheckout = other.getVisaCheckout();
                    return !(this$visaCheckout == null ? other$visaCheckout != null : !((Object)this$visaCheckout).equals(other$visaCheckout));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Wallet;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    AmexExpressCheckout $amexExpressCheckout = this.getAmexExpressCheckout();
                    result = result * 59 + ($amexExpressCheckout == null ? 43 : ((Object)$amexExpressCheckout).hashCode());
                    ApplePay $applePay = this.getApplePay();
                    result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
                    String $dynamicLast4 = this.getDynamicLast4();
                    result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
                    GooglePay $googlePay = this.getGooglePay();
                    result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
                    Masterpass $masterpass = this.getMasterpass();
                    result = result * 59 + ($masterpass == null ? 43 : ((Object)$masterpass).hashCode());
                    SamsungPay $samsungPay = this.getSamsungPay();
                    result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    VisaCheckout $visaCheckout = this.getVisaCheckout();
                    result = result * 59 + ($visaCheckout == null ? 43 : ((Object)$visaCheckout).hashCode());
                    return result;
                }

                public static class VisaCheckout
                extends StripeObject {
                    @SerializedName(value="billing_address")
                    Address billingAddress;
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="shipping_address")
                    Address shippingAddress;

                    @Generated
                    public Address getBillingAddress() {
                        return this.billingAddress;
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public Address getShippingAddress() {
                        return this.shippingAddress;
                    }

                    @Generated
                    public void setBillingAddress(Address billingAddress) {
                        this.billingAddress = billingAddress;
                    }

                    @Generated
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    @Generated
                    public void setName(String name) {
                        this.name = name;
                    }

                    @Generated
                    public void setShippingAddress(Address shippingAddress) {
                        this.shippingAddress = shippingAddress;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof VisaCheckout)) {
                            return false;
                        }
                        VisaCheckout other = (VisaCheckout)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Address this$billingAddress = this.getBillingAddress();
                        Address other$billingAddress = other.getBillingAddress();
                        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        Address this$shippingAddress = this.getShippingAddress();
                        Address other$shippingAddress = other.getShippingAddress();
                        return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof VisaCheckout;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Address $billingAddress = this.getBillingAddress();
                        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        Address $shippingAddress = this.getShippingAddress();
                        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                        return result;
                    }
                }

                public static class SamsungPay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SamsungPay)) {
                            return false;
                        }
                        SamsungPay other = (SamsungPay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SamsungPay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class Masterpass
                extends StripeObject {
                    @SerializedName(value="billing_address")
                    Address billingAddress;
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="shipping_address")
                    Address shippingAddress;

                    @Generated
                    public Address getBillingAddress() {
                        return this.billingAddress;
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public Address getShippingAddress() {
                        return this.shippingAddress;
                    }

                    @Generated
                    public void setBillingAddress(Address billingAddress) {
                        this.billingAddress = billingAddress;
                    }

                    @Generated
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    @Generated
                    public void setName(String name) {
                        this.name = name;
                    }

                    @Generated
                    public void setShippingAddress(Address shippingAddress) {
                        this.shippingAddress = shippingAddress;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Masterpass)) {
                            return false;
                        }
                        Masterpass other = (Masterpass)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Address this$billingAddress = this.getBillingAddress();
                        Address other$billingAddress = other.getBillingAddress();
                        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        Address this$shippingAddress = this.getShippingAddress();
                        Address other$shippingAddress = other.getShippingAddress();
                        return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Masterpass;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Address $billingAddress = this.getBillingAddress();
                        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        Address $shippingAddress = this.getShippingAddress();
                        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                        return result;
                    }
                }

                public static class GooglePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof GooglePay)) {
                            return false;
                        }
                        GooglePay other = (GooglePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof GooglePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class ApplePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ApplePay)) {
                            return false;
                        }
                        ApplePay other = (ApplePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ApplePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class AmexExpressCheckout
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof AmexExpressCheckout)) {
                            return false;
                        }
                        AmexExpressCheckout other = (AmexExpressCheckout)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof AmexExpressCheckout;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }
            }

            public static class ThreeDSecure
            extends StripeObject {
                @SerializedName(value="authenticated")
                Boolean authenticated;
                @SerializedName(value="authentication_flow")
                String authenticationFlow;
                @SerializedName(value="result")
                String result;
                @SerializedName(value="result_reason")
                String resultReason;
                @SerializedName(value="succeeded")
                Boolean succeeded;
                @SerializedName(value="version")
                String version;

                @Generated
                public Boolean getAuthenticated() {
                    return this.authenticated;
                }

                @Generated
                public String getAuthenticationFlow() {
                    return this.authenticationFlow;
                }

                @Generated
                public String getResult() {
                    return this.result;
                }

                @Generated
                public String getResultReason() {
                    return this.resultReason;
                }

                @Generated
                public Boolean getSucceeded() {
                    return this.succeeded;
                }

                @Generated
                public String getVersion() {
                    return this.version;
                }

                @Generated
                public void setAuthenticated(Boolean authenticated) {
                    this.authenticated = authenticated;
                }

                @Generated
                public void setAuthenticationFlow(String authenticationFlow) {
                    this.authenticationFlow = authenticationFlow;
                }

                @Generated
                public void setResult(String result) {
                    this.result = result;
                }

                @Generated
                public void setResultReason(String resultReason) {
                    this.resultReason = resultReason;
                }

                @Generated
                public void setSucceeded(Boolean succeeded) {
                    this.succeeded = succeeded;
                }

                @Generated
                public void setVersion(String version) {
                    this.version = version;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ThreeDSecure)) {
                        return false;
                    }
                    ThreeDSecure other = (ThreeDSecure)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$authenticated = this.getAuthenticated();
                    Boolean other$authenticated = other.getAuthenticated();
                    if (this$authenticated == null ? other$authenticated != null : !((Object)this$authenticated).equals(other$authenticated)) {
                        return false;
                    }
                    String this$authenticationFlow = this.getAuthenticationFlow();
                    String other$authenticationFlow = other.getAuthenticationFlow();
                    if (this$authenticationFlow == null ? other$authenticationFlow != null : !this$authenticationFlow.equals(other$authenticationFlow)) {
                        return false;
                    }
                    String this$result = this.getResult();
                    String other$result = other.getResult();
                    if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                        return false;
                    }
                    String this$resultReason = this.getResultReason();
                    String other$resultReason = other.getResultReason();
                    if (this$resultReason == null ? other$resultReason != null : !this$resultReason.equals(other$resultReason)) {
                        return false;
                    }
                    Boolean this$succeeded = this.getSucceeded();
                    Boolean other$succeeded = other.getSucceeded();
                    if (this$succeeded == null ? other$succeeded != null : !((Object)this$succeeded).equals(other$succeeded)) {
                        return false;
                    }
                    String this$version = this.getVersion();
                    String other$version = other.getVersion();
                    return !(this$version == null ? other$version != null : !this$version.equals(other$version));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ThreeDSecure;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $authenticated = this.getAuthenticated();
                    result = result * 59 + ($authenticated == null ? 43 : ((Object)$authenticated).hashCode());
                    String $authenticationFlow = this.getAuthenticationFlow();
                    result = result * 59 + ($authenticationFlow == null ? 43 : $authenticationFlow.hashCode());
                    String $result = this.getResult();
                    result = result * 59 + ($result == null ? 43 : $result.hashCode());
                    String $resultReason = this.getResultReason();
                    result = result * 59 + ($resultReason == null ? 43 : $resultReason.hashCode());
                    Boolean $succeeded = this.getSucceeded();
                    result = result * 59 + ($succeeded == null ? 43 : ((Object)$succeeded).hashCode());
                    String $version = this.getVersion();
                    result = result * 59 + ($version == null ? 43 : $version.hashCode());
                    return result;
                }
            }

            public static class Installments
            extends StripeObject {
                @SerializedName(value="plan")
                PaymentIntent.PaymentMethodOptions.Card.Installments.Plan plan;

                @Generated
                public PaymentIntent.PaymentMethodOptions.Card.Installments.Plan getPlan() {
                    return this.plan;
                }

                @Generated
                public void setPlan(PaymentIntent.PaymentMethodOptions.Card.Installments.Plan plan) {
                    this.plan = plan;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Installments)) {
                        return false;
                    }
                    Installments other = (Installments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    PaymentIntent.PaymentMethodOptions.Card.Installments.Plan this$plan = this.getPlan();
                    PaymentIntent.PaymentMethodOptions.Card.Installments.Plan other$plan = other.getPlan();
                    return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Installments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    PaymentIntent.PaymentMethodOptions.Card.Installments.Plan $plan = this.getPlan();
                    result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
                    return result;
                }
            }

            public static class Checks
            extends StripeObject {
                @SerializedName(value="address_line1_check")
                String addressLine1Check;
                @SerializedName(value="address_postal_code_check")
                String addressPostalCodeCheck;
                @SerializedName(value="cvc_check")
                String cvcCheck;

                @Generated
                public String getAddressLine1Check() {
                    return this.addressLine1Check;
                }

                @Generated
                public String getAddressPostalCodeCheck() {
                    return this.addressPostalCodeCheck;
                }

                @Generated
                public String getCvcCheck() {
                    return this.cvcCheck;
                }

                @Generated
                public void setAddressLine1Check(String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                }

                @Generated
                public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                }

                @Generated
                public void setCvcCheck(String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Checks)) {
                        return false;
                    }
                    Checks other = (Checks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$addressLine1Check = this.getAddressLine1Check();
                    String other$addressLine1Check = other.getAddressLine1Check();
                    if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                        return false;
                    }
                    String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                    if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                        return false;
                    }
                    String this$cvcCheck = this.getCvcCheck();
                    String other$cvcCheck = other.getCvcCheck();
                    return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Checks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $addressLine1Check = this.getAddressLine1Check();
                    result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                    String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                    String $cvcCheck = this.getCvcCheck();
                    result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                    return result;
                }
            }
        }

        public static class Bitcoin
        extends StripeObject {
            @SerializedName(value="address")
            String address;
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="amount_charged")
            Long amountCharged;
            @SerializedName(value="amount_received")
            Long amountReceived;
            @SerializedName(value="amount_returned")
            Long amountReturned;
            @SerializedName(value="refund_address")
            String refundAddress;

            @Generated
            public String getAddress() {
                return this.address;
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public Long getAmountCharged() {
                return this.amountCharged;
            }

            @Generated
            public Long getAmountReceived() {
                return this.amountReceived;
            }

            @Generated
            public Long getAmountReturned() {
                return this.amountReturned;
            }

            @Generated
            public String getRefundAddress() {
                return this.refundAddress;
            }

            @Generated
            public void setAddress(String address) {
                this.address = address;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setAmountCharged(Long amountCharged) {
                this.amountCharged = amountCharged;
            }

            @Generated
            public void setAmountReceived(Long amountReceived) {
                this.amountReceived = amountReceived;
            }

            @Generated
            public void setAmountReturned(Long amountReturned) {
                this.amountReturned = amountReturned;
            }

            @Generated
            public void setRefundAddress(String refundAddress) {
                this.refundAddress = refundAddress;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bitcoin)) {
                    return false;
                }
                Bitcoin other = (Bitcoin)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$address = this.getAddress();
                String other$address = other.getAddress();
                if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Long this$amountCharged = this.getAmountCharged();
                Long other$amountCharged = other.getAmountCharged();
                if (this$amountCharged == null ? other$amountCharged != null : !((Object)this$amountCharged).equals(other$amountCharged)) {
                    return false;
                }
                Long this$amountReceived = this.getAmountReceived();
                Long other$amountReceived = other.getAmountReceived();
                if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
                    return false;
                }
                Long this$amountReturned = this.getAmountReturned();
                Long other$amountReturned = other.getAmountReturned();
                if (this$amountReturned == null ? other$amountReturned != null : !((Object)this$amountReturned).equals(other$amountReturned)) {
                    return false;
                }
                String this$refundAddress = this.getRefundAddress();
                String other$refundAddress = other.getRefundAddress();
                return !(this$refundAddress == null ? other$refundAddress != null : !this$refundAddress.equals(other$refundAddress));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bitcoin;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : $address.hashCode());
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Long $amountCharged = this.getAmountCharged();
                result = result * 59 + ($amountCharged == null ? 43 : ((Object)$amountCharged).hashCode());
                Long $amountReceived = this.getAmountReceived();
                result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
                Long $amountReturned = this.getAmountReturned();
                result = result * 59 + ($amountReturned == null ? 43 : ((Object)$amountReturned).hashCode());
                String $refundAddress = this.getRefundAddress();
                result = result * 59 + ($refundAddress == null ? 43 : $refundAddress.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;
            @SerializedName(value="sort_code")
            String sortCode;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public String getSortCode() {
                return this.sortCode;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public void setSortCode(String sortCode) {
                this.sortCode = sortCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
                    return false;
                }
                String this$sortCode = this.getSortCode();
                String other$sortCode = other.getSortCode();
                return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                String $sortCode = this.getSortCode();
                result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
                return result;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public void setBsbNumber(String bsbNumber) {
                this.bsbNumber = bsbNumber;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                return !(this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                return result;
            }
        }

        public static class Alipay
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="institution_number")
            String institutionNumber;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="transit_number")
            String transitNumber;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getTransitNumber() {
                return this.transitNumber;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setInstitutionNumber(String institutionNumber) {
                this.institutionNumber = institutionNumber;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setTransitNumber(String transitNumber) {
                this.transitNumber = transitNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$institutionNumber = this.getInstitutionNumber();
                String other$institutionNumber = other.getInstitutionNumber();
                if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$transitNumber = this.getTransitNumber();
                String other$transitNumber = other.getTransitNumber();
                return !(this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $institutionNumber = this.getInstitutionNumber();
                result = result * 59 + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $transitNumber = this.getTransitNumber();
                result = result * 59 + ($transitNumber == null ? 43 : $transitNumber.hashCode());
                return result;
            }
        }

        public static class AchDebit
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AchDebit)) {
                    return false;
                }
                AchDebit other = (AchDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AchDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }

        public static class AchCreditTransfer
        extends StripeObject {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="routing_number")
            String routingNumber;
            @SerializedName(value="swift_code")
            String swiftCode;

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public String getSwiftCode() {
                return this.swiftCode;
            }

            @Generated
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public void setSwiftCode(String swiftCode) {
                this.swiftCode = swiftCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AchCreditTransfer)) {
                    return false;
                }
                AchCreditTransfer other = (AchCreditTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
                    return false;
                }
                String this$swiftCode = this.getSwiftCode();
                String other$swiftCode = other.getSwiftCode();
                return !(this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AchCreditTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                String $swiftCode = this.getSwiftCode();
                result = result * 59 + ($swiftCode == null ? 43 : $swiftCode.hashCode());
                return result;
            }
        }
    }

    public static class Outcome
    extends StripeObject {
        @SerializedName(value="network_status")
        String networkStatus;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="risk_level")
        String riskLevel;
        @SerializedName(value="risk_score")
        Long riskScore;
        @SerializedName(value="rule")
        ExpandableField<Rule> rule;
        @SerializedName(value="seller_message")
        String sellerMessage;
        @SerializedName(value="type")
        String type;

        public String getRule() {
            return this.rule != null ? this.rule.getId() : null;
        }

        public void setRule(String id) {
            this.rule = ApiResource.setExpandableFieldId(id, this.rule);
        }

        public Rule getRuleObject() {
            return this.rule != null ? this.rule.getExpanded() : null;
        }

        public void setRuleObject(Rule expandableObject) {
            this.rule = new ExpandableField<Rule>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getNetworkStatus() {
            return this.networkStatus;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getRiskLevel() {
            return this.riskLevel;
        }

        @Generated
        public Long getRiskScore() {
            return this.riskScore;
        }

        @Generated
        public String getSellerMessage() {
            return this.sellerMessage;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setNetworkStatus(String networkStatus) {
            this.networkStatus = networkStatus;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setRiskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
        }

        @Generated
        public void setRiskScore(Long riskScore) {
            this.riskScore = riskScore;
        }

        @Generated
        public void setSellerMessage(String sellerMessage) {
            this.sellerMessage = sellerMessage;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Outcome)) {
                return false;
            }
            Outcome other = (Outcome)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$networkStatus = this.getNetworkStatus();
            String other$networkStatus = other.getNetworkStatus();
            if (this$networkStatus == null ? other$networkStatus != null : !this$networkStatus.equals(other$networkStatus)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$riskLevel = this.getRiskLevel();
            String other$riskLevel = other.getRiskLevel();
            if (this$riskLevel == null ? other$riskLevel != null : !this$riskLevel.equals(other$riskLevel)) {
                return false;
            }
            Long this$riskScore = this.getRiskScore();
            Long other$riskScore = other.getRiskScore();
            if (this$riskScore == null ? other$riskScore != null : !((Object)this$riskScore).equals(other$riskScore)) {
                return false;
            }
            String this$rule = this.getRule();
            String other$rule = other.getRule();
            if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
                return false;
            }
            String this$sellerMessage = this.getSellerMessage();
            String other$sellerMessage = other.getSellerMessage();
            if (this$sellerMessage == null ? other$sellerMessage != null : !this$sellerMessage.equals(other$sellerMessage)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Outcome;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $networkStatus = this.getNetworkStatus();
            result = result * 59 + ($networkStatus == null ? 43 : $networkStatus.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $riskLevel = this.getRiskLevel();
            result = result * 59 + ($riskLevel == null ? 43 : $riskLevel.hashCode());
            Long $riskScore = this.getRiskScore();
            result = result * 59 + ($riskScore == null ? 43 : ((Object)$riskScore).hashCode());
            String $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
            String $sellerMessage = this.getSellerMessage();
            result = result * 59 + ($sellerMessage == null ? 43 : $sellerMessage.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Level3
    extends StripeObject {
        @SerializedName(value="customer_reference")
        String customerReference;
        @SerializedName(value="line_items")
        List<LineItem> lineItems;
        @SerializedName(value="merchant_reference")
        String merchantReference;
        @SerializedName(value="shipping_address_zip")
        String shippingAddressZip;
        @SerializedName(value="shipping_amount")
        Long shippingAmount;
        @SerializedName(value="shipping_from_zip")
        String shippingFromZip;

        @Generated
        public String getCustomerReference() {
            return this.customerReference;
        }

        @Generated
        public List<LineItem> getLineItems() {
            return this.lineItems;
        }

        @Generated
        public String getMerchantReference() {
            return this.merchantReference;
        }

        @Generated
        public String getShippingAddressZip() {
            return this.shippingAddressZip;
        }

        @Generated
        public Long getShippingAmount() {
            return this.shippingAmount;
        }

        @Generated
        public String getShippingFromZip() {
            return this.shippingFromZip;
        }

        @Generated
        public void setCustomerReference(String customerReference) {
            this.customerReference = customerReference;
        }

        @Generated
        public void setLineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
        }

        @Generated
        public void setMerchantReference(String merchantReference) {
            this.merchantReference = merchantReference;
        }

        @Generated
        public void setShippingAddressZip(String shippingAddressZip) {
            this.shippingAddressZip = shippingAddressZip;
        }

        @Generated
        public void setShippingAmount(Long shippingAmount) {
            this.shippingAmount = shippingAmount;
        }

        @Generated
        public void setShippingFromZip(String shippingFromZip) {
            this.shippingFromZip = shippingFromZip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Level3)) {
                return false;
            }
            Level3 other = (Level3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customerReference = this.getCustomerReference();
            String other$customerReference = other.getCustomerReference();
            if (this$customerReference == null ? other$customerReference != null : !this$customerReference.equals(other$customerReference)) {
                return false;
            }
            List<LineItem> this$lineItems = this.getLineItems();
            List<LineItem> other$lineItems = other.getLineItems();
            if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
                return false;
            }
            String this$merchantReference = this.getMerchantReference();
            String other$merchantReference = other.getMerchantReference();
            if (this$merchantReference == null ? other$merchantReference != null : !this$merchantReference.equals(other$merchantReference)) {
                return false;
            }
            String this$shippingAddressZip = this.getShippingAddressZip();
            String other$shippingAddressZip = other.getShippingAddressZip();
            if (this$shippingAddressZip == null ? other$shippingAddressZip != null : !this$shippingAddressZip.equals(other$shippingAddressZip)) {
                return false;
            }
            Long this$shippingAmount = this.getShippingAmount();
            Long other$shippingAmount = other.getShippingAmount();
            if (this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount)) {
                return false;
            }
            String this$shippingFromZip = this.getShippingFromZip();
            String other$shippingFromZip = other.getShippingFromZip();
            return !(this$shippingFromZip == null ? other$shippingFromZip != null : !this$shippingFromZip.equals(other$shippingFromZip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Level3;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customerReference = this.getCustomerReference();
            result = result * 59 + ($customerReference == null ? 43 : $customerReference.hashCode());
            List<LineItem> $lineItems = this.getLineItems();
            result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
            String $merchantReference = this.getMerchantReference();
            result = result * 59 + ($merchantReference == null ? 43 : $merchantReference.hashCode());
            String $shippingAddressZip = this.getShippingAddressZip();
            result = result * 59 + ($shippingAddressZip == null ? 43 : $shippingAddressZip.hashCode());
            Long $shippingAmount = this.getShippingAmount();
            result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
            String $shippingFromZip = this.getShippingFromZip();
            result = result * 59 + ($shippingFromZip == null ? 43 : $shippingFromZip.hashCode());
            return result;
        }

        public static class LineItem
        extends StripeObject {
            @SerializedName(value="discount_amount")
            Long discountAmount;
            @SerializedName(value="product_code")
            String productCode;
            @SerializedName(value="product_description")
            String productDescription;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_amount")
            Long taxAmount;
            @SerializedName(value="unit_cost")
            Long unitCost;

            @Generated
            public Long getDiscountAmount() {
                return this.discountAmount;
            }

            @Generated
            public String getProductCode() {
                return this.productCode;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Long getTaxAmount() {
                return this.taxAmount;
            }

            @Generated
            public Long getUnitCost() {
                return this.unitCost;
            }

            @Generated
            public void setDiscountAmount(Long discountAmount) {
                this.discountAmount = discountAmount;
            }

            @Generated
            public void setProductCode(String productCode) {
                this.productCode = productCode;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setQuantity(Long quantity) {
                this.quantity = quantity;
            }

            @Generated
            public void setTaxAmount(Long taxAmount) {
                this.taxAmount = taxAmount;
            }

            @Generated
            public void setUnitCost(Long unitCost) {
                this.unitCost = unitCost;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LineItem)) {
                    return false;
                }
                LineItem other = (LineItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$discountAmount = this.getDiscountAmount();
                Long other$discountAmount = other.getDiscountAmount();
                if (this$discountAmount == null ? other$discountAmount != null : !((Object)this$discountAmount).equals(other$discountAmount)) {
                    return false;
                }
                String this$productCode = this.getProductCode();
                String other$productCode = other.getProductCode();
                if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                Long this$taxAmount = this.getTaxAmount();
                Long other$taxAmount = other.getTaxAmount();
                if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                    return false;
                }
                Long this$unitCost = this.getUnitCost();
                Long other$unitCost = other.getUnitCost();
                return !(this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LineItem;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $discountAmount = this.getDiscountAmount();
                result = result * 59 + ($discountAmount == null ? 43 : ((Object)$discountAmount).hashCode());
                String $productCode = this.getProductCode();
                result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                Long $taxAmount = this.getTaxAmount();
                result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
                Long $unitCost = this.getUnitCost();
                result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
                return result;
            }
        }
    }

    public static class FraudDetails
    extends StripeObject {
        @SerializedName(value="stripe_report")
        String stripeReport;
        @SerializedName(value="user_report")
        String userReport;

        @Generated
        public String getStripeReport() {
            return this.stripeReport;
        }

        @Generated
        public String getUserReport() {
            return this.userReport;
        }

        @Generated
        public void setStripeReport(String stripeReport) {
            this.stripeReport = stripeReport;
        }

        @Generated
        public void setUserReport(String userReport) {
            this.userReport = userReport;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FraudDetails)) {
                return false;
            }
            FraudDetails other = (FraudDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$stripeReport = this.getStripeReport();
            String other$stripeReport = other.getStripeReport();
            if (this$stripeReport == null ? other$stripeReport != null : !this$stripeReport.equals(other$stripeReport)) {
                return false;
            }
            String this$userReport = this.getUserReport();
            String other$userReport = other.getUserReport();
            return !(this$userReport == null ? other$userReport != null : !this$userReport.equals(other$userReport));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FraudDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $stripeReport = this.getStripeReport();
            result = result * 59 + ($stripeReport == null ? 43 : $stripeReport.hashCode());
            String $userReport = this.getUserReport();
            result = result * 59 + ($userReport == null ? 43 : $userReport.hashCode());
            return result;
        }
    }

    public static class AlternateStatementDescriptors
    extends StripeObject {
        @SerializedName(value="kana")
        String kana;
        @SerializedName(value="kanji")
        String kanji;

        @Generated
        public String getKana() {
            return this.kana;
        }

        @Generated
        public String getKanji() {
            return this.kanji;
        }

        @Generated
        public void setKana(String kana) {
            this.kana = kana;
        }

        @Generated
        public void setKanji(String kanji) {
            this.kanji = kanji;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlternateStatementDescriptors)) {
                return false;
            }
            AlternateStatementDescriptors other = (AlternateStatementDescriptors)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$kana = this.getKana();
            String other$kana = other.getKana();
            if (this$kana == null ? other$kana != null : !this$kana.equals(other$kana)) {
                return false;
            }
            String this$kanji = this.getKanji();
            String other$kanji = other.getKanji();
            return !(this$kanji == null ? other$kanji != null : !this$kanji.equals(other$kanji));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AlternateStatementDescriptors;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $kana = this.getKana();
            result = result * 59 + ($kana == null ? 43 : $kana.hashCode());
            String $kanji = this.getKanji();
            result = result * 59 + ($kanji == null ? 43 : $kanji.hashCode());
            return result;
        }
    }
}

