// Generated by delombok at Thu Jun 18 14:16:56 PDT 2020
package com.stripe.net;

import static java.util.Objects.requireNonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;

/**
 * Represents the content of an HTTP request, i.e. the request's body. This class also holds the
 * value of the {@code Content-Type} header, which can depend on the body in some cases (e.g. for
 * multipart requests).
 */
public final class HttpContent {
  /**
   * The request's content, as a byte array.
   */
  private final byte[] byteArrayContent;
  /**
   * The value of the {@code Content-Type} header.
   */
  private final String contentType;

  private HttpContent(byte[] byteArrayContent, String contentType) {
    this.byteArrayContent = byteArrayContent;
    this.contentType = contentType;
  }

  /**
   * Builds a new HttpContent for name/value tuples encoded using {@code
   * application/x-www-form-urlencoded} MIME type.
   *
   * @param nameValueCollection the collection of name/value tuples to encode
   * @return the encoded HttpContent instance
   * @throws IllegalArgumentException if nameValueCollection is null
   */
  public static HttpContent buildFormURLEncodedContent(Collection<KeyValuePair<String, String>> nameValueCollection) throws IOException {
    requireNonNull(nameValueCollection);
    return new HttpContent(FormEncoder.createQueryString(nameValueCollection).getBytes(ApiResource.CHARSET), String.format("application/x-www-form-urlencoded;charset=%s", ApiResource.CHARSET));
  }

  /**
   * The request's content, as a string.
   */
  public String stringContent() {
    return new String(this.byteArrayContent, ApiResource.CHARSET);
  }

  /**
   * Builds a new HttpContent for name/value tuples encoded using {@code multipart/form-data} MIME
   * type.
   *
   * @param nameValueCollection the collection of name/value tuples to encode
   * @return the encoded HttpContent instance
   * @throws IllegalArgumentException if nameValueCollection is null
   */
  public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection) throws IOException {
    String boundary = UUID.randomUUID().toString();
    return buildMultipartFormDataContent(nameValueCollection, boundary);
  }

  /**
   * Builds a new HttpContent for name/value tuples encoded using {@code multipart/form-data} MIME
   * type.
   *
   * @param nameValueCollection the collection of name/value tuples to encode
   * @param boundary the boundary
   * @return the encoded HttpContent instance
   * @throws IllegalArgumentException if nameValueCollection is null
   */
  public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection, String boundary) throws IOException {
    requireNonNull(nameValueCollection);
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    MultipartProcessor multipartProcessor = null;
    try {
      multipartProcessor = new MultipartProcessor(baos, boundary, ApiResource.CHARSET);
      for (KeyValuePair<String, Object> entry : nameValueCollection) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof File) {
          File file = (File) value;
          multipartProcessor.addFileField(key, file.getName(), new FileInputStream(file));
        } else if (value instanceof InputStream) {
          multipartProcessor.addFileField(key, "blob", (InputStream) value);
        } else {
          multipartProcessor.addFormField(key, (String) value);
        }
      }
    } finally {
      if (multipartProcessor != null) {
        multipartProcessor.finish();
      }
    }
    return new HttpContent(baos.toByteArray(), String.format("multipart/form-data; boundary=%s", boundary));
  }

  /**
   * The request's content, as a byte array.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public byte[] byteArrayContent() {
    return this.byteArrayContent;
  }

  /**
   * The value of the {@code Content-Type} header.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String contentType() {
    return this.contentType;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HttpContent)) return false;
    final HttpContent other = (HttpContent) o;
    if (!java.util.Arrays.equals(this.byteArrayContent(), other.byteArrayContent())) return false;
    final java.lang.Object this$contentType = this.contentType();
    final java.lang.Object other$contentType = other.contentType();
    if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + java.util.Arrays.hashCode(this.byteArrayContent());
    final java.lang.Object $contentType = this.contentType();
    result = result * PRIME + ($contentType == null ? 43 : $contentType.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "HttpContent(byteArrayContent=" + java.util.Arrays.toString(this.byteArrayContent()) + ", contentType=" + this.contentType() + ")";
  }
}
