// Generated by delombok at Tue Jun 23 19:30:40 PDT 2020
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ConnectionTokenCreateParams;
import java.util.Map;

public class ConnectionToken extends ApiResource {
  /**
   * The id of the location that this connection token is scoped to.
   */
  @SerializedName("location")
  String location;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.connection_token}.
   */
  @SerializedName("object")
  String object;
  /**
   * Your application should pass this token to the Stripe Terminal SDK.
   */
  @SerializedName("secret")
  String secret;

  /**
   * To connect to a reader the Stripe Terminal SDK needs to retrieve a short-lived connection token
   * from Stripe, proxied through your server. On your backend, add an endpoint that creates and
   * returns a connection token.
   */
  public static ConnectionToken create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To connect to a reader the Stripe Terminal SDK needs to retrieve a short-lived connection token
   * from Stripe, proxied through your server. On your backend, add an endpoint that creates and
   * returns a connection token.
   */
  public static ConnectionToken create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/connection_tokens");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ConnectionToken.class, options);
  }

  /**
   * To connect to a reader the Stripe Terminal SDK needs to retrieve a short-lived connection token
   * from Stripe, proxied through your server. On your backend, add an endpoint that creates and
   * returns a connection token.
   */
  public static ConnectionToken create(ConnectionTokenCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To connect to a reader the Stripe Terminal SDK needs to retrieve a short-lived connection token
   * from Stripe, proxied through your server. On your backend, add an endpoint that creates and
   * returns a connection token.
   */
  public static ConnectionToken create(ConnectionTokenCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/connection_tokens");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ConnectionToken.class, options);
  }

  /**
   * The id of the location that this connection token is scoped to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLocation() {
    return this.location;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.connection_token}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Your application should pass this token to the Stripe Terminal SDK.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSecret() {
    return this.secret;
  }

  /**
   * The id of the location that this connection token is scoped to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLocation(final String location) {
    this.location = location;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.connection_token}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Your application should pass this token to the Stripe Terminal SDK.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecret(final String secret) {
    this.secret = secret;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ConnectionToken)) return false;
    final ConnectionToken other = (ConnectionToken) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$location = this.getLocation();
    final java.lang.Object other$location = other.getLocation();
    if (this$location == null ? other$location != null : !this$location.equals(other$location)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$secret = this.getSecret();
    final java.lang.Object other$secret = other.getSecret();
    if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ConnectionToken;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $location = this.getLocation();
    result = result * PRIME + ($location == null ? 43 : $location.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $secret = this.getSecret();
    result = result * PRIME + ($secret == null ? 43 : $secret.hashCode());
    return result;
  }
}
