// Generated by delombok at Wed Jul 15 21:05:18 PDT 2020
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiRequestParams.EnumParam;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentIntentConfirmParams extends ApiRequestParams {
  /**
   * Set to {@code true} to fail the payment attempt if the PaymentIntent transitions into {@code
   * requires_action}. This parameter is intended for simpler integrations that do not handle
   * customer actions, like <a
   * href="https://stripe.com/docs/payments/save-card-without-authentication">saving cards without
   * authentication</a>.
   */
  @SerializedName("error_on_requires_action")
  Boolean errorOnRequiresAction;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * ID of the mandate to be used for this payment.
   */
  @SerializedName("mandate")
  String mandate;
  /**
   * This hash contains details about the Mandate to create.
   */
  @SerializedName("mandate_data")
  Object mandateData;
  /**
   * Set to {@code true} to indicate that the customer is not in your checkout flow during this
   * payment attempt, and therefore is unable to authenticate. This parameter is intended for
   * scenarios where you collect card details and <a
   * href="https://stripe.com/docs/payments/cards/charging-saved-cards">charge them later</a>.
   */
  @SerializedName("off_session")
  Object offSession;
  /**
   * ID of the payment method (a PaymentMethod, Card, or <a
   * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
   * object) to attach to this PaymentIntent.
   */
  @SerializedName("payment_method")
  String paymentMethod;
  /**
   * If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will
   * appear in the <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method">payment_method</a>
   * property on the PaymentIntent.
   */
  @SerializedName("payment_method_data")
  PaymentMethodData paymentMethodData;
  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @SerializedName("payment_method_options")
  PaymentMethodOptions paymentMethodOptions;
  /**
   * Email address that the receipt for the resulting payment will be sent to. If {@code
   * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
   * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
   */
  @SerializedName("receipt_email")
  Object receiptEmail;
  /**
   * The URL to redirect your customer back to after they authenticate or cancel their payment on
   * the payment method's app or site. If you'd prefer to redirect to a mobile application, you can
   * alternatively supply an application URI scheme. This parameter is only used for cards and other
   * redirect-based payment methods.
   */
  @SerializedName("return_url")
  String returnUrl;
  /**
   * If the PaymentIntent has a {@code payment_method} and a {@code customer} or if you're attaching
   * a payment method to the PaymentIntent in this request, you can pass {@code
   * save_payment_method=true} to save the payment method to the customer immediately.
   *
   * <p>If the payment method is already saved to a customer, this parameter does nothing. If this
   * type of payment method cannot be saved to a customer, the request will error.
   *
   * <p>Saving a payment method using this parameter is <em>not recommended</em> because it will
   * save the payment method even if it cannot be charged (e.g. the user made a typo). To ensure
   * that only payment methods which are likely to be chargeable are saved to a customer, use the
   * (setup_future_usage)[#payment_intents/object#payment_intent_object-setup_future_usage]
   * property, which saves the payment method after the PaymentIntent has been confirmed and all
   * required actions by the customer are complete.
   */
  @SerializedName("save_payment_method")
  Boolean savePaymentMethod;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>If {@code setup_future_usage} is already set and you are performing a request using a
   * publishable key, you may only update the value from {@code on_session} to {@code off_session}.
   */
  @SerializedName("setup_future_usage")
  EnumParam setupFutureUsage;
  /**
   * Shipping information for this PaymentIntent.
   */
  @SerializedName("shipping")
  Object shipping;
  /**
   * This is a legacy field that will be removed in the future. It is the ID of the Source object to
   * attach to this PaymentIntent. Please use the {@code payment_method} field instead, which also
   * supports Cards and <a
   * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
   * objects.
   */
  @SerializedName("source")
  String source;
  /**
   * Set to {@code true} only when using manual confirmation and the iOS or Android SDKs to handle
   * additional authentication steps.
   */
  @SerializedName("use_stripe_sdk")
  Boolean useStripeSdk;

  private PaymentIntentConfirmParams(Boolean errorOnRequiresAction, List<String> expand, Map<String, Object> extraParams, String mandate, Object mandateData, Object offSession, String paymentMethod, PaymentMethodData paymentMethodData, PaymentMethodOptions paymentMethodOptions, Object receiptEmail, String returnUrl, Boolean savePaymentMethod, EnumParam setupFutureUsage, Object shipping, String source, Boolean useStripeSdk) {
    this.errorOnRequiresAction = errorOnRequiresAction;
    this.expand = expand;
    this.extraParams = extraParams;
    this.mandate = mandate;
    this.mandateData = mandateData;
    this.offSession = offSession;
    this.paymentMethod = paymentMethod;
    this.paymentMethodData = paymentMethodData;
    this.paymentMethodOptions = paymentMethodOptions;
    this.receiptEmail = receiptEmail;
    this.returnUrl = returnUrl;
    this.savePaymentMethod = savePaymentMethod;
    this.setupFutureUsage = setupFutureUsage;
    this.shipping = shipping;
    this.source = source;
    this.useStripeSdk = useStripeSdk;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private Boolean errorOnRequiresAction;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private String mandate;
    private Object mandateData;
    private Object offSession;
    private String paymentMethod;
    private PaymentMethodData paymentMethodData;
    private PaymentMethodOptions paymentMethodOptions;
    private Object receiptEmail;
    private String returnUrl;
    private Boolean savePaymentMethod;
    private EnumParam setupFutureUsage;
    private Object shipping;
    private String source;
    private Boolean useStripeSdk;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public PaymentIntentConfirmParams build() {
      return new PaymentIntentConfirmParams(this.errorOnRequiresAction, this.expand, this.extraParams, this.mandate, this.mandateData, this.offSession, this.paymentMethod, this.paymentMethodData, this.paymentMethodOptions, this.receiptEmail, this.returnUrl, this.savePaymentMethod, this.setupFutureUsage, this.shipping, this.source, this.useStripeSdk);
    }

    /**
     * Set to {@code true} to fail the payment attempt if the PaymentIntent transitions into {@code
     * requires_action}. This parameter is intended for simpler integrations that do not handle
     * customer actions, like <a
     * href="https://stripe.com/docs/payments/save-card-without-authentication">saving cards without
     * authentication</a>.
     */
    public Builder setErrorOnRequiresAction(Boolean errorOnRequiresAction) {
      this.errorOnRequiresAction = errorOnRequiresAction;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentIntentConfirmParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentIntentConfirmParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * PaymentIntentConfirmParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link PaymentIntentConfirmParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * ID of the mandate to be used for this payment.
     */
    public Builder setMandate(String mandate) {
      this.mandate = mandate;
      return this;
    }

    /**
     * This hash contains details about the Mandate to create.
     */
    public Builder setMandateData(MandateData mandateData) {
      this.mandateData = mandateData;
      return this;
    }

    /**
     * Set to {@code true} to indicate that the customer is not in your checkout flow during this
     * payment attempt, and therefore is unable to authenticate. This parameter is intended for
     * scenarios where you collect card details and <a
     * href="https://stripe.com/docs/payments/cards/charging-saved-cards">charge them later</a>.
     */
    public Builder setOffSession(Boolean offSession) {
      this.offSession = offSession;
      return this;
    }

    /**
     * Set to {@code true} to indicate that the customer is not in your checkout flow during this
     * payment attempt, and therefore is unable to authenticate. This parameter is intended for
     * scenarios where you collect card details and <a
     * href="https://stripe.com/docs/payments/cards/charging-saved-cards">charge them later</a>.
     */
    public Builder setOffSession(OffSession offSession) {
      this.offSession = offSession;
      return this;
    }

    /**
     * ID of the payment method (a PaymentMethod, Card, or <a
     * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
     * object) to attach to this PaymentIntent.
     */
    public Builder setPaymentMethod(String paymentMethod) {
      this.paymentMethod = paymentMethod;
      return this;
    }

    /**
     * If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will
     * appear in the <a
     * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method">payment_method</a>
     * property on the PaymentIntent.
     */
    public Builder setPaymentMethodData(PaymentMethodData paymentMethodData) {
      this.paymentMethodData = paymentMethodData;
      return this;
    }

    /**
     * Payment-method-specific configuration for this PaymentIntent.
     */
    public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
      this.paymentMethodOptions = paymentMethodOptions;
      return this;
    }

    /**
     * Email address that the receipt for the resulting payment will be sent to. If {@code
     * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
     * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
     */
    public Builder setReceiptEmail(String receiptEmail) {
      this.receiptEmail = receiptEmail;
      return this;
    }

    /**
     * Email address that the receipt for the resulting payment will be sent to. If {@code
     * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
     * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
     */
    public Builder setReceiptEmail(EmptyParam receiptEmail) {
      this.receiptEmail = receiptEmail;
      return this;
    }

    /**
     * The URL to redirect your customer back to after they authenticate or cancel their payment on
     * the payment method's app or site. If you'd prefer to redirect to a mobile application, you
     * can alternatively supply an application URI scheme. This parameter is only used for cards and
     * other redirect-based payment methods.
     */
    public Builder setReturnUrl(String returnUrl) {
      this.returnUrl = returnUrl;
      return this;
    }

    /**
     * If the PaymentIntent has a {@code payment_method} and a {@code customer} or if you're
     * attaching a payment method to the PaymentIntent in this request, you can pass {@code
     * save_payment_method=true} to save the payment method to the customer immediately.
     *
     * <p>If the payment method is already saved to a customer, this parameter does nothing. If this
     * type of payment method cannot be saved to a customer, the request will error.
     *
     * <p>Saving a payment method using this parameter is <em>not recommended</em> because it will
     * save the payment method even if it cannot be charged (e.g. the user made a typo). To ensure
     * that only payment methods which are likely to be chargeable are saved to a customer, use the
     * (setup_future_usage)[#payment_intents/object#payment_intent_object-setup_future_usage]
     * property, which saves the payment method after the PaymentIntent has been confirmed and all
     * required actions by the customer are complete.
     */
    public Builder setSavePaymentMethod(Boolean savePaymentMethod) {
      this.savePaymentMethod = savePaymentMethod;
      return this;
    }

    /**
     * Indicates that you intend to make future payments with this PaymentIntent's payment method.
     *
     * <p>Providing this parameter will <a
     * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
     * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
     * required actions from the user are complete. If no Customer was provided, the payment method
     * can still be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a
     * Customer after the transaction completes.
     *
     * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
     * optimize your payment flow and comply with regional legislation and network rules, such as <a
     * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
     *
     * <p>If {@code setup_future_usage} is already set and you are performing a request using a
     * publishable key, you may only update the value from {@code on_session} to {@code
     * off_session}.
     */
    public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
      this.setupFutureUsage = setupFutureUsage;
      return this;
    }

    /**
     * Indicates that you intend to make future payments with this PaymentIntent's payment method.
     *
     * <p>Providing this parameter will <a
     * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
     * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
     * required actions from the user are complete. If no Customer was provided, the payment method
     * can still be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a
     * Customer after the transaction completes.
     *
     * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
     * optimize your payment flow and comply with regional legislation and network rules, such as <a
     * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
     *
     * <p>If {@code setup_future_usage} is already set and you are performing a request using a
     * publishable key, you may only update the value from {@code on_session} to {@code
     * off_session}.
     */
    public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
      this.setupFutureUsage = setupFutureUsage;
      return this;
    }

    /**
     * Shipping information for this PaymentIntent.
     */
    public Builder setShipping(Shipping shipping) {
      this.shipping = shipping;
      return this;
    }

    /**
     * Shipping information for this PaymentIntent.
     */
    public Builder setShipping(EmptyParam shipping) {
      this.shipping = shipping;
      return this;
    }

    /**
     * This is a legacy field that will be removed in the future. It is the ID of the Source object
     * to attach to this PaymentIntent. Please use the {@code payment_method} field instead, which
     * also supports Cards and <a
     * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
     * objects.
     */
    public Builder setSource(String source) {
      this.source = source;
      return this;
    }

    /**
     * Set to {@code true} only when using manual confirmation and the iOS or Android SDKs to handle
     * additional authentication steps.
     */
    public Builder setUseStripeSdk(Boolean useStripeSdk) {
      this.useStripeSdk = useStripeSdk;
      return this;
    }
  }


  public static class MandateData {
    /**
     * This hash contains details about the customer acceptance of the Mandate.
     */
    @SerializedName("customer_acceptance")
    CustomerAcceptance customerAcceptance;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private MandateData(CustomerAcceptance customerAcceptance, Map<String, Object> extraParams) {
      this.customerAcceptance = customerAcceptance;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private CustomerAcceptance customerAcceptance;
      private Map<String, Object> extraParams;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public MandateData build() {
        return new MandateData(this.customerAcceptance, this.extraParams);
      }

      /**
       * This hash contains details about the customer acceptance of the Mandate.
       */
      public Builder setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentIntentConfirmParams.MandateData#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentIntentConfirmParams.MandateData#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }


    public static class CustomerAcceptance {
      /** The time at which the customer accepted the Mandate. */
      @SerializedName("accepted_at")
      Long acceptedAt;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * If this is a Mandate accepted offline, this hash contains details about the offline
       * acceptance.
       */
      @SerializedName("offline")
      Offline offline;
      /**
       * If this is a Mandate accepted online, this hash contains details about the online
       * acceptance.
       */
      @SerializedName("online")
      Online online;
      /**
       * The type of customer acceptance information included with the Mandate. One of {@code
       * online} or {@code offline}.
       */
      @SerializedName("type")
      Type type;

      private CustomerAcceptance(Long acceptedAt, Map<String, Object> extraParams, Offline offline, Online online, Type type) {
        this.acceptedAt = acceptedAt;
        this.extraParams = extraParams;
        this.offline = offline;
        this.online = online;
        this.type = type;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Long acceptedAt;
        private Map<String, Object> extraParams;
        private Offline offline;
        private Online online;
        private Type type;

        /** Finalize and obtain parameter instance from this builder. */
        public CustomerAcceptance build() {
          return new CustomerAcceptance(this.acceptedAt, this.extraParams, this.offline, this.online, this.type);
        }

        /** The time at which the customer accepted the Mandate. */
        public Builder setAcceptedAt(Long acceptedAt) {
          this.acceptedAt = acceptedAt;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.MandateData.CustomerAcceptance#extraParams}
         * for the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.MandateData.CustomerAcceptance#extraParams}
         * for the field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * If this is a Mandate accepted offline, this hash contains details about the offline
         * acceptance.
         */
        public Builder setOffline(Offline offline) {
          this.offline = offline;
          return this;
        }

        /**
         * If this is a Mandate accepted online, this hash contains details about the online
         * acceptance.
         */
        public Builder setOnline(Online online) {
          this.online = online;
          return this;
        }

        /**
         * The type of customer acceptance information included with the Mandate. One of {@code
         * online} or {@code offline}.
         */
        public Builder setType(Type type) {
          this.type = type;
          return this;
        }
      }


      public static class Offline {
        /**
         * Map of extra parameters for custom features not available in this client library. The
         * content in this map is not serialized under this field's {@code @SerializedName} value.
         * Instead, each key/value pair is serialized as if the key is a root-level field
         * (serialized) name in this param object. Effectively, this map is flattened to its parent
         * instance.
         */
        @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
        Map<String, Object> extraParams;

        private Offline(Map<String, Object> extraParams) {
          this.extraParams = extraParams;
        }

        public static Builder builder() {
          return new Builder();
        }


        public static class Builder {
          private Map<String, Object> extraParams;

          /** Finalize and obtain parameter instance from this builder. */
          public Offline build() {
            return new Offline(this.extraParams);
          }

          /**
           * Add a key/value pair to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.MandateData.CustomerAcceptance.Offline#extraParams} for the
           * field documentation.
           */
          public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.put(key, value);
            return this;
          }

          /**
           * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.MandateData.CustomerAcceptance.Offline#extraParams} for the
           * field documentation.
           */
          public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.putAll(map);
            return this;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, Object> getExtraParams() {
          return this.extraParams;
        }
      }


      public static class Online {
        /**
         * Map of extra parameters for custom features not available in this client library. The
         * content in this map is not serialized under this field's {@code @SerializedName} value.
         * Instead, each key/value pair is serialized as if the key is a root-level field
         * (serialized) name in this param object. Effectively, this map is flattened to its parent
         * instance.
         */
        @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
        Map<String, Object> extraParams;
        /** The IP address from which the Mandate was accepted by the customer. */
        @SerializedName("ip_address")
        String ipAddress;
        /** The user agent of the browser from which the Mandate was accepted by the customer. */
        @SerializedName("user_agent")
        String userAgent;

        private Online(Map<String, Object> extraParams, String ipAddress, String userAgent) {
          this.extraParams = extraParams;
          this.ipAddress = ipAddress;
          this.userAgent = userAgent;
        }

        public static Builder builder() {
          return new Builder();
        }


        public static class Builder {
          private Map<String, Object> extraParams;
          private String ipAddress;
          private String userAgent;

          /** Finalize and obtain parameter instance from this builder. */
          public Online build() {
            return new Online(this.extraParams, this.ipAddress, this.userAgent);
          }

          /**
           * Add a key/value pair to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.MandateData.CustomerAcceptance.Online#extraParams} for the
           * field documentation.
           */
          public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.put(key, value);
            return this;
          }

          /**
           * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.MandateData.CustomerAcceptance.Online#extraParams} for the
           * field documentation.
           */
          public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.putAll(map);
            return this;
          }

          /** The IP address from which the Mandate was accepted by the customer. */
          public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
          }

          public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, Object> getExtraParams() {
          return this.extraParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIpAddress() {
          return this.ipAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUserAgent() {
          return this.userAgent;
        }
      }


      public enum Type implements ApiRequestParams.EnumParam {
        @SerializedName("offline")
        OFFLINE("offline"), @SerializedName("online")
        ONLINE("online");
        private final String value;

        Type(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAcceptedAt() {
        return this.acceptedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Offline getOffline() {
        return this.offline;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Online getOnline() {
        return this.online;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Type getType() {
        return this.type;
      }
    }

    /**
     * This hash contains details about the customer acceptance of the Mandate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomerAcceptance getCustomerAcceptance() {
      return this.customerAcceptance;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  /**
   * The user agent of the browser from which the Mandate was accepted by the customer.
   */
  public static class PaymentMethodData {
    /**
     * If this is an {@code au_becs_debit} PaymentMethod, this hash contains details about the bank
     * account.
     */
    @SerializedName("au_becs_debit")
    AuBecsDebit auBecsDebit;
    /**
     * If this is a {@code bacs_debit} PaymentMethod, this hash contains details about the Bacs
     * Direct Debit bank account.
     */
    @SerializedName("bacs_debit")
    BacsDebit bacsDebit;
    /**
     * If this is a {@code bancontact} PaymentMethod, this hash contains details about the
     * Bancontact payment method.
     */
    @SerializedName("bancontact")
    Bancontact bancontact;
    /**
     * Billing information associated with the PaymentMethod that may be used or required by
     * particular types of payment methods.
     */
    @SerializedName("billing_details")
    BillingDetails billingDetails;
    /**
     * If this is an {@code eps} PaymentMethod, this hash contains details about the EPS payment
     * method.
     */
    @SerializedName("eps")
    Eps eps;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * If this is an {@code fpx} PaymentMethod, this hash contains details about the FPX payment
     * method.
     */
    @SerializedName("fpx")
    Fpx fpx;
    /**
     * If this is a {@code giropay} PaymentMethod, this hash contains details about the Giropay
     * payment method.
     */
    @SerializedName("giropay")
    Giropay giropay;
    /**
     * If this is an {@code ideal} PaymentMethod, this hash contains details about the iDEAL payment
     * method.
     */
    @SerializedName("ideal")
    Ideal ideal;
    /**
     * If this is an {@code interac_present} PaymentMethod, this hash contains details about the
     * Interac Present payment method.
     */
    @SerializedName("interac_present")
    InteracPresent interacPresent;
    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to an object. This can be useful for storing additional information about the object in a
     * structured format. Individual keys can be unset by posting an empty value to them. All keys
     * can be unset by posting an empty value to {@code metadata}.
     */
    @SerializedName("metadata")
    Map<String, String> metadata;
    /**
     * If this is a {@code p24} PaymentMethod, this hash contains details about the P24 payment
     * method.
     */
    @SerializedName("p24")
    P24 p24;
    /**
     * If this is a {@code sepa_debit} PaymentMethod, this hash contains details about the SEPA
     * debit bank account.
     */
    @SerializedName("sepa_debit")
    SepaDebit sepaDebit;
    /**
     * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a
     * name matching this value. It contains additional information specific to the PaymentMethod
     * type.
     */
    @SerializedName("type")
    Type type;

    private PaymentMethodData(AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, BillingDetails billingDetails, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Ideal ideal, InteracPresent interacPresent, Map<String, String> metadata, P24 p24, SepaDebit sepaDebit, Type type) {
      this.auBecsDebit = auBecsDebit;
      this.bacsDebit = bacsDebit;
      this.bancontact = bancontact;
      this.billingDetails = billingDetails;
      this.eps = eps;
      this.extraParams = extraParams;
      this.fpx = fpx;
      this.giropay = giropay;
      this.ideal = ideal;
      this.interacPresent = interacPresent;
      this.metadata = metadata;
      this.p24 = p24;
      this.sepaDebit = sepaDebit;
      this.type = type;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private AuBecsDebit auBecsDebit;
      private BacsDebit bacsDebit;
      private Bancontact bancontact;
      private BillingDetails billingDetails;
      private Eps eps;
      private Map<String, Object> extraParams;
      private Fpx fpx;
      private Giropay giropay;
      private Ideal ideal;
      private InteracPresent interacPresent;
      private Map<String, String> metadata;
      private P24 p24;
      private SepaDebit sepaDebit;
      private Type type;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public PaymentMethodData build() {
        return new PaymentMethodData(this.auBecsDebit, this.bacsDebit, this.bancontact, this.billingDetails, this.eps, this.extraParams, this.fpx, this.giropay, this.ideal, this.interacPresent, this.metadata, this.p24, this.sepaDebit, this.type);
      }

      /**
       * If this is an {@code au_becs_debit} PaymentMethod, this hash contains details about the
       * bank account.
       */
      public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
        return this;
      }

      /**
       * If this is a {@code bacs_debit} PaymentMethod, this hash contains details about the Bacs
       * Direct Debit bank account.
       */
      public Builder setBacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
        return this;
      }

      /**
       * If this is a {@code bancontact} PaymentMethod, this hash contains details about the
       * Bancontact payment method.
       */
      public Builder setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
        return this;
      }

      /**
       * Billing information associated with the PaymentMethod that may be used or required by
       * particular types of payment methods.
       */
      public Builder setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
        return this;
      }

      /**
       * If this is an {@code eps} PaymentMethod, this hash contains details about the EPS payment
       * method.
       */
      public Builder setEps(Eps eps) {
        this.eps = eps;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentIntentConfirmParams.PaymentMethodData#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentIntentConfirmParams.PaymentMethodData#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /**
       * If this is an {@code fpx} PaymentMethod, this hash contains details about the FPX payment
       * method.
       */
      public Builder setFpx(Fpx fpx) {
        this.fpx = fpx;
        return this;
      }

      /**
       * If this is a {@code giropay} PaymentMethod, this hash contains details about the Giropay
       * payment method.
       */
      public Builder setGiropay(Giropay giropay) {
        this.giropay = giropay;
        return this;
      }

      /**
       * If this is an {@code ideal} PaymentMethod, this hash contains details about the iDEAL
       * payment method.
       */
      public Builder setIdeal(Ideal ideal) {
        this.ideal = ideal;
        return this;
      }

      /**
       * If this is an {@code interac_present} PaymentMethod, this hash contains details about the
       * Interac Present payment method.
       */
      public Builder setInteracPresent(InteracPresent interacPresent) {
        this.interacPresent = interacPresent;
        return this;
      }

      /**
       * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentIntentConfirmParams.PaymentMethodData#metadata} for the field documentation.
       */
      public Builder putMetadata(String key, String value) {
        if (this.metadata == null) {
          this.metadata = new HashMap<>();
        }
        this.metadata.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `metadata` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentIntentConfirmParams.PaymentMethodData#metadata} for the field
       * documentation.
       */
      public Builder putAllMetadata(Map<String, String> map) {
        if (this.metadata == null) {
          this.metadata = new HashMap<>();
        }
        this.metadata.putAll(map);
        return this;
      }

      /**
       * If this is a {@code p24} PaymentMethod, this hash contains details about the P24 payment
       * method.
       */
      public Builder setP24(P24 p24) {
        this.p24 = p24;
        return this;
      }

      /**
       * If this is a {@code sepa_debit} PaymentMethod, this hash contains details about the SEPA
       * debit bank account.
       */
      public Builder setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
        return this;
      }

      /**
       * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a
       * name matching this value. It contains additional information specific to the PaymentMethod
       * type.
       */
      public Builder setType(Type type) {
        this.type = type;
        return this;
      }
    }


    public static class AuBecsDebit {
      /**
       * The account number for the bank account.
       */
      @SerializedName("account_number")
      String accountNumber;
      /**
       * Bank-State-Branch number of the bank account.
       */
      @SerializedName("bsb_number")
      String bsbNumber;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private AuBecsDebit(String accountNumber, String bsbNumber, Map<String, Object> extraParams) {
        this.accountNumber = accountNumber;
        this.bsbNumber = bsbNumber;
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private String accountNumber;
        private String bsbNumber;
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public AuBecsDebit build() {
          return new AuBecsDebit(this.accountNumber, this.bsbNumber, this.extraParams);
        }

        /** The account number for the bank account. */
        public Builder setAccountNumber(String accountNumber) {
          this.accountNumber = accountNumber;
          return this;
        }

        /** Bank-State-Branch number of the bank account. */
        public Builder setBsbNumber(String bsbNumber) {
          this.bsbNumber = bsbNumber;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.AuBecsDebit#extraParams} for
         * the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * The account number for the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountNumber() {
        return this.accountNumber;
      }

      /**
       * Bank-State-Branch number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBsbNumber() {
        return this.bsbNumber;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.AuBecsDebit#extraParams} for
     * the field documentation.
     */
    public static class BacsDebit {
      /**
       * Account number of the bank account that the funds will be debited from.
       */
      @SerializedName("account_number")
      String accountNumber;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * Sort code of the bank account. (e.g., {@code 10-20-30})
       */
      @SerializedName("sort_code")
      String sortCode;

      private BacsDebit(String accountNumber, Map<String, Object> extraParams, String sortCode) {
        this.accountNumber = accountNumber;
        this.extraParams = extraParams;
        this.sortCode = sortCode;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private String accountNumber;
        private Map<String, Object> extraParams;
        private String sortCode;

        /** Finalize and obtain parameter instance from this builder. */
        public BacsDebit build() {
          return new BacsDebit(this.accountNumber, this.extraParams, this.sortCode);
        }

        /** Account number of the bank account that the funds will be debited from. */
        public Builder setAccountNumber(String accountNumber) {
          this.accountNumber = accountNumber;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.BacsDebit#extraParams} for
         * the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.BacsDebit#extraParams} for
         * the field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        public Builder setSortCode(String sortCode) {
          this.sortCode = sortCode;
          return this;
        }
      }

      /**
       * Account number of the bank account that the funds will be debited from.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountNumber() {
        return this.accountNumber;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      /**
       * Sort code of the bank account. (e.g., {@code 10-20-30})
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSortCode() {
        return this.sortCode;
      }
    }


    /**
     * Sort code of the bank account. (e.g., {@code 10-20-30})
     */
    public static class Bancontact {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private Bancontact(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public Bancontact build() {
          return new Bancontact(this.extraParams);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Bancontact#extraParams} for
         * the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Bancontact#extraParams} for
     * the field documentation.
     */
    public static class BillingDetails {
      /**
       * Billing address.
       */
      @SerializedName("address")
      Address address;
      /**
       * Email address.
       */
      @SerializedName("email")
      String email;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * Full name.
       */
      @SerializedName("name")
      String name;
      /**
       * Billing phone number (including extension).
       */
      @SerializedName("phone")
      String phone;

      private BillingDetails(Address address, String email, Map<String, Object> extraParams, String name, String phone) {
        this.address = address;
        this.email = email;
        this.extraParams = extraParams;
        this.name = name;
        this.phone = phone;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Address address;
        private String email;
        private Map<String, Object> extraParams;
        private String name;
        private String phone;

        /**
         * Finalize and obtain parameter instance from this builder.
         */
        public BillingDetails build() {
          return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone);
        }

        /**
         * Billing address.
         */
        public Builder setAddress(Address address) {
          this.address = address;
          return this;
        }

        /**
         * Email address.
         */
        public Builder setEmail(String email) {
          this.email = email;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.BillingDetails#extraParams}
         * for the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.BillingDetails#extraParams}
         * for the field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * Full name.
         */
        public Builder setName(String name) {
          this.name = name;
          return this;
        }

        /**
         * Billing phone number (including extension).
         */
        public Builder setPhone(String phone) {
          this.phone = phone;
          return this;
        }
      }


      public static class Address {
        /** City, district, suburb, town, or village. */
        @SerializedName("city")
        String city;
        /**
         * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
         * 3166-1 alpha-2</a>).
         */
        @SerializedName("country")
        String country;
        /**
         * Map of extra parameters for custom features not available in this client library. The
         * content in this map is not serialized under this field's {@code @SerializedName} value.
         * Instead, each key/value pair is serialized as if the key is a root-level field
         * (serialized) name in this param object. Effectively, this map is flattened to its parent
         * instance.
         */
        @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
        Map<String, Object> extraParams;
        /** Address line 1 (e.g., street, PO Box, or company name). */
        @SerializedName("line1")
        String line1;
        /** Address line 2 (e.g., apartment, suite, unit, or building). */
        @SerializedName("line2")
        String line2;
        /** ZIP or postal code. */
        @SerializedName("postal_code")
        String postalCode;
        /** State, county, province, or region. */
        @SerializedName("state")
        String state;

        private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
          this.city = city;
          this.country = country;
          this.extraParams = extraParams;
          this.line1 = line1;
          this.line2 = line2;
          this.postalCode = postalCode;
          this.state = state;
        }

        public static Builder builder() {
          return new Builder();
        }


        public static class Builder {
          private String city;
          private String country;
          private Map<String, Object> extraParams;
          private String line1;
          private String line2;
          private String postalCode;
          private String state;

          /** Finalize and obtain parameter instance from this builder. */
          public Address build() {
            return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
          }

          /** City, district, suburb, town, or village. */
          public Builder setCity(String city) {
            this.city = city;
            return this;
          }

          /**
           * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
           * 3166-1 alpha-2</a>).
           */
          public Builder setCountry(String country) {
            this.country = country;
            return this;
          }

          /**
           * Add a key/value pair to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.PaymentMethodData.BillingDetails.Address#extraParams} for
           * the field documentation.
           */
          public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.put(key, value);
            return this;
          }

          /**
           * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.PaymentMethodData.BillingDetails.Address#extraParams} for
           * the field documentation.
           */
          public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.putAll(map);
            return this;
          }

          /** Address line 1 (e.g., street, PO Box, or company name). */
          public Builder setLine1(String line1) {
            this.line1 = line1;
            return this;
          }

          /** Address line 2 (e.g., apartment, suite, unit, or building). */
          public Builder setLine2(String line2) {
            this.line2 = line2;
            return this;
          }

          /** ZIP or postal code. */
          public Builder setPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
          }

          public Builder setState(String state) {
            this.state = state;
            return this;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCity() {
          return this.city;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCountry() {
          return this.country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, Object> getExtraParams() {
          return this.extraParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getLine1() {
          return this.line1;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getLine2() {
          return this.line2;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPostalCode() {
          return this.postalCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getState() {
          return this.state;
        }
      }

      /**
       * Billing address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Address getAddress() {
        return this.address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmail() {
        return this.email;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getName() {
        return this.name;
      }

      /**
       * Billing phone number (including extension).
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPhone() {
        return this.phone;
      }
    }


    /**
     * State, county, province, or region.
     */
    public static class Eps {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private Eps(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public Eps build() {
          return new Eps(this.extraParams);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Eps#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Eps#extraParams} for the
     * field documentation.
     */
    public static class Fpx {
      /**
       * Account holder type for FPX transaction.
       */
      @SerializedName("account_holder_type")
      AccountHolderType accountHolderType;
      /**
       * The customer's bank.
       */
      @SerializedName("bank")
      Bank bank;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private Fpx(AccountHolderType accountHolderType, Bank bank, Map<String, Object> extraParams) {
        this.accountHolderType = accountHolderType;
        this.bank = bank;
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private AccountHolderType accountHolderType;
        private Bank bank;
        private Map<String, Object> extraParams;

        /**
         * Finalize and obtain parameter instance from this builder.
         */
        public Fpx build() {
          return new Fpx(this.accountHolderType, this.bank, this.extraParams);
        }

        /**
         * Account holder type for FPX transaction.
         */
        public Builder setAccountHolderType(AccountHolderType accountHolderType) {
          this.accountHolderType = accountHolderType;
          return this;
        }

        /**
         * The customer's bank.
         */
        public Builder setBank(Bank bank) {
          this.bank = bank;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Fpx#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Fpx#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }


      public enum AccountHolderType implements ApiRequestParams.EnumParam {
        @SerializedName("company")
        COMPANY("company"), @SerializedName("individual")
        INDIVIDUAL("individual");
        private final String value;

        AccountHolderType(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }


      public enum Bank implements ApiRequestParams.EnumParam {
        @SerializedName("affin_bank")
        AFFIN_BANK("affin_bank"), @SerializedName("alliance_bank")
        ALLIANCE_BANK("alliance_bank"), @SerializedName("ambank")
        AMBANK("ambank"), @SerializedName("bank_islam")
        BANK_ISLAM("bank_islam"), @SerializedName("bank_muamalat")
        BANK_MUAMALAT("bank_muamalat"), @SerializedName("bank_rakyat")
        BANK_RAKYAT("bank_rakyat"), @SerializedName("bsn")
        BSN("bsn"), @SerializedName("cimb")
        CIMB("cimb"), @SerializedName("deutsche_bank")
        DEUTSCHE_BANK("deutsche_bank"), @SerializedName("hong_leong_bank")
        HONG_LEONG_BANK("hong_leong_bank"), @SerializedName("hsbc")
        HSBC("hsbc"), @SerializedName("kfh")
        KFH("kfh"), @SerializedName("maybank2e")
        MAYBANK2E("maybank2e"), @SerializedName("maybank2u")
        MAYBANK2U("maybank2u"), @SerializedName("ocbc")
        OCBC("ocbc"), @SerializedName("pb_enterprise")
        PB_ENTERPRISE("pb_enterprise"), @SerializedName("public_bank")
        PUBLIC_BANK("public_bank"), @SerializedName("rhb")
        RHB("rhb"), @SerializedName("standard_chartered")
        STANDARD_CHARTERED("standard_chartered"), @SerializedName("uob")
        UOB("uob");
        private final String value;

        Bank(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }

      /**
       * Account holder type for FPX transaction.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public AccountHolderType getAccountHolderType() {
        return this.accountHolderType;
      }

      /**
       * The customer's bank.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Bank getBank() {
        return this.bank;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    public static class Giropay {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private Giropay(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public Giropay build() {
          return new Giropay(this.extraParams);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Giropay#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Giropay#extraParams} for the
     * field documentation.
     */
    public static class Ideal {
      /**
       * The customer's bank.
       */
      @SerializedName("bank")
      Bank bank;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private Ideal(Bank bank, Map<String, Object> extraParams) {
        this.bank = bank;
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Bank bank;
        private Map<String, Object> extraParams;

        /**
         * Finalize and obtain parameter instance from this builder.
         */
        public Ideal build() {
          return new Ideal(this.bank, this.extraParams);
        }

        /**
         * The customer's bank.
         */
        public Builder setBank(Bank bank) {
          this.bank = bank;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Ideal#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.Ideal#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }


      public enum Bank implements ApiRequestParams.EnumParam {
        @SerializedName("abn_amro")
        ABN_AMRO("abn_amro"), @SerializedName("asn_bank")
        ASN_BANK("asn_bank"), @SerializedName("bunq")
        BUNQ("bunq"), @SerializedName("handelsbanken")
        HANDELSBANKEN("handelsbanken"), @SerializedName("ing")
        ING("ing"), @SerializedName("knab")
        KNAB("knab"), @SerializedName("moneyou")
        MONEYOU("moneyou"), @SerializedName("rabobank")
        RABOBANK("rabobank"), @SerializedName("regiobank")
        REGIOBANK("regiobank"), @SerializedName("sns_bank")
        SNS_BANK("sns_bank"), @SerializedName("triodos_bank")
        TRIODOS_BANK("triodos_bank"), @SerializedName("van_lanschot")
        VAN_LANSCHOT("van_lanschot");
        private final String value;

        Bank(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }

      /**
       * The customer's bank.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Bank getBank() {
        return this.bank;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    public static class InteracPresent {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private InteracPresent(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public InteracPresent build() {
          return new InteracPresent(this.extraParams);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.InteracPresent#extraParams}
         * for the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.InteracPresent#extraParams}
     * for the field documentation.
     */
    public static class P24 {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private P24(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public P24 build() {
          return new P24(this.extraParams);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.P24#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.P24#extraParams} for the
     * field documentation.
     */
    public static class SepaDebit {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * IBAN of the bank account.
       */
      @SerializedName("iban")
      String iban;

      private SepaDebit(Map<String, Object> extraParams, String iban) {
        this.extraParams = extraParams;
        this.iban = iban;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;
        private String iban;

        /** Finalize and obtain parameter instance from this builder. */
        public SepaDebit build() {
          return new SepaDebit(this.extraParams, this.iban);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.SepaDebit#extraParams} for
         * the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodData.SepaDebit#extraParams} for
         * the field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        public Builder setIban(String iban) {
          this.iban = iban;
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      /**
       * IBAN of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIban() {
        return this.iban;
      }
    }


    /**
     * IBAN of the bank account.
     */
    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("au_becs_debit")
      AU_BECS_DEBIT("au_becs_debit"), @SerializedName("bacs_debit")
      BACS_DEBIT("bacs_debit"), @SerializedName("bancontact")
      BANCONTACT("bancontact"), @SerializedName("card_present")
      CARD_PRESENT("card_present"), @SerializedName("eps")
      EPS("eps"), @SerializedName("fpx")
      FPX("fpx"), @SerializedName("giropay")
      GIROPAY("giropay"), @SerializedName("ideal")
      IDEAL("ideal"), @SerializedName("p24")
      P24("p24"), @SerializedName("sepa_debit")
      SEPA_DEBIT("sepa_debit");
      private final String value;

      Type(String value) {
        this.value = value;
      }

      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }
    }

    /**
     * If this is an {@code au_becs_debit} PaymentMethod, this hash contains details about the bank
     * account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuBecsDebit getAuBecsDebit() {
      return this.auBecsDebit;
    }

    /**
     * If this is a {@code bacs_debit} PaymentMethod, this hash contains details about the Bacs
     * Direct Debit bank account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BacsDebit getBacsDebit() {
      return this.bacsDebit;
    }

    /**
     * If this is a {@code bancontact} PaymentMethod, this hash contains details about the
     * Bancontact payment method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Bancontact getBancontact() {
      return this.bancontact;
    }

    /**
     * Billing information associated with the PaymentMethod that may be used or required by
     * particular types of payment methods.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BillingDetails getBillingDetails() {
      return this.billingDetails;
    }

    /**
     * If this is an {@code eps} PaymentMethod, this hash contains details about the EPS payment
     * method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Eps getEps() {
      return this.eps;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * If this is an {@code fpx} PaymentMethod, this hash contains details about the FPX payment
     * method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Fpx getFpx() {
      return this.fpx;
    }

    /**
     * If this is a {@code giropay} PaymentMethod, this hash contains details about the Giropay
     * payment method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Giropay getGiropay() {
      return this.giropay;
    }

    /**
     * If this is an {@code ideal} PaymentMethod, this hash contains details about the iDEAL payment
     * method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ideal getIdeal() {
      return this.ideal;
    }

    /**
     * If this is an {@code interac_present} PaymentMethod, this hash contains details about the
     * Interac Present payment method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InteracPresent getInteracPresent() {
      return this.interacPresent;
    }

    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to an object. This can be useful for storing additional information about the object in a
     * structured format. Individual keys can be unset by posting an empty value to them. All keys
     * can be unset by posting an empty value to {@code metadata}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getMetadata() {
      return this.metadata;
    }

    /**
     * If this is a {@code p24} PaymentMethod, this hash contains details about the P24 payment
     * method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public P24 getP24() {
      return this.p24;
    }

    /**
     * If this is a {@code sepa_debit} PaymentMethod, this hash contains details about the SEPA
     * debit bank account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaDebit getSepaDebit() {
      return this.sepaDebit;
    }

    /**
     * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a
     * name matching this value. It contains additional information specific to the PaymentMethod
     * type.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Type getType() {
      return this.type;
    }
  }


  public static class PaymentMethodOptions {
    /**
     * If this is a {@code bancontact} PaymentMethod, this sub-hash contains details about the
     * Bancontact payment method options.
     */
    @SerializedName("bancontact")
    Object bancontact;
    /**
     * Configuration for any card payments attempted on this PaymentIntent.
     */
    @SerializedName("card")
    Object card;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private PaymentMethodOptions(Object bancontact, Object card, Map<String, Object> extraParams) {
      this.bancontact = bancontact;
      this.card = card;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Object bancontact;
      private Object card;
      private Map<String, Object> extraParams;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public PaymentMethodOptions build() {
        return new PaymentMethodOptions(this.bancontact, this.card, this.extraParams);
      }

      /**
       * If this is a {@code bancontact} PaymentMethod, this sub-hash contains details about the
       * Bancontact payment method options.
       */
      public Builder setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
        return this;
      }

      /**
       * If this is a {@code bancontact} PaymentMethod, this sub-hash contains details about the
       * Bancontact payment method options.
       */
      public Builder setBancontact(EmptyParam bancontact) {
        this.bancontact = bancontact;
        return this;
      }

      /**
       * Configuration for any card payments attempted on this PaymentIntent.
       */
      public Builder setCard(Card card) {
        this.card = card;
        return this;
      }

      /**
       * Configuration for any card payments attempted on this PaymentIntent.
       */
      public Builder setCard(EmptyParam card) {
        this.card = card;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentIntentConfirmParams.PaymentMethodOptions#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentIntentConfirmParams.PaymentMethodOptions#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }


    public static class Bancontact {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       */
      @SerializedName("preferred_language")
      PreferredLanguage preferredLanguage;

      private Bancontact(Map<String, Object> extraParams, PreferredLanguage preferredLanguage) {
        this.extraParams = extraParams;
        this.preferredLanguage = preferredLanguage;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;
        private PreferredLanguage preferredLanguage;

        /**
         * Finalize and obtain parameter instance from this builder.
         */
        public Bancontact build() {
          return new Bancontact(this.extraParams, this.preferredLanguage);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodOptions.Bancontact#extraParams}
         * for the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodOptions.Bancontact#extraParams}
         * for the field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * Preferred language of the Bancontact authorization page that the customer is redirected
         * to.
         */
        public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
          this.preferredLanguage = preferredLanguage;
          return this;
        }
      }


      public enum PreferredLanguage implements ApiRequestParams.EnumParam {
        @SerializedName("de")
        DE("de"), @SerializedName("en")
        EN("en"), @SerializedName("fr")
        FR("fr"), @SerializedName("nl")
        NL("nl");
        private final String value;

        PreferredLanguage(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public PreferredLanguage getPreferredLanguage() {
        return this.preferredLanguage;
      }
    }


    public static class Card {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * Installment configuration for payments attempted on this PaymentIntent (Mexico Only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @SerializedName("installments")
      Installments installments;
      /**
       * When specified, this parameter indicates that a transaction will be marked as MOTO (Mail
       * Order Telephone Order) and thus out of scope for SCA. This parameter can only be provided
       * during confirmation.
       */
      @SerializedName("moto")
      Boolean moto;
      /**
       * Selected network to process this PaymentIntent on. Depends on the available networks of the
       * card attached to the PaymentIntent. Can be only set confirm-time.
       */
      @SerializedName("network")
      Network network;
      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       */
      @SerializedName("request_three_d_secure")
      RequestThreeDSecure requestThreeDSecure;

      private Card(Map<String, Object> extraParams, Installments installments, Boolean moto, Network network, RequestThreeDSecure requestThreeDSecure) {
        this.extraParams = extraParams;
        this.installments = installments;
        this.moto = moto;
        this.network = network;
        this.requestThreeDSecure = requestThreeDSecure;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;
        private Installments installments;
        private Boolean moto;
        private Network network;
        private RequestThreeDSecure requestThreeDSecure;

        /** Finalize and obtain parameter instance from this builder. */
        public Card build() {
          return new Card(this.extraParams, this.installments, this.moto, this.network, this.requestThreeDSecure);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodOptions.Card#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.PaymentMethodOptions.Card#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * Installment configuration for payments attempted on this PaymentIntent (Mexico Only).
         *
         * <p>For more information, see the <a
         * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
         */
        public Builder setInstallments(Installments installments) {
          this.installments = installments;
          return this;
        }

        /**
         * When specified, this parameter indicates that a transaction will be marked as MOTO (Mail
         * Order Telephone Order) and thus out of scope for SCA. This parameter can only be provided
         * during confirmation.
         */
        public Builder setMoto(Boolean moto) {
          this.moto = moto;
          return this;
        }

        /**
         * Selected network to process this PaymentIntent on. Depends on the available networks of
         * the card attached to the PaymentIntent. Can be only set confirm-time.
         */
        public Builder setNetwork(Network network) {
          this.network = network;
          return this;
        }

        /**
         * We strongly recommend that you rely on our SCA Engine to automatically prompt your
         * customers for authentication based on risk level and <a
         * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
         * However, if you wish to request 3D Secure based on logic from your own fraud engine,
         * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
         * provided, defaults to {@code automatic}. Read our guide on <a
         * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
         * Secure</a> for more information on how this configuration interacts with Radar and our
         * SCA Engine.
         */
        public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
          this.requestThreeDSecure = requestThreeDSecure;
          return this;
        }
      }


      public static class Installments {
        /**
         * Setting to true enables installments for this PaymentIntent. This will cause the response
         * to contain a list of available installment plans. Setting to false will prevent any
         * selected plan from applying to a charge.
         */
        @SerializedName("enabled")
        Boolean enabled;
        /**
         * Map of extra parameters for custom features not available in this client library. The
         * content in this map is not serialized under this field's {@code @SerializedName} value.
         * Instead, each key/value pair is serialized as if the key is a root-level field
         * (serialized) name in this param object. Effectively, this map is flattened to its parent
         * instance.
         */
        @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
        Map<String, Object> extraParams;
        /**
         * The selected installment plan to use for this payment attempt. This parameter can only be
         * provided during confirmation.
         */
        @SerializedName("plan")
        Object plan;

        private Installments(Boolean enabled, Map<String, Object> extraParams, Object plan) {
          this.enabled = enabled;
          this.extraParams = extraParams;
          this.plan = plan;
        }

        public static Builder builder() {
          return new Builder();
        }


        public static class Builder {
          private Boolean enabled;
          private Map<String, Object> extraParams;
          private Object plan;

          /** Finalize and obtain parameter instance from this builder. */
          public Installments build() {
            return new Installments(this.enabled, this.extraParams, this.plan);
          }

          /**
           * Setting to true enables installments for this PaymentIntent. This will cause the
           * response to contain a list of available installment plans. Setting to false will
           * prevent any selected plan from applying to a charge.
           */
          public Builder setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
          }

          /**
           * Add a key/value pair to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.PaymentMethodOptions.Card.Installments#extraParams} for the
           * field documentation.
           */
          public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.put(key, value);
            return this;
          }

          /**
           * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
           * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
           * map. See {@link
           * PaymentIntentConfirmParams.PaymentMethodOptions.Card.Installments#extraParams} for the
           * field documentation.
           */
          public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
              this.extraParams = new HashMap<>();
            }
            this.extraParams.putAll(map);
            return this;
          }

          /**
           * The selected installment plan to use for this payment attempt. This parameter can only
           * be provided during confirmation.
           */
          public Builder setPlan(Plan plan) {
            this.plan = plan;
            return this;
          }

          /**
           * The selected installment plan to use for this payment attempt. This parameter can only
           * be provided during confirmation.
           */
          public Builder setPlan(EmptyParam plan) {
            this.plan = plan;
            return this;
          }
        }


        public static class Plan {
          /**
           * For {@code fixed_count} installment plans, this is the number of installment payments
           * your customer will make to their credit card.
           */
          @SerializedName("count")
          Long count;
          /**
           * Map of extra parameters for custom features not available in this client library. The
           * content in this map is not serialized under this field's {@code @SerializedName} value.
           * Instead, each key/value pair is serialized as if the key is a root-level field
           * (serialized) name in this param object. Effectively, this map is flattened to its
           * parent instance.
           */
          @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
          Map<String, Object> extraParams;
          /**
           * For {@code fixed_count} installment plans, this is the interval between installment
           * payments your customer will make to their credit card. One of {@code month}.
           */
          @SerializedName("interval")
          Interval interval;
          /** Type of installment plan, one of {@code fixed_count}. */
          @SerializedName("type")
          Type type;

          private Plan(Long count, Map<String, Object> extraParams, Interval interval, Type type) {
            this.count = count;
            this.extraParams = extraParams;
            this.interval = interval;
            this.type = type;
          }

          public static Builder builder() {
            return new Builder();
          }


          public static class Builder {
            private Long count;
            private Map<String, Object> extraParams;
            private Interval interval;
            private Type type;

            /** Finalize and obtain parameter instance from this builder. */
            public Plan build() {
              return new Plan(this.count, this.extraParams, this.interval, this.type);
            }

            /**
             * For {@code fixed_count} installment plans, this is the number of installment payments
             * your customer will make to their credit card.
             */
            public Builder setCount(Long count) {
              this.count = count;
              return this;
            }

            /**
             * Add a key/value pair to `extraParams` map. A map is initialized for the first
             * `put/putAll` call, and subsequent calls add additional key/value pairs to the
             * original map. See {@link
             * PaymentIntentConfirmParams.PaymentMethodOptions.Card.Installments.Plan#extraParams}
             * for the field documentation.
             */
            public Builder putExtraParam(String key, Object value) {
              if (this.extraParams == null) {
                this.extraParams = new HashMap<>();
              }
              this.extraParams.put(key, value);
              return this;
            }

            /**
             * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
             * `put/putAll` call, and subsequent calls add additional key/value pairs to the
             * original map. See {@link
             * PaymentIntentConfirmParams.PaymentMethodOptions.Card.Installments.Plan#extraParams}
             * for the field documentation.
             */
            public Builder putAllExtraParam(Map<String, Object> map) {
              if (this.extraParams == null) {
                this.extraParams = new HashMap<>();
              }
              this.extraParams.putAll(map);
              return this;
            }

            /**
             * For {@code fixed_count} installment plans, this is the interval between installment
             * payments your customer will make to their credit card. One of {@code month}.
             */
            public Builder setInterval(Interval interval) {
              this.interval = interval;
              return this;
            }

            public Builder setType(Type type) {
              this.type = type;
              return this;
            }
          }


          public enum Interval implements ApiRequestParams.EnumParam {
            @SerializedName("month")
            MONTH("month");
            private final String value;

            Interval(String value) {
              this.value = value;
            }

            @Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getValue() {
              return this.value;
            }
          }


          public enum Type implements ApiRequestParams.EnumParam {
            @SerializedName("fixed_count")
            FIXED_COUNT("fixed_count");
            private final String value;

            Type(String value) {
              this.value = value;
            }

            @Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getValue() {
              return this.value;
            }
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getCount() {
            return this.count;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Map<String, Object> getExtraParams() {
            return this.extraParams;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Interval getInterval() {
            return this.interval;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Type getType() {
            return this.type;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getEnabled() {
          return this.enabled;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, Object> getExtraParams() {
          return this.extraParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Object getPlan() {
          return this.plan;
        }
      }


      public enum Network implements ApiRequestParams.EnumParam {
        @SerializedName("amex")
        AMEX("amex"), @SerializedName("cartes_bancaires")
        CARTES_BANCAIRES("cartes_bancaires"), @SerializedName("diners")
        DINERS("diners"), @SerializedName("discover")
        DISCOVER("discover"), @SerializedName("interac")
        INTERAC("interac"), @SerializedName("jcb")
        JCB("jcb"), @SerializedName("mastercard")
        MASTERCARD("mastercard"), @SerializedName("unionpay")
        UNIONPAY("unionpay"), @SerializedName("unknown")
        UNKNOWN("unknown"), @SerializedName("visa")
        VISA("visa");
        private final String value;

        Network(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }


      public enum RequestThreeDSecure implements ApiRequestParams.EnumParam {
        @SerializedName("any")
        ANY("any"), @SerializedName("automatic")
        AUTOMATIC("automatic");
        private final String value;

        RequestThreeDSecure(String value) {
          this.value = value;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
          return this.value;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Installments getInstallments() {
        return this.installments;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getMoto() {
        return this.moto;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Network getNetwork() {
        return this.network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public RequestThreeDSecure getRequestThreeDSecure() {
        return this.requestThreeDSecure;
      }
    }

    /**
     * If this is a {@code bancontact} PaymentMethod, this sub-hash contains details about the
     * Bancontact payment method options.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getBancontact() {
      return this.bancontact;
    }

    /**
     * Configuration for any card payments attempted on this PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getCard() {
      return this.card;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  /**
   * Type of installment plan, one of {@code fixed_count}.
   */
  public static class Shipping {
    /**
     * Shipping address.
     */
    @SerializedName("address")
    Address address;
    /**
     * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc.
     */
    @SerializedName("carrier")
    String carrier;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Recipient name.
     */
    @SerializedName("name")
    String name;
    /**
     * Recipient phone (including extension).
     */
    @SerializedName("phone")
    String phone;
    /**
     * The tracking number for a physical product, obtained from the delivery service. If multiple
     * tracking numbers were generated for this purchase, please separate them with commas.
     */
    @SerializedName("tracking_number")
    String trackingNumber;

    private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
      this.address = address;
      this.carrier = carrier;
      this.extraParams = extraParams;
      this.name = name;
      this.phone = phone;
      this.trackingNumber = trackingNumber;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Address address;
      private String carrier;
      private Map<String, Object> extraParams;
      private String name;
      private String phone;
      private String trackingNumber;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public Shipping build() {
        return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
      }

      /**
       * Shipping address.
       */
      public Builder setAddress(Address address) {
        this.address = address;
        return this;
      }

      /**
       * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc.
       */
      public Builder setCarrier(String carrier) {
        this.carrier = carrier;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentIntentConfirmParams.Shipping#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentIntentConfirmParams.Shipping#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /**
       * Recipient name.
       */
      public Builder setName(String name) {
        this.name = name;
        return this;
      }

      /**
       * Recipient phone (including extension).
       */
      public Builder setPhone(String phone) {
        this.phone = phone;
        return this;
      }

      /**
       * The tracking number for a physical product, obtained from the delivery service. If multiple
       * tracking numbers were generated for this purchase, please separate them with commas.
       */
      public Builder setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
      }
    }


    public static class Address {
      /** City, district, suburb, town, or village. */
      @SerializedName("city")
      String city;
      /**
       * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
       * 3166-1 alpha-2</a>).
       */
      @SerializedName("country")
      String country;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /** Address line 1 (e.g., street, PO Box, or company name). */
      @SerializedName("line1")
      String line1;
      /** Address line 2 (e.g., apartment, suite, unit, or building). */
      @SerializedName("line2")
      String line2;
      /** ZIP or postal code. */
      @SerializedName("postal_code")
      String postalCode;
      /** State, county, province, or region. */
      @SerializedName("state")
      String state;

      private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
        this.city = city;
        this.country = country;
        this.extraParams = extraParams;
        this.line1 = line1;
        this.line2 = line2;
        this.postalCode = postalCode;
        this.state = state;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private String city;
        private String country;
        private Map<String, Object> extraParams;
        private String line1;
        private String line2;
        private String postalCode;
        private String state;

        /** Finalize and obtain parameter instance from this builder. */
        public Address build() {
          return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
        }

        /** City, district, suburb, town, or village. */
        public Builder setCity(String city) {
          this.city = city;
          return this;
        }

        /**
         * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
         * 3166-1 alpha-2</a>).
         */
        public Builder setCountry(String country) {
          this.country = country;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.Shipping.Address#extraParams} for the field
         * documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentIntentConfirmParams.Shipping.Address#extraParams} for the field
         * documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /** Address line 1 (e.g., street, PO Box, or company name). */
        public Builder setLine1(String line1) {
          this.line1 = line1;
          return this;
        }

        /** Address line 2 (e.g., apartment, suite, unit, or building). */
        public Builder setLine2(String line2) {
          this.line2 = line2;
          return this;
        }

        /** ZIP or postal code. */
        public Builder setPostalCode(String postalCode) {
          this.postalCode = postalCode;
          return this;
        }

        public Builder setState(String state) {
          this.state = state;
          return this;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCity() {
        return this.city;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLine1() {
        return this.line1;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLine2() {
        return this.line2;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPostalCode() {
        return this.postalCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getState() {
        return this.state;
      }
    }

    /**
     * Shipping address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCarrier() {
      return this.carrier;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Recipient name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Recipient phone (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * The tracking number for a physical product, obtained from the delivery service. If multiple
     * tracking numbers were generated for this purchase, please separate them with commas.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrackingNumber() {
      return this.trackingNumber;
    }
  }


  /**
   * State, county, province, or region.
   */
  public enum OffSession implements ApiRequestParams.EnumParam {
    @SerializedName("one_off")
    ONE_OFF("one_off"), @SerializedName("recurring")
    RECURRING("recurring");
    private final String value;

    OffSession(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum SetupFutureUsage implements ApiRequestParams.EnumParam {
    @SerializedName("off_session")
    OFF_SESSION("off_session"), @SerializedName("on_session")
    ON_SESSION("on_session");
    private final String value;

    SetupFutureUsage(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }

  /**
   * Set to {@code true} to fail the payment attempt if the PaymentIntent transitions into {@code
   * requires_action}. This parameter is intended for simpler integrations that do not handle
   * customer actions, like <a
   * href="https://stripe.com/docs/payments/save-card-without-authentication">saving cards without
   * authentication</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getErrorOnRequiresAction() {
    return this.errorOnRequiresAction;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * ID of the mandate to be used for this payment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMandate() {
    return this.mandate;
  }

  /**
   * This hash contains details about the Mandate to create.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getMandateData() {
    return this.mandateData;
  }

  /**
   * Set to {@code true} to indicate that the customer is not in your checkout flow during this
   * payment attempt, and therefore is unable to authenticate. This parameter is intended for
   * scenarios where you collect card details and <a
   * href="https://stripe.com/docs/payments/cards/charging-saved-cards">charge them later</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getOffSession() {
    return this.offSession;
  }

  /**
   * ID of the payment method (a PaymentMethod, Card, or <a
   * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
   * object) to attach to this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentMethod() {
    return this.paymentMethod;
  }

  /**
   * If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will
   * appear in the <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method">payment_method</a>
   * property on the PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodData getPaymentMethodData() {
    return this.paymentMethodData;
  }

  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodOptions getPaymentMethodOptions() {
    return this.paymentMethodOptions;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to. If {@code
   * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
   * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getReceiptEmail() {
    return this.receiptEmail;
  }

  /**
   * The URL to redirect your customer back to after they authenticate or cancel their payment on
   * the payment method's app or site. If you'd prefer to redirect to a mobile application, you can
   * alternatively supply an application URI scheme. This parameter is only used for cards and other
   * redirect-based payment methods.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnUrl() {
    return this.returnUrl;
  }

  /**
   * If the PaymentIntent has a {@code payment_method} and a {@code customer} or if you're attaching
   * a payment method to the PaymentIntent in this request, you can pass {@code
   * save_payment_method=true} to save the payment method to the customer immediately.
   *
   * <p>If the payment method is already saved to a customer, this parameter does nothing. If this
   * type of payment method cannot be saved to a customer, the request will error.
   *
   * <p>Saving a payment method using this parameter is <em>not recommended</em> because it will
   * save the payment method even if it cannot be charged (e.g. the user made a typo). To ensure
   * that only payment methods which are likely to be chargeable are saved to a customer, use the
   * (setup_future_usage)[#payment_intents/object#payment_intent_object-setup_future_usage]
   * property, which saves the payment method after the PaymentIntent has been confirmed and all
   * required actions by the customer are complete.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getSavePaymentMethod() {
    return this.savePaymentMethod;
  }

  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>If {@code setup_future_usage} is already set and you are performing a request using a
   * publishable key, you may only update the value from {@code on_session} to {@code off_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EnumParam getSetupFutureUsage() {
    return this.setupFutureUsage;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getShipping() {
    return this.shipping;
  }

  /**
   * This is a legacy field that will be removed in the future. It is the ID of the Source object to
   * attach to this PaymentIntent. Please use the {@code payment_method} field instead, which also
   * supports Cards and <a
   * href="https://stripe.com/docs/payments/payment-methods#compatibility">compatible Source</a>
   * objects.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSource() {
    return this.source;
  }

  /**
   * Set to {@code true} only when using manual confirmation and the iOS or Android SDKs to handle
   * additional authentication steps.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getUseStripeSdk() {
    return this.useStripeSdk;
  }
}
