/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;
import com.stripe.exception.ApiConnectionException;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestTelemetry;
import com.stripe.net.StripeRequest;
import com.stripe.net.StripeResponse;
import com.stripe.util.Stopwatch;
import java.net.ConnectException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public abstract class HttpClient {
    public static final Duration maxNetworkRetriesDelay = Duration.ofSeconds(5L);
    public static final Duration minNetworkRetriesDelay = Duration.ofMillis(500L);
    private final RequestTelemetry requestTelemetry = new RequestTelemetry();
    boolean networkRetriesSleep = true;

    public abstract StripeResponse request(StripeRequest var1) throws StripeException;

    public StripeResponse requestWithTelemetry(StripeRequest request) throws StripeException {
        Optional<String> telemetryHeaderValue = this.requestTelemetry.getHeaderValue(request.headers());
        if (telemetryHeaderValue.isPresent()) {
            request = request.withAdditionalHeader("X-Stripe-Client-Telemetry", telemetryHeaderValue.get());
        }
        Stopwatch stopwatch = Stopwatch.startNew();
        StripeResponse response = this.request(request);
        stopwatch.stop();
        this.requestTelemetry.maybeEnqueueMetrics(response, stopwatch.getElapsed());
        return response;
    }

    public StripeResponse requestWithRetries(StripeRequest request) throws StripeException {
        ApiConnectionException requestException = null;
        StripeResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = this.requestWithTelemetry(request);
            }
            catch (ApiConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.numRetries(retry);
        return response;
    }

    protected static String buildUserAgentString() {
        String userAgent = String.format("Stripe/v1 JavaBindings/%s", "19.31.0");
        if (Stripe.getAppInfo() != null) {
            userAgent = userAgent + " " + HttpClient.formatAppInfo(Stripe.getAppInfo());
        }
        return userAgent;
    }

    protected static String buildXStripeClientUserAgentString() {
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "19.31.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        if (Stripe.getAppInfo() != null) {
            propertyMap.put("application", ApiResource.GSON.toJson(Stripe.getAppInfo()));
        }
        return ApiResource.GSON.toJson(propertyMap);
    }

    private static String formatAppInfo(Map<String, String> info) {
        String str = info.get("name");
        if (info.get("version") != null) {
            str = str + String.format("/%s", info.get("version"));
        }
        if (info.get("url") != null) {
            str = str + String.format(" (%s)", info.get("url"));
        }
        return str;
    }

    private boolean shouldRetry(int numRetries, StripeException exception, StripeRequest request, StripeResponse response) {
        if (numRetries >= request.options().getMaxNetworkRetries()) {
            return false;
        }
        if (exception != null && exception.getCause() != null && exception.getCause() instanceof ConnectException) {
            return true;
        }
        if (response != null && response.headers() != null) {
            String value = response.headers().firstValue("Stripe-Should-Retry").orElse(null);
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
        }
        if (response != null && response.code() == 409) {
            return true;
        }
        return response != null && response.code() >= 500;
    }

    private Duration sleepTime(int numRetries) {
        if (!this.networkRetriesSleep) {
            return Duration.ZERO;
        }
        Duration delay = Duration.ofNanos((long)((double)minNetworkRetriesDelay.toNanos() * Math.pow(2.0, numRetries - 1)));
        if (delay.compareTo(maxNetworkRetriesDelay) > 0) {
            delay = maxNetworkRetriesDelay;
        }
        double jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0);
        if ((delay = Duration.ofNanos((long)((double)delay.toNanos() * jitter))).compareTo(minNetworkRetriesDelay) < 0) {
            delay = minNetworkRetriesDelay;
        }
        return delay;
    }
}

