// Generated by delombok at Fri Jul 24 17:36:24 PDT 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.DisputeCloseParams;
import com.stripe.param.DisputeListParams;
import com.stripe.param.DisputeRetrieveParams;
import com.stripe.param.DisputeUpdateParams;
import java.util.List;
import java.util.Map;

public class Dispute extends ApiResource implements MetadataStore<Dispute>, BalanceTransactionSource {
  /**
   * Disputed amount. Usually the amount of the charge, but can differ (usually because of currency
   * fluctuation or because only part of the order is disputed).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * List of zero, one, or two balance transactions that show funds withdrawn and reinstated to your
   * Stripe account as a result of this dispute.
   */
  @SerializedName("balance_transactions")
  List<BalanceTransaction> balanceTransactions;
  /**
   * ID of the charge that was disputed.
   */
  @SerializedName("charge")
  ExpandableField<Charge> charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  @SerializedName("evidence")
  Evidence evidence;
  @SerializedName("evidence_details")
  EvidenceDetails evidenceDetails;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * If true, it is still possible to refund the disputed payment. Once the payment has been fully
   * refunded, no further funds will be withdrawn from your Stripe account as a result of this
   * dispute.
   */
  @SerializedName("is_charge_refundable")
  Boolean isChargeRefundable;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * Network-dependent reason code for the dispute.
   */
  @SerializedName("network_reason_code")
  String networkReasonCode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code dispute}.
   */
  @SerializedName("object")
  String object;
  /**
   * ID of the PaymentIntent that was disputed.
   */
  @SerializedName("payment_intent")
  ExpandableField<PaymentIntent> paymentIntent;
  /**
   * Reason given by cardholder for dispute. Possible values are {@code bank_cannot_process}, {@code
   * check_returned}, {@code credit_not_processed}, {@code customer_initiated}, {@code
   * debit_not_authorized}, {@code duplicate}, {@code fraudulent}, {@code general}, {@code
   * incorrect_account_details}, {@code insufficient_funds}, {@code product_not_received}, {@code
   * product_unacceptable}, {@code subscription_canceled}, or {@code unrecognized}. Read more about
   * <a href="https://stripe.com/docs/disputes/categories">dispute reasons</a>.
   */
  @SerializedName("reason")
  String reason;
  /**
   * Current status of dispute. Possible values are {@code warning_needs_response}, {@code
   * warning_under_review}, {@code warning_closed}, {@code needs_response}, {@code under_review},
   * {@code charge_refunded}, {@code won}, or {@code lost}.
   *
   * <p>One of {@code charge_refunded}, {@code lost}, {@code needs_response}, {@code under_review},
   * {@code warning_closed}, {@code warning_needs_response}, {@code warning_under_review}, or {@code
   * won}.
   */
  @SerializedName("status")
  String status;

  /**
   * Get ID of expandable {@code charge} object.
   */
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String id) {
    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
  }

  /**
   * Get expanded {@code charge}.
   */
  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge expandableObject) {
    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentIntent} object.
   */
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String id) {
    this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
  }

  /**
   * Get expanded {@code paymentIntent}.
   */
  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent expandableObject) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of your disputes.
   */
  public static DisputeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your disputes.
   */
  public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Returns a list of your disputes.
   */
  public static DisputeCollection list(DisputeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your disputes.
   */
  public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Retrieves the dispute with the given ID.
   */
  public static Dispute retrieve(String dispute) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the dispute with the given ID.
   */
  public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the dispute with the given ID.
   */
  public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }

  /**
   * Retrieves the dispute with the given ID.
   */
  public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }

  /**
   * When you get a dispute, contacting your customer is always the best first step. If that doesn’t
   * work, you can submit evidence to help us resolve the dispute in your favor. You can do this in
   * your <a href="https://dashboard.stripe.com/disputes">dashboard</a>, but if you prefer, you can
   * use the API to submit evidence programmatically.
   *
   * <p>Depending on your dispute type, different evidence fields will give you a better chance of
   * winning your dispute. To figure out which evidence fields to provide, see our <a
   * href="https://stripe.com/docs/disputes/categories">guide to dispute types</a>.
   */
  @Override
  public Dispute update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * When you get a dispute, contacting your customer is always the best first step. If that doesn’t
   * work, you can submit evidence to help us resolve the dispute in your favor. You can do this in
   * your <a href="https://dashboard.stripe.com/disputes">dashboard</a>, but if you prefer, you can
   * use the API to submit evidence programmatically.
   *
   * <p>Depending on your dispute type, different evidence fields will give you a better chance of
   * winning your dispute. To figure out which evidence fields to provide, see our <a
   * href="https://stripe.com/docs/disputes/categories">guide to dispute types</a>.
   */
  @Override
  public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * When you get a dispute, contacting your customer is always the best first step. If that doesn’t
   * work, you can submit evidence to help us resolve the dispute in your favor. You can do this in
   * your <a href="https://dashboard.stripe.com/disputes">dashboard</a>, but if you prefer, you can
   * use the API to submit evidence programmatically.
   *
   * <p>Depending on your dispute type, different evidence fields will give you a better chance of
   * winning your dispute. To figure out which evidence fields to provide, see our <a
   * href="https://stripe.com/docs/disputes/categories">guide to dispute types</a>.
   */
  public Dispute update(DisputeUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * When you get a dispute, contacting your customer is always the best first step. If that doesn’t
   * work, you can submit evidence to help us resolve the dispute in your favor. You can do this in
   * your <a href="https://dashboard.stripe.com/disputes">dashboard</a>, but if you prefer, you can
   * use the API to submit evidence programmatically.
   *
   * <p>Depending on your dispute type, different evidence fields will give you a better chance of
   * winning your dispute. To figure out which evidence fields to provide, see our <a
   * href="https://stripe.com/docs/disputes/categories">guide to dispute types</a>.
   */
  public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close() throws StripeException {
    return close((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close(RequestOptions options) throws StripeException {
    return close((Map<String, Object>) null, options);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close(Map<String, Object> params) throws StripeException {
    return close(params, (RequestOptions) null);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s/close", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close(DisputeCloseParams params) throws StripeException {
    return close(params, (RequestOptions) null);
  }

  /**
   * Closing the dispute for a charge indicates that you do not have any evidence to submit and are
   * essentially dismissing the dispute, acknowledging it as lost.
   *
   * <p>The status of the dispute will change from <code>needs_response</code> to <code>lost</code>.
   * <em>Closing a dispute is irreversible</em>.
   */
  public Dispute close(DisputeCloseParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/disputes/%s/close", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }


  public static class Evidence extends StripeObject {
    /**
     * Any server or activity logs showing proof that the customer accessed or downloaded the
     * purchased digital product. This information should include IP addresses, corresponding
     * timestamps, and any detailed recorded activity.
     */
    @SerializedName("access_activity_log")
    String accessActivityLog;
    /**
     * The billing address provided by the customer.
     */
    @SerializedName("billing_address")
    String billingAddress;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Your
     * subscription cancellation policy, as shown to the customer.
     */
    @SerializedName("cancellation_policy")
    ExpandableField<File> cancellationPolicy;
    /**
     * An explanation of how and when the customer was shown your refund policy prior to purchase.
     */
    @SerializedName("cancellation_policy_disclosure")
    String cancellationPolicyDisclosure;
    /**
     * A justification for why the customer's subscription was not canceled.
     */
    @SerializedName("cancellation_rebuttal")
    String cancellationRebuttal;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Any
     * communication with the customer that you feel is relevant to your case. Examples include
     * emails proving that the customer received the product or service, or demonstrating their use
     * of or satisfaction with the product or service.
     */
    @SerializedName("customer_communication")
    ExpandableField<File> customerCommunication;
    /**
     * The email address of the customer.
     */
    @SerializedName("customer_email_address")
    String customerEmailAddress;
    /**
     * The name of the customer.
     */
    @SerializedName("customer_name")
    String customerName;
    /**
     * The IP address that the customer used when making the purchase.
     */
    @SerializedName("customer_purchase_ip")
    String customerPurchaseIp;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) A relevant
     * document or contract showing the customer's signature.
     */
    @SerializedName("customer_signature")
    ExpandableField<File> customerSignature;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Documentation
     * for the prior charge that can uniquely identify the charge, such as a receipt, shipping
     * label, work order, etc. This document should be paired with a similar document from the
     * disputed payment that proves the two payments are separate.
     */
    @SerializedName("duplicate_charge_documentation")
    ExpandableField<File> duplicateChargeDocumentation;
    /**
     * An explanation of the difference between the disputed charge versus the prior charge that
     * appears to be a duplicate.
     */
    @SerializedName("duplicate_charge_explanation")
    String duplicateChargeExplanation;
    /**
     * The Stripe ID for the prior charge which appears to be a duplicate of the disputed charge.
     */
    @SerializedName("duplicate_charge_id")
    String duplicateChargeId;
    /**
     * A description of the product or service that was sold.
     */
    @SerializedName("product_description")
    String productDescription;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Any receipt or
     * message sent to the customer notifying them of the charge.
     */
    @SerializedName("receipt")
    ExpandableField<File> receipt;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Your refund
     * policy, as shown to the customer.
     */
    @SerializedName("refund_policy")
    ExpandableField<File> refundPolicy;
    /**
     * Documentation demonstrating that the customer was shown your refund policy prior to purchase.
     */
    @SerializedName("refund_policy_disclosure")
    String refundPolicyDisclosure;
    /**
     * A justification for why the customer is not entitled to a refund.
     */
    @SerializedName("refund_refusal_explanation")
    String refundRefusalExplanation;
    /**
     * The date on which the customer received or began receiving the purchased service, in a clear
     * human-readable format.
     */
    @SerializedName("service_date")
    String serviceDate;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Documentation
     * showing proof that a service was provided to the customer. This could include a copy of a
     * signed contract, work order, or other form of written agreement.
     */
    @SerializedName("service_documentation")
    ExpandableField<File> serviceDocumentation;
    /**
     * The address to which a physical product was shipped. You should try to include as complete
     * address information as possible.
     */
    @SerializedName("shipping_address")
    String shippingAddress;
    /**
     * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc. If
     * multiple carriers were used for this purchase, please separate them with commas.
     */
    @SerializedName("shipping_carrier")
    String shippingCarrier;
    /**
     * The date on which a physical product began its route to the shipping address, in a clear
     * human-readable format.
     */
    @SerializedName("shipping_date")
    String shippingDate;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Documentation
     * showing proof that a product was shipped to the customer at the same address the customer
     * provided to you. This could include a copy of the shipment receipt, shipping label, etc. It
     * should show the customer's full shipping address, if possible.
     */
    @SerializedName("shipping_documentation")
    ExpandableField<File> shippingDocumentation;
    /**
     * The tracking number for a physical product, obtained from the delivery service. If multiple
     * tracking numbers were generated for this purchase, please separate them with commas.
     */
    @SerializedName("shipping_tracking_number")
    String shippingTrackingNumber;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Any additional
     * evidence or statements.
     */
    @SerializedName("uncategorized_file")
    ExpandableField<File> uncategorizedFile;
    /**
     * Any additional evidence or statements.
     */
    @SerializedName("uncategorized_text")
    String uncategorizedText;

    /**
     * Get ID of expandable {@code cancellationPolicy} object.
     */
    public String getCancellationPolicy() {
      return (this.cancellationPolicy != null) ? this.cancellationPolicy.getId() : null;
    }

    public void setCancellationPolicy(String id) {
      this.cancellationPolicy = ApiResource.setExpandableFieldId(id, this.cancellationPolicy);
    }

    /**
     * Get expanded {@code cancellationPolicy}.
     */
    public File getCancellationPolicyObject() {
      return (this.cancellationPolicy != null) ? this.cancellationPolicy.getExpanded() : null;
    }

    public void setCancellationPolicyObject(File expandableObject) {
      this.cancellationPolicy = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code customerCommunication} object.
     */
    public String getCustomerCommunication() {
      return (this.customerCommunication != null) ? this.customerCommunication.getId() : null;
    }

    public void setCustomerCommunication(String id) {
      this.customerCommunication = ApiResource.setExpandableFieldId(id, this.customerCommunication);
    }

    /**
     * Get expanded {@code customerCommunication}.
     */
    public File getCustomerCommunicationObject() {
      return (this.customerCommunication != null) ? this.customerCommunication.getExpanded() : null;
    }

    public void setCustomerCommunicationObject(File expandableObject) {
      this.customerCommunication = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code customerSignature} object.
     */
    public String getCustomerSignature() {
      return (this.customerSignature != null) ? this.customerSignature.getId() : null;
    }

    public void setCustomerSignature(String id) {
      this.customerSignature = ApiResource.setExpandableFieldId(id, this.customerSignature);
    }

    /**
     * Get expanded {@code customerSignature}.
     */
    public File getCustomerSignatureObject() {
      return (this.customerSignature != null) ? this.customerSignature.getExpanded() : null;
    }

    public void setCustomerSignatureObject(File expandableObject) {
      this.customerSignature = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code duplicateChargeDocumentation} object.
     */
    public String getDuplicateChargeDocumentation() {
      return (this.duplicateChargeDocumentation != null) ? this.duplicateChargeDocumentation.getId() : null;
    }

    public void setDuplicateChargeDocumentation(String id) {
      this.duplicateChargeDocumentation = ApiResource.setExpandableFieldId(id, this.duplicateChargeDocumentation);
    }

    /**
     * Get expanded {@code duplicateChargeDocumentation}.
     */
    public File getDuplicateChargeDocumentationObject() {
      return (this.duplicateChargeDocumentation != null) ? this.duplicateChargeDocumentation.getExpanded() : null;
    }

    public void setDuplicateChargeDocumentationObject(File expandableObject) {
      this.duplicateChargeDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code receipt} object.
     */
    public String getReceipt() {
      return (this.receipt != null) ? this.receipt.getId() : null;
    }

    public void setReceipt(String id) {
      this.receipt = ApiResource.setExpandableFieldId(id, this.receipt);
    }

    /**
     * Get expanded {@code receipt}.
     */
    public File getReceiptObject() {
      return (this.receipt != null) ? this.receipt.getExpanded() : null;
    }

    public void setReceiptObject(File expandableObject) {
      this.receipt = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code refundPolicy} object.
     */
    public String getRefundPolicy() {
      return (this.refundPolicy != null) ? this.refundPolicy.getId() : null;
    }

    public void setRefundPolicy(String id) {
      this.refundPolicy = ApiResource.setExpandableFieldId(id, this.refundPolicy);
    }

    /**
     * Get expanded {@code refundPolicy}.
     */
    public File getRefundPolicyObject() {
      return (this.refundPolicy != null) ? this.refundPolicy.getExpanded() : null;
    }

    public void setRefundPolicyObject(File expandableObject) {
      this.refundPolicy = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code serviceDocumentation} object.
     */
    public String getServiceDocumentation() {
      return (this.serviceDocumentation != null) ? this.serviceDocumentation.getId() : null;
    }

    public void setServiceDocumentation(String id) {
      this.serviceDocumentation = ApiResource.setExpandableFieldId(id, this.serviceDocumentation);
    }

    /**
     * Get expanded {@code serviceDocumentation}.
     */
    public File getServiceDocumentationObject() {
      return (this.serviceDocumentation != null) ? this.serviceDocumentation.getExpanded() : null;
    }

    public void setServiceDocumentationObject(File expandableObject) {
      this.serviceDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code shippingDocumentation} object.
     */
    public String getShippingDocumentation() {
      return (this.shippingDocumentation != null) ? this.shippingDocumentation.getId() : null;
    }

    public void setShippingDocumentation(String id) {
      this.shippingDocumentation = ApiResource.setExpandableFieldId(id, this.shippingDocumentation);
    }

    /**
     * Get expanded {@code shippingDocumentation}.
     */
    public File getShippingDocumentationObject() {
      return (this.shippingDocumentation != null) ? this.shippingDocumentation.getExpanded() : null;
    }

    public void setShippingDocumentationObject(File expandableObject) {
      this.shippingDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code uncategorizedFile} object.
     */
    public String getUncategorizedFile() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getId() : null;
    }

    public void setUncategorizedFile(String id) {
      this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
    }

    /**
     * Get expanded {@code uncategorizedFile}.
     */
    public File getUncategorizedFileObject() {
      return (this.uncategorizedFile != null) ? this.uncategorizedFile.getExpanded() : null;
    }

    public void setUncategorizedFileObject(File expandableObject) {
      this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Any server or activity logs showing proof that the customer accessed or downloaded the
     * purchased digital product. This information should include IP addresses, corresponding
     * timestamps, and any detailed recorded activity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAccessActivityLog() {
      return this.accessActivityLog;
    }

    /**
     * The billing address provided by the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBillingAddress() {
      return this.billingAddress;
    }

    /**
     * An explanation of how and when the customer was shown your refund policy prior to purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCancellationPolicyDisclosure() {
      return this.cancellationPolicyDisclosure;
    }

    /**
     * A justification for why the customer's subscription was not canceled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCancellationRebuttal() {
      return this.cancellationRebuttal;
    }

    /**
     * The email address of the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomerEmailAddress() {
      return this.customerEmailAddress;
    }

    /**
     * The name of the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomerName() {
      return this.customerName;
    }

    /**
     * The IP address that the customer used when making the purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomerPurchaseIp() {
      return this.customerPurchaseIp;
    }

    /**
     * An explanation of the difference between the disputed charge versus the prior charge that
     * appears to be a duplicate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDuplicateChargeExplanation() {
      return this.duplicateChargeExplanation;
    }

    /**
     * The Stripe ID for the prior charge which appears to be a duplicate of the disputed charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDuplicateChargeId() {
      return this.duplicateChargeId;
    }

    /**
     * A description of the product or service that was sold.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProductDescription() {
      return this.productDescription;
    }

    /**
     * Documentation demonstrating that the customer was shown your refund policy prior to purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundPolicyDisclosure() {
      return this.refundPolicyDisclosure;
    }

    /**
     * A justification for why the customer is not entitled to a refund.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundRefusalExplanation() {
      return this.refundRefusalExplanation;
    }

    /**
     * The date on which the customer received or began receiving the purchased service, in a clear
     * human-readable format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getServiceDate() {
      return this.serviceDate;
    }

    /**
     * The address to which a physical product was shipped. You should try to include as complete
     * address information as possible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingAddress() {
      return this.shippingAddress;
    }

    /**
     * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc. If
     * multiple carriers were used for this purchase, please separate them with commas.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingCarrier() {
      return this.shippingCarrier;
    }

    /**
     * The date on which a physical product began its route to the shipping address, in a clear
     * human-readable format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingDate() {
      return this.shippingDate;
    }

    /**
     * The tracking number for a physical product, obtained from the delivery service. If multiple
     * tracking numbers were generated for this purchase, please separate them with commas.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingTrackingNumber() {
      return this.shippingTrackingNumber;
    }

    /**
     * Any additional evidence or statements.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUncategorizedText() {
      return this.uncategorizedText;
    }

    /**
     * Any server or activity logs showing proof that the customer accessed or downloaded the
     * purchased digital product. This information should include IP addresses, corresponding
     * timestamps, and any detailed recorded activity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAccessActivityLog(final String accessActivityLog) {
      this.accessActivityLog = accessActivityLog;
    }

    /**
     * The billing address provided by the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingAddress(final String billingAddress) {
      this.billingAddress = billingAddress;
    }

    /**
     * An explanation of how and when the customer was shown your refund policy prior to purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancellationPolicyDisclosure(final String cancellationPolicyDisclosure) {
      this.cancellationPolicyDisclosure = cancellationPolicyDisclosure;
    }

    /**
     * A justification for why the customer's subscription was not canceled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancellationRebuttal(final String cancellationRebuttal) {
      this.cancellationRebuttal = cancellationRebuttal;
    }

    /**
     * The email address of the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerEmailAddress(final String customerEmailAddress) {
      this.customerEmailAddress = customerEmailAddress;
    }

    /**
     * The name of the customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerName(final String customerName) {
      this.customerName = customerName;
    }

    /**
     * The IP address that the customer used when making the purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerPurchaseIp(final String customerPurchaseIp) {
      this.customerPurchaseIp = customerPurchaseIp;
    }

    /**
     * An explanation of the difference between the disputed charge versus the prior charge that
     * appears to be a duplicate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDuplicateChargeExplanation(final String duplicateChargeExplanation) {
      this.duplicateChargeExplanation = duplicateChargeExplanation;
    }

    /**
     * The Stripe ID for the prior charge which appears to be a duplicate of the disputed charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDuplicateChargeId(final String duplicateChargeId) {
      this.duplicateChargeId = duplicateChargeId;
    }

    /**
     * A description of the product or service that was sold.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProductDescription(final String productDescription) {
      this.productDescription = productDescription;
    }

    /**
     * Documentation demonstrating that the customer was shown your refund policy prior to purchase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundPolicyDisclosure(final String refundPolicyDisclosure) {
      this.refundPolicyDisclosure = refundPolicyDisclosure;
    }

    /**
     * A justification for why the customer is not entitled to a refund.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundRefusalExplanation(final String refundRefusalExplanation) {
      this.refundRefusalExplanation = refundRefusalExplanation;
    }

    /**
     * The date on which the customer received or began receiving the purchased service, in a clear
     * human-readable format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setServiceDate(final String serviceDate) {
      this.serviceDate = serviceDate;
    }

    /**
     * The address to which a physical product was shipped. You should try to include as complete
     * address information as possible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingAddress(final String shippingAddress) {
      this.shippingAddress = shippingAddress;
    }

    /**
     * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc. If
     * multiple carriers were used for this purchase, please separate them with commas.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingCarrier(final String shippingCarrier) {
      this.shippingCarrier = shippingCarrier;
    }

    /**
     * The date on which a physical product began its route to the shipping address, in a clear
     * human-readable format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingDate(final String shippingDate) {
      this.shippingDate = shippingDate;
    }

    /**
     * The tracking number for a physical product, obtained from the delivery service. If multiple
     * tracking numbers were generated for this purchase, please separate them with commas.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingTrackingNumber(final String shippingTrackingNumber) {
      this.shippingTrackingNumber = shippingTrackingNumber;
    }

    /**
     * Any additional evidence or statements.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUncategorizedText(final String uncategorizedText) {
      this.uncategorizedText = uncategorizedText;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.Evidence)) return false;
      final Dispute.Evidence other = (Dispute.Evidence) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$accessActivityLog = this.getAccessActivityLog();
      final java.lang.Object other$accessActivityLog = other.getAccessActivityLog();
      if (this$accessActivityLog == null ? other$accessActivityLog != null : !this$accessActivityLog.equals(other$accessActivityLog)) return false;
      final java.lang.Object this$billingAddress = this.getBillingAddress();
      final java.lang.Object other$billingAddress = other.getBillingAddress();
      if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
      final java.lang.Object this$cancellationPolicy = this.getCancellationPolicy();
      final java.lang.Object other$cancellationPolicy = other.getCancellationPolicy();
      if (this$cancellationPolicy == null ? other$cancellationPolicy != null : !this$cancellationPolicy.equals(other$cancellationPolicy)) return false;
      final java.lang.Object this$cancellationPolicyDisclosure = this.getCancellationPolicyDisclosure();
      final java.lang.Object other$cancellationPolicyDisclosure = other.getCancellationPolicyDisclosure();
      if (this$cancellationPolicyDisclosure == null ? other$cancellationPolicyDisclosure != null : !this$cancellationPolicyDisclosure.equals(other$cancellationPolicyDisclosure)) return false;
      final java.lang.Object this$cancellationRebuttal = this.getCancellationRebuttal();
      final java.lang.Object other$cancellationRebuttal = other.getCancellationRebuttal();
      if (this$cancellationRebuttal == null ? other$cancellationRebuttal != null : !this$cancellationRebuttal.equals(other$cancellationRebuttal)) return false;
      final java.lang.Object this$customerCommunication = this.getCustomerCommunication();
      final java.lang.Object other$customerCommunication = other.getCustomerCommunication();
      if (this$customerCommunication == null ? other$customerCommunication != null : !this$customerCommunication.equals(other$customerCommunication)) return false;
      final java.lang.Object this$customerEmailAddress = this.getCustomerEmailAddress();
      final java.lang.Object other$customerEmailAddress = other.getCustomerEmailAddress();
      if (this$customerEmailAddress == null ? other$customerEmailAddress != null : !this$customerEmailAddress.equals(other$customerEmailAddress)) return false;
      final java.lang.Object this$customerName = this.getCustomerName();
      final java.lang.Object other$customerName = other.getCustomerName();
      if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) return false;
      final java.lang.Object this$customerPurchaseIp = this.getCustomerPurchaseIp();
      final java.lang.Object other$customerPurchaseIp = other.getCustomerPurchaseIp();
      if (this$customerPurchaseIp == null ? other$customerPurchaseIp != null : !this$customerPurchaseIp.equals(other$customerPurchaseIp)) return false;
      final java.lang.Object this$customerSignature = this.getCustomerSignature();
      final java.lang.Object other$customerSignature = other.getCustomerSignature();
      if (this$customerSignature == null ? other$customerSignature != null : !this$customerSignature.equals(other$customerSignature)) return false;
      final java.lang.Object this$duplicateChargeDocumentation = this.getDuplicateChargeDocumentation();
      final java.lang.Object other$duplicateChargeDocumentation = other.getDuplicateChargeDocumentation();
      if (this$duplicateChargeDocumentation == null ? other$duplicateChargeDocumentation != null : !this$duplicateChargeDocumentation.equals(other$duplicateChargeDocumentation)) return false;
      final java.lang.Object this$duplicateChargeExplanation = this.getDuplicateChargeExplanation();
      final java.lang.Object other$duplicateChargeExplanation = other.getDuplicateChargeExplanation();
      if (this$duplicateChargeExplanation == null ? other$duplicateChargeExplanation != null : !this$duplicateChargeExplanation.equals(other$duplicateChargeExplanation)) return false;
      final java.lang.Object this$duplicateChargeId = this.getDuplicateChargeId();
      final java.lang.Object other$duplicateChargeId = other.getDuplicateChargeId();
      if (this$duplicateChargeId == null ? other$duplicateChargeId != null : !this$duplicateChargeId.equals(other$duplicateChargeId)) return false;
      final java.lang.Object this$productDescription = this.getProductDescription();
      final java.lang.Object other$productDescription = other.getProductDescription();
      if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
      final java.lang.Object this$receipt = this.getReceipt();
      final java.lang.Object other$receipt = other.getReceipt();
      if (this$receipt == null ? other$receipt != null : !this$receipt.equals(other$receipt)) return false;
      final java.lang.Object this$refundPolicy = this.getRefundPolicy();
      final java.lang.Object other$refundPolicy = other.getRefundPolicy();
      if (this$refundPolicy == null ? other$refundPolicy != null : !this$refundPolicy.equals(other$refundPolicy)) return false;
      final java.lang.Object this$refundPolicyDisclosure = this.getRefundPolicyDisclosure();
      final java.lang.Object other$refundPolicyDisclosure = other.getRefundPolicyDisclosure();
      if (this$refundPolicyDisclosure == null ? other$refundPolicyDisclosure != null : !this$refundPolicyDisclosure.equals(other$refundPolicyDisclosure)) return false;
      final java.lang.Object this$refundRefusalExplanation = this.getRefundRefusalExplanation();
      final java.lang.Object other$refundRefusalExplanation = other.getRefundRefusalExplanation();
      if (this$refundRefusalExplanation == null ? other$refundRefusalExplanation != null : !this$refundRefusalExplanation.equals(other$refundRefusalExplanation)) return false;
      final java.lang.Object this$serviceDate = this.getServiceDate();
      final java.lang.Object other$serviceDate = other.getServiceDate();
      if (this$serviceDate == null ? other$serviceDate != null : !this$serviceDate.equals(other$serviceDate)) return false;
      final java.lang.Object this$serviceDocumentation = this.getServiceDocumentation();
      final java.lang.Object other$serviceDocumentation = other.getServiceDocumentation();
      if (this$serviceDocumentation == null ? other$serviceDocumentation != null : !this$serviceDocumentation.equals(other$serviceDocumentation)) return false;
      final java.lang.Object this$shippingAddress = this.getShippingAddress();
      final java.lang.Object other$shippingAddress = other.getShippingAddress();
      if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) return false;
      final java.lang.Object this$shippingCarrier = this.getShippingCarrier();
      final java.lang.Object other$shippingCarrier = other.getShippingCarrier();
      if (this$shippingCarrier == null ? other$shippingCarrier != null : !this$shippingCarrier.equals(other$shippingCarrier)) return false;
      final java.lang.Object this$shippingDate = this.getShippingDate();
      final java.lang.Object other$shippingDate = other.getShippingDate();
      if (this$shippingDate == null ? other$shippingDate != null : !this$shippingDate.equals(other$shippingDate)) return false;
      final java.lang.Object this$shippingDocumentation = this.getShippingDocumentation();
      final java.lang.Object other$shippingDocumentation = other.getShippingDocumentation();
      if (this$shippingDocumentation == null ? other$shippingDocumentation != null : !this$shippingDocumentation.equals(other$shippingDocumentation)) return false;
      final java.lang.Object this$shippingTrackingNumber = this.getShippingTrackingNumber();
      final java.lang.Object other$shippingTrackingNumber = other.getShippingTrackingNumber();
      if (this$shippingTrackingNumber == null ? other$shippingTrackingNumber != null : !this$shippingTrackingNumber.equals(other$shippingTrackingNumber)) return false;
      final java.lang.Object this$uncategorizedFile = this.getUncategorizedFile();
      final java.lang.Object other$uncategorizedFile = other.getUncategorizedFile();
      if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) return false;
      final java.lang.Object this$uncategorizedText = this.getUncategorizedText();
      final java.lang.Object other$uncategorizedText = other.getUncategorizedText();
      if (this$uncategorizedText == null ? other$uncategorizedText != null : !this$uncategorizedText.equals(other$uncategorizedText)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.Evidence;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $accessActivityLog = this.getAccessActivityLog();
      result = result * PRIME + ($accessActivityLog == null ? 43 : $accessActivityLog.hashCode());
      final java.lang.Object $billingAddress = this.getBillingAddress();
      result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
      final java.lang.Object $cancellationPolicy = this.getCancellationPolicy();
      result = result * PRIME + ($cancellationPolicy == null ? 43 : $cancellationPolicy.hashCode());
      final java.lang.Object $cancellationPolicyDisclosure = this.getCancellationPolicyDisclosure();
      result = result * PRIME + ($cancellationPolicyDisclosure == null ? 43 : $cancellationPolicyDisclosure.hashCode());
      final java.lang.Object $cancellationRebuttal = this.getCancellationRebuttal();
      result = result * PRIME + ($cancellationRebuttal == null ? 43 : $cancellationRebuttal.hashCode());
      final java.lang.Object $customerCommunication = this.getCustomerCommunication();
      result = result * PRIME + ($customerCommunication == null ? 43 : $customerCommunication.hashCode());
      final java.lang.Object $customerEmailAddress = this.getCustomerEmailAddress();
      result = result * PRIME + ($customerEmailAddress == null ? 43 : $customerEmailAddress.hashCode());
      final java.lang.Object $customerName = this.getCustomerName();
      result = result * PRIME + ($customerName == null ? 43 : $customerName.hashCode());
      final java.lang.Object $customerPurchaseIp = this.getCustomerPurchaseIp();
      result = result * PRIME + ($customerPurchaseIp == null ? 43 : $customerPurchaseIp.hashCode());
      final java.lang.Object $customerSignature = this.getCustomerSignature();
      result = result * PRIME + ($customerSignature == null ? 43 : $customerSignature.hashCode());
      final java.lang.Object $duplicateChargeDocumentation = this.getDuplicateChargeDocumentation();
      result = result * PRIME + ($duplicateChargeDocumentation == null ? 43 : $duplicateChargeDocumentation.hashCode());
      final java.lang.Object $duplicateChargeExplanation = this.getDuplicateChargeExplanation();
      result = result * PRIME + ($duplicateChargeExplanation == null ? 43 : $duplicateChargeExplanation.hashCode());
      final java.lang.Object $duplicateChargeId = this.getDuplicateChargeId();
      result = result * PRIME + ($duplicateChargeId == null ? 43 : $duplicateChargeId.hashCode());
      final java.lang.Object $productDescription = this.getProductDescription();
      result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
      final java.lang.Object $receipt = this.getReceipt();
      result = result * PRIME + ($receipt == null ? 43 : $receipt.hashCode());
      final java.lang.Object $refundPolicy = this.getRefundPolicy();
      result = result * PRIME + ($refundPolicy == null ? 43 : $refundPolicy.hashCode());
      final java.lang.Object $refundPolicyDisclosure = this.getRefundPolicyDisclosure();
      result = result * PRIME + ($refundPolicyDisclosure == null ? 43 : $refundPolicyDisclosure.hashCode());
      final java.lang.Object $refundRefusalExplanation = this.getRefundRefusalExplanation();
      result = result * PRIME + ($refundRefusalExplanation == null ? 43 : $refundRefusalExplanation.hashCode());
      final java.lang.Object $serviceDate = this.getServiceDate();
      result = result * PRIME + ($serviceDate == null ? 43 : $serviceDate.hashCode());
      final java.lang.Object $serviceDocumentation = this.getServiceDocumentation();
      result = result * PRIME + ($serviceDocumentation == null ? 43 : $serviceDocumentation.hashCode());
      final java.lang.Object $shippingAddress = this.getShippingAddress();
      result = result * PRIME + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
      final java.lang.Object $shippingCarrier = this.getShippingCarrier();
      result = result * PRIME + ($shippingCarrier == null ? 43 : $shippingCarrier.hashCode());
      final java.lang.Object $shippingDate = this.getShippingDate();
      result = result * PRIME + ($shippingDate == null ? 43 : $shippingDate.hashCode());
      final java.lang.Object $shippingDocumentation = this.getShippingDocumentation();
      result = result * PRIME + ($shippingDocumentation == null ? 43 : $shippingDocumentation.hashCode());
      final java.lang.Object $shippingTrackingNumber = this.getShippingTrackingNumber();
      result = result * PRIME + ($shippingTrackingNumber == null ? 43 : $shippingTrackingNumber.hashCode());
      final java.lang.Object $uncategorizedFile = this.getUncategorizedFile();
      result = result * PRIME + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
      final java.lang.Object $uncategorizedText = this.getUncategorizedText();
      result = result * PRIME + ($uncategorizedText == null ? 43 : $uncategorizedText.hashCode());
      return result;
    }
  }


  public static class EvidenceDetails extends StripeObject {
    /**
     * Date by which evidence must be submitted in order to successfully challenge dispute. Will be
     * null if the customer's bank or credit card company doesn't allow a response for this
     * particular dispute.
     */
    @SerializedName("due_by")
    Long dueBy;
    /** Whether evidence has been staged for this dispute. */
    @SerializedName("has_evidence")
    Boolean hasEvidence;
    /**
     * Whether the last evidence submission was submitted past the due date. Defaults to {@code
     * false} if no evidence submissions have occurred. If {@code true}, then delivery of the latest
     * evidence is <em>not</em> guaranteed.
     */
    @SerializedName("past_due")
    Boolean pastDue;
    /**
     * The number of times evidence has been submitted. Typically, you may only submit evidence
     * once.
     */
    @SerializedName("submission_count")
    Long submissionCount;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDueBy() {
      return this.dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasEvidence() {
      return this.hasEvidence;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPastDue() {
      return this.pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSubmissionCount() {
      return this.submissionCount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDueBy(final Long dueBy) {
      this.dueBy = dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHasEvidence(final Boolean hasEvidence) {
      this.hasEvidence = hasEvidence;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final Boolean pastDue) {
      this.pastDue = pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSubmissionCount(final Long submissionCount) {
      this.submissionCount = submissionCount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceDetails)) return false;
      final Dispute.EvidenceDetails other = (Dispute.EvidenceDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$dueBy = this.getDueBy();
      final java.lang.Object other$dueBy = other.getDueBy();
      if (this$dueBy == null ? other$dueBy != null : !this$dueBy.equals(other$dueBy)) return false;
      final java.lang.Object this$hasEvidence = this.getHasEvidence();
      final java.lang.Object other$hasEvidence = other.getHasEvidence();
      if (this$hasEvidence == null ? other$hasEvidence != null : !this$hasEvidence.equals(other$hasEvidence)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$submissionCount = this.getSubmissionCount();
      final java.lang.Object other$submissionCount = other.getSubmissionCount();
      if (this$submissionCount == null ? other$submissionCount != null : !this$submissionCount.equals(other$submissionCount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $dueBy = this.getDueBy();
      result = result * PRIME + ($dueBy == null ? 43 : $dueBy.hashCode());
      final java.lang.Object $hasEvidence = this.getHasEvidence();
      result = result * PRIME + ($hasEvidence == null ? 43 : $hasEvidence.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $submissionCount = this.getSubmissionCount();
      result = result * PRIME + ($submissionCount == null ? 43 : $submissionCount.hashCode());
      return result;
    }
  }

  /**
   * Disputed amount. Usually the amount of the charge, but can differ (usually because of currency
   * fluctuation or because only part of the order is disputed).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * List of zero, one, or two balance transactions that show funds withdrawn and reinstated to your
   * Stripe account as a result of this dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction> getBalanceTransactions() {
    return this.balanceTransactions;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Evidence getEvidence() {
    return this.evidence;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EvidenceDetails getEvidenceDetails() {
    return this.evidenceDetails;
  }

  /**
   * If true, it is still possible to refund the disputed payment. Once the payment has been fully
   * refunded, no further funds will be withdrawn from your Stripe account as a result of this
   * dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIsChargeRefundable() {
    return this.isChargeRefundable;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Network-dependent reason code for the dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNetworkReasonCode() {
    return this.networkReasonCode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Reason given by cardholder for dispute. Possible values are {@code bank_cannot_process}, {@code
   * check_returned}, {@code credit_not_processed}, {@code customer_initiated}, {@code
   * debit_not_authorized}, {@code duplicate}, {@code fraudulent}, {@code general}, {@code
   * incorrect_account_details}, {@code insufficient_funds}, {@code product_not_received}, {@code
   * product_unacceptable}, {@code subscription_canceled}, or {@code unrecognized}. Read more about
   * <a href="https://stripe.com/docs/disputes/categories">dispute reasons</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  /**
   * Current status of dispute. Possible values are {@code warning_needs_response}, {@code
   * warning_under_review}, {@code warning_closed}, {@code needs_response}, {@code under_review},
   * {@code charge_refunded}, {@code won}, or {@code lost}.
   *
   * <p>One of {@code charge_refunded}, {@code lost}, {@code needs_response}, {@code under_review},
   * {@code warning_closed}, {@code warning_needs_response}, {@code warning_under_review}, or {@code
   * won}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Disputed amount. Usually the amount of the charge, but can differ (usually because of currency
   * fluctuation or because only part of the order is disputed).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * List of zero, one, or two balance transactions that show funds withdrawn and reinstated to your
   * Stripe account as a result of this dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransactions(final List<BalanceTransaction> balanceTransactions) {
    this.balanceTransactions = balanceTransactions;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidence(final Evidence evidence) {
    this.evidence = evidence;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidenceDetails(final EvidenceDetails evidenceDetails) {
    this.evidenceDetails = evidenceDetails;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * If true, it is still possible to refund the disputed payment. Once the payment has been fully
   * refunded, no further funds will be withdrawn from your Stripe account as a result of this
   * dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsChargeRefundable(final Boolean isChargeRefundable) {
    this.isChargeRefundable = isChargeRefundable;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * Network-dependent reason code for the dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkReasonCode(final String networkReasonCode) {
    this.networkReasonCode = networkReasonCode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Reason given by cardholder for dispute. Possible values are {@code bank_cannot_process}, {@code
   * check_returned}, {@code credit_not_processed}, {@code customer_initiated}, {@code
   * debit_not_authorized}, {@code duplicate}, {@code fraudulent}, {@code general}, {@code
   * incorrect_account_details}, {@code insufficient_funds}, {@code product_not_received}, {@code
   * product_unacceptable}, {@code subscription_canceled}, or {@code unrecognized}. Read more about
   * <a href="https://stripe.com/docs/disputes/categories">dispute reasons</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  /**
   * Current status of dispute. Possible values are {@code warning_needs_response}, {@code
   * warning_under_review}, {@code warning_closed}, {@code needs_response}, {@code under_review},
   * {@code charge_refunded}, {@code won}, or {@code lost}.
   *
   * <p>One of {@code charge_refunded}, {@code lost}, {@code needs_response}, {@code under_review},
   * {@code warning_closed}, {@code warning_needs_response}, {@code warning_under_review}, or {@code
   * won}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Dispute)) return false;
    final Dispute other = (Dispute) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$balanceTransactions = this.getBalanceTransactions();
    final java.lang.Object other$balanceTransactions = other.getBalanceTransactions();
    if (this$balanceTransactions == null ? other$balanceTransactions != null : !this$balanceTransactions.equals(other$balanceTransactions)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$evidence = this.getEvidence();
    final java.lang.Object other$evidence = other.getEvidence();
    if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) return false;
    final java.lang.Object this$evidenceDetails = this.getEvidenceDetails();
    final java.lang.Object other$evidenceDetails = other.getEvidenceDetails();
    if (this$evidenceDetails == null ? other$evidenceDetails != null : !this$evidenceDetails.equals(other$evidenceDetails)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$isChargeRefundable = this.getIsChargeRefundable();
    final java.lang.Object other$isChargeRefundable = other.getIsChargeRefundable();
    if (this$isChargeRefundable == null ? other$isChargeRefundable != null : !this$isChargeRefundable.equals(other$isChargeRefundable)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$networkReasonCode = this.getNetworkReasonCode();
    final java.lang.Object other$networkReasonCode = other.getNetworkReasonCode();
    if (this$networkReasonCode == null ? other$networkReasonCode != null : !this$networkReasonCode.equals(other$networkReasonCode)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Dispute;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $balanceTransactions = this.getBalanceTransactions();
    result = result * PRIME + ($balanceTransactions == null ? 43 : $balanceTransactions.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $evidence = this.getEvidence();
    result = result * PRIME + ($evidence == null ? 43 : $evidence.hashCode());
    final java.lang.Object $evidenceDetails = this.getEvidenceDetails();
    result = result * PRIME + ($evidenceDetails == null ? 43 : $evidenceDetails.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $isChargeRefundable = this.getIsChargeRefundable();
    result = result * PRIME + ($isChargeRefundable == null ? 43 : $isChargeRefundable.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $networkReasonCode = this.getNetworkReasonCode();
    result = result * PRIME + ($networkReasonCode == null ? 43 : $networkReasonCode.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
