// Generated by delombok at Fri Jul 31 14:02:13 EDT 2020
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TransferReversalUpdateParams;
import java.util.Map;

public class TransferReversal extends ApiResource implements MetadataStore<TransferReversal>, BalanceTransactionSource {
  /**
   * Amount, in %s.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Balance transaction that describes the impact on your account balance.
   */
  @SerializedName("balance_transaction")
  ExpandableField<BalanceTransaction> balanceTransaction;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Linked payment refund for the transfer reversal.
   */
  @SerializedName("destination_payment_refund")
  ExpandableField<Refund> destinationPaymentRefund;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code transfer_reversal}.
   */
  @SerializedName("object")
  String object;
  /**
   * ID of the refund responsible for the transfer reversal.
   */
  @SerializedName("source_refund")
  ExpandableField<Refund> sourceRefund;
  /**
   * ID of the transfer that was reversed.
   */
  @SerializedName("transfer")
  ExpandableField<Transfer> transfer;

  /**
   * Get ID of expandable {@code balanceTransaction} object.
   */
  public String getBalanceTransaction() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getId() : null;
  }

  public void setBalanceTransaction(String id) {
    this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
  }

  /**
   * Get expanded {@code balanceTransaction}.
   */
  public BalanceTransaction getBalanceTransactionObject() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getExpanded() : null;
  }

  public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
    this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code destinationPaymentRefund} object.
   */
  public String getDestinationPaymentRefund() {
    return (this.destinationPaymentRefund != null) ? this.destinationPaymentRefund.getId() : null;
  }

  public void setDestinationPaymentRefund(String id) {
    this.destinationPaymentRefund = ApiResource.setExpandableFieldId(id, this.destinationPaymentRefund);
  }

  /**
   * Get expanded {@code destinationPaymentRefund}.
   */
  public Refund getDestinationPaymentRefundObject() {
    return (this.destinationPaymentRefund != null) ? this.destinationPaymentRefund.getExpanded() : null;
  }

  public void setDestinationPaymentRefundObject(Refund expandableObject) {
    this.destinationPaymentRefund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code sourceRefund} object.
   */
  public String getSourceRefund() {
    return (this.sourceRefund != null) ? this.sourceRefund.getId() : null;
  }

  public void setSourceRefund(String id) {
    this.sourceRefund = ApiResource.setExpandableFieldId(id, this.sourceRefund);
  }

  /**
   * Get expanded {@code sourceRefund}.
   */
  public Refund getSourceRefundObject() {
    return (this.sourceRefund != null) ? this.sourceRefund.getExpanded() : null;
  }

  public void setSourceRefundObject(Refund expandableObject) {
    this.sourceRefund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code transfer} object.
   */
  public String getTransfer() {
    return (this.transfer != null) ? this.transfer.getId() : null;
  }

  public void setTransfer(String id) {
    this.transfer = ApiResource.setExpandableFieldId(id, this.transfer);
  }

  /**
   * Get expanded {@code transfer}.
   */
  public Transfer getTransferObject() {
    return (this.transfer != null) ? this.transfer.getExpanded() : null;
  }

  public void setTransferObject(Transfer expandableObject) {
    this.transfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Updates the specified reversal by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged.
   *
   * <p>This request only accepts metadata and description as arguments.
   */
  @Override
  public TransferReversal update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified reversal by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged.
   *
   * <p>This request only accepts metadata and description as arguments.
   */
  @Override
  public TransferReversal update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(this.getTransfer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TransferReversal.class, options);
  }

  /**
   * Updates the specified reversal by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged.
   *
   * <p>This request only accepts metadata and description as arguments.
   */
  public TransferReversal update(TransferReversalUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified reversal by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged.
   *
   * <p>This request only accepts metadata and description as arguments.
   */
  public TransferReversal update(TransferReversalUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(this.getTransfer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TransferReversal.class, options);
  }

  /**
   * Amount, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code transfer_reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Amount, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code transfer_reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TransferReversal)) return false;
    final TransferReversal other = (TransferReversal) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$balanceTransaction = this.getBalanceTransaction();
    final java.lang.Object other$balanceTransaction = other.getBalanceTransaction();
    if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$destinationPaymentRefund = this.getDestinationPaymentRefund();
    final java.lang.Object other$destinationPaymentRefund = other.getDestinationPaymentRefund();
    if (this$destinationPaymentRefund == null ? other$destinationPaymentRefund != null : !this$destinationPaymentRefund.equals(other$destinationPaymentRefund)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$sourceRefund = this.getSourceRefund();
    final java.lang.Object other$sourceRefund = other.getSourceRefund();
    if (this$sourceRefund == null ? other$sourceRefund != null : !this$sourceRefund.equals(other$sourceRefund)) return false;
    final java.lang.Object this$transfer = this.getTransfer();
    final java.lang.Object other$transfer = other.getTransfer();
    if (this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TransferReversal;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $balanceTransaction = this.getBalanceTransaction();
    result = result * PRIME + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $destinationPaymentRefund = this.getDestinationPaymentRefund();
    result = result * PRIME + ($destinationPaymentRefund == null ? 43 : $destinationPaymentRefund.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $sourceRefund = this.getSourceRefund();
    result = result * PRIME + ($sourceRefund == null ? 43 : $sourceRefund.hashCode());
    final java.lang.Object $transfer = this.getTransfer();
    result = result * PRIME + ($transfer == null ? 43 : $transfer.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
