// Generated by delombok at Mon Aug 31 13:06:13 PDT 2020
package com.stripe.model.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItem;
import com.stripe.model.LineItemCollection;
import com.stripe.model.PaymentIntent;
import com.stripe.model.SetupIntent;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.checkout.SessionCreateParams;
import com.stripe.param.checkout.SessionListLineItemsParams;
import com.stripe.param.checkout.SessionListParams;
import com.stripe.param.checkout.SessionRetrieveParams;
import java.util.List;
import java.util.Map;

public class Session extends ApiResource implements HasId {
  /**
   * Enables user redeemable promotion codes.
   */
  @SerializedName("allow_promotion_codes")
  Boolean allowPromotionCodes;
  /**
   * Total of all items before discounts or taxes are applied.
   */
  @SerializedName("amount_subtotal")
  Long amountSubtotal;
  /**
   * Total of all items after discounts and taxes are applied.
   */
  @SerializedName("amount_total")
  Long amountTotal;
  /**
   * Describes whether Checkout should collect the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @SerializedName("billing_address_collection")
  String billingAddressCollection;
  /**
   * The URL the customer will be directed to if they decide to cancel payment and return to your
   * website.
   */
  @SerializedName("cancel_url")
  String cancelUrl;
  /**
   * A unique string to reference the Checkout Session. This can be a customer ID, a cart ID, or
   * similar, and can be used to reconcile the session with your internal systems.
   */
  @SerializedName("client_reference_id")
  String clientReferenceId;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The ID of the customer for this session. For Checkout Sessions in {@code payment} or {@code
   * subscription} mode, Checkout will create a new customer object based on information provided
   * during the session unless an existing customer was provided when the session was created.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * If provided, this value will be used when the Customer object is created. If not provided,
   * customers will be asked to enter their email address. Use this parameter to prefill customer
   * data if you already have an email on file. To access information about the customer once a
   * session is complete, use the {@code customer} attribute.
   */
  @SerializedName("customer_email")
  String customerEmail;
  /**
   * Unique identifier for the object. Used to pass to {@code redirectToCheckout} in Stripe.js.
   */
  @SerializedName("id")
  String id;
  /**
   * The line items purchased by the customer.
   */
  @SerializedName("line_items")
  LineItemCollection lineItems;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The IETF language tag of the locale Checkout is displayed in. If blank or {@code auto}, the
   * browser's locale is used.
   *
   * <p>One of {@code auto}, {@code bg}, {@code cs}, {@code da}, {@code de}, {@code el}, {@code en},
   * {@code en-GB}, {@code es}, {@code es-419}, {@code et}, {@code fi}, {@code fr}, {@code fr-CA},
   * {@code hu}, {@code id}, {@code it}, {@code ja}, {@code lt}, {@code lv}, {@code ms}, {@code mt},
   * {@code nb}, {@code nl}, {@code pl}, {@code pt}, {@code pt-BR}, {@code ro}, {@code ru}, {@code
   * sk}, {@code sl}, {@code sv}, {@code tr}, {@code zh}, {@code zh-HK}, or {@code zh-TW}.
   */
  @SerializedName("locale")
  String locale;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The mode of the Checkout Session, one of {@code payment}, {@code setup}, or {@code
   * subscription}.
   */
  @SerializedName("mode")
  String mode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code checkout.session}.
   */
  @SerializedName("object")
  String object;
  /**
   * The ID of the PaymentIntent for Checkout Sessions in {@code payment} mode.
   */
  @SerializedName("payment_intent")
  ExpandableField<PaymentIntent> paymentIntent;
  /**
   * A list of the types of payment methods (e.g. card) this Checkout Session is allowed to accept.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  /**
   * The ID of the SetupIntent for Checkout Sessions in {@code setup} mode.
   */
  @SerializedName("setup_intent")
  ExpandableField<SetupIntent> setupIntent;
  /**
   * Shipping information for this Checkout Session.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * When set, provides configuration for Checkout to collect a shipping address from a customer.
   */
  @SerializedName("shipping_address_collection")
  ShippingAddressCollection shippingAddressCollection;
  /**
   * Describes the type of transaction being performed by Checkout in order to customize relevant
   * text on the page, such as the submit button. {@code submit_type} can only be specified on
   * Checkout Sessions in {@code payment} mode, but not Checkout Sessions in {@code subscription} or
   * {@code setup} mode.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @SerializedName("submit_type")
  String submitType;
  /**
   * The ID of the subscription for Checkout Sessions in {@code subscription} mode.
   */
  @SerializedName("subscription")
  ExpandableField<Subscription> subscription;
  /**
   * The URL the customer will be directed to after the payment or subscription creation is
   * successful.
   */
  @SerializedName("success_url")
  String successUrl;
  /**
   * Tax and discount details for the computed total amount.
   */
  @SerializedName("total_details")
  TotalDetails totalDetails;

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentIntent} object.
   */
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String id) {
    this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
  }

  /**
   * Get expanded {@code paymentIntent}.
   */
  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent expandableObject) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code setupIntent} object.
   */
  public String getSetupIntent() {
    return (this.setupIntent != null) ? this.setupIntent.getId() : null;
  }

  public void setSetupIntent(String id) {
    this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
  }

  /**
   * Get expanded {@code setupIntent}.
   */
  public SetupIntent getSetupIntentObject() {
    return (this.setupIntent != null) ? this.setupIntent.getExpanded() : null;
  }

  public void setSetupIntentObject(SetupIntent expandableObject) {
    this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code subscription} object.
   */
  public String getSubscription() {
    return (this.subscription != null) ? this.subscription.getId() : null;
  }

  public void setSubscription(String id) {
    this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
  }

  /**
   * Get expanded {@code subscription}.
   */
  public Subscription getSubscriptionObject() {
    return (this.subscription != null) ? this.subscription.getExpanded() : null;
  }

  public void setSubscriptionObject(Subscription expandableObject) {
    this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of Checkout Sessions.
   */
  public static SessionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Checkout Sessions.
   */
  public static SessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
    return ApiResource.requestCollection(url, params, SessionCollection.class, options);
  }

  /**
   * Returns a list of Checkout Sessions.
   */
  public static SessionCollection list(SessionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Checkout Sessions.
   */
  public static SessionCollection list(SessionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
    return ApiResource.requestCollection(url, params, SessionCollection.class, options);
  }

  /**
   * Retrieves a Session object.
   */
  public static Session retrieve(String session) throws StripeException {
    return retrieve(session, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a Session object.
   */
  public static Session retrieve(String session, RequestOptions options) throws StripeException {
    return retrieve(session, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a Session object.
   */
  public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
  }

  /**
   * Retrieves a Session object.
   */
  public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
  }

  /**
   * Creates a Session object.
   */
  public static Session create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a Session object.
   */
  public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
  }

  /**
   * Creates a Session object.
   */
  public static Session create(SessionCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a Session object.
   */
  public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
  }

  /**
   * Returns a list of Line Items
   */
  public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Line Items
   */
  public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * Returns a list of Line Items
   */
  public LineItemCollection listLineItems(SessionListLineItemsParams params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Line Items
   */
  public LineItemCollection listLineItems(SessionListLineItemsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }


  public static class ShippingAddressCollection extends StripeObject {
    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @SerializedName("allowed_countries")
    List<String> allowedCountries;

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCountries() {
      return this.allowedCountries;
    }

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCountries(final List<String> allowedCountries) {
      this.allowedCountries = allowedCountries;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Session.ShippingAddressCollection)) return false;
      final Session.ShippingAddressCollection other = (Session.ShippingAddressCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCountries = this.getAllowedCountries();
      final java.lang.Object other$allowedCountries = other.getAllowedCountries();
      if (this$allowedCountries == null ? other$allowedCountries != null : !this$allowedCountries.equals(other$allowedCountries)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Session.ShippingAddressCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCountries = this.getAllowedCountries();
      result = result * PRIME + ($allowedCountries == null ? 43 : $allowedCountries.hashCode());
      return result;
    }
  }


  public static class TotalDetails extends StripeObject {
    /** This is the sum of all the line item discounts. */
    @SerializedName("amount_discount")
    Long amountDiscount;
    /** This is the sum of all the line item tax amounts. */
    @SerializedName("amount_tax")
    Long amountTax;
    @SerializedName("breakdown")
    Breakdown breakdown;


    public static class Breakdown extends StripeObject {
      /** The aggregated line item discounts. */
      @SerializedName("discounts")
      List<LineItem.Discount> discounts;
      /** The aggregated line item tax amounts by rate. */
      @SerializedName("taxes")
      List<LineItem.Tax> taxes;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<LineItem.Discount> getDiscounts() {
        return this.discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<LineItem.Tax> getTaxes() {
        return this.taxes;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDiscounts(final List<LineItem.Discount> discounts) {
        this.discounts = discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTaxes(final List<LineItem.Tax> taxes) {
        this.taxes = taxes;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Session.TotalDetails.Breakdown)) return false;
        final Session.TotalDetails.Breakdown other = (Session.TotalDetails.Breakdown) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$discounts = this.getDiscounts();
        final java.lang.Object other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
        final java.lang.Object this$taxes = this.getTaxes();
        final java.lang.Object other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !this$taxes.equals(other$taxes)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Session.TotalDetails.Breakdown;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $discounts = this.getDiscounts();
        result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
        final java.lang.Object $taxes = this.getTaxes();
        result = result * PRIME + ($taxes == null ? 43 : $taxes.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountDiscount() {
      return this.amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountTax() {
      return this.amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Breakdown getBreakdown() {
      return this.breakdown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountDiscount(final Long amountDiscount) {
      this.amountDiscount = amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTax(final Long amountTax) {
      this.amountTax = amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBreakdown(final Breakdown breakdown) {
      this.breakdown = breakdown;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Session.TotalDetails)) return false;
      final Session.TotalDetails other = (Session.TotalDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountDiscount = this.getAmountDiscount();
      final java.lang.Object other$amountDiscount = other.getAmountDiscount();
      if (this$amountDiscount == null ? other$amountDiscount != null : !this$amountDiscount.equals(other$amountDiscount)) return false;
      final java.lang.Object this$amountTax = this.getAmountTax();
      final java.lang.Object other$amountTax = other.getAmountTax();
      if (this$amountTax == null ? other$amountTax != null : !this$amountTax.equals(other$amountTax)) return false;
      final java.lang.Object this$breakdown = this.getBreakdown();
      final java.lang.Object other$breakdown = other.getBreakdown();
      if (this$breakdown == null ? other$breakdown != null : !this$breakdown.equals(other$breakdown)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Session.TotalDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountDiscount = this.getAmountDiscount();
      result = result * PRIME + ($amountDiscount == null ? 43 : $amountDiscount.hashCode());
      final java.lang.Object $amountTax = this.getAmountTax();
      result = result * PRIME + ($amountTax == null ? 43 : $amountTax.hashCode());
      final java.lang.Object $breakdown = this.getBreakdown();
      result = result * PRIME + ($breakdown == null ? 43 : $breakdown.hashCode());
      return result;
    }
  }

  /**
   * Enables user redeemable promotion codes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAllowPromotionCodes() {
    return this.allowPromotionCodes;
  }

  /**
   * Total of all items before discounts or taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountSubtotal() {
    return this.amountSubtotal;
  }

  /**
   * Total of all items after discounts and taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountTotal() {
    return this.amountTotal;
  }

  /**
   * Describes whether Checkout should collect the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingAddressCollection() {
    return this.billingAddressCollection;
  }

  /**
   * The URL the customer will be directed to if they decide to cancel payment and return to your
   * website.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancelUrl() {
    return this.cancelUrl;
  }

  /**
   * A unique string to reference the Checkout Session. This can be a customer ID, a cart ID, or
   * similar, and can be used to reconcile the session with your internal systems.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientReferenceId() {
    return this.clientReferenceId;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * If provided, this value will be used when the Customer object is created. If not provided,
   * customers will be asked to enter their email address. Use this parameter to prefill customer
   * data if you already have an email on file. To access information about the customer once a
   * session is complete, use the {@code customer} attribute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerEmail() {
    return this.customerEmail;
  }

  /**
   * The line items purchased by the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineItemCollection getLineItems() {
    return this.lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The IETF language tag of the locale Checkout is displayed in. If blank or {@code auto}, the
   * browser's locale is used.
   *
   * <p>One of {@code auto}, {@code bg}, {@code cs}, {@code da}, {@code de}, {@code el}, {@code en},
   * {@code en-GB}, {@code es}, {@code es-419}, {@code et}, {@code fi}, {@code fr}, {@code fr-CA},
   * {@code hu}, {@code id}, {@code it}, {@code ja}, {@code lt}, {@code lv}, {@code ms}, {@code mt},
   * {@code nb}, {@code nl}, {@code pl}, {@code pt}, {@code pt-BR}, {@code ro}, {@code ru}, {@code
   * sk}, {@code sl}, {@code sv}, {@code tr}, {@code zh}, {@code zh-HK}, or {@code zh-TW}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLocale() {
    return this.locale;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * The mode of the Checkout Session, one of {@code payment}, {@code setup}, or {@code
   * subscription}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMode() {
    return this.mode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code checkout.session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * A list of the types of payment methods (e.g. card) this Checkout Session is allowed to accept.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * Shipping information for this Checkout Session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * When set, provides configuration for Checkout to collect a shipping address from a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingAddressCollection getShippingAddressCollection() {
    return this.shippingAddressCollection;
  }

  /**
   * Describes the type of transaction being performed by Checkout in order to customize relevant
   * text on the page, such as the submit button. {@code submit_type} can only be specified on
   * Checkout Sessions in {@code payment} mode, but not Checkout Sessions in {@code subscription} or
   * {@code setup} mode.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubmitType() {
    return this.submitType;
  }

  /**
   * The URL the customer will be directed to after the payment or subscription creation is
   * successful.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSuccessUrl() {
    return this.successUrl;
  }

  /**
   * Tax and discount details for the computed total amount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TotalDetails getTotalDetails() {
    return this.totalDetails;
  }

  /**
   * Enables user redeemable promotion codes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAllowPromotionCodes(final Boolean allowPromotionCodes) {
    this.allowPromotionCodes = allowPromotionCodes;
  }

  /**
   * Total of all items before discounts or taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountSubtotal(final Long amountSubtotal) {
    this.amountSubtotal = amountSubtotal;
  }

  /**
   * Total of all items after discounts and taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountTotal(final Long amountTotal) {
    this.amountTotal = amountTotal;
  }

  /**
   * Describes whether Checkout should collect the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingAddressCollection(final String billingAddressCollection) {
    this.billingAddressCollection = billingAddressCollection;
  }

  /**
   * The URL the customer will be directed to if they decide to cancel payment and return to your
   * website.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelUrl(final String cancelUrl) {
    this.cancelUrl = cancelUrl;
  }

  /**
   * A unique string to reference the Checkout Session. This can be a customer ID, a cart ID, or
   * similar, and can be used to reconcile the session with your internal systems.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientReferenceId(final String clientReferenceId) {
    this.clientReferenceId = clientReferenceId;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * If provided, this value will be used when the Customer object is created. If not provided,
   * customers will be asked to enter their email address. Use this parameter to prefill customer
   * data if you already have an email on file. To access information about the customer once a
   * session is complete, use the {@code customer} attribute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerEmail(final String customerEmail) {
    this.customerEmail = customerEmail;
  }

  /**
   * Unique identifier for the object. Used to pass to {@code redirectToCheckout} in Stripe.js.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The line items purchased by the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineItems(final LineItemCollection lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The IETF language tag of the locale Checkout is displayed in. If blank or {@code auto}, the
   * browser's locale is used.
   *
   * <p>One of {@code auto}, {@code bg}, {@code cs}, {@code da}, {@code de}, {@code el}, {@code en},
   * {@code en-GB}, {@code es}, {@code es-419}, {@code et}, {@code fi}, {@code fr}, {@code fr-CA},
   * {@code hu}, {@code id}, {@code it}, {@code ja}, {@code lt}, {@code lv}, {@code ms}, {@code mt},
   * {@code nb}, {@code nl}, {@code pl}, {@code pt}, {@code pt-BR}, {@code ro}, {@code ru}, {@code
   * sk}, {@code sl}, {@code sv}, {@code tr}, {@code zh}, {@code zh-HK}, or {@code zh-TW}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLocale(final String locale) {
    this.locale = locale;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The mode of the Checkout Session, one of {@code payment}, {@code setup}, or {@code
   * subscription}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMode(final String mode) {
    this.mode = mode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code checkout.session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * A list of the types of payment methods (e.g. card) this Checkout Session is allowed to accept.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  /**
   * Shipping information for this Checkout Session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * When set, provides configuration for Checkout to collect a shipping address from a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingAddressCollection(final ShippingAddressCollection shippingAddressCollection) {
    this.shippingAddressCollection = shippingAddressCollection;
  }

  /**
   * Describes the type of transaction being performed by Checkout in order to customize relevant
   * text on the page, such as the submit button. {@code submit_type} can only be specified on
   * Checkout Sessions in {@code payment} mode, but not Checkout Sessions in {@code subscription} or
   * {@code setup} mode.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubmitType(final String submitType) {
    this.submitType = submitType;
  }

  /**
   * The URL the customer will be directed to after the payment or subscription creation is
   * successful.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSuccessUrl(final String successUrl) {
    this.successUrl = successUrl;
  }

  /**
   * Tax and discount details for the computed total amount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDetails(final TotalDetails totalDetails) {
    this.totalDetails = totalDetails;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Session)) return false;
    final Session other = (Session) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$allowPromotionCodes = this.getAllowPromotionCodes();
    final java.lang.Object other$allowPromotionCodes = other.getAllowPromotionCodes();
    if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !this$allowPromotionCodes.equals(other$allowPromotionCodes)) return false;
    final java.lang.Object this$amountSubtotal = this.getAmountSubtotal();
    final java.lang.Object other$amountSubtotal = other.getAmountSubtotal();
    if (this$amountSubtotal == null ? other$amountSubtotal != null : !this$amountSubtotal.equals(other$amountSubtotal)) return false;
    final java.lang.Object this$amountTotal = this.getAmountTotal();
    final java.lang.Object other$amountTotal = other.getAmountTotal();
    if (this$amountTotal == null ? other$amountTotal != null : !this$amountTotal.equals(other$amountTotal)) return false;
    final java.lang.Object this$billingAddressCollection = this.getBillingAddressCollection();
    final java.lang.Object other$billingAddressCollection = other.getBillingAddressCollection();
    if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) return false;
    final java.lang.Object this$cancelUrl = this.getCancelUrl();
    final java.lang.Object other$cancelUrl = other.getCancelUrl();
    if (this$cancelUrl == null ? other$cancelUrl != null : !this$cancelUrl.equals(other$cancelUrl)) return false;
    final java.lang.Object this$clientReferenceId = this.getClientReferenceId();
    final java.lang.Object other$clientReferenceId = other.getClientReferenceId();
    if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$customerEmail = this.getCustomerEmail();
    final java.lang.Object other$customerEmail = other.getCustomerEmail();
    if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lineItems = this.getLineItems();
    final java.lang.Object other$lineItems = other.getLineItems();
    if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$locale = this.getLocale();
    final java.lang.Object other$locale = other.getLocale();
    if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$mode = this.getMode();
    final java.lang.Object other$mode = other.getMode();
    if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$setupIntent = this.getSetupIntent();
    final java.lang.Object other$setupIntent = other.getSetupIntent();
    if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$shippingAddressCollection = this.getShippingAddressCollection();
    final java.lang.Object other$shippingAddressCollection = other.getShippingAddressCollection();
    if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !this$shippingAddressCollection.equals(other$shippingAddressCollection)) return false;
    final java.lang.Object this$submitType = this.getSubmitType();
    final java.lang.Object other$submitType = other.getSubmitType();
    if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$successUrl = this.getSuccessUrl();
    final java.lang.Object other$successUrl = other.getSuccessUrl();
    if (this$successUrl == null ? other$successUrl != null : !this$successUrl.equals(other$successUrl)) return false;
    final java.lang.Object this$totalDetails = this.getTotalDetails();
    final java.lang.Object other$totalDetails = other.getTotalDetails();
    if (this$totalDetails == null ? other$totalDetails != null : !this$totalDetails.equals(other$totalDetails)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Session;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $allowPromotionCodes = this.getAllowPromotionCodes();
    result = result * PRIME + ($allowPromotionCodes == null ? 43 : $allowPromotionCodes.hashCode());
    final java.lang.Object $amountSubtotal = this.getAmountSubtotal();
    result = result * PRIME + ($amountSubtotal == null ? 43 : $amountSubtotal.hashCode());
    final java.lang.Object $amountTotal = this.getAmountTotal();
    result = result * PRIME + ($amountTotal == null ? 43 : $amountTotal.hashCode());
    final java.lang.Object $billingAddressCollection = this.getBillingAddressCollection();
    result = result * PRIME + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
    final java.lang.Object $cancelUrl = this.getCancelUrl();
    result = result * PRIME + ($cancelUrl == null ? 43 : $cancelUrl.hashCode());
    final java.lang.Object $clientReferenceId = this.getClientReferenceId();
    result = result * PRIME + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $customerEmail = this.getCustomerEmail();
    result = result * PRIME + ($customerEmail == null ? 43 : $customerEmail.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lineItems = this.getLineItems();
    result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $locale = this.getLocale();
    result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $mode = this.getMode();
    result = result * PRIME + ($mode == null ? 43 : $mode.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $setupIntent = this.getSetupIntent();
    result = result * PRIME + ($setupIntent == null ? 43 : $setupIntent.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $shippingAddressCollection = this.getShippingAddressCollection();
    result = result * PRIME + ($shippingAddressCollection == null ? 43 : $shippingAddressCollection.hashCode());
    final java.lang.Object $submitType = this.getSubmitType();
    result = result * PRIME + ($submitType == null ? 43 : $submitType.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $successUrl = this.getSuccessUrl();
    result = result * PRIME + ($successUrl == null ? 43 : $successUrl.hashCode());
    final java.lang.Object $totalDetails = this.getTotalDetails();
    result = result * PRIME + ($totalDetails == null ? 43 : $totalDetails.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object. Used to pass to {@code redirectToCheckout} in Stripe.js.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
