/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.AutomaticPaymentMethodsPaymentIntent;
import com.stripe.model.ChargeCollection;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntentCollection;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentUpdateParams;
import com.stripe.param.PaymentIntentVerifyMicrodepositsParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntent
extends ApiResource
implements HasId,
MetadataStore<PaymentIntent> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_capturable")
    Long amountCapturable;
    @SerializedName(value="amount_received")
    Long amountReceived;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="automatic_payment_methods")
    AutomaticPaymentMethodsPaymentIntent automaticPaymentMethods;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="capture_method")
    String captureMethod;
    @SerializedName(value="charges")
    ChargeCollection charges;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="confirmation_method")
    String confirmationMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="last_payment_error")
    StripeError lastPaymentError;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="processing")
    Processing processing;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="review")
    ExpandableField<Review> review;
    @SerializedName(value="setup_future_usage")
    String setupFutureUsage;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="source")
    ExpandableField<PaymentSource> source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String id) {
        this.review = ApiResource.setExpandableFieldId(id, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review expandableObject) {
        this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
    }

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String id) {
        this.source = ApiResource.setExpandableFieldId(id, this.source);
    }

    public PaymentSource getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(PaymentSource expandableObject) {
        this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public static PaymentIntent create(Map<String, Object> params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
        return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
    }

    public static PaymentIntent retrieve(String intent) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, options);
    }

    public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
    }

    public static PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent update(PaymentIntentUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentIntent update(PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent capture() throws StripeException {
        return this.capture((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent capture(RequestOptions options) throws StripeException {
        return this.capture((Map<String, Object>)null, options);
    }

    public PaymentIntent capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent verifyMicrodeposits() throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(RequestOptions options) throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, options);
    }

    public PaymentIntent verifyMicrodeposits(Map<String, Object> params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountCapturable() {
        return this.amountCapturable;
    }

    @Generated
    public Long getAmountReceived() {
        return this.amountReceived;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public AutomaticPaymentMethodsPaymentIntent getAutomaticPaymentMethods() {
        return this.automaticPaymentMethods;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public ChargeCollection getCharges() {
        return this.charges;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public StripeError getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public Processing getProcessing() {
        return this.processing;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountCapturable(Long amountCapturable) {
        this.amountCapturable = amountCapturable;
    }

    @Generated
    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setAutomaticPaymentMethods(AutomaticPaymentMethodsPaymentIntent automaticPaymentMethods) {
        this.automaticPaymentMethods = automaticPaymentMethods;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    @Generated
    public void setCharges(ChargeCollection charges) {
        this.charges = charges;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastPaymentError(StripeError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setSetupFutureUsage(String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
        this.statementDescriptorSuffix = statementDescriptorSuffix;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent other = (PaymentIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountCapturable = this.getAmountCapturable();
        Long other$amountCapturable = other.getAmountCapturable();
        if (this$amountCapturable == null ? other$amountCapturable != null : !((Object)this$amountCapturable).equals(other$amountCapturable)) {
            return false;
        }
        Long this$amountReceived = this.getAmountReceived();
        Long other$amountReceived = other.getAmountReceived();
        if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AutomaticPaymentMethodsPaymentIntent this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
        AutomaticPaymentMethodsPaymentIntent other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
        if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !((Object)this$automaticPaymentMethods).equals(other$automaticPaymentMethods)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$captureMethod = this.getCaptureMethod();
        String other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
            return false;
        }
        ChargeCollection this$charges = this.getCharges();
        ChargeCollection other$charges = other.getCharges();
        if (this$charges == null ? other$charges != null : !((Object)this$charges).equals(other$charges)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$confirmationMethod = this.getConfirmationMethod();
        String other$confirmationMethod = other.getConfirmationMethod();
        if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        StripeError this$lastPaymentError = this.getLastPaymentError();
        StripeError other$lastPaymentError = other.getLastPaymentError();
        if (this$lastPaymentError == null ? other$lastPaymentError != null : !((Object)this$lastPaymentError).equals(other$lastPaymentError)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        Processing this$processing = this.getProcessing();
        Processing other$processing = other.getProcessing();
        if (this$processing == null ? other$processing != null : !((Object)this$processing).equals(other$processing)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        String this$setupFutureUsage = this.getSetupFutureUsage();
        String other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountCapturable = this.getAmountCapturable();
        result = result * 59 + ($amountCapturable == null ? 43 : ((Object)$amountCapturable).hashCode());
        Long $amountReceived = this.getAmountReceived();
        result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AutomaticPaymentMethodsPaymentIntent $automaticPaymentMethods = this.getAutomaticPaymentMethods();
        result = result * 59 + ($automaticPaymentMethods == null ? 43 : ((Object)$automaticPaymentMethods).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $captureMethod = this.getCaptureMethod();
        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        ChargeCollection $charges = this.getCharges();
        result = result * 59 + ($charges == null ? 43 : ((Object)$charges).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $confirmationMethod = this.getConfirmationMethod();
        result = result * 59 + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        StripeError $lastPaymentError = this.getLastPaymentError();
        result = result * 59 + ($lastPaymentError == null ? 43 : ((Object)$lastPaymentError).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        Processing $processing = this.getProcessing();
        result = result * 59 + ($processing == null ? 43 : ((Object)$processing).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        String $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class Processing
    extends StripeObject {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="type")
        String type;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Processing)) {
                return false;
            }
            Processing other = (Processing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Processing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setInteracPresent(InteracPresent interacPresent) {
            this.interacPresent = interacPresent;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setWechatPay(WechatPay wechatPay) {
            this.wechatPay = wechatPay;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            return !(this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            return result;
        }

        public static class WechatPay
        extends StripeObject {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="client")
            String client;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public String getClient() {
                return this.client;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setAppId(String appId) {
                this.appId = appId;
            }

            @Generated
            public void setClient(String client) {
                this.client = client;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$appId = this.getAppId();
                String other$appId = other.getAppId();
                if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                    return false;
                }
                String this$client = this.getClient();
                String other$client = other.getClient();
                if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $appId = this.getAppId();
                result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                String $client = this.getClient();
                result = result * 59 + ($client == null ? 43 : $client.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class SepaDebitMandateOptions
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebitMandateOptions)) {
                    return false;
                }
                SepaDebitMandateOptions other = (SepaDebitMandateOptions)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebitMandateOptions;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            SepaDebitMandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public SepaDebitMandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setMandateOptions(SepaDebitMandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                SepaDebitMandateOptions this$mandateOptions = this.getMandateOptions();
                SepaDebitMandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                SepaDebitMandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="preferred_locale")
            String preferredLocale;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setPreferredLocale(String preferredLocale) {
                this.preferredLocale = preferredLocale;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferredLocale = this.getPreferredLocale();
                String other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class InteracPresent
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class CardPresent
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="request_three_d_secure")
            String requestThreeDSecure;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setInstallments(Installments installments) {
                this.installments = installments;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setRequestThreeDSecure(String requestThreeDSecure) {
                this.requestThreeDSecure = requestThreeDSecure;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Installments this$installments = this.getInstallments();
                Installments other$installments = other.getInstallments();
                if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$requestThreeDSecure = this.getRequestThreeDSecure();
                String other$requestThreeDSecure = other.getRequestThreeDSecure();
                if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Installments $installments = this.getInstallments();
                result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $requestThreeDSecure = this.getRequestThreeDSecure();
                result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Installments
            extends StripeObject {
                @SerializedName(value="available_plans")
                List<Plan> availablePlans;
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="plan")
                Plan plan;

                @Generated
                public List<Plan> getAvailablePlans() {
                    return this.availablePlans;
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Plan getPlan() {
                    return this.plan;
                }

                @Generated
                public void setAvailablePlans(List<Plan> availablePlans) {
                    this.availablePlans = availablePlans;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public void setPlan(Plan plan) {
                    this.plan = plan;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Installments)) {
                        return false;
                    }
                    Installments other = (Installments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                        return false;
                    }
                    List<Plan> this$availablePlans = this.getAvailablePlans();
                    List<Plan> other$availablePlans = other.getAvailablePlans();
                    if (this$availablePlans == null ? other$availablePlans != null : !((Object)this$availablePlans).equals(other$availablePlans)) {
                        return false;
                    }
                    Plan this$plan = this.getPlan();
                    Plan other$plan = other.getPlan();
                    return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Installments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    List<Plan> $availablePlans = this.getAvailablePlans();
                    result = result * 59 + ($availablePlans == null ? 43 : ((Object)$availablePlans).hashCode());
                    Plan $plan = this.getPlan();
                    result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
                    return result;
                }

                public static class Plan
                extends StripeObject {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setCount(Long count) {
                        this.count = count;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Plan)) {
                            return false;
                        }
                        Plan other = (Plan)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$count = this.getCount();
                        Long other$count = other.getCount();
                        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Plan;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $count = this.getCount();
                        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Alipay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="custom_mandate_url")
                String customMandateUrl;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                String paymentSchedule;
                @SerializedName(value="transaction_type")
                String transactionType;

                @Generated
                public String getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public String getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getTransactionType() {
                    return this.transactionType;
                }

                @Generated
                public void setCustomMandateUrl(String customMandateUrl) {
                    this.customMandateUrl = customMandateUrl;
                }

                @Generated
                public void setIntervalDescription(String intervalDescription) {
                    this.intervalDescription = intervalDescription;
                }

                @Generated
                public void setPaymentSchedule(String paymentSchedule) {
                    this.paymentSchedule = paymentSchedule;
                }

                @Generated
                public void setTransactionType(String transactionType) {
                    this.transactionType = transactionType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$customMandateUrl = this.getCustomMandateUrl();
                    String other$customMandateUrl = other.getCustomMandateUrl();
                    if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                        return false;
                    }
                    String this$intervalDescription = this.getIntervalDescription();
                    String other$intervalDescription = other.getIntervalDescription();
                    if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                        return false;
                    }
                    String this$paymentSchedule = this.getPaymentSchedule();
                    String other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$transactionType = this.getTransactionType();
                    String other$transactionType = other.getTransactionType();
                    return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $customMandateUrl = this.getCustomMandateUrl();
                    result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                    String $intervalDescription = this.getIntervalDescription();
                    result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                    String $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $transactionType = this.getTransactionType();
                    result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                    return result;
                }
            }
        }
    }

    public static class NextActionRedirectToUrl
    extends StripeObject {
        @SerializedName(value="return_url")
        String returnUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionRedirectToUrl)) {
                return false;
            }
            NextActionRedirectToUrl other = (NextActionRedirectToUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionRedirectToUrl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class NextActionOxxoDisplayDetails
    extends StripeObject {
        @SerializedName(value="expires_after")
        Long expiresAfter;
        @SerializedName(value="hosted_voucher_url")
        String hostedVoucherUrl;
        @SerializedName(value="number")
        String number;

        @Generated
        public Long getExpiresAfter() {
            return this.expiresAfter;
        }

        @Generated
        public String getHostedVoucherUrl() {
            return this.hostedVoucherUrl;
        }

        @Generated
        public String getNumber() {
            return this.number;
        }

        @Generated
        public void setExpiresAfter(Long expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        @Generated
        public void setHostedVoucherUrl(String hostedVoucherUrl) {
            this.hostedVoucherUrl = hostedVoucherUrl;
        }

        @Generated
        public void setNumber(String number) {
            this.number = number;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionOxxoDisplayDetails)) {
                return false;
            }
            NextActionOxxoDisplayDetails other = (NextActionOxxoDisplayDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$expiresAfter = this.getExpiresAfter();
            Long other$expiresAfter = other.getExpiresAfter();
            if (this$expiresAfter == null ? other$expiresAfter != null : !((Object)this$expiresAfter).equals(other$expiresAfter)) {
                return false;
            }
            String this$hostedVoucherUrl = this.getHostedVoucherUrl();
            String other$hostedVoucherUrl = other.getHostedVoucherUrl();
            if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            return !(this$number == null ? other$number != null : !this$number.equals(other$number));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionOxxoDisplayDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $expiresAfter = this.getExpiresAfter();
            result = result * 59 + ($expiresAfter == null ? 43 : ((Object)$expiresAfter).hashCode());
            String $hostedVoucherUrl = this.getHostedVoucherUrl();
            result = result * 59 + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            return result;
        }
    }

    public static class NextActionDisplayBoletoDetails
    extends StripeObject {
        @SerializedName(value="expires_at")
        Long expiresAt;
        @SerializedName(value="hosted_voucher_url")
        String hostedVoucherUrl;
        @SerializedName(value="number")
        String number;
        @SerializedName(value="pdf")
        String pdf;

        @Generated
        public Long getExpiresAt() {
            return this.expiresAt;
        }

        @Generated
        public String getHostedVoucherUrl() {
            return this.hostedVoucherUrl;
        }

        @Generated
        public String getNumber() {
            return this.number;
        }

        @Generated
        public String getPdf() {
            return this.pdf;
        }

        @Generated
        public void setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Generated
        public void setHostedVoucherUrl(String hostedVoucherUrl) {
            this.hostedVoucherUrl = hostedVoucherUrl;
        }

        @Generated
        public void setNumber(String number) {
            this.number = number;
        }

        @Generated
        public void setPdf(String pdf) {
            this.pdf = pdf;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionDisplayBoletoDetails)) {
                return false;
            }
            NextActionDisplayBoletoDetails other = (NextActionDisplayBoletoDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$expiresAt = this.getExpiresAt();
            Long other$expiresAt = other.getExpiresAt();
            if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                return false;
            }
            String this$hostedVoucherUrl = this.getHostedVoucherUrl();
            String other$hostedVoucherUrl = other.getHostedVoucherUrl();
            if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                return false;
            }
            String this$pdf = this.getPdf();
            String other$pdf = other.getPdf();
            return !(this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionDisplayBoletoDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $expiresAt = this.getExpiresAt();
            result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
            String $hostedVoucherUrl = this.getHostedVoucherUrl();
            result = result * 59 + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            String $pdf = this.getPdf();
            result = result * 59 + ($pdf == null ? 43 : $pdf.hashCode());
            return result;
        }
    }

    public static class NextActionAlipayHandleRedirect
    extends StripeObject {
        @SerializedName(value="native_data")
        String nativeData;
        @SerializedName(value="native_url")
        String nativeUrl;
        @SerializedName(value="return_url")
        String returnUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getNativeData() {
            return this.nativeData;
        }

        @Generated
        public String getNativeUrl() {
            return this.nativeUrl;
        }

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setNativeData(String nativeData) {
            this.nativeData = nativeData;
        }

        @Generated
        public void setNativeUrl(String nativeUrl) {
            this.nativeUrl = nativeUrl;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionAlipayHandleRedirect)) {
                return false;
            }
            NextActionAlipayHandleRedirect other = (NextActionAlipayHandleRedirect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nativeData = this.getNativeData();
            String other$nativeData = other.getNativeData();
            if (this$nativeData == null ? other$nativeData != null : !this$nativeData.equals(other$nativeData)) {
                return false;
            }
            String this$nativeUrl = this.getNativeUrl();
            String other$nativeUrl = other.getNativeUrl();
            if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionAlipayHandleRedirect;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nativeData = this.getNativeData();
            result = result * 59 + ($nativeData == null ? 43 : $nativeData.hashCode());
            String $nativeUrl = this.getNativeUrl();
            result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="alipay_handle_redirect")
        NextActionAlipayHandleRedirect alipayHandleRedirect;
        @SerializedName(value="boleto_display_details")
        NextActionDisplayBoletoDetails boletoDisplayDetails;
        @SerializedName(value="oxxo_display_details")
        NextActionOxxoDisplayDetails oxxoDisplayDetails;
        @SerializedName(value="redirect_to_url")
        NextActionRedirectToUrl redirectToUrl;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="use_stripe_sdk")
        Map<String, Object> useStripeSdk;
        @SerializedName(value="verify_with_microdeposits")
        VerifyWithMicrodeposits verifyWithMicrodeposits;
        @SerializedName(value="wechat_pay_display_qr_code")
        WechatPayDisplayQrCode wechatPayDisplayQrCode;
        @SerializedName(value="wechat_pay_redirect_to_android_app")
        WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp;
        @SerializedName(value="wechat_pay_redirect_to_ios_app")
        WechatPayRedirectToIosApp wechatPayRedirectToIosApp;

        @Generated
        public NextActionAlipayHandleRedirect getAlipayHandleRedirect() {
            return this.alipayHandleRedirect;
        }

        @Generated
        public NextActionDisplayBoletoDetails getBoletoDisplayDetails() {
            return this.boletoDisplayDetails;
        }

        @Generated
        public NextActionOxxoDisplayDetails getOxxoDisplayDetails() {
            return this.oxxoDisplayDetails;
        }

        @Generated
        public NextActionRedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getUseStripeSdk() {
            return this.useStripeSdk;
        }

        @Generated
        public VerifyWithMicrodeposits getVerifyWithMicrodeposits() {
            return this.verifyWithMicrodeposits;
        }

        @Generated
        public WechatPayDisplayQrCode getWechatPayDisplayQrCode() {
            return this.wechatPayDisplayQrCode;
        }

        @Generated
        public WechatPayRedirectToAndroidApp getWechatPayRedirectToAndroidApp() {
            return this.wechatPayRedirectToAndroidApp;
        }

        @Generated
        public WechatPayRedirectToIosApp getWechatPayRedirectToIosApp() {
            return this.wechatPayRedirectToIosApp;
        }

        @Generated
        public void setAlipayHandleRedirect(NextActionAlipayHandleRedirect alipayHandleRedirect) {
            this.alipayHandleRedirect = alipayHandleRedirect;
        }

        @Generated
        public void setBoletoDisplayDetails(NextActionDisplayBoletoDetails boletoDisplayDetails) {
            this.boletoDisplayDetails = boletoDisplayDetails;
        }

        @Generated
        public void setOxxoDisplayDetails(NextActionOxxoDisplayDetails oxxoDisplayDetails) {
            this.oxxoDisplayDetails = oxxoDisplayDetails;
        }

        @Generated
        public void setRedirectToUrl(NextActionRedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUseStripeSdk(Map<String, Object> useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
        }

        @Generated
        public void setVerifyWithMicrodeposits(VerifyWithMicrodeposits verifyWithMicrodeposits) {
            this.verifyWithMicrodeposits = verifyWithMicrodeposits;
        }

        @Generated
        public void setWechatPayDisplayQrCode(WechatPayDisplayQrCode wechatPayDisplayQrCode) {
            this.wechatPayDisplayQrCode = wechatPayDisplayQrCode;
        }

        @Generated
        public void setWechatPayRedirectToAndroidApp(WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp) {
            this.wechatPayRedirectToAndroidApp = wechatPayRedirectToAndroidApp;
        }

        @Generated
        public void setWechatPayRedirectToIosApp(WechatPayRedirectToIosApp wechatPayRedirectToIosApp) {
            this.wechatPayRedirectToIosApp = wechatPayRedirectToIosApp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NextActionAlipayHandleRedirect this$alipayHandleRedirect = this.getAlipayHandleRedirect();
            NextActionAlipayHandleRedirect other$alipayHandleRedirect = other.getAlipayHandleRedirect();
            if (this$alipayHandleRedirect == null ? other$alipayHandleRedirect != null : !((Object)this$alipayHandleRedirect).equals(other$alipayHandleRedirect)) {
                return false;
            }
            NextActionDisplayBoletoDetails this$boletoDisplayDetails = this.getBoletoDisplayDetails();
            NextActionDisplayBoletoDetails other$boletoDisplayDetails = other.getBoletoDisplayDetails();
            if (this$boletoDisplayDetails == null ? other$boletoDisplayDetails != null : !((Object)this$boletoDisplayDetails).equals(other$boletoDisplayDetails)) {
                return false;
            }
            NextActionOxxoDisplayDetails this$oxxoDisplayDetails = this.getOxxoDisplayDetails();
            NextActionOxxoDisplayDetails other$oxxoDisplayDetails = other.getOxxoDisplayDetails();
            if (this$oxxoDisplayDetails == null ? other$oxxoDisplayDetails != null : !((Object)this$oxxoDisplayDetails).equals(other$oxxoDisplayDetails)) {
                return false;
            }
            NextActionRedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            NextActionRedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$useStripeSdk = this.getUseStripeSdk();
            Map<String, Object> other$useStripeSdk = other.getUseStripeSdk();
            if (this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk)) {
                return false;
            }
            VerifyWithMicrodeposits this$verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            VerifyWithMicrodeposits other$verifyWithMicrodeposits = other.getVerifyWithMicrodeposits();
            if (this$verifyWithMicrodeposits == null ? other$verifyWithMicrodeposits != null : !((Object)this$verifyWithMicrodeposits).equals(other$verifyWithMicrodeposits)) {
                return false;
            }
            WechatPayDisplayQrCode this$wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
            WechatPayDisplayQrCode other$wechatPayDisplayQrCode = other.getWechatPayDisplayQrCode();
            if (this$wechatPayDisplayQrCode == null ? other$wechatPayDisplayQrCode != null : !((Object)this$wechatPayDisplayQrCode).equals(other$wechatPayDisplayQrCode)) {
                return false;
            }
            WechatPayRedirectToAndroidApp this$wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
            WechatPayRedirectToAndroidApp other$wechatPayRedirectToAndroidApp = other.getWechatPayRedirectToAndroidApp();
            if (this$wechatPayRedirectToAndroidApp == null ? other$wechatPayRedirectToAndroidApp != null : !((Object)this$wechatPayRedirectToAndroidApp).equals(other$wechatPayRedirectToAndroidApp)) {
                return false;
            }
            WechatPayRedirectToIosApp this$wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
            WechatPayRedirectToIosApp other$wechatPayRedirectToIosApp = other.getWechatPayRedirectToIosApp();
            return !(this$wechatPayRedirectToIosApp == null ? other$wechatPayRedirectToIosApp != null : !((Object)this$wechatPayRedirectToIosApp).equals(other$wechatPayRedirectToIosApp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NextActionAlipayHandleRedirect $alipayHandleRedirect = this.getAlipayHandleRedirect();
            result = result * 59 + ($alipayHandleRedirect == null ? 43 : ((Object)$alipayHandleRedirect).hashCode());
            NextActionDisplayBoletoDetails $boletoDisplayDetails = this.getBoletoDisplayDetails();
            result = result * 59 + ($boletoDisplayDetails == null ? 43 : ((Object)$boletoDisplayDetails).hashCode());
            NextActionOxxoDisplayDetails $oxxoDisplayDetails = this.getOxxoDisplayDetails();
            result = result * 59 + ($oxxoDisplayDetails == null ? 43 : ((Object)$oxxoDisplayDetails).hashCode());
            NextActionRedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $useStripeSdk = this.getUseStripeSdk();
            result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
            VerifyWithMicrodeposits $verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            result = result * 59 + ($verifyWithMicrodeposits == null ? 43 : ((Object)$verifyWithMicrodeposits).hashCode());
            WechatPayDisplayQrCode $wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
            result = result * 59 + ($wechatPayDisplayQrCode == null ? 43 : ((Object)$wechatPayDisplayQrCode).hashCode());
            WechatPayRedirectToAndroidApp $wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
            result = result * 59 + ($wechatPayRedirectToAndroidApp == null ? 43 : ((Object)$wechatPayRedirectToAndroidApp).hashCode());
            WechatPayRedirectToIosApp $wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
            result = result * 59 + ($wechatPayRedirectToIosApp == null ? 43 : ((Object)$wechatPayRedirectToIosApp).hashCode());
            return result;
        }

        public static class WechatPayRedirectToIosApp
        extends StripeObject {
            @SerializedName(value="native_url")
            String nativeUrl;

            @Generated
            public String getNativeUrl() {
                return this.nativeUrl;
            }

            @Generated
            public void setNativeUrl(String nativeUrl) {
                this.nativeUrl = nativeUrl;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayRedirectToIosApp)) {
                    return false;
                }
                WechatPayRedirectToIosApp other = (WechatPayRedirectToIosApp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$nativeUrl = this.getNativeUrl();
                String other$nativeUrl = other.getNativeUrl();
                return !(this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayRedirectToIosApp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $nativeUrl = this.getNativeUrl();
                result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
                return result;
            }
        }

        public static class WechatPayRedirectToAndroidApp
        extends StripeObject {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="nonce_str")
            String nonceStr;
            @SerializedName(value="partner_id")
            String partnerId;
            @SerializedName(value="prepay_id")
            String prepayId;
            @SerializedName(value="sign")
            String sign;
            @SerializedName(value="timestamp")
            String timestamp;
            @SerializedName(value="package")
            String package_;

            public String getPackage() {
                return this.package_;
            }

            public void setPackage(String package_) {
                this.package_ = package_;
            }

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public String getNonceStr() {
                return this.nonceStr;
            }

            @Generated
            public String getPartnerId() {
                return this.partnerId;
            }

            @Generated
            public String getPrepayId() {
                return this.prepayId;
            }

            @Generated
            public String getSign() {
                return this.sign;
            }

            @Generated
            public String getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public String getPackage_() {
                return this.package_;
            }

            @Generated
            public void setAppId(String appId) {
                this.appId = appId;
            }

            @Generated
            public void setNonceStr(String nonceStr) {
                this.nonceStr = nonceStr;
            }

            @Generated
            public void setPartnerId(String partnerId) {
                this.partnerId = partnerId;
            }

            @Generated
            public void setPrepayId(String prepayId) {
                this.prepayId = prepayId;
            }

            @Generated
            public void setSign(String sign) {
                this.sign = sign;
            }

            @Generated
            public void setTimestamp(String timestamp) {
                this.timestamp = timestamp;
            }

            @Generated
            public void setPackage_(String package_) {
                this.package_ = package_;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayRedirectToAndroidApp)) {
                    return false;
                }
                WechatPayRedirectToAndroidApp other = (WechatPayRedirectToAndroidApp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$appId = this.getAppId();
                String other$appId = other.getAppId();
                if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                    return false;
                }
                String this$nonceStr = this.getNonceStr();
                String other$nonceStr = other.getNonceStr();
                if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
                    return false;
                }
                String this$partnerId = this.getPartnerId();
                String other$partnerId = other.getPartnerId();
                if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
                    return false;
                }
                String this$prepayId = this.getPrepayId();
                String other$prepayId = other.getPrepayId();
                if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) {
                    return false;
                }
                String this$sign = this.getSign();
                String other$sign = other.getSign();
                if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
                    return false;
                }
                String this$timestamp = this.getTimestamp();
                String other$timestamp = other.getTimestamp();
                if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                    return false;
                }
                String this$package_ = this.getPackage_();
                String other$package_ = other.getPackage_();
                return !(this$package_ == null ? other$package_ != null : !this$package_.equals(other$package_));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayRedirectToAndroidApp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $appId = this.getAppId();
                result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                String $nonceStr = this.getNonceStr();
                result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
                String $partnerId = this.getPartnerId();
                result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
                String $prepayId = this.getPrepayId();
                result = result * 59 + ($prepayId == null ? 43 : $prepayId.hashCode());
                String $sign = this.getSign();
                result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
                String $timestamp = this.getTimestamp();
                result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
                String $package_ = this.getPackage_();
                result = result * 59 + ($package_ == null ? 43 : $package_.hashCode());
                return result;
            }
        }

        public static class WechatPayDisplayQrCode
        extends StripeObject {
            @SerializedName(value="data")
            String data;
            @SerializedName(value="image_data_url")
            String imageDataUrl;
            @SerializedName(value="image_url_png")
            String imageUrlPng;
            @SerializedName(value="image_url_svg")
            String imageUrlSvg;

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public String getImageDataUrl() {
                return this.imageDataUrl;
            }

            @Generated
            public String getImageUrlPng() {
                return this.imageUrlPng;
            }

            @Generated
            public String getImageUrlSvg() {
                return this.imageUrlSvg;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setImageDataUrl(String imageDataUrl) {
                this.imageDataUrl = imageDataUrl;
            }

            @Generated
            public void setImageUrlPng(String imageUrlPng) {
                this.imageUrlPng = imageUrlPng;
            }

            @Generated
            public void setImageUrlSvg(String imageUrlSvg) {
                this.imageUrlSvg = imageUrlSvg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayDisplayQrCode)) {
                    return false;
                }
                WechatPayDisplayQrCode other = (WechatPayDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$data = this.getData();
                String other$data = other.getData();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                String this$imageDataUrl = this.getImageDataUrl();
                String other$imageDataUrl = other.getImageDataUrl();
                if (this$imageDataUrl == null ? other$imageDataUrl != null : !this$imageDataUrl.equals(other$imageDataUrl)) {
                    return false;
                }
                String this$imageUrlPng = this.getImageUrlPng();
                String other$imageUrlPng = other.getImageUrlPng();
                if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                    return false;
                }
                String this$imageUrlSvg = this.getImageUrlSvg();
                String other$imageUrlSvg = other.getImageUrlSvg();
                return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                String $imageDataUrl = this.getImageDataUrl();
                result = result * 59 + ($imageDataUrl == null ? 43 : $imageDataUrl.hashCode());
                String $imageUrlPng = this.getImageUrlPng();
                result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                String $imageUrlSvg = this.getImageUrlSvg();
                result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                return result;
            }
        }

        public static class VerifyWithMicrodeposits
        extends StripeObject {
            @SerializedName(value="arrival_date")
            Long arrivalDate;
            @SerializedName(value="hosted_verification_url")
            String hostedVerificationUrl;

            @Generated
            public Long getArrivalDate() {
                return this.arrivalDate;
            }

            @Generated
            public String getHostedVerificationUrl() {
                return this.hostedVerificationUrl;
            }

            @Generated
            public void setArrivalDate(Long arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            @Generated
            public void setHostedVerificationUrl(String hostedVerificationUrl) {
                this.hostedVerificationUrl = hostedVerificationUrl;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof VerifyWithMicrodeposits)) {
                    return false;
                }
                VerifyWithMicrodeposits other = (VerifyWithMicrodeposits)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$arrivalDate = this.getArrivalDate();
                Long other$arrivalDate = other.getArrivalDate();
                if (this$arrivalDate == null ? other$arrivalDate != null : !((Object)this$arrivalDate).equals(other$arrivalDate)) {
                    return false;
                }
                String this$hostedVerificationUrl = this.getHostedVerificationUrl();
                String other$hostedVerificationUrl = other.getHostedVerificationUrl();
                return !(this$hostedVerificationUrl == null ? other$hostedVerificationUrl != null : !this$hostedVerificationUrl.equals(other$hostedVerificationUrl));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof VerifyWithMicrodeposits;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $arrivalDate = this.getArrivalDate();
                result = result * 59 + ($arrivalDate == null ? 43 : ((Object)$arrivalDate).hashCode());
                String $hostedVerificationUrl = this.getHostedVerificationUrl();
                result = result * 59 + ($hostedVerificationUrl == null ? 43 : $hostedVerificationUrl.hashCode());
                return result;
            }
        }
    }
}

