// Generated by delombok at Wed Mar 02 10:54:38 EST 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentLinkCreateParams;
import com.stripe.param.PaymentLinkListLineItemsParams;
import com.stripe.param.PaymentLinkListParams;
import com.stripe.param.PaymentLinkRetrieveParams;
import com.stripe.param.PaymentLinkUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class PaymentLink extends ApiResource implements HasId, MetadataStore<PaymentLink> {
  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @SerializedName("active")
  Boolean active;
  @SerializedName("after_completion")
  AfterCompletion afterCompletion;
  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @SerializedName("allow_promotion_codes")
  Boolean allowPromotionCodes;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @SerializedName("application_fee_percent")
  BigDecimal applicationFeePercent;
  @SerializedName("automatic_tax")
  AutomaticTax automaticTax;
  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @SerializedName("billing_address_collection")
  String billingAddressCollection;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The line items representing what is being sold.
   */
  @SerializedName("line_items")
  LineItemCollection lineItems;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account on behalf of which to charge. See the <a
   * href="https://support.stripe.com/questions/sending-invoices-on-behalf-of-connected-accounts">Connect
   * documentation</a> for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  @SerializedName("phone_number_collection")
  PhoneNumberCollection phoneNumberCollection;
  /**
   * Configuration for collecting the customer's shipping address.
   */
  @SerializedName("shipping_address_collection")
  ShippingAddressCollection shippingAddressCollection;
  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @SerializedName("subscription_data")
  SubscriptionData subscriptionData;
  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * The public URL that can be shared with customers.
   */
  @SerializedName("url")
  String url;

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(PaymentLinkListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(PaymentLinkListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink) throws StripeException {
    return retrieve(paymentLink, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, RequestOptions options) throws StripeException {
    return retrieve(paymentLink, (Map<String, Object>) null, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems() throws StripeException {
    return listLineItems((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(PaymentLinkCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(PaymentLinkCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Updates a payment link.
   */
  @Override
  public PaymentLink update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a payment link.
   */
  @Override
  public PaymentLink update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Updates a payment link.
   */
  public PaymentLink update(PaymentLinkUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a payment link.
   */
  public PaymentLink update(PaymentLinkUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }


  public static class AfterCompletion extends StripeObject {
    @SerializedName("hosted_confirmation")
    HostedConfirmation hostedConfirmation;
    @SerializedName("redirect")
    Redirect redirect;
    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @SerializedName("type")
    String type;


    public static class HostedConfirmation extends StripeObject {
      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @SerializedName("custom_message")
      String customMessage;

      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCustomMessage() {
        return this.customMessage;
      }

      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCustomMessage(final String customMessage) {
        this.customMessage = customMessage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentLink.AfterCompletion.HostedConfirmation)) return false;
        final PaymentLink.AfterCompletion.HostedConfirmation other = (PaymentLink.AfterCompletion.HostedConfirmation) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$customMessage = this.getCustomMessage();
        final java.lang.Object other$customMessage = other.getCustomMessage();
        if (this$customMessage == null ? other$customMessage != null : !this$customMessage.equals(other$customMessage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentLink.AfterCompletion.HostedConfirmation;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $customMessage = this.getCustomMessage();
        result = result * PRIME + ($customMessage == null ? 43 : $customMessage.hashCode());
        return result;
      }
    }


    public static class Redirect extends StripeObject {
      @SerializedName("url")
      String url;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUrl() {
        return this.url;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUrl(final String url) {
        this.url = url;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentLink.AfterCompletion.Redirect)) return false;
        final PaymentLink.AfterCompletion.Redirect other = (PaymentLink.AfterCompletion.Redirect) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentLink.AfterCompletion.Redirect;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HostedConfirmation getHostedConfirmation() {
      return this.hostedConfirmation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Redirect getRedirect() {
      return this.redirect;
    }

    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedConfirmation(final HostedConfirmation hostedConfirmation) {
      this.hostedConfirmation = hostedConfirmation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirect(final Redirect redirect) {
      this.redirect = redirect;
    }

    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.AfterCompletion)) return false;
      final PaymentLink.AfterCompletion other = (PaymentLink.AfterCompletion) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$hostedConfirmation = this.getHostedConfirmation();
      final java.lang.Object other$hostedConfirmation = other.getHostedConfirmation();
      if (this$hostedConfirmation == null ? other$hostedConfirmation != null : !this$hostedConfirmation.equals(other$hostedConfirmation)) return false;
      final java.lang.Object this$redirect = this.getRedirect();
      final java.lang.Object other$redirect = other.getRedirect();
      if (this$redirect == null ? other$redirect != null : !this$redirect.equals(other$redirect)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.AfterCompletion;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $hostedConfirmation = this.getHostedConfirmation();
      result = result * PRIME + ($hostedConfirmation == null ? 43 : $hostedConfirmation.hashCode());
      final java.lang.Object $redirect = this.getRedirect();
      result = result * PRIME + ($redirect == null ? 43 : $redirect.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * The URL the customer will be redirected to after the purchase is complete.
   */
  public static class AutomaticTax extends StripeObject {
    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @SerializedName("enabled")
    Boolean enabled;

    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.AutomaticTax)) return false;
      final PaymentLink.AutomaticTax other = (PaymentLink.AutomaticTax) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.AutomaticTax;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      return result;
    }
  }


  public static class PhoneNumberCollection extends StripeObject {
    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @SerializedName("enabled")
    Boolean enabled;

    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.PhoneNumberCollection)) return false;
      final PaymentLink.PhoneNumberCollection other = (PaymentLink.PhoneNumberCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.PhoneNumberCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      return result;
    }
  }


  public static class ShippingAddressCollection extends StripeObject {
    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @SerializedName("allowed_countries")
    List<String> allowedCountries;

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCountries() {
      return this.allowedCountries;
    }

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCountries(final List<String> allowedCountries) {
      this.allowedCountries = allowedCountries;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.ShippingAddressCollection)) return false;
      final PaymentLink.ShippingAddressCollection other = (PaymentLink.ShippingAddressCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCountries = this.getAllowedCountries();
      final java.lang.Object other$allowedCountries = other.getAllowedCountries();
      if (this$allowedCountries == null ? other$allowedCountries != null : !this$allowedCountries.equals(other$allowedCountries)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.ShippingAddressCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCountries = this.getAllowedCountries();
      result = result * PRIME + ($allowedCountries == null ? 43 : $allowedCountries.hashCode());
      return result;
    }
  }


  public static class SubscriptionData extends StripeObject {
    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @SerializedName("trial_period_days")
    Long trialPeriodDays;

    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTrialPeriodDays() {
      return this.trialPeriodDays;
    }

    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialPeriodDays(final Long trialPeriodDays) {
      this.trialPeriodDays = trialPeriodDays;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.SubscriptionData)) return false;
      final PaymentLink.SubscriptionData other = (PaymentLink.SubscriptionData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$trialPeriodDays = this.getTrialPeriodDays();
      final java.lang.Object other$trialPeriodDays = other.getTrialPeriodDays();
      if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !this$trialPeriodDays.equals(other$trialPeriodDays)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.SubscriptionData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $trialPeriodDays = this.getTrialPeriodDays();
      result = result * PRIME + ($trialPeriodDays == null ? 43 : $trialPeriodDays.hashCode());
      return result;
    }
  }


  public static class TransferData extends StripeObject {
    /**
     * The amount in %s that will be transferred to the destination account. By default, the entire
     * amount is transferred to the destination.
     */
    @SerializedName("amount")
    Long amount;
    /** The connected account receiving the transfer. */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.TransferData)) return false;
      final PaymentLink.TransferData other = (PaymentLink.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AfterCompletion getAfterCompletion() {
    return this.afterCompletion;
  }

  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAllowPromotionCodes() {
    return this.allowPromotionCodes;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApplicationFeePercent() {
    return this.applicationFeePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticTax getAutomaticTax() {
    return this.automaticTax;
  }

  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingAddressCollection() {
    return this.billingAddressCollection;
  }

  /**
   * The line items representing what is being sold.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineItemCollection getLineItems() {
    return this.lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PhoneNumberCollection getPhoneNumberCollection() {
    return this.phoneNumberCollection;
  }

  /**
   * Configuration for collecting the customer's shipping address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingAddressCollection getShippingAddressCollection() {
    return this.shippingAddressCollection;
  }

  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SubscriptionData getSubscriptionData() {
    return this.subscriptionData;
  }

  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * The public URL that can be shared with customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUrl() {
    return this.url;
  }

  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAfterCompletion(final AfterCompletion afterCompletion) {
    this.afterCompletion = afterCompletion;
  }

  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAllowPromotionCodes(final Boolean allowPromotionCodes) {
    this.allowPromotionCodes = allowPromotionCodes;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeePercent(final BigDecimal applicationFeePercent) {
    this.applicationFeePercent = applicationFeePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutomaticTax(final AutomaticTax automaticTax) {
    this.automaticTax = automaticTax;
  }

  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingAddressCollection(final String billingAddressCollection) {
    this.billingAddressCollection = billingAddressCollection;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The line items representing what is being sold.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineItems(final LineItemCollection lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhoneNumberCollection(final PhoneNumberCollection phoneNumberCollection) {
    this.phoneNumberCollection = phoneNumberCollection;
  }

  /**
   * Configuration for collecting the customer's shipping address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingAddressCollection(final ShippingAddressCollection shippingAddressCollection) {
    this.shippingAddressCollection = shippingAddressCollection;
  }

  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionData(final SubscriptionData subscriptionData) {
    this.subscriptionData = subscriptionData;
  }

  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * The public URL that can be shared with customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUrl(final String url) {
    this.url = url;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentLink)) return false;
    final PaymentLink other = (PaymentLink) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$allowPromotionCodes = this.getAllowPromotionCodes();
    final java.lang.Object other$allowPromotionCodes = other.getAllowPromotionCodes();
    if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !this$allowPromotionCodes.equals(other$allowPromotionCodes)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$afterCompletion = this.getAfterCompletion();
    final java.lang.Object other$afterCompletion = other.getAfterCompletion();
    if (this$afterCompletion == null ? other$afterCompletion != null : !this$afterCompletion.equals(other$afterCompletion)) return false;
    final java.lang.Object this$applicationFeePercent = this.getApplicationFeePercent();
    final java.lang.Object other$applicationFeePercent = other.getApplicationFeePercent();
    if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !this$applicationFeePercent.equals(other$applicationFeePercent)) return false;
    final java.lang.Object this$automaticTax = this.getAutomaticTax();
    final java.lang.Object other$automaticTax = other.getAutomaticTax();
    if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
    final java.lang.Object this$billingAddressCollection = this.getBillingAddressCollection();
    final java.lang.Object other$billingAddressCollection = other.getBillingAddressCollection();
    if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lineItems = this.getLineItems();
    final java.lang.Object other$lineItems = other.getLineItems();
    if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$phoneNumberCollection = this.getPhoneNumberCollection();
    final java.lang.Object other$phoneNumberCollection = other.getPhoneNumberCollection();
    if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !this$phoneNumberCollection.equals(other$phoneNumberCollection)) return false;
    final java.lang.Object this$shippingAddressCollection = this.getShippingAddressCollection();
    final java.lang.Object other$shippingAddressCollection = other.getShippingAddressCollection();
    if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !this$shippingAddressCollection.equals(other$shippingAddressCollection)) return false;
    final java.lang.Object this$subscriptionData = this.getSubscriptionData();
    final java.lang.Object other$subscriptionData = other.getSubscriptionData();
    if (this$subscriptionData == null ? other$subscriptionData != null : !this$subscriptionData.equals(other$subscriptionData)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$url = this.getUrl();
    final java.lang.Object other$url = other.getUrl();
    if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentLink;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $allowPromotionCodes = this.getAllowPromotionCodes();
    result = result * PRIME + ($allowPromotionCodes == null ? 43 : $allowPromotionCodes.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $afterCompletion = this.getAfterCompletion();
    result = result * PRIME + ($afterCompletion == null ? 43 : $afterCompletion.hashCode());
    final java.lang.Object $applicationFeePercent = this.getApplicationFeePercent();
    result = result * PRIME + ($applicationFeePercent == null ? 43 : $applicationFeePercent.hashCode());
    final java.lang.Object $automaticTax = this.getAutomaticTax();
    result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
    final java.lang.Object $billingAddressCollection = this.getBillingAddressCollection();
    result = result * PRIME + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lineItems = this.getLineItems();
    result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $phoneNumberCollection = this.getPhoneNumberCollection();
    result = result * PRIME + ($phoneNumberCollection == null ? 43 : $phoneNumberCollection.hashCode());
    final java.lang.Object $shippingAddressCollection = this.getShippingAddressCollection();
    result = result * PRIME + ($shippingAddressCollection == null ? 43 : $shippingAddressCollection.hashCode());
    final java.lang.Object $subscriptionData = this.getSubscriptionData();
    result = result * PRIME + ($subscriptionData == null ? 43 : $subscriptionData.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $url = this.getUrl();
    result = result * PRIME + ($url == null ? 43 : $url.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
