// Generated by delombok at Wed Mar 09 15:22:30 EST 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ShippingRateCreateParams;
import com.stripe.param.ShippingRateListParams;
import com.stripe.param.ShippingRateRetrieveParams;
import com.stripe.param.ShippingRateUpdateParams;
import java.util.Map;

public class ShippingRate extends ApiResource implements HasId, MetadataStore<ShippingRate> {
  /**
   * Whether the shipping rate can be used for new purchases. Defaults to {@code true}.
   */
  @SerializedName("active")
  Boolean active;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The estimated range for how long shipping will take, meant to be displayable to the customer.
   * This will appear on CheckoutSessions.
   */
  @SerializedName("delivery_estimate")
  DeliveryEstimate deliveryEstimate;
  /**
   * The name of the shipping rate, meant to be displayable to the customer. This will appear on
   * CheckoutSessions.
   */
  @SerializedName("display_name")
  String displayName;
  @SerializedName("fixed_amount")
  FixedAmount fixedAmount;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code shipping_rate}.
   */
  @SerializedName("object")
  String object;
  /**
   * Specifies whether the rate is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}.
   */
  @SerializedName("tax_behavior")
  String taxBehavior;
  /**
   * A <a href="https://stripe.com/docs/tax/tax-codes">tax code</a> ID. The Shipping tax code is
   * {@code txcd_92010001}.
   */
  @SerializedName("tax_code")
  ExpandableField<TaxCode> taxCode;
  /**
   * The type of calculation to use on the shipping rate. Can only be {@code fixed_amount} for now.
   *
   * <p>Equal to {@code fixed_amount}.
   */
  @SerializedName("type")
  String type;

  /**
   * Get ID of expandable {@code taxCode} object.
   */
  public String getTaxCode() {
    return (this.taxCode != null) ? this.taxCode.getId() : null;
  }

  public void setTaxCode(String id) {
    this.taxCode = ApiResource.setExpandableFieldId(id, this.taxCode);
  }

  /**
   * Get expanded {@code taxCode}.
   */
  public TaxCode getTaxCodeObject() {
    return (this.taxCode != null) ? this.taxCode.getExpanded() : null;
  }

  public void setTaxCodeObject(TaxCode expandableObject) {
    this.taxCode = new ExpandableField<TaxCode>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of your shipping rates.
   */
  public static ShippingRateCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your shipping rates.
   */
  public static ShippingRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/shipping_rates");
    return ApiResource.requestCollection(url, params, ShippingRateCollection.class, options);
  }

  /**
   * Returns a list of your shipping rates.
   */
  public static ShippingRateCollection list(ShippingRateListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your shipping rates.
   */
  public static ShippingRateCollection list(ShippingRateListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/shipping_rates");
    return ApiResource.requestCollection(url, params, ShippingRateCollection.class, options);
  }

  /**
   * Returns the shipping rate object with the given ID.
   */
  public static ShippingRate retrieve(String shippingRateToken) throws StripeException {
    return retrieve(shippingRateToken, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Returns the shipping rate object with the given ID.
   */
  public static ShippingRate retrieve(String shippingRateToken, RequestOptions options) throws StripeException {
    return retrieve(shippingRateToken, (Map<String, Object>) null, options);
  }

  /**
   * Returns the shipping rate object with the given ID.
   */
  public static ShippingRate retrieve(String shippingRateToken, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ShippingRate.class, options);
  }

  /**
   * Returns the shipping rate object with the given ID.
   */
  public static ShippingRate retrieve(String shippingRateToken, ShippingRateRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ShippingRate.class, options);
  }

  /**
   * Creates a new shipping rate object.
   */
  public static ShippingRate create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new shipping rate object.
   */
  public static ShippingRate create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/shipping_rates");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
  }

  /**
   * Creates a new shipping rate object.
   */
  public static ShippingRate create(ShippingRateCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new shipping rate object.
   */
  public static ShippingRate create(ShippingRateCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/shipping_rates");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
  }

  /**
   * Updates an existing shipping rate object.
   */
  @Override
  public ShippingRate update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing shipping rate object.
   */
  @Override
  public ShippingRate update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
  }

  /**
   * Updates an existing shipping rate object.
   */
  public ShippingRate update(ShippingRateUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing shipping rate object.
   */
  public ShippingRate update(ShippingRateUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
  }


  public static class DeliveryEstimate extends StripeObject {
    /**
     * The upper bound of the estimated range. If empty, represents no upper bound i.e., infinite.
     */
    @SerializedName("maximum")
    Maximum maximum;
    /**
     * The lower bound of the estimated range. If empty, represents no lower bound.
     */
    @SerializedName("minimum")
    Minimum minimum;


    public static class Maximum extends StripeObject {
      /**
       * A unit of time.
       *
       * <p>One of {@code business_day}, {@code day}, {@code hour}, {@code month}, or {@code week}.
       */
      @SerializedName("unit")
      String unit;
      /**
       * Must be greater than 0.
       */
      @SerializedName("value")
      Long value;

      /**
       * A unit of time.
       *
       * <p>One of {@code business_day}, {@code day}, {@code hour}, {@code month}, or {@code week}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUnit() {
        return this.unit;
      }

      /**
       * Must be greater than 0.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getValue() {
        return this.value;
      }

      /**
       * A unit of time.
       *
       * <p>One of {@code business_day}, {@code day}, {@code hour}, {@code month}, or {@code week}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUnit(final String unit) {
        this.unit = unit;
      }

      /**
       * Must be greater than 0.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setValue(final Long value) {
        this.value = value;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ShippingRate.DeliveryEstimate.Maximum)) return false;
        final ShippingRate.DeliveryEstimate.Maximum other = (ShippingRate.DeliveryEstimate.Maximum) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        final java.lang.Object this$unit = this.getUnit();
        final java.lang.Object other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ShippingRate.DeliveryEstimate.Maximum;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        final java.lang.Object $unit = this.getUnit();
        result = result * PRIME + ($unit == null ? 43 : $unit.hashCode());
        return result;
      }
    }


    public static class Minimum extends StripeObject {
      /**
       * A unit of time.
       *
       * <p>One of {@code business_day}, {@code day}, {@code hour}, {@code month}, or {@code week}.
       */
      @SerializedName("unit")
      String unit;
      @SerializedName("value")
      Long value;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUnit() {
        return this.unit;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getValue() {
        return this.value;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUnit(final String unit) {
        this.unit = unit;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setValue(final Long value) {
        this.value = value;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ShippingRate.DeliveryEstimate.Minimum)) return false;
        final ShippingRate.DeliveryEstimate.Minimum other = (ShippingRate.DeliveryEstimate.Minimum) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        final java.lang.Object this$unit = this.getUnit();
        final java.lang.Object other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ShippingRate.DeliveryEstimate.Minimum;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        final java.lang.Object $unit = this.getUnit();
        result = result * PRIME + ($unit == null ? 43 : $unit.hashCode());
        return result;
      }
    }

    /**
     * The upper bound of the estimated range. If empty, represents no upper bound i.e., infinite.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Maximum getMaximum() {
      return this.maximum;
    }

    /**
     * The lower bound of the estimated range. If empty, represents no lower bound.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Minimum getMinimum() {
      return this.minimum;
    }

    /**
     * The upper bound of the estimated range. If empty, represents no upper bound i.e., infinite.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMaximum(final Maximum maximum) {
      this.maximum = maximum;
    }

    /**
     * The lower bound of the estimated range. If empty, represents no lower bound.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMinimum(final Minimum minimum) {
      this.minimum = minimum;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ShippingRate.DeliveryEstimate)) return false;
      final ShippingRate.DeliveryEstimate other = (ShippingRate.DeliveryEstimate) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$maximum = this.getMaximum();
      final java.lang.Object other$maximum = other.getMaximum();
      if (this$maximum == null ? other$maximum != null : !this$maximum.equals(other$maximum)) return false;
      final java.lang.Object this$minimum = this.getMinimum();
      final java.lang.Object other$minimum = other.getMinimum();
      if (this$minimum == null ? other$minimum != null : !this$minimum.equals(other$minimum)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ShippingRate.DeliveryEstimate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $maximum = this.getMaximum();
      result = result * PRIME + ($maximum == null ? 43 : $maximum.hashCode());
      final java.lang.Object $minimum = this.getMinimum();
      result = result * PRIME + ($minimum == null ? 43 : $minimum.hashCode());
      return result;
    }
  }


  /**
   * Must be greater than 0.
   */
  public static class FixedAmount extends StripeObject {
    /** A non-negative integer in cents representing how much to charge. */
    @SerializedName("amount")
    Long amount;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ShippingRate.FixedAmount)) return false;
      final ShippingRate.FixedAmount other = (ShippingRate.FixedAmount) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ShippingRate.FixedAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      return result;
    }
  }

  /**
   * Whether the shipping rate can be used for new purchases. Defaults to {@code true}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The estimated range for how long shipping will take, meant to be displayable to the customer.
   * This will appear on CheckoutSessions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DeliveryEstimate getDeliveryEstimate() {
    return this.deliveryEstimate;
  }

  /**
   * The name of the shipping rate, meant to be displayable to the customer. This will appear on
   * CheckoutSessions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDisplayName() {
    return this.displayName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FixedAmount getFixedAmount() {
    return this.fixedAmount;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code shipping_rate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Specifies whether the rate is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTaxBehavior() {
    return this.taxBehavior;
  }

  /**
   * The type of calculation to use on the shipping rate. Can only be {@code fixed_amount} for now.
   *
   * <p>Equal to {@code fixed_amount}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * Whether the shipping rate can be used for new purchases. Defaults to {@code true}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The estimated range for how long shipping will take, meant to be displayable to the customer.
   * This will appear on CheckoutSessions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeliveryEstimate(final DeliveryEstimate deliveryEstimate) {
    this.deliveryEstimate = deliveryEstimate;
  }

  /**
   * The name of the shipping rate, meant to be displayable to the customer. This will appear on
   * CheckoutSessions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDisplayName(final String displayName) {
    this.displayName = displayName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFixedAmount(final FixedAmount fixedAmount) {
    this.fixedAmount = fixedAmount;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code shipping_rate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Specifies whether the rate is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxBehavior(final String taxBehavior) {
    this.taxBehavior = taxBehavior;
  }

  /**
   * The type of calculation to use on the shipping rate. Can only be {@code fixed_amount} for now.
   *
   * <p>Equal to {@code fixed_amount}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ShippingRate)) return false;
    final ShippingRate other = (ShippingRate) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$deliveryEstimate = this.getDeliveryEstimate();
    final java.lang.Object other$deliveryEstimate = other.getDeliveryEstimate();
    if (this$deliveryEstimate == null ? other$deliveryEstimate != null : !this$deliveryEstimate.equals(other$deliveryEstimate)) return false;
    final java.lang.Object this$displayName = this.getDisplayName();
    final java.lang.Object other$displayName = other.getDisplayName();
    if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
    final java.lang.Object this$fixedAmount = this.getFixedAmount();
    final java.lang.Object other$fixedAmount = other.getFixedAmount();
    if (this$fixedAmount == null ? other$fixedAmount != null : !this$fixedAmount.equals(other$fixedAmount)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$taxBehavior = this.getTaxBehavior();
    final java.lang.Object other$taxBehavior = other.getTaxBehavior();
    if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) return false;
    final java.lang.Object this$taxCode = this.getTaxCode();
    final java.lang.Object other$taxCode = other.getTaxCode();
    if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ShippingRate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $deliveryEstimate = this.getDeliveryEstimate();
    result = result * PRIME + ($deliveryEstimate == null ? 43 : $deliveryEstimate.hashCode());
    final java.lang.Object $displayName = this.getDisplayName();
    result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
    final java.lang.Object $fixedAmount = this.getFixedAmount();
    result = result * PRIME + ($fixedAmount == null ? 43 : $fixedAmount.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $taxBehavior = this.getTaxBehavior();
    result = result * PRIME + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
    final java.lang.Object $taxCode = this.getTaxCode();
    result = result * PRIME + ($taxCode == null ? 43 : $taxCode.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
