// Generated by delombok at Fri Mar 18 14:28:32 EDT 2022
// File generated from our OpenAPI spec
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentLinkCreateParams extends ApiRequestParams {
  /**
   * Behavior after the purchase is complete.
   */
  @SerializedName("after_completion")
  AfterCompletion afterCompletion;
  /**
   * Enables user redeemable promotion codes.
   */
  @SerializedName("allow_promotion_codes")
  Boolean allowPromotionCodes;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account. Can only be applied when there are
   * no line items with recurring prices.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account. There must be at least 1 line item with a recurring price to use this
   * field.
   */
  @SerializedName("application_fee_percent")
  BigDecimal applicationFeePercent;
  /**
   * Configuration for automatic tax collection.
   */
  @SerializedName("automatic_tax")
  AutomaticTax automaticTax;
  /**
   * Configuration for collecting the customer's billing address.
   */
  @SerializedName("billing_address_collection")
  BillingAddressCollection billingAddressCollection;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * The line items representing what is being sold. Each line item represents an item being sold.
   * Up to 20 line items are supported.
   */
  @SerializedName("line_items")
  List<LineItem> lineItems;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Individual keys can be unset by posting an empty value to them. All keys can
   * be unset by posting an empty value to {@code metadata}. Metadata associated with this Payment
   * Link will automatically be copied to <a
   * href="https://stripe.com/docs/api/checkout/sessions">checkout sessions</a> created by this
   * payment link.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The account on behalf of which to charge.
   */
  @SerializedName("on_behalf_of")
  String onBehalfOf;
  /**
   * The list of payment method types that customers can use. Only {@code card} is supported. If no
   * value is passed, Stripe will dynamically show relevant payment methods from your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a> (20+
   * payment methods <a
   * href="https://stripe.com/docs/payments/payment-methods/integration-options#payment-method-product-support">supported</a>).
   */
  @SerializedName("payment_method_types")
  List<PaymentMethodType> paymentMethodTypes;
  /**
   * Controls phone number collection settings during checkout.
   *
   * <p>We recommend that you review your privacy policy and check with your legal contacts.
   */
  @SerializedName("phone_number_collection")
  PhoneNumberCollection phoneNumberCollection;
  /**
   * Configuration for collecting the customer's shipping address.
   */
  @SerializedName("shipping_address_collection")
  ShippingAddressCollection shippingAddressCollection;
  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @SerializedName("subscription_data")
  SubscriptionData subscriptionData;
  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @SerializedName("transfer_data")
  TransferData transferData;

  private PaymentLinkCreateParams(AfterCompletion afterCompletion, Boolean allowPromotionCodes, Long applicationFeeAmount, BigDecimal applicationFeePercent, AutomaticTax automaticTax, BillingAddressCollection billingAddressCollection, List<String> expand, Map<String, Object> extraParams, List<LineItem> lineItems, Map<String, String> metadata, String onBehalfOf, List<PaymentMethodType> paymentMethodTypes, PhoneNumberCollection phoneNumberCollection, ShippingAddressCollection shippingAddressCollection, SubscriptionData subscriptionData, TransferData transferData) {
    this.afterCompletion = afterCompletion;
    this.allowPromotionCodes = allowPromotionCodes;
    this.applicationFeeAmount = applicationFeeAmount;
    this.applicationFeePercent = applicationFeePercent;
    this.automaticTax = automaticTax;
    this.billingAddressCollection = billingAddressCollection;
    this.expand = expand;
    this.extraParams = extraParams;
    this.lineItems = lineItems;
    this.metadata = metadata;
    this.onBehalfOf = onBehalfOf;
    this.paymentMethodTypes = paymentMethodTypes;
    this.phoneNumberCollection = phoneNumberCollection;
    this.shippingAddressCollection = shippingAddressCollection;
    this.subscriptionData = subscriptionData;
    this.transferData = transferData;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private AfterCompletion afterCompletion;
    private Boolean allowPromotionCodes;
    private Long applicationFeeAmount;
    private BigDecimal applicationFeePercent;
    private AutomaticTax automaticTax;
    private BillingAddressCollection billingAddressCollection;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private List<LineItem> lineItems;
    private Map<String, String> metadata;
    private String onBehalfOf;
    private List<PaymentMethodType> paymentMethodTypes;
    private PhoneNumberCollection phoneNumberCollection;
    private ShippingAddressCollection shippingAddressCollection;
    private SubscriptionData subscriptionData;
    private TransferData transferData;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public PaymentLinkCreateParams build() {
      return new PaymentLinkCreateParams(this.afterCompletion, this.allowPromotionCodes, this.applicationFeeAmount, this.applicationFeePercent, this.automaticTax, this.billingAddressCollection, this.expand, this.extraParams, this.lineItems, this.metadata, this.onBehalfOf, this.paymentMethodTypes, this.phoneNumberCollection, this.shippingAddressCollection, this.subscriptionData, this.transferData);
    }

    /**
     * Behavior after the purchase is complete.
     */
    public Builder setAfterCompletion(AfterCompletion afterCompletion) {
      this.afterCompletion = afterCompletion;
      return this;
    }

    /**
     * Enables user redeemable promotion codes.
     */
    public Builder setAllowPromotionCodes(Boolean allowPromotionCodes) {
      this.allowPromotionCodes = allowPromotionCodes;
      return this;
    }

    /**
     * The amount of the application fee (if any) that will be requested to be applied to the
     * payment and transferred to the application owner's Stripe account. Can only be applied when
     * there are no line items with recurring prices.
     */
    public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
      this.applicationFeeAmount = applicationFeeAmount;
      return this;
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account. There must be at least 1 line item with a recurring price
     * to use this field.
     */
    public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
      this.applicationFeePercent = applicationFeePercent;
      return this;
    }

    /**
     * Configuration for automatic tax collection.
     */
    public Builder setAutomaticTax(AutomaticTax automaticTax) {
      this.automaticTax = automaticTax;
      return this;
    }

    /**
     * Configuration for collecting the customer's billing address.
     */
    public Builder setBillingAddressCollection(BillingAddressCollection billingAddressCollection) {
      this.billingAddressCollection = billingAddressCollection;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentLinkCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentLinkCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * PaymentLinkCreateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link PaymentLinkCreateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * Add an element to `lineItems` list. A list is initialized for the first `add/addAll` call,
     * and subsequent calls adds additional elements to the original list. See {@link
     * PaymentLinkCreateParams#lineItems} for the field documentation.
     */
    public Builder addLineItem(LineItem element) {
      if (this.lineItems == null) {
        this.lineItems = new ArrayList<>();
      }
      this.lineItems.add(element);
      return this;
    }

    /**
     * Add all elements to `lineItems` list. A list is initialized for the first `add/addAll` call,
     * and subsequent calls adds additional elements to the original list. See {@link
     * PaymentLinkCreateParams#lineItems} for the field documentation.
     */
    public Builder addAllLineItem(List<LineItem> elements) {
      if (this.lineItems == null) {
        this.lineItems = new ArrayList<>();
      }
      this.lineItems.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * PaymentLinkCreateParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link PaymentLinkCreateParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }

    /**
     * The account on behalf of which to charge.
     */
    public Builder setOnBehalfOf(String onBehalfOf) {
      this.onBehalfOf = onBehalfOf;
      return this;
    }

    /**
     * Add an element to `paymentMethodTypes` list. A list is initialized for the first `add/addAll`
     * call, and subsequent calls adds additional elements to the original list. See {@link
     * PaymentLinkCreateParams#paymentMethodTypes} for the field documentation.
     */
    public Builder addPaymentMethodType(PaymentMethodType element) {
      if (this.paymentMethodTypes == null) {
        this.paymentMethodTypes = new ArrayList<>();
      }
      this.paymentMethodTypes.add(element);
      return this;
    }

    /**
     * Add all elements to `paymentMethodTypes` list. A list is initialized for the first
     * `add/addAll` call, and subsequent calls adds additional elements to the original list. See
     * {@link PaymentLinkCreateParams#paymentMethodTypes} for the field documentation.
     */
    public Builder addAllPaymentMethodType(List<PaymentMethodType> elements) {
      if (this.paymentMethodTypes == null) {
        this.paymentMethodTypes = new ArrayList<>();
      }
      this.paymentMethodTypes.addAll(elements);
      return this;
    }

    /**
     * Controls phone number collection settings during checkout.
     *
     * <p>We recommend that you review your privacy policy and check with your legal contacts.
     */
    public Builder setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
      this.phoneNumberCollection = phoneNumberCollection;
      return this;
    }

    /**
     * Configuration for collecting the customer's shipping address.
     */
    public Builder setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
      this.shippingAddressCollection = shippingAddressCollection;
      return this;
    }

    /**
     * When creating a subscription, the specified configuration data will be used. There must be at
     * least one line item with a recurring price to use {@code subscription_data}.
     */
    public Builder setSubscriptionData(SubscriptionData subscriptionData) {
      this.subscriptionData = subscriptionData;
      return this;
    }

    /**
     * The account (if any) the payments will be attributed to for tax reporting, and where funds
     * from each payment will be transferred to.
     */
    public Builder setTransferData(TransferData transferData) {
      this.transferData = transferData;
      return this;
    }
  }


  public static class AfterCompletion {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Configuration when {@code type=hosted_confirmation}.
     */
    @SerializedName("hosted_confirmation")
    HostedConfirmation hostedConfirmation;
    /**
     * Configuration when {@code type=redirect}.
     */
    @SerializedName("redirect")
    Redirect redirect;
    /**
     * The specified behavior after the purchase is complete. Either {@code redirect} or {@code
     * hosted_confirmation}.
     */
    @SerializedName("type")
    Type type;

    private AfterCompletion(Map<String, Object> extraParams, HostedConfirmation hostedConfirmation, Redirect redirect, Type type) {
      this.extraParams = extraParams;
      this.hostedConfirmation = hostedConfirmation;
      this.redirect = redirect;
      this.type = type;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private HostedConfirmation hostedConfirmation;
      private Redirect redirect;
      private Type type;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public AfterCompletion build() {
        return new AfterCompletion(this.extraParams, this.hostedConfirmation, this.redirect, this.type);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.AfterCompletion#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentLinkCreateParams.AfterCompletion#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /**
       * Configuration when {@code type=hosted_confirmation}.
       */
      public Builder setHostedConfirmation(HostedConfirmation hostedConfirmation) {
        this.hostedConfirmation = hostedConfirmation;
        return this;
      }

      /**
       * Configuration when {@code type=redirect}.
       */
      public Builder setRedirect(Redirect redirect) {
        this.redirect = redirect;
        return this;
      }

      /**
       * The specified behavior after the purchase is complete. Either {@code redirect} or {@code
       * hosted_confirmation}.
       */
      public Builder setType(Type type) {
        this.type = type;
        return this;
      }
    }


    public static class HostedConfirmation {
      /**
       * A custom message to display to the customer after the purchase is complete.
       */
      @SerializedName("custom_message")
      String customMessage;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      private HostedConfirmation(String customMessage, Map<String, Object> extraParams) {
        this.customMessage = customMessage;
        this.extraParams = extraParams;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private String customMessage;
        private Map<String, Object> extraParams;

        /** Finalize and obtain parameter instance from this builder. */
        public HostedConfirmation build() {
          return new HostedConfirmation(this.customMessage, this.extraParams);
        }

        /** A custom message to display to the customer after the purchase is complete. */
        public Builder setCustomMessage(String customMessage) {
          this.customMessage = customMessage;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentLinkCreateParams.AfterCompletion.HostedConfirmation#extraParams}
         * for the field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }
      }

      /**
       * A custom message to display to the customer after the purchase is complete.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCustomMessage() {
        return this.customMessage;
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }
    }


    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
     * map. See {@link PaymentLinkCreateParams.AfterCompletion.HostedConfirmation#extraParams}
     * for the field documentation.
     */
    public static class Redirect {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * The URL the customer will be redirected to after the purchase is complete. You can embed
       * {@code {CHECKOUT_SESSION_ID}} into the URL to have the {@code id} of the completed <a
       * href="https://stripe.com/docs/api/checkout/sessions/object#checkout_session_object-id">checkout
       * session</a> included.
       */
      @SerializedName("url")
      String url;

      private Redirect(Map<String, Object> extraParams, String url) {
        this.extraParams = extraParams;
        this.url = url;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;
        private String url;

        /** Finalize and obtain parameter instance from this builder. */
        public Redirect build() {
          return new Redirect(this.extraParams, this.url);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentLinkCreateParams.AfterCompletion.Redirect#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentLinkCreateParams.AfterCompletion.Redirect#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        public Builder setUrl(String url) {
          this.url = url;
          return this;
        }
      }

      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      /**
       * The URL the customer will be redirected to after the purchase is complete. You can embed
       * {@code {CHECKOUT_SESSION_ID}} into the URL to have the {@code id} of the completed <a
       * href="https://stripe.com/docs/api/checkout/sessions/object#checkout_session_object-id">checkout
       * session</a> included.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUrl() {
        return this.url;
      }
    }


    /**
     * The URL the customer will be redirected to after the purchase is complete. You can embed
     * {@code {CHECKOUT_SESSION_ID}} into the URL to have the {@code id} of the completed <a
     * href="https://stripe.com/docs/api/checkout/sessions/object#checkout_session_object-id">checkout
     * session</a> included.
     */
    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("hosted_confirmation")
      HOSTED_CONFIRMATION("hosted_confirmation"), @SerializedName("redirect")
      REDIRECT("redirect");
      private final String value;

      Type(String value) {
        this.value = value;
      }

      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Configuration when {@code type=hosted_confirmation}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HostedConfirmation getHostedConfirmation() {
      return this.hostedConfirmation;
    }

    /**
     * Configuration when {@code type=redirect}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Redirect getRedirect() {
      return this.redirect;
    }

    /**
     * The specified behavior after the purchase is complete. Either {@code redirect} or {@code
     * hosted_confirmation}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Type getType() {
      return this.type;
    }
  }


  public static class AutomaticTax {
    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @SerializedName("enabled")
    Boolean enabled;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
      this.enabled = enabled;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Boolean enabled;
      private Map<String, Object> extraParams;

      /** Finalize and obtain parameter instance from this builder. */
      public AutomaticTax build() {
        return new AutomaticTax(this.enabled, this.extraParams);
      }

      /** If {@code true}, tax will be calculated automatically using the customer's location. */
      public Builder setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.AutomaticTax#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }

    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  /**
   * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
   * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
   * See {@link PaymentLinkCreateParams.AutomaticTax#extraParams} for the field documentation.
   */
  public static class LineItem {
    /**
     * When set, provides configuration for this item’s quantity to be adjusted by the customer
     * during checkout.
     */
    @SerializedName("adjustable_quantity")
    AdjustableQuantity adjustableQuantity;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * The ID of the <a href="https://stripe.com/docs/api/prices">Price</a> or <a
     * href="https://stripe.com/docs/api/plans">Plan</a> object.
     */
    @SerializedName("price")
    String price;
    /**
     * The quantity of the line item being purchased.
     */
    @SerializedName("quantity")
    Long quantity;

    private LineItem(AdjustableQuantity adjustableQuantity, Map<String, Object> extraParams, String price, Long quantity) {
      this.adjustableQuantity = adjustableQuantity;
      this.extraParams = extraParams;
      this.price = price;
      this.quantity = quantity;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private AdjustableQuantity adjustableQuantity;
      private Map<String, Object> extraParams;
      private String price;
      private Long quantity;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public LineItem build() {
        return new LineItem(this.adjustableQuantity, this.extraParams, this.price, this.quantity);
      }

      /**
       * When set, provides configuration for this item’s quantity to be adjusted by the customer
       * during checkout.
       */
      public Builder setAdjustableQuantity(AdjustableQuantity adjustableQuantity) {
        this.adjustableQuantity = adjustableQuantity;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.LineItem#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentLinkCreateParams.LineItem#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /**
       * The ID of the <a href="https://stripe.com/docs/api/prices">Price</a> or <a
       * href="https://stripe.com/docs/api/plans">Plan</a> object.
       */
      public Builder setPrice(String price) {
        this.price = price;
        return this;
      }

      /**
       * The quantity of the line item being purchased.
       */
      public Builder setQuantity(Long quantity) {
        this.quantity = quantity;
        return this;
      }
    }


    public static class AdjustableQuantity {
      /** Set to true if the quantity can be adjusted to any non-negative Integer. */
      @SerializedName("enabled")
      Boolean enabled;
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /**
       * The maximum quantity the customer can purchase. By default this value is 99. You can
       * specify a value up to 99.
       */
      @SerializedName("maximum")
      Long maximum;
      /**
       * The minimum quantity the customer can purchase. By default this value is 0. You can specify
       * a value up to 98. If there is only one item in the cart then that item's quantity cannot go
       * down to 0.
       */
      @SerializedName("minimum")
      Long minimum;

      private AdjustableQuantity(Boolean enabled, Map<String, Object> extraParams, Long maximum, Long minimum) {
        this.enabled = enabled;
        this.extraParams = extraParams;
        this.maximum = maximum;
        this.minimum = minimum;
      }

      public static Builder builder() {
        return new Builder();
      }


      public static class Builder {
        private Boolean enabled;
        private Map<String, Object> extraParams;
        private Long maximum;
        private Long minimum;

        /** Finalize and obtain parameter instance from this builder. */
        public AdjustableQuantity build() {
          return new AdjustableQuantity(this.enabled, this.extraParams, this.maximum, this.minimum);
        }

        /** Set to true if the quantity can be adjusted to any non-negative Integer. */
        public Builder setEnabled(Boolean enabled) {
          this.enabled = enabled;
          return this;
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentLinkCreateParams.LineItem.AdjustableQuantity#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link PaymentLinkCreateParams.LineItem.AdjustableQuantity#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * The maximum quantity the customer can purchase. By default this value is 99. You can
         * specify a value up to 99.
         */
        public Builder setMaximum(Long maximum) {
          this.maximum = maximum;
          return this;
        }

        public Builder setMinimum(Long minimum) {
          this.minimum = minimum;
          return this;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getEnabled() {
        return this.enabled;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Object> getExtraParams() {
        return this.extraParams;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMaximum() {
        return this.maximum;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMinimum() {
        return this.minimum;
      }
    }

    /**
     * When set, provides configuration for this item’s quantity to be adjusted by the customer
     * during checkout.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AdjustableQuantity getAdjustableQuantity() {
      return this.adjustableQuantity;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * The ID of the <a href="https://stripe.com/docs/api/prices">Price</a> or <a
     * href="https://stripe.com/docs/api/plans">Plan</a> object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPrice() {
      return this.price;
    }

    /**
     * The quantity of the line item being purchased.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuantity() {
      return this.quantity;
    }
  }


  /**
   * The minimum quantity the customer can purchase. By default this value is 0. You can
   * specify a value up to 98. If there is only one item in the cart then that item's quantity
   * cannot go down to 0.
   */
  public static class PhoneNumberCollection {
    /**
     * Set to {@code true} to enable phone number collection.
     */
    @SerializedName("enabled")
    Boolean enabled;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private PhoneNumberCollection(Boolean enabled, Map<String, Object> extraParams) {
      this.enabled = enabled;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Boolean enabled;
      private Map<String, Object> extraParams;

      /** Finalize and obtain parameter instance from this builder. */
      public PhoneNumberCollection build() {
        return new PhoneNumberCollection(this.enabled, this.extraParams);
      }

      /** Set to {@code true} to enable phone number collection. */
      public Builder setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.PhoneNumberCollection#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }

    /**
     * Set to {@code true} to enable phone number collection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  /**
   * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
   * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
   * See {@link PaymentLinkCreateParams.PhoneNumberCollection#extraParams} for the field
   * documentation.
   */
  public static class ShippingAddressCollection {
    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @SerializedName("allowed_countries")
    List<AllowedCountry> allowedCountries;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private ShippingAddressCollection(List<AllowedCountry> allowedCountries, Map<String, Object> extraParams) {
      this.allowedCountries = allowedCountries;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private List<AllowedCountry> allowedCountries;
      private Map<String, Object> extraParams;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public ShippingAddressCollection build() {
        return new ShippingAddressCollection(this.allowedCountries, this.extraParams);
      }

      /**
       * Add an element to `allowedCountries` list. A list is initialized for the first `add/addAll`
       * call, and subsequent calls adds additional elements to the original list. See {@link
       * PaymentLinkCreateParams.ShippingAddressCollection#allowedCountries} for the field
       * documentation.
       */
      public Builder addAllowedCountry(AllowedCountry element) {
        if (this.allowedCountries == null) {
          this.allowedCountries = new ArrayList<>();
        }
        this.allowedCountries.add(element);
        return this;
      }

      /**
       * Add all elements to `allowedCountries` list. A list is initialized for the first
       * `add/addAll` call, and subsequent calls adds additional elements to the original list. See
       * {@link PaymentLinkCreateParams.ShippingAddressCollection#allowedCountries} for the field
       * documentation.
       */
      public Builder addAllAllowedCountry(List<AllowedCountry> elements) {
        if (this.allowedCountries == null) {
          this.allowedCountries = new ArrayList<>();
        }
        this.allowedCountries.addAll(elements);
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.ShippingAddressCollection#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentLinkCreateParams.ShippingAddressCollection#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }


    public enum AllowedCountry implements ApiRequestParams.EnumParam {
      @SerializedName("AC")
      AC("AC"), @SerializedName("AD")
      AD("AD"), @SerializedName("AE")
      AE("AE"), @SerializedName("AF")
      AF("AF"), @SerializedName("AG")
      AG("AG"), @SerializedName("AI")
      AI("AI"), @SerializedName("AL")
      AL("AL"), @SerializedName("AM")
      AM("AM"), @SerializedName("AO")
      AO("AO"), @SerializedName("AQ")
      AQ("AQ"), @SerializedName("AR")
      AR("AR"), @SerializedName("AT")
      AT("AT"), @SerializedName("AU")
      AU("AU"), @SerializedName("AW")
      AW("AW"), @SerializedName("AX")
      AX("AX"), @SerializedName("AZ")
      AZ("AZ"), @SerializedName("BA")
      BA("BA"), @SerializedName("BB")
      BB("BB"), @SerializedName("BD")
      BD("BD"), @SerializedName("BE")
      BE("BE"), @SerializedName("BF")
      BF("BF"), @SerializedName("BG")
      BG("BG"), @SerializedName("BH")
      BH("BH"), @SerializedName("BI")
      BI("BI"), @SerializedName("BJ")
      BJ("BJ"), @SerializedName("BL")
      BL("BL"), @SerializedName("BM")
      BM("BM"), @SerializedName("BN")
      BN("BN"), @SerializedName("BO")
      BO("BO"), @SerializedName("BQ")
      BQ("BQ"), @SerializedName("BR")
      BR("BR"), @SerializedName("BS")
      BS("BS"), @SerializedName("BT")
      BT("BT"), @SerializedName("BV")
      BV("BV"), @SerializedName("BW")
      BW("BW"), @SerializedName("BY")
      BY("BY"), @SerializedName("BZ")
      BZ("BZ"), @SerializedName("CA")
      CA("CA"), @SerializedName("CD")
      CD("CD"), @SerializedName("CF")
      CF("CF"), @SerializedName("CG")
      CG("CG"), @SerializedName("CH")
      CH("CH"), @SerializedName("CI")
      CI("CI"), @SerializedName("CK")
      CK("CK"), @SerializedName("CL")
      CL("CL"), @SerializedName("CM")
      CM("CM"), @SerializedName("CN")
      CN("CN"), @SerializedName("CO")
      CO("CO"), @SerializedName("CR")
      CR("CR"), @SerializedName("CV")
      CV("CV"), @SerializedName("CW")
      CW("CW"), @SerializedName("CY")
      CY("CY"), @SerializedName("CZ")
      CZ("CZ"), @SerializedName("DE")
      DE("DE"), @SerializedName("DJ")
      DJ("DJ"), @SerializedName("DK")
      DK("DK"), @SerializedName("DM")
      DM("DM"), @SerializedName("DO")
      DO("DO"), @SerializedName("DZ")
      DZ("DZ"), @SerializedName("EC")
      EC("EC"), @SerializedName("EE")
      EE("EE"), @SerializedName("EG")
      EG("EG"), @SerializedName("EH")
      EH("EH"), @SerializedName("ER")
      ER("ER"), @SerializedName("ES")
      ES("ES"), @SerializedName("ET")
      ET("ET"), @SerializedName("FI")
      FI("FI"), @SerializedName("FJ")
      FJ("FJ"), @SerializedName("FK")
      FK("FK"), @SerializedName("FO")
      FO("FO"), @SerializedName("FR")
      FR("FR"), @SerializedName("GA")
      GA("GA"), @SerializedName("GB")
      GB("GB"), @SerializedName("GD")
      GD("GD"), @SerializedName("GE")
      GE("GE"), @SerializedName("GF")
      GF("GF"), @SerializedName("GG")
      GG("GG"), @SerializedName("GH")
      GH("GH"), @SerializedName("GI")
      GI("GI"), @SerializedName("GL")
      GL("GL"), @SerializedName("GM")
      GM("GM"), @SerializedName("GN")
      GN("GN"), @SerializedName("GP")
      GP("GP"), @SerializedName("GQ")
      GQ("GQ"), @SerializedName("GR")
      GR("GR"), @SerializedName("GS")
      GS("GS"), @SerializedName("GT")
      GT("GT"), @SerializedName("GU")
      GU("GU"), @SerializedName("GW")
      GW("GW"), @SerializedName("GY")
      GY("GY"), @SerializedName("HK")
      HK("HK"), @SerializedName("HN")
      HN("HN"), @SerializedName("HR")
      HR("HR"), @SerializedName("HT")
      HT("HT"), @SerializedName("HU")
      HU("HU"), @SerializedName("ID")
      ID("ID"), @SerializedName("IE")
      IE("IE"), @SerializedName("IL")
      IL("IL"), @SerializedName("IM")
      IM("IM"), @SerializedName("IN")
      IN("IN"), @SerializedName("IO")
      IO("IO"), @SerializedName("IQ")
      IQ("IQ"), @SerializedName("IS")
      IS("IS"), @SerializedName("IT")
      IT("IT"), @SerializedName("JE")
      JE("JE"), @SerializedName("JM")
      JM("JM"), @SerializedName("JO")
      JO("JO"), @SerializedName("JP")
      JP("JP"), @SerializedName("KE")
      KE("KE"), @SerializedName("KG")
      KG("KG"), @SerializedName("KH")
      KH("KH"), @SerializedName("KI")
      KI("KI"), @SerializedName("KM")
      KM("KM"), @SerializedName("KN")
      KN("KN"), @SerializedName("KR")
      KR("KR"), @SerializedName("KW")
      KW("KW"), @SerializedName("KY")
      KY("KY"), @SerializedName("KZ")
      KZ("KZ"), @SerializedName("LA")
      LA("LA"), @SerializedName("LB")
      LB("LB"), @SerializedName("LC")
      LC("LC"), @SerializedName("LI")
      LI("LI"), @SerializedName("LK")
      LK("LK"), @SerializedName("LR")
      LR("LR"), @SerializedName("LS")
      LS("LS"), @SerializedName("LT")
      LT("LT"), @SerializedName("LU")
      LU("LU"), @SerializedName("LV")
      LV("LV"), @SerializedName("LY")
      LY("LY"), @SerializedName("MA")
      MA("MA"), @SerializedName("MC")
      MC("MC"), @SerializedName("MD")
      MD("MD"), @SerializedName("ME")
      ME("ME"), @SerializedName("MF")
      MF("MF"), @SerializedName("MG")
      MG("MG"), @SerializedName("MK")
      MK("MK"), @SerializedName("ML")
      ML("ML"), @SerializedName("MM")
      MM("MM"), @SerializedName("MN")
      MN("MN"), @SerializedName("MO")
      MO("MO"), @SerializedName("MQ")
      MQ("MQ"), @SerializedName("MR")
      MR("MR"), @SerializedName("MS")
      MS("MS"), @SerializedName("MT")
      MT("MT"), @SerializedName("MU")
      MU("MU"), @SerializedName("MV")
      MV("MV"), @SerializedName("MW")
      MW("MW"), @SerializedName("MX")
      MX("MX"), @SerializedName("MY")
      MY("MY"), @SerializedName("MZ")
      MZ("MZ"), @SerializedName("NA")
      NA("NA"), @SerializedName("NC")
      NC("NC"), @SerializedName("NE")
      NE("NE"), @SerializedName("NG")
      NG("NG"), @SerializedName("NI")
      NI("NI"), @SerializedName("NL")
      NL("NL"), @SerializedName("NO")
      NO("NO"), @SerializedName("NP")
      NP("NP"), @SerializedName("NR")
      NR("NR"), @SerializedName("NU")
      NU("NU"), @SerializedName("NZ")
      NZ("NZ"), @SerializedName("OM")
      OM("OM"), @SerializedName("PA")
      PA("PA"), @SerializedName("PE")
      PE("PE"), @SerializedName("PF")
      PF("PF"), @SerializedName("PG")
      PG("PG"), @SerializedName("PH")
      PH("PH"), @SerializedName("PK")
      PK("PK"), @SerializedName("PL")
      PL("PL"), @SerializedName("PM")
      PM("PM"), @SerializedName("PN")
      PN("PN"), @SerializedName("PR")
      PR("PR"), @SerializedName("PS")
      PS("PS"), @SerializedName("PT")
      PT("PT"), @SerializedName("PY")
      PY("PY"), @SerializedName("QA")
      QA("QA"), @SerializedName("RE")
      RE("RE"), @SerializedName("RO")
      RO("RO"), @SerializedName("RS")
      RS("RS"), @SerializedName("RU")
      RU("RU"), @SerializedName("RW")
      RW("RW"), @SerializedName("SA")
      SA("SA"), @SerializedName("SB")
      SB("SB"), @SerializedName("SC")
      SC("SC"), @SerializedName("SE")
      SE("SE"), @SerializedName("SG")
      SG("SG"), @SerializedName("SH")
      SH("SH"), @SerializedName("SI")
      SI("SI"), @SerializedName("SJ")
      SJ("SJ"), @SerializedName("SK")
      SK("SK"), @SerializedName("SL")
      SL("SL"), @SerializedName("SM")
      SM("SM"), @SerializedName("SN")
      SN("SN"), @SerializedName("SO")
      SO("SO"), @SerializedName("SR")
      SR("SR"), @SerializedName("SS")
      SS("SS"), @SerializedName("ST")
      ST("ST"), @SerializedName("SV")
      SV("SV"), @SerializedName("SX")
      SX("SX"), @SerializedName("SZ")
      SZ("SZ"), @SerializedName("TA")
      TA("TA"), @SerializedName("TC")
      TC("TC"), @SerializedName("TD")
      TD("TD"), @SerializedName("TF")
      TF("TF"), @SerializedName("TG")
      TG("TG"), @SerializedName("TH")
      TH("TH"), @SerializedName("TJ")
      TJ("TJ"), @SerializedName("TK")
      TK("TK"), @SerializedName("TL")
      TL("TL"), @SerializedName("TM")
      TM("TM"), @SerializedName("TN")
      TN("TN"), @SerializedName("TO")
      TO("TO"), @SerializedName("TR")
      TR("TR"), @SerializedName("TT")
      TT("TT"), @SerializedName("TV")
      TV("TV"), @SerializedName("TW")
      TW("TW"), @SerializedName("TZ")
      TZ("TZ"), @SerializedName("UA")
      UA("UA"), @SerializedName("UG")
      UG("UG"), @SerializedName("US")
      US("US"), @SerializedName("UY")
      UY("UY"), @SerializedName("UZ")
      UZ("UZ"), @SerializedName("VA")
      VA("VA"), @SerializedName("VC")
      VC("VC"), @SerializedName("VE")
      VE("VE"), @SerializedName("VG")
      VG("VG"), @SerializedName("VN")
      VN("VN"), @SerializedName("VU")
      VU("VU"), @SerializedName("WF")
      WF("WF"), @SerializedName("WS")
      WS("WS"), @SerializedName("XK")
      XK("XK"), @SerializedName("YE")
      YE("YE"), @SerializedName("YT")
      YT("YT"), @SerializedName("ZA")
      ZA("ZA"), @SerializedName("ZM")
      ZM("ZM"), @SerializedName("ZW")
      ZW("ZW"), @SerializedName("ZZ")
      ZZ("ZZ");
      private final String value;

      AllowedCountry(String value) {
        this.value = value;
      }

      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }
    }

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AllowedCountry> getAllowedCountries() {
      return this.allowedCountries;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  public static class SubscriptionData {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time. Has to be at least 1.
     */
    @SerializedName("trial_period_days")
    Long trialPeriodDays;

    private SubscriptionData(Map<String, Object> extraParams, Long trialPeriodDays) {
      this.extraParams = extraParams;
      this.trialPeriodDays = trialPeriodDays;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Long trialPeriodDays;

      /** Finalize and obtain parameter instance from this builder. */
      public SubscriptionData build() {
        return new SubscriptionData(this.extraParams, this.trialPeriodDays);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.SubscriptionData#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link PaymentLinkCreateParams.SubscriptionData#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      public Builder setTrialPeriodDays(Long trialPeriodDays) {
        this.trialPeriodDays = trialPeriodDays;
        return this;
      }
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time. Has to be at least 1.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTrialPeriodDays() {
      return this.trialPeriodDays;
    }
  }


  /**
   * Integer representing the number of trial period days before the customer is charged for the
   * first time. Has to be at least 1.
   */
  public static class TransferData {
    /**
     * The amount that will be transferred automatically when a charge succeeds.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * If specified, successful charges will be attributed to the destination account for tax
     * reporting, and the funds from charges will be transferred to the destination account. The ID
     * of the resulting transfer will be returned on the successful charge's {@code transfer} field.
     */
    @SerializedName("destination")
    String destination;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private TransferData(Long amount, String destination, Map<String, Object> extraParams) {
      this.amount = amount;
      this.destination = destination;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Long amount;
      private String destination;
      private Map<String, Object> extraParams;

      /** Finalize and obtain parameter instance from this builder. */
      public TransferData build() {
        return new TransferData(this.amount, this.destination, this.extraParams);
      }

      /** The amount that will be transferred automatically when a charge succeeds. */
      public Builder setAmount(Long amount) {
        this.amount = amount;
        return this;
      }

      /**
       * If specified, successful charges will be attributed to the destination account for tax
       * reporting, and the funds from charges will be transferred to the destination account. The
       * ID of the resulting transfer will be returned on the successful charge's {@code transfer}
       * field.
       */
      public Builder setDestination(String destination) {
        this.destination = destination;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * PaymentLinkCreateParams.TransferData#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }

    /**
     * The amount that will be transferred automatically when a charge succeeds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * If specified, successful charges will be attributed to the destination account for tax
     * reporting, and the funds from charges will be transferred to the destination account. The ID
     * of the resulting transfer will be returned on the successful charge's {@code transfer} field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestination() {
      return this.destination;
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }
  }


  /**
   * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
   * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
   * See {@link PaymentLinkCreateParams.TransferData#extraParams} for the field documentation.
   */
  public enum BillingAddressCollection implements ApiRequestParams.EnumParam {
    @SerializedName("auto")
    AUTO("auto"), @SerializedName("required")
    REQUIRED("required");
    private final String value;

    BillingAddressCollection(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum PaymentMethodType implements ApiRequestParams.EnumParam {
    @SerializedName("card")
    CARD("card");
    private final String value;

    PaymentMethodType(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }

  /**
   * Behavior after the purchase is complete.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AfterCompletion getAfterCompletion() {
    return this.afterCompletion;
  }

  /**
   * Enables user redeemable promotion codes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAllowPromotionCodes() {
    return this.allowPromotionCodes;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account. Can only be applied when there are
   * no line items with recurring prices.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account. There must be at least 1 line item with a recurring price to use this
   * field.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApplicationFeePercent() {
    return this.applicationFeePercent;
  }

  /**
   * Configuration for automatic tax collection.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticTax getAutomaticTax() {
    return this.automaticTax;
  }

  /**
   * Configuration for collecting the customer's billing address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingAddressCollection getBillingAddressCollection() {
    return this.billingAddressCollection;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * The line items representing what is being sold. Each line item represents an item being sold.
   * Up to 20 line items are supported.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<LineItem> getLineItems() {
    return this.lineItems;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Individual keys can be unset by posting an empty value to them. All keys can
   * be unset by posting an empty value to {@code metadata}. Metadata associated with this Payment
   * Link will automatically be copied to <a
   * href="https://stripe.com/docs/api/checkout/sessions">checkout sessions</a> created by this
   * payment link.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * The account on behalf of which to charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOnBehalfOf() {
    return this.onBehalfOf;
  }

  /**
   * The list of payment method types that customers can use. Only {@code card} is supported. If no
   * value is passed, Stripe will dynamically show relevant payment methods from your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a> (20+
   * payment methods <a
   * href="https://stripe.com/docs/payments/payment-methods/integration-options#payment-method-product-support">supported</a>).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<PaymentMethodType> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * Controls phone number collection settings during checkout.
   *
   * <p>We recommend that you review your privacy policy and check with your legal contacts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PhoneNumberCollection getPhoneNumberCollection() {
    return this.phoneNumberCollection;
  }

  /**
   * Configuration for collecting the customer's shipping address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingAddressCollection getShippingAddressCollection() {
    return this.shippingAddressCollection;
  }

  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SubscriptionData getSubscriptionData() {
    return this.subscriptionData;
  }

  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }
}
