/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItem;
import com.stripe.model.LineItemCollection;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentLink;
import com.stripe.model.SetupIntent;
import com.stripe.model.ShippingDetails;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.checkout.SessionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.checkout.SessionCreateParams;
import com.stripe.param.checkout.SessionExpireParams;
import com.stripe.param.checkout.SessionListLineItemsParams;
import com.stripe.param.checkout.SessionListParams;
import com.stripe.param.checkout.SessionRetrieveParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Session
extends ApiResource
implements HasId {
    @SerializedName(value="after_expiration")
    AfterExpiration afterExpiration;
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_address_collection")
    String billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="consent")
    Consent consent;
    @SerializedName(value="consent_collection")
    ConsentCollection consentCollection;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_creation")
    String customerCreation;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="locale")
    String locale;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="mode")
    String mode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_link")
    ExpandableField<PaymentLink> paymentLink;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="payment_status")
    String paymentStatus;
    @SerializedName(value="phone_number_collection")
    PhoneNumberCollection phoneNumberCollection;
    @SerializedName(value="recovered_from")
    String recoveredFrom;
    @SerializedName(value="setup_intent")
    ExpandableField<SetupIntent> setupIntent;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="shipping_options")
    List<ShippingOption> shippingOptions;
    @SerializedName(value="shipping_rate")
    ExpandableField<ShippingRate> shippingRate;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="submit_type")
    String submitType;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="success_url")
    String successUrl;
    @SerializedName(value="tax_id_collection")
    TaxIDCollection taxIdCollection;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="url")
    String url;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentLink() {
        return this.paymentLink != null ? this.paymentLink.getId() : null;
    }

    public void setPaymentLink(String id) {
        this.paymentLink = ApiResource.setExpandableFieldId(id, this.paymentLink);
    }

    public PaymentLink getPaymentLinkObject() {
        return this.paymentLink != null ? this.paymentLink.getExpanded() : null;
    }

    public void setPaymentLinkObject(PaymentLink expandableObject) {
        this.paymentLink = new ExpandableField<PaymentLink>(expandableObject.getId(), expandableObject);
    }

    public String getSetupIntent() {
        return this.setupIntent != null ? this.setupIntent.getId() : null;
    }

    public void setSetupIntent(String id) {
        this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
    }

    public SetupIntent getSetupIntentObject() {
        return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
    }

    public void setSetupIntentObject(SetupIntent expandableObject) {
        this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public String getShippingRate() {
        return this.shippingRate != null ? this.shippingRate.getId() : null;
    }

    public void setShippingRate(String id) {
        this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
    }

    public ShippingRate getShippingRateObject() {
        return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
    }

    public void setShippingRateObject(ShippingRate expandableObject) {
        this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public static SessionCollection list(Map<String, Object> params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.requestCollection(url, params, SessionCollection.class, options);
    }

    public static SessionCollection list(SessionListParams params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(SessionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.requestCollection(url, params, SessionCollection.class, options);
    }

    public static Session retrieve(String session) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Session retrieve(String session, RequestOptions options) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, options);
    }

    public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    public static Session create(Map<String, Object> params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public static Session create(SessionCreateParams params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public Session expire() throws StripeException {
        return this.expire((Map<String, Object>)null, (RequestOptions)null);
    }

    public Session expire(RequestOptions options) throws StripeException {
        return this.expire((Map<String, Object>)null, options);
    }

    public Session expire(Map<String, Object> params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public Session expire(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/expire", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public Session expire(SessionExpireParams params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public Session expire(SessionExpireParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/expire", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(SessionListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(SessionListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    @Generated
    public AfterExpiration getAfterExpiration() {
        return this.afterExpiration;
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public Consent getConsent() {
        return this.consent;
    }

    @Generated
    public ConsentCollection getConsentCollection() {
        return this.consentCollection;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomerCreation() {
        return this.customerCreation;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Generated
    public PhoneNumberCollection getPhoneNumberCollection() {
        return this.phoneNumberCollection;
    }

    @Generated
    public String getRecoveredFrom() {
        return this.recoveredFrom;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getSubmitType() {
        return this.submitType;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @Generated
    public TaxIDCollection getTaxIdCollection() {
        return this.taxIdCollection;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setAfterExpiration(AfterExpiration afterExpiration) {
        this.afterExpiration = afterExpiration;
    }

    @Generated
    public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
        this.allowPromotionCodes = allowPromotionCodes;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingAddressCollection(String billingAddressCollection) {
        this.billingAddressCollection = billingAddressCollection;
    }

    @Generated
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @Generated
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @Generated
    public void setConsent(Consent consent) {
        this.consent = consent;
    }

    @Generated
    public void setConsentCollection(ConsentCollection consentCollection) {
        this.consentCollection = consentCollection;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomerCreation(String customerCreation) {
        this.customerCreation = customerCreation;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @Generated
    public void setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
        this.phoneNumberCollection = phoneNumberCollection;
    }

    @Generated
    public void setRecoveredFrom(String recoveredFrom) {
        this.recoveredFrom = recoveredFrom;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
        this.shippingAddressCollection = shippingAddressCollection;
    }

    @Generated
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setSubmitType(String submitType) {
        this.submitType = submitType;
    }

    @Generated
    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    @Generated
    public void setTaxIdCollection(TaxIDCollection taxIdCollection) {
        this.taxIdCollection = taxIdCollection;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
        Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
        if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AfterExpiration this$afterExpiration = this.getAfterExpiration();
        AfterExpiration other$afterExpiration = other.getAfterExpiration();
        if (this$afterExpiration == null ? other$afterExpiration != null : !((Object)this$afterExpiration).equals(other$afterExpiration)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$billingAddressCollection = this.getBillingAddressCollection();
        String other$billingAddressCollection = other.getBillingAddressCollection();
        if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) {
            return false;
        }
        String this$cancelUrl = this.getCancelUrl();
        String other$cancelUrl = other.getCancelUrl();
        if (this$cancelUrl == null ? other$cancelUrl != null : !this$cancelUrl.equals(other$cancelUrl)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        Consent this$consent = this.getConsent();
        Consent other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        ConsentCollection this$consentCollection = this.getConsentCollection();
        ConsentCollection other$consentCollection = other.getConsentCollection();
        if (this$consentCollection == null ? other$consentCollection != null : !((Object)this$consentCollection).equals(other$consentCollection)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerCreation = this.getCustomerCreation();
        String other$customerCreation = other.getCustomerCreation();
        if (this$customerCreation == null ? other$customerCreation != null : !this$customerCreation.equals(other$customerCreation)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$customerEmail = this.getCustomerEmail();
        String other$customerEmail = other.getCustomerEmail();
        if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$paymentLink = this.getPaymentLink();
        String other$paymentLink = other.getPaymentLink();
        if (this$paymentLink == null ? other$paymentLink != null : !this$paymentLink.equals(other$paymentLink)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$paymentStatus = this.getPaymentStatus();
        String other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !this$paymentStatus.equals(other$paymentStatus)) {
            return false;
        }
        PhoneNumberCollection this$phoneNumberCollection = this.getPhoneNumberCollection();
        PhoneNumberCollection other$phoneNumberCollection = other.getPhoneNumberCollection();
        if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !((Object)this$phoneNumberCollection).equals(other$phoneNumberCollection)) {
            return false;
        }
        String this$recoveredFrom = this.getRecoveredFrom();
        String other$recoveredFrom = other.getRecoveredFrom();
        if (this$recoveredFrom == null ? other$recoveredFrom != null : !this$recoveredFrom.equals(other$recoveredFrom)) {
            return false;
        }
        String this$setupIntent = this.getSetupIntent();
        String other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ShippingAddressCollection this$shippingAddressCollection = this.getShippingAddressCollection();
        ShippingAddressCollection other$shippingAddressCollection = other.getShippingAddressCollection();
        if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !((Object)this$shippingAddressCollection).equals(other$shippingAddressCollection)) {
            return false;
        }
        List<ShippingOption> this$shippingOptions = this.getShippingOptions();
        List<ShippingOption> other$shippingOptions = other.getShippingOptions();
        if (this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions)) {
            return false;
        }
        String this$shippingRate = this.getShippingRate();
        String other$shippingRate = other.getShippingRate();
        if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$submitType = this.getSubmitType();
        String other$submitType = other.getSubmitType();
        if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$successUrl = this.getSuccessUrl();
        String other$successUrl = other.getSuccessUrl();
        if (this$successUrl == null ? other$successUrl != null : !this$successUrl.equals(other$successUrl)) {
            return false;
        }
        TaxIDCollection this$taxIdCollection = this.getTaxIdCollection();
        TaxIDCollection other$taxIdCollection = other.getTaxIdCollection();
        if (this$taxIdCollection == null ? other$taxIdCollection != null : !((Object)this$taxIdCollection).equals(other$taxIdCollection)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        if (this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Session;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
        result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AfterExpiration $afterExpiration = this.getAfterExpiration();
        result = result * 59 + ($afterExpiration == null ? 43 : ((Object)$afterExpiration).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $billingAddressCollection = this.getBillingAddressCollection();
        result = result * 59 + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
        String $cancelUrl = this.getCancelUrl();
        result = result * 59 + ($cancelUrl == null ? 43 : $cancelUrl.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        Consent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        ConsentCollection $consentCollection = this.getConsentCollection();
        result = result * 59 + ($consentCollection == null ? 43 : ((Object)$consentCollection).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerCreation = this.getCustomerCreation();
        result = result * 59 + ($customerCreation == null ? 43 : $customerCreation.hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $customerEmail = this.getCustomerEmail();
        result = result * 59 + ($customerEmail == null ? 43 : $customerEmail.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $paymentLink = this.getPaymentLink();
        result = result * 59 + ($paymentLink == null ? 43 : $paymentLink.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : $paymentStatus.hashCode());
        PhoneNumberCollection $phoneNumberCollection = this.getPhoneNumberCollection();
        result = result * 59 + ($phoneNumberCollection == null ? 43 : ((Object)$phoneNumberCollection).hashCode());
        String $recoveredFrom = this.getRecoveredFrom();
        result = result * 59 + ($recoveredFrom == null ? 43 : $recoveredFrom.hashCode());
        String $setupIntent = this.getSetupIntent();
        result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ShippingAddressCollection $shippingAddressCollection = this.getShippingAddressCollection();
        result = result * 59 + ($shippingAddressCollection == null ? 43 : ((Object)$shippingAddressCollection).hashCode());
        List<ShippingOption> $shippingOptions = this.getShippingOptions();
        result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
        String $shippingRate = this.getShippingRate();
        result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $submitType = this.getSubmitType();
        result = result * 59 + ($submitType == null ? 43 : $submitType.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $successUrl = this.getSuccessUrl();
        result = result * 59 + ($successUrl == null ? 43 : $successUrl.hashCode());
        TaxIDCollection $taxIdCollection = this.getTaxIdCollection();
        result = result * 59 + ($taxIdCollection == null ? 43 : ((Object)$taxIdCollection).hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<LineItem.Discount> discounts;
            @SerializedName(value="taxes")
            List<LineItem.Tax> taxes;

            @Generated
            public List<LineItem.Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<LineItem.Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<LineItem.Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<LineItem.Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<LineItem.Discount> this$discounts = this.getDiscounts();
                List<LineItem.Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<LineItem.Tax> this$taxes = this.getTaxes();
                List<LineItem.Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<LineItem.Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<LineItem.Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }
        }
    }

    public static class TaxIDCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxIDCollection)) {
                return false;
            }
            TaxIDCollection other = (TaxIDCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxIDCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class ShippingOption
    extends StripeObject {
        @SerializedName(value="shipping_amount")
        Long shippingAmount;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getShippingAmount() {
            return this.shippingAmount;
        }

        @Generated
        public void setShippingAmount(Long shippingAmount) {
            this.shippingAmount = shippingAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingOption)) {
                return false;
            }
            ShippingOption other = (ShippingOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$shippingAmount = this.getShippingAmount();
            Long other$shippingAmount = other.getShippingAmount();
            if (this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            return !(this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $shippingAmount = this.getShippingAmount();
            result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            return result;
        }
    }

    public static class ShippingAddressCollection
    extends StripeObject {
        @SerializedName(value="allowed_countries")
        List<String> allowedCountries;

        @Generated
        public List<String> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public void setAllowedCountries(List<String> allowedCountries) {
            this.allowedCountries = allowedCountries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingAddressCollection)) {
                return false;
            }
            ShippingAddressCollection other = (ShippingAddressCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCountries = this.getAllowedCountries();
            List<String> other$allowedCountries = other.getAllowedCountries();
            return !(this$allowedCountries == null ? other$allowedCountries != null : !((Object)this$allowedCountries).equals(other$allowedCountries));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingAddressCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCountries = this.getAllowedCountries();
            result = result * 59 + ($allowedCountries == null ? 43 : ((Object)$allowedCountries).hashCode());
            return result;
        }
    }

    public static class PhoneNumberCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberCollection)) {
                return false;
            }
            PhoneNumberCollection other = (PhoneNumberCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setKonbini(Konbini konbini) {
            this.konbini = konbini;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Konbini
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                return !(this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                return result;
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="custom_mandate_url")
                String customMandateUrl;
                @SerializedName(value="default_for")
                List<String> defaultFor;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                String paymentSchedule;
                @SerializedName(value="transaction_type")
                String transactionType;

                @Generated
                public String getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public List<String> getDefaultFor() {
                    return this.defaultFor;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public String getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getTransactionType() {
                    return this.transactionType;
                }

                @Generated
                public void setCustomMandateUrl(String customMandateUrl) {
                    this.customMandateUrl = customMandateUrl;
                }

                @Generated
                public void setDefaultFor(List<String> defaultFor) {
                    this.defaultFor = defaultFor;
                }

                @Generated
                public void setIntervalDescription(String intervalDescription) {
                    this.intervalDescription = intervalDescription;
                }

                @Generated
                public void setPaymentSchedule(String paymentSchedule) {
                    this.paymentSchedule = paymentSchedule;
                }

                @Generated
                public void setTransactionType(String transactionType) {
                    this.transactionType = transactionType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$customMandateUrl = this.getCustomMandateUrl();
                    String other$customMandateUrl = other.getCustomMandateUrl();
                    if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                        return false;
                    }
                    List<String> this$defaultFor = this.getDefaultFor();
                    List<String> other$defaultFor = other.getDefaultFor();
                    if (this$defaultFor == null ? other$defaultFor != null : !((Object)this$defaultFor).equals(other$defaultFor)) {
                        return false;
                    }
                    String this$intervalDescription = this.getIntervalDescription();
                    String other$intervalDescription = other.getIntervalDescription();
                    if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                        return false;
                    }
                    String this$paymentSchedule = this.getPaymentSchedule();
                    String other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$transactionType = this.getTransactionType();
                    String other$transactionType = other.getTransactionType();
                    return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $customMandateUrl = this.getCustomMandateUrl();
                    result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                    List<String> $defaultFor = this.getDefaultFor();
                    result = result * 59 + ($defaultFor == null ? 43 : ((Object)$defaultFor).hashCode());
                    String $intervalDescription = this.getIntervalDescription();
                    result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                    String $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $transactionType = this.getTransactionType();
                    result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                    return result;
                }
            }
        }
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tax_exempt")
        String taxExempt;
        @SerializedName(value="tax_ids")
        List<TaxID> taxIds;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getTaxExempt() {
            return this.taxExempt;
        }

        @Generated
        public List<TaxID> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setTaxExempt(String taxExempt) {
            this.taxExempt = taxExempt;
        }

        @Generated
        public void setTaxIds(List<TaxID> taxIds) {
            this.taxIds = taxIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$taxExempt = this.getTaxExempt();
            String other$taxExempt = other.getTaxExempt();
            if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) {
                return false;
            }
            List<TaxID> this$taxIds = this.getTaxIds();
            List<TaxID> other$taxIds = other.getTaxIds();
            return !(this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $taxExempt = this.getTaxExempt();
            result = result * 59 + ($taxExempt == null ? 43 : $taxExempt.hashCode());
            List<TaxID> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            return result;
        }

        public static class TaxID
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxID)) {
                    return false;
                }
                TaxID other = (TaxID)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxID;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ConsentCollection
    extends StripeObject {
        @SerializedName(value="promotions")
        String promotions;

        @Generated
        public String getPromotions() {
            return this.promotions;
        }

        @Generated
        public void setPromotions(String promotions) {
            this.promotions = promotions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsentCollection)) {
                return false;
            }
            ConsentCollection other = (ConsentCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$promotions = this.getPromotions();
            String other$promotions = other.getPromotions();
            return !(this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConsentCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $promotions = this.getPromotions();
            result = result * 59 + ($promotions == null ? 43 : $promotions.hashCode());
            return result;
        }
    }

    public static class Consent
    extends StripeObject {
        @SerializedName(value="promotions")
        String promotions;

        @Generated
        public String getPromotions() {
            return this.promotions;
        }

        @Generated
        public void setPromotions(String promotions) {
            this.promotions = promotions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Consent)) {
                return false;
            }
            Consent other = (Consent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$promotions = this.getPromotions();
            String other$promotions = other.getPromotions();
            return !(this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Consent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $promotions = this.getPromotions();
            result = result * 59 + ($promotions == null ? 43 : $promotions.hashCode());
            return result;
        }
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class AfterExpiration
    extends StripeObject {
        @SerializedName(value="recovery")
        Recovery recovery;

        @Generated
        public Recovery getRecovery() {
            return this.recovery;
        }

        @Generated
        public void setRecovery(Recovery recovery) {
            this.recovery = recovery;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterExpiration)) {
                return false;
            }
            AfterExpiration other = (AfterExpiration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Recovery this$recovery = this.getRecovery();
            Recovery other$recovery = other.getRecovery();
            return !(this$recovery == null ? other$recovery != null : !((Object)this$recovery).equals(other$recovery));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterExpiration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Recovery $recovery = this.getRecovery();
            result = result * 59 + ($recovery == null ? 43 : ((Object)$recovery).hashCode());
            return result;
        }

        public static class Recovery
        extends StripeObject {
            @SerializedName(value="allow_promotion_codes")
            Boolean allowPromotionCodes;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="url")
            String url;

            @Generated
            public Boolean getAllowPromotionCodes() {
                return this.allowPromotionCodes;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
                this.allowPromotionCodes = allowPromotionCodes;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Recovery)) {
                    return false;
                }
                Recovery other = (Recovery)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
                Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
                if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Recovery;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
                result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }
    }
}

