/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentLinkCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentLinkCreateParams;
import com.stripe.param.PaymentLinkListLineItemsParams;
import com.stripe.param.PaymentLinkListParams;
import com.stripe.param.PaymentLinkRetrieveParams;
import com.stripe.param.PaymentLinkUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentLink
extends ApiResource
implements HasId,
MetadataStore<PaymentLink> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="after_completion")
    AfterCompletion afterCompletion;
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_address_collection")
    String billingAddressCollection;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="phone_number_collection")
    PhoneNumberCollection phoneNumberCollection;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="url")
    String url;

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public static PaymentLinkCollection list(Map<String, Object> params) throws StripeException {
        return PaymentLink.list(params, (RequestOptions)null);
    }

    public static PaymentLinkCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
        return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
    }

    public static PaymentLinkCollection list(PaymentLinkListParams params) throws StripeException {
        return PaymentLink.list(params, (RequestOptions)null);
    }

    public static PaymentLinkCollection list(PaymentLinkListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
        return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
    }

    public static PaymentLink retrieve(String paymentLink) throws StripeException {
        return PaymentLink.retrieve(paymentLink, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentLink retrieve(String paymentLink, RequestOptions options) throws StripeException {
        return PaymentLink.retrieve(paymentLink, (Map<String, Object>)null, options);
    }

    public static PaymentLink retrieve(String paymentLink, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
    }

    public static PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public static PaymentLink create(Map<String, Object> params) throws StripeException {
        return PaymentLink.create(params, (RequestOptions)null);
    }

    public static PaymentLink create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
    }

    public static PaymentLink create(PaymentLinkCreateParams params) throws StripeException {
        return PaymentLink.create(params, (RequestOptions)null);
    }

    public static PaymentLink create(PaymentLinkCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
    }

    public PaymentLink update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentLink update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
    }

    public PaymentLink update(PaymentLinkUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentLink update(PaymentLinkUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public AfterCompletion getAfterCompletion() {
        return this.afterCompletion;
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public PhoneNumberCollection getPhoneNumberCollection() {
        return this.phoneNumberCollection;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAfterCompletion(AfterCompletion afterCompletion) {
        this.afterCompletion = afterCompletion;
    }

    @Generated
    public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
        this.allowPromotionCodes = allowPromotionCodes;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingAddressCollection(String billingAddressCollection) {
        this.billingAddressCollection = billingAddressCollection;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
        this.phoneNumberCollection = phoneNumberCollection;
    }

    @Generated
    public void setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
        this.shippingAddressCollection = shippingAddressCollection;
    }

    @Generated
    public void setSubscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentLink)) {
            return false;
        }
        PaymentLink other = (PaymentLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
        Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
        if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AfterCompletion this$afterCompletion = this.getAfterCompletion();
        AfterCompletion other$afterCompletion = other.getAfterCompletion();
        if (this$afterCompletion == null ? other$afterCompletion != null : !((Object)this$afterCompletion).equals(other$afterCompletion)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$billingAddressCollection = this.getBillingAddressCollection();
        String other$billingAddressCollection = other.getBillingAddressCollection();
        if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        PhoneNumberCollection this$phoneNumberCollection = this.getPhoneNumberCollection();
        PhoneNumberCollection other$phoneNumberCollection = other.getPhoneNumberCollection();
        if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !((Object)this$phoneNumberCollection).equals(other$phoneNumberCollection)) {
            return false;
        }
        ShippingAddressCollection this$shippingAddressCollection = this.getShippingAddressCollection();
        ShippingAddressCollection other$shippingAddressCollection = other.getShippingAddressCollection();
        if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !((Object)this$shippingAddressCollection).equals(other$shippingAddressCollection)) {
            return false;
        }
        SubscriptionData this$subscriptionData = this.getSubscriptionData();
        SubscriptionData other$subscriptionData = other.getSubscriptionData();
        if (this$subscriptionData == null ? other$subscriptionData != null : !((Object)this$subscriptionData).equals(other$subscriptionData)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
        result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AfterCompletion $afterCompletion = this.getAfterCompletion();
        result = result * 59 + ($afterCompletion == null ? 43 : ((Object)$afterCompletion).hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $billingAddressCollection = this.getBillingAddressCollection();
        result = result * 59 + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        PhoneNumberCollection $phoneNumberCollection = this.getPhoneNumberCollection();
        result = result * 59 + ($phoneNumberCollection == null ? 43 : ((Object)$phoneNumberCollection).hashCode());
        ShippingAddressCollection $shippingAddressCollection = this.getShippingAddressCollection();
        result = result * 59 + ($shippingAddressCollection == null ? 43 : ((Object)$shippingAddressCollection).hashCode());
        SubscriptionData $subscriptionData = this.getSubscriptionData();
        result = result * 59 + ($subscriptionData == null ? 43 : ((Object)$subscriptionData).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AfterCompletion
    extends StripeObject {
        @SerializedName(value="hosted_confirmation")
        HostedConfirmation hostedConfirmation;
        @SerializedName(value="redirect")
        Redirect redirect;
        @SerializedName(value="type")
        String type;

        @Generated
        public HostedConfirmation getHostedConfirmation() {
            return this.hostedConfirmation;
        }

        @Generated
        public Redirect getRedirect() {
            return this.redirect;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setHostedConfirmation(HostedConfirmation hostedConfirmation) {
            this.hostedConfirmation = hostedConfirmation;
        }

        @Generated
        public void setRedirect(Redirect redirect) {
            this.redirect = redirect;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterCompletion)) {
                return false;
            }
            AfterCompletion other = (AfterCompletion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HostedConfirmation this$hostedConfirmation = this.getHostedConfirmation();
            HostedConfirmation other$hostedConfirmation = other.getHostedConfirmation();
            if (this$hostedConfirmation == null ? other$hostedConfirmation != null : !((Object)this$hostedConfirmation).equals(other$hostedConfirmation)) {
                return false;
            }
            Redirect this$redirect = this.getRedirect();
            Redirect other$redirect = other.getRedirect();
            if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterCompletion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HostedConfirmation $hostedConfirmation = this.getHostedConfirmation();
            result = result * 59 + ($hostedConfirmation == null ? 43 : ((Object)$hostedConfirmation).hashCode());
            Redirect $redirect = this.getRedirect();
            result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class HostedConfirmation
        extends StripeObject {
            @SerializedName(value="custom_message")
            String customMessage;

            @Generated
            public String getCustomMessage() {
                return this.customMessage;
            }

            @Generated
            public void setCustomMessage(String customMessage) {
                this.customMessage = customMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HostedConfirmation)) {
                    return false;
                }
                HostedConfirmation other = (HostedConfirmation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$customMessage = this.getCustomMessage();
                String other$customMessage = other.getCustomMessage();
                return !(this$customMessage == null ? other$customMessage != null : !this$customMessage.equals(other$customMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof HostedConfirmation;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $customMessage = this.getCustomMessage();
                result = result * 59 + ($customMessage == null ? 43 : $customMessage.hashCode());
                return result;
            }
        }

        public static class Redirect
        extends StripeObject {
            @SerializedName(value="url")
            String url;

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Redirect)) {
                    return false;
                }
                Redirect other = (Redirect)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Redirect;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class PhoneNumberCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberCollection)) {
                return false;
            }
            PhoneNumberCollection other = (PhoneNumberCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class ShippingAddressCollection
    extends StripeObject {
        @SerializedName(value="allowed_countries")
        List<String> allowedCountries;

        @Generated
        public List<String> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public void setAllowedCountries(List<String> allowedCountries) {
            this.allowedCountries = allowedCountries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingAddressCollection)) {
                return false;
            }
            ShippingAddressCollection other = (ShippingAddressCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCountries = this.getAllowedCountries();
            List<String> other$allowedCountries = other.getAllowedCountries();
            return !(this$allowedCountries == null ? other$allowedCountries != null : !((Object)this$allowedCountries).equals(other$allowedCountries));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingAddressCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCountries = this.getAllowedCountries();
            result = result * 59 + ($allowedCountries == null ? 43 : ((Object)$allowedCountries).hashCode());
            return result;
        }
    }

    public static class SubscriptionData
    extends StripeObject {
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        @Generated
        public void setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionData)) {
                return false;
            }
            SubscriptionData other = (SubscriptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$trialPeriodDays = this.getTrialPeriodDays();
            Long other$trialPeriodDays = other.getTrialPeriodDays();
            return !(this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $trialPeriodDays = this.getTrialPeriodDays();
            result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
            return result;
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }
}

