// Generated by delombok at Fri Apr 01 14:33:21 PDT 2022
// File generated from our OpenAPI spec
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceListParams extends ApiRequestParams {
  /**
   * The collection method of the invoice to retrieve. Either {@code charge_automatically} or {@code
   * send_invoice}.
   */
  @SerializedName("collection_method")
  CollectionMethod collectionMethod;
  @SerializedName("created")
  Object created;
  /**
   * Only return invoices for the customer specified by this customer ID.
   */
  @SerializedName("customer")
  String customer;
  @SerializedName("due_date")
  Object dueDate;
  /**
   * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, starting with
   * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
   * fetch the previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;
  /**
   * A cursor for use in pagination. {@code starting_after} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, ending with
   * {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in order to
   * fetch the next page of the list.
   */
  @SerializedName("starting_after")
  String startingAfter;
  /**
   * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
   * uncollectible}, or {@code void}. <a
   * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
   */
  @SerializedName("status")
  Status status;
  /**
   * Only return invoices for the subscription specified by this subscription ID.
   */
  @SerializedName("subscription")
  String subscription;

  private InvoiceListParams(CollectionMethod collectionMethod, Object created, String customer, Object dueDate, String endingBefore, List<String> expand, Map<String, Object> extraParams, Long limit, String startingAfter, Status status, String subscription) {
    this.collectionMethod = collectionMethod;
    this.created = created;
    this.customer = customer;
    this.dueDate = dueDate;
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.extraParams = extraParams;
    this.limit = limit;
    this.startingAfter = startingAfter;
    this.status = status;
    this.subscription = subscription;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private CollectionMethod collectionMethod;
    private Object created;
    private String customer;
    private Object dueDate;
    private String endingBefore;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private Long limit;
    private String startingAfter;
    private Status status;
    private String subscription;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public InvoiceListParams build() {
      return new InvoiceListParams(this.collectionMethod, this.created, this.customer, this.dueDate, this.endingBefore, this.expand, this.extraParams, this.limit, this.startingAfter, this.status, this.subscription);
    }

    /**
     * The collection method of the invoice to retrieve. Either {@code charge_automatically} or
     * {@code send_invoice}.
     */
    public Builder setCollectionMethod(CollectionMethod collectionMethod) {
      this.collectionMethod = collectionMethod;
      return this;
    }

    public Builder setCreated(Created created) {
      this.created = created;
      return this;
    }

    public Builder setCreated(Long created) {
      this.created = created;
      return this;
    }

    /**
     * Only return invoices for the customer specified by this customer ID.
     */
    public Builder setCustomer(String customer) {
      this.customer = customer;
      return this;
    }

    public Builder setDueDate(DueDate dueDate) {
      this.dueDate = dueDate;
      return this;
    }

    public Builder setDueDate(Long dueDate) {
      this.dueDate = dueDate;
      return this;
    }

    /**
     * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
     * in the list. For instance, if you make a list request and receive 100 objects, starting with
     * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
     * fetch the previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * InvoiceListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * InvoiceListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * InvoiceListParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link InvoiceListParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * A cursor for use in pagination. {@code starting_after} is an object ID that defines your
     * place in the list. For instance, if you make a list request and receive 100 objects, ending
     * with {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in
     * order to fetch the next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /**
     * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
     * uncollectible}, or {@code void}. <a
     * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
     */
    public Builder setStatus(Status status) {
      this.status = status;
      return this;
    }

    /**
     * Only return invoices for the subscription specified by this subscription ID.
     */
    public Builder setSubscription(String subscription) {
      this.subscription = subscription;
      return this;
    }
  }


  public static class Created {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Minimum value to filter by (exclusive).
     */
    @SerializedName("gt")
    Long gt;
    /**
     * Minimum value to filter by (inclusive).
     */
    @SerializedName("gte")
    Long gte;
    /**
     * Maximum value to filter by (exclusive).
     */
    @SerializedName("lt")
    Long lt;
    /**
     * Maximum value to filter by (inclusive).
     */
    @SerializedName("lte")
    Long lte;

    private Created(Map<String, Object> extraParams, Long gt, Long gte, Long lt, Long lte) {
      this.extraParams = extraParams;
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Long gt;
      private Long gte;
      private Long lt;
      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public Created build() {
        return new Created(this.extraParams, this.gt, this.gte, this.lt, this.lte);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * InvoiceListParams.Created#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link InvoiceListParams.Created#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Minimum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGt() {
      return this.gt;
    }

    /**
     * Minimum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGte() {
      return this.gte;
    }

    /**
     * Maximum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLt() {
      return this.lt;
    }

    /**
     * Maximum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLte() {
      return this.lte;
    }
  }


  /**
   * Maximum value to filter by (inclusive).
   */
  public static class DueDate {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Minimum value to filter by (exclusive).
     */
    @SerializedName("gt")
    Long gt;
    /**
     * Minimum value to filter by (inclusive).
     */
    @SerializedName("gte")
    Long gte;
    /**
     * Maximum value to filter by (exclusive).
     */
    @SerializedName("lt")
    Long lt;
    /**
     * Maximum value to filter by (inclusive).
     */
    @SerializedName("lte")
    Long lte;

    private DueDate(Map<String, Object> extraParams, Long gt, Long gte, Long lt, Long lte) {
      this.extraParams = extraParams;
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Long gt;
      private Long gte;
      private Long lt;
      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public DueDate build() {
        return new DueDate(this.extraParams, this.gt, this.gte, this.lt, this.lte);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * InvoiceListParams.DueDate#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link InvoiceListParams.DueDate#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Minimum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGt() {
      return this.gt;
    }

    /**
     * Minimum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGte() {
      return this.gte;
    }

    /**
     * Maximum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLt() {
      return this.lt;
    }

    /**
     * Maximum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLte() {
      return this.lte;
    }
  }


  /**
   * Maximum value to filter by (inclusive).
   */
  public enum CollectionMethod implements ApiRequestParams.EnumParam {
    @SerializedName("charge_automatically")
    CHARGE_AUTOMATICALLY("charge_automatically"), @SerializedName("send_invoice")
    SEND_INVOICE("send_invoice");
    private final String value;

    CollectionMethod(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum Status implements ApiRequestParams.EnumParam {
    @SerializedName("draft")
    DRAFT("draft"), @SerializedName("open")
    OPEN("open"), @SerializedName("paid")
    PAID("paid"), @SerializedName("uncollectible")
    UNCOLLECTIBLE("uncollectible"), @SerializedName("void")
    VOID("void");
    private final String value;

    Status(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }

  /**
   * The collection method of the invoice to retrieve. Either {@code charge_automatically} or {@code
   * send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CollectionMethod getCollectionMethod() {
    return this.collectionMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getCreated() {
    return this.created;
  }

  /**
   * Only return invoices for the customer specified by this customer ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getDueDate() {
    return this.dueDate;
  }

  /**
   * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, starting with
   * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
   * fetch the previous page of the list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEndingBefore() {
    return this.endingBefore;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getLimit() {
    return this.limit;
  }

  /**
   * A cursor for use in pagination. {@code starting_after} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, ending with
   * {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in order to
   * fetch the next page of the list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStartingAfter() {
    return this.startingAfter;
  }

  /**
   * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
   * uncollectible}, or {@code void}. <a
   * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Status getStatus() {
    return this.status;
  }

  /**
   * Only return invoices for the subscription specified by this subscription ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscription() {
    return this.subscription;
  }
}
