/*
 * Decompiled with CFR 0.152.
 */
package com.stripe;

import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class Stripe {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 80000;
    public static final String API_VERSION = "2020-08-27";
    public static final String CONNECT_API_BASE = "https://connect.stripe.com";
    public static final String LIVE_API_BASE = "https://api.stripe.com";
    public static final String UPLOAD_API_BASE = "https://files.stripe.com";
    public static final String VERSION = "20.118.0";
    public static volatile String apiKey;
    public static volatile String clientId;
    public static volatile boolean enableTelemetry;
    public static volatile String partnerId;
    private static volatile int connectTimeout;
    private static volatile int readTimeout;
    private static volatile int maxNetworkRetries;
    private static volatile String apiBase;
    private static volatile String connectBase;
    private static volatile String uploadBase;
    private static volatile Proxy connectionProxy;
    private static volatile PasswordAuthentication proxyCredential;
    private static volatile Map<String, String> appInfo;

    public static void overrideApiBase(String overriddenApiBase) {
        apiBase = overriddenApiBase;
    }

    public static String getApiBase() {
        return apiBase;
    }

    public static void overrideConnectBase(String overriddenConnectBase) {
        connectBase = overriddenConnectBase;
    }

    public static String getConnectBase() {
        return connectBase;
    }

    public static void overrideUploadBase(String overriddenUploadBase) {
        uploadBase = overriddenUploadBase;
    }

    public static String getUploadBase() {
        return uploadBase;
    }

    public static void setConnectionProxy(Proxy proxy) {
        connectionProxy = proxy;
    }

    public static Proxy getConnectionProxy() {
        return connectionProxy;
    }

    public static int getConnectTimeout() {
        if (connectTimeout == -1) {
            return 30000;
        }
        return connectTimeout;
    }

    public static void setConnectTimeout(int timeout) {
        connectTimeout = timeout;
    }

    public static int getReadTimeout() {
        if (readTimeout == -1) {
            return 80000;
        }
        return readTimeout;
    }

    public static void setReadTimeout(int timeout) {
        readTimeout = timeout;
    }

    public static int getMaxNetworkRetries() {
        return maxNetworkRetries;
    }

    public static void setMaxNetworkRetries(int numRetries) {
        maxNetworkRetries = numRetries;
    }

    public static void setProxyCredential(PasswordAuthentication auth) {
        proxyCredential = auth;
    }

    public static PasswordAuthentication getProxyCredential() {
        return proxyCredential;
    }

    public static void setAppInfo(String name) {
        Stripe.setAppInfo(name, null, null, null);
    }

    public static void setAppInfo(String name, String version) {
        Stripe.setAppInfo(name, version, null, null);
    }

    public static void setAppInfo(String name, String version, String url) {
        Stripe.setAppInfo(name, version, url, null);
    }

    public static void setAppInfo(String name, String version, String url, String partnerId) {
        if (appInfo == null) {
            appInfo = new HashMap<String, String>();
        }
        appInfo.put("name", name);
        appInfo.put("version", version);
        appInfo.put("url", url);
        appInfo.put("partner_id", partnerId);
    }

    public static Map<String, String> getAppInfo() {
        return appInfo;
    }

    static {
        enableTelemetry = true;
        connectTimeout = -1;
        readTimeout = -1;
        maxNetworkRetries = 0;
        apiBase = LIVE_API_BASE;
        connectBase = CONNECT_API_BASE;
        uploadBase = UPLOAD_API_BASE;
        connectionProxy = null;
        proxyCredential = null;
        appInfo = null;
    }
}

