/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.ProductCollection;
import com.stripe.model.ProductSearchResult;
import com.stripe.model.TaxCode;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ProductCreateParams;
import com.stripe.param.ProductListParams;
import com.stripe.param.ProductRetrieveParams;
import com.stripe.param.ProductSearchParams;
import com.stripe.param.ProductUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Product
extends ApiResource
implements HasId,
MetadataStore<Product> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="attributes")
    List<String> attributes;
    @SerializedName(value="caption")
    String caption;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deactivate_on")
    List<String> deactivateOn;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="images")
    List<String> images;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="package_dimensions")
    PackageDimensions packageDimensions;
    @SerializedName(value="shippable")
    Boolean shippable;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="tax_code")
    ExpandableField<TaxCode> taxCode;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="unit_label")
    String unitLabel;
    @SerializedName(value="updated")
    Long updated;
    @SerializedName(value="url")
    String url;

    public String getTaxCode() {
        return this.taxCode != null ? this.taxCode.getId() : null;
    }

    public void setTaxCode(String id) {
        this.taxCode = ApiResource.setExpandableFieldId(id, this.taxCode);
    }

    public TaxCode getTaxCodeObject() {
        return this.taxCode != null ? this.taxCode.getExpanded() : null;
    }

    public void setTaxCodeObject(TaxCode expandableObject) {
        this.taxCode = new ExpandableField<TaxCode>(expandableObject.getId(), expandableObject);
    }

    public static ProductSearchResult search(Map<String, Object> params) throws StripeException {
        return Product.search(params, (RequestOptions)null);
    }

    public static ProductSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products/search");
        return ApiResource.requestSearchResult(url, params, ProductSearchResult.class, options);
    }

    public static ProductSearchResult search(ProductSearchParams params) throws StripeException {
        return Product.search(params, (RequestOptions)null);
    }

    public static ProductSearchResult search(ProductSearchParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products/search");
        return ApiResource.requestSearchResult(url, params, ProductSearchResult.class, options);
    }

    public static Product create(Map<String, Object> params) throws StripeException {
        return Product.create(params, (RequestOptions)null);
    }

    public static Product create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Product.class, options);
    }

    public static Product create(ProductCreateParams params) throws StripeException {
        return Product.create(params, (RequestOptions)null);
    }

    public static Product create(ProductCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Product.class, options);
    }

    public static Product retrieve(String id) throws StripeException {
        return Product.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Product retrieve(String id, RequestOptions options) throws StripeException {
        return Product.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Product retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/products/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Product.class, options);
    }

    public static Product retrieve(String id, ProductRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/products/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Product.class, options);
    }

    public Product update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Product update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/products/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Product.class, options);
    }

    public Product update(ProductUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Product update(ProductUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/products/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Product.class, options);
    }

    public static ProductCollection list(Map<String, Object> params) throws StripeException {
        return Product.list(params, (RequestOptions)null);
    }

    public static ProductCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products");
        return ApiResource.requestCollection(url, params, ProductCollection.class, options);
    }

    public static ProductCollection list(ProductListParams params) throws StripeException {
        return Product.list(params, (RequestOptions)null);
    }

    public static ProductCollection list(ProductListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/products");
        return ApiResource.requestCollection(url, params, ProductCollection.class, options);
    }

    public Product delete() throws StripeException {
        return this.delete(null, null);
    }

    public Product delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Product delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Product delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/products/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Product.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public List<String> getDeactivateOn() {
        return this.deactivateOn;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getImages() {
        return this.images;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    @Generated
    public Boolean getShippable() {
        return this.shippable;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUnitLabel() {
        return this.unitLabel;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeactivateOn(List<String> deactivateOn) {
        this.deactivateOn = deactivateOn;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setImages(List<String> images) {
        this.images = images;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    @Generated
    public void setShippable(Boolean shippable) {
        this.shippable = shippable;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUnitLabel(String unitLabel) {
        this.unitLabel = unitLabel;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$shippable = this.getShippable();
        Boolean other$shippable = other.getShippable();
        if (this$shippable == null ? other$shippable != null : !((Object)this$shippable).equals(other$shippable)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        List<String> this$deactivateOn = this.getDeactivateOn();
        List<String> other$deactivateOn = other.getDeactivateOn();
        if (this$deactivateOn == null ? other$deactivateOn != null : !((Object)this$deactivateOn).equals(other$deactivateOn)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$images = this.getImages();
        List<String> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PackageDimensions this$packageDimensions = this.getPackageDimensions();
        PackageDimensions other$packageDimensions = other.getPackageDimensions();
        if (this$packageDimensions == null ? other$packageDimensions != null : !((Object)this$packageDimensions).equals(other$packageDimensions)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$taxCode = this.getTaxCode();
        String other$taxCode = other.getTaxCode();
        if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$unitLabel = this.getUnitLabel();
        String other$unitLabel = other.getUnitLabel();
        if (this$unitLabel == null ? other$unitLabel != null : !this$unitLabel.equals(other$unitLabel)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $shippable = this.getShippable();
        result = result * 59 + ($shippable == null ? 43 : ((Object)$shippable).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        List<String> $deactivateOn = this.getDeactivateOn();
        result = result * 59 + ($deactivateOn == null ? 43 : ((Object)$deactivateOn).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PackageDimensions $packageDimensions = this.getPackageDimensions();
        result = result * 59 + ($packageDimensions == null ? 43 : ((Object)$packageDimensions).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $taxCode = this.getTaxCode();
        result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $unitLabel = this.getUnitLabel();
        result = result * 59 + ($unitLabel == null ? 43 : $unitLabel.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

