/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.Authorization;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.Dispute;
import com.stripe.model.issuing.TransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.TransactionListParams;
import com.stripe.param.issuing.TransactionRetrieveParams;
import com.stripe.param.issuing.TransactionUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Transaction
extends ApiResource
implements MetadataStore<Transaction>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="authorization")
    ExpandableField<Authorization> authorization;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="card")
    ExpandableField<Card> card;
    @SerializedName(value="cardholder")
    ExpandableField<Cardholder> cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="dispute")
    ExpandableField<Dispute> dispute;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="merchant_amount")
    Long merchantAmount;
    @SerializedName(value="merchant_currency")
    String merchantCurrency;
    @SerializedName(value="merchant_data")
    Authorization.MerchantData merchantData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="purchase_details")
    PurchaseDetails purchaseDetails;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="wallet")
    String wallet;

    public String getAuthorization() {
        return this.authorization != null ? this.authorization.getId() : null;
    }

    public void setAuthorization(String id) {
        this.authorization = ApiResource.setExpandableFieldId(id, this.authorization);
    }

    public Authorization getAuthorizationObject() {
        return this.authorization != null ? this.authorization.getExpanded() : null;
    }

    public void setAuthorizationObject(Authorization expandableObject) {
        this.authorization = new ExpandableField<Authorization>(expandableObject.getId(), expandableObject);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCard() {
        return this.card != null ? this.card.getId() : null;
    }

    public void setCard(String id) {
        this.card = ApiResource.setExpandableFieldId(id, this.card);
    }

    public Card getCardObject() {
        return this.card != null ? this.card.getExpanded() : null;
    }

    public void setCardObject(Card expandableObject) {
        this.card = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
    }

    public String getCardholder() {
        return this.cardholder != null ? this.cardholder.getId() : null;
    }

    public void setCardholder(String id) {
        this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
    }

    public Cardholder getCardholderObject() {
        return this.cardholder != null ? this.cardholder.getExpanded() : null;
    }

    public void setCardholderObject(Cardholder expandableObject) {
        this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
    }

    public String getDispute() {
        return this.dispute != null ? this.dispute.getId() : null;
    }

    public void setDispute(String id) {
        this.dispute = ApiResource.setExpandableFieldId(id, this.dispute);
    }

    public Dispute getDisputeObject() {
        return this.dispute != null ? this.dispute.getExpanded() : null;
    }

    public void setDisputeObject(Dispute expandableObject) {
        this.dispute = new ExpandableField<Dispute>(expandableObject.getId(), expandableObject);
    }

    public static TransactionCollection list(Map<String, Object> params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/transactions");
        return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static TransactionCollection list(TransactionListParams params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/transactions");
        return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static Transaction retrieve(String transaction) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, options);
    }

    public static Transaction retrieve(String transaction, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(transaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public static Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(transaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public Transaction update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transaction update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction update(TransactionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Transaction update(TransactionUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getMerchantAmount() {
        return this.merchantAmount;
    }

    @Generated
    public String getMerchantCurrency() {
        return this.merchantCurrency;
    }

    @Generated
    public Authorization.MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PurchaseDetails getPurchaseDetails() {
        return this.purchaseDetails;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getWallet() {
        return this.wallet;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountDetails(AmountDetails amountDetails) {
        this.amountDetails = amountDetails;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMerchantAmount(Long merchantAmount) {
        this.merchantAmount = merchantAmount;
    }

    @Generated
    public void setMerchantCurrency(String merchantCurrency) {
        this.merchantCurrency = merchantCurrency;
    }

    @Generated
    public void setMerchantData(Authorization.MerchantData merchantData) {
        this.merchantData = merchantData;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPurchaseDetails(PurchaseDetails purchaseDetails) {
        this.purchaseDetails = purchaseDetails;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$merchantAmount = this.getMerchantAmount();
        Long other$merchantAmount = other.getMerchantAmount();
        if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
            return false;
        }
        AmountDetails this$amountDetails = this.getAmountDetails();
        AmountDetails other$amountDetails = other.getAmountDetails();
        if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$card = this.getCard();
        String other$card = other.getCard();
        if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
            return false;
        }
        String this$cardholder = this.getCardholder();
        String other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$merchantCurrency = this.getMerchantCurrency();
        String other$merchantCurrency = other.getMerchantCurrency();
        if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) {
            return false;
        }
        Authorization.MerchantData this$merchantData = this.getMerchantData();
        Authorization.MerchantData other$merchantData = other.getMerchantData();
        if (this$merchantData == null ? other$merchantData != null : !((Object)this$merchantData).equals(other$merchantData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PurchaseDetails this$purchaseDetails = this.getPurchaseDetails();
        PurchaseDetails other$purchaseDetails = other.getPurchaseDetails();
        if (this$purchaseDetails == null ? other$purchaseDetails != null : !((Object)this$purchaseDetails).equals(other$purchaseDetails)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$wallet = this.getWallet();
        String other$wallet = other.getWallet();
        return !(this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $merchantAmount = this.getMerchantAmount();
        result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
        AmountDetails $amountDetails = this.getAmountDetails();
        result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : $card.hashCode());
        String $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : $cardholder.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $merchantCurrency = this.getMerchantCurrency();
        result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
        Authorization.MerchantData $merchantData = this.getMerchantData();
        result = result * 59 + ($merchantData == null ? 43 : ((Object)$merchantData).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PurchaseDetails $purchaseDetails = this.getPurchaseDetails();
        result = result * 59 + ($purchaseDetails == null ? 43 : ((Object)$purchaseDetails).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AmountDetails
    extends StripeObject {
        @SerializedName(value="atm_fee")
        Long atmFee;

        @Generated
        public Long getAtmFee() {
            return this.atmFee;
        }

        @Generated
        public void setAtmFee(Long atmFee) {
            this.atmFee = atmFee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountDetails)) {
                return false;
            }
            AmountDetails other = (AmountDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$atmFee = this.getAtmFee();
            Long other$atmFee = other.getAtmFee();
            return !(this$atmFee == null ? other$atmFee != null : !((Object)this$atmFee).equals(other$atmFee));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $atmFee = this.getAtmFee();
            result = result * 59 + ($atmFee == null ? 43 : ((Object)$atmFee).hashCode());
            return result;
        }
    }

    public static class PurchaseDetails
    extends StripeObject {
        @SerializedName(value="flight")
        Flight flight;
        @SerializedName(value="fuel")
        Fuel fuel;
        @SerializedName(value="lodging")
        Lodging lodging;
        @SerializedName(value="receipt")
        List<Receipt> receipt;
        @SerializedName(value="reference")
        String reference;

        @Generated
        public Flight getFlight() {
            return this.flight;
        }

        @Generated
        public Fuel getFuel() {
            return this.fuel;
        }

        @Generated
        public Lodging getLodging() {
            return this.lodging;
        }

        @Generated
        public List<Receipt> getReceipt() {
            return this.receipt;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public void setFlight(Flight flight) {
            this.flight = flight;
        }

        @Generated
        public void setFuel(Fuel fuel) {
            this.fuel = fuel;
        }

        @Generated
        public void setLodging(Lodging lodging) {
            this.lodging = lodging;
        }

        @Generated
        public void setReceipt(List<Receipt> receipt) {
            this.receipt = receipt;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PurchaseDetails)) {
                return false;
            }
            PurchaseDetails other = (PurchaseDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Flight this$flight = this.getFlight();
            Flight other$flight = other.getFlight();
            if (this$flight == null ? other$flight != null : !((Object)this$flight).equals(other$flight)) {
                return false;
            }
            Fuel this$fuel = this.getFuel();
            Fuel other$fuel = other.getFuel();
            if (this$fuel == null ? other$fuel != null : !((Object)this$fuel).equals(other$fuel)) {
                return false;
            }
            Lodging this$lodging = this.getLodging();
            Lodging other$lodging = other.getLodging();
            if (this$lodging == null ? other$lodging != null : !((Object)this$lodging).equals(other$lodging)) {
                return false;
            }
            List<Receipt> this$receipt = this.getReceipt();
            List<Receipt> other$receipt = other.getReceipt();
            if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PurchaseDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Flight $flight = this.getFlight();
            result = result * 59 + ($flight == null ? 43 : ((Object)$flight).hashCode());
            Fuel $fuel = this.getFuel();
            result = result * 59 + ($fuel == null ? 43 : ((Object)$fuel).hashCode());
            Lodging $lodging = this.getLodging();
            result = result * 59 + ($lodging == null ? 43 : ((Object)$lodging).hashCode());
            List<Receipt> $receipt = this.getReceipt();
            result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            return result;
        }

        public static class Flight
        extends StripeObject {
            @SerializedName(value="departure_at")
            Long departureAt;
            @SerializedName(value="passenger_name")
            String passengerName;
            @SerializedName(value="refundable")
            Boolean refundable;
            @SerializedName(value="segments")
            List<Segments> segments;
            @SerializedName(value="travel_agency")
            String travelAgency;

            @Generated
            public Long getDepartureAt() {
                return this.departureAt;
            }

            @Generated
            public String getPassengerName() {
                return this.passengerName;
            }

            @Generated
            public Boolean getRefundable() {
                return this.refundable;
            }

            @Generated
            public List<Segments> getSegments() {
                return this.segments;
            }

            @Generated
            public String getTravelAgency() {
                return this.travelAgency;
            }

            @Generated
            public void setDepartureAt(Long departureAt) {
                this.departureAt = departureAt;
            }

            @Generated
            public void setPassengerName(String passengerName) {
                this.passengerName = passengerName;
            }

            @Generated
            public void setRefundable(Boolean refundable) {
                this.refundable = refundable;
            }

            @Generated
            public void setSegments(List<Segments> segments) {
                this.segments = segments;
            }

            @Generated
            public void setTravelAgency(String travelAgency) {
                this.travelAgency = travelAgency;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Flight)) {
                    return false;
                }
                Flight other = (Flight)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$departureAt = this.getDepartureAt();
                Long other$departureAt = other.getDepartureAt();
                if (this$departureAt == null ? other$departureAt != null : !((Object)this$departureAt).equals(other$departureAt)) {
                    return false;
                }
                Boolean this$refundable = this.getRefundable();
                Boolean other$refundable = other.getRefundable();
                if (this$refundable == null ? other$refundable != null : !((Object)this$refundable).equals(other$refundable)) {
                    return false;
                }
                String this$passengerName = this.getPassengerName();
                String other$passengerName = other.getPassengerName();
                if (this$passengerName == null ? other$passengerName != null : !this$passengerName.equals(other$passengerName)) {
                    return false;
                }
                List<Segments> this$segments = this.getSegments();
                List<Segments> other$segments = other.getSegments();
                if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
                    return false;
                }
                String this$travelAgency = this.getTravelAgency();
                String other$travelAgency = other.getTravelAgency();
                return !(this$travelAgency == null ? other$travelAgency != null : !this$travelAgency.equals(other$travelAgency));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Flight;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $departureAt = this.getDepartureAt();
                result = result * 59 + ($departureAt == null ? 43 : ((Object)$departureAt).hashCode());
                Boolean $refundable = this.getRefundable();
                result = result * 59 + ($refundable == null ? 43 : ((Object)$refundable).hashCode());
                String $passengerName = this.getPassengerName();
                result = result * 59 + ($passengerName == null ? 43 : $passengerName.hashCode());
                List<Segments> $segments = this.getSegments();
                result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
                String $travelAgency = this.getTravelAgency();
                result = result * 59 + ($travelAgency == null ? 43 : $travelAgency.hashCode());
                return result;
            }

            public static class Segments
            extends StripeObject {
                @SerializedName(value="arrival_airport_code")
                String arrivalAirportCode;
                @SerializedName(value="carrier")
                String carrier;
                @SerializedName(value="departure_airport_code")
                String departureAirportCode;
                @SerializedName(value="flight_number")
                String flightNumber;
                @SerializedName(value="service_class")
                String serviceClass;
                @SerializedName(value="stopover_allowed")
                Boolean stopoverAllowed;

                @Generated
                public String getArrivalAirportCode() {
                    return this.arrivalAirportCode;
                }

                @Generated
                public String getCarrier() {
                    return this.carrier;
                }

                @Generated
                public String getDepartureAirportCode() {
                    return this.departureAirportCode;
                }

                @Generated
                public String getFlightNumber() {
                    return this.flightNumber;
                }

                @Generated
                public String getServiceClass() {
                    return this.serviceClass;
                }

                @Generated
                public Boolean getStopoverAllowed() {
                    return this.stopoverAllowed;
                }

                @Generated
                public void setArrivalAirportCode(String arrivalAirportCode) {
                    this.arrivalAirportCode = arrivalAirportCode;
                }

                @Generated
                public void setCarrier(String carrier) {
                    this.carrier = carrier;
                }

                @Generated
                public void setDepartureAirportCode(String departureAirportCode) {
                    this.departureAirportCode = departureAirportCode;
                }

                @Generated
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }

                @Generated
                public void setServiceClass(String serviceClass) {
                    this.serviceClass = serviceClass;
                }

                @Generated
                public void setStopoverAllowed(Boolean stopoverAllowed) {
                    this.stopoverAllowed = stopoverAllowed;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Segments)) {
                        return false;
                    }
                    Segments other = (Segments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$stopoverAllowed = this.getStopoverAllowed();
                    Boolean other$stopoverAllowed = other.getStopoverAllowed();
                    if (this$stopoverAllowed == null ? other$stopoverAllowed != null : !((Object)this$stopoverAllowed).equals(other$stopoverAllowed)) {
                        return false;
                    }
                    String this$arrivalAirportCode = this.getArrivalAirportCode();
                    String other$arrivalAirportCode = other.getArrivalAirportCode();
                    if (this$arrivalAirportCode == null ? other$arrivalAirportCode != null : !this$arrivalAirportCode.equals(other$arrivalAirportCode)) {
                        return false;
                    }
                    String this$carrier = this.getCarrier();
                    String other$carrier = other.getCarrier();
                    if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
                        return false;
                    }
                    String this$departureAirportCode = this.getDepartureAirportCode();
                    String other$departureAirportCode = other.getDepartureAirportCode();
                    if (this$departureAirportCode == null ? other$departureAirportCode != null : !this$departureAirportCode.equals(other$departureAirportCode)) {
                        return false;
                    }
                    String this$flightNumber = this.getFlightNumber();
                    String other$flightNumber = other.getFlightNumber();
                    if (this$flightNumber == null ? other$flightNumber != null : !this$flightNumber.equals(other$flightNumber)) {
                        return false;
                    }
                    String this$serviceClass = this.getServiceClass();
                    String other$serviceClass = other.getServiceClass();
                    return !(this$serviceClass == null ? other$serviceClass != null : !this$serviceClass.equals(other$serviceClass));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Segments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $stopoverAllowed = this.getStopoverAllowed();
                    result = result * 59 + ($stopoverAllowed == null ? 43 : ((Object)$stopoverAllowed).hashCode());
                    String $arrivalAirportCode = this.getArrivalAirportCode();
                    result = result * 59 + ($arrivalAirportCode == null ? 43 : $arrivalAirportCode.hashCode());
                    String $carrier = this.getCarrier();
                    result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
                    String $departureAirportCode = this.getDepartureAirportCode();
                    result = result * 59 + ($departureAirportCode == null ? 43 : $departureAirportCode.hashCode());
                    String $flightNumber = this.getFlightNumber();
                    result = result * 59 + ($flightNumber == null ? 43 : $flightNumber.hashCode());
                    String $serviceClass = this.getServiceClass();
                    result = result * 59 + ($serviceClass == null ? 43 : $serviceClass.hashCode());
                    return result;
                }
            }
        }

        public static class Fuel
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="unit")
            String unit;
            @SerializedName(value="unit_cost_decimal")
            BigDecimal unitCostDecimal;
            @SerializedName(value="volume_decimal")
            BigDecimal volumeDecimal;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getUnit() {
                return this.unit;
            }

            @Generated
            public BigDecimal getUnitCostDecimal() {
                return this.unitCostDecimal;
            }

            @Generated
            public BigDecimal getVolumeDecimal() {
                return this.volumeDecimal;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setUnit(String unit) {
                this.unit = unit;
            }

            @Generated
            public void setUnitCostDecimal(BigDecimal unitCostDecimal) {
                this.unitCostDecimal = unitCostDecimal;
            }

            @Generated
            public void setVolumeDecimal(BigDecimal volumeDecimal) {
                this.volumeDecimal = volumeDecimal;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fuel)) {
                    return false;
                }
                Fuel other = (Fuel)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$unit = this.getUnit();
                String other$unit = other.getUnit();
                if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                    return false;
                }
                BigDecimal this$unitCostDecimal = this.getUnitCostDecimal();
                BigDecimal other$unitCostDecimal = other.getUnitCostDecimal();
                if (this$unitCostDecimal == null ? other$unitCostDecimal != null : !((Object)this$unitCostDecimal).equals(other$unitCostDecimal)) {
                    return false;
                }
                BigDecimal this$volumeDecimal = this.getVolumeDecimal();
                BigDecimal other$volumeDecimal = other.getVolumeDecimal();
                return !(this$volumeDecimal == null ? other$volumeDecimal != null : !((Object)this$volumeDecimal).equals(other$volumeDecimal));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fuel;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $unit = this.getUnit();
                result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                BigDecimal $unitCostDecimal = this.getUnitCostDecimal();
                result = result * 59 + ($unitCostDecimal == null ? 43 : ((Object)$unitCostDecimal).hashCode());
                BigDecimal $volumeDecimal = this.getVolumeDecimal();
                result = result * 59 + ($volumeDecimal == null ? 43 : ((Object)$volumeDecimal).hashCode());
                return result;
            }
        }

        public static class Lodging
        extends StripeObject {
            @SerializedName(value="check_in_at")
            Long checkInAt;
            @SerializedName(value="nights")
            Long nights;

            @Generated
            public Long getCheckInAt() {
                return this.checkInAt;
            }

            @Generated
            public Long getNights() {
                return this.nights;
            }

            @Generated
            public void setCheckInAt(Long checkInAt) {
                this.checkInAt = checkInAt;
            }

            @Generated
            public void setNights(Long nights) {
                this.nights = nights;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lodging)) {
                    return false;
                }
                Lodging other = (Lodging)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$checkInAt = this.getCheckInAt();
                Long other$checkInAt = other.getCheckInAt();
                if (this$checkInAt == null ? other$checkInAt != null : !((Object)this$checkInAt).equals(other$checkInAt)) {
                    return false;
                }
                Long this$nights = this.getNights();
                Long other$nights = other.getNights();
                return !(this$nights == null ? other$nights != null : !((Object)this$nights).equals(other$nights));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lodging;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $checkInAt = this.getCheckInAt();
                result = result * 59 + ($checkInAt == null ? 43 : ((Object)$checkInAt).hashCode());
                Long $nights = this.getNights();
                result = result * 59 + ($nights == null ? 43 : ((Object)$nights).hashCode());
                return result;
            }
        }

        public static class Receipt
        extends StripeObject {
            @SerializedName(value="description")
            String description;
            @SerializedName(value="quantity")
            BigDecimal quantity;
            @SerializedName(value="total")
            Long total;
            @SerializedName(value="unit_cost")
            Long unitCost;

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public BigDecimal getQuantity() {
                return this.quantity;
            }

            @Generated
            public Long getTotal() {
                return this.total;
            }

            @Generated
            public Long getUnitCost() {
                return this.unitCost;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setQuantity(BigDecimal quantity) {
                this.quantity = quantity;
            }

            @Generated
            public void setTotal(Long total) {
                this.total = total;
            }

            @Generated
            public void setUnitCost(Long unitCost) {
                this.unitCost = unitCost;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Receipt)) {
                    return false;
                }
                Receipt other = (Receipt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$total = this.getTotal();
                Long other$total = other.getTotal();
                if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                    return false;
                }
                Long this$unitCost = this.getUnitCost();
                Long other$unitCost = other.getUnitCost();
                if (this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                BigDecimal this$quantity = this.getQuantity();
                BigDecimal other$quantity = other.getQuantity();
                return !(this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Receipt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $total = this.getTotal();
                result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
                Long $unitCost = this.getUnitCost();
                result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                BigDecimal $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                return result;
            }
        }
    }
}

