// Generated by delombok at Fri May 20 00:30:20 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PriceCreateParams;
import com.stripe.param.PriceListParams;
import com.stripe.param.PriceRetrieveParams;
import com.stripe.param.PriceSearchParams;
import com.stripe.param.PriceUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class Price extends ApiResource implements HasId, MetadataStore<Price> {
  /**
   * Whether the price can be used for new purchases.
   */
  @SerializedName("active")
  Boolean active;
  /**
   * Describes how to compute the price per period. Either {@code per_unit} or {@code tiered}.
   * {@code per_unit} indicates that the fixed amount (specified in {@code unit_amount} or {@code
   * unit_amount_decimal}) will be charged per unit in {@code quantity} (for prices with {@code
   * usage_type=licensed}), or per unit of total usage (for prices with {@code usage_type=metered}).
   * {@code tiered} indicates that the unit pricing will be computed using a tiering strategy as
   * defined using the {@code tiers} and {@code tiers_mode} attributes.
   *
   * <p>One of {@code per_unit}, or {@code tiered}.
   */
  @SerializedName("billing_scheme")
  String billingScheme;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * A lookup key used to retrieve prices dynamically from a static string. This may be up to 200
   * characters.
   */
  @SerializedName("lookup_key")
  String lookupKey;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * A brief description of the price, hidden from customers.
   */
  @SerializedName("nickname")
  String nickname;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code price}.
   */
  @SerializedName("object")
  String object;
  /**
   * The ID of the product this price is associated with.
   */
  @SerializedName("product")
  ExpandableField<Product> product;
  /**
   * The recurring components of a price such as {@code interval} and {@code usage_type}.
   */
  @SerializedName("recurring")
  Recurring recurring;
  /**
   * Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}. Once specified as either {@code
   * inclusive} or {@code exclusive}, it cannot be changed.
   */
  @SerializedName("tax_behavior")
  String taxBehavior;
  /**
   * Each element represents a pricing tier. This parameter requires {@code billing_scheme} to be
   * set to {@code tiered}. See also the documentation for {@code billing_scheme}.
   */
  @SerializedName("tiers")
  List<Price.Tier> tiers;
  /**
   * Defines if the tiering price should be {@code graduated} or {@code volume} based. In {@code
   * volume}-based tiering, the maximum quantity within a period determines the per unit price. In
   * {@code graduated} tiering, pricing can change as the quantity grows.
   *
   * <p>One of {@code graduated}, or {@code volume}.
   */
  @SerializedName("tiers_mode")
  String tiersMode;
  /**
   * Apply a transformation to the reported usage or set quantity before computing the amount
   * billed. Cannot be combined with {@code tiers}.
   */
  @SerializedName("transform_quantity")
  TransformQuantity transformQuantity;
  /**
   * One of {@code one_time} or {@code recurring} depending on whether the price is for a one-time
   * purchase or a recurring (subscription) purchase.
   */
  @SerializedName("type")
  String type;
  /**
   * The unit amount in %s to be charged, represented as a whole integer if possible. Only set if
   * {@code billing_scheme=per_unit}.
   */
  @SerializedName("unit_amount")
  Long unitAmount;
  /**
   * The unit amount in %s to be charged, represented as a decimal string with at most 12 decimal
   * places. Only set if {@code billing_scheme=per_unit}.
   */
  @SerializedName("unit_amount_decimal")
  BigDecimal unitAmountDecimal;

  /**
   * Get ID of expandable {@code product} object.
   */
  public String getProduct() {
    return (this.product != null) ? this.product.getId() : null;
  }

  public void setProduct(String id) {
    this.product = ApiResource.setExpandableFieldId(id, this.product);
  }

  /**
   * Get expanded {@code product}.
   */
  public Product getProductObject() {
    return (this.product != null) ? this.product.getExpanded() : null;
  }

  public void setProductObject(Product expandableObject) {
    this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
  }

  /**
   * Search for prices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PriceSearchResult search(Map<String, Object> params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for prices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PriceSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices/search");
    return ApiResource.requestSearchResult(url, params, PriceSearchResult.class, options);
  }

  /**
   * Search for prices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PriceSearchResult search(PriceSearchParams params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for prices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PriceSearchResult search(PriceSearchParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices/search");
    return ApiResource.requestSearchResult(url, params, PriceSearchResult.class, options);
  }

  /**
   * Returns a list of your prices.
   */
  public static PriceCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your prices.
   */
  public static PriceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices");
    return ApiResource.requestCollection(url, params, PriceCollection.class, options);
  }

  /**
   * Returns a list of your prices.
   */
  public static PriceCollection list(PriceListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your prices.
   */
  public static PriceCollection list(PriceListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices");
    return ApiResource.requestCollection(url, params, PriceCollection.class, options);
  }

  /**
   * Creates a new price for an existing product. The price can be recurring or one-time.
   */
  public static Price create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new price for an existing product. The price can be recurring or one-time.
   */
  public static Price create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Price.class, options);
  }

  /**
   * Creates a new price for an existing product. The price can be recurring or one-time.
   */
  public static Price create(PriceCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new price for an existing product. The price can be recurring or one-time.
   */
  public static Price create(PriceCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/prices");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Price.class, options);
  }

  /**
   * Retrieves the price with the given ID.
   */
  public static Price retrieve(String price) throws StripeException {
    return retrieve(price, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the price with the given ID.
   */
  public static Price retrieve(String price, RequestOptions options) throws StripeException {
    return retrieve(price, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the price with the given ID.
   */
  public static Price retrieve(String price, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/prices/%s", ApiResource.urlEncodeId(price)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Price.class, options);
  }

  /**
   * Retrieves the price with the given ID.
   */
  public static Price retrieve(String price, PriceRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/prices/%s", ApiResource.urlEncodeId(price)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Price.class, options);
  }

  /**
   * Updates the specified price by setting the values of the parameters passed. Any parameters not
   * provided are left unchanged.
   */
  @Override
  public Price update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified price by setting the values of the parameters passed. Any parameters not
   * provided are left unchanged.
   */
  @Override
  public Price update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/prices/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Price.class, options);
  }

  /**
   * Updates the specified price by setting the values of the parameters passed. Any parameters not
   * provided are left unchanged.
   */
  public Price update(PriceUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified price by setting the values of the parameters passed. Any parameters not
   * provided are left unchanged.
   */
  public Price update(PriceUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/prices/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Price.class, options);
  }


  public static class Recurring extends StripeObject {
    /**
     * Specifies a usage aggregation strategy for prices of {@code usage_type=metered}. Allowed
     * values are {@code sum} for summing up all usage during a period, {@code last_during_period}
     * for using the last usage record reported within a period, {@code last_ever} for using the
     * last usage record ever (across period bounds) or {@code max} which uses the usage record with
     * the maximum reported usage during a period. Defaults to {@code sum}.
     *
     * <p>One of {@code last_during_period}, {@code last_ever}, {@code max}, or {@code sum}.
     */
    @SerializedName("aggregate_usage")
    String aggregateUsage;
    /**
     * The frequency at which a subscription is billed. One of {@code day}, {@code week}, {@code
     * month} or {@code year}.
     */
    @SerializedName("interval")
    String interval;
    /**
     * The number of intervals (specified in the {@code interval} attribute) between subscription
     * billings. For example, {@code interval=month} and {@code interval_count=3} bills every 3
     * months.
     */
    @SerializedName("interval_count")
    Long intervalCount;
    /**
     * Default number of trial days when subscribing a customer to this price using <a
     * href="https://stripe.com/docs/api#create_subscription-trial_from_plan">{@code
     * trial_from_plan=true}</a>.
     */
    @SerializedName("trial_period_days")
    Long trialPeriodDays;
    /**
     * Configures how the quantity per period should be determined. Can be either {@code metered} or
     * {@code licensed}. {@code licensed} automatically bills the {@code quantity} set when adding
     * it to a subscription. {@code metered} aggregates the total usage based on usage records.
     * Defaults to {@code licensed}.
     */
    @SerializedName("usage_type")
    String usageType;

    /**
     * Specifies a usage aggregation strategy for prices of {@code usage_type=metered}. Allowed
     * values are {@code sum} for summing up all usage during a period, {@code last_during_period}
     * for using the last usage record reported within a period, {@code last_ever} for using the
     * last usage record ever (across period bounds) or {@code max} which uses the usage record with
     * the maximum reported usage during a period. Defaults to {@code sum}.
     *
     * <p>One of {@code last_during_period}, {@code last_ever}, {@code max}, or {@code sum}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAggregateUsage() {
      return this.aggregateUsage;
    }

    /**
     * The frequency at which a subscription is billed. One of {@code day}, {@code week}, {@code
     * month} or {@code year}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInterval() {
      return this.interval;
    }

    /**
     * The number of intervals (specified in the {@code interval} attribute) between subscription
     * billings. For example, {@code interval=month} and {@code interval_count=3} bills every 3
     * months.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getIntervalCount() {
      return this.intervalCount;
    }

    /**
     * Default number of trial days when subscribing a customer to this price using <a
     * href="https://stripe.com/docs/api#create_subscription-trial_from_plan">{@code
     * trial_from_plan=true}</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTrialPeriodDays() {
      return this.trialPeriodDays;
    }

    /**
     * Configures how the quantity per period should be determined. Can be either {@code metered} or
     * {@code licensed}. {@code licensed} automatically bills the {@code quantity} set when adding
     * it to a subscription. {@code metered} aggregates the total usage based on usage records.
     * Defaults to {@code licensed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsageType() {
      return this.usageType;
    }

    /**
     * Specifies a usage aggregation strategy for prices of {@code usage_type=metered}. Allowed
     * values are {@code sum} for summing up all usage during a period, {@code last_during_period}
     * for using the last usage record reported within a period, {@code last_ever} for using the
     * last usage record ever (across period bounds) or {@code max} which uses the usage record with
     * the maximum reported usage during a period. Defaults to {@code sum}.
     *
     * <p>One of {@code last_during_period}, {@code last_ever}, {@code max}, or {@code sum}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAggregateUsage(final String aggregateUsage) {
      this.aggregateUsage = aggregateUsage;
    }

    /**
     * The frequency at which a subscription is billed. One of {@code day}, {@code week}, {@code
     * month} or {@code year}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInterval(final String interval) {
      this.interval = interval;
    }

    /**
     * The number of intervals (specified in the {@code interval} attribute) between subscription
     * billings. For example, {@code interval=month} and {@code interval_count=3} bills every 3
     * months.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIntervalCount(final Long intervalCount) {
      this.intervalCount = intervalCount;
    }

    /**
     * Default number of trial days when subscribing a customer to this price using <a
     * href="https://stripe.com/docs/api#create_subscription-trial_from_plan">{@code
     * trial_from_plan=true}</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialPeriodDays(final Long trialPeriodDays) {
      this.trialPeriodDays = trialPeriodDays;
    }

    /**
     * Configures how the quantity per period should be determined. Can be either {@code metered} or
     * {@code licensed}. {@code licensed} automatically bills the {@code quantity} set when adding
     * it to a subscription. {@code metered} aggregates the total usage based on usage records.
     * Defaults to {@code licensed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsageType(final String usageType) {
      this.usageType = usageType;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Price.Recurring)) return false;
      final Price.Recurring other = (Price.Recurring) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$intervalCount = this.getIntervalCount();
      final java.lang.Object other$intervalCount = other.getIntervalCount();
      if (this$intervalCount == null ? other$intervalCount != null : !this$intervalCount.equals(other$intervalCount)) return false;
      final java.lang.Object this$trialPeriodDays = this.getTrialPeriodDays();
      final java.lang.Object other$trialPeriodDays = other.getTrialPeriodDays();
      if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !this$trialPeriodDays.equals(other$trialPeriodDays)) return false;
      final java.lang.Object this$aggregateUsage = this.getAggregateUsage();
      final java.lang.Object other$aggregateUsage = other.getAggregateUsage();
      if (this$aggregateUsage == null ? other$aggregateUsage != null : !this$aggregateUsage.equals(other$aggregateUsage)) return false;
      final java.lang.Object this$interval = this.getInterval();
      final java.lang.Object other$interval = other.getInterval();
      if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
      final java.lang.Object this$usageType = this.getUsageType();
      final java.lang.Object other$usageType = other.getUsageType();
      if (this$usageType == null ? other$usageType != null : !this$usageType.equals(other$usageType)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Price.Recurring;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $intervalCount = this.getIntervalCount();
      result = result * PRIME + ($intervalCount == null ? 43 : $intervalCount.hashCode());
      final java.lang.Object $trialPeriodDays = this.getTrialPeriodDays();
      result = result * PRIME + ($trialPeriodDays == null ? 43 : $trialPeriodDays.hashCode());
      final java.lang.Object $aggregateUsage = this.getAggregateUsage();
      result = result * PRIME + ($aggregateUsage == null ? 43 : $aggregateUsage.hashCode());
      final java.lang.Object $interval = this.getInterval();
      result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
      final java.lang.Object $usageType = this.getUsageType();
      result = result * PRIME + ($usageType == null ? 43 : $usageType.hashCode());
      return result;
    }
  }


  public static class Tier extends StripeObject {
    /**
     * Price for the entire tier.
     */
    @SerializedName("flat_amount")
    Long flatAmount;
    /**
     * Same as {@code flat_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @SerializedName("flat_amount_decimal")
    BigDecimal flatAmountDecimal;
    /**
     * Per unit price for units relevant to the tier.
     */
    @SerializedName("unit_amount")
    Long unitAmount;
    /**
     * Same as {@code unit_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @SerializedName("unit_amount_decimal")
    BigDecimal unitAmountDecimal;
    /**
     * Up to and including to this quantity will be contained in the tier.
     */
    @SerializedName("up_to")
    Long upTo;

    /**
     * Price for the entire tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFlatAmount() {
      return this.flatAmount;
    }

    /**
     * Same as {@code flat_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getFlatAmountDecimal() {
      return this.flatAmountDecimal;
    }

    /**
     * Per unit price for units relevant to the tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUnitAmount() {
      return this.unitAmount;
    }

    /**
     * Same as {@code unit_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getUnitAmountDecimal() {
      return this.unitAmountDecimal;
    }

    /**
     * Up to and including to this quantity will be contained in the tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpTo() {
      return this.upTo;
    }

    /**
     * Price for the entire tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFlatAmount(final Long flatAmount) {
      this.flatAmount = flatAmount;
    }

    /**
     * Same as {@code flat_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFlatAmountDecimal(final BigDecimal flatAmountDecimal) {
      this.flatAmountDecimal = flatAmountDecimal;
    }

    /**
     * Per unit price for units relevant to the tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUnitAmount(final Long unitAmount) {
      this.unitAmount = unitAmount;
    }

    /**
     * Same as {@code unit_amount}, but contains a decimal value with at most 12 decimal places.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUnitAmountDecimal(final BigDecimal unitAmountDecimal) {
      this.unitAmountDecimal = unitAmountDecimal;
    }

    /**
     * Up to and including to this quantity will be contained in the tier.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUpTo(final Long upTo) {
      this.upTo = upTo;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Price.Tier)) return false;
      final Price.Tier other = (Price.Tier) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$flatAmount = this.getFlatAmount();
      final java.lang.Object other$flatAmount = other.getFlatAmount();
      if (this$flatAmount == null ? other$flatAmount != null : !this$flatAmount.equals(other$flatAmount)) return false;
      final java.lang.Object this$unitAmount = this.getUnitAmount();
      final java.lang.Object other$unitAmount = other.getUnitAmount();
      if (this$unitAmount == null ? other$unitAmount != null : !this$unitAmount.equals(other$unitAmount)) return false;
      final java.lang.Object this$upTo = this.getUpTo();
      final java.lang.Object other$upTo = other.getUpTo();
      if (this$upTo == null ? other$upTo != null : !this$upTo.equals(other$upTo)) return false;
      final java.lang.Object this$flatAmountDecimal = this.getFlatAmountDecimal();
      final java.lang.Object other$flatAmountDecimal = other.getFlatAmountDecimal();
      if (this$flatAmountDecimal == null ? other$flatAmountDecimal != null : !this$flatAmountDecimal.equals(other$flatAmountDecimal)) return false;
      final java.lang.Object this$unitAmountDecimal = this.getUnitAmountDecimal();
      final java.lang.Object other$unitAmountDecimal = other.getUnitAmountDecimal();
      if (this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !this$unitAmountDecimal.equals(other$unitAmountDecimal)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Price.Tier;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $flatAmount = this.getFlatAmount();
      result = result * PRIME + ($flatAmount == null ? 43 : $flatAmount.hashCode());
      final java.lang.Object $unitAmount = this.getUnitAmount();
      result = result * PRIME + ($unitAmount == null ? 43 : $unitAmount.hashCode());
      final java.lang.Object $upTo = this.getUpTo();
      result = result * PRIME + ($upTo == null ? 43 : $upTo.hashCode());
      final java.lang.Object $flatAmountDecimal = this.getFlatAmountDecimal();
      result = result * PRIME + ($flatAmountDecimal == null ? 43 : $flatAmountDecimal.hashCode());
      final java.lang.Object $unitAmountDecimal = this.getUnitAmountDecimal();
      result = result * PRIME + ($unitAmountDecimal == null ? 43 : $unitAmountDecimal.hashCode());
      return result;
    }
  }


  public static class TransformQuantity extends StripeObject {
    /** Divide usage by this number. */
    @SerializedName("divide_by")
    Long divideBy;
    /**
     * After division, either round the result {@code up} or {@code down}.
     *
     * <p>One of {@code down}, or {@code up}.
     */
    @SerializedName("round")
    String round;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDivideBy() {
      return this.divideBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRound() {
      return this.round;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDivideBy(final Long divideBy) {
      this.divideBy = divideBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRound(final String round) {
      this.round = round;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Price.TransformQuantity)) return false;
      final Price.TransformQuantity other = (Price.TransformQuantity) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$divideBy = this.getDivideBy();
      final java.lang.Object other$divideBy = other.getDivideBy();
      if (this$divideBy == null ? other$divideBy != null : !this$divideBy.equals(other$divideBy)) return false;
      final java.lang.Object this$round = this.getRound();
      final java.lang.Object other$round = other.getRound();
      if (this$round == null ? other$round != null : !this$round.equals(other$round)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Price.TransformQuantity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $divideBy = this.getDivideBy();
      result = result * PRIME + ($divideBy == null ? 43 : $divideBy.hashCode());
      final java.lang.Object $round = this.getRound();
      result = result * PRIME + ($round == null ? 43 : $round.hashCode());
      return result;
    }
  }

  /**
   * Whether the price can be used for new purchases.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  /**
   * Describes how to compute the price per period. Either {@code per_unit} or {@code tiered}.
   * {@code per_unit} indicates that the fixed amount (specified in {@code unit_amount} or {@code
   * unit_amount_decimal}) will be charged per unit in {@code quantity} (for prices with {@code
   * usage_type=licensed}), or per unit of total usage (for prices with {@code usage_type=metered}).
   * {@code tiered} indicates that the unit pricing will be computed using a tiering strategy as
   * defined using the {@code tiers} and {@code tiers_mode} attributes.
   *
   * <p>One of {@code per_unit}, or {@code tiered}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingScheme() {
    return this.billingScheme;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * A lookup key used to retrieve prices dynamically from a static string. This may be up to 200
   * characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLookupKey() {
    return this.lookupKey;
  }

  /**
   * A brief description of the price, hidden from customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNickname() {
    return this.nickname;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code price}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The recurring components of a price such as {@code interval} and {@code usage_type}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Recurring getRecurring() {
    return this.recurring;
  }

  /**
   * Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}. Once specified as either {@code
   * inclusive} or {@code exclusive}, it cannot be changed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTaxBehavior() {
    return this.taxBehavior;
  }

  /**
   * Each element represents a pricing tier. This parameter requires {@code billing_scheme} to be
   * set to {@code tiered}. See also the documentation for {@code billing_scheme}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Price.Tier> getTiers() {
    return this.tiers;
  }

  /**
   * Defines if the tiering price should be {@code graduated} or {@code volume} based. In {@code
   * volume}-based tiering, the maximum quantity within a period determines the per unit price. In
   * {@code graduated} tiering, pricing can change as the quantity grows.
   *
   * <p>One of {@code graduated}, or {@code volume}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTiersMode() {
    return this.tiersMode;
  }

  /**
   * Apply a transformation to the reported usage or set quantity before computing the amount
   * billed. Cannot be combined with {@code tiers}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransformQuantity getTransformQuantity() {
    return this.transformQuantity;
  }

  /**
   * One of {@code one_time} or {@code recurring} depending on whether the price is for a one-time
   * purchase or a recurring (subscription) purchase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The unit amount in %s to be charged, represented as a whole integer if possible. Only set if
   * {@code billing_scheme=per_unit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUnitAmount() {
    return this.unitAmount;
  }

  /**
   * The unit amount in %s to be charged, represented as a decimal string with at most 12 decimal
   * places. Only set if {@code billing_scheme=per_unit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getUnitAmountDecimal() {
    return this.unitAmountDecimal;
  }

  /**
   * Whether the price can be used for new purchases.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  /**
   * Describes how to compute the price per period. Either {@code per_unit} or {@code tiered}.
   * {@code per_unit} indicates that the fixed amount (specified in {@code unit_amount} or {@code
   * unit_amount_decimal}) will be charged per unit in {@code quantity} (for prices with {@code
   * usage_type=licensed}), or per unit of total usage (for prices with {@code usage_type=metered}).
   * {@code tiered} indicates that the unit pricing will be computed using a tiering strategy as
   * defined using the {@code tiers} and {@code tiers_mode} attributes.
   *
   * <p>One of {@code per_unit}, or {@code tiered}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingScheme(final String billingScheme) {
    this.billingScheme = billingScheme;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * A lookup key used to retrieve prices dynamically from a static string. This may be up to 200
   * characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLookupKey(final String lookupKey) {
    this.lookupKey = lookupKey;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * A brief description of the price, hidden from customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNickname(final String nickname) {
    this.nickname = nickname;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code price}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The recurring components of a price such as {@code interval} and {@code usage_type}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRecurring(final Recurring recurring) {
    this.recurring = recurring;
  }

  /**
   * Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of
   * {@code inclusive}, {@code exclusive}, or {@code unspecified}. Once specified as either {@code
   * inclusive} or {@code exclusive}, it cannot be changed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxBehavior(final String taxBehavior) {
    this.taxBehavior = taxBehavior;
  }

  /**
   * Each element represents a pricing tier. This parameter requires {@code billing_scheme} to be
   * set to {@code tiered}. See also the documentation for {@code billing_scheme}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTiers(final List<Price.Tier> tiers) {
    this.tiers = tiers;
  }

  /**
   * Defines if the tiering price should be {@code graduated} or {@code volume} based. In {@code
   * volume}-based tiering, the maximum quantity within a period determines the per unit price. In
   * {@code graduated} tiering, pricing can change as the quantity grows.
   *
   * <p>One of {@code graduated}, or {@code volume}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTiersMode(final String tiersMode) {
    this.tiersMode = tiersMode;
  }

  /**
   * Apply a transformation to the reported usage or set quantity before computing the amount
   * billed. Cannot be combined with {@code tiers}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransformQuantity(final TransformQuantity transformQuantity) {
    this.transformQuantity = transformQuantity;
  }

  /**
   * One of {@code one_time} or {@code recurring} depending on whether the price is for a one-time
   * purchase or a recurring (subscription) purchase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * The unit amount in %s to be charged, represented as a whole integer if possible. Only set if
   * {@code billing_scheme=per_unit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnitAmount(final Long unitAmount) {
    this.unitAmount = unitAmount;
  }

  /**
   * The unit amount in %s to be charged, represented as a decimal string with at most 12 decimal
   * places. Only set if {@code billing_scheme=per_unit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnitAmountDecimal(final BigDecimal unitAmountDecimal) {
    this.unitAmountDecimal = unitAmountDecimal;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Price)) return false;
    final Price other = (Price) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$unitAmount = this.getUnitAmount();
    final java.lang.Object other$unitAmount = other.getUnitAmount();
    if (this$unitAmount == null ? other$unitAmount != null : !this$unitAmount.equals(other$unitAmount)) return false;
    final java.lang.Object this$billingScheme = this.getBillingScheme();
    final java.lang.Object other$billingScheme = other.getBillingScheme();
    if (this$billingScheme == null ? other$billingScheme != null : !this$billingScheme.equals(other$billingScheme)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lookupKey = this.getLookupKey();
    final java.lang.Object other$lookupKey = other.getLookupKey();
    if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nickname = this.getNickname();
    final java.lang.Object other$nickname = other.getNickname();
    if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$product = this.getProduct();
    final java.lang.Object other$product = other.getProduct();
    if (this$product == null ? other$product != null : !this$product.equals(other$product)) return false;
    final java.lang.Object this$recurring = this.getRecurring();
    final java.lang.Object other$recurring = other.getRecurring();
    if (this$recurring == null ? other$recurring != null : !this$recurring.equals(other$recurring)) return false;
    final java.lang.Object this$taxBehavior = this.getTaxBehavior();
    final java.lang.Object other$taxBehavior = other.getTaxBehavior();
    if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) return false;
    final java.lang.Object this$tiers = this.getTiers();
    final java.lang.Object other$tiers = other.getTiers();
    if (this$tiers == null ? other$tiers != null : !this$tiers.equals(other$tiers)) return false;
    final java.lang.Object this$tiersMode = this.getTiersMode();
    final java.lang.Object other$tiersMode = other.getTiersMode();
    if (this$tiersMode == null ? other$tiersMode != null : !this$tiersMode.equals(other$tiersMode)) return false;
    final java.lang.Object this$transformQuantity = this.getTransformQuantity();
    final java.lang.Object other$transformQuantity = other.getTransformQuantity();
    if (this$transformQuantity == null ? other$transformQuantity != null : !this$transformQuantity.equals(other$transformQuantity)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$unitAmountDecimal = this.getUnitAmountDecimal();
    final java.lang.Object other$unitAmountDecimal = other.getUnitAmountDecimal();
    if (this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !this$unitAmountDecimal.equals(other$unitAmountDecimal)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Price;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $unitAmount = this.getUnitAmount();
    result = result * PRIME + ($unitAmount == null ? 43 : $unitAmount.hashCode());
    final java.lang.Object $billingScheme = this.getBillingScheme();
    result = result * PRIME + ($billingScheme == null ? 43 : $billingScheme.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lookupKey = this.getLookupKey();
    result = result * PRIME + ($lookupKey == null ? 43 : $lookupKey.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nickname = this.getNickname();
    result = result * PRIME + ($nickname == null ? 43 : $nickname.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $product = this.getProduct();
    result = result * PRIME + ($product == null ? 43 : $product.hashCode());
    final java.lang.Object $recurring = this.getRecurring();
    result = result * PRIME + ($recurring == null ? 43 : $recurring.hashCode());
    final java.lang.Object $taxBehavior = this.getTaxBehavior();
    result = result * PRIME + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
    final java.lang.Object $tiers = this.getTiers();
    result = result * PRIME + ($tiers == null ? 43 : $tiers.hashCode());
    final java.lang.Object $tiersMode = this.getTiersMode();
    result = result * PRIME + ($tiersMode == null ? 43 : $tiersMode.hashCode());
    final java.lang.Object $transformQuantity = this.getTransformQuantity();
    result = result * PRIME + ($transformQuantity == null ? 43 : $transformQuantity.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $unitAmountDecimal = this.getUnitAmountDecimal();
    result = result * PRIME + ($unitAmountDecimal == null ? 43 : $unitAmountDecimal.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
