// Generated by delombok at Fri May 20 00:30:20 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SetupIntentCancelParams;
import com.stripe.param.SetupIntentConfirmParams;
import com.stripe.param.SetupIntentCreateParams;
import com.stripe.param.SetupIntentListParams;
import com.stripe.param.SetupIntentRetrieveParams;
import com.stripe.param.SetupIntentUpdateParams;
import com.stripe.param.SetupIntentVerifyMicrodepositsParams;
import java.util.List;
import java.util.Map;

public class SetupIntent extends ApiResource implements HasId, MetadataStore<SetupIntent> {
  /**
   * ID of the Connect application that created the SetupIntent.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * If present, the SetupIntent's payment method will be attached to the in-context Stripe Account.
   *
   * <p>It can only be used for this Stripe Account’s own money movement flows like InboundTransfer
   * and OutboundTransfers. It cannot be set to true when setting up a PaymentMethod for a Customer,
   * and defaults to false when attaching a PaymentMethod to a Customer.
   */
  @SerializedName("attach_to_self")
  Boolean attachToSelf;
  /**
   * Reason for cancellation of this SetupIntent, one of {@code abandoned}, {@code
   * requested_by_customer}, or {@code duplicate}.
   */
  @SerializedName("cancellation_reason")
  String cancellationReason;
  /**
   * The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete payment setup from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   */
  @SerializedName("client_secret")
  String clientSecret;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * ID of the Customer this SetupIntent belongs to, if one exists.
   *
   * <p>If present, the SetupIntent's payment method will be attached to the Customer on successful
   * setup. Payment methods attached to other Customers cannot be used with this SetupIntent.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Indicates the directions of money movement for which this payment method is intended to be
   * used.
   *
   * <p>Include {@code inbound} if you intend to use the payment method as the origin to pull funds
   * from. Include {@code outbound} if you intend to use the payment method as the destination to
   * send funds to. You can include both if you intend to use the payment method for both purposes.
   */
  @SerializedName("flow_directions")
  List<String> flowDirections;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The error encountered in the previous SetupIntent confirmation.
   */
  @SerializedName("last_setup_error")
  StripeError lastSetupError;
  /**
   * The most recent SetupAttempt for this SetupIntent.
   */
  @SerializedName("latest_attempt")
  ExpandableField<SetupAttempt> latestAttempt;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * ID of the multi use Mandate generated by the SetupIntent.
   */
  @SerializedName("mandate")
  ExpandableField<Mandate> mandate;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * continue payment setup.
   */
  @SerializedName("next_action")
  NextAction nextAction;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_intent}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) for which the setup is intended.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the payment method used with this SetupIntent.
   */
  @SerializedName("payment_method")
  ExpandableField<PaymentMethod> paymentMethod;
  /**
   * Payment-method-specific configuration for this SetupIntent.
   */
  @SerializedName("payment_method_options")
  PaymentMethodOptions paymentMethodOptions;
  /**
   * The list of payment method types (e.g. card) that this SetupIntent is allowed to set up.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  /**
   * ID of the single_use Mandate generated by the SetupIntent.
   */
  @SerializedName("single_use_mandate")
  ExpandableField<Mandate> singleUseMandate;
  /**
   * <a href="https://stripe.com/docs/payments/intents#intent-statuses">Status</a> of this
   * SetupIntent, one of {@code requires_payment_method}, {@code requires_confirmation}, {@code
   * requires_action}, {@code processing}, {@code canceled}, or {@code succeeded}.
   */
  @SerializedName("status")
  String status;
  /**
   * Indicates how the payment method is intended to be used in the future.
   *
   * <p>Use {@code on_session} if you intend to only reuse the payment method when the customer is
   * in your checkout flow. Use {@code off_session} if your customer may or may not be in your
   * checkout flow. If not provided, this value defaults to {@code off_session}.
   */
  @SerializedName("usage")
  String usage;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code latestAttempt} object.
   */
  public String getLatestAttempt() {
    return (this.latestAttempt != null) ? this.latestAttempt.getId() : null;
  }

  public void setLatestAttempt(String id) {
    this.latestAttempt = ApiResource.setExpandableFieldId(id, this.latestAttempt);
  }

  /**
   * Get expanded {@code latestAttempt}.
   */
  public SetupAttempt getLatestAttemptObject() {
    return (this.latestAttempt != null) ? this.latestAttempt.getExpanded() : null;
  }

  public void setLatestAttemptObject(SetupAttempt expandableObject) {
    this.latestAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code mandate} object.
   */
  public String getMandate() {
    return (this.mandate != null) ? this.mandate.getId() : null;
  }

  public void setMandate(String id) {
    this.mandate = ApiResource.setExpandableFieldId(id, this.mandate);
  }

  /**
   * Get expanded {@code mandate}.
   */
  public Mandate getMandateObject() {
    return (this.mandate != null) ? this.mandate.getExpanded() : null;
  }

  public void setMandateObject(Mandate expandableObject) {
    this.mandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentMethod} object.
   */
  public String getPaymentMethod() {
    return (this.paymentMethod != null) ? this.paymentMethod.getId() : null;
  }

  public void setPaymentMethod(String id) {
    this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
  }

  /**
   * Get expanded {@code paymentMethod}.
   */
  public PaymentMethod getPaymentMethodObject() {
    return (this.paymentMethod != null) ? this.paymentMethod.getExpanded() : null;
  }

  public void setPaymentMethodObject(PaymentMethod expandableObject) {
    this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code singleUseMandate} object.
   */
  public String getSingleUseMandate() {
    return (this.singleUseMandate != null) ? this.singleUseMandate.getId() : null;
  }

  public void setSingleUseMandate(String id) {
    this.singleUseMandate = ApiResource.setExpandableFieldId(id, this.singleUseMandate);
  }

  /**
   * Get expanded {@code singleUseMandate}.
   */
  public Mandate getSingleUseMandateObject() {
    return (this.singleUseMandate != null) ? this.singleUseMandate.getExpanded() : null;
  }

  public void setSingleUseMandateObject(Mandate expandableObject) {
    this.singleUseMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a SetupIntent object.
   *
   * <p>After the SetupIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/setup_intents/confirm">confirm</a> to collect any required
   * permissions to charge the payment method later.
   */
  public static SetupIntent create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a SetupIntent object.
   *
   * <p>After the SetupIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/setup_intents/confirm">confirm</a> to collect any required
   * permissions to charge the payment method later.
   */
  public static SetupIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Creates a SetupIntent object.
   *
   * <p>After the SetupIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/setup_intents/confirm">confirm</a> to collect any required
   * permissions to charge the payment method later.
   */
  public static SetupIntent create(SetupIntentCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a SetupIntent object.
   *
   * <p>After the SetupIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/setup_intents/confirm">confirm</a> to collect any required
   * permissions to charge the payment method later.
   */
  public static SetupIntent create(SetupIntentCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Returns a list of SetupIntents.
   */
  public static SetupIntentCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of SetupIntents.
   */
  public static SetupIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
    return ApiResource.requestCollection(url, params, SetupIntentCollection.class, options);
  }

  /**
   * Returns a list of SetupIntents.
   */
  public static SetupIntentCollection list(SetupIntentListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of SetupIntents.
   */
  public static SetupIntentCollection list(SetupIntentListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
    return ApiResource.requestCollection(url, params, SetupIntentCollection.class, options);
  }

  /**
   * Retrieves the details of a SetupIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#setup_intent_object">SetupIntent</a> object
   * reference for more details.
   */
  public static SetupIntent retrieve(String intent) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a SetupIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#setup_intent_object">SetupIntent</a> object
   * reference for more details.
   */
  public static SetupIntent retrieve(String intent, RequestOptions options) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a SetupIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#setup_intent_object">SetupIntent</a> object
   * reference for more details.
   */
  public static SetupIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SetupIntent.class, options);
  }

  /**
   * Retrieves the details of a SetupIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#setup_intent_object">SetupIntent</a> object
   * reference for more details.
   */
  public static SetupIntent retrieve(String intent, SetupIntentRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SetupIntent.class, options);
  }

  /**
   * Updates a SetupIntent object.
   */
  @Override
  public SetupIntent update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a SetupIntent object.
   */
  @Override
  public SetupIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Updates a SetupIntent object.
   */
  public SetupIntent update(SetupIntentUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a SetupIntent object.
   */
  public SetupIntent update(SetupIntentUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm() throws StripeException {
    return confirm((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm(RequestOptions options) throws StripeException {
    return confirm((Map<String, Object>) null, options);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm(Map<String, Object> params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm(SetupIntentConfirmParams params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to set up the current or provided payment method. For
   * example, you would confirm a SetupIntent when a customer hits the “Save” button on a payment
   * method management page on your website.
   *
   * <p>If the selected payment method does not require any additional steps from the customer, the
   * SetupIntent will transition to the <code>succeeded</code> status.
   *
   * <p>Otherwise, it will transition to the <code>requires_action</code> status and suggest
   * additional actions via <code>next_action</code>. If setup fails, the SetupIntent will
   * transition to the <code>requires_payment_method</code> status.
   */
  public SetupIntent confirm(SetupIntentConfirmParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel(SetupIntentCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A SetupIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_confirmation</code>, or <code>requires_action
   * </code>.
   *
   * <p>Once canceled, setup is abandoned and any operations on the SetupIntent will fail with an
   * error.
   */
  public SetupIntent cancel(SetupIntentCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits() throws StripeException {
    return verifyMicrodeposits((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits(RequestOptions options) throws StripeException {
    return verifyMicrodeposits((Map<String, Object>) null, options);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits(Map<String, Object> params) throws StripeException {
    return verifyMicrodeposits(params, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits(SetupIntentVerifyMicrodepositsParams params) throws StripeException {
    return verifyMicrodeposits(params, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a SetupIntent object.
   */
  public SetupIntent verifyMicrodeposits(SetupIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
  }


  public static class NextAction extends StripeObject {
    @SerializedName("redirect_to_url")
    NextActionRedirectToUrl redirectToUrl;
    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @SerializedName("type")
    String type;
    /**
     * When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @SerializedName("use_stripe_sdk")
    Map<String, Object> useStripeSdk;
    @SerializedName("verify_with_microdeposits")
    VerifyWithMicrodeposits verifyWithMicrodeposits;


    public static class VerifyWithMicrodeposits extends StripeObject {
      /** The timestamp when the microdeposits are expected to land. */
      @SerializedName("arrival_date")
      Long arrivalDate;
      /**
       * The URL for the hosted verification page, which allows customers to verify their bank
       * account.
       */
      @SerializedName("hosted_verification_url")
      String hostedVerificationUrl;
      @SerializedName("microdeposit_type")
      String microdepositType;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getArrivalDate() {
        return this.arrivalDate;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getHostedVerificationUrl() {
        return this.hostedVerificationUrl;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMicrodepositType() {
        return this.microdepositType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setArrivalDate(final Long arrivalDate) {
        this.arrivalDate = arrivalDate;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setHostedVerificationUrl(final String hostedVerificationUrl) {
        this.hostedVerificationUrl = hostedVerificationUrl;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMicrodepositType(final String microdepositType) {
        this.microdepositType = microdepositType;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.NextAction.VerifyWithMicrodeposits)) return false;
        final SetupIntent.NextAction.VerifyWithMicrodeposits other = (SetupIntent.NextAction.VerifyWithMicrodeposits) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$arrivalDate = this.getArrivalDate();
        final java.lang.Object other$arrivalDate = other.getArrivalDate();
        if (this$arrivalDate == null ? other$arrivalDate != null : !this$arrivalDate.equals(other$arrivalDate)) return false;
        final java.lang.Object this$hostedVerificationUrl = this.getHostedVerificationUrl();
        final java.lang.Object other$hostedVerificationUrl = other.getHostedVerificationUrl();
        if (this$hostedVerificationUrl == null ? other$hostedVerificationUrl != null : !this$hostedVerificationUrl.equals(other$hostedVerificationUrl)) return false;
        final java.lang.Object this$microdepositType = this.getMicrodepositType();
        final java.lang.Object other$microdepositType = other.getMicrodepositType();
        if (this$microdepositType == null ? other$microdepositType != null : !this$microdepositType.equals(other$microdepositType)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.NextAction.VerifyWithMicrodeposits;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $arrivalDate = this.getArrivalDate();
        result = result * PRIME + ($arrivalDate == null ? 43 : $arrivalDate.hashCode());
        final java.lang.Object $hostedVerificationUrl = this.getHostedVerificationUrl();
        result = result * PRIME + ($hostedVerificationUrl == null ? 43 : $hostedVerificationUrl.hashCode());
        final java.lang.Object $microdepositType = this.getMicrodepositType();
        result = result * PRIME + ($microdepositType == null ? 43 : $microdepositType.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionRedirectToUrl getRedirectToUrl() {
      return this.redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getUseStripeSdk() {
      return this.useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VerifyWithMicrodeposits getVerifyWithMicrodeposits() {
      return this.verifyWithMicrodeposits;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirectToUrl(final NextActionRedirectToUrl redirectToUrl) {
      this.redirectToUrl = redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    /**
     * When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUseStripeSdk(final Map<String, Object> useStripeSdk) {
      this.useStripeSdk = useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifyWithMicrodeposits(final VerifyWithMicrodeposits verifyWithMicrodeposits) {
      this.verifyWithMicrodeposits = verifyWithMicrodeposits;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SetupIntent.NextAction)) return false;
      final SetupIntent.NextAction other = (SetupIntent.NextAction) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$redirectToUrl = this.getRedirectToUrl();
      final java.lang.Object other$redirectToUrl = other.getRedirectToUrl();
      if (this$redirectToUrl == null ? other$redirectToUrl != null : !this$redirectToUrl.equals(other$redirectToUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$useStripeSdk = this.getUseStripeSdk();
      final java.lang.Object other$useStripeSdk = other.getUseStripeSdk();
      if (this$useStripeSdk == null ? other$useStripeSdk != null : !this$useStripeSdk.equals(other$useStripeSdk)) return false;
      final java.lang.Object this$verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
      final java.lang.Object other$verifyWithMicrodeposits = other.getVerifyWithMicrodeposits();
      if (this$verifyWithMicrodeposits == null ? other$verifyWithMicrodeposits != null : !this$verifyWithMicrodeposits.equals(other$verifyWithMicrodeposits)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SetupIntent.NextAction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $redirectToUrl = this.getRedirectToUrl();
      result = result * PRIME + ($redirectToUrl == null ? 43 : $redirectToUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $useStripeSdk = this.getUseStripeSdk();
      result = result * PRIME + ($useStripeSdk == null ? 43 : $useStripeSdk.hashCode());
      final java.lang.Object $verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
      result = result * PRIME + ($verifyWithMicrodeposits == null ? 43 : $verifyWithMicrodeposits.hashCode());
      return result;
    }
  }


  /**
   * The type of the microdeposit sent to the customer. Used to distinguish between different
   * verification methods.
   *
   * <p>One of {@code amounts}, or {@code descriptor_code}.
   */
  public static class NextActionRedirectToUrl extends StripeObject {
    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The URL you must redirect your customer to in order to authenticate.
     */
    @SerializedName("url")
    String url;

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SetupIntent.NextActionRedirectToUrl)) return false;
      final SetupIntent.NextActionRedirectToUrl other = (SetupIntent.NextActionRedirectToUrl) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SetupIntent.NextActionRedirectToUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class PaymentMethodOptions extends StripeObject {
    @SerializedName("acss_debit")
    AcssDebit acssDebit;
    @SerializedName("card")
    Card card;
    @SerializedName("sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;


    public static class AcssDebit extends StripeObject {
      /**
       * Currency supported by the bank account
       *
       * <p>One of {@code cad}, or {@code usd}.
       */
      @SerializedName("currency")
      String currency;
      @SerializedName("mandate_options")
      MandateOptions mandateOptions;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class MandateOptions extends StripeObject {
        /** A URL for custom mandate text. */
        @SerializedName("custom_mandate_url")
        String customMandateUrl;
        /** List of Stripe products where this mandate can be selected automatically. */
        @SerializedName("default_for")
        List<String> defaultFor;
        /**
         * Description of the interval. Only required if the 'payment_schedule' parameter is
         * 'interval' or 'combined'.
         */
        @SerializedName("interval_description")
        String intervalDescription;
        /**
         * Payment schedule for the mandate.
         *
         * <p>One of {@code combined}, {@code interval}, or {@code sporadic}.
         */
        @SerializedName("payment_schedule")
        String paymentSchedule;
        /**
         * Transaction type of the mandate.
         *
         * <p>One of {@code business}, or {@code personal}.
         */
        @SerializedName("transaction_type")
        String transactionType;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCustomMandateUrl() {
          return this.customMandateUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getDefaultFor() {
          return this.defaultFor;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIntervalDescription() {
          return this.intervalDescription;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentSchedule() {
          return this.paymentSchedule;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTransactionType() {
          return this.transactionType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCustomMandateUrl(final String customMandateUrl) {
          this.customMandateUrl = customMandateUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDefaultFor(final List<String> defaultFor) {
          this.defaultFor = defaultFor;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIntervalDescription(final String intervalDescription) {
          this.intervalDescription = intervalDescription;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentSchedule(final String paymentSchedule) {
          this.paymentSchedule = paymentSchedule;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTransactionType(final String transactionType) {
          this.transactionType = transactionType;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof SetupIntent.PaymentMethodOptions.AcssDebit.MandateOptions)) return false;
          final SetupIntent.PaymentMethodOptions.AcssDebit.MandateOptions other = (SetupIntent.PaymentMethodOptions.AcssDebit.MandateOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$customMandateUrl = this.getCustomMandateUrl();
          final java.lang.Object other$customMandateUrl = other.getCustomMandateUrl();
          if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) return false;
          final java.lang.Object this$defaultFor = this.getDefaultFor();
          final java.lang.Object other$defaultFor = other.getDefaultFor();
          if (this$defaultFor == null ? other$defaultFor != null : !this$defaultFor.equals(other$defaultFor)) return false;
          final java.lang.Object this$intervalDescription = this.getIntervalDescription();
          final java.lang.Object other$intervalDescription = other.getIntervalDescription();
          if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) return false;
          final java.lang.Object this$paymentSchedule = this.getPaymentSchedule();
          final java.lang.Object other$paymentSchedule = other.getPaymentSchedule();
          if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) return false;
          final java.lang.Object this$transactionType = this.getTransactionType();
          final java.lang.Object other$transactionType = other.getTransactionType();
          if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof SetupIntent.PaymentMethodOptions.AcssDebit.MandateOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $customMandateUrl = this.getCustomMandateUrl();
          result = result * PRIME + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
          final java.lang.Object $defaultFor = this.getDefaultFor();
          result = result * PRIME + ($defaultFor == null ? 43 : $defaultFor.hashCode());
          final java.lang.Object $intervalDescription = this.getIntervalDescription();
          result = result * PRIME + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
          final java.lang.Object $paymentSchedule = this.getPaymentSchedule();
          result = result * PRIME + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
          final java.lang.Object $transactionType = this.getTransactionType();
          result = result * PRIME + ($transactionType == null ? 43 : $transactionType.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCurrency() {
        return this.currency;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public MandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCurrency(final String currency) {
        this.currency = currency;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final MandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.PaymentMethodOptions.AcssDebit)) return false;
        final SetupIntent.PaymentMethodOptions.AcssDebit other = (SetupIntent.PaymentMethodOptions.AcssDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$currency = this.getCurrency();
        final java.lang.Object other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.PaymentMethodOptions.AcssDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $currency = this.getCurrency();
        result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }


    public static class Card extends StripeObject {
      /** Configuration options for setting up an eMandate for cards issued in India. */
      @SerializedName("mandate_options")
      MandateOptions mandateOptions;
      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, {@code automatic}, or {@code challenge_only}.
       */
      @SerializedName("request_three_d_secure")
      String requestThreeDSecure;


      public static class MandateOptions extends StripeObject {
        /** Amount to be charged for future payments. */
        @SerializedName("amount")
        Long amount;
        /**
         * One of {@code fixed} or {@code maximum}. If {@code fixed}, the {@code amount} param
         * refers to the exact amount to be charged in future payments. If {@code maximum}, the
         * amount charged can be up to the value passed for the {@code amount} param.
         */
        @SerializedName("amount_type")
        String amountType;
        /**
         * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
         * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
         * currency</a>.
         */
        @SerializedName("currency")
        String currency;
        /**
         * A description of the mandate or subscription that is meant to be displayed to the
         * customer.
         */
        @SerializedName("description")
        String description;
        /**
         * End date of the mandate or subscription. If not provided, the mandate will be active
         * until canceled. If provided, end date should be after start date.
         */
        @SerializedName("end_date")
        Long endDate;
        /**
         * Specifies payment frequency. One of {@code day}, {@code week}, {@code month}, {@code
         * year}, or {@code sporadic}.
         */
        @SerializedName("interval")
        String interval;
        /**
         * The number of intervals between payments. For example, {@code interval=month} and {@code
         * interval_count=3} indicates one payment every three months. Maximum of one year interval
         * allowed (1 year, 12 months, or 52 weeks). This parameter is optional when {@code
         * interval=sporadic}.
         */
        @SerializedName("interval_count")
        Long intervalCount;
        /** Unique identifier for the mandate or subscription. */
        @SerializedName("reference")
        String reference;
        /**
         * Start date of the mandate or subscription. Start date should not be lesser than
         * yesterday.
         */
        @SerializedName("start_date")
        Long startDate;
        /** Specifies the type of mandates supported. Possible values are {@code india}. */
        @SerializedName("supported_types")
        List<String> supportedTypes;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAmountType() {
          return this.amountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCurrency() {
          return this.currency;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
          return this.description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getEndDate() {
          return this.endDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getInterval() {
          return this.interval;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getIntervalCount() {
          return this.intervalCount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getReference() {
          return this.reference;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getStartDate() {
          return this.startDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getSupportedTypes() {
          return this.supportedTypes;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmountType(final String amountType) {
          this.amountType = amountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCurrency(final String currency) {
          this.currency = currency;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDescription(final String description) {
          this.description = description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEndDate(final Long endDate) {
          this.endDate = endDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setInterval(final String interval) {
          this.interval = interval;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIntervalCount(final Long intervalCount) {
          this.intervalCount = intervalCount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setReference(final String reference) {
          this.reference = reference;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setStartDate(final Long startDate) {
          this.startDate = startDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSupportedTypes(final List<String> supportedTypes) {
          this.supportedTypes = supportedTypes;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof SetupIntent.PaymentMethodOptions.Card.MandateOptions)) return false;
          final SetupIntent.PaymentMethodOptions.Card.MandateOptions other = (SetupIntent.PaymentMethodOptions.Card.MandateOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$endDate = this.getEndDate();
          final java.lang.Object other$endDate = other.getEndDate();
          if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) return false;
          final java.lang.Object this$intervalCount = this.getIntervalCount();
          final java.lang.Object other$intervalCount = other.getIntervalCount();
          if (this$intervalCount == null ? other$intervalCount != null : !this$intervalCount.equals(other$intervalCount)) return false;
          final java.lang.Object this$startDate = this.getStartDate();
          final java.lang.Object other$startDate = other.getStartDate();
          if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
          final java.lang.Object this$amountType = this.getAmountType();
          final java.lang.Object other$amountType = other.getAmountType();
          if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) return false;
          final java.lang.Object this$currency = this.getCurrency();
          final java.lang.Object other$currency = other.getCurrency();
          if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
          final java.lang.Object this$description = this.getDescription();
          final java.lang.Object other$description = other.getDescription();
          if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
          final java.lang.Object this$interval = this.getInterval();
          final java.lang.Object other$interval = other.getInterval();
          if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
          final java.lang.Object this$reference = this.getReference();
          final java.lang.Object other$reference = other.getReference();
          if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
          final java.lang.Object this$supportedTypes = this.getSupportedTypes();
          final java.lang.Object other$supportedTypes = other.getSupportedTypes();
          if (this$supportedTypes == null ? other$supportedTypes != null : !this$supportedTypes.equals(other$supportedTypes)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof SetupIntent.PaymentMethodOptions.Card.MandateOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $endDate = this.getEndDate();
          result = result * PRIME + ($endDate == null ? 43 : $endDate.hashCode());
          final java.lang.Object $intervalCount = this.getIntervalCount();
          result = result * PRIME + ($intervalCount == null ? 43 : $intervalCount.hashCode());
          final java.lang.Object $startDate = this.getStartDate();
          result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
          final java.lang.Object $amountType = this.getAmountType();
          result = result * PRIME + ($amountType == null ? 43 : $amountType.hashCode());
          final java.lang.Object $currency = this.getCurrency();
          result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
          final java.lang.Object $description = this.getDescription();
          result = result * PRIME + ($description == null ? 43 : $description.hashCode());
          final java.lang.Object $interval = this.getInterval();
          result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
          final java.lang.Object $reference = this.getReference();
          result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
          final java.lang.Object $supportedTypes = this.getSupportedTypes();
          result = result * PRIME + ($supportedTypes == null ? 43 : $supportedTypes.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public MandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequestThreeDSecure() {
        return this.requestThreeDSecure;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final MandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestThreeDSecure(final String requestThreeDSecure) {
        this.requestThreeDSecure = requestThreeDSecure;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.PaymentMethodOptions.Card)) return false;
        final SetupIntent.PaymentMethodOptions.Card other = (SetupIntent.PaymentMethodOptions.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$requestThreeDSecure = this.getRequestThreeDSecure();
        final java.lang.Object other$requestThreeDSecure = other.getRequestThreeDSecure();
        if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.PaymentMethodOptions.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $requestThreeDSecure = this.getRequestThreeDSecure();
        result = result * PRIME + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
        return result;
      }
    }


    public static class SepaDebit extends StripeObject {
      @SerializedName("mandate_options")
      SepaDebitMandateOptions mandateOptions;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public SepaDebitMandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final SepaDebitMandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.PaymentMethodOptions.SepaDebit)) return false;
        final SetupIntent.PaymentMethodOptions.SepaDebit other = (SetupIntent.PaymentMethodOptions.SepaDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.PaymentMethodOptions.SepaDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        return result;
      }
    }


    public static class SepaDebitMandateOptions extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.PaymentMethodOptions.SepaDebitMandateOptions)) return false;
        final SetupIntent.PaymentMethodOptions.SepaDebitMandateOptions other = (SetupIntent.PaymentMethodOptions.SepaDebitMandateOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.PaymentMethodOptions.SepaDebitMandateOptions;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class UsBankAccount extends StripeObject {
      @SerializedName("financial_connections")
      FinancialConnections financialConnections;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class FinancialConnections extends StripeObject {
        /**
         * The list of permissions to request. The {@code payment_method} permission must be
         * included.
         */
        @SerializedName("permissions")
        List<String> permissions;
        /**
         * For webview integrations only. Upon completing OAuth login in the native browser, the
         * user will be redirected to this URL to return to your app.
         */
        @SerializedName("return_url")
        String returnUrl;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getPermissions() {
          return this.permissions;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getReturnUrl() {
          return this.returnUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPermissions(final List<String> permissions) {
          this.permissions = permissions;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setReturnUrl(final String returnUrl) {
          this.returnUrl = returnUrl;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof SetupIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections)) return false;
          final SetupIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections other = (SetupIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$permissions = this.getPermissions();
          final java.lang.Object other$permissions = other.getPermissions();
          if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
          final java.lang.Object this$returnUrl = this.getReturnUrl();
          final java.lang.Object other$returnUrl = other.getReturnUrl();
          if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof SetupIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $permissions = this.getPermissions();
          result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
          final java.lang.Object $returnUrl = this.getReturnUrl();
          result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public FinancialConnections getFinancialConnections() {
        return this.financialConnections;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFinancialConnections(final FinancialConnections financialConnections) {
        this.financialConnections = financialConnections;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupIntent.PaymentMethodOptions.UsBankAccount)) return false;
        final SetupIntent.PaymentMethodOptions.UsBankAccount other = (SetupIntent.PaymentMethodOptions.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$financialConnections = this.getFinancialConnections();
        final java.lang.Object other$financialConnections = other.getFinancialConnections();
        if (this$financialConnections == null ? other$financialConnections != null : !this$financialConnections.equals(other$financialConnections)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupIntent.PaymentMethodOptions.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $financialConnections = this.getFinancialConnections();
        result = result * PRIME + ($financialConnections == null ? 43 : $financialConnections.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcssDebit getAcssDebit() {
      return this.acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaDebit getSepaDebit() {
      return this.sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAcssDebit(final AcssDebit acssDebit) {
      this.acssDebit = acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaDebit(final SepaDebit sepaDebit) {
      this.sepaDebit = sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SetupIntent.PaymentMethodOptions)) return false;
      final SetupIntent.PaymentMethodOptions other = (SetupIntent.PaymentMethodOptions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$acssDebit = this.getAcssDebit();
      final java.lang.Object other$acssDebit = other.getAcssDebit();
      if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$sepaDebit = this.getSepaDebit();
      final java.lang.Object other$sepaDebit = other.getSepaDebit();
      if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SetupIntent.PaymentMethodOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $acssDebit = this.getAcssDebit();
      result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $sepaDebit = this.getSepaDebit();
      result = result * PRIME + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }

  /**
   * If present, the SetupIntent's payment method will be attached to the in-context Stripe Account.
   *
   * <p>It can only be used for this Stripe Account’s own money movement flows like InboundTransfer
   * and OutboundTransfers. It cannot be set to true when setting up a PaymentMethod for a Customer,
   * and defaults to false when attaching a PaymentMethod to a Customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAttachToSelf() {
    return this.attachToSelf;
  }

  /**
   * Reason for cancellation of this SetupIntent, one of {@code abandoned}, {@code
   * requested_by_customer}, or {@code duplicate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancellationReason() {
    return this.cancellationReason;
  }

  /**
   * The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete payment setup from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Indicates the directions of money movement for which this payment method is intended to be
   * used.
   *
   * <p>Include {@code inbound} if you intend to use the payment method as the origin to pull funds
   * from. Include {@code outbound} if you intend to use the payment method as the destination to
   * send funds to. You can include both if you intend to use the payment method for both purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getFlowDirections() {
    return this.flowDirections;
  }

  /**
   * The error encountered in the previous SetupIntent confirmation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getLastSetupError() {
    return this.lastSetupError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * continue payment setup.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NextAction getNextAction() {
    return this.nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Payment-method-specific configuration for this SetupIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodOptions getPaymentMethodOptions() {
    return this.paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this SetupIntent is allowed to set up.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * <a href="https://stripe.com/docs/payments/intents#intent-statuses">Status</a> of this
   * SetupIntent, one of {@code requires_payment_method}, {@code requires_confirmation}, {@code
   * requires_action}, {@code processing}, {@code canceled}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Indicates how the payment method is intended to be used in the future.
   *
   * <p>Use {@code on_session} if you intend to only reuse the payment method when the customer is
   * in your checkout flow. Use {@code off_session} if your customer may or may not be in your
   * checkout flow. If not provided, this value defaults to {@code off_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUsage() {
    return this.usage;
  }

  /**
   * If present, the SetupIntent's payment method will be attached to the in-context Stripe Account.
   *
   * <p>It can only be used for this Stripe Account’s own money movement flows like InboundTransfer
   * and OutboundTransfers. It cannot be set to true when setting up a PaymentMethod for a Customer,
   * and defaults to false when attaching a PaymentMethod to a Customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAttachToSelf(final Boolean attachToSelf) {
    this.attachToSelf = attachToSelf;
  }

  /**
   * Reason for cancellation of this SetupIntent, one of {@code abandoned}, {@code
   * requested_by_customer}, or {@code duplicate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancellationReason(final String cancellationReason) {
    this.cancellationReason = cancellationReason;
  }

  /**
   * The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete payment setup from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Indicates the directions of money movement for which this payment method is intended to be
   * used.
   *
   * <p>Include {@code inbound} if you intend to use the payment method as the origin to pull funds
   * from. Include {@code outbound} if you intend to use the payment method as the destination to
   * send funds to. You can include both if you intend to use the payment method for both purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlowDirections(final List<String> flowDirections) {
    this.flowDirections = flowDirections;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The error encountered in the previous SetupIntent confirmation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastSetupError(final StripeError lastSetupError) {
    this.lastSetupError = lastSetupError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * continue payment setup.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNextAction(final NextAction nextAction) {
    this.nextAction = nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Payment-method-specific configuration for this SetupIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodOptions(final PaymentMethodOptions paymentMethodOptions) {
    this.paymentMethodOptions = paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this SetupIntent is allowed to set up.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  /**
   * <a href="https://stripe.com/docs/payments/intents#intent-statuses">Status</a> of this
   * SetupIntent, one of {@code requires_payment_method}, {@code requires_confirmation}, {@code
   * requires_action}, {@code processing}, {@code canceled}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * Indicates how the payment method is intended to be used in the future.
   *
   * <p>Use {@code on_session} if you intend to only reuse the payment method when the customer is
   * in your checkout flow. Use {@code off_session} if your customer may or may not be in your
   * checkout flow. If not provided, this value defaults to {@code off_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUsage(final String usage) {
    this.usage = usage;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SetupIntent)) return false;
    final SetupIntent other = (SetupIntent) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$attachToSelf = this.getAttachToSelf();
    final java.lang.Object other$attachToSelf = other.getAttachToSelf();
    if (this$attachToSelf == null ? other$attachToSelf != null : !this$attachToSelf.equals(other$attachToSelf)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$cancellationReason = this.getCancellationReason();
    final java.lang.Object other$cancellationReason = other.getCancellationReason();
    if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$flowDirections = this.getFlowDirections();
    final java.lang.Object other$flowDirections = other.getFlowDirections();
    if (this$flowDirections == null ? other$flowDirections != null : !this$flowDirections.equals(other$flowDirections)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lastSetupError = this.getLastSetupError();
    final java.lang.Object other$lastSetupError = other.getLastSetupError();
    if (this$lastSetupError == null ? other$lastSetupError != null : !this$lastSetupError.equals(other$lastSetupError)) return false;
    final java.lang.Object this$latestAttempt = this.getLatestAttempt();
    final java.lang.Object other$latestAttempt = other.getLatestAttempt();
    if (this$latestAttempt == null ? other$latestAttempt != null : !this$latestAttempt.equals(other$latestAttempt)) return false;
    final java.lang.Object this$mandate = this.getMandate();
    final java.lang.Object other$mandate = other.getMandate();
    if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nextAction = this.getNextAction();
    final java.lang.Object other$nextAction = other.getNextAction();
    if (this$nextAction == null ? other$nextAction != null : !this$nextAction.equals(other$nextAction)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodOptions = this.getPaymentMethodOptions();
    final java.lang.Object other$paymentMethodOptions = other.getPaymentMethodOptions();
    if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !this$paymentMethodOptions.equals(other$paymentMethodOptions)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$singleUseMandate = this.getSingleUseMandate();
    final java.lang.Object other$singleUseMandate = other.getSingleUseMandate();
    if (this$singleUseMandate == null ? other$singleUseMandate != null : !this$singleUseMandate.equals(other$singleUseMandate)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$usage = this.getUsage();
    final java.lang.Object other$usage = other.getUsage();
    if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SetupIntent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $attachToSelf = this.getAttachToSelf();
    result = result * PRIME + ($attachToSelf == null ? 43 : $attachToSelf.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $cancellationReason = this.getCancellationReason();
    result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $flowDirections = this.getFlowDirections();
    result = result * PRIME + ($flowDirections == null ? 43 : $flowDirections.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lastSetupError = this.getLastSetupError();
    result = result * PRIME + ($lastSetupError == null ? 43 : $lastSetupError.hashCode());
    final java.lang.Object $latestAttempt = this.getLatestAttempt();
    result = result * PRIME + ($latestAttempt == null ? 43 : $latestAttempt.hashCode());
    final java.lang.Object $mandate = this.getMandate();
    result = result * PRIME + ($mandate == null ? 43 : $mandate.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nextAction = this.getNextAction();
    result = result * PRIME + ($nextAction == null ? 43 : $nextAction.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodOptions = this.getPaymentMethodOptions();
    result = result * PRIME + ($paymentMethodOptions == null ? 43 : $paymentMethodOptions.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $singleUseMandate = this.getSingleUseMandate();
    result = result * PRIME + ($singleUseMandate == null ? 43 : $singleUseMandate.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $usage = this.getUsage();
    result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
