// Generated by delombok at Mon May 23 23:23:00 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.param.apps;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecretCreateParams extends ApiRequestParams {
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * A name for the secret that's unique within the scope.
   */
  @SerializedName("name")
  String name;
  /**
   * The plaintext secret value to be stored.
   */
  @SerializedName("payload")
  String payload;
  /**
   * Specifies the scoping of the secret. Requests originating from UI extensions can only access
   * account-scoped secrets or secrets scoped to their own user.
   */
  @SerializedName("scope")
  Scope scope;

  private SecretCreateParams(List<String> expand, Map<String, Object> extraParams, String name, String payload, Scope scope) {
    this.expand = expand;
    this.extraParams = extraParams;
    this.name = name;
    this.payload = payload;
    this.scope = scope;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private List<String> expand;
    private Map<String, Object> extraParams;
    private String name;
    private String payload;
    private Scope scope;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public SecretCreateParams build() {
      return new SecretCreateParams(this.expand, this.extraParams, this.name, this.payload, this.scope);
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SecretCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SecretCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * SecretCreateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link SecretCreateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * A name for the secret that's unique within the scope.
     */
    public Builder setName(String name) {
      this.name = name;
      return this;
    }

    /**
     * The plaintext secret value to be stored.
     */
    public Builder setPayload(String payload) {
      this.payload = payload;
      return this;
    }

    /**
     * Specifies the scoping of the secret. Requests originating from UI extensions can only access
     * account-scoped secrets or secrets scoped to their own user.
     */
    public Builder setScope(Scope scope) {
      this.scope = scope;
      return this;
    }
  }


  public static class Scope {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /** The secret scope type. */
    @SerializedName("type")
    Type type;
    /**
     * The user ID. This field is required if {@code type} is set to {@code user}, and should not be
     * provided if {@code type} is set to {@code account}.
     */
    @SerializedName("user")
    String user;

    private Scope(Map<String, Object> extraParams, Type type, String user) {
      this.extraParams = extraParams;
      this.type = type;
      this.user = user;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Type type;
      private String user;

      /** Finalize and obtain parameter instance from this builder. */
      public Scope build() {
        return new Scope(this.extraParams, this.type, this.user);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SecretCreateParams.Scope#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link SecretCreateParams.Scope#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** The secret scope type. */
      public Builder setType(Type type) {
        this.type = type;
        return this;
      }

      /**
       * The user ID. This field is required if {@code type} is set to {@code user}, and should not
       * be provided if {@code type} is set to {@code account}.
       */
      public Builder setUser(String user) {
        this.user = user;
        return this;
      }
    }


    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("account")
      ACCOUNT("account"), @SerializedName("user")
      USER("user");
      private final String value;

      Type(String value) {
        this.value = value;
      }

      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Type getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUser() {
      return this.user;
    }
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * A name for the secret that's unique within the scope.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * The plaintext secret value to be stored.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPayload() {
    return this.payload;
  }

  /**
   * Specifies the scoping of the secret. Requests originating from UI extensions can only access
   * account-scoped secrets or secrets scoped to their own user.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Scope getScope() {
    return this.scope;
  }
}
