// Generated by delombok at Fri Jun 17 22:19:47 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.Authorization;

public class FlowDetails extends StripeObject {
  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_credits">ReceivedCredits</a>
   * depending on their network and source flow. Reversing a ReceivedCredit leads to the creation of
   * a new object known as a CreditReversal.
   */
  @SerializedName("credit_reversal")
  CreditReversal creditReversal;
  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_debits">ReceivedDebits</a>
   * depending on their network and source flow. Reversing a ReceivedDebit leads to the creation of
   * a new object known as a DebitReversal.
   */
  @SerializedName("debit_reversal")
  DebitReversal debitReversal;
  /**
   * Use <a
   * href="https://stripe.com/docs/treasury/moving-money/financial-accounts/into/inbound-transfers">InboundTransfers</a>
   * to add funds to your <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> via a PaymentMethod
   * that is owned by you. The funds will be transferred via an ACH debit.
   */
  @SerializedName("inbound_transfer")
  InboundTransfer inboundTransfer;
  /**
   * When an <a href="https://stripe.com/docs/issuing">issued card</a> is used to make a purchase,
   * an Issuing {@code Authorization} object is created. <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">Authorizations</a> must be
   * approved for the purchase to be completed successfully.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/purchases/authorizations">Issued
   * Card Authorizations</a>.
   */
  @SerializedName("issuing_authorization")
  Authorization issuingAuthorization;
  /**
   * Use OutboundPayments to send funds to another party's external bank account or <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. To send money to an
   * account belonging to the same user, use an <a
   * href="https://stripe.com/docs/api#outbound_transfers">OutboundTransfer</a>.
   *
   * <p>Simulate OutboundPayment state changes with the {@code
   * /v1/test_helpers/treasury/outbound_payments} endpoints. These methods can only be called on
   * test mode objects.
   */
  @SerializedName("outbound_payment")
  OutboundPayment outboundPayment;
  /**
   * Use OutboundTransfers to transfer funds from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> to a PaymentMethod
   * belonging to the same entity. To send funds to a different party, use <a
   * href="https://stripe.com/docs/api#outbound_payments">OutboundPayments</a> instead. You can send
   * funds over ACH rails or through a domestic wire transfer to a user's own external bank account.
   *
   * <p>Simulate OutboundTransfer state changes with the {@code
   * /v1/test_helpers/treasury/outbound_transfers} endpoints. These methods can only be called on
   * test mode objects.
   */
  @SerializedName("outbound_transfer")
  OutboundTransfer outboundTransfer;
  /**
   * ReceivedCredits represent funds sent to a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> (for example, via
   * ACH or wire). These money movements are not initiated from the FinancialAccount.
   */
  @SerializedName("received_credit")
  ReceivedCredit receivedCredit;
  /**
   * ReceivedDebits represent funds pulled from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. These are not
   * initiated from the FinancialAccount.
   */
  @SerializedName("received_debit")
  ReceivedDebit receivedDebit;
  /**
   * Type of the flow that created the Transaction. Set to the same value as {@code flow_type}.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @SerializedName("type")
  String type;

  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_credits">ReceivedCredits</a>
   * depending on their network and source flow. Reversing a ReceivedCredit leads to the creation of
   * a new object known as a CreditReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CreditReversal getCreditReversal() {
    return this.creditReversal;
  }

  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_debits">ReceivedDebits</a>
   * depending on their network and source flow. Reversing a ReceivedDebit leads to the creation of
   * a new object known as a DebitReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DebitReversal getDebitReversal() {
    return this.debitReversal;
  }

  /**
   * Use <a
   * href="https://stripe.com/docs/treasury/moving-money/financial-accounts/into/inbound-transfers">InboundTransfers</a>
   * to add funds to your <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> via a PaymentMethod
   * that is owned by you. The funds will be transferred via an ACH debit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InboundTransfer getInboundTransfer() {
    return this.inboundTransfer;
  }

  /**
   * When an <a href="https://stripe.com/docs/issuing">issued card</a> is used to make a purchase,
   * an Issuing {@code Authorization} object is created. <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">Authorizations</a> must be
   * approved for the purchase to be completed successfully.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/purchases/authorizations">Issued
   * Card Authorizations</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Authorization getIssuingAuthorization() {
    return this.issuingAuthorization;
  }

  /**
   * Use OutboundPayments to send funds to another party's external bank account or <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. To send money to an
   * account belonging to the same user, use an <a
   * href="https://stripe.com/docs/api#outbound_transfers">OutboundTransfer</a>.
   *
   * <p>Simulate OutboundPayment state changes with the {@code
   * /v1/test_helpers/treasury/outbound_payments} endpoints. These methods can only be called on
   * test mode objects.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutboundPayment getOutboundPayment() {
    return this.outboundPayment;
  }

  /**
   * Use OutboundTransfers to transfer funds from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> to a PaymentMethod
   * belonging to the same entity. To send funds to a different party, use <a
   * href="https://stripe.com/docs/api#outbound_payments">OutboundPayments</a> instead. You can send
   * funds over ACH rails or through a domestic wire transfer to a user's own external bank account.
   *
   * <p>Simulate OutboundTransfer state changes with the {@code
   * /v1/test_helpers/treasury/outbound_transfers} endpoints. These methods can only be called on
   * test mode objects.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutboundTransfer getOutboundTransfer() {
    return this.outboundTransfer;
  }

  /**
   * ReceivedCredits represent funds sent to a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> (for example, via
   * ACH or wire). These money movements are not initiated from the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReceivedCredit getReceivedCredit() {
    return this.receivedCredit;
  }

  /**
   * ReceivedDebits represent funds pulled from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. These are not
   * initiated from the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReceivedDebit getReceivedDebit() {
    return this.receivedDebit;
  }

  /**
   * Type of the flow that created the Transaction. Set to the same value as {@code flow_type}.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_credits">ReceivedCredits</a>
   * depending on their network and source flow. Reversing a ReceivedCredit leads to the creation of
   * a new object known as a CreditReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreditReversal(final CreditReversal creditReversal) {
    this.creditReversal = creditReversal;
  }

  /**
   * You can reverse some <a href="https://stripe.com/docs/api#received_debits">ReceivedDebits</a>
   * depending on their network and source flow. Reversing a ReceivedDebit leads to the creation of
   * a new object known as a DebitReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDebitReversal(final DebitReversal debitReversal) {
    this.debitReversal = debitReversal;
  }

  /**
   * Use <a
   * href="https://stripe.com/docs/treasury/moving-money/financial-accounts/into/inbound-transfers">InboundTransfers</a>
   * to add funds to your <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> via a PaymentMethod
   * that is owned by you. The funds will be transferred via an ACH debit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInboundTransfer(final InboundTransfer inboundTransfer) {
    this.inboundTransfer = inboundTransfer;
  }

  /**
   * When an <a href="https://stripe.com/docs/issuing">issued card</a> is used to make a purchase,
   * an Issuing {@code Authorization} object is created. <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">Authorizations</a> must be
   * approved for the purchase to be completed successfully.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/purchases/authorizations">Issued
   * Card Authorizations</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIssuingAuthorization(final Authorization issuingAuthorization) {
    this.issuingAuthorization = issuingAuthorization;
  }

  /**
   * Use OutboundPayments to send funds to another party's external bank account or <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. To send money to an
   * account belonging to the same user, use an <a
   * href="https://stripe.com/docs/api#outbound_transfers">OutboundTransfer</a>.
   *
   * <p>Simulate OutboundPayment state changes with the {@code
   * /v1/test_helpers/treasury/outbound_payments} endpoints. These methods can only be called on
   * test mode objects.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutboundPayment(final OutboundPayment outboundPayment) {
    this.outboundPayment = outboundPayment;
  }

  /**
   * Use OutboundTransfers to transfer funds from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> to a PaymentMethod
   * belonging to the same entity. To send funds to a different party, use <a
   * href="https://stripe.com/docs/api#outbound_payments">OutboundPayments</a> instead. You can send
   * funds over ACH rails or through a domestic wire transfer to a user's own external bank account.
   *
   * <p>Simulate OutboundTransfer state changes with the {@code
   * /v1/test_helpers/treasury/outbound_transfers} endpoints. These methods can only be called on
   * test mode objects.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutboundTransfer(final OutboundTransfer outboundTransfer) {
    this.outboundTransfer = outboundTransfer;
  }

  /**
   * ReceivedCredits represent funds sent to a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> (for example, via
   * ACH or wire). These money movements are not initiated from the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceivedCredit(final ReceivedCredit receivedCredit) {
    this.receivedCredit = receivedCredit;
  }

  /**
   * ReceivedDebits represent funds pulled from a <a
   * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. These are not
   * initiated from the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceivedDebit(final ReceivedDebit receivedDebit) {
    this.receivedDebit = receivedDebit;
  }

  /**
   * Type of the flow that created the Transaction. Set to the same value as {@code flow_type}.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FlowDetails)) return false;
    final FlowDetails other = (FlowDetails) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$creditReversal = this.getCreditReversal();
    final java.lang.Object other$creditReversal = other.getCreditReversal();
    if (this$creditReversal == null ? other$creditReversal != null : !this$creditReversal.equals(other$creditReversal)) return false;
    final java.lang.Object this$debitReversal = this.getDebitReversal();
    final java.lang.Object other$debitReversal = other.getDebitReversal();
    if (this$debitReversal == null ? other$debitReversal != null : !this$debitReversal.equals(other$debitReversal)) return false;
    final java.lang.Object this$inboundTransfer = this.getInboundTransfer();
    final java.lang.Object other$inboundTransfer = other.getInboundTransfer();
    if (this$inboundTransfer == null ? other$inboundTransfer != null : !this$inboundTransfer.equals(other$inboundTransfer)) return false;
    final java.lang.Object this$issuingAuthorization = this.getIssuingAuthorization();
    final java.lang.Object other$issuingAuthorization = other.getIssuingAuthorization();
    if (this$issuingAuthorization == null ? other$issuingAuthorization != null : !this$issuingAuthorization.equals(other$issuingAuthorization)) return false;
    final java.lang.Object this$outboundPayment = this.getOutboundPayment();
    final java.lang.Object other$outboundPayment = other.getOutboundPayment();
    if (this$outboundPayment == null ? other$outboundPayment != null : !this$outboundPayment.equals(other$outboundPayment)) return false;
    final java.lang.Object this$outboundTransfer = this.getOutboundTransfer();
    final java.lang.Object other$outboundTransfer = other.getOutboundTransfer();
    if (this$outboundTransfer == null ? other$outboundTransfer != null : !this$outboundTransfer.equals(other$outboundTransfer)) return false;
    final java.lang.Object this$receivedCredit = this.getReceivedCredit();
    final java.lang.Object other$receivedCredit = other.getReceivedCredit();
    if (this$receivedCredit == null ? other$receivedCredit != null : !this$receivedCredit.equals(other$receivedCredit)) return false;
    final java.lang.Object this$receivedDebit = this.getReceivedDebit();
    final java.lang.Object other$receivedDebit = other.getReceivedDebit();
    if (this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FlowDetails;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $creditReversal = this.getCreditReversal();
    result = result * PRIME + ($creditReversal == null ? 43 : $creditReversal.hashCode());
    final java.lang.Object $debitReversal = this.getDebitReversal();
    result = result * PRIME + ($debitReversal == null ? 43 : $debitReversal.hashCode());
    final java.lang.Object $inboundTransfer = this.getInboundTransfer();
    result = result * PRIME + ($inboundTransfer == null ? 43 : $inboundTransfer.hashCode());
    final java.lang.Object $issuingAuthorization = this.getIssuingAuthorization();
    result = result * PRIME + ($issuingAuthorization == null ? 43 : $issuingAuthorization.hashCode());
    final java.lang.Object $outboundPayment = this.getOutboundPayment();
    result = result * PRIME + ($outboundPayment == null ? 43 : $outboundPayment.hashCode());
    final java.lang.Object $outboundTransfer = this.getOutboundTransfer();
    result = result * PRIME + ($outboundTransfer == null ? 43 : $outboundTransfer.hashCode());
    final java.lang.Object $receivedCredit = this.getReceivedCredit();
    result = result * PRIME + ($receivedCredit == null ? 43 : $receivedCredit.hashCode());
    final java.lang.Object $receivedDebit = this.getReceivedDebit();
    result = result * PRIME + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }
}
