// Generated by delombok at Fri Jun 17 19:33:44 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.OutboundPaymentCancelParams;
import com.stripe.param.treasury.OutboundPaymentCreateParams;
import com.stripe.param.treasury.OutboundPaymentFailParams;
import com.stripe.param.treasury.OutboundPaymentListParams;
import com.stripe.param.treasury.OutboundPaymentPostParams;
import com.stripe.param.treasury.OutboundPaymentRetrieveParams;
import com.stripe.param.treasury.OutboundPaymentReturnOutboundPaymentParams;
import java.util.Map;

public class OutboundPayment extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @SerializedName("cancelable")
  Boolean cancelable;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the <a href="https://stripe.com/docs/api/customers">customer</a> to whom an
   * OutboundPayment is sent.
   */
  @SerializedName("customer")
  String customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The PaymentMethod via which an OutboundPayment is sent. This field can be empty if the
   * OutboundPayment was created using {@code destination_payment_method_data}.
   */
  @SerializedName("destination_payment_method")
  String destinationPaymentMethod;
  /**
   * Details about the PaymentMethod for an OutboundPayment.
   */
  @SerializedName("destination_payment_method_details")
  DestinationPaymentMethodDetails destinationPaymentMethodDetails;
  /**
   * Details about the end user.
   */
  @SerializedName("end_user_details")
  EndUserDetails endUserDetails;
  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @SerializedName("expected_arrival_date")
  Long expectedArrivalDate;
  /**
   * The FinancialAccount that funds were pulled from.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @SerializedName("hosted_regulatory_receipt_url")
  String hostedRegulatoryReceiptUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_payment}.
   */
  @SerializedName("object")
  String object;
  /**
   * Details about a returned OutboundPayment. Only set when the status is {@code returned}.
   */
  @SerializedName("returned_details")
  ReturnedDetails returnedDetails;
  /**
   * The description that appears on the receiving end for an OutboundPayment (for example, bank
   * statement for external bank transfer).
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Current status of the OutboundPayment: {@code processing}, {@code failed}, {@code posted},
   * {@code returned}, {@code canceled}. An OutboundPayment is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundPayment has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundPayment fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates an OutboundPayment.
   */
  public static OutboundPayment create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an OutboundPayment.
   */
  public static OutboundPayment create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_payments");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
  }

  /**
   * Creates an OutboundPayment.
   */
  public static OutboundPayment create(OutboundPaymentCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an OutboundPayment.
   */
  public static OutboundPayment create(OutboundPaymentCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_payments");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
  }

  /**
   * Retrieves the details of an existing OutboundPayment by passing the unique OutboundPayment ID
   * from either the OutboundPayment creation request or OutboundPayment list.
   */
  public static OutboundPayment retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing OutboundPayment by passing the unique OutboundPayment ID
   * from either the OutboundPayment creation request or OutboundPayment list.
   */
  public static OutboundPayment retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing OutboundPayment by passing the unique OutboundPayment ID
   * from either the OutboundPayment creation request or OutboundPayment list.
   */
  public static OutboundPayment retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_payments/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OutboundPayment.class, options);
  }

  /**
   * Retrieves the details of an existing OutboundPayment by passing the unique OutboundPayment ID
   * from either the OutboundPayment creation request or OutboundPayment list.
   */
  public static OutboundPayment retrieve(String id, OutboundPaymentRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_payments/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OutboundPayment.class, options);
  }

  /**
   * Returns a list of OutboundPayments sent from the specified FinancialAccount.
   */
  public static OutboundPaymentCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of OutboundPayments sent from the specified FinancialAccount.
   */
  public static OutboundPaymentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_payments");
    return ApiResource.requestCollection(url, params, OutboundPaymentCollection.class, options);
  }

  /**
   * Returns a list of OutboundPayments sent from the specified FinancialAccount.
   */
  public static OutboundPaymentCollection list(OutboundPaymentListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of OutboundPayments sent from the specified FinancialAccount.
   */
  public static OutboundPaymentCollection list(OutboundPaymentListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_payments");
    return ApiResource.requestCollection(url, params, OutboundPaymentCollection.class, options);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_payments/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel(OutboundPaymentCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancel an OutboundPayment.
   */
  public OutboundPayment cancel(OutboundPaymentCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_payments/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
  }


  public static class DestinationPaymentMethodDetails extends StripeObject {
    @SerializedName("billing_details")
    BillingDetails billingDetails;
    @SerializedName("financial_account")
    FinancialAccount financialAccount;
    /**
     * The type of the payment method used in the OutboundPayment.
     *
     * <p>One of {@code financial_account}, or {@code us_bank_account}.
     */
    @SerializedName("type")
    String type;
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;


    public static class BillingDetails extends StripeObject {
      @SerializedName("address")
      Address address;
      /**
       * Email address.
       */
      @SerializedName("email")
      String email;
      /**
       * Full name.
       */
      @SerializedName("name")
      String name;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Address getAddress() {
        return this.address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmail() {
        return this.email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getName() {
        return this.name;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddress(final Address address) {
        this.address = address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmail(final String email) {
        this.email = email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setName(final String name) {
        this.name = name;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundPayment.DestinationPaymentMethodDetails.BillingDetails)) return false;
        final OutboundPayment.DestinationPaymentMethodDetails.BillingDetails other = (OutboundPayment.DestinationPaymentMethodDetails.BillingDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$address = this.getAddress();
        final java.lang.Object other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundPayment.DestinationPaymentMethodDetails.BillingDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $address = this.getAddress();
        result = result * PRIME + ($address == null ? 43 : $address.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        return result;
      }
    }


    public static class FinancialAccount extends StripeObject implements HasId {
      /**
       * Token of the FinancialAccount.
       */
      @SerializedName("id")
      String id;
      /**
       * The rails used to send funds.
       *
       * <p>Equal to {@code stripe}.
       */
      @SerializedName("network")
      String network;

      /**
       * The rails used to send funds.
       *
       * <p>Equal to {@code stripe}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * Token of the FinancialAccount.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setId(final String id) {
        this.id = id;
      }

      /**
       * The rails used to send funds.
       *
       * <p>Equal to {@code stripe}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundPayment.DestinationPaymentMethodDetails.FinancialAccount)) return false;
        final OutboundPayment.DestinationPaymentMethodDetails.FinancialAccount other = (OutboundPayment.DestinationPaymentMethodDetails.FinancialAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundPayment.DestinationPaymentMethodDetails.FinancialAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        return result;
      }

      /**
       * Token of the FinancialAccount.
       */
      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getId() {
        return this.id;
      }
    }


    public static class UsBankAccount extends StripeObject {
      /**
       * Account holder type: individual or company.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @SerializedName("account_holder_type")
      String accountHolderType;
      /**
       * Account type: checkings or savings. Defaults to checking if omitted.
       *
       * <p>One of {@code checking}, or {@code savings}.
       */
      @SerializedName("account_type")
      String accountType;
      /** Name of the bank associated with the bank account. */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /** Last four digits of the bank account number. */
      @SerializedName("last4")
      String last4;
      /**
       * The US bank account network used to send funds.
       *
       * <p>One of {@code ach}, or {@code us_domestic_wire}.
       */
      @SerializedName("network")
      String network;
      @SerializedName("routing_number")
      String routingNumber;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderType() {
        return this.accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountType() {
        return this.accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderType(final String accountHolderType) {
        this.accountHolderType = accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountType(final String accountType) {
        this.accountType = accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundPayment.DestinationPaymentMethodDetails.UsBankAccount)) return false;
        final OutboundPayment.DestinationPaymentMethodDetails.UsBankAccount other = (OutboundPayment.DestinationPaymentMethodDetails.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderType = this.getAccountHolderType();
        final java.lang.Object other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
        final java.lang.Object this$accountType = this.getAccountType();
        final java.lang.Object other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundPayment.DestinationPaymentMethodDetails.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderType = this.getAccountHolderType();
        result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        final java.lang.Object $accountType = this.getAccountType();
        result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BillingDetails getBillingDetails() {
      return this.billingDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FinancialAccount getFinancialAccount() {
      return this.financialAccount;
    }

    /**
     * The type of the payment method used in the OutboundPayment.
     *
     * <p>One of {@code financial_account}, or {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingDetails(final BillingDetails billingDetails) {
      this.billingDetails = billingDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinancialAccount(final FinancialAccount financialAccount) {
      this.financialAccount = financialAccount;
    }

    /**
     * The type of the payment method used in the OutboundPayment.
     *
     * <p>One of {@code financial_account}, or {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundPayment.DestinationPaymentMethodDetails)) return false;
      final OutboundPayment.DestinationPaymentMethodDetails other = (OutboundPayment.DestinationPaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$billingDetails = this.getBillingDetails();
      final java.lang.Object other$billingDetails = other.getBillingDetails();
      if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
      final java.lang.Object this$financialAccount = this.getFinancialAccount();
      final java.lang.Object other$financialAccount = other.getFinancialAccount();
      if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundPayment.DestinationPaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $billingDetails = this.getBillingDetails();
      result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
      final java.lang.Object $financialAccount = this.getFinancialAccount();
      result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }


  /**
   * Routing number of the bank account.
   */
  public static class EndUserDetails extends StripeObject {
    /**
     * IP address of the user initiating the OutboundPayment. Set if {@code present} is set to
     * {@code true}. IP address collection is required for risk and compliance reasons. This will be
     * used to help determine if the OutboundPayment is authorized or should be blocked.
     */
    @SerializedName("ip_address")
    String ipAddress;
    /**
     * {@code true`` if the OutboundPayment creation request is being made on behalf of an end user
     * by a platform. Otherwise, }false`.
     */
    @SerializedName("present")
    Boolean present;

    /**
     * IP address of the user initiating the OutboundPayment. Set if {@code present} is set to
     * {@code true}. IP address collection is required for risk and compliance reasons. This will be
     * used to help determine if the OutboundPayment is authorized or should be blocked.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIpAddress() {
      return this.ipAddress;
    }

    /**
     * {@code true`` if the OutboundPayment creation request is being made on behalf of an end user
     * by a platform. Otherwise, }false`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPresent() {
      return this.present;
    }

    /**
     * IP address of the user initiating the OutboundPayment. Set if {@code present} is set to
     * {@code true}. IP address collection is required for risk and compliance reasons. This will be
     * used to help determine if the OutboundPayment is authorized or should be blocked.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIpAddress(final String ipAddress) {
      this.ipAddress = ipAddress;
    }

    /**
     * {@code true`` if the OutboundPayment creation request is being made on behalf of an end user
     * by a platform. Otherwise, }false`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPresent(final Boolean present) {
      this.present = present;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundPayment.EndUserDetails)) return false;
      final OutboundPayment.EndUserDetails other = (OutboundPayment.EndUserDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$present = this.getPresent();
      final java.lang.Object other$present = other.getPresent();
      if (this$present == null ? other$present != null : !this$present.equals(other$present)) return false;
      final java.lang.Object this$ipAddress = this.getIpAddress();
      final java.lang.Object other$ipAddress = other.getIpAddress();
      if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundPayment.EndUserDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $present = this.getPresent();
      result = result * PRIME + ($present == null ? 43 : $present.hashCode());
      final java.lang.Object $ipAddress = this.getIpAddress();
      result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
      return result;
    }
  }


  public static class ReturnedDetails extends StripeObject {
    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @SerializedName("code")
    String code;
    /**
     * The Transaction associated with this object.
     */
    @SerializedName("transaction")
    ExpandableField<Transaction> transaction;

    /**
     * Get ID of expandable {@code transaction} object.
     */
    public String getTransaction() {
      return (this.transaction != null) ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
      this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    /**
     * Get expanded {@code transaction}.
     */
    public Transaction getTransactionObject() {
      return (this.transaction != null) ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
      this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
      return this.code;
    }

    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCode(final String code) {
      this.code = code;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundPayment.ReturnedDetails)) return false;
      final OutboundPayment.ReturnedDetails other = (OutboundPayment.ReturnedDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$code = this.getCode();
      final java.lang.Object other$code = other.getCode();
      if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
      final java.lang.Object this$transaction = this.getTransaction();
      final java.lang.Object other$transaction = other.getTransaction();
      if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundPayment.ReturnedDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $code = this.getCode();
      result = result * PRIME + ($code == null ? 43 : $code.hashCode());
      final java.lang.Object $transaction = this.getTransaction();
      result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /**
     * Timestamp describing when an OutboundPayment changed status to {@code canceled}.
     */
    @SerializedName("canceled_at")
    Long canceledAt;
    /**
     * Timestamp describing when an OutboundPayment changed status to {@code failed}.
     */
    @SerializedName("failed_at")
    Long failedAt;
    /**
     * Timestamp describing when an OutboundPayment changed status to {@code posted}.
     */
    @SerializedName("posted_at")
    Long postedAt;
    /**
     * Timestamp describing when an OutboundPayment changed status to {@code returned}.
     */
    @SerializedName("returned_at")
    Long returnedAt;

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCanceledAt() {
      return this.canceledAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFailedAt() {
      return this.failedAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code posted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPostedAt() {
      return this.postedAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code returned}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getReturnedAt() {
      return this.returnedAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceledAt(final Long canceledAt) {
      this.canceledAt = canceledAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailedAt(final Long failedAt) {
      this.failedAt = failedAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code posted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostedAt(final Long postedAt) {
      this.postedAt = postedAt;
    }

    /**
     * Timestamp describing when an OutboundPayment changed status to {@code returned}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnedAt(final Long returnedAt) {
      this.returnedAt = returnedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundPayment.StatusTransitions)) return false;
      final OutboundPayment.StatusTransitions other = (OutboundPayment.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceledAt = this.getCanceledAt();
      final java.lang.Object other$canceledAt = other.getCanceledAt();
      if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
      final java.lang.Object this$failedAt = this.getFailedAt();
      final java.lang.Object other$failedAt = other.getFailedAt();
      if (this$failedAt == null ? other$failedAt != null : !this$failedAt.equals(other$failedAt)) return false;
      final java.lang.Object this$postedAt = this.getPostedAt();
      final java.lang.Object other$postedAt = other.getPostedAt();
      if (this$postedAt == null ? other$postedAt != null : !this$postedAt.equals(other$postedAt)) return false;
      final java.lang.Object this$returnedAt = this.getReturnedAt();
      final java.lang.Object other$returnedAt = other.getReturnedAt();
      if (this$returnedAt == null ? other$returnedAt != null : !this$returnedAt.equals(other$returnedAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundPayment.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceledAt = this.getCanceledAt();
      result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
      final java.lang.Object $failedAt = this.getFailedAt();
      result = result * PRIME + ($failedAt == null ? 43 : $failedAt.hashCode());
      final java.lang.Object $postedAt = this.getPostedAt();
      result = result * PRIME + ($postedAt == null ? 43 : $postedAt.hashCode());
      final java.lang.Object $returnedAt = this.getReturnedAt();
      result = result * PRIME + ($returnedAt == null ? 43 : $returnedAt.hashCode());
      return result;
    }
  }

  public TestHelpers getTestHelpers() {
    return new TestHelpers(this);
  }


  public class TestHelpers {
    private final OutboundPayment resource;

    @Deprecated
    public TestHelpers() {
      this.resource = OutboundPayment.this;
    }

    private TestHelpers(OutboundPayment resource) {
      this.resource = resource;
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail() throws StripeException {
      return fail((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail(RequestOptions options) throws StripeException {
      return fail((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail(Map<String, Object> params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail(OutboundPaymentFailParams params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>failed</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment fail(OutboundPaymentFailParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post() throws StripeException {
      return post((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post(RequestOptions options) throws StripeException {
      return post((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post(Map<String, Object> params) throws StripeException {
      return post(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/post", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post(OutboundPaymentPostParams params) throws StripeException {
      return post(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>posted</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment post(OutboundPaymentPostParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/post", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment() throws StripeException {
      return returnOutboundPayment((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment(RequestOptions options) throws StripeException {
      return returnOutboundPayment((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment(Map<String, Object> params) throws StripeException {
      return returnOutboundPayment(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment(OutboundPaymentReturnOutboundPaymentParams params) throws StripeException {
      return returnOutboundPayment(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundPayment to the <code>returned</code> status. The
     * OutboundPayment must already be in the <code>processing</code> state.
     */
    public OutboundPayment returnOutboundPayment(OutboundPaymentReturnOutboundPaymentParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_payments/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundPayment.class, options);
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCancelable() {
    return this.cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * ID of the <a href="https://stripe.com/docs/api/customers">customer</a> to whom an
   * OutboundPayment is sent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The PaymentMethod via which an OutboundPayment is sent. This field can be empty if the
   * OutboundPayment was created using {@code destination_payment_method_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDestinationPaymentMethod() {
    return this.destinationPaymentMethod;
  }

  /**
   * Details about the PaymentMethod for an OutboundPayment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DestinationPaymentMethodDetails getDestinationPaymentMethodDetails() {
    return this.destinationPaymentMethodDetails;
  }

  /**
   * Details about the end user.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EndUserDetails getEndUserDetails() {
    return this.endUserDetails;
  }

  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpectedArrivalDate() {
    return this.expectedArrivalDate;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedRegulatoryReceiptUrl() {
    return this.hostedRegulatoryReceiptUrl;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_payment}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Details about a returned OutboundPayment. Only set when the status is {@code returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReturnedDetails getReturnedDetails() {
    return this.returnedDetails;
  }

  /**
   * The description that appears on the receiving end for an OutboundPayment (for example, bank
   * statement for external bank transfer).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Current status of the OutboundPayment: {@code processing}, {@code failed}, {@code posted},
   * {@code returned}, {@code canceled}. An OutboundPayment is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundPayment has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundPayment fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelable(final Boolean cancelable) {
    this.cancelable = cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * ID of the <a href="https://stripe.com/docs/api/customers">customer</a> to whom an
   * OutboundPayment is sent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomer(final String customer) {
    this.customer = customer;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * The PaymentMethod via which an OutboundPayment is sent. This field can be empty if the
   * OutboundPayment was created using {@code destination_payment_method_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDestinationPaymentMethod(final String destinationPaymentMethod) {
    this.destinationPaymentMethod = destinationPaymentMethod;
  }

  /**
   * Details about the PaymentMethod for an OutboundPayment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDestinationPaymentMethodDetails(final DestinationPaymentMethodDetails destinationPaymentMethodDetails) {
    this.destinationPaymentMethodDetails = destinationPaymentMethodDetails;
  }

  /**
   * Details about the end user.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndUserDetails(final EndUserDetails endUserDetails) {
    this.endUserDetails = endUserDetails;
  }

  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpectedArrivalDate(final Long expectedArrivalDate) {
    this.expectedArrivalDate = expectedArrivalDate;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedRegulatoryReceiptUrl(final String hostedRegulatoryReceiptUrl) {
    this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_payment}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Details about a returned OutboundPayment. Only set when the status is {@code returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnedDetails(final ReturnedDetails returnedDetails) {
    this.returnedDetails = returnedDetails;
  }

  /**
   * The description that appears on the receiving end for an OutboundPayment (for example, bank
   * statement for external bank transfer).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Current status of the OutboundPayment: {@code processing}, {@code failed}, {@code posted},
   * {@code returned}, {@code canceled}. An OutboundPayment is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundPayment has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundPayment fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof OutboundPayment)) return false;
    final OutboundPayment other = (OutboundPayment) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$cancelable = this.getCancelable();
    final java.lang.Object other$cancelable = other.getCancelable();
    if (this$cancelable == null ? other$cancelable != null : !this$cancelable.equals(other$cancelable)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$expectedArrivalDate = this.getExpectedArrivalDate();
    final java.lang.Object other$expectedArrivalDate = other.getExpectedArrivalDate();
    if (this$expectedArrivalDate == null ? other$expectedArrivalDate != null : !this$expectedArrivalDate.equals(other$expectedArrivalDate)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$destinationPaymentMethod = this.getDestinationPaymentMethod();
    final java.lang.Object other$destinationPaymentMethod = other.getDestinationPaymentMethod();
    if (this$destinationPaymentMethod == null ? other$destinationPaymentMethod != null : !this$destinationPaymentMethod.equals(other$destinationPaymentMethod)) return false;
    final java.lang.Object this$destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
    final java.lang.Object other$destinationPaymentMethodDetails = other.getDestinationPaymentMethodDetails();
    if (this$destinationPaymentMethodDetails == null ? other$destinationPaymentMethodDetails != null : !this$destinationPaymentMethodDetails.equals(other$destinationPaymentMethodDetails)) return false;
    final java.lang.Object this$endUserDetails = this.getEndUserDetails();
    final java.lang.Object other$endUserDetails = other.getEndUserDetails();
    if (this$endUserDetails == null ? other$endUserDetails != null : !this$endUserDetails.equals(other$endUserDetails)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    final java.lang.Object other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
    if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$returnedDetails = this.getReturnedDetails();
    final java.lang.Object other$returnedDetails = other.getReturnedDetails();
    if (this$returnedDetails == null ? other$returnedDetails != null : !this$returnedDetails.equals(other$returnedDetails)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof OutboundPayment;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $cancelable = this.getCancelable();
    result = result * PRIME + ($cancelable == null ? 43 : $cancelable.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $expectedArrivalDate = this.getExpectedArrivalDate();
    result = result * PRIME + ($expectedArrivalDate == null ? 43 : $expectedArrivalDate.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $destinationPaymentMethod = this.getDestinationPaymentMethod();
    result = result * PRIME + ($destinationPaymentMethod == null ? 43 : $destinationPaymentMethod.hashCode());
    final java.lang.Object $destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
    result = result * PRIME + ($destinationPaymentMethodDetails == null ? 43 : $destinationPaymentMethodDetails.hashCode());
    final java.lang.Object $endUserDetails = this.getEndUserDetails();
    result = result * PRIME + ($endUserDetails == null ? 43 : $endUserDetails.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    result = result * PRIME + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $returnedDetails = this.getReturnedDetails();
    result = result * PRIME + ($returnedDetails == null ? 43 : $returnedDetails.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
