// Generated by delombok at Tue Sep 29 23:04:00 PDT 2020
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SetupAttemptListParams;
import java.util.Map;

public class SetupAttempt extends ApiResource implements HasId {
  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-application">application</a>
   * on the SetupIntent at the time of this confirmation.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-customer">customer</a>
   * on the SetupIntent at the time of this confirmation.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_attempt}.
   */
  @SerializedName("object")
  String object;
  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-on_behalf_of">on_behalf_of</a>
   * on the SetupIntent at the time of this confirmation.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the payment method used with this SetupAttempt.
   */
  @SerializedName("payment_method")
  ExpandableField<PaymentMethod> paymentMethod;
  @SerializedName("payment_method_details")
  PaymentMethodDetails paymentMethodDetails;
  /**
   * The error encountered during this attempt to confirm the SetupIntent, if any.
   */
  @SerializedName("setup_error")
  StripeError setupError;
  /**
   * ID of the SetupIntent that this attempt belongs to.
   */
  @SerializedName("setup_intent")
  ExpandableField<SetupIntent> setupIntent;
  /**
   * Status of this SetupAttempt, one of {@code requires_confirmation}, {@code requires_action},
   * {@code processing}, {@code succeeded}, {@code failed}, or {@code abandoned}.
   */
  @SerializedName("status")
  String status;
  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-usage">usage</a> on
   * the SetupIntent at the time of this confirmation, one of {@code off_session} or {@code
   * on_session}.
   */
  @SerializedName("usage")
  String usage;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentMethod} object.
   */
  public String getPaymentMethod() {
    return (this.paymentMethod != null) ? this.paymentMethod.getId() : null;
  }

  public void setPaymentMethod(String id) {
    this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
  }

  /**
   * Get expanded {@code paymentMethod}.
   */
  public PaymentMethod getPaymentMethodObject() {
    return (this.paymentMethod != null) ? this.paymentMethod.getExpanded() : null;
  }

  public void setPaymentMethodObject(PaymentMethod expandableObject) {
    this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code setupIntent} object.
   */
  public String getSetupIntent() {
    return (this.setupIntent != null) ? this.setupIntent.getId() : null;
  }

  public void setSetupIntent(String id) {
    this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
  }

  /**
   * Get expanded {@code setupIntent}.
   */
  public SetupIntent getSetupIntentObject() {
    return (this.setupIntent != null) ? this.setupIntent.getExpanded() : null;
  }

  public void setSetupIntentObject(SetupIntent expandableObject) {
    this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of SetupAttempts associated with a provided SetupIntent.
   */
  public static SetupAttemptCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of SetupAttempts associated with a provided SetupIntent.
   */
  public static SetupAttemptCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_attempts");
    return ApiResource.requestCollection(url, params, SetupAttemptCollection.class, options);
  }

  /**
   * Returns a list of SetupAttempts associated with a provided SetupIntent.
   */
  public static SetupAttemptCollection list(SetupAttemptListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of SetupAttempts associated with a provided SetupIntent.
   */
  public static SetupAttemptCollection list(SetupAttemptListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_attempts");
    return ApiResource.requestCollection(url, params, SetupAttemptCollection.class, options);
  }


  public static class PaymentMethodDetails extends StripeObject {
    @SerializedName("card")
    Card card;
    /**
     * The type of the payment method used in the SetupIntent (e.g., {@code card}). An additional
     * hash is included on {@code payment_method_details} with a name matching this value. It
     * contains confirmation-specific information for the payment method.
     */
    @SerializedName("type")
    String type;


    public static class Card extends StripeObject {
      /** Populated if this authorization used 3D Secure authentication. */
      @SerializedName("three_d_secure")
      Charge.PaymentMethodDetails.Card.ThreeDSecure threeDSecure;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Charge.PaymentMethodDetails.Card.ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setThreeDSecure(final Charge.PaymentMethodDetails.Card.ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SetupAttempt.PaymentMethodDetails.Card)) return false;
        final SetupAttempt.PaymentMethodDetails.Card other = (SetupAttempt.PaymentMethodDetails.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$threeDSecure = this.getThreeDSecure();
        final java.lang.Object other$threeDSecure = other.getThreeDSecure();
        if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SetupAttempt.PaymentMethodDetails.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $threeDSecure = this.getThreeDSecure();
        result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SetupAttempt.PaymentMethodDetails)) return false;
      final SetupAttempt.PaymentMethodDetails other = (SetupAttempt.PaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SetupAttempt.PaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_attempt}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodDetails getPaymentMethodDetails() {
    return this.paymentMethodDetails;
  }

  /**
   * The error encountered during this attempt to confirm the SetupIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getSetupError() {
    return this.setupError;
  }

  /**
   * Status of this SetupAttempt, one of {@code requires_confirmation}, {@code requires_action},
   * {@code processing}, {@code succeeded}, {@code failed}, or {@code abandoned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-usage">usage</a> on
   * the SetupIntent at the time of this confirmation, one of {@code off_session} or {@code
   * on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUsage() {
    return this.usage;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code setup_attempt}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodDetails(final PaymentMethodDetails paymentMethodDetails) {
    this.paymentMethodDetails = paymentMethodDetails;
  }

  /**
   * The error encountered during this attempt to confirm the SetupIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSetupError(final StripeError setupError) {
    this.setupError = setupError;
  }

  /**
   * Status of this SetupAttempt, one of {@code requires_confirmation}, {@code requires_action},
   * {@code processing}, {@code succeeded}, {@code failed}, or {@code abandoned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The value of <a
   * href="https://stripe.com/docs/api/setup_intents/object#setup_intent_object-usage">usage</a> on
   * the SetupIntent at the time of this confirmation, one of {@code off_session} or {@code
   * on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUsage(final String usage) {
    this.usage = usage;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SetupAttempt)) return false;
    final SetupAttempt other = (SetupAttempt) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodDetails = this.getPaymentMethodDetails();
    final java.lang.Object other$paymentMethodDetails = other.getPaymentMethodDetails();
    if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !this$paymentMethodDetails.equals(other$paymentMethodDetails)) return false;
    final java.lang.Object this$setupError = this.getSetupError();
    final java.lang.Object other$setupError = other.getSetupError();
    if (this$setupError == null ? other$setupError != null : !this$setupError.equals(other$setupError)) return false;
    final java.lang.Object this$setupIntent = this.getSetupIntent();
    final java.lang.Object other$setupIntent = other.getSetupIntent();
    if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$usage = this.getUsage();
    final java.lang.Object other$usage = other.getUsage();
    if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SetupAttempt;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodDetails = this.getPaymentMethodDetails();
    result = result * PRIME + ($paymentMethodDetails == null ? 43 : $paymentMethodDetails.hashCode());
    final java.lang.Object $setupError = this.getSetupError();
    result = result * PRIME + ($setupError == null ? 43 : $setupError.hashCode());
    final java.lang.Object $setupIntent = this.getSetupIntent();
    result = result * PRIME + ($setupIntent == null ? 43 : $setupIntent.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $usage = this.getUsage();
    result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
