/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.CashBalance;
import com.stripe.model.CustomerBalanceTransaction;
import com.stripe.model.CustomerBalanceTransactionCollection;
import com.stripe.model.CustomerCollection;
import com.stripe.model.CustomerSearchResult;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.FundingInstructions;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentMethodCollection;
import com.stripe.model.PaymentSource;
import com.stripe.model.PaymentSourceCollection;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.TaxIdCollection;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CustomerBalanceTransactionsParams;
import com.stripe.param.CustomerCreateFundingInstructionsParams;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerFundCashBalanceParams;
import com.stripe.param.CustomerListParams;
import com.stripe.param.CustomerListPaymentMethodsParams;
import com.stripe.param.CustomerRetrieveParams;
import com.stripe.param.CustomerRetrievePaymentMethodParams;
import com.stripe.param.CustomerSearchParams;
import com.stripe.param.CustomerUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Customer
extends ApiResource
implements HasId,
MetadataStore<Customer> {
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="balance")
    Long balance;
    @SerializedName(value="cash_balance")
    CashBalance cashBalance;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="delinquent")
    Boolean delinquent;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discount")
    Discount discount;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice_prefix")
    String invoicePrefix;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="next_invoice_sequence")
    Long nextInvoiceSequence;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phone")
    String phone;
    @SerializedName(value="preferred_locales")
    List<String> preferredLocales;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="sources")
    PaymentSourceCollection sources;
    @SerializedName(value="subscriptions")
    SubscriptionCollection subscriptions;
    @SerializedName(value="tax")
    Tax tax;
    @SerializedName(value="tax_exempt")
    String taxExempt;
    @SerializedName(value="tax_ids")
    TaxIdCollection taxIds;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public static CustomerSearchResult search(Map<String, Object> params) throws StripeException {
        return Customer.search(params, (RequestOptions)null);
    }

    public static CustomerSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers/search");
        return ApiResource.requestSearchResult(url, params, CustomerSearchResult.class, options);
    }

    public static CustomerSearchResult search(CustomerSearchParams params) throws StripeException {
        return Customer.search(params, (RequestOptions)null);
    }

    public static CustomerSearchResult search(CustomerSearchParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers/search");
        return ApiResource.requestSearchResult(url, params, CustomerSearchResult.class, options);
    }

    public static CustomerCollection list(Map<String, Object> params) throws StripeException {
        return Customer.list(params, (RequestOptions)null);
    }

    public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return ApiResource.requestCollection(url, params, CustomerCollection.class, options);
    }

    public static CustomerCollection list(CustomerListParams params) throws StripeException {
        return Customer.list(params, (RequestOptions)null);
    }

    public static CustomerCollection list(CustomerListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return ApiResource.requestCollection(url, params, CustomerCollection.class, options);
    }

    public static Customer create(Map<String, Object> params) throws StripeException {
        return Customer.create(params, (RequestOptions)null);
    }

    public static Customer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public static Customer create(CustomerCreateParams params) throws StripeException {
        return Customer.create(params, (RequestOptions)null);
    }

    public static Customer create(CustomerCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public static Customer retrieve(String customer) throws StripeException {
        return Customer.retrieve(customer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Customer retrieve(String customer, RequestOptions options) throws StripeException {
        return Customer.retrieve(customer, (Map<String, Object>)null, options);
    }

    public static Customer retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
    }

    public static Customer retrieve(String customer, CustomerRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
    }

    public Customer update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Customer update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public Customer update(CustomerUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Customer update(CustomerUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public Customer delete() throws StripeException {
        return this.delete(null, null);
    }

    public Customer delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Customer delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Customer delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Customer.class, options);
    }

    public PaymentMethodCollection listPaymentMethods(Map<String, Object> params) throws StripeException {
        return this.listPaymentMethods(params, (RequestOptions)null);
    }

    public PaymentMethodCollection listPaymentMethods(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/payment_methods", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public PaymentMethodCollection listPaymentMethods(CustomerListPaymentMethodsParams params) throws StripeException {
        return this.listPaymentMethods(params, (RequestOptions)null);
    }

    public PaymentMethodCollection listPaymentMethods(CustomerListPaymentMethodsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/payment_methods", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public PaymentMethod retrievePaymentMethod(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/payment_methods/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod retrievePaymentMethod(String customer, CustomerRetrievePaymentMethodParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/payment_methods/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public CustomerBalanceTransactionCollection balanceTransactions() throws StripeException {
        return this.balanceTransactions((Map<String, Object>)null, (RequestOptions)null);
    }

    public CustomerBalanceTransactionCollection balanceTransactions(Map<String, Object> params) throws StripeException {
        return this.balanceTransactions(params, (RequestOptions)null);
    }

    public CustomerBalanceTransactionCollection balanceTransactions(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, CustomerBalanceTransactionCollection.class, options);
    }

    public CustomerBalanceTransactionCollection balanceTransactions(CustomerBalanceTransactionsParams params) throws StripeException {
        return this.balanceTransactions(params, (RequestOptions)null);
    }

    public CustomerBalanceTransactionCollection balanceTransactions(CustomerBalanceTransactionsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, CustomerBalanceTransactionCollection.class, options);
    }

    public FundingInstructions createFundingInstructions(Map<String, Object> params) throws StripeException {
        return this.createFundingInstructions(params, (RequestOptions)null);
    }

    public FundingInstructions createFundingInstructions(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/funding_instructions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FundingInstructions.class, options);
    }

    public FundingInstructions createFundingInstructions(CustomerCreateFundingInstructionsParams params) throws StripeException {
        return this.createFundingInstructions(params, (RequestOptions)null);
    }

    public FundingInstructions createFundingInstructions(CustomerCreateFundingInstructionsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/funding_instructions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FundingInstructions.class, options);
    }

    public Discount deleteDiscount() throws StripeException {
        return this.deleteDiscount(null, null);
    }

    public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
        return this.deleteDiscount(params, null);
    }

    public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/discount", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public Long getBalance() {
        return this.balance;
    }

    @Generated
    public CashBalance getCashBalance() {
        return this.cashBalance;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDelinquent() {
        return this.delinquent;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getInvoicePrefix() {
        return this.invoicePrefix;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getNextInvoiceSequence() {
        return this.nextInvoiceSequence;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public List<String> getPreferredLocales() {
        return this.preferredLocales;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public PaymentSourceCollection getSources() {
        return this.sources;
    }

    @Generated
    public SubscriptionCollection getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public Tax getTax() {
        return this.tax;
    }

    @Generated
    public String getTaxExempt() {
        return this.taxExempt;
    }

    @Generated
    public TaxIdCollection getTaxIds() {
        return this.taxIds;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    @Generated
    public void setCashBalance(CashBalance cashBalance) {
        this.cashBalance = cashBalance;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoicePrefix(String invoicePrefix) {
        this.invoicePrefix = invoicePrefix;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNextInvoiceSequence(Long nextInvoiceSequence) {
        this.nextInvoiceSequence = nextInvoiceSequence;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setPreferredLocales(List<String> preferredLocales) {
        this.preferredLocales = preferredLocales;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSources(PaymentSourceCollection sources) {
        this.sources = sources;
    }

    @Generated
    public void setSubscriptions(SubscriptionCollection subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setTax(Tax tax) {
        this.tax = tax;
    }

    @Generated
    public void setTaxExempt(String taxExempt) {
        this.taxExempt = taxExempt;
    }

    @Generated
    public void setTaxIds(TaxIdCollection taxIds) {
        this.taxIds = taxIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$balance = this.getBalance();
        Long other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$delinquent = this.getDelinquent();
        Boolean other$delinquent = other.getDelinquent();
        if (this$delinquent == null ? other$delinquent != null : !((Object)this$delinquent).equals(other$delinquent)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$nextInvoiceSequence = this.getNextInvoiceSequence();
        Long other$nextInvoiceSequence = other.getNextInvoiceSequence();
        if (this$nextInvoiceSequence == null ? other$nextInvoiceSequence != null : !((Object)this$nextInvoiceSequence).equals(other$nextInvoiceSequence)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        CashBalance this$cashBalance = this.getCashBalance();
        CashBalance other$cashBalance = other.getCashBalance();
        if (this$cashBalance == null ? other$cashBalance != null : !((Object)this$cashBalance).equals(other$cashBalance)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoicePrefix = this.getInvoicePrefix();
        String other$invoicePrefix = other.getInvoicePrefix();
        if (this$invoicePrefix == null ? other$invoicePrefix != null : !this$invoicePrefix.equals(other$invoicePrefix)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        List<String> this$preferredLocales = this.getPreferredLocales();
        List<String> other$preferredLocales = other.getPreferredLocales();
        if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        PaymentSourceCollection this$sources = this.getSources();
        PaymentSourceCollection other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        SubscriptionCollection this$subscriptions = this.getSubscriptions();
        SubscriptionCollection other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        Tax this$tax = this.getTax();
        Tax other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        String this$taxExempt = this.getTaxExempt();
        String other$taxExempt = other.getTaxExempt();
        if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) {
            return false;
        }
        TaxIdCollection this$taxIds = this.getTaxIds();
        TaxIdCollection other$taxIds = other.getTaxIds();
        if (this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        return !(this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $delinquent = this.getDelinquent();
        result = result * 59 + ($delinquent == null ? 43 : ((Object)$delinquent).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $nextInvoiceSequence = this.getNextInvoiceSequence();
        result = result * 59 + ($nextInvoiceSequence == null ? 43 : ((Object)$nextInvoiceSequence).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        CashBalance $cashBalance = this.getCashBalance();
        result = result * 59 + ($cashBalance == null ? 43 : ((Object)$cashBalance).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoicePrefix = this.getInvoicePrefix();
        result = result * 59 + ($invoicePrefix == null ? 43 : $invoicePrefix.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        List<String> $preferredLocales = this.getPreferredLocales();
        result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        PaymentSourceCollection $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        SubscriptionCollection $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        Tax $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        String $taxExempt = this.getTaxExempt();
        result = result * 59 + ($taxExempt == null ? 43 : $taxExempt.hashCode());
        TaxIdCollection $taxIds = this.getTaxIds();
        result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Customer resource;

        private TestHelpers(Customer resource) {
            this.resource = resource;
        }

        public CustomerBalanceTransaction fundCashBalance(Map<String, Object> params) throws StripeException {
            return this.fundCashBalance(params, (RequestOptions)null);
        }

        public CustomerBalanceTransaction fundCashBalance(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/customers/%s/fund_cash_balance", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CustomerBalanceTransaction.class, options);
        }

        public CustomerBalanceTransaction fundCashBalance(CustomerFundCashBalanceParams params) throws StripeException {
            return this.fundCashBalance(params, (RequestOptions)null);
        }

        public CustomerBalanceTransaction fundCashBalance(CustomerFundCashBalanceParams params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/customers/%s/fund_cash_balance", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CustomerBalanceTransaction.class, options);
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="custom_fields")
        List<Invoice.CustomField> customFields;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="footer")
        String footer;
        @SerializedName(value="rendering_options")
        Invoice.RenderingOptions renderingOptions;

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<Invoice.CustomField> getCustomFields() {
            return this.customFields;
        }

        @Generated
        public String getFooter() {
            return this.footer;
        }

        @Generated
        public Invoice.RenderingOptions getRenderingOptions() {
            return this.renderingOptions;
        }

        @Generated
        public void setCustomFields(List<Invoice.CustomField> customFields) {
            this.customFields = customFields;
        }

        @Generated
        public void setFooter(String footer) {
            this.footer = footer;
        }

        @Generated
        public void setRenderingOptions(Invoice.RenderingOptions renderingOptions) {
            this.renderingOptions = renderingOptions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Invoice.CustomField> this$customFields = this.getCustomFields();
            List<Invoice.CustomField> other$customFields = other.getCustomFields();
            if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            String this$footer = this.getFooter();
            String other$footer = other.getFooter();
            if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                return false;
            }
            Invoice.RenderingOptions this$renderingOptions = this.getRenderingOptions();
            Invoice.RenderingOptions other$renderingOptions = other.getRenderingOptions();
            return !(this$renderingOptions == null ? other$renderingOptions != null : !((Object)this$renderingOptions).equals(other$renderingOptions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Invoice.CustomField> $customFields = this.getCustomFields();
            result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            String $footer = this.getFooter();
            result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
            Invoice.RenderingOptions $renderingOptions = this.getRenderingOptions();
            result = result * 59 + ($renderingOptions == null ? 43 : ((Object)$renderingOptions).hashCode());
            return result;
        }
    }

    public static class Tax
    extends StripeObject {
        @SerializedName(value="automatic_tax")
        String automaticTax;
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="location")
        Location location;

        @Generated
        public String getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public Location getLocation() {
            return this.location;
        }

        @Generated
        public void setAutomaticTax(String automaticTax) {
            this.automaticTax = automaticTax;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setLocation(Location location) {
            this.location = location;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tax)) {
                return false;
            }
            Tax other = (Tax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$automaticTax = this.getAutomaticTax();
            String other$automaticTax = other.getAutomaticTax();
            if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $automaticTax = this.getAutomaticTax();
            result = result * 59 + ($automaticTax == null ? 43 : $automaticTax.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            return result;
        }

        public static class Location
        extends StripeObject {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="source")
            String source;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getSource() {
                return this.source;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setSource(String source) {
                this.source = source;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Location)) {
                    return false;
                }
                Location other = (Location)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$source = this.getSource();
                String other$source = other.getSource();
                if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Location;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $source = this.getSource();
                result = result * 59 + ($source == null ? 43 : $source.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }
    }
}

