// Generated by delombok at Thu Jul 07 22:24:36 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionItemCreateParams;
import com.stripe.param.SubscriptionItemDeleteParams;
import com.stripe.param.SubscriptionItemListParams;
import com.stripe.param.SubscriptionItemRetrieveParams;
import com.stripe.param.SubscriptionItemUpdateParams;
import com.stripe.param.SubscriptionItemUsageRecordSummariesParams;
import java.util.List;
import java.util.Map;

public class SubscriptionItem extends ApiResource implements HasId, MetadataStore<SubscriptionItem> {
  /**
   * Define thresholds at which an invoice will be sent, and the related subscription advanced to a
   * new billing period.
   */
  @SerializedName("billing_thresholds")
  BillingThresholds billingThresholds;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_item}.
   */
  @SerializedName("object")
  String object;
  /**
   * You can now model subscriptions more flexibly using the <a
   * href="https://stripe.com/docs/api#prices">Prices API</a>. It replaces the Plans API and is
   * backwards compatible to simplify your migration.
   *
   * <p>Plans define the base price, currency, and billing cycle for recurring purchases of
   * products. <a href="https://stripe.com/docs/api#products">Products</a> help you track inventory
   * or provisioning, and plans help you track pricing. Different physical goods or levels of
   * service should be represented by products, and pricing options should be represented by plans.
   * This approach lets you change prices without having to change your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has plans for $10/month,
   * $100/year, €9/month, and €90/year.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a> and more about <a
   * href="https://stripe.com/docs/products-prices/overview">products and prices</a>.
   */
  @SerializedName("plan")
  Plan plan;
  /**
   * Prices define the unit cost, currency, and (optional) billing cycle for both recurring and
   * one-time purchases of products. <a href="https://stripe.com/docs/api#products">Products</a>
   * help you track inventory or provisioning, and prices help you track payment terms. Different
   * physical goods or levels of service should be represented by products, and pricing options
   * should be represented by prices. This approach lets you change prices without having to change
   * your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has prices for $10/month,
   * $100/year, and €9 once.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a>, <a href="https://stripe.com/docs/billing/invoices/create">create an
   * invoice</a>, and more about <a href="https://stripe.com/docs/products-prices/overview">products
   * and prices</a>.
   */
  @SerializedName("price")
  Price price;
  /**
   * The <a href="https://stripe.com/docs/subscriptions/quantities">quantity</a> of the plan to
   * which the customer should be subscribed.
   */
  @SerializedName("quantity")
  Long quantity;
  /**
   * The {@code subscription} this {@code subscription_item} belongs to.
   */
  @SerializedName("subscription")
  String subscription;
  /**
   * The tax rates which apply to this {@code subscription_item}. When set, the {@code
   * default_tax_rates} on the subscription do not apply to this {@code subscription_item}.
   */
  @SerializedName("tax_rates")
  List<TaxRate> taxRates;

  /**
   * Returns a list of your subscription items for a given subscription.
   */
  public static SubscriptionItemCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your subscription items for a given subscription.
   */
  public static SubscriptionItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
    return ApiResource.requestCollection(url, params, SubscriptionItemCollection.class, options);
  }

  /**
   * Returns a list of your subscription items for a given subscription.
   */
  public static SubscriptionItemCollection list(SubscriptionItemListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your subscription items for a given subscription.
   */
  public static SubscriptionItemCollection list(SubscriptionItemListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
    return ApiResource.requestCollection(url, params, SubscriptionItemCollection.class, options);
  }

  /**
   * Retrieves the subscription item with the given ID.
   */
  public static SubscriptionItem retrieve(String item) throws StripeException {
    return retrieve(item, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the subscription item with the given ID.
   */
  public static SubscriptionItem retrieve(String item, RequestOptions options) throws StripeException {
    return retrieve(item, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the subscription item with the given ID.
   */
  public static SubscriptionItem retrieve(String item, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionItem.class, options);
  }

  /**
   * Retrieves the subscription item with the given ID.
   */
  public static SubscriptionItem retrieve(String item, SubscriptionItemRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionItem.class, options);
  }

  /**
   * Adds a new item to an existing subscription. No existing items will be changed or replaced.
   */
  public static SubscriptionItem create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Adds a new item to an existing subscription. No existing items will be changed or replaced.
   */
  public static SubscriptionItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
  }

  /**
   * Adds a new item to an existing subscription. No existing items will be changed or replaced.
   */
  public static SubscriptionItem create(SubscriptionItemCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Adds a new item to an existing subscription. No existing items will be changed or replaced.
   */
  public static SubscriptionItem create(SubscriptionItemCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
  }

  /**
   * Updates the plan or quantity of an item on a current subscription.
   */
  @Override
  public SubscriptionItem update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the plan or quantity of an item on a current subscription.
   */
  @Override
  public SubscriptionItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
  }

  /**
   * Updates the plan or quantity of an item on a current subscription.
   */
  public SubscriptionItem update(SubscriptionItemUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the plan or quantity of an item on a current subscription.
   */
  public SubscriptionItem update(SubscriptionItemUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, SubscriptionItem.class, options);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete(SubscriptionItemDeleteParams params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes an item from the subscription. Removing a subscription item from a subscription will
   * not cancel the subscription.
   */
  public SubscriptionItem delete(SubscriptionItemDeleteParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, SubscriptionItem.class, options);
  }

  /**
   * For the specified subscription item, returns a list of summary objects. Each object in the list
   * provides usage information that’s been summarized from multiple usage records and over a
   * subscription billing period (e.g., 15 usage records in the month of September).
   *
   * <p>The list is sorted in reverse-chronological order (newest first). The first list item
   * represents the most current usage period that hasn’t ended yet. Since new usage records can
   * still be added, the returned summary information for the subscription item’s ID should be seen
   * as unstable until the subscription billing period ends.
   */
  public UsageRecordSummaryCollection usageRecordSummaries() throws StripeException {
    return usageRecordSummaries((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * For the specified subscription item, returns a list of summary objects. Each object in the list
   * provides usage information that’s been summarized from multiple usage records and over a
   * subscription billing period (e.g., 15 usage records in the month of September).
   *
   * <p>The list is sorted in reverse-chronological order (newest first). The first list item
   * represents the most current usage period that hasn’t ended yet. Since new usage records can
   * still be added, the returned summary information for the subscription item’s ID should be seen
   * as unstable until the subscription billing period ends.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params) throws StripeException {
    return usageRecordSummaries(params, (RequestOptions) null);
  }

  /**
   * For the specified subscription item, returns a list of summary objects. Each object in the list
   * provides usage information that’s been summarized from multiple usage records and over a
   * subscription billing period (e.g., 15 usage records in the month of September).
   *
   * <p>The list is sorted in reverse-chronological order (newest first). The first list item
   * represents the most current usage period that hasn’t ended yet. Since new usage records can
   * still be added, the returned summary information for the subscription item’s ID should be seen
   * as unstable until the subscription billing period ends.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, UsageRecordSummaryCollection.class, options);
  }

  /**
   * For the specified subscription item, returns a list of summary objects. Each object in the list
   * provides usage information that’s been summarized from multiple usage records and over a
   * subscription billing period (e.g., 15 usage records in the month of September).
   *
   * <p>The list is sorted in reverse-chronological order (newest first). The first list item
   * represents the most current usage period that hasn’t ended yet. Since new usage records can
   * still be added, the returned summary information for the subscription item’s ID should be seen
   * as unstable until the subscription billing period ends.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params) throws StripeException {
    return usageRecordSummaries(params, (RequestOptions) null);
  }

  /**
   * For the specified subscription item, returns a list of summary objects. Each object in the list
   * provides usage information that’s been summarized from multiple usage records and over a
   * subscription billing period (e.g., 15 usage records in the month of September).
   *
   * <p>The list is sorted in reverse-chronological order (newest first). The first list item
   * represents the most current usage period that hasn’t ended yet. Since new usage records can
   * still be added, the returned summary information for the subscription item’s ID should be seen
   * as unstable until the subscription billing period ends.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, UsageRecordSummaryCollection.class, options);
  }


  public static class BillingThresholds extends StripeObject {
    /** Usage threshold that triggers the subscription to create an invoice. */
    @SerializedName("usage_gte")
    Long usageGte;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUsageGte() {
      return this.usageGte;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsageGte(final Long usageGte) {
      this.usageGte = usageGte;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionItem.BillingThresholds)) return false;
      final SubscriptionItem.BillingThresholds other = (SubscriptionItem.BillingThresholds) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$usageGte = this.getUsageGte();
      final java.lang.Object other$usageGte = other.getUsageGte();
      if (this$usageGte == null ? other$usageGte != null : !this$usageGte.equals(other$usageGte)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionItem.BillingThresholds;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $usageGte = this.getUsageGte();
      result = result * PRIME + ($usageGte == null ? 43 : $usageGte.hashCode());
      return result;
    }
  }

  /**
   * Define thresholds at which an invoice will be sent, and the related subscription advanced to a
   * new billing period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingThresholds getBillingThresholds() {
    return this.billingThresholds;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * You can now model subscriptions more flexibly using the <a
   * href="https://stripe.com/docs/api#prices">Prices API</a>. It replaces the Plans API and is
   * backwards compatible to simplify your migration.
   *
   * <p>Plans define the base price, currency, and billing cycle for recurring purchases of
   * products. <a href="https://stripe.com/docs/api#products">Products</a> help you track inventory
   * or provisioning, and plans help you track pricing. Different physical goods or levels of
   * service should be represented by products, and pricing options should be represented by plans.
   * This approach lets you change prices without having to change your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has plans for $10/month,
   * $100/year, €9/month, and €90/year.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a> and more about <a
   * href="https://stripe.com/docs/products-prices/overview">products and prices</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Plan getPlan() {
    return this.plan;
  }

  /**
   * Prices define the unit cost, currency, and (optional) billing cycle for both recurring and
   * one-time purchases of products. <a href="https://stripe.com/docs/api#products">Products</a>
   * help you track inventory or provisioning, and prices help you track payment terms. Different
   * physical goods or levels of service should be represented by products, and pricing options
   * should be represented by prices. This approach lets you change prices without having to change
   * your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has prices for $10/month,
   * $100/year, and €9 once.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a>, <a href="https://stripe.com/docs/billing/invoices/create">create an
   * invoice</a>, and more about <a href="https://stripe.com/docs/products-prices/overview">products
   * and prices</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Price getPrice() {
    return this.price;
  }

  /**
   * The <a href="https://stripe.com/docs/subscriptions/quantities">quantity</a> of the plan to
   * which the customer should be subscribed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  /**
   * The {@code subscription} this {@code subscription_item} belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscription() {
    return this.subscription;
  }

  /**
   * The tax rates which apply to this {@code subscription_item}. When set, the {@code
   * default_tax_rates} on the subscription do not apply to this {@code subscription_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<TaxRate> getTaxRates() {
    return this.taxRates;
  }

  /**
   * Define thresholds at which an invoice will be sent, and the related subscription advanced to a
   * new billing period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingThresholds(final BillingThresholds billingThresholds) {
    this.billingThresholds = billingThresholds;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * You can now model subscriptions more flexibly using the <a
   * href="https://stripe.com/docs/api#prices">Prices API</a>. It replaces the Plans API and is
   * backwards compatible to simplify your migration.
   *
   * <p>Plans define the base price, currency, and billing cycle for recurring purchases of
   * products. <a href="https://stripe.com/docs/api#products">Products</a> help you track inventory
   * or provisioning, and plans help you track pricing. Different physical goods or levels of
   * service should be represented by products, and pricing options should be represented by plans.
   * This approach lets you change prices without having to change your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has plans for $10/month,
   * $100/year, €9/month, and €90/year.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a> and more about <a
   * href="https://stripe.com/docs/products-prices/overview">products and prices</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlan(final Plan plan) {
    this.plan = plan;
  }

  /**
   * Prices define the unit cost, currency, and (optional) billing cycle for both recurring and
   * one-time purchases of products. <a href="https://stripe.com/docs/api#products">Products</a>
   * help you track inventory or provisioning, and prices help you track payment terms. Different
   * physical goods or levels of service should be represented by products, and pricing options
   * should be represented by prices. This approach lets you change prices without having to change
   * your provisioning scheme.
   *
   * <p>For example, you might have a single &quot;gold&quot; product that has prices for $10/month,
   * $100/year, and €9 once.
   *
   * <p>Related guides: <a
   * href="https://stripe.com/docs/billing/subscriptions/set-up-subscription">Set up a
   * subscription</a>, <a href="https://stripe.com/docs/billing/invoices/create">create an
   * invoice</a>, and more about <a href="https://stripe.com/docs/products-prices/overview">products
   * and prices</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrice(final Price price) {
    this.price = price;
  }

  /**
   * The <a href="https://stripe.com/docs/subscriptions/quantities">quantity</a> of the plan to
   * which the customer should be subscribed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  /**
   * The {@code subscription} this {@code subscription_item} belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscription(final String subscription) {
    this.subscription = subscription;
  }

  /**
   * The tax rates which apply to this {@code subscription_item}. When set, the {@code
   * default_tax_rates} on the subscription do not apply to this {@code subscription_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxRates(final List<TaxRate> taxRates) {
    this.taxRates = taxRates;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SubscriptionItem)) return false;
    final SubscriptionItem other = (SubscriptionItem) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$billingThresholds = this.getBillingThresholds();
    final java.lang.Object other$billingThresholds = other.getBillingThresholds();
    if (this$billingThresholds == null ? other$billingThresholds != null : !this$billingThresholds.equals(other$billingThresholds)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$plan = this.getPlan();
    final java.lang.Object other$plan = other.getPlan();
    if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
    final java.lang.Object this$price = this.getPrice();
    final java.lang.Object other$price = other.getPrice();
    if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$taxRates = this.getTaxRates();
    final java.lang.Object other$taxRates = other.getTaxRates();
    if (this$taxRates == null ? other$taxRates != null : !this$taxRates.equals(other$taxRates)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SubscriptionItem;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $billingThresholds = this.getBillingThresholds();
    result = result * PRIME + ($billingThresholds == null ? 43 : $billingThresholds.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $plan = this.getPlan();
    result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
    final java.lang.Object $price = this.getPrice();
    result = result * PRIME + ($price == null ? 43 : $price.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $taxRates = this.getTaxRates();
    result = result * PRIME + ($taxRates == null ? 43 : $taxRates.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
