// Generated by delombok at Tue Jul 12 20:15:49 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.apps;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.apps.SecretCreateParams;
import com.stripe.param.apps.SecretDeleteWhereParams;
import com.stripe.param.apps.SecretFindParams;
import com.stripe.param.apps.SecretListParams;
import java.util.Map;

public class Secret extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * If true, indicates that this secret has been deleted.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * A name for the secret that's unique within the scope.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code apps.secret}.
   */
  @SerializedName("object")
  String object;
  /**
   * The plaintext secret value to be stored.
   */
  @SerializedName("payload")
  String payload;
  @SerializedName("scope")
  Scope scope;

  /**
   * Finds a secret in the secret store by name and scope.
   */
  public static Secret find(Map<String, Object> params) throws StripeException {
    return find(params, (RequestOptions) null);
  }

  /**
   * Finds a secret in the secret store by name and scope.
   */
  public static Secret find(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets/find");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Secret.class, options);
  }

  /**
   * Finds a secret in the secret store by name and scope.
   */
  public static Secret find(SecretFindParams params) throws StripeException {
    return find(params, (RequestOptions) null);
  }

  /**
   * Finds a secret in the secret store by name and scope.
   */
  public static Secret find(SecretFindParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets/find");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Secret.class, options);
  }

  /**
   * Create or replace a secret in the secret store.
   */
  public static Secret create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create or replace a secret in the secret store.
   */
  public static Secret create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Secret.class, options);
  }

  /**
   * Create or replace a secret in the secret store.
   */
  public static Secret create(SecretCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create or replace a secret in the secret store.
   */
  public static Secret create(SecretCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Secret.class, options);
  }

  /**
   * Deletes a secret from the secret store by name and scope.
   */
  public static Secret deleteWhere(Map<String, Object> params) throws StripeException {
    return deleteWhere(params, (RequestOptions) null);
  }

  /**
   * Deletes a secret from the secret store by name and scope.
   */
  public static Secret deleteWhere(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets/delete");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Secret.class, options);
  }

  /**
   * Deletes a secret from the secret store by name and scope.
   */
  public static Secret deleteWhere(SecretDeleteWhereParams params) throws StripeException {
    return deleteWhere(params, (RequestOptions) null);
  }

  /**
   * Deletes a secret from the secret store by name and scope.
   */
  public static Secret deleteWhere(SecretDeleteWhereParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets/delete");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Secret.class, options);
  }

  /**
   * List all secrets stored on the given scope.
   */
  public static SecretCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all secrets stored on the given scope.
   */
  public static SecretCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets");
    return ApiResource.requestCollection(url, params, SecretCollection.class, options);
  }

  /**
   * List all secrets stored on the given scope.
   */
  public static SecretCollection list(SecretListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all secrets stored on the given scope.
   */
  public static SecretCollection list(SecretListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apps/secrets");
    return ApiResource.requestCollection(url, params, SecretCollection.class, options);
  }


  public static class Scope extends StripeObject {
    /**
     * The secret scope type.
     *
     * <p>One of {@code account}, or {@code user}.
     */
    @SerializedName("type")
    String type;
    /** The user ID, if type is set to &quot;user&quot;. */
    @SerializedName("user")
    String user;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUser() {
      return this.user;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUser(final String user) {
      this.user = user;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Secret.Scope)) return false;
      final Secret.Scope other = (Secret.Scope) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$user = this.getUser();
      final java.lang.Object other$user = other.getUser();
      if (this$user == null ? other$user != null : !this$user.equals(other$user)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Secret.Scope;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $user = this.getUser();
      result = result * PRIME + ($user == null ? 43 : $user.hashCode());
      return result;
    }
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * If true, indicates that this secret has been deleted.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * A name for the secret that's unique within the scope.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code apps.secret}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The plaintext secret value to be stored.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPayload() {
    return this.payload;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Scope getScope() {
    return this.scope;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * If true, indicates that this secret has been deleted.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * A name for the secret that's unique within the scope.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code apps.secret}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The plaintext secret value to be stored.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayload(final String payload) {
    this.payload = payload;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setScope(final Scope scope) {
    this.scope = scope;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Secret)) return false;
    final Secret other = (Secret) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$payload = this.getPayload();
    final java.lang.Object other$payload = other.getPayload();
    if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) return false;
    final java.lang.Object this$scope = this.getScope();
    final java.lang.Object other$scope = other.getScope();
    if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Secret;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $payload = this.getPayload();
    result = result * PRIME + ($payload == null ? 43 : $payload.hashCode());
    final java.lang.Object $scope = this.getScope();
    result = result * PRIME + ($scope == null ? 43 : $scope.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
