// Generated by delombok at Fri Jul 22 18:23:24 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.FinancialAccountCreateParams;
import com.stripe.param.treasury.FinancialAccountListParams;
import com.stripe.param.treasury.FinancialAccountRetrieveFeaturesParams;
import com.stripe.param.treasury.FinancialAccountRetrieveParams;
import com.stripe.param.treasury.FinancialAccountUpdateFeaturesParams;
import com.stripe.param.treasury.FinancialAccountUpdateParams;
import java.util.List;
import java.util.Map;

public class FinancialAccount extends ApiResource implements HasId, MetadataStore<FinancialAccount> {
  /**
   * The array of paths to active Features in the Features hash.
   */
  @SerializedName("active_features")
  List<String> activeFeatures;
  /**
   * Balance information for the FinancialAccount.
   */
  @SerializedName("balance")
  Balance balance;
  /**
   * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1
   * alpha-2</a>).
   */
  @SerializedName("country")
  String country;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Encodes whether a FinancialAccount has access to a particular Feature, with a {@code status}
   * enum and associated {@code status_details}. Stripe or the platform can control Features via the
   * requested field.
   */
  @SerializedName("features")
  FinancialAccountFeatures features;
  /**
   * The set of credentials that resolve to a FinancialAccount.
   */
  @SerializedName("financial_addresses")
  List<FinancialAccount.FinancialAddress> financialAddresses;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account}.
   */
  @SerializedName("object")
  String object;
  /**
   * The array of paths to pending Features in the Features hash.
   */
  @SerializedName("pending_features")
  List<String> pendingFeatures;
  /**
   * The set of functionalities that the platform can restrict on the FinancialAccount.
   */
  @SerializedName("platform_restrictions")
  PlatformRestrictions platformRestrictions;
  /**
   * The array of paths to restricted Features in the Features hash.
   */
  @SerializedName("restricted_features")
  List<String> restrictedFeatures;
  /**
   * The enum specifying what state the account is in.
   *
   * <p>One of {@code closed}, or {@code open}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_details")
  StatusDetails statusDetails;
  /**
   * The currencies the FinancialAccount can hold a balance in. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   */
  @SerializedName("supported_currencies")
  List<String> supportedCurrencies;

  /**
   * Creates a new FinancialAccount. For now, each connected account can only have one
   * FinancialAccount.
   */
  public static FinancialAccount create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new FinancialAccount. For now, each connected account can only have one
   * FinancialAccount.
   */
  public static FinancialAccount create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/financial_accounts");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccount.class, options);
  }

  /**
   * Creates a new FinancialAccount. For now, each connected account can only have one
   * FinancialAccount.
   */
  public static FinancialAccount create(FinancialAccountCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new FinancialAccount. For now, each connected account can only have one
   * FinancialAccount.
   */
  public static FinancialAccount create(FinancialAccountCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/financial_accounts");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccount.class, options);
  }

  /**
   * Updates the details of a FinancialAccount.
   */
  @Override
  public FinancialAccount update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the details of a FinancialAccount.
   */
  @Override
  public FinancialAccount update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccount.class, options);
  }

  /**
   * Updates the details of a FinancialAccount.
   */
  public FinancialAccount update(FinancialAccountUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the details of a FinancialAccount.
   */
  public FinancialAccount update(FinancialAccountUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccount.class, options);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures() throws StripeException {
    return updateFeatures((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures(RequestOptions options) throws StripeException {
    return updateFeatures((Map<String, Object>) null, options);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures(Map<String, Object> params) throws StripeException {
    return updateFeatures(params, (RequestOptions) null);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccountFeatures.class, options);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures(FinancialAccountUpdateFeaturesParams params) throws StripeException {
    return updateFeatures(params, (RequestOptions) null);
  }

  /**
   * Updates the Features associated with a FinancialAccount.
   */
  public FinancialAccountFeatures updateFeatures(FinancialAccountUpdateFeaturesParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancialAccountFeatures.class, options);
  }

  /**
   * Returns a list of FinancialAccounts.
   */
  public static FinancialAccountCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of FinancialAccounts.
   */
  public static FinancialAccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/financial_accounts");
    return ApiResource.requestCollection(url, params, FinancialAccountCollection.class, options);
  }

  /**
   * Returns a list of FinancialAccounts.
   */
  public static FinancialAccountCollection list(FinancialAccountListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of FinancialAccounts.
   */
  public static FinancialAccountCollection list(FinancialAccountListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/financial_accounts");
    return ApiResource.requestCollection(url, params, FinancialAccountCollection.class, options);
  }

  /**
   * Retrieves the details of a FinancialAccount.
   */
  public static FinancialAccount retrieve(String financialAccount) throws StripeException {
    return retrieve(financialAccount, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a FinancialAccount.
   */
  public static FinancialAccount retrieve(String financialAccount, RequestOptions options) throws StripeException {
    return retrieve(financialAccount, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a FinancialAccount.
   */
  public static FinancialAccount retrieve(String financialAccount, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancialAccount.class, options);
  }

  /**
   * Retrieves the details of a FinancialAccount.
   */
  public static FinancialAccount retrieve(String financialAccount, FinancialAccountRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancialAccount.class, options);
  }

  /**
   * Retrieves Features information associated with the FinancialAccount.
   */
  public FinancialAccountFeatures retrieveFeatures() throws StripeException {
    return retrieveFeatures((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves Features information associated with the FinancialAccount.
   */
  public FinancialAccountFeatures retrieveFeatures(Map<String, Object> params) throws StripeException {
    return retrieveFeatures(params, (RequestOptions) null);
  }

  /**
   * Retrieves Features information associated with the FinancialAccount.
   */
  public FinancialAccountFeatures retrieveFeatures(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancialAccountFeatures.class, options);
  }

  /**
   * Retrieves Features information associated with the FinancialAccount.
   */
  public FinancialAccountFeatures retrieveFeatures(FinancialAccountRetrieveFeaturesParams params) throws StripeException {
    return retrieveFeatures(params, (RequestOptions) null);
  }

  /**
   * Retrieves Features information associated with the FinancialAccount.
   */
  public FinancialAccountFeatures retrieveFeatures(FinancialAccountRetrieveFeaturesParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancialAccountFeatures.class, options);
  }


  public static class Balance extends StripeObject {
    /**
     * Funds the user can spend right now.
     */
    @SerializedName("cash")
    Map<String, Long> cash;
    /**
     * Funds not spendable yet, but will become available at a later time.
     */
    @SerializedName("inbound_pending")
    Map<String, Long> inboundPending;
    /**
     * Funds in the account, but not spendable because they are being held for pending outbound
     * flows.
     */
    @SerializedName("outbound_pending")
    Map<String, Long> outboundPending;

    /**
     * Funds the user can spend right now.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getCash() {
      return this.cash;
    }

    /**
     * Funds not spendable yet, but will become available at a later time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getInboundPending() {
      return this.inboundPending;
    }

    /**
     * Funds in the account, but not spendable because they are being held for pending outbound
     * flows.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getOutboundPending() {
      return this.outboundPending;
    }

    /**
     * Funds the user can spend right now.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCash(final Map<String, Long> cash) {
      this.cash = cash;
    }

    /**
     * Funds not spendable yet, but will become available at a later time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInboundPending(final Map<String, Long> inboundPending) {
      this.inboundPending = inboundPending;
    }

    /**
     * Funds in the account, but not spendable because they are being held for pending outbound
     * flows.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOutboundPending(final Map<String, Long> outboundPending) {
      this.outboundPending = outboundPending;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccount.Balance)) return false;
      final FinancialAccount.Balance other = (FinancialAccount.Balance) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$cash = this.getCash();
      final java.lang.Object other$cash = other.getCash();
      if (this$cash == null ? other$cash != null : !this$cash.equals(other$cash)) return false;
      final java.lang.Object this$inboundPending = this.getInboundPending();
      final java.lang.Object other$inboundPending = other.getInboundPending();
      if (this$inboundPending == null ? other$inboundPending != null : !this$inboundPending.equals(other$inboundPending)) return false;
      final java.lang.Object this$outboundPending = this.getOutboundPending();
      final java.lang.Object other$outboundPending = other.getOutboundPending();
      if (this$outboundPending == null ? other$outboundPending != null : !this$outboundPending.equals(other$outboundPending)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccount.Balance;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $cash = this.getCash();
      result = result * PRIME + ($cash == null ? 43 : $cash.hashCode());
      final java.lang.Object $inboundPending = this.getInboundPending();
      result = result * PRIME + ($inboundPending == null ? 43 : $inboundPending.hashCode());
      final java.lang.Object $outboundPending = this.getOutboundPending();
      result = result * PRIME + ($outboundPending == null ? 43 : $outboundPending.hashCode());
      return result;
    }
  }


  public static class FinancialAddress extends StripeObject {
    /**
     * ABA Records contain U.S. bank account details per the ABA format.
     */
    @SerializedName("aba")
    Aba aba;
    /**
     * The list of networks that the address supports.
     */
    @SerializedName("supported_networks")
    List<String> supportedNetworks;
    /**
     * The type of financial address
     *
     * <p>Equal to {@code aba}.
     */
    @SerializedName("type")
    String type;


    public static class Aba extends StripeObject {
      /** The name of the person or business that owns the bank account. */
      @SerializedName("account_holder_name")
      String accountHolderName;
      /** The account number. */
      @SerializedName("account_number")
      String accountNumber;
      /** The last four characters of the account number. */
      @SerializedName("account_number_last4")
      String accountNumberLast4;
      /** Name of the bank. */
      @SerializedName("bank_name")
      String bankName;
      @SerializedName("routing_number")
      String routingNumber;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderName() {
        return this.accountHolderName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountNumber() {
        return this.accountNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountNumberLast4() {
        return this.accountNumberLast4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderName(final String accountHolderName) {
        this.accountHolderName = accountHolderName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountNumberLast4(final String accountNumberLast4) {
        this.accountNumberLast4 = accountNumberLast4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccount.FinancialAddress.Aba)) return false;
        final FinancialAccount.FinancialAddress.Aba other = (FinancialAccount.FinancialAddress.Aba) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderName = this.getAccountHolderName();
        final java.lang.Object other$accountHolderName = other.getAccountHolderName();
        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
        final java.lang.Object this$accountNumber = this.getAccountNumber();
        final java.lang.Object other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
        final java.lang.Object this$accountNumberLast4 = this.getAccountNumberLast4();
        final java.lang.Object other$accountNumberLast4 = other.getAccountNumberLast4();
        if (this$accountNumberLast4 == null ? other$accountNumberLast4 != null : !this$accountNumberLast4.equals(other$accountNumberLast4)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccount.FinancialAddress.Aba;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderName = this.getAccountHolderName();
        result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
        final java.lang.Object $accountNumber = this.getAccountNumber();
        result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        final java.lang.Object $accountNumberLast4 = this.getAccountNumberLast4();
        result = result * PRIME + ($accountNumberLast4 == null ? 43 : $accountNumberLast4.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }

    /**
     * ABA Records contain U.S. bank account details per the ABA format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Aba getAba() {
      return this.aba;
    }

    /**
     * The list of networks that the address supports.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSupportedNetworks() {
      return this.supportedNetworks;
    }

    /**
     * The type of financial address
     *
     * <p>Equal to {@code aba}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * ABA Records contain U.S. bank account details per the ABA format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAba(final Aba aba) {
      this.aba = aba;
    }

    /**
     * The list of networks that the address supports.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportedNetworks(final List<String> supportedNetworks) {
      this.supportedNetworks = supportedNetworks;
    }

    /**
     * The type of financial address
     *
     * <p>Equal to {@code aba}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccount.FinancialAddress)) return false;
      final FinancialAccount.FinancialAddress other = (FinancialAccount.FinancialAddress) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$aba = this.getAba();
      final java.lang.Object other$aba = other.getAba();
      if (this$aba == null ? other$aba != null : !this$aba.equals(other$aba)) return false;
      final java.lang.Object this$supportedNetworks = this.getSupportedNetworks();
      final java.lang.Object other$supportedNetworks = other.getSupportedNetworks();
      if (this$supportedNetworks == null ? other$supportedNetworks != null : !this$supportedNetworks.equals(other$supportedNetworks)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccount.FinancialAddress;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $aba = this.getAba();
      result = result * PRIME + ($aba == null ? 43 : $aba.hashCode());
      final java.lang.Object $supportedNetworks = this.getSupportedNetworks();
      result = result * PRIME + ($supportedNetworks == null ? 43 : $supportedNetworks.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * Routing number for the account.
   */
  public static class PlatformRestrictions extends StripeObject {
    /**
     * Restricts all inbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @SerializedName("inbound_flows")
    String inboundFlows;
    /**
     * Restricts all outbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @SerializedName("outbound_flows")
    String outboundFlows;

    /**
     * Restricts all inbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInboundFlows() {
      return this.inboundFlows;
    }

    /**
     * Restricts all outbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getOutboundFlows() {
      return this.outboundFlows;
    }

    /**
     * Restricts all inbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInboundFlows(final String inboundFlows) {
      this.inboundFlows = inboundFlows;
    }

    /**
     * Restricts all outbound money movement.
     *
     * <p>One of {@code restricted}, or {@code unrestricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOutboundFlows(final String outboundFlows) {
      this.outboundFlows = outboundFlows;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccount.PlatformRestrictions)) return false;
      final FinancialAccount.PlatformRestrictions other = (FinancialAccount.PlatformRestrictions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$inboundFlows = this.getInboundFlows();
      final java.lang.Object other$inboundFlows = other.getInboundFlows();
      if (this$inboundFlows == null ? other$inboundFlows != null : !this$inboundFlows.equals(other$inboundFlows)) return false;
      final java.lang.Object this$outboundFlows = this.getOutboundFlows();
      final java.lang.Object other$outboundFlows = other.getOutboundFlows();
      if (this$outboundFlows == null ? other$outboundFlows != null : !this$outboundFlows.equals(other$outboundFlows)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccount.PlatformRestrictions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $inboundFlows = this.getInboundFlows();
      result = result * PRIME + ($inboundFlows == null ? 43 : $inboundFlows.hashCode());
      final java.lang.Object $outboundFlows = this.getOutboundFlows();
      result = result * PRIME + ($outboundFlows == null ? 43 : $outboundFlows.hashCode());
      return result;
    }
  }


  public static class StatusDetails extends StripeObject {
    /**
     * Details related to the closure of this FinancialAccount.
     */
    @SerializedName("closed")
    Closed closed;


    public static class Closed extends StripeObject {
      @SerializedName("reasons")
      List<String> reasons;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getReasons() {
        return this.reasons;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReasons(final List<String> reasons) {
        this.reasons = reasons;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccount.StatusDetails.Closed)) return false;
        final FinancialAccount.StatusDetails.Closed other = (FinancialAccount.StatusDetails.Closed) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$reasons = this.getReasons();
        final java.lang.Object other$reasons = other.getReasons();
        if (this$reasons == null ? other$reasons != null : !this$reasons.equals(other$reasons)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccount.StatusDetails.Closed;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $reasons = this.getReasons();
        result = result * PRIME + ($reasons == null ? 43 : $reasons.hashCode());
        return result;
      }
    }

    /**
     * Details related to the closure of this FinancialAccount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Closed getClosed() {
      return this.closed;
    }

    /**
     * Details related to the closure of this FinancialAccount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setClosed(final Closed closed) {
      this.closed = closed;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccount.StatusDetails)) return false;
      final FinancialAccount.StatusDetails other = (FinancialAccount.StatusDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$closed = this.getClosed();
      final java.lang.Object other$closed = other.getClosed();
      if (this$closed == null ? other$closed != null : !this$closed.equals(other$closed)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccount.StatusDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $closed = this.getClosed();
      result = result * PRIME + ($closed == null ? 43 : $closed.hashCode());
      return result;
    }
  }


  /**
   * The array that contains reasons for a FinancialAccount closure.
   */
  public static class ToggleSettings extends StripeObject {
    /** Whether the FinancialAccount should have the Feature. */
    @SerializedName("requested")
    Boolean requested;
    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @SerializedName("status")
    String status;
    /** Additional details; includes at least one entry when the status is not {@code active}. */
    @SerializedName("status_details")
    List<FinancialAccount.ToggleSettings.StatusDetails> statusDetails;


    public static class StatusDetails extends StripeObject {
      /**
       * Represents the reason why the status is {@code pending} or {@code restricted}.
       *
       * <p>One of {@code activating}, {@code capability_not_requested}, {@code
       * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
       * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
       * restricted_by_platform}, or {@code restricted_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * Represents what the user should do, if anything, to activate the Feature.
       *
       * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
       * remove_restriction}.
       */
      @SerializedName("resolution")
      String resolution;
      /**
       * The {@code platform_restrictions} that are restricting this Feature.
       *
       * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
       */
      @SerializedName("restriction")
      String restriction;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getResolution() {
        return this.resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRestriction() {
        return this.restriction;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setResolution(final String resolution) {
        this.resolution = resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRestriction(final String restriction) {
        this.restriction = restriction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccount.ToggleSettings.StatusDetails)) return false;
        final FinancialAccount.ToggleSettings.StatusDetails other = (FinancialAccount.ToggleSettings.StatusDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$resolution = this.getResolution();
        final java.lang.Object other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
        final java.lang.Object this$restriction = this.getRestriction();
        final java.lang.Object other$restriction = other.getRestriction();
        if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccount.ToggleSettings.StatusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $resolution = this.getResolution();
        result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
        final java.lang.Object $restriction = this.getRestriction();
        result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRequested() {
      return this.requested;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<FinancialAccount.ToggleSettings.StatusDetails> getStatusDetails() {
      return this.statusDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequested(final Boolean requested) {
      this.requested = requested;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatusDetails(final List<FinancialAccount.ToggleSettings.StatusDetails> statusDetails) {
      this.statusDetails = statusDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccount.ToggleSettings)) return false;
      final FinancialAccount.ToggleSettings other = (FinancialAccount.ToggleSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$requested = this.getRequested();
      final java.lang.Object other$requested = other.getRequested();
      if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$statusDetails = this.getStatusDetails();
      final java.lang.Object other$statusDetails = other.getStatusDetails();
      if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccount.ToggleSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $requested = this.getRequested();
      result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $statusDetails = this.getStatusDetails();
      result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
      return result;
    }
  }

  /**
   * The array of paths to active Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getActiveFeatures() {
    return this.activeFeatures;
  }

  /**
   * Balance information for the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Balance getBalance() {
    return this.balance;
  }

  /**
   * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1
   * alpha-2</a>).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCountry() {
    return this.country;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Encodes whether a FinancialAccount has access to a particular Feature, with a {@code status}
   * enum and associated {@code status_details}. Stripe or the platform can control Features via the
   * requested field.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FinancialAccountFeatures getFeatures() {
    return this.features;
  }

  /**
   * The set of credentials that resolve to a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<FinancialAccount.FinancialAddress> getFinancialAddresses() {
    return this.financialAddresses;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The array of paths to pending Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPendingFeatures() {
    return this.pendingFeatures;
  }

  /**
   * The set of functionalities that the platform can restrict on the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PlatformRestrictions getPlatformRestrictions() {
    return this.platformRestrictions;
  }

  /**
   * The array of paths to restricted Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getRestrictedFeatures() {
    return this.restrictedFeatures;
  }

  /**
   * The enum specifying what state the account is in.
   *
   * <p>One of {@code closed}, or {@code open}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusDetails getStatusDetails() {
    return this.statusDetails;
  }

  /**
   * The currencies the FinancialAccount can hold a balance in. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedCurrencies() {
    return this.supportedCurrencies;
  }

  /**
   * The array of paths to active Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActiveFeatures(final List<String> activeFeatures) {
    this.activeFeatures = activeFeatures;
  }

  /**
   * Balance information for the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalance(final Balance balance) {
    this.balance = balance;
  }

  /**
   * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1
   * alpha-2</a>).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCountry(final String country) {
    this.country = country;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Encodes whether a FinancialAccount has access to a particular Feature, with a {@code status}
   * enum and associated {@code status_details}. Stripe or the platform can control Features via the
   * requested field.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFeatures(final FinancialAccountFeatures features) {
    this.features = features;
  }

  /**
   * The set of credentials that resolve to a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAddresses(final List<FinancialAccount.FinancialAddress> financialAddresses) {
    this.financialAddresses = financialAddresses;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The array of paths to pending Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingFeatures(final List<String> pendingFeatures) {
    this.pendingFeatures = pendingFeatures;
  }

  /**
   * The set of functionalities that the platform can restrict on the FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlatformRestrictions(final PlatformRestrictions platformRestrictions) {
    this.platformRestrictions = platformRestrictions;
  }

  /**
   * The array of paths to restricted Features in the Features hash.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRestrictedFeatures(final List<String> restrictedFeatures) {
    this.restrictedFeatures = restrictedFeatures;
  }

  /**
   * The enum specifying what state the account is in.
   *
   * <p>One of {@code closed}, or {@code open}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusDetails(final StatusDetails statusDetails) {
    this.statusDetails = statusDetails;
  }

  /**
   * The currencies the FinancialAccount can hold a balance in. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedCurrencies(final List<String> supportedCurrencies) {
    this.supportedCurrencies = supportedCurrencies;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FinancialAccount)) return false;
    final FinancialAccount other = (FinancialAccount) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$activeFeatures = this.getActiveFeatures();
    final java.lang.Object other$activeFeatures = other.getActiveFeatures();
    if (this$activeFeatures == null ? other$activeFeatures != null : !this$activeFeatures.equals(other$activeFeatures)) return false;
    final java.lang.Object this$balance = this.getBalance();
    final java.lang.Object other$balance = other.getBalance();
    if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) return false;
    final java.lang.Object this$country = this.getCountry();
    final java.lang.Object other$country = other.getCountry();
    if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
    final java.lang.Object this$features = this.getFeatures();
    final java.lang.Object other$features = other.getFeatures();
    if (this$features == null ? other$features != null : !this$features.equals(other$features)) return false;
    final java.lang.Object this$financialAddresses = this.getFinancialAddresses();
    final java.lang.Object other$financialAddresses = other.getFinancialAddresses();
    if (this$financialAddresses == null ? other$financialAddresses != null : !this$financialAddresses.equals(other$financialAddresses)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$pendingFeatures = this.getPendingFeatures();
    final java.lang.Object other$pendingFeatures = other.getPendingFeatures();
    if (this$pendingFeatures == null ? other$pendingFeatures != null : !this$pendingFeatures.equals(other$pendingFeatures)) return false;
    final java.lang.Object this$platformRestrictions = this.getPlatformRestrictions();
    final java.lang.Object other$platformRestrictions = other.getPlatformRestrictions();
    if (this$platformRestrictions == null ? other$platformRestrictions != null : !this$platformRestrictions.equals(other$platformRestrictions)) return false;
    final java.lang.Object this$restrictedFeatures = this.getRestrictedFeatures();
    final java.lang.Object other$restrictedFeatures = other.getRestrictedFeatures();
    if (this$restrictedFeatures == null ? other$restrictedFeatures != null : !this$restrictedFeatures.equals(other$restrictedFeatures)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusDetails = this.getStatusDetails();
    final java.lang.Object other$statusDetails = other.getStatusDetails();
    if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
    final java.lang.Object this$supportedCurrencies = this.getSupportedCurrencies();
    final java.lang.Object other$supportedCurrencies = other.getSupportedCurrencies();
    if (this$supportedCurrencies == null ? other$supportedCurrencies != null : !this$supportedCurrencies.equals(other$supportedCurrencies)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FinancialAccount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $activeFeatures = this.getActiveFeatures();
    result = result * PRIME + ($activeFeatures == null ? 43 : $activeFeatures.hashCode());
    final java.lang.Object $balance = this.getBalance();
    result = result * PRIME + ($balance == null ? 43 : $balance.hashCode());
    final java.lang.Object $country = this.getCountry();
    result = result * PRIME + ($country == null ? 43 : $country.hashCode());
    final java.lang.Object $features = this.getFeatures();
    result = result * PRIME + ($features == null ? 43 : $features.hashCode());
    final java.lang.Object $financialAddresses = this.getFinancialAddresses();
    result = result * PRIME + ($financialAddresses == null ? 43 : $financialAddresses.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $pendingFeatures = this.getPendingFeatures();
    result = result * PRIME + ($pendingFeatures == null ? 43 : $pendingFeatures.hashCode());
    final java.lang.Object $platformRestrictions = this.getPlatformRestrictions();
    result = result * PRIME + ($platformRestrictions == null ? 43 : $platformRestrictions.hashCode());
    final java.lang.Object $restrictedFeatures = this.getRestrictedFeatures();
    result = result * PRIME + ($restrictedFeatures == null ? 43 : $restrictedFeatures.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusDetails = this.getStatusDetails();
    result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
    final java.lang.Object $supportedCurrencies = this.getSupportedCurrencies();
    result = result * PRIME + ($supportedCurrencies == null ? 43 : $supportedCurrencies.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
