/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.Price;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.model.TaxRate;
import com.stripe.model.UsageRecordSummaryCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionItemCreateParams;
import com.stripe.param.SubscriptionItemDeleteParams;
import com.stripe.param.SubscriptionItemListParams;
import com.stripe.param.SubscriptionItemRetrieveParams;
import com.stripe.param.SubscriptionItemUpdateParams;
import com.stripe.param.SubscriptionItemUsageRecordSummariesParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class SubscriptionItem
extends ApiResource
implements HasId,
MetadataStore<SubscriptionItem> {
    @SerializedName(value="billing_thresholds")
    BillingThresholds billingThresholds;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="plan")
    Plan plan;
    @SerializedName(value="price")
    Price price;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="subscription")
    String subscription;
    @SerializedName(value="tax_rates")
    List<TaxRate> taxRates;
    @SerializedName(value="trial")
    Trial trial;

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public static SubscriptionItemCollection list(Map<String, Object> params) throws StripeException {
        return SubscriptionItem.list(params, (RequestOptions)null);
    }

    public static SubscriptionItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
        return ApiResource.requestCollection(url, params, SubscriptionItemCollection.class, options);
    }

    public static SubscriptionItemCollection list(SubscriptionItemListParams params) throws StripeException {
        return SubscriptionItem.list(params, (RequestOptions)null);
    }

    public static SubscriptionItemCollection list(SubscriptionItemListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
        return ApiResource.requestCollection(url, params, SubscriptionItemCollection.class, options);
    }

    public static SubscriptionItem retrieve(String item) throws StripeException {
        return SubscriptionItem.retrieve(item, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SubscriptionItem retrieve(String item, RequestOptions options) throws StripeException {
        return SubscriptionItem.retrieve(item, (Map<String, Object>)null, options);
    }

    public static SubscriptionItem retrieve(String item, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionItem.class, options);
    }

    public static SubscriptionItem retrieve(String item, SubscriptionItemRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionItem.class, options);
    }

    public static SubscriptionItem create(Map<String, Object> params) throws StripeException {
        return SubscriptionItem.create(params, (RequestOptions)null);
    }

    public static SubscriptionItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
    }

    public static SubscriptionItem create(SubscriptionItemCreateParams params) throws StripeException {
        return SubscriptionItem.create(params, (RequestOptions)null);
    }

    public static SubscriptionItem create(SubscriptionItemCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_items");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
    }

    public SubscriptionItem update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SubscriptionItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
    }

    public SubscriptionItem update(SubscriptionItemUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SubscriptionItem update(SubscriptionItemUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionItem.class, options);
    }

    public SubscriptionItem delete() throws StripeException {
        return this.delete((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionItem delete(RequestOptions options) throws StripeException {
        return this.delete((Map<String, Object>)null, options);
    }

    public SubscriptionItem delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public SubscriptionItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, SubscriptionItem.class, options);
    }

    public SubscriptionItem delete(SubscriptionItemDeleteParams params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public SubscriptionItem delete(SubscriptionItemDeleteParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, SubscriptionItem.class, options);
    }

    public UsageRecordSummaryCollection usageRecordSummaries() throws StripeException {
        return this.usageRecordSummaries((Map<String, Object>)null, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params) throws StripeException {
        return this.usageRecordSummaries(params, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, UsageRecordSummaryCollection.class, options);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params) throws StripeException {
        return this.usageRecordSummaries(params, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, UsageRecordSummaryCollection.class, options);
    }

    @Generated
    public BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getSubscription() {
        return this.subscription;
    }

    @Generated
    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    @Generated
    public Trial getTrial() {
        return this.trial;
    }

    @Generated
    public void setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setPrice(Price price) {
        this.price = price;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Generated
    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    @Generated
    public void setTrial(Trial trial) {
        this.trial = trial;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionItem)) {
            return false;
        }
        SubscriptionItem other = (SubscriptionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        BillingThresholds this$billingThresholds = this.getBillingThresholds();
        BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        List<TaxRate> this$taxRates = this.getTaxRates();
        List<TaxRate> other$taxRates = other.getTaxRates();
        if (this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates)) {
            return false;
        }
        Trial this$trial = this.getTrial();
        Trial other$trial = other.getTrial();
        return !(this$trial == null ? other$trial != null : !((Object)this$trial).equals(other$trial));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        List<TaxRate> $taxRates = this.getTaxRates();
        result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
        Trial $trial = this.getTrial();
        result = result * 59 + ($trial == null ? 43 : ((Object)$trial).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BillingThresholds
    extends StripeObject {
        @SerializedName(value="usage_gte")
        Long usageGte;

        @Generated
        public Long getUsageGte() {
            return this.usageGte;
        }

        @Generated
        public void setUsageGte(Long usageGte) {
            this.usageGte = usageGte;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingThresholds)) {
                return false;
            }
            BillingThresholds other = (BillingThresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$usageGte = this.getUsageGte();
            Long other$usageGte = other.getUsageGte();
            return !(this$usageGte == null ? other$usageGte != null : !((Object)this$usageGte).equals(other$usageGte));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingThresholds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $usageGte = this.getUsageGte();
            result = result * 59 + ($usageGte == null ? 43 : ((Object)$usageGte).hashCode());
            return result;
        }
    }

    public static class Trial
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="paid")
        Paid paid;
        @SerializedName(value="type")
        String type;

        @Generated
        public Paid getPaid() {
            return this.paid;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setPaid(Paid paid) {
            this.paid = paid;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trial)) {
                return false;
            }
            Trial other = (Trial)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Paid this$paid = this.getPaid();
            Paid other$paid = other.getPaid();
            if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Trial;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Paid $paid = this.getPaid();
            result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        public static class Paid
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="price")
            String price;
            @SerializedName(value="quantity")
            Long quantity;

            @Generated
            public String getPrice() {
                return this.price;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setPrice(String price) {
                this.price = price;
            }

            @Generated
            public void setQuantity(Long quantity) {
                this.quantity = quantity;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paid)) {
                    return false;
                }
                Paid other = (Paid)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$price = this.getPrice();
                String other$price = other.getPrice();
                return !(this$price == null ? other$price != null : !this$price.equals(other$price));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paid;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : $price.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }
    }
}

