// Generated by delombok at Tue Jul 26 21:30:52 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.param.billingportal;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionCreateParams extends ApiRequestParams {
  /**
   * The ID of an existing <a
   * href="https://stripe.com/docs/api/customer_portal/configuration">configuration</a> to use for
   * this session, describing its functionality and features. If not specified, the session uses the
   * default configuration.
   */
  @SerializedName("configuration")
  String configuration;
  /**
   * The ID of an existing customer.
   */
  @SerializedName("customer")
  String customer;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the
   * customer’s {@code preferred_locales} or browser’s locale is used.
   */
  @SerializedName("locale")
  Locale locale;
  /**
   * The {@code on_behalf_of} account to use for this session. When specified, only subscriptions
   * and invoices with this {@code on_behalf_of} account appear in the portal. For more information,
   * see the <a href="https://stripe.com/docs/connect/charges-transfers#on-behalf-of">docs</a>. Use
   * the <a
   * href="https://stripe.com/docs/api/accounts/object#account_object-settings-branding">Accounts
   * API</a> to modify the {@code on_behalf_of} account's branding settings, which the portal
   * displays.
   */
  @SerializedName("on_behalf_of")
  String onBehalfOf;
  /**
   * The default URL to redirect customers to when they click on the portal's link to return to your
   * website.
   */
  @SerializedName("return_url")
  String returnUrl;

  private SessionCreateParams(String configuration, String customer, List<String> expand, Map<String, Object> extraParams, Locale locale, String onBehalfOf, String returnUrl) {
    this.configuration = configuration;
    this.customer = customer;
    this.expand = expand;
    this.extraParams = extraParams;
    this.locale = locale;
    this.onBehalfOf = onBehalfOf;
    this.returnUrl = returnUrl;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private String configuration;
    private String customer;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private Locale locale;
    private String onBehalfOf;
    private String returnUrl;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public SessionCreateParams build() {
      return new SessionCreateParams(this.configuration, this.customer, this.expand, this.extraParams, this.locale, this.onBehalfOf, this.returnUrl);
    }

    /**
     * The ID of an existing <a
     * href="https://stripe.com/docs/api/customer_portal/configuration">configuration</a> to use for
     * this session, describing its functionality and features. If not specified, the session uses
     * the default configuration.
     */
    public Builder setConfiguration(String configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * The ID of an existing customer.
     */
    public Builder setCustomer(String customer) {
      this.customer = customer;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SessionCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SessionCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * SessionCreateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link SessionCreateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the
     * customer’s {@code preferred_locales} or browser’s locale is used.
     */
    public Builder setLocale(Locale locale) {
      this.locale = locale;
      return this;
    }

    /**
     * The {@code on_behalf_of} account to use for this session. When specified, only subscriptions
     * and invoices with this {@code on_behalf_of} account appear in the portal. For more
     * information, see the <a
     * href="https://stripe.com/docs/connect/charges-transfers#on-behalf-of">docs</a>. Use the <a
     * href="https://stripe.com/docs/api/accounts/object#account_object-settings-branding">Accounts
     * API</a> to modify the {@code on_behalf_of} account's branding settings, which the portal
     * displays.
     */
    public Builder setOnBehalfOf(String onBehalfOf) {
      this.onBehalfOf = onBehalfOf;
      return this;
    }

    /**
     * The default URL to redirect customers to when they click on the portal's link to return to
     * your website.
     */
    public Builder setReturnUrl(String returnUrl) {
      this.returnUrl = returnUrl;
      return this;
    }
  }


  public enum Locale implements ApiRequestParams.EnumParam {
    @SerializedName("auto")
    AUTO("auto"), @SerializedName("bg")
    BG("bg"), @SerializedName("cs")
    CS("cs"), @SerializedName("da")
    DA("da"), @SerializedName("de")
    DE("de"), @SerializedName("el")
    EL("el"), @SerializedName("en")
    EN("en"), @SerializedName("en-AU")
    EN_AU("en-AU"), @SerializedName("en-CA")
    EN_CA("en-CA"), @SerializedName("en-GB")
    EN_GB("en-GB"), @SerializedName("en-IE")
    EN_IE("en-IE"), @SerializedName("en-IN")
    EN_IN("en-IN"), @SerializedName("en-NZ")
    EN_NZ("en-NZ"), @SerializedName("en-SG")
    EN_SG("en-SG"), @SerializedName("es")
    ES("es"), @SerializedName("es-419")
    ES_419("es-419"), @SerializedName("et")
    ET("et"), @SerializedName("fi")
    FI("fi"), @SerializedName("fil")
    FIL("fil"), @SerializedName("fr")
    FR("fr"), @SerializedName("fr-CA")
    FR_CA("fr-CA"), @SerializedName("hr")
    HR("hr"), @SerializedName("hu")
    HU("hu"), @SerializedName("id")
    ID("id"), @SerializedName("it")
    IT("it"), @SerializedName("ja")
    JA("ja"), @SerializedName("ko")
    KO("ko"), @SerializedName("lt")
    LT("lt"), @SerializedName("lv")
    LV("lv"), @SerializedName("ms")
    MS("ms"), @SerializedName("mt")
    MT("mt"), @SerializedName("nb")
    NB("nb"), @SerializedName("nl")
    NL("nl"), @SerializedName("pl")
    PL("pl"), @SerializedName("pt")
    PT("pt"), @SerializedName("pt-BR")
    PT_BR("pt-BR"), @SerializedName("ro")
    RO("ro"), @SerializedName("ru")
    RU("ru"), @SerializedName("sk")
    SK("sk"), @SerializedName("sl")
    SL("sl"), @SerializedName("sv")
    SV("sv"), @SerializedName("th")
    TH("th"), @SerializedName("tr")
    TR("tr"), @SerializedName("vi")
    VI("vi"), @SerializedName("zh")
    ZH("zh"), @SerializedName("zh-HK")
    ZH_HK("zh-HK"), @SerializedName("zh-TW")
    ZH_TW("zh-TW");
    private final String value;

    Locale(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }

  /**
   * The ID of an existing <a
   * href="https://stripe.com/docs/api/customer_portal/configuration">configuration</a> to use for
   * this session, describing its functionality and features. If not specified, the session uses the
   * default configuration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getConfiguration() {
    return this.configuration;
  }

  /**
   * The ID of an existing customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the
   * customer’s {@code preferred_locales} or browser’s locale is used.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Locale getLocale() {
    return this.locale;
  }

  /**
   * The {@code on_behalf_of} account to use for this session. When specified, only subscriptions
   * and invoices with this {@code on_behalf_of} account appear in the portal. For more information,
   * see the <a href="https://stripe.com/docs/connect/charges-transfers#on-behalf-of">docs</a>. Use
   * the <a
   * href="https://stripe.com/docs/api/accounts/object#account_object-settings-branding">Accounts
   * API</a> to modify the {@code on_behalf_of} account's branding settings, which the portal
   * displays.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOnBehalfOf() {
    return this.onBehalfOf;
  }

  /**
   * The default URL to redirect customers to when they click on the portal's link to return to your
   * website.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnUrl() {
    return this.returnUrl;
  }
}
