// Generated by delombok at Thu Oct 08 22:32:37 EDT 2020
// File generated from our OpenAPI spec
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.AuthorizationApproveParams;
import com.stripe.param.issuing.AuthorizationDeclineParams;
import com.stripe.param.issuing.AuthorizationListParams;
import com.stripe.param.issuing.AuthorizationRetrieveParams;
import com.stripe.param.issuing.AuthorizationUpdateParams;
import java.util.List;
import java.util.Map;

public class Authorization extends ApiResource implements MetadataStore<Authorization>, BalanceTransactionSource {
  /**
   * The total amount that was authorized or rejected. This amount is in the card's currency and in
   * the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Detailed breakdown of amount components. These amounts are denominated in {@code currency} and
   * in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @SerializedName("amount_details")
  AmountDetails amountDetails;
  /**
   * Whether the authorization has been approved.
   */
  @SerializedName("approved")
  Boolean approved;
  /**
   * How the card details were provided.
   *
   * <p>One of {@code chip}, {@code contactless}, {@code keyed_in}, {@code online}, or {@code
   * swipe}.
   */
  @SerializedName("authorization_method")
  String authorizationMethod;
  /**
   * List of balance transactions associated with this authorization.
   */
  @SerializedName("balance_transactions")
  List<BalanceTransaction> balanceTransactions;
  /**
   * You can <a href="https://stripe.com/docs/issuing/cards">create physical or virtual cards</a>
   * that are issued to cardholders.
   */
  @SerializedName("card")
  Card card;
  /**
   * The cardholder to whom this authorization belongs.
   */
  @SerializedName("cardholder")
  ExpandableField<Cardholder> cardholder;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The total amount that was authorized or rejected. This amount is in the {@code
   * merchant_currency} and in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @SerializedName("merchant_amount")
  Long merchantAmount;
  /**
   * The currency that was presented to the cardholder for the authorization. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("merchant_currency")
  String merchantCurrency;
  @SerializedName("merchant_data")
  MerchantData merchantData;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.authorization}.
   */
  @SerializedName("object")
  String object;
  /**
   * The pending authorization request. This field will only be non-null during an {@code
   * issuing_authorization.request} webhook.
   */
  @SerializedName("pending_request")
  PendingRequest pendingRequest;
  /**
   * History of every time the authorization was approved/denied (whether approved/denied by you
   * directly or by Stripe based on your {@code spending_controls}). If the merchant changes the
   * authorization by performing an <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">incremental authorization or
   * partial capture</a>, you can look at this field to see the previous states of the
   * authorization.
   */
  @SerializedName("request_history")
  List<Authorization.RequestHistory> requestHistory;
  /**
   * The current status of the authorization in its lifecycle.
   *
   * <p>One of {@code closed}, {@code pending}, or {@code reversed}.
   */
  @SerializedName("status")
  String status;
  /**
   * List of <a href="https://stripe.com/docs/api/issuing/transactions">transactions</a> associated
   * with this authorization.
   */
  @SerializedName("transactions")
  List<Transaction> transactions;
  @SerializedName("verification_data")
  VerificationData verificationData;
  /**
   * What, if any, digital wallet was used for this authorization. One of {@code apple_pay}, {@code
   * google_pay}, or {@code samsung_pay}.
   */
  @SerializedName("wallet")
  String wallet;

  /**
   * Get ID of expandable {@code cardholder} object.
   */
  public String getCardholder() {
    return (this.cardholder != null) ? this.cardholder.getId() : null;
  }

  public void setCardholder(String id) {
    this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
  }

  /**
   * Get expanded {@code cardholder}.
   */
  public Cardholder getCardholderObject() {
    return (this.cardholder != null) ? this.cardholder.getExpanded() : null;
  }

  public void setCardholderObject(Cardholder expandableObject) {
    this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of Issuing <code>Authorization</code> objects. The objects are sorted in
   * descending order by creation date, with the most recently created object appearing first.
   */
  public static AuthorizationCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Authorization</code> objects. The objects are sorted in
   * descending order by creation date, with the most recently created object appearing first.
   */
  public static AuthorizationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
    return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
  }

  /**
   * Returns a list of Issuing <code>Authorization</code> objects. The objects are sorted in
   * descending order by creation date, with the most recently created object appearing first.
   */
  public static AuthorizationCollection list(AuthorizationListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Authorization</code> objects. The objects are sorted in
   * descending order by creation date, with the most recently created object appearing first.
   */
  public static AuthorizationCollection list(AuthorizationListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
    return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
  }

  /**
   * Retrieves an Issuing <code>Authorization</code> object.
   */
  public static Authorization retrieve(String authorization) throws StripeException {
    return retrieve(authorization, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an Issuing <code>Authorization</code> object.
   */
  public static Authorization retrieve(String authorization, RequestOptions options) throws StripeException {
    return retrieve(authorization, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an Issuing <code>Authorization</code> object.
   */
  public static Authorization retrieve(String authorization, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
  }

  /**
   * Retrieves an Issuing <code>Authorization</code> object.
   */
  public static Authorization retrieve(String authorization, AuthorizationRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
  }

  /**
   * Updates the specified Issuing <code>Authorization</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Authorization update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Authorization</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Authorization update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }

  /**
   * Updates the specified Issuing <code>Authorization</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Authorization update(AuthorizationUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Authorization</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Authorization update(AuthorizationUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve() throws StripeException {
    return approve((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve(RequestOptions options) throws StripeException {
    return approve((Map<String, Object>) null, options);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve(Map<String, Object> params) throws StripeException {
    return approve(params, (RequestOptions) null);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve(AuthorizationApproveParams params) throws StripeException {
    return approve(params, (RequestOptions) null);
  }

  /**
   * Approves a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real-time
   * authorization</a> flow.
   */
  public Authorization approve(AuthorizationApproveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline() throws StripeException {
    return decline((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline(RequestOptions options) throws StripeException {
    return decline((Map<String, Object>) null, options);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline(Map<String, Object> params) throws StripeException {
    return decline(params, (RequestOptions) null);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline(AuthorizationDeclineParams params) throws StripeException {
    return decline(params, (RequestOptions) null);
  }

  /**
   * Declines a pending Issuing <code>Authorization</code> object. This request should be made
   * within the timeout window of the <a
   * href="https://stripe.com/docs/issuing/controls/real-time-authorizations">real time
   * authorization</a> flow.
   */
  public Authorization decline(AuthorizationDeclineParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
  }


  public static class AmountDetails extends StripeObject {
    /**
     * The fee charged by the ATM for the cash withdrawal.
     */
    @SerializedName("atm_fee")
    Long atmFee;

    /**
     * The fee charged by the ATM for the cash withdrawal.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAtmFee() {
      return this.atmFee;
    }

    /**
     * The fee charged by the ATM for the cash withdrawal.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAtmFee(final Long atmFee) {
      this.atmFee = atmFee;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.AmountDetails)) return false;
      final Authorization.AmountDetails other = (Authorization.AmountDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$atmFee = this.getAtmFee();
      final java.lang.Object other$atmFee = other.getAtmFee();
      if (this$atmFee == null ? other$atmFee != null : !this$atmFee.equals(other$atmFee)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.AmountDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $atmFee = this.getAtmFee();
      result = result * PRIME + ($atmFee == null ? 43 : $atmFee.hashCode());
      return result;
    }
  }


  public static class MerchantData extends StripeObject {
    /**
     * A categorization of the seller's type of business. See our <a
     * href="https://stripe.com/docs/issuing/merchant-categories">merchant categories guide</a> for
     * a list of possible values.
     */
    @SerializedName("category")
    String category;
    /**
     * City where the seller is located.
     */
    @SerializedName("city")
    String city;
    /**
     * Country where the seller is located.
     */
    @SerializedName("country")
    String country;
    /**
     * Name of the seller.
     */
    @SerializedName("name")
    String name;
    /**
     * Identifier assigned to the seller by the card brand.
     */
    @SerializedName("network_id")
    String networkId;
    /**
     * Postal code where the seller is located.
     */
    @SerializedName("postal_code")
    String postalCode;
    /**
     * State where the seller is located.
     */
    @SerializedName("state")
    String state;

    /**
     * A categorization of the seller's type of business. See our <a
     * href="https://stripe.com/docs/issuing/merchant-categories">merchant categories guide</a> for
     * a list of possible values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCategory() {
      return this.category;
    }

    /**
     * City where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCity() {
      return this.city;
    }

    /**
     * Country where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    /**
     * Name of the seller.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Identifier assigned to the seller by the card brand.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNetworkId() {
      return this.networkId;
    }

    /**
     * Postal code where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPostalCode() {
      return this.postalCode;
    }

    /**
     * State where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getState() {
      return this.state;
    }

    /**
     * A categorization of the seller's type of business. See our <a
     * href="https://stripe.com/docs/issuing/merchant-categories">merchant categories guide</a> for
     * a list of possible values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCategory(final String category) {
      this.category = category;
    }

    /**
     * City where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCity(final String city) {
      this.city = city;
    }

    /**
     * Country where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    /**
     * Name of the seller.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Identifier assigned to the seller by the card brand.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNetworkId(final String networkId) {
      this.networkId = networkId;
    }

    /**
     * Postal code where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostalCode(final String postalCode) {
      this.postalCode = postalCode;
    }

    /**
     * State where the seller is located.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setState(final String state) {
      this.state = state;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.MerchantData)) return false;
      final Authorization.MerchantData other = (Authorization.MerchantData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$category = this.getCategory();
      final java.lang.Object other$category = other.getCategory();
      if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
      final java.lang.Object this$city = this.getCity();
      final java.lang.Object other$city = other.getCity();
      if (this$city == null ? other$city != null : !this$city.equals(other$city)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$networkId = this.getNetworkId();
      final java.lang.Object other$networkId = other.getNetworkId();
      if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) return false;
      final java.lang.Object this$postalCode = this.getPostalCode();
      final java.lang.Object other$postalCode = other.getPostalCode();
      if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) return false;
      final java.lang.Object this$state = this.getState();
      final java.lang.Object other$state = other.getState();
      if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.MerchantData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $category = this.getCategory();
      result = result * PRIME + ($category == null ? 43 : $category.hashCode());
      final java.lang.Object $city = this.getCity();
      result = result * PRIME + ($city == null ? 43 : $city.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $networkId = this.getNetworkId();
      result = result * PRIME + ($networkId == null ? 43 : $networkId.hashCode());
      final java.lang.Object $postalCode = this.getPostalCode();
      result = result * PRIME + ($postalCode == null ? 43 : $postalCode.hashCode());
      final java.lang.Object $state = this.getState();
      result = result * PRIME + ($state == null ? 43 : $state.hashCode());
      return result;
    }
  }


  public static class PendingRequest extends StripeObject {
    /**
     * The additional amount Stripe will hold if the authorization is approved, in the card's <a
     * href="https://stripe.com/docs/api#issuing_authorization_object-pending-request-currency">currency</a>
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @SerializedName("amount_details")
    AmountDetails amountDetails;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /**
     * If set {@code true}, you may provide <a
     * href="https://stripe.com/docs/api/issuing/authorizations/approve#approve_issuing_authorization-amount">amount</a>
     * to control how much to hold for the authorization.
     */
    @SerializedName("is_amount_controllable")
    Boolean isAmountControllable;
    /**
     * The amount the merchant is requesting to be authorized in the {@code merchant_currency}. The
     * amount is in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @SerializedName("merchant_amount")
    Long merchantAmount;
    /**
     * The local currency the merchant is requesting to authorize.
     */
    @SerializedName("merchant_currency")
    String merchantCurrency;

    /**
     * The additional amount Stripe will hold if the authorization is approved, in the card's <a
     * href="https://stripe.com/docs/api#issuing_authorization_object-pending-request-currency">currency</a>
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AmountDetails getAmountDetails() {
      return this.amountDetails;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * If set {@code true}, you may provide <a
     * href="https://stripe.com/docs/api/issuing/authorizations/approve#approve_issuing_authorization-amount">amount</a>
     * to control how much to hold for the authorization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsAmountControllable() {
      return this.isAmountControllable;
    }

    /**
     * The amount the merchant is requesting to be authorized in the {@code merchant_currency}. The
     * amount is in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMerchantAmount() {
      return this.merchantAmount;
    }

    /**
     * The local currency the merchant is requesting to authorize.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMerchantCurrency() {
      return this.merchantCurrency;
    }

    /**
     * The additional amount Stripe will hold if the authorization is approved, in the card's <a
     * href="https://stripe.com/docs/api#issuing_authorization_object-pending-request-currency">currency</a>
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountDetails(final AmountDetails amountDetails) {
      this.amountDetails = amountDetails;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * If set {@code true}, you may provide <a
     * href="https://stripe.com/docs/api/issuing/authorizations/approve#approve_issuing_authorization-amount">amount</a>
     * to control how much to hold for the authorization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIsAmountControllable(final Boolean isAmountControllable) {
      this.isAmountControllable = isAmountControllable;
    }

    /**
     * The amount the merchant is requesting to be authorized in the {@code merchant_currency}. The
     * amount is in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchantAmount(final Long merchantAmount) {
      this.merchantAmount = merchantAmount;
    }

    /**
     * The local currency the merchant is requesting to authorize.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchantCurrency(final String merchantCurrency) {
      this.merchantCurrency = merchantCurrency;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.PendingRequest)) return false;
      final Authorization.PendingRequest other = (Authorization.PendingRequest) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$amountDetails = this.getAmountDetails();
      final java.lang.Object other$amountDetails = other.getAmountDetails();
      if (this$amountDetails == null ? other$amountDetails != null : !this$amountDetails.equals(other$amountDetails)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$isAmountControllable = this.getIsAmountControllable();
      final java.lang.Object other$isAmountControllable = other.getIsAmountControllable();
      if (this$isAmountControllable == null ? other$isAmountControllable != null : !this$isAmountControllable.equals(other$isAmountControllable)) return false;
      final java.lang.Object this$merchantAmount = this.getMerchantAmount();
      final java.lang.Object other$merchantAmount = other.getMerchantAmount();
      if (this$merchantAmount == null ? other$merchantAmount != null : !this$merchantAmount.equals(other$merchantAmount)) return false;
      final java.lang.Object this$merchantCurrency = this.getMerchantCurrency();
      final java.lang.Object other$merchantCurrency = other.getMerchantCurrency();
      if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.PendingRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $amountDetails = this.getAmountDetails();
      result = result * PRIME + ($amountDetails == null ? 43 : $amountDetails.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $isAmountControllable = this.getIsAmountControllable();
      result = result * PRIME + ($isAmountControllable == null ? 43 : $isAmountControllable.hashCode());
      final java.lang.Object $merchantAmount = this.getMerchantAmount();
      result = result * PRIME + ($merchantAmount == null ? 43 : $merchantAmount.hashCode());
      final java.lang.Object $merchantCurrency = this.getMerchantCurrency();
      result = result * PRIME + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
      return result;
    }
  }


  public static class RequestHistory extends StripeObject {
    /**
     * The authorization amount in your card's currency and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. Stripe
     * held this amount from your account to fund the authorization if the request was approved.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @SerializedName("amount_details")
    AmountDetails amountDetails;
    /**
     * Whether this request was approved.
     */
    @SerializedName("approved")
    Boolean approved;
    /**
     * Time at which the object was created. Measured in seconds since the Unix epoch.
     */
    @SerializedName("created")
    Long created;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /**
     * The amount that was authorized at the time of this request. This amount is in the {@code
     * merchant_currency} and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
     */
    @SerializedName("merchant_amount")
    Long merchantAmount;
    /**
     * The currency that was collected by the merchant and presented to the cardholder for the
     * authorization. Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase. Must be a <a
     * href="https://stripe.com/docs/currencies">supported currency</a>.
     */
    @SerializedName("merchant_currency")
    String merchantCurrency;
    /**
     * The reason for the approval or decline.
     *
     * <p>One of {@code account_disabled}, {@code card_active}, {@code card_inactive}, {@code
     * cardholder_inactive}, {@code cardholder_verification_required}, {@code insufficient_funds},
     * {@code not_allowed}, {@code spending_controls}, {@code suspected_fraud}, {@code
     * verification_failed}, {@code webhook_approved}, {@code webhook_declined}, or {@code
     * webhook_timeout}.
     */
    @SerializedName("reason")
    String reason;

    /**
     * The authorization amount in your card's currency and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. Stripe
     * held this amount from your account to fund the authorization if the request was approved.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AmountDetails getAmountDetails() {
      return this.amountDetails;
    }

    /**
     * Whether this request was approved.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApproved() {
      return this.approved;
    }

    /**
     * Time at which the object was created. Measured in seconds since the Unix epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreated() {
      return this.created;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * The amount that was authorized at the time of this request. This amount is in the {@code
     * merchant_currency} and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMerchantAmount() {
      return this.merchantAmount;
    }

    /**
     * The currency that was collected by the merchant and presented to the cardholder for the
     * authorization. Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase. Must be a <a
     * href="https://stripe.com/docs/currencies">supported currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMerchantCurrency() {
      return this.merchantCurrency;
    }

    /**
     * The reason for the approval or decline.
     *
     * <p>One of {@code account_disabled}, {@code card_active}, {@code card_inactive}, {@code
     * cardholder_inactive}, {@code cardholder_verification_required}, {@code insufficient_funds},
     * {@code not_allowed}, {@code spending_controls}, {@code suspected_fraud}, {@code
     * verification_failed}, {@code webhook_approved}, {@code webhook_declined}, or {@code
     * webhook_timeout}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReason() {
      return this.reason;
    }

    /**
     * The authorization amount in your card's currency and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. Stripe
     * held this amount from your account to fund the authorization if the request was approved.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    /**
     * Detailed breakdown of amount components. These amounts are denominated in {@code currency}
     * and in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
     * unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountDetails(final AmountDetails amountDetails) {
      this.amountDetails = amountDetails;
    }

    /**
     * Whether this request was approved.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApproved(final Boolean approved) {
      this.approved = approved;
    }

    /**
     * Time at which the object was created. Measured in seconds since the Unix epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCreated(final Long created) {
      this.created = created;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * The amount that was authorized at the time of this request. This amount is in the {@code
     * merchant_currency} and in the <a
     * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchantAmount(final Long merchantAmount) {
      this.merchantAmount = merchantAmount;
    }

    /**
     * The currency that was collected by the merchant and presented to the cardholder for the
     * authorization. Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase. Must be a <a
     * href="https://stripe.com/docs/currencies">supported currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchantCurrency(final String merchantCurrency) {
      this.merchantCurrency = merchantCurrency;
    }

    /**
     * The reason for the approval or decline.
     *
     * <p>One of {@code account_disabled}, {@code card_active}, {@code card_inactive}, {@code
     * cardholder_inactive}, {@code cardholder_verification_required}, {@code insufficient_funds},
     * {@code not_allowed}, {@code spending_controls}, {@code suspected_fraud}, {@code
     * verification_failed}, {@code webhook_approved}, {@code webhook_declined}, or {@code
     * webhook_timeout}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final String reason) {
      this.reason = reason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.RequestHistory)) return false;
      final Authorization.RequestHistory other = (Authorization.RequestHistory) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$amountDetails = this.getAmountDetails();
      final java.lang.Object other$amountDetails = other.getAmountDetails();
      if (this$amountDetails == null ? other$amountDetails != null : !this$amountDetails.equals(other$amountDetails)) return false;
      final java.lang.Object this$approved = this.getApproved();
      final java.lang.Object other$approved = other.getApproved();
      if (this$approved == null ? other$approved != null : !this$approved.equals(other$approved)) return false;
      final java.lang.Object this$created = this.getCreated();
      final java.lang.Object other$created = other.getCreated();
      if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$merchantAmount = this.getMerchantAmount();
      final java.lang.Object other$merchantAmount = other.getMerchantAmount();
      if (this$merchantAmount == null ? other$merchantAmount != null : !this$merchantAmount.equals(other$merchantAmount)) return false;
      final java.lang.Object this$merchantCurrency = this.getMerchantCurrency();
      final java.lang.Object other$merchantCurrency = other.getMerchantCurrency();
      if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) return false;
      final java.lang.Object this$reason = this.getReason();
      final java.lang.Object other$reason = other.getReason();
      if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.RequestHistory;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $amountDetails = this.getAmountDetails();
      result = result * PRIME + ($amountDetails == null ? 43 : $amountDetails.hashCode());
      final java.lang.Object $approved = this.getApproved();
      result = result * PRIME + ($approved == null ? 43 : $approved.hashCode());
      final java.lang.Object $created = this.getCreated();
      result = result * PRIME + ($created == null ? 43 : $created.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $merchantAmount = this.getMerchantAmount();
      result = result * PRIME + ($merchantAmount == null ? 43 : $merchantAmount.hashCode());
      final java.lang.Object $merchantCurrency = this.getMerchantCurrency();
      result = result * PRIME + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
      final java.lang.Object $reason = this.getReason();
      result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
      return result;
    }
  }


  public static class VerificationData extends StripeObject {
    /**
     * Whether the cardholder provided an address first line and if it matched the cardholder’s
     * {@code billing.address.line1}.
     *
     * <p>One of {@code match}, {@code mismatch}, or {@code not_provided}.
     */
    @SerializedName("address_line1_check")
    String addressLine1Check;
    /**
     * Whether the cardholder provided a postal code and if it matched the cardholder’s {@code
     * billing.address.postal_code}.
     *
     * <p>One of {@code match}, {@code mismatch}, or {@code not_provided}.
     */
    @SerializedName("address_postal_code_check")
    String addressPostalCodeCheck;
    /**
     * Whether the cardholder provided a CVC and if it matched Stripe’s record.
     *
     * <p>One of {@code match}, {@code mismatch}, or {@code not_provided}.
     */
    @SerializedName("cvc_check")
    String cvcCheck;
    /**
     * Whether the cardholder provided an expiry date and if it matched Stripe’s record.
     *
     * <p>One of {@code match}, {@code mismatch}, or {@code not_provided}.
     */
    @SerializedName("expiry_check")
    String expiryCheck;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressLine1Check() {
      return this.addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressPostalCodeCheck() {
      return this.addressPostalCodeCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCvcCheck() {
      return this.cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExpiryCheck() {
      return this.expiryCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressLine1Check(final String addressLine1Check) {
      this.addressLine1Check = addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressPostalCodeCheck(final String addressPostalCodeCheck) {
      this.addressPostalCodeCheck = addressPostalCodeCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcCheck(final String cvcCheck) {
      this.cvcCheck = cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpiryCheck(final String expiryCheck) {
      this.expiryCheck = expiryCheck;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.VerificationData)) return false;
      final Authorization.VerificationData other = (Authorization.VerificationData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
      final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
      if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
      final java.lang.Object this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
      final java.lang.Object other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
      if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) return false;
      final java.lang.Object this$cvcCheck = this.getCvcCheck();
      final java.lang.Object other$cvcCheck = other.getCvcCheck();
      if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
      final java.lang.Object this$expiryCheck = this.getExpiryCheck();
      final java.lang.Object other$expiryCheck = other.getExpiryCheck();
      if (this$expiryCheck == null ? other$expiryCheck != null : !this$expiryCheck.equals(other$expiryCheck)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.VerificationData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
      result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
      final java.lang.Object $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
      result = result * PRIME + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
      final java.lang.Object $cvcCheck = this.getCvcCheck();
      result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
      final java.lang.Object $expiryCheck = this.getExpiryCheck();
      result = result * PRIME + ($expiryCheck == null ? 43 : $expiryCheck.hashCode());
      return result;
    }
  }

  /**
   * The total amount that was authorized or rejected. This amount is in the card's currency and in
   * the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Detailed breakdown of amount components. These amounts are denominated in {@code currency} and
   * in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AmountDetails getAmountDetails() {
    return this.amountDetails;
  }

  /**
   * Whether the authorization has been approved.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getApproved() {
    return this.approved;
  }

  /**
   * How the card details were provided.
   *
   * <p>One of {@code chip}, {@code contactless}, {@code keyed_in}, {@code online}, or {@code
   * swipe}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthorizationMethod() {
    return this.authorizationMethod;
  }

  /**
   * List of balance transactions associated with this authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction> getBalanceTransactions() {
    return this.balanceTransactions;
  }

  /**
   * You can <a href="https://stripe.com/docs/issuing/cards">create physical or virtual cards</a>
   * that are issued to cardholders.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Card getCard() {
    return this.card;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The total amount that was authorized or rejected. This amount is in the {@code
   * merchant_currency} and in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getMerchantAmount() {
    return this.merchantAmount;
  }

  /**
   * The currency that was presented to the cardholder for the authorization. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMerchantCurrency() {
    return this.merchantCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public MerchantData getMerchantData() {
    return this.merchantData;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.authorization}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The pending authorization request. This field will only be non-null during an {@code
   * issuing_authorization.request} webhook.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PendingRequest getPendingRequest() {
    return this.pendingRequest;
  }

  /**
   * History of every time the authorization was approved/denied (whether approved/denied by you
   * directly or by Stripe based on your {@code spending_controls}). If the merchant changes the
   * authorization by performing an <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">incremental authorization or
   * partial capture</a>, you can look at this field to see the previous states of the
   * authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Authorization.RequestHistory> getRequestHistory() {
    return this.requestHistory;
  }

  /**
   * The current status of the authorization in its lifecycle.
   *
   * <p>One of {@code closed}, {@code pending}, or {@code reversed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * List of <a href="https://stripe.com/docs/api/issuing/transactions">transactions</a> associated
   * with this authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Transaction> getTransactions() {
    return this.transactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VerificationData getVerificationData() {
    return this.verificationData;
  }

  /**
   * What, if any, digital wallet was used for this authorization. One of {@code apple_pay}, {@code
   * google_pay}, or {@code samsung_pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getWallet() {
    return this.wallet;
  }

  /**
   * The total amount that was authorized or rejected. This amount is in the card's currency and in
   * the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Detailed breakdown of amount components. These amounts are denominated in {@code currency} and
   * in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountDetails(final AmountDetails amountDetails) {
    this.amountDetails = amountDetails;
  }

  /**
   * Whether the authorization has been approved.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApproved(final Boolean approved) {
    this.approved = approved;
  }

  /**
   * How the card details were provided.
   *
   * <p>One of {@code chip}, {@code contactless}, {@code keyed_in}, {@code online}, or {@code
   * swipe}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizationMethod(final String authorizationMethod) {
    this.authorizationMethod = authorizationMethod;
  }

  /**
   * List of balance transactions associated with this authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransactions(final List<BalanceTransaction> balanceTransactions) {
    this.balanceTransactions = balanceTransactions;
  }

  /**
   * You can <a href="https://stripe.com/docs/issuing/cards">create physical or virtual cards</a>
   * that are issued to cardholders.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCard(final Card card) {
    this.card = card;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The total amount that was authorized or rejected. This amount is in the {@code
   * merchant_currency} and in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMerchantAmount(final Long merchantAmount) {
    this.merchantAmount = merchantAmount;
  }

  /**
   * The currency that was presented to the cardholder for the authorization. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMerchantCurrency(final String merchantCurrency) {
    this.merchantCurrency = merchantCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMerchantData(final MerchantData merchantData) {
    this.merchantData = merchantData;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.authorization}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The pending authorization request. This field will only be non-null during an {@code
   * issuing_authorization.request} webhook.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingRequest(final PendingRequest pendingRequest) {
    this.pendingRequest = pendingRequest;
  }

  /**
   * History of every time the authorization was approved/denied (whether approved/denied by you
   * directly or by Stripe based on your {@code spending_controls}). If the merchant changes the
   * authorization by performing an <a
   * href="https://stripe.com/docs/issuing/purchases/authorizations">incremental authorization or
   * partial capture</a>, you can look at this field to see the previous states of the
   * authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequestHistory(final List<Authorization.RequestHistory> requestHistory) {
    this.requestHistory = requestHistory;
  }

  /**
   * The current status of the authorization in its lifecycle.
   *
   * <p>One of {@code closed}, {@code pending}, or {@code reversed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * List of <a href="https://stripe.com/docs/api/issuing/transactions">transactions</a> associated
   * with this authorization.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransactions(final List<Transaction> transactions) {
    this.transactions = transactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerificationData(final VerificationData verificationData) {
    this.verificationData = verificationData;
  }

  /**
   * What, if any, digital wallet was used for this authorization. One of {@code apple_pay}, {@code
   * google_pay}, or {@code samsung_pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWallet(final String wallet) {
    this.wallet = wallet;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Authorization)) return false;
    final Authorization other = (Authorization) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountDetails = this.getAmountDetails();
    final java.lang.Object other$amountDetails = other.getAmountDetails();
    if (this$amountDetails == null ? other$amountDetails != null : !this$amountDetails.equals(other$amountDetails)) return false;
    final java.lang.Object this$approved = this.getApproved();
    final java.lang.Object other$approved = other.getApproved();
    if (this$approved == null ? other$approved != null : !this$approved.equals(other$approved)) return false;
    final java.lang.Object this$authorizationMethod = this.getAuthorizationMethod();
    final java.lang.Object other$authorizationMethod = other.getAuthorizationMethod();
    if (this$authorizationMethod == null ? other$authorizationMethod != null : !this$authorizationMethod.equals(other$authorizationMethod)) return false;
    final java.lang.Object this$balanceTransactions = this.getBalanceTransactions();
    final java.lang.Object other$balanceTransactions = other.getBalanceTransactions();
    if (this$balanceTransactions == null ? other$balanceTransactions != null : !this$balanceTransactions.equals(other$balanceTransactions)) return false;
    final java.lang.Object this$card = this.getCard();
    final java.lang.Object other$card = other.getCard();
    if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
    final java.lang.Object this$cardholder = this.getCardholder();
    final java.lang.Object other$cardholder = other.getCardholder();
    if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$merchantAmount = this.getMerchantAmount();
    final java.lang.Object other$merchantAmount = other.getMerchantAmount();
    if (this$merchantAmount == null ? other$merchantAmount != null : !this$merchantAmount.equals(other$merchantAmount)) return false;
    final java.lang.Object this$merchantCurrency = this.getMerchantCurrency();
    final java.lang.Object other$merchantCurrency = other.getMerchantCurrency();
    if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) return false;
    final java.lang.Object this$merchantData = this.getMerchantData();
    final java.lang.Object other$merchantData = other.getMerchantData();
    if (this$merchantData == null ? other$merchantData != null : !this$merchantData.equals(other$merchantData)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$pendingRequest = this.getPendingRequest();
    final java.lang.Object other$pendingRequest = other.getPendingRequest();
    if (this$pendingRequest == null ? other$pendingRequest != null : !this$pendingRequest.equals(other$pendingRequest)) return false;
    final java.lang.Object this$requestHistory = this.getRequestHistory();
    final java.lang.Object other$requestHistory = other.getRequestHistory();
    if (this$requestHistory == null ? other$requestHistory != null : !this$requestHistory.equals(other$requestHistory)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transactions = this.getTransactions();
    final java.lang.Object other$transactions = other.getTransactions();
    if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) return false;
    final java.lang.Object this$verificationData = this.getVerificationData();
    final java.lang.Object other$verificationData = other.getVerificationData();
    if (this$verificationData == null ? other$verificationData != null : !this$verificationData.equals(other$verificationData)) return false;
    final java.lang.Object this$wallet = this.getWallet();
    final java.lang.Object other$wallet = other.getWallet();
    if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Authorization;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountDetails = this.getAmountDetails();
    result = result * PRIME + ($amountDetails == null ? 43 : $amountDetails.hashCode());
    final java.lang.Object $approved = this.getApproved();
    result = result * PRIME + ($approved == null ? 43 : $approved.hashCode());
    final java.lang.Object $authorizationMethod = this.getAuthorizationMethod();
    result = result * PRIME + ($authorizationMethod == null ? 43 : $authorizationMethod.hashCode());
    final java.lang.Object $balanceTransactions = this.getBalanceTransactions();
    result = result * PRIME + ($balanceTransactions == null ? 43 : $balanceTransactions.hashCode());
    final java.lang.Object $card = this.getCard();
    result = result * PRIME + ($card == null ? 43 : $card.hashCode());
    final java.lang.Object $cardholder = this.getCardholder();
    result = result * PRIME + ($cardholder == null ? 43 : $cardholder.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $merchantAmount = this.getMerchantAmount();
    result = result * PRIME + ($merchantAmount == null ? 43 : $merchantAmount.hashCode());
    final java.lang.Object $merchantCurrency = this.getMerchantCurrency();
    result = result * PRIME + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
    final java.lang.Object $merchantData = this.getMerchantData();
    result = result * PRIME + ($merchantData == null ? 43 : $merchantData.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $pendingRequest = this.getPendingRequest();
    result = result * PRIME + ($pendingRequest == null ? 43 : $pendingRequest.hashCode());
    final java.lang.Object $requestHistory = this.getRequestHistory();
    result = result * PRIME + ($requestHistory == null ? 43 : $requestHistory.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transactions = this.getTransactions();
    result = result * PRIME + ($transactions == null ? 43 : $transactions.hashCode());
    final java.lang.Object $verificationData = this.getVerificationData();
    result = result * PRIME + ($verificationData == null ? 43 : $verificationData.hashCode());
    final java.lang.Object $wallet = this.getWallet();
    result = result * PRIME + ($wallet == null ? 43 : $wallet.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
