// Generated by delombok at Wed Nov 04 15:19:56 PST 2020
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.radar.Rule;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ChargeCaptureParams;
import com.stripe.param.ChargeCreateParams;
import com.stripe.param.ChargeListParams;
import com.stripe.param.ChargeRetrieveParams;
import com.stripe.param.ChargeUpdateParams;
import java.util.List;
import java.util.Map;

public class Charge extends ApiResource implements MetadataStore<Charge>, BalanceTransactionSource {
  @SerializedName("alternate_statement_descriptors")
  AlternateStatementDescriptors alternateStatementDescriptors;
  /**
   * Amount intended to be collected by this payment. A positive integer representing how much to
   * charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Amount in %s captured (can be less than the amount attribute on the charge if a partial capture
   * was made).
   */
  @SerializedName("amount_captured")
  Long amountCaptured;
  /**
   * Amount in %s refunded (can be less than the amount attribute on the charge if a partial refund
   * was issued).
   */
  @SerializedName("amount_refunded")
  Long amountRefunded;
  /**
   * ID of the Connect application that created the charge.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * The application fee (if any) for the charge. <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">See the Connect
   * documentation</a> for details.
   */
  @SerializedName("application_fee")
  ExpandableField<ApplicationFee> applicationFee;
  /**
   * The amount of the application fee (if any) requested for the charge. <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">See the Connect
   * documentation</a> for details.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * Authorization code on the charge.
   */
  @SerializedName("authorization_code")
  String authorizationCode;
  /**
   * ID of the balance transaction that describes the impact of this charge on your account balance
   * (not including refunds or disputes).
   */
  @SerializedName("balance_transaction")
  ExpandableField<BalanceTransaction> balanceTransaction;
  @SerializedName("billing_details")
  PaymentMethod.BillingDetails billingDetails;
  /**
   * The full statement descriptor that is passed to card networks, and that is displayed on your
   * customers' credit card and bank statements. Allows you to see what the statement descriptor
   * looks like after the static and dynamic portions are combined.
   */
  @SerializedName("calculated_statement_descriptor")
  String calculatedStatementDescriptor;
  /**
   * If the charge was created without capturing, this Boolean represents whether it is still
   * uncaptured or has since been captured.
   */
  @SerializedName("captured")
  Boolean captured;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the customer this charge is for if one exists.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * ID of an existing, connected Stripe account to transfer funds to if {@code transfer_data} was
   * specified in the charge request.
   */
  @SerializedName("destination")
  ExpandableField<Account> destination;
  /**
   * Details about the dispute if the charge has been disputed.
   */
  @SerializedName("dispute")
  ExpandableField<Dispute> dispute;
  /**
   * Whether the charge has been disputed.
   */
  @SerializedName("disputed")
  Boolean disputed;
  /**
   * Error code explaining reason for charge failure if available (see <a
   * href="https://stripe.com/docs/api#errors">the errors section</a> for a list of codes).
   */
  @SerializedName("failure_code")
  String failureCode;
  /**
   * Message to user further explaining reason for charge failure if available.
   */
  @SerializedName("failure_message")
  String failureMessage;
  /**
   * Information on fraud assessments for the charge.
   */
  @SerializedName("fraud_details")
  FraudDetails fraudDetails;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * ID of the invoice this charge is for if one exists.
   */
  @SerializedName("invoice")
  ExpandableField<Invoice> invoice;
  @SerializedName("level3")
  Level3 level3;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code charge}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) the charge was made on behalf of without triggering an automatic transfer.
   * See the <a href="https://stripe.com/docs/connect/charges-transfers">Connect documentation</a>
   * for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the order this charge is for if one exists.
   */
  @SerializedName("order")
  ExpandableField<Order> order;
  /**
   * Details about whether the payment was accepted, and why. See <a
   * href="https://stripe.com/docs/declines">understanding declines</a> for details.
   */
  @SerializedName("outcome")
  Outcome outcome;
  /**
   * {@code true} if the charge succeeded, or was successfully authorized for later capture.
   */
  @SerializedName("paid")
  Boolean paid;
  /**
   * ID of the PaymentIntent associated with this charge, if one exists.
   */
  @SerializedName("payment_intent")
  ExpandableField<PaymentIntent> paymentIntent;
  /**
   * ID of the payment method used in this charge.
   */
  @SerializedName("payment_method")
  String paymentMethod;
  /**
   * Details about the payment method at the time of the transaction.
   */
  @SerializedName("payment_method_details")
  PaymentMethodDetails paymentMethodDetails;
  /**
   * This is the email address that the receipt for this charge was sent to.
   */
  @SerializedName("receipt_email")
  String receiptEmail;
  /**
   * This is the transaction number that appears on email receipts sent for this charge. This
   * attribute will be {@code null} until a receipt has been sent.
   */
  @SerializedName("receipt_number")
  String receiptNumber;
  /**
   * This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the
   * latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt
   * will be stylized as an Invoice receipt.
   */
  @SerializedName("receipt_url")
  String receiptUrl;
  /**
   * Whether the charge has been fully refunded. If the charge is only partially refunded, this
   * attribute will still be false.
   */
  @SerializedName("refunded")
  Boolean refunded;
  /**
   * A list of refunds that have been applied to the charge.
   */
  @SerializedName("refunds")
  RefundCollection refunds;
  /**
   * ID of the review associated with this charge if one exists.
   */
  @SerializedName("review")
  ExpandableField<Review> review;
  /**
   * Shipping information for the charge.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * This is a legacy field that will be removed in the future. It contains the Source, Card, or
   * BankAccount object used for the charge. For details about the payment method used for this
   * charge, refer to {@code payment_method} or {@code payment_method_details} instead.
   */
  @SerializedName("source")
  PaymentSource source;
  /**
   * The transfer ID which created this charge. Only present if the charge came from another Stripe
   * account. <a href="https://stripe.com/docs/connect/destination-charges">See the Connect
   * documentation</a> for details.
   */
  @SerializedName("source_transfer")
  ExpandableField<Transfer> sourceTransfer;
  /**
   * For card charges, use {@code statement_descriptor_suffix} instead. Otherwise, you can use this
   * value as the complete description of a charge on your customers’ statements. Must contain at
   * least one letter, maximum 22 characters.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Provides information about the charge that customers see on their statements. Concatenated with
   * the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the
   * complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @SerializedName("statement_descriptor_suffix")
  String statementDescriptorSuffix;
  /**
   * The status of the payment is either {@code succeeded}, {@code pending}, or {@code failed}.
   */
  @SerializedName("status")
  String status;
  /**
   * ID of the transfer to the {@code destination} account (only applicable if the charge was
   * created using the {@code destination} parameter).
   */
  @SerializedName("transfer")
  ExpandableField<Transfer> transfer;
  /**
   * An optional dictionary including the account to automatically transfer to as part of a
   * destination charge. <a href="https://stripe.com/docs/connect/destination-charges">See the
   * Connect documentation</a> for details.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers#transfer-options">Connect
   * documentation</a> for details.
   */
  @SerializedName("transfer_group")
  String transferGroup;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code applicationFee} object.
   */
  public String getApplicationFee() {
    return (this.applicationFee != null) ? this.applicationFee.getId() : null;
  }

  public void setApplicationFee(String id) {
    this.applicationFee = ApiResource.setExpandableFieldId(id, this.applicationFee);
  }

  /**
   * Get expanded {@code applicationFee}.
   */
  public ApplicationFee getApplicationFeeObject() {
    return (this.applicationFee != null) ? this.applicationFee.getExpanded() : null;
  }

  public void setApplicationFeeObject(ApplicationFee expandableObject) {
    this.applicationFee = new ExpandableField<ApplicationFee>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code balanceTransaction} object.
   */
  public String getBalanceTransaction() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getId() : null;
  }

  public void setBalanceTransaction(String id) {
    this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
  }

  /**
   * Get expanded {@code balanceTransaction}.
   */
  public BalanceTransaction getBalanceTransactionObject() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getExpanded() : null;
  }

  public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
    this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code destination} object.
   */
  public String getDestination() {
    return (this.destination != null) ? this.destination.getId() : null;
  }

  public void setDestination(String id) {
    this.destination = ApiResource.setExpandableFieldId(id, this.destination);
  }

  /**
   * Get expanded {@code destination}.
   */
  public Account getDestinationObject() {
    return (this.destination != null) ? this.destination.getExpanded() : null;
  }

  public void setDestinationObject(Account expandableObject) {
    this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code dispute} object.
   */
  public String getDispute() {
    return (this.dispute != null) ? this.dispute.getId() : null;
  }

  public void setDispute(String id) {
    this.dispute = ApiResource.setExpandableFieldId(id, this.dispute);
  }

  /**
   * Get expanded {@code dispute}.
   */
  public Dispute getDisputeObject() {
    return (this.dispute != null) ? this.dispute.getExpanded() : null;
  }

  public void setDisputeObject(Dispute expandableObject) {
    this.dispute = new ExpandableField<Dispute>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code invoice} object.
   */
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String id) {
    this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
  }

  /**
   * Get expanded {@code invoice}.
   */
  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice expandableObject) {
    this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code order} object.
   */
  public String getOrder() {
    return (this.order != null) ? this.order.getId() : null;
  }

  public void setOrder(String id) {
    this.order = ApiResource.setExpandableFieldId(id, this.order);
  }

  /**
   * Get expanded {@code order}.
   */
  public Order getOrderObject() {
    return (this.order != null) ? this.order.getExpanded() : null;
  }

  public void setOrderObject(Order expandableObject) {
    this.order = new ExpandableField<Order>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentIntent} object.
   */
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String id) {
    this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
  }

  /**
   * Get expanded {@code paymentIntent}.
   */
  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent expandableObject) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code review} object.
   */
  public String getReview() {
    return (this.review != null) ? this.review.getId() : null;
  }

  public void setReview(String id) {
    this.review = ApiResource.setExpandableFieldId(id, this.review);
  }

  /**
   * Get expanded {@code review}.
   */
  public Review getReviewObject() {
    return (this.review != null) ? this.review.getExpanded() : null;
  }

  public void setReviewObject(Review expandableObject) {
    this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code sourceTransfer} object.
   */
  public String getSourceTransfer() {
    return (this.sourceTransfer != null) ? this.sourceTransfer.getId() : null;
  }

  public void setSourceTransfer(String id) {
    this.sourceTransfer = ApiResource.setExpandableFieldId(id, this.sourceTransfer);
  }

  /**
   * Get expanded {@code sourceTransfer}.
   */
  public Transfer getSourceTransferObject() {
    return (this.sourceTransfer != null) ? this.sourceTransfer.getExpanded() : null;
  }

  public void setSourceTransferObject(Transfer expandableObject) {
    this.sourceTransfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code transfer} object.
   */
  public String getTransfer() {
    return (this.transfer != null) ? this.transfer.getId() : null;
  }

  public void setTransfer(String id) {
    this.transfer = ApiResource.setExpandableFieldId(id, this.transfer);
  }

  /**
   * Get expanded {@code transfer}.
   */
  public Transfer getTransferObject() {
    return (this.transfer != null) ? this.transfer.getExpanded() : null;
  }

  public void setTransferObject(Transfer expandableObject) {
    this.transfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of charges you’ve previously created. The charges are returned in sorted order,
   * with the most recent charges appearing first.
   */
  public static ChargeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of charges you’ve previously created. The charges are returned in sorted order,
   * with the most recent charges appearing first.
   */
  public static ChargeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
    return ApiResource.requestCollection(url, params, ChargeCollection.class, options);
  }

  /**
   * Returns a list of charges you’ve previously created. The charges are returned in sorted order,
   * with the most recent charges appearing first.
   */
  public static ChargeCollection list(ChargeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of charges you’ve previously created. The charges are returned in sorted order,
   * with the most recent charges appearing first.
   */
  public static ChargeCollection list(ChargeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
    return ApiResource.requestCollection(url, params, ChargeCollection.class, options);
  }

  /**
   * To charge a credit card or other payment source, you create a <code>Charge</code> object. If
   * your API key is in test mode, the supplied payment source (e.g., card) won’t actually be
   * charged, although everything else will occur as if in live mode. (Stripe assumes that the
   * charge would have completed successfully).
   */
  public static Charge create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To charge a credit card or other payment source, you create a <code>Charge</code> object. If
   * your API key is in test mode, the supplied payment source (e.g., card) won’t actually be
   * charged, although everything else will occur as if in live mode. (Stripe assumes that the
   * charge would have completed successfully).
   */
  public static Charge create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }

  /**
   * To charge a credit card or other payment source, you create a <code>Charge</code> object. If
   * your API key is in test mode, the supplied payment source (e.g., card) won’t actually be
   * charged, although everything else will occur as if in live mode. (Stripe assumes that the
   * charge would have completed successfully).
   */
  public static Charge create(ChargeCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To charge a credit card or other payment source, you create a <code>Charge</code> object. If
   * your API key is in test mode, the supplied payment source (e.g., card) won’t actually be
   * charged, although everything else will occur as if in live mode. (Stripe assumes that the
   * charge would have completed successfully).
   */
  public static Charge create(ChargeCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/charges");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }

  /**
   * Retrieves the details of a charge that has previously been created. Supply the unique charge ID
   * that was returned from your previous request, and Stripe will return the corresponding charge
   * information. The same information is returned when creating or refunding the charge.
   */
  public static Charge retrieve(String charge) throws StripeException {
    return retrieve(charge, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a charge that has previously been created. Supply the unique charge ID
   * that was returned from your previous request, and Stripe will return the corresponding charge
   * information. The same information is returned when creating or refunding the charge.
   */
  public static Charge retrieve(String charge, RequestOptions options) throws StripeException {
    return retrieve(charge, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a charge that has previously been created. Supply the unique charge ID
   * that was returned from your previous request, and Stripe will return the corresponding charge
   * information. The same information is returned when creating or refunding the charge.
   */
  public static Charge retrieve(String charge, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Charge.class, options);
  }

  /**
   * Retrieves the details of a charge that has previously been created. Supply the unique charge ID
   * that was returned from your previous request, and Stripe will return the corresponding charge
   * information. The same information is returned when creating or refunding the charge.
   */
  public static Charge retrieve(String charge, ChargeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Charge.class, options);
  }

  /**
   * Updates the specified charge by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Charge update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified charge by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Charge update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }

  /**
   * Updates the specified charge by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Charge update(ChargeUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified charge by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Charge update(ChargeUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture() throws StripeException {
    return capture((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture(RequestOptions options) throws StripeException {
    return capture((Map<String, Object>) null, options);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture(Map<String, Object> params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture(ChargeCaptureParams params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the payment of an existing, uncaptured, charge. This is the second half of the two-step
   * payment flow, where first you <a href="https://stripe.com/docs/api#create_charge">created a
   * charge</a> with the capture option set to false.
   *
   * <p>Uncaptured payments expire exactly seven days after they are created. If they are not
   * captured by that point in time, they will be marked as refunded and will no longer be
   * capturable.
   */
  public Charge capture(ChargeCaptureParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/charges/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Charge.class, options);
  }


  public static class AlternateStatementDescriptors extends StripeObject {
    /**
     * The Kana variation of the descriptor.
     */
    @SerializedName("kana")
    String kana;
    /**
     * The Kanji variation of the descriptor.
     */
    @SerializedName("kanji")
    String kanji;

    /**
     * The Kana variation of the descriptor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKana() {
      return this.kana;
    }

    /**
     * The Kanji variation of the descriptor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKanji() {
      return this.kanji;
    }

    /**
     * The Kana variation of the descriptor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKana(final String kana) {
      this.kana = kana;
    }

    /**
     * The Kanji variation of the descriptor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKanji(final String kanji) {
      this.kanji = kanji;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.AlternateStatementDescriptors)) return false;
      final Charge.AlternateStatementDescriptors other = (Charge.AlternateStatementDescriptors) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$kana = this.getKana();
      final java.lang.Object other$kana = other.getKana();
      if (this$kana == null ? other$kana != null : !this$kana.equals(other$kana)) return false;
      final java.lang.Object this$kanji = this.getKanji();
      final java.lang.Object other$kanji = other.getKanji();
      if (this$kanji == null ? other$kanji != null : !this$kanji.equals(other$kanji)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.AlternateStatementDescriptors;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $kana = this.getKana();
      result = result * PRIME + ($kana == null ? 43 : $kana.hashCode());
      final java.lang.Object $kanji = this.getKanji();
      result = result * PRIME + ($kanji == null ? 43 : $kanji.hashCode());
      return result;
    }
  }


  public static class FraudDetails extends StripeObject {
    /**
     * Assessments from Stripe. If set, the value is {@code fraudulent}.
     */
    @SerializedName("stripe_report")
    String stripeReport;
    /**
     * Assessments reported by you. If set, possible values of are {@code safe} and {@code
     * fraudulent}.
     */
    @SerializedName("user_report")
    String userReport;

    /**
     * Assessments from Stripe. If set, the value is {@code fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStripeReport() {
      return this.stripeReport;
    }

    /**
     * Assessments reported by you. If set, possible values of are {@code safe} and {@code
     * fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserReport() {
      return this.userReport;
    }

    /**
     * Assessments from Stripe. If set, the value is {@code fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStripeReport(final String stripeReport) {
      this.stripeReport = stripeReport;
    }

    /**
     * Assessments reported by you. If set, possible values of are {@code safe} and {@code
     * fraudulent}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserReport(final String userReport) {
      this.userReport = userReport;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.FraudDetails)) return false;
      final Charge.FraudDetails other = (Charge.FraudDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$stripeReport = this.getStripeReport();
      final java.lang.Object other$stripeReport = other.getStripeReport();
      if (this$stripeReport == null ? other$stripeReport != null : !this$stripeReport.equals(other$stripeReport)) return false;
      final java.lang.Object this$userReport = this.getUserReport();
      final java.lang.Object other$userReport = other.getUserReport();
      if (this$userReport == null ? other$userReport != null : !this$userReport.equals(other$userReport)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.FraudDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $stripeReport = this.getStripeReport();
      result = result * PRIME + ($stripeReport == null ? 43 : $stripeReport.hashCode());
      final java.lang.Object $userReport = this.getUserReport();
      result = result * PRIME + ($userReport == null ? 43 : $userReport.hashCode());
      return result;
    }
  }


  public static class Level3 extends StripeObject {
    @SerializedName("customer_reference")
    String customerReference;
    @SerializedName("line_items")
    List<Charge.Level3.LineItem> lineItems;
    @SerializedName("merchant_reference")
    String merchantReference;
    @SerializedName("shipping_address_zip")
    String shippingAddressZip;
    @SerializedName("shipping_amount")
    Long shippingAmount;
    @SerializedName("shipping_from_zip")
    String shippingFromZip;


    public static class LineItem extends StripeObject {
      @SerializedName("discount_amount")
      Long discountAmount;
      @SerializedName("product_code")
      String productCode;
      @SerializedName("product_description")
      String productDescription;
      @SerializedName("quantity")
      Long quantity;
      @SerializedName("tax_amount")
      Long taxAmount;
      @SerializedName("unit_cost")
      Long unitCost;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDiscountAmount() {
        return this.discountAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductCode() {
        return this.productCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductDescription() {
        return this.productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getQuantity() {
        return this.quantity;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getTaxAmount() {
        return this.taxAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getUnitCost() {
        return this.unitCost;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDiscountAmount(final Long discountAmount) {
        this.discountAmount = discountAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductCode(final String productCode) {
        this.productCode = productCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductDescription(final String productDescription) {
        this.productDescription = productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setQuantity(final Long quantity) {
        this.quantity = quantity;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTaxAmount(final Long taxAmount) {
        this.taxAmount = taxAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUnitCost(final Long unitCost) {
        this.unitCost = unitCost;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.Level3.LineItem)) return false;
        final Charge.Level3.LineItem other = (Charge.Level3.LineItem) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$discountAmount = this.getDiscountAmount();
        final java.lang.Object other$discountAmount = other.getDiscountAmount();
        if (this$discountAmount == null ? other$discountAmount != null : !this$discountAmount.equals(other$discountAmount)) return false;
        final java.lang.Object this$quantity = this.getQuantity();
        final java.lang.Object other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
        final java.lang.Object this$taxAmount = this.getTaxAmount();
        final java.lang.Object other$taxAmount = other.getTaxAmount();
        if (this$taxAmount == null ? other$taxAmount != null : !this$taxAmount.equals(other$taxAmount)) return false;
        final java.lang.Object this$unitCost = this.getUnitCost();
        final java.lang.Object other$unitCost = other.getUnitCost();
        if (this$unitCost == null ? other$unitCost != null : !this$unitCost.equals(other$unitCost)) return false;
        final java.lang.Object this$productCode = this.getProductCode();
        final java.lang.Object other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) return false;
        final java.lang.Object this$productDescription = this.getProductDescription();
        final java.lang.Object other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.Level3.LineItem;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $discountAmount = this.getDiscountAmount();
        result = result * PRIME + ($discountAmount == null ? 43 : $discountAmount.hashCode());
        final java.lang.Object $quantity = this.getQuantity();
        result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
        final java.lang.Object $taxAmount = this.getTaxAmount();
        result = result * PRIME + ($taxAmount == null ? 43 : $taxAmount.hashCode());
        final java.lang.Object $unitCost = this.getUnitCost();
        result = result * PRIME + ($unitCost == null ? 43 : $unitCost.hashCode());
        final java.lang.Object $productCode = this.getProductCode();
        result = result * PRIME + ($productCode == null ? 43 : $productCode.hashCode());
        final java.lang.Object $productDescription = this.getProductDescription();
        result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomerReference() {
      return this.customerReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Charge.Level3.LineItem> getLineItems() {
      return this.lineItems;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMerchantReference() {
      return this.merchantReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingAddressZip() {
      return this.shippingAddressZip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getShippingAmount() {
      return this.shippingAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingFromZip() {
      return this.shippingFromZip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerReference(final String customerReference) {
      this.customerReference = customerReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLineItems(final List<Charge.Level3.LineItem> lineItems) {
      this.lineItems = lineItems;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchantReference(final String merchantReference) {
      this.merchantReference = merchantReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingAddressZip(final String shippingAddressZip) {
      this.shippingAddressZip = shippingAddressZip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingAmount(final Long shippingAmount) {
      this.shippingAmount = shippingAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingFromZip(final String shippingFromZip) {
      this.shippingFromZip = shippingFromZip;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.Level3)) return false;
      final Charge.Level3 other = (Charge.Level3) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$shippingAmount = this.getShippingAmount();
      final java.lang.Object other$shippingAmount = other.getShippingAmount();
      if (this$shippingAmount == null ? other$shippingAmount != null : !this$shippingAmount.equals(other$shippingAmount)) return false;
      final java.lang.Object this$customerReference = this.getCustomerReference();
      final java.lang.Object other$customerReference = other.getCustomerReference();
      if (this$customerReference == null ? other$customerReference != null : !this$customerReference.equals(other$customerReference)) return false;
      final java.lang.Object this$lineItems = this.getLineItems();
      final java.lang.Object other$lineItems = other.getLineItems();
      if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
      final java.lang.Object this$merchantReference = this.getMerchantReference();
      final java.lang.Object other$merchantReference = other.getMerchantReference();
      if (this$merchantReference == null ? other$merchantReference != null : !this$merchantReference.equals(other$merchantReference)) return false;
      final java.lang.Object this$shippingAddressZip = this.getShippingAddressZip();
      final java.lang.Object other$shippingAddressZip = other.getShippingAddressZip();
      if (this$shippingAddressZip == null ? other$shippingAddressZip != null : !this$shippingAddressZip.equals(other$shippingAddressZip)) return false;
      final java.lang.Object this$shippingFromZip = this.getShippingFromZip();
      final java.lang.Object other$shippingFromZip = other.getShippingFromZip();
      if (this$shippingFromZip == null ? other$shippingFromZip != null : !this$shippingFromZip.equals(other$shippingFromZip)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.Level3;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $shippingAmount = this.getShippingAmount();
      result = result * PRIME + ($shippingAmount == null ? 43 : $shippingAmount.hashCode());
      final java.lang.Object $customerReference = this.getCustomerReference();
      result = result * PRIME + ($customerReference == null ? 43 : $customerReference.hashCode());
      final java.lang.Object $lineItems = this.getLineItems();
      result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
      final java.lang.Object $merchantReference = this.getMerchantReference();
      result = result * PRIME + ($merchantReference == null ? 43 : $merchantReference.hashCode());
      final java.lang.Object $shippingAddressZip = this.getShippingAddressZip();
      result = result * PRIME + ($shippingAddressZip == null ? 43 : $shippingAddressZip.hashCode());
      final java.lang.Object $shippingFromZip = this.getShippingFromZip();
      result = result * PRIME + ($shippingFromZip == null ? 43 : $shippingFromZip.hashCode());
      return result;
    }
  }


  public static class Outcome extends StripeObject {
    /**
     * Possible values are {@code approved_by_network}, {@code declined_by_network}, {@code
     * not_sent_to_network}, and {@code reversed_after_approval}. The value {@code
     * reversed_after_approval} indicates the payment was <a
     * href="https://stripe.com/docs/declines#blocked-payments">blocked by Stripe</a> after bank
     * authorization, and may temporarily appear as &quot;pending&quot; on a cardholder's statement.
     */
    @SerializedName("network_status")
    String networkStatus;
    /**
     * An enumerated value providing a more detailed explanation of the outcome's {@code type}.
     * Charges blocked by Radar's default block rule have the value {@code highest_risk_level}.
     * Charges placed in review by Radar's default review rule have the value {@code
     * elevated_risk_level}. Charges authorized, blocked, or placed in review by custom rules have
     * the value {@code rule}. See <a href="https://stripe.com/docs/declines">understanding
     * declines</a> for more details.
     */
    @SerializedName("reason")
    String reason;
    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are {@code normal}, {@code elevated}, {@code highest}. For non-card payments, and
     * card-based payments predating the public assignment of risk levels, this field will have the
     * value {@code not_assessed}. In the event of an error in the evaluation, this field will have
     * the value {@code unknown}. This field is only available with Radar.
     */
    @SerializedName("risk_level")
    String riskLevel;
    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are between 0 and 100. For non-card payments, card-based payments predating the
     * public assignment of risk scores, or in the event of an error during evaluation, this field
     * will not be present. This field is only available with Radar for Fraud Teams.
     */
    @SerializedName("risk_score")
    Long riskScore;
    /**
     * The ID of the Radar rule that matched the payment, if applicable.
     */
    @SerializedName("rule")
    ExpandableField<Rule> rule;
    /**
     * A human-readable description of the outcome type and reason, designed for you (the recipient
     * of the payment), not your customer.
     */
    @SerializedName("seller_message")
    String sellerMessage;
    /**
     * Possible values are {@code authorized}, {@code manual_review}, {@code issuer_declined},
     * {@code blocked}, and {@code invalid}. See <a
     * href="https://stripe.com/docs/declines">understanding declines</a> and <a
     * href="https://stripe.com/docs/radar/reviews">Radar reviews</a> for details.
     */
    @SerializedName("type")
    String type;

    /**
     * Get ID of expandable {@code rule} object.
     */
    public String getRule() {
      return (this.rule != null) ? this.rule.getId() : null;
    }

    public void setRule(String id) {
      this.rule = ApiResource.setExpandableFieldId(id, this.rule);
    }

    /**
     * Get expanded {@code rule}.
     */
    public Rule getRuleObject() {
      return (this.rule != null) ? this.rule.getExpanded() : null;
    }

    public void setRuleObject(Rule expandableObject) {
      this.rule = new ExpandableField<Rule>(expandableObject.getId(), expandableObject);
    }

    /**
     * Possible values are {@code approved_by_network}, {@code declined_by_network}, {@code
     * not_sent_to_network}, and {@code reversed_after_approval}. The value {@code
     * reversed_after_approval} indicates the payment was <a
     * href="https://stripe.com/docs/declines#blocked-payments">blocked by Stripe</a> after bank
     * authorization, and may temporarily appear as &quot;pending&quot; on a cardholder's statement.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNetworkStatus() {
      return this.networkStatus;
    }

    /**
     * An enumerated value providing a more detailed explanation of the outcome's {@code type}.
     * Charges blocked by Radar's default block rule have the value {@code highest_risk_level}.
     * Charges placed in review by Radar's default review rule have the value {@code
     * elevated_risk_level}. Charges authorized, blocked, or placed in review by custom rules have
     * the value {@code rule}. See <a href="https://stripe.com/docs/declines">understanding
     * declines</a> for more details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReason() {
      return this.reason;
    }

    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are {@code normal}, {@code elevated}, {@code highest}. For non-card payments, and
     * card-based payments predating the public assignment of risk levels, this field will have the
     * value {@code not_assessed}. In the event of an error in the evaluation, this field will have
     * the value {@code unknown}. This field is only available with Radar.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRiskLevel() {
      return this.riskLevel;
    }

    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are between 0 and 100. For non-card payments, card-based payments predating the
     * public assignment of risk scores, or in the event of an error during evaluation, this field
     * will not be present. This field is only available with Radar for Fraud Teams.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getRiskScore() {
      return this.riskScore;
    }

    /**
     * A human-readable description of the outcome type and reason, designed for you (the recipient
     * of the payment), not your customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSellerMessage() {
      return this.sellerMessage;
    }

    /**
     * Possible values are {@code authorized}, {@code manual_review}, {@code issuer_declined},
     * {@code blocked}, and {@code invalid}. See <a
     * href="https://stripe.com/docs/declines">understanding declines</a> and <a
     * href="https://stripe.com/docs/radar/reviews">Radar reviews</a> for details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Possible values are {@code approved_by_network}, {@code declined_by_network}, {@code
     * not_sent_to_network}, and {@code reversed_after_approval}. The value {@code
     * reversed_after_approval} indicates the payment was <a
     * href="https://stripe.com/docs/declines#blocked-payments">blocked by Stripe</a> after bank
     * authorization, and may temporarily appear as &quot;pending&quot; on a cardholder's statement.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNetworkStatus(final String networkStatus) {
      this.networkStatus = networkStatus;
    }

    /**
     * An enumerated value providing a more detailed explanation of the outcome's {@code type}.
     * Charges blocked by Radar's default block rule have the value {@code highest_risk_level}.
     * Charges placed in review by Radar's default review rule have the value {@code
     * elevated_risk_level}. Charges authorized, blocked, or placed in review by custom rules have
     * the value {@code rule}. See <a href="https://stripe.com/docs/declines">understanding
     * declines</a> for more details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final String reason) {
      this.reason = reason;
    }

    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are {@code normal}, {@code elevated}, {@code highest}. For non-card payments, and
     * card-based payments predating the public assignment of risk levels, this field will have the
     * value {@code not_assessed}. In the event of an error in the evaluation, this field will have
     * the value {@code unknown}. This field is only available with Radar.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRiskLevel(final String riskLevel) {
      this.riskLevel = riskLevel;
    }

    /**
     * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated
     * payments are between 0 and 100. For non-card payments, card-based payments predating the
     * public assignment of risk scores, or in the event of an error during evaluation, this field
     * will not be present. This field is only available with Radar for Fraud Teams.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRiskScore(final Long riskScore) {
      this.riskScore = riskScore;
    }

    /**
     * A human-readable description of the outcome type and reason, designed for you (the recipient
     * of the payment), not your customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSellerMessage(final String sellerMessage) {
      this.sellerMessage = sellerMessage;
    }

    /**
     * Possible values are {@code authorized}, {@code manual_review}, {@code issuer_declined},
     * {@code blocked}, and {@code invalid}. See <a
     * href="https://stripe.com/docs/declines">understanding declines</a> and <a
     * href="https://stripe.com/docs/radar/reviews">Radar reviews</a> for details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.Outcome)) return false;
      final Charge.Outcome other = (Charge.Outcome) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$riskScore = this.getRiskScore();
      final java.lang.Object other$riskScore = other.getRiskScore();
      if (this$riskScore == null ? other$riskScore != null : !this$riskScore.equals(other$riskScore)) return false;
      final java.lang.Object this$networkStatus = this.getNetworkStatus();
      final java.lang.Object other$networkStatus = other.getNetworkStatus();
      if (this$networkStatus == null ? other$networkStatus != null : !this$networkStatus.equals(other$networkStatus)) return false;
      final java.lang.Object this$reason = this.getReason();
      final java.lang.Object other$reason = other.getReason();
      if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
      final java.lang.Object this$riskLevel = this.getRiskLevel();
      final java.lang.Object other$riskLevel = other.getRiskLevel();
      if (this$riskLevel == null ? other$riskLevel != null : !this$riskLevel.equals(other$riskLevel)) return false;
      final java.lang.Object this$rule = this.getRule();
      final java.lang.Object other$rule = other.getRule();
      if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) return false;
      final java.lang.Object this$sellerMessage = this.getSellerMessage();
      final java.lang.Object other$sellerMessage = other.getSellerMessage();
      if (this$sellerMessage == null ? other$sellerMessage != null : !this$sellerMessage.equals(other$sellerMessage)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.Outcome;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $riskScore = this.getRiskScore();
      result = result * PRIME + ($riskScore == null ? 43 : $riskScore.hashCode());
      final java.lang.Object $networkStatus = this.getNetworkStatus();
      result = result * PRIME + ($networkStatus == null ? 43 : $networkStatus.hashCode());
      final java.lang.Object $reason = this.getReason();
      result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
      final java.lang.Object $riskLevel = this.getRiskLevel();
      result = result * PRIME + ($riskLevel == null ? 43 : $riskLevel.hashCode());
      final java.lang.Object $rule = this.getRule();
      result = result * PRIME + ($rule == null ? 43 : $rule.hashCode());
      final java.lang.Object $sellerMessage = this.getSellerMessage();
      result = result * PRIME + ($sellerMessage == null ? 43 : $sellerMessage.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class PaymentMethodDetails extends StripeObject {
    @SerializedName("ach_credit_transfer")
    AchCreditTransfer achCreditTransfer;
    @SerializedName("ach_debit")
    AchDebit achDebit;
    @SerializedName("acss_debit")
    AcssDebit acssDebit;
    @SerializedName("alipay")
    Alipay alipay;
    @SerializedName("au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName("bacs_debit")
    BacsDebit bacsDebit;
    @SerializedName("bancontact")
    Bancontact bancontact;
    @SerializedName("card")
    Card card;
    @SerializedName("card_present")
    CardPresent cardPresent;
    @SerializedName("eps")
    Eps eps;
    @SerializedName("fpx")
    Fpx fpx;
    @SerializedName("giropay")
    Giropay giropay;
    @SerializedName("ideal")
    Ideal ideal;
    @SerializedName("interac_present")
    InteracPresent interacPresent;
    @SerializedName("klarna")
    Klarna klarna;
    @SerializedName("multibanco")
    Multibanco multibanco;
    @SerializedName("oxxo")
    Oxxo oxxo;
    @SerializedName("p24")
    P24 p24;
    @SerializedName("sepa_credit_transfer")
    SepaCreditTransfer sepaCreditTransfer;
    @SerializedName("sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName("sofort")
    Sofort sofort;
    @SerializedName("stripe_account")
    StripeAccount stripeAccount;
    /**
     * The type of transaction-specific details of the payment method used in the payment, one of
     * {@code ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code au_becs_debit}, {@code
     * bancontact}, {@code card}, {@code card_present}, {@code eps}, {@code giropay}, {@code ideal},
     * {@code klarna}, {@code multibanco}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code
     * stripe_account}, or {@code wechat}. An additional hash is included on {@code
     * payment_method_details} with a name matching this value. It contains information specific to
     * the payment method.
     */
    @SerializedName("type")
    String type;
    @SerializedName("wechat")
    Wechat wechat;


    public static class AchCreditTransfer extends StripeObject {
      /**
       * Account number to transfer funds to.
       */
      @SerializedName("account_number")
      String accountNumber;
      /**
       * Name of the bank associated with the routing number.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Routing transit number for the bank account to transfer funds to.
       */
      @SerializedName("routing_number")
      String routingNumber;
      /**
       * SWIFT code of the bank associated with the routing number.
       */
      @SerializedName("swift_code")
      String swiftCode;

      /**
       * Account number to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountNumber() {
        return this.accountNumber;
      }

      /**
       * Name of the bank associated with the routing number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Routing transit number for the bank account to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      /**
       * SWIFT code of the bank associated with the routing number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSwiftCode() {
        return this.swiftCode;
      }

      /**
       * Account number to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
      }

      /**
       * Name of the bank associated with the routing number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Routing transit number for the bank account to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      /**
       * SWIFT code of the bank associated with the routing number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSwiftCode(final String swiftCode) {
        this.swiftCode = swiftCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.AchCreditTransfer)) return false;
        final Charge.PaymentMethodDetails.AchCreditTransfer other = (Charge.PaymentMethodDetails.AchCreditTransfer) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountNumber = this.getAccountNumber();
        final java.lang.Object other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        final java.lang.Object this$swiftCode = this.getSwiftCode();
        final java.lang.Object other$swiftCode = other.getSwiftCode();
        if (this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.AchCreditTransfer;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountNumber = this.getAccountNumber();
        result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        final java.lang.Object $swiftCode = this.getSwiftCode();
        result = result * PRIME + ($swiftCode == null ? 43 : $swiftCode.hashCode());
        return result;
      }
    }


    public static class AchDebit extends StripeObject {
      /**
       * Type of entity that holds the account. This can be either {@code individual} or {@code
       * company}.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @SerializedName("account_holder_type")
      String accountHolderType;
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @SerializedName("country")
      String country;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Last four digits of the bank account number.
       */
      @SerializedName("last4")
      String last4;
      /**
       * Routing transit number of the bank account.
       */
      @SerializedName("routing_number")
      String routingNumber;

      /**
       * Type of entity that holds the account. This can be either {@code individual} or {@code
       * company}.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderType() {
        return this.accountHolderType;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * Routing transit number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      /**
       * Type of entity that holds the account. This can be either {@code individual} or {@code
       * company}.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderType(final String accountHolderType) {
        this.accountHolderType = accountHolderType;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * Routing transit number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.AchDebit)) return false;
        final Charge.PaymentMethodDetails.AchDebit other = (Charge.PaymentMethodDetails.AchDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderType = this.getAccountHolderType();
        final java.lang.Object other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.AchDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderType = this.getAccountHolderType();
        result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }


    public static class AcssDebit extends StripeObject {
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Institution number of the bank account.
       */
      @SerializedName("institution_number")
      String institutionNumber;
      /**
       * Last four digits of the bank account number.
       */
      @SerializedName("last4")
      String last4;
      /**
       * ID of the mandate used to make this payment.
       */
      @SerializedName("mandate")
      String mandate;
      /**
       * Transit number of the bank account.
       */
      @SerializedName("transit_number")
      String transitNumber;

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Institution number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getInstitutionNumber() {
        return this.institutionNumber;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMandate() {
        return this.mandate;
      }

      /**
       * Transit number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getTransitNumber() {
        return this.transitNumber;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Institution number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInstitutionNumber(final String institutionNumber) {
        this.institutionNumber = institutionNumber;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandate(final String mandate) {
        this.mandate = mandate;
      }

      /**
       * Transit number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTransitNumber(final String transitNumber) {
        this.transitNumber = transitNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.AcssDebit)) return false;
        final Charge.PaymentMethodDetails.AcssDebit other = (Charge.PaymentMethodDetails.AcssDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$institutionNumber = this.getInstitutionNumber();
        final java.lang.Object other$institutionNumber = other.getInstitutionNumber();
        if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$mandate = this.getMandate();
        final java.lang.Object other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) return false;
        final java.lang.Object this$transitNumber = this.getTransitNumber();
        final java.lang.Object other$transitNumber = other.getTransitNumber();
        if (this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.AcssDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $institutionNumber = this.getInstitutionNumber();
        result = result * PRIME + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $mandate = this.getMandate();
        result = result * PRIME + ($mandate == null ? 43 : $mandate.hashCode());
        final java.lang.Object $transitNumber = this.getTransitNumber();
        result = result * PRIME + ($transitNumber == null ? 43 : $transitNumber.hashCode());
        return result;
      }
    }


    public static class Alipay extends StripeObject {
      /**
       * Uniquely identifies this particular Alipay account. You can use this attribute to check
       * whether two Alipay accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Transaction ID of this particular Alipay transaction.
       */
      @SerializedName("transaction_id")
      String transactionId;

      /**
       * Uniquely identifies this particular Alipay account. You can use this attribute to check
       * whether two Alipay accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Transaction ID of this particular Alipay transaction.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getTransactionId() {
        return this.transactionId;
      }

      /**
       * Uniquely identifies this particular Alipay account. You can use this attribute to check
       * whether two Alipay accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Transaction ID of this particular Alipay transaction.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTransactionId(final String transactionId) {
        this.transactionId = transactionId;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Alipay)) return false;
        final Charge.PaymentMethodDetails.Alipay other = (Charge.PaymentMethodDetails.Alipay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$transactionId = this.getTransactionId();
        final java.lang.Object other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Alipay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $transactionId = this.getTransactionId();
        result = result * PRIME + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
      }
    }


    public static class AuBecsDebit extends StripeObject {
      /**
       * Bank-State-Branch number of the bank account.
       */
      @SerializedName("bsb_number")
      String bsbNumber;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Last four digits of the bank account number.
       */
      @SerializedName("last4")
      String last4;
      /**
       * ID of the mandate used to make this payment.
       */
      @SerializedName("mandate")
      String mandate;

      /**
       * Bank-State-Branch number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBsbNumber() {
        return this.bsbNumber;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMandate() {
        return this.mandate;
      }

      /**
       * Bank-State-Branch number of the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBsbNumber(final String bsbNumber) {
        this.bsbNumber = bsbNumber;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandate(final String mandate) {
        this.mandate = mandate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.AuBecsDebit)) return false;
        final Charge.PaymentMethodDetails.AuBecsDebit other = (Charge.PaymentMethodDetails.AuBecsDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bsbNumber = this.getBsbNumber();
        final java.lang.Object other$bsbNumber = other.getBsbNumber();
        if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$mandate = this.getMandate();
        final java.lang.Object other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.AuBecsDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bsbNumber = this.getBsbNumber();
        result = result * PRIME + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $mandate = this.getMandate();
        result = result * PRIME + ($mandate == null ? 43 : $mandate.hashCode());
        return result;
      }
    }


    public static class BacsDebit extends StripeObject {
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Last four digits of the bank account number.
       */
      @SerializedName("last4")
      String last4;
      /**
       * ID of the mandate used to make this payment.
       */
      @SerializedName("mandate")
      String mandate;
      /**
       * Sort code of the bank account. (e.g., {@code 10-20-30})
       */
      @SerializedName("sort_code")
      String sortCode;

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMandate() {
        return this.mandate;
      }

      /**
       * Sort code of the bank account. (e.g., {@code 10-20-30})
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSortCode() {
        return this.sortCode;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Last four digits of the bank account number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandate(final String mandate) {
        this.mandate = mandate;
      }

      /**
       * Sort code of the bank account. (e.g., {@code 10-20-30})
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSortCode(final String sortCode) {
        this.sortCode = sortCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.BacsDebit)) return false;
        final Charge.PaymentMethodDetails.BacsDebit other = (Charge.PaymentMethodDetails.BacsDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$mandate = this.getMandate();
        final java.lang.Object other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) return false;
        final java.lang.Object this$sortCode = this.getSortCode();
        final java.lang.Object other$sortCode = other.getSortCode();
        if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.BacsDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $mandate = this.getMandate();
        result = result * PRIME + ($mandate == null ? 43 : $mandate.hashCode());
        final java.lang.Object $sortCode = this.getSortCode();
        result = result * PRIME + ($sortCode == null ? 43 : $sortCode.hashCode());
        return result;
      }
    }


    public static class Bancontact extends StripeObject {
      /**
       * Bank code of bank associated with the bank account.
       */
      @SerializedName("bank_code")
      String bankCode;
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @SerializedName("bic")
      String bic;
      /**
       * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit")
      ExpandableField<PaymentMethod> generatedSepaDebit;
      /**
       * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit_mandate")
      ExpandableField<Mandate> generatedSepaDebitMandate;
      /**
       * Last four characters of the IBAN.
       */
      @SerializedName("iban_last4")
      String ibanLast4;
      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       * Can be one of {@code en}, {@code de}, {@code fr}, or {@code nl}
       */
      @SerializedName("preferred_language")
      String preferredLanguage;
      /**
       * Owner's verified full name. Values are verified or provided by Bancontact directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Get ID of expandable {@code generatedSepaDebit} object.
       */
      public String getGeneratedSepaDebit() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getId() : null;
      }

      public void setGeneratedSepaDebit(String id) {
        this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
      }

      /**
       * Get expanded {@code generatedSepaDebit}.
       */
      public PaymentMethod getGeneratedSepaDebitObject() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getExpanded() : null;
      }

      public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
        this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
      }

      /**
       * Get ID of expandable {@code generatedSepaDebitMandate} object.
       */
      public String getGeneratedSepaDebitMandate() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getId() : null;
      }

      public void setGeneratedSepaDebitMandate(String id) {
        this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
      }

      /**
       * Get expanded {@code generatedSepaDebitMandate}.
       */
      public Mandate getGeneratedSepaDebitMandateObject() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getExpanded() : null;
      }

      public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
        this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankCode() {
        return this.bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBic() {
        return this.bic;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIbanLast4() {
        return this.ibanLast4;
      }

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       * Can be one of {@code en}, {@code de}, {@code fr}, or {@code nl}
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLanguage() {
        return this.preferredLanguage;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Bancontact directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankCode(final String bankCode) {
        this.bankCode = bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBic(final String bic) {
        this.bic = bic;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIbanLast4(final String ibanLast4) {
        this.ibanLast4 = ibanLast4;
      }

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       * Can be one of {@code en}, {@code de}, {@code fr}, or {@code nl}
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLanguage(final String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Bancontact directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Bancontact)) return false;
        final Charge.PaymentMethodDetails.Bancontact other = (Charge.PaymentMethodDetails.Bancontact) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankCode = this.getBankCode();
        final java.lang.Object other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$bic = this.getBic();
        final java.lang.Object other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
        final java.lang.Object this$generatedSepaDebit = this.getGeneratedSepaDebit();
        final java.lang.Object other$generatedSepaDebit = other.getGeneratedSepaDebit();
        if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) return false;
        final java.lang.Object this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        final java.lang.Object other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
        if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) return false;
        final java.lang.Object this$ibanLast4 = this.getIbanLast4();
        final java.lang.Object other$ibanLast4 = other.getIbanLast4();
        if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
        final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
        final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Bancontact;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankCode = this.getBankCode();
        result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $bic = this.getBic();
        result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
        final java.lang.Object $generatedSepaDebit = this.getGeneratedSepaDebit();
        result = result * PRIME + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
        final java.lang.Object $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        result = result * PRIME + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
        final java.lang.Object $ibanLast4 = this.getIbanLast4();
        result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
        final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
        result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class Card extends StripeObject {
      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @SerializedName("brand")
      String brand;
      /**
       * Check results by Card networks on Card address and CVC at time of payment.
       */
      @SerializedName("checks")
      Checks checks;
      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @SerializedName("country")
      String country;
      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @SerializedName("description")
      String description;
      /**
       * Two-digit number representing the card's expiration month.
       */
      @SerializedName("exp_month")
      Long expMonth;
      /**
       * Four-digit number representing the card's expiration year.
       */
      @SerializedName("exp_year")
      Long expYear;
      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @SerializedName("funding")
      String funding;
      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @SerializedName("iin")
      String iin;
      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @SerializedName("installments")
      Installments installments;
      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @SerializedName("issuer")
      String issuer;
      /**
       * The last four digits of the card.
       */
      @SerializedName("last4")
      String last4;
      /**
       * True if this payment was marked as MOTO and out of scope for SCA.
       */
      @SerializedName("moto")
      Boolean moto;
      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @SerializedName("network")
      String network;
      /**
       * Populated if this transaction used 3D Secure authentication.
       */
      @SerializedName("three_d_secure")
      ThreeDSecure threeDSecure;
      /**
       * If this Card is part of a card wallet, this contains the details of the card wallet.
       */
      @SerializedName("wallet")
      Wallet wallet;


      public static class Checks extends StripeObject {
        /**
         * If a address line1 was provided, results of the check, one of {@code pass}, {@code fail},
         * {@code unavailable}, or {@code unchecked}.
         */
        @SerializedName("address_line1_check")
        String addressLine1Check;
        /**
         * If a address postal code was provided, results of the check, one of {@code pass}, {@code
         * fail}, {@code unavailable}, or {@code unchecked}.
         */
        @SerializedName("address_postal_code_check")
        String addressPostalCodeCheck;
        /**
         * If a CVC was provided, results of the check, one of {@code pass}, {@code fail}, {@code
         * unavailable}, or {@code unchecked}.
         */
        @SerializedName("cvc_check")
        String cvcCheck;

        /**
         * If a address line1 was provided, results of the check, one of {@code pass}, {@code fail},
         * {@code unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAddressLine1Check() {
          return this.addressLine1Check;
        }

        /**
         * If a address postal code was provided, results of the check, one of {@code pass}, {@code
         * fail}, {@code unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAddressPostalCodeCheck() {
          return this.addressPostalCodeCheck;
        }

        /**
         * If a CVC was provided, results of the check, one of {@code pass}, {@code fail}, {@code
         * unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCvcCheck() {
          return this.cvcCheck;
        }

        /**
         * If a address line1 was provided, results of the check, one of {@code pass}, {@code fail},
         * {@code unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAddressLine1Check(final String addressLine1Check) {
          this.addressLine1Check = addressLine1Check;
        }

        /**
         * If a address postal code was provided, results of the check, one of {@code pass}, {@code
         * fail}, {@code unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAddressPostalCodeCheck(final String addressPostalCodeCheck) {
          this.addressPostalCodeCheck = addressPostalCodeCheck;
        }

        /**
         * If a CVC was provided, results of the check, one of {@code pass}, {@code fail}, {@code
         * unavailable}, or {@code unchecked}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCvcCheck(final String cvcCheck) {
          this.cvcCheck = cvcCheck;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.Card.Checks)) return false;
          final Charge.PaymentMethodDetails.Card.Checks other = (Charge.PaymentMethodDetails.Card.Checks) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
          final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
          if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
          final java.lang.Object this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
          final java.lang.Object other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
          if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) return false;
          final java.lang.Object this$cvcCheck = this.getCvcCheck();
          final java.lang.Object other$cvcCheck = other.getCvcCheck();
          if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.Card.Checks;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
          result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
          final java.lang.Object $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
          result = result * PRIME + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
          final java.lang.Object $cvcCheck = this.getCvcCheck();
          result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
          return result;
        }
      }


      public static class Installments extends StripeObject {
        /**
         * Installment plan selected for the payment.
         */
        @SerializedName("plan")
        PaymentIntent.PaymentMethodOptions.Card.Installments.Plan plan;

        /**
         * Installment plan selected for the payment.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PaymentIntent.PaymentMethodOptions.Card.Installments.Plan getPlan() {
          return this.plan;
        }

        /**
         * Installment plan selected for the payment.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPlan(final PaymentIntent.PaymentMethodOptions.Card.Installments.Plan plan) {
          this.plan = plan;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.Card.Installments)) return false;
          final Charge.PaymentMethodDetails.Card.Installments other = (Charge.PaymentMethodDetails.Card.Installments) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$plan = this.getPlan();
          final java.lang.Object other$plan = other.getPlan();
          if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.Card.Installments;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $plan = this.getPlan();
          result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
          return result;
        }
      }


      public static class ThreeDSecure extends StripeObject {
        /**
         * For authenticated transactions: how the customer was authenticated by the issuing bank.
         *
         * <p>One of {@code challenge}, or {@code frictionless}.
         */
        @SerializedName("authentication_flow")
        String authenticationFlow;
        /**
         * Indicates the outcome of 3D Secure authentication.
         *
         * <p>One of {@code attempt_acknowledged}, {@code authenticated}, {@code failed}, {@code
         * not_supported}, or {@code processing_error}.
         */
        @SerializedName("result")
        String result;
        /**
         * Additional information about why 3D Secure succeeded or failed based on the {@code
         * result}.
         *
         * <p>One of {@code abandoned}, {@code bypassed}, {@code canceled}, {@code
         * card_not_enrolled}, {@code network_not_supported}, {@code protocol_error}, or {@code
         * rejected}.
         */
        @SerializedName("result_reason")
        String resultReason;
        /**
         * The version of 3D Secure that was used.
         *
         * <p>One of {@code 1.0.2}, {@code 2.1.0}, or {@code 2.2.0}.
         */
        @SerializedName("version")
        String version;

        /**
         * For authenticated transactions: how the customer was authenticated by the issuing bank.
         *
         * <p>One of {@code challenge}, or {@code frictionless}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAuthenticationFlow() {
          return this.authenticationFlow;
        }

        /**
         * Indicates the outcome of 3D Secure authentication.
         *
         * <p>One of {@code attempt_acknowledged}, {@code authenticated}, {@code failed}, {@code
         * not_supported}, or {@code processing_error}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResult() {
          return this.result;
        }

        /**
         * Additional information about why 3D Secure succeeded or failed based on the {@code
         * result}.
         *
         * <p>One of {@code abandoned}, {@code bypassed}, {@code canceled}, {@code
         * card_not_enrolled}, {@code network_not_supported}, {@code protocol_error}, or {@code
         * rejected}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResultReason() {
          return this.resultReason;
        }

        /**
         * The version of 3D Secure that was used.
         *
         * <p>One of {@code 1.0.2}, {@code 2.1.0}, or {@code 2.2.0}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getVersion() {
          return this.version;
        }

        /**
         * For authenticated transactions: how the customer was authenticated by the issuing bank.
         *
         * <p>One of {@code challenge}, or {@code frictionless}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAuthenticationFlow(final String authenticationFlow) {
          this.authenticationFlow = authenticationFlow;
        }

        /**
         * Indicates the outcome of 3D Secure authentication.
         *
         * <p>One of {@code attempt_acknowledged}, {@code authenticated}, {@code failed}, {@code
         * not_supported}, or {@code processing_error}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResult(final String result) {
          this.result = result;
        }

        /**
         * Additional information about why 3D Secure succeeded or failed based on the {@code
         * result}.
         *
         * <p>One of {@code abandoned}, {@code bypassed}, {@code canceled}, {@code
         * card_not_enrolled}, {@code network_not_supported}, {@code protocol_error}, or {@code
         * rejected}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResultReason(final String resultReason) {
          this.resultReason = resultReason;
        }

        /**
         * The version of 3D Secure that was used.
         *
         * <p>One of {@code 1.0.2}, {@code 2.1.0}, or {@code 2.2.0}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setVersion(final String version) {
          this.version = version;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.Card.ThreeDSecure)) return false;
          final Charge.PaymentMethodDetails.Card.ThreeDSecure other = (Charge.PaymentMethodDetails.Card.ThreeDSecure) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$authenticationFlow = this.getAuthenticationFlow();
          final java.lang.Object other$authenticationFlow = other.getAuthenticationFlow();
          if (this$authenticationFlow == null ? other$authenticationFlow != null : !this$authenticationFlow.equals(other$authenticationFlow)) return false;
          final java.lang.Object this$result = this.getResult();
          final java.lang.Object other$result = other.getResult();
          if (this$result == null ? other$result != null : !this$result.equals(other$result)) return false;
          final java.lang.Object this$resultReason = this.getResultReason();
          final java.lang.Object other$resultReason = other.getResultReason();
          if (this$resultReason == null ? other$resultReason != null : !this$resultReason.equals(other$resultReason)) return false;
          final java.lang.Object this$version = this.getVersion();
          final java.lang.Object other$version = other.getVersion();
          if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.Card.ThreeDSecure;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $authenticationFlow = this.getAuthenticationFlow();
          result = result * PRIME + ($authenticationFlow == null ? 43 : $authenticationFlow.hashCode());
          final java.lang.Object $result = this.getResult();
          result = result * PRIME + ($result == null ? 43 : $result.hashCode());
          final java.lang.Object $resultReason = this.getResultReason();
          result = result * PRIME + ($resultReason == null ? 43 : $resultReason.hashCode());
          final java.lang.Object $version = this.getVersion();
          result = result * PRIME + ($version == null ? 43 : $version.hashCode());
          return result;
        }
      }


      public static class Wallet extends StripeObject {
        @SerializedName("amex_express_checkout")
        AmexExpressCheckout amexExpressCheckout;
        @SerializedName("apple_pay")
        ApplePay applePay;
        /** (For tokenized numbers only.) The last four digits of the device account number. */
        @SerializedName("dynamic_last4")
        String dynamicLast4;
        @SerializedName("google_pay")
        GooglePay googlePay;
        @SerializedName("masterpass")
        Masterpass masterpass;
        @SerializedName("samsung_pay")
        SamsungPay samsungPay;
        /**
         * The type of the card wallet, one of {@code amex_express_checkout}, {@code apple_pay},
         * {@code google_pay}, {@code masterpass}, {@code samsung_pay}, or {@code visa_checkout}. An
         * additional hash is included on the Wallet subhash with a name matching this value. It
         * contains additional information specific to the card wallet type.
         */
        @SerializedName("type")
        String type;
        @SerializedName("visa_checkout")
        VisaCheckout visaCheckout;


        public static class AmexExpressCheckout extends StripeObject {
          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.AmexExpressCheckout)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.AmexExpressCheckout other = (Charge.PaymentMethodDetails.Card.Wallet.AmexExpressCheckout) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.AmexExpressCheckout;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int result = 1;
            return result;
          }
        }


        public static class ApplePay extends StripeObject {
          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.ApplePay)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.ApplePay other = (Charge.PaymentMethodDetails.Card.Wallet.ApplePay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.ApplePay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int result = 1;
            return result;
          }
        }


        public static class GooglePay extends StripeObject {
          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.GooglePay)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.GooglePay other = (Charge.PaymentMethodDetails.Card.Wallet.GooglePay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.GooglePay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int result = 1;
            return result;
          }
        }


        public static class Masterpass extends StripeObject {
          /**
           * Owner's verified billing address. Values are verified or provided by the wallet
           * directly (if supported) at the time of authorization or settlement. They cannot be set
           * or mutated.
           */
          @SerializedName("billing_address")
          Address billingAddress;
          /**
           * Owner's verified email. Values are verified or provided by the wallet directly (if
           * supported) at the time of authorization or settlement. They cannot be set or mutated.
           */
          @SerializedName("email")
          String email;
          /**
           * Owner's verified full name. Values are verified or provided by the wallet directly (if
           * supported) at the time of authorization or settlement. They cannot be set or mutated.
           */
          @SerializedName("name")
          String name;
          /**
           * Owner's verified shipping address. Values are verified or provided by the wallet
           * directly (if supported) at the time of authorization or settlement. They cannot be set
           * or mutated.
           */
          @SerializedName("shipping_address")
          Address shippingAddress;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Address getBillingAddress() {
            return this.billingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getEmail() {
            return this.email;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getName() {
            return this.name;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Address getShippingAddress() {
            return this.shippingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setBillingAddress(final Address billingAddress) {
            this.billingAddress = billingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setEmail(final String email) {
            this.email = email;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setName(final String name) {
            this.name = name;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setShippingAddress(final Address shippingAddress) {
            this.shippingAddress = shippingAddress;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.Masterpass)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.Masterpass other = (Charge.PaymentMethodDetails.Card.Wallet.Masterpass) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$billingAddress = this.getBillingAddress();
            final java.lang.Object other$billingAddress = other.getBillingAddress();
            if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
            final java.lang.Object this$email = this.getEmail();
            final java.lang.Object other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$shippingAddress = this.getShippingAddress();
            final java.lang.Object other$shippingAddress = other.getShippingAddress();
            if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.Masterpass;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $billingAddress = this.getBillingAddress();
            result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
            final java.lang.Object $email = this.getEmail();
            result = result * PRIME + ($email == null ? 43 : $email.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $shippingAddress = this.getShippingAddress();
            result = result * PRIME + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
            return result;
          }
        }


        public static class SamsungPay extends StripeObject {
          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.SamsungPay)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.SamsungPay other = (Charge.PaymentMethodDetails.Card.Wallet.SamsungPay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.SamsungPay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int result = 1;
            return result;
          }
        }


        public static class VisaCheckout extends StripeObject {
          /**
           * Owner's verified billing address. Values are verified or provided by the wallet
           * directly (if supported) at the time of authorization or settlement. They cannot be set
           * or mutated.
           */
          @SerializedName("billing_address")
          Address billingAddress;
          /**
           * Owner's verified email. Values are verified or provided by the wallet directly (if
           * supported) at the time of authorization or settlement. They cannot be set or mutated.
           */
          @SerializedName("email")
          String email;
          /**
           * Owner's verified full name. Values are verified or provided by the wallet directly (if
           * supported) at the time of authorization or settlement. They cannot be set or mutated.
           */
          @SerializedName("name")
          String name;
          @SerializedName("shipping_address")
          Address shippingAddress;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Address getBillingAddress() {
            return this.billingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getEmail() {
            return this.email;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getName() {
            return this.name;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Address getShippingAddress() {
            return this.shippingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setBillingAddress(final Address billingAddress) {
            this.billingAddress = billingAddress;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setEmail(final String email) {
            this.email = email;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setName(final String name) {
            this.name = name;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setShippingAddress(final Address shippingAddress) {
            this.shippingAddress = shippingAddress;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet.VisaCheckout)) return false;
            final Charge.PaymentMethodDetails.Card.Wallet.VisaCheckout other = (Charge.PaymentMethodDetails.Card.Wallet.VisaCheckout) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$billingAddress = this.getBillingAddress();
            final java.lang.Object other$billingAddress = other.getBillingAddress();
            if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
            final java.lang.Object this$email = this.getEmail();
            final java.lang.Object other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$shippingAddress = this.getShippingAddress();
            final java.lang.Object other$shippingAddress = other.getShippingAddress();
            if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Charge.PaymentMethodDetails.Card.Wallet.VisaCheckout;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $billingAddress = this.getBillingAddress();
            result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
            final java.lang.Object $email = this.getEmail();
            result = result * PRIME + ($email == null ? 43 : $email.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $shippingAddress = this.getShippingAddress();
            result = result * PRIME + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
            return result;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AmexExpressCheckout getAmexExpressCheckout() {
          return this.amexExpressCheckout;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ApplePay getApplePay() {
          return this.applePay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDynamicLast4() {
          return this.dynamicLast4;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GooglePay getGooglePay() {
          return this.googlePay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Masterpass getMasterpass() {
          return this.masterpass;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SamsungPay getSamsungPay() {
          return this.samsungPay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getType() {
          return this.type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public VisaCheckout getVisaCheckout() {
          return this.visaCheckout;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmexExpressCheckout(final AmexExpressCheckout amexExpressCheckout) {
          this.amexExpressCheckout = amexExpressCheckout;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApplePay(final ApplePay applePay) {
          this.applePay = applePay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDynamicLast4(final String dynamicLast4) {
          this.dynamicLast4 = dynamicLast4;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setGooglePay(final GooglePay googlePay) {
          this.googlePay = googlePay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setMasterpass(final Masterpass masterpass) {
          this.masterpass = masterpass;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSamsungPay(final SamsungPay samsungPay) {
          this.samsungPay = samsungPay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setType(final String type) {
          this.type = type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setVisaCheckout(final VisaCheckout visaCheckout) {
          this.visaCheckout = visaCheckout;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.Card.Wallet)) return false;
          final Charge.PaymentMethodDetails.Card.Wallet other = (Charge.PaymentMethodDetails.Card.Wallet) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amexExpressCheckout = this.getAmexExpressCheckout();
          final java.lang.Object other$amexExpressCheckout = other.getAmexExpressCheckout();
          if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !this$amexExpressCheckout.equals(other$amexExpressCheckout)) return false;
          final java.lang.Object this$applePay = this.getApplePay();
          final java.lang.Object other$applePay = other.getApplePay();
          if (this$applePay == null ? other$applePay != null : !this$applePay.equals(other$applePay)) return false;
          final java.lang.Object this$dynamicLast4 = this.getDynamicLast4();
          final java.lang.Object other$dynamicLast4 = other.getDynamicLast4();
          if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) return false;
          final java.lang.Object this$googlePay = this.getGooglePay();
          final java.lang.Object other$googlePay = other.getGooglePay();
          if (this$googlePay == null ? other$googlePay != null : !this$googlePay.equals(other$googlePay)) return false;
          final java.lang.Object this$masterpass = this.getMasterpass();
          final java.lang.Object other$masterpass = other.getMasterpass();
          if (this$masterpass == null ? other$masterpass != null : !this$masterpass.equals(other$masterpass)) return false;
          final java.lang.Object this$samsungPay = this.getSamsungPay();
          final java.lang.Object other$samsungPay = other.getSamsungPay();
          if (this$samsungPay == null ? other$samsungPay != null : !this$samsungPay.equals(other$samsungPay)) return false;
          final java.lang.Object this$type = this.getType();
          final java.lang.Object other$type = other.getType();
          if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
          final java.lang.Object this$visaCheckout = this.getVisaCheckout();
          final java.lang.Object other$visaCheckout = other.getVisaCheckout();
          if (this$visaCheckout == null ? other$visaCheckout != null : !this$visaCheckout.equals(other$visaCheckout)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.Card.Wallet;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amexExpressCheckout = this.getAmexExpressCheckout();
          result = result * PRIME + ($amexExpressCheckout == null ? 43 : $amexExpressCheckout.hashCode());
          final java.lang.Object $applePay = this.getApplePay();
          result = result * PRIME + ($applePay == null ? 43 : $applePay.hashCode());
          final java.lang.Object $dynamicLast4 = this.getDynamicLast4();
          result = result * PRIME + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
          final java.lang.Object $googlePay = this.getGooglePay();
          result = result * PRIME + ($googlePay == null ? 43 : $googlePay.hashCode());
          final java.lang.Object $masterpass = this.getMasterpass();
          result = result * PRIME + ($masterpass == null ? 43 : $masterpass.hashCode());
          final java.lang.Object $samsungPay = this.getSamsungPay();
          result = result * PRIME + ($samsungPay == null ? 43 : $samsungPay.hashCode());
          final java.lang.Object $type = this.getType();
          result = result * PRIME + ($type == null ? 43 : $type.hashCode());
          final java.lang.Object $visaCheckout = this.getVisaCheckout();
          result = result * PRIME + ($visaCheckout == null ? 43 : $visaCheckout.hashCode());
          return result;
        }
      }

      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBrand() {
        return this.brand;
      }

      /**
       * Check results by Card networks on Card address and CVC at time of payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Checks getChecks() {
        return this.checks;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDescription() {
        return this.description;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpMonth() {
        return this.expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpYear() {
        return this.expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFunding() {
        return this.funding;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIin() {
        return this.iin;
      }

      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Installments getInstallments() {
        return this.installments;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIssuer() {
        return this.issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * True if this payment was marked as MOTO and out of scope for SCA.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getMoto() {
        return this.moto;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * Populated if this transaction used 3D Secure authentication.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
      }

      /**
       * If this Card is part of a card wallet, this contains the details of the card wallet.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Wallet getWallet() {
        return this.wallet;
      }

      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBrand(final String brand) {
        this.brand = brand;
      }

      /**
       * Check results by Card networks on Card address and CVC at time of payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setChecks(final Checks checks) {
        this.checks = checks;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDescription(final String description) {
        this.description = description;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpMonth(final Long expMonth) {
        this.expMonth = expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpYear(final Long expYear) {
        this.expYear = expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFunding(final String funding) {
        this.funding = funding;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIin(final String iin) {
        this.iin = iin;
      }

      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInstallments(final Installments installments) {
        this.installments = installments;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIssuer(final String issuer) {
        this.issuer = issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * True if this payment was marked as MOTO and out of scope for SCA.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMoto(final Boolean moto) {
        this.moto = moto;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      /**
       * Populated if this transaction used 3D Secure authentication.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setThreeDSecure(final ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
      }

      /**
       * If this Card is part of a card wallet, this contains the details of the card wallet.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setWallet(final Wallet wallet) {
        this.wallet = wallet;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Card)) return false;
        final Charge.PaymentMethodDetails.Card other = (Charge.PaymentMethodDetails.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expMonth = this.getExpMonth();
        final java.lang.Object other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
        final java.lang.Object this$expYear = this.getExpYear();
        final java.lang.Object other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
        final java.lang.Object this$moto = this.getMoto();
        final java.lang.Object other$moto = other.getMoto();
        if (this$moto == null ? other$moto != null : !this$moto.equals(other$moto)) return false;
        final java.lang.Object this$brand = this.getBrand();
        final java.lang.Object other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
        final java.lang.Object this$checks = this.getChecks();
        final java.lang.Object other$checks = other.getChecks();
        if (this$checks == null ? other$checks != null : !this$checks.equals(other$checks)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$funding = this.getFunding();
        final java.lang.Object other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
        final java.lang.Object this$iin = this.getIin();
        final java.lang.Object other$iin = other.getIin();
        if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
        final java.lang.Object this$installments = this.getInstallments();
        final java.lang.Object other$installments = other.getInstallments();
        if (this$installments == null ? other$installments != null : !this$installments.equals(other$installments)) return false;
        final java.lang.Object this$issuer = this.getIssuer();
        final java.lang.Object other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$threeDSecure = this.getThreeDSecure();
        final java.lang.Object other$threeDSecure = other.getThreeDSecure();
        if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
        final java.lang.Object this$wallet = this.getWallet();
        final java.lang.Object other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expMonth = this.getExpMonth();
        result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
        final java.lang.Object $expYear = this.getExpYear();
        result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
        final java.lang.Object $moto = this.getMoto();
        result = result * PRIME + ($moto == null ? 43 : $moto.hashCode());
        final java.lang.Object $brand = this.getBrand();
        result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
        final java.lang.Object $checks = this.getChecks();
        result = result * PRIME + ($checks == null ? 43 : $checks.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $funding = this.getFunding();
        result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
        final java.lang.Object $iin = this.getIin();
        result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
        final java.lang.Object $installments = this.getInstallments();
        result = result * PRIME + ($installments == null ? 43 : $installments.hashCode());
        final java.lang.Object $issuer = this.getIssuer();
        result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $threeDSecure = this.getThreeDSecure();
        result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
        final java.lang.Object $wallet = this.getWallet();
        result = result * PRIME + ($wallet == null ? 43 : $wallet.hashCode());
        return result;
      }
    }


    /**
     * Owner's verified shipping address. Values are verified or provided by the wallet
     * directly (if supported) at the time of authorization or settlement. They cannot be set
     * or mutated.
     */
    public static class CardPresent extends StripeObject {
      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @SerializedName("brand")
      String brand;
      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @SerializedName("cardholder_name")
      String cardholderName;
      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @SerializedName("country")
      String country;
      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @SerializedName("description")
      String description;
      /**
       * Authorization response cryptogram.
       */
      @SerializedName("emv_auth_data")
      String emvAuthData;
      /**
       * Two-digit number representing the card's expiration month.
       */
      @SerializedName("exp_month")
      Long expMonth;
      /**
       * Four-digit number representing the card's expiration year.
       */
      @SerializedName("exp_year")
      Long expYear;
      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @SerializedName("funding")
      String funding;
      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @SerializedName("generated_card")
      String generatedCard;
      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @SerializedName("iin")
      String iin;
      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @SerializedName("issuer")
      String issuer;
      /**
       * The last four digits of the card.
       */
      @SerializedName("last4")
      String last4;
      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @SerializedName("network")
      String network;
      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @SerializedName("read_method")
      String readMethod;
      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @SerializedName("receipt")
      Receipt receipt;


      public static class Receipt extends StripeObject {
        /**
         * The type of account being debited or credited
         *
         * <p>One of {@code checking}, {@code credit}, {@code prepaid}, or {@code unknown}.
         */
        @SerializedName("account_type")
        String accountType;
        /** EMV tag 9F26, cryptogram generated by the integrated circuit chip. */
        @SerializedName("application_cryptogram")
        String applicationCryptogram;
        /** Mnenomic of the Application Identifier. */
        @SerializedName("application_preferred_name")
        String applicationPreferredName;
        /** Identifier for this transaction. */
        @SerializedName("authorization_code")
        String authorizationCode;
        /** EMV tag 8A. A code returned by the card issuer. */
        @SerializedName("authorization_response_code")
        String authorizationResponseCode;
        /** How the cardholder verified ownership of the card. */
        @SerializedName("cardholder_verification_method")
        String cardholderVerificationMethod;
        /**
         * EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.
         */
        @SerializedName("dedicated_file_name")
        String dedicatedFileName;
        /** The outcome of a series of EMV functions performed by the card reader. */
        @SerializedName("terminal_verification_results")
        String terminalVerificationResults;
        @SerializedName("transaction_status_information")
        String transactionStatusInformation;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountType() {
          return this.accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getApplicationCryptogram() {
          return this.applicationCryptogram;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getApplicationPreferredName() {
          return this.applicationPreferredName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAuthorizationCode() {
          return this.authorizationCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAuthorizationResponseCode() {
          return this.authorizationResponseCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCardholderVerificationMethod() {
          return this.cardholderVerificationMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDedicatedFileName() {
          return this.dedicatedFileName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTerminalVerificationResults() {
          return this.terminalVerificationResults;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTransactionStatusInformation() {
          return this.transactionStatusInformation;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountType(final String accountType) {
          this.accountType = accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApplicationCryptogram(final String applicationCryptogram) {
          this.applicationCryptogram = applicationCryptogram;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApplicationPreferredName(final String applicationPreferredName) {
          this.applicationPreferredName = applicationPreferredName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAuthorizationCode(final String authorizationCode) {
          this.authorizationCode = authorizationCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAuthorizationResponseCode(final String authorizationResponseCode) {
          this.authorizationResponseCode = authorizationResponseCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCardholderVerificationMethod(final String cardholderVerificationMethod) {
          this.cardholderVerificationMethod = cardholderVerificationMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDedicatedFileName(final String dedicatedFileName) {
          this.dedicatedFileName = dedicatedFileName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTerminalVerificationResults(final String terminalVerificationResults) {
          this.terminalVerificationResults = terminalVerificationResults;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTransactionStatusInformation(final String transactionStatusInformation) {
          this.transactionStatusInformation = transactionStatusInformation;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.CardPresent.Receipt)) return false;
          final Charge.PaymentMethodDetails.CardPresent.Receipt other = (Charge.PaymentMethodDetails.CardPresent.Receipt) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountType = this.getAccountType();
          final java.lang.Object other$accountType = other.getAccountType();
          if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
          final java.lang.Object this$applicationCryptogram = this.getApplicationCryptogram();
          final java.lang.Object other$applicationCryptogram = other.getApplicationCryptogram();
          if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) return false;
          final java.lang.Object this$applicationPreferredName = this.getApplicationPreferredName();
          final java.lang.Object other$applicationPreferredName = other.getApplicationPreferredName();
          if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) return false;
          final java.lang.Object this$authorizationCode = this.getAuthorizationCode();
          final java.lang.Object other$authorizationCode = other.getAuthorizationCode();
          if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) return false;
          final java.lang.Object this$authorizationResponseCode = this.getAuthorizationResponseCode();
          final java.lang.Object other$authorizationResponseCode = other.getAuthorizationResponseCode();
          if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) return false;
          final java.lang.Object this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
          final java.lang.Object other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
          if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) return false;
          final java.lang.Object this$dedicatedFileName = this.getDedicatedFileName();
          final java.lang.Object other$dedicatedFileName = other.getDedicatedFileName();
          if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) return false;
          final java.lang.Object this$terminalVerificationResults = this.getTerminalVerificationResults();
          final java.lang.Object other$terminalVerificationResults = other.getTerminalVerificationResults();
          if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) return false;
          final java.lang.Object this$transactionStatusInformation = this.getTransactionStatusInformation();
          final java.lang.Object other$transactionStatusInformation = other.getTransactionStatusInformation();
          if (this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.CardPresent.Receipt;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountType = this.getAccountType();
          result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
          final java.lang.Object $applicationCryptogram = this.getApplicationCryptogram();
          result = result * PRIME + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
          final java.lang.Object $applicationPreferredName = this.getApplicationPreferredName();
          result = result * PRIME + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
          final java.lang.Object $authorizationCode = this.getAuthorizationCode();
          result = result * PRIME + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
          final java.lang.Object $authorizationResponseCode = this.getAuthorizationResponseCode();
          result = result * PRIME + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
          final java.lang.Object $cardholderVerificationMethod = this.getCardholderVerificationMethod();
          result = result * PRIME + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
          final java.lang.Object $dedicatedFileName = this.getDedicatedFileName();
          result = result * PRIME + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
          final java.lang.Object $terminalVerificationResults = this.getTerminalVerificationResults();
          result = result * PRIME + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
          final java.lang.Object $transactionStatusInformation = this.getTransactionStatusInformation();
          result = result * PRIME + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
          return result;
        }
      }

      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBrand() {
        return this.brand;
      }

      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCardholderName() {
        return this.cardholderName;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDescription() {
        return this.description;
      }

      /**
       * Authorization response cryptogram.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmvAuthData() {
        return this.emvAuthData;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpMonth() {
        return this.expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpYear() {
        return this.expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFunding() {
        return this.funding;
      }

      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getGeneratedCard() {
        return this.generatedCard;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIin() {
        return this.iin;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIssuer() {
        return this.issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReadMethod() {
        return this.readMethod;
      }

      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Receipt getReceipt() {
        return this.receipt;
      }

      /**
       * Card brand. Can be {@code amex}, {@code diners}, {@code discover}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBrand(final String brand) {
        this.brand = brand;
      }

      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCardholderName(final String cardholderName) {
        this.cardholderName = cardholderName;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDescription(final String description) {
        this.description = description;
      }

      /**
       * Authorization response cryptogram.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmvAuthData(final String emvAuthData) {
        this.emvAuthData = emvAuthData;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpMonth(final Long expMonth) {
        this.expMonth = expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpYear(final Long expYear) {
        this.expYear = expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFunding(final String funding) {
        this.funding = funding;
      }

      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setGeneratedCard(final String generatedCard) {
        this.generatedCard = generatedCard;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIin(final String iin) {
        this.iin = iin;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIssuer(final String issuer) {
        this.issuer = issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReadMethod(final String readMethod) {
        this.readMethod = readMethod;
      }

      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReceipt(final Receipt receipt) {
        this.receipt = receipt;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.CardPresent)) return false;
        final Charge.PaymentMethodDetails.CardPresent other = (Charge.PaymentMethodDetails.CardPresent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expMonth = this.getExpMonth();
        final java.lang.Object other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
        final java.lang.Object this$expYear = this.getExpYear();
        final java.lang.Object other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
        final java.lang.Object this$brand = this.getBrand();
        final java.lang.Object other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
        final java.lang.Object this$cardholderName = this.getCardholderName();
        final java.lang.Object other$cardholderName = other.getCardholderName();
        if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$emvAuthData = this.getEmvAuthData();
        final java.lang.Object other$emvAuthData = other.getEmvAuthData();
        if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$funding = this.getFunding();
        final java.lang.Object other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
        final java.lang.Object this$generatedCard = this.getGeneratedCard();
        final java.lang.Object other$generatedCard = other.getGeneratedCard();
        if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) return false;
        final java.lang.Object this$iin = this.getIin();
        final java.lang.Object other$iin = other.getIin();
        if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
        final java.lang.Object this$issuer = this.getIssuer();
        final java.lang.Object other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$readMethod = this.getReadMethod();
        final java.lang.Object other$readMethod = other.getReadMethod();
        if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) return false;
        final java.lang.Object this$receipt = this.getReceipt();
        final java.lang.Object other$receipt = other.getReceipt();
        if (this$receipt == null ? other$receipt != null : !this$receipt.equals(other$receipt)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.CardPresent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expMonth = this.getExpMonth();
        result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
        final java.lang.Object $expYear = this.getExpYear();
        result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
        final java.lang.Object $brand = this.getBrand();
        result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
        final java.lang.Object $cardholderName = this.getCardholderName();
        result = result * PRIME + ($cardholderName == null ? 43 : $cardholderName.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $emvAuthData = this.getEmvAuthData();
        result = result * PRIME + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $funding = this.getFunding();
        result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
        final java.lang.Object $generatedCard = this.getGeneratedCard();
        result = result * PRIME + ($generatedCard == null ? 43 : $generatedCard.hashCode());
        final java.lang.Object $iin = this.getIin();
        result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
        final java.lang.Object $issuer = this.getIssuer();
        result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $readMethod = this.getReadMethod();
        result = result * PRIME + ($readMethod == null ? 43 : $readMethod.hashCode());
        final java.lang.Object $receipt = this.getReceipt();
        result = result * PRIME + ($receipt == null ? 43 : $receipt.hashCode());
        return result;
      }
    }


    /**
     * An indication of various EMV functions performed during the transaction.
     */
    public static class Eps extends StripeObject {
      /**
       * Owner's verified full name. Values are verified or provided by EPS directly (if supported)
       * at the time of authorization or settlement. They cannot be set or mutated. EPS rarely
       * provides this information so the attribute is usually empty.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Owner's verified full name. Values are verified or provided by EPS directly (if supported)
       * at the time of authorization or settlement. They cannot be set or mutated. EPS rarely
       * provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * Owner's verified full name. Values are verified or provided by EPS directly (if supported)
       * at the time of authorization or settlement. They cannot be set or mutated. EPS rarely
       * provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Eps)) return false;
        final Charge.PaymentMethodDetails.Eps other = (Charge.PaymentMethodDetails.Eps) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Eps;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class Fpx extends StripeObject {
      /**
       * Account holder type, if provided. Can be one of {@code individual} or {@code company}.
       */
      @SerializedName("account_holder_type")
      String accountHolderType;
      /**
       * The customer's bank. Can be one of {@code affin_bank}, {@code alliance_bank}, {@code
       * ambank}, {@code bank_islam}, {@code bank_muamalat}, {@code bank_rakyat}, {@code bsn},
       * {@code cimb}, {@code hong_leong_bank}, {@code hsbc}, {@code kfh}, {@code maybank2u}, {@code
       * ocbc}, {@code public_bank}, {@code rhb}, {@code standard_chartered}, {@code uob}, {@code
       * deutsche_bank}, {@code maybank2e}, or {@code pb_enterprise}.
       */
      @SerializedName("bank")
      String bank;
      /**
       * Unique transaction id generated by FPX for every request from the merchant.
       */
      @SerializedName("transaction_id")
      String transactionId;

      /**
       * Account holder type, if provided. Can be one of {@code individual} or {@code company}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderType() {
        return this.accountHolderType;
      }

      /**
       * The customer's bank. Can be one of {@code affin_bank}, {@code alliance_bank}, {@code
       * ambank}, {@code bank_islam}, {@code bank_muamalat}, {@code bank_rakyat}, {@code bsn},
       * {@code cimb}, {@code hong_leong_bank}, {@code hsbc}, {@code kfh}, {@code maybank2u}, {@code
       * ocbc}, {@code public_bank}, {@code rhb}, {@code standard_chartered}, {@code uob}, {@code
       * deutsche_bank}, {@code maybank2e}, or {@code pb_enterprise}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBank() {
        return this.bank;
      }

      /**
       * Unique transaction id generated by FPX for every request from the merchant.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getTransactionId() {
        return this.transactionId;
      }

      /**
       * Account holder type, if provided. Can be one of {@code individual} or {@code company}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderType(final String accountHolderType) {
        this.accountHolderType = accountHolderType;
      }

      /**
       * The customer's bank. Can be one of {@code affin_bank}, {@code alliance_bank}, {@code
       * ambank}, {@code bank_islam}, {@code bank_muamalat}, {@code bank_rakyat}, {@code bsn},
       * {@code cimb}, {@code hong_leong_bank}, {@code hsbc}, {@code kfh}, {@code maybank2u}, {@code
       * ocbc}, {@code public_bank}, {@code rhb}, {@code standard_chartered}, {@code uob}, {@code
       * deutsche_bank}, {@code maybank2e}, or {@code pb_enterprise}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBank(final String bank) {
        this.bank = bank;
      }

      /**
       * Unique transaction id generated by FPX for every request from the merchant.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTransactionId(final String transactionId) {
        this.transactionId = transactionId;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Fpx)) return false;
        final Charge.PaymentMethodDetails.Fpx other = (Charge.PaymentMethodDetails.Fpx) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderType = this.getAccountHolderType();
        final java.lang.Object other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
        final java.lang.Object this$bank = this.getBank();
        final java.lang.Object other$bank = other.getBank();
        if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) return false;
        final java.lang.Object this$transactionId = this.getTransactionId();
        final java.lang.Object other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Fpx;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderType = this.getAccountHolderType();
        result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        final java.lang.Object $bank = this.getBank();
        result = result * PRIME + ($bank == null ? 43 : $bank.hashCode());
        final java.lang.Object $transactionId = this.getTransactionId();
        result = result * PRIME + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
      }
    }


    public static class Giropay extends StripeObject {
      /**
       * Bank code of bank associated with the bank account.
       */
      @SerializedName("bank_code")
      String bankCode;
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @SerializedName("bic")
      String bic;
      /**
       * Owner's verified full name. Values are verified or provided by Giropay directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Giropay rarely provides this information so the attribute is usually empty.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankCode() {
        return this.bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBic() {
        return this.bic;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Giropay directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Giropay rarely provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankCode(final String bankCode) {
        this.bankCode = bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBic(final String bic) {
        this.bic = bic;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Giropay directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Giropay rarely provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Giropay)) return false;
        final Charge.PaymentMethodDetails.Giropay other = (Charge.PaymentMethodDetails.Giropay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankCode = this.getBankCode();
        final java.lang.Object other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$bic = this.getBic();
        final java.lang.Object other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Giropay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankCode = this.getBankCode();
        result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $bic = this.getBic();
        result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class Ideal extends StripeObject {
      /**
       * The customer's bank. Can be one of {@code abn_amro}, {@code asn_bank}, {@code bunq}, {@code
       * handelsbanken}, {@code ing}, {@code knab}, {@code moneyou}, {@code rabobank}, {@code
       * regiobank}, {@code sns_bank}, {@code triodos_bank}, or {@code van_lanschot}.
       */
      @SerializedName("bank")
      String bank;
      /**
       * The Bank Identifier Code of the customer's bank.
       *
       * <p>One of {@code ABNANL2A}, {@code ASNBNL21}, {@code BUNQNL2A}, {@code FVLBNL22}, {@code
       * HANDNL2A}, {@code INGBNL2A}, {@code KNABNL2H}, {@code MOYONL21}, {@code RABONL2U}, {@code
       * RBRBNL21}, {@code SNSBNL2A}, or {@code TRIONL2U}.
       */
      @SerializedName("bic")
      String bic;
      /**
       * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit")
      ExpandableField<PaymentMethod> generatedSepaDebit;
      /**
       * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit_mandate")
      ExpandableField<Mandate> generatedSepaDebitMandate;
      /**
       * Last four characters of the IBAN.
       */
      @SerializedName("iban_last4")
      String ibanLast4;
      /**
       * Owner's verified full name. Values are verified or provided by iDEAL directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Get ID of expandable {@code generatedSepaDebit} object.
       */
      public String getGeneratedSepaDebit() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getId() : null;
      }

      public void setGeneratedSepaDebit(String id) {
        this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
      }

      /**
       * Get expanded {@code generatedSepaDebit}.
       */
      public PaymentMethod getGeneratedSepaDebitObject() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getExpanded() : null;
      }

      public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
        this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
      }

      /**
       * Get ID of expandable {@code generatedSepaDebitMandate} object.
       */
      public String getGeneratedSepaDebitMandate() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getId() : null;
      }

      public void setGeneratedSepaDebitMandate(String id) {
        this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
      }

      /**
       * Get expanded {@code generatedSepaDebitMandate}.
       */
      public Mandate getGeneratedSepaDebitMandateObject() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getExpanded() : null;
      }

      public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
        this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
      }

      /**
       * The customer's bank. Can be one of {@code abn_amro}, {@code asn_bank}, {@code bunq}, {@code
       * handelsbanken}, {@code ing}, {@code knab}, {@code moneyou}, {@code rabobank}, {@code
       * regiobank}, {@code sns_bank}, {@code triodos_bank}, or {@code van_lanschot}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBank() {
        return this.bank;
      }

      /**
       * The Bank Identifier Code of the customer's bank.
       *
       * <p>One of {@code ABNANL2A}, {@code ASNBNL21}, {@code BUNQNL2A}, {@code FVLBNL22}, {@code
       * HANDNL2A}, {@code INGBNL2A}, {@code KNABNL2H}, {@code MOYONL21}, {@code RABONL2U}, {@code
       * RBRBNL21}, {@code SNSBNL2A}, or {@code TRIONL2U}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBic() {
        return this.bic;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIbanLast4() {
        return this.ibanLast4;
      }

      /**
       * Owner's verified full name. Values are verified or provided by iDEAL directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * The customer's bank. Can be one of {@code abn_amro}, {@code asn_bank}, {@code bunq}, {@code
       * handelsbanken}, {@code ing}, {@code knab}, {@code moneyou}, {@code rabobank}, {@code
       * regiobank}, {@code sns_bank}, {@code triodos_bank}, or {@code van_lanschot}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBank(final String bank) {
        this.bank = bank;
      }

      /**
       * The Bank Identifier Code of the customer's bank.
       *
       * <p>One of {@code ABNANL2A}, {@code ASNBNL21}, {@code BUNQNL2A}, {@code FVLBNL22}, {@code
       * HANDNL2A}, {@code INGBNL2A}, {@code KNABNL2H}, {@code MOYONL21}, {@code RABONL2U}, {@code
       * RBRBNL21}, {@code SNSBNL2A}, or {@code TRIONL2U}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBic(final String bic) {
        this.bic = bic;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIbanLast4(final String ibanLast4) {
        this.ibanLast4 = ibanLast4;
      }

      /**
       * Owner's verified full name. Values are verified or provided by iDEAL directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Ideal)) return false;
        final Charge.PaymentMethodDetails.Ideal other = (Charge.PaymentMethodDetails.Ideal) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bank = this.getBank();
        final java.lang.Object other$bank = other.getBank();
        if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) return false;
        final java.lang.Object this$bic = this.getBic();
        final java.lang.Object other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
        final java.lang.Object this$generatedSepaDebit = this.getGeneratedSepaDebit();
        final java.lang.Object other$generatedSepaDebit = other.getGeneratedSepaDebit();
        if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) return false;
        final java.lang.Object this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        final java.lang.Object other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
        if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) return false;
        final java.lang.Object this$ibanLast4 = this.getIbanLast4();
        final java.lang.Object other$ibanLast4 = other.getIbanLast4();
        if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Ideal;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bank = this.getBank();
        result = result * PRIME + ($bank == null ? 43 : $bank.hashCode());
        final java.lang.Object $bic = this.getBic();
        result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
        final java.lang.Object $generatedSepaDebit = this.getGeneratedSepaDebit();
        result = result * PRIME + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
        final java.lang.Object $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        result = result * PRIME + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
        final java.lang.Object $ibanLast4 = this.getIbanLast4();
        result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class InteracPresent extends StripeObject {
      /**
       * Card brand. Can be {@code interac}, {@code mastercard} or {@code visa}.
       */
      @SerializedName("brand")
      String brand;
      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @SerializedName("cardholder_name")
      String cardholderName;
      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @SerializedName("country")
      String country;
      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @SerializedName("description")
      String description;
      /**
       * Authorization response cryptogram.
       */
      @SerializedName("emv_auth_data")
      String emvAuthData;
      /**
       * Two-digit number representing the card's expiration month.
       */
      @SerializedName("exp_month")
      Long expMonth;
      /**
       * Four-digit number representing the card's expiration year.
       */
      @SerializedName("exp_year")
      Long expYear;
      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @SerializedName("funding")
      String funding;
      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @SerializedName("generated_card")
      String generatedCard;
      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @SerializedName("iin")
      String iin;
      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @SerializedName("issuer")
      String issuer;
      /**
       * The last four digits of the card.
       */
      @SerializedName("last4")
      String last4;
      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @SerializedName("network")
      String network;
      /**
       * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
       */
      @SerializedName("preferred_locales")
      List<String> preferredLocales;
      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @SerializedName("read_method")
      String readMethod;
      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @SerializedName("receipt")
      Receipt receipt;


      public static class Receipt extends StripeObject {
        /**
         * The type of account being debited or credited
         *
         * <p>One of {@code checking}, {@code savings}, or {@code unknown}.
         */
        @SerializedName("account_type")
        String accountType;
        /** EMV tag 9F26, cryptogram generated by the integrated circuit chip. */
        @SerializedName("application_cryptogram")
        String applicationCryptogram;
        /** Mnenomic of the Application Identifier. */
        @SerializedName("application_preferred_name")
        String applicationPreferredName;
        /** Identifier for this transaction. */
        @SerializedName("authorization_code")
        String authorizationCode;
        /** EMV tag 8A. A code returned by the card issuer. */
        @SerializedName("authorization_response_code")
        String authorizationResponseCode;
        /** How the cardholder verified ownership of the card. */
        @SerializedName("cardholder_verification_method")
        String cardholderVerificationMethod;
        /**
         * EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.
         */
        @SerializedName("dedicated_file_name")
        String dedicatedFileName;
        /** The outcome of a series of EMV functions performed by the card reader. */
        @SerializedName("terminal_verification_results")
        String terminalVerificationResults;
        @SerializedName("transaction_status_information")
        String transactionStatusInformation;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountType() {
          return this.accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getApplicationCryptogram() {
          return this.applicationCryptogram;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getApplicationPreferredName() {
          return this.applicationPreferredName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAuthorizationCode() {
          return this.authorizationCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAuthorizationResponseCode() {
          return this.authorizationResponseCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCardholderVerificationMethod() {
          return this.cardholderVerificationMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDedicatedFileName() {
          return this.dedicatedFileName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTerminalVerificationResults() {
          return this.terminalVerificationResults;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTransactionStatusInformation() {
          return this.transactionStatusInformation;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountType(final String accountType) {
          this.accountType = accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApplicationCryptogram(final String applicationCryptogram) {
          this.applicationCryptogram = applicationCryptogram;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApplicationPreferredName(final String applicationPreferredName) {
          this.applicationPreferredName = applicationPreferredName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAuthorizationCode(final String authorizationCode) {
          this.authorizationCode = authorizationCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAuthorizationResponseCode(final String authorizationResponseCode) {
          this.authorizationResponseCode = authorizationResponseCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCardholderVerificationMethod(final String cardholderVerificationMethod) {
          this.cardholderVerificationMethod = cardholderVerificationMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDedicatedFileName(final String dedicatedFileName) {
          this.dedicatedFileName = dedicatedFileName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTerminalVerificationResults(final String terminalVerificationResults) {
          this.terminalVerificationResults = terminalVerificationResults;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTransactionStatusInformation(final String transactionStatusInformation) {
          this.transactionStatusInformation = transactionStatusInformation;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Charge.PaymentMethodDetails.InteracPresent.Receipt)) return false;
          final Charge.PaymentMethodDetails.InteracPresent.Receipt other = (Charge.PaymentMethodDetails.InteracPresent.Receipt) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountType = this.getAccountType();
          final java.lang.Object other$accountType = other.getAccountType();
          if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
          final java.lang.Object this$applicationCryptogram = this.getApplicationCryptogram();
          final java.lang.Object other$applicationCryptogram = other.getApplicationCryptogram();
          if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) return false;
          final java.lang.Object this$applicationPreferredName = this.getApplicationPreferredName();
          final java.lang.Object other$applicationPreferredName = other.getApplicationPreferredName();
          if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) return false;
          final java.lang.Object this$authorizationCode = this.getAuthorizationCode();
          final java.lang.Object other$authorizationCode = other.getAuthorizationCode();
          if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) return false;
          final java.lang.Object this$authorizationResponseCode = this.getAuthorizationResponseCode();
          final java.lang.Object other$authorizationResponseCode = other.getAuthorizationResponseCode();
          if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) return false;
          final java.lang.Object this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
          final java.lang.Object other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
          if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) return false;
          final java.lang.Object this$dedicatedFileName = this.getDedicatedFileName();
          final java.lang.Object other$dedicatedFileName = other.getDedicatedFileName();
          if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) return false;
          final java.lang.Object this$terminalVerificationResults = this.getTerminalVerificationResults();
          final java.lang.Object other$terminalVerificationResults = other.getTerminalVerificationResults();
          if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) return false;
          final java.lang.Object this$transactionStatusInformation = this.getTransactionStatusInformation();
          final java.lang.Object other$transactionStatusInformation = other.getTransactionStatusInformation();
          if (this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Charge.PaymentMethodDetails.InteracPresent.Receipt;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountType = this.getAccountType();
          result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
          final java.lang.Object $applicationCryptogram = this.getApplicationCryptogram();
          result = result * PRIME + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
          final java.lang.Object $applicationPreferredName = this.getApplicationPreferredName();
          result = result * PRIME + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
          final java.lang.Object $authorizationCode = this.getAuthorizationCode();
          result = result * PRIME + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
          final java.lang.Object $authorizationResponseCode = this.getAuthorizationResponseCode();
          result = result * PRIME + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
          final java.lang.Object $cardholderVerificationMethod = this.getCardholderVerificationMethod();
          result = result * PRIME + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
          final java.lang.Object $dedicatedFileName = this.getDedicatedFileName();
          result = result * PRIME + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
          final java.lang.Object $terminalVerificationResults = this.getTerminalVerificationResults();
          result = result * PRIME + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
          final java.lang.Object $transactionStatusInformation = this.getTransactionStatusInformation();
          result = result * PRIME + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
          return result;
        }
      }

      /**
       * Card brand. Can be {@code interac}, {@code mastercard} or {@code visa}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBrand() {
        return this.brand;
      }

      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCardholderName() {
        return this.cardholderName;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDescription() {
        return this.description;
      }

      /**
       * Authorization response cryptogram.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmvAuthData() {
        return this.emvAuthData;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpMonth() {
        return this.expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpYear() {
        return this.expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFunding() {
        return this.funding;
      }

      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getGeneratedCard() {
        return this.generatedCard;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIin() {
        return this.iin;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIssuer() {
        return this.issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getPreferredLocales() {
        return this.preferredLocales;
      }

      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReadMethod() {
        return this.readMethod;
      }

      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Receipt getReceipt() {
        return this.receipt;
      }

      /**
       * Card brand. Can be {@code interac}, {@code mastercard} or {@code visa}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBrand(final String brand) {
        this.brand = brand;
      }

      /**
       * The cardholder name as read from the card, in <a
       * href="https://en.wikipedia.org/wiki/ISO/IEC_7813">ISO 7813</a> format. May include
       * alphanumeric characters, special characters and first/last name separator ({@code /}).
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCardholderName(final String cardholderName) {
        this.cardholderName = cardholderName;
      }

      /**
       * Two-letter ISO code representing the country of the card. You could use this attribute to
       * get a sense of the international breakdown of cards you've collected.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Card description. (For internal use only and not typically available in standard API
       * requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDescription(final String description) {
        this.description = description;
      }

      /**
       * Authorization response cryptogram.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmvAuthData(final String emvAuthData) {
        this.emvAuthData = emvAuthData;
      }

      /**
       * Two-digit number representing the card's expiration month.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpMonth(final Long expMonth) {
        this.expMonth = expMonth;
      }

      /**
       * Four-digit number representing the card's expiration year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpYear(final Long expYear) {
        this.expYear = expYear;
      }

      /**
       * Uniquely identifies this particular card number. You can use this attribute to check
       * whether two customers who’ve signed up with you are using the same card number, for
       * example. For payment methods that tokenize card information (Apple Pay, Google Pay), the
       * tokenized number might be provided instead of the underlying card number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Card funding type. Can be {@code credit}, {@code debit}, {@code prepaid}, or {@code
       * unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFunding(final String funding) {
        this.funding = funding;
      }

      /**
       * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be
       * attached to a Customer for future transactions. Only present if it was possible to generate
       * a card PaymentMethod.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setGeneratedCard(final String generatedCard) {
        this.generatedCard = generatedCard;
      }

      /**
       * Issuer identification number of the card. (For internal use only and not typically
       * available in standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIin(final String iin) {
        this.iin = iin;
      }

      /**
       * Issuer bank name of the card. (For internal use only and not typically available in
       * standard API requests.)
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIssuer(final String issuer) {
        this.issuer = issuer;
      }

      /**
       * The last four digits of the card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * Identifies which network this charge was processed on. Can be {@code amex}, {@code
       * cartes_bancaires}, {@code diners}, {@code discover}, {@code interac}, {@code jcb}, {@code
       * mastercard}, {@code unionpay}, {@code visa}, or {@code unknown}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      /**
       * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLocales(final List<String> preferredLocales) {
        this.preferredLocales = preferredLocales;
      }

      /**
       * How card details were read in this transaction.
       *
       * <p>One of {@code contact_emv}, {@code contactless_emv}, {@code contactless_magstripe_mode},
       * {@code magnetic_stripe_fallback}, or {@code magnetic_stripe_track2}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReadMethod(final String readMethod) {
        this.readMethod = readMethod;
      }

      /**
       * A collection of fields required to be displayed on receipts. Only required for EMV
       * transactions.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReceipt(final Receipt receipt) {
        this.receipt = receipt;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.InteracPresent)) return false;
        final Charge.PaymentMethodDetails.InteracPresent other = (Charge.PaymentMethodDetails.InteracPresent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expMonth = this.getExpMonth();
        final java.lang.Object other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
        final java.lang.Object this$expYear = this.getExpYear();
        final java.lang.Object other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
        final java.lang.Object this$brand = this.getBrand();
        final java.lang.Object other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
        final java.lang.Object this$cardholderName = this.getCardholderName();
        final java.lang.Object other$cardholderName = other.getCardholderName();
        if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$emvAuthData = this.getEmvAuthData();
        final java.lang.Object other$emvAuthData = other.getEmvAuthData();
        if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$funding = this.getFunding();
        final java.lang.Object other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
        final java.lang.Object this$generatedCard = this.getGeneratedCard();
        final java.lang.Object other$generatedCard = other.getGeneratedCard();
        if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) return false;
        final java.lang.Object this$iin = this.getIin();
        final java.lang.Object other$iin = other.getIin();
        if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
        final java.lang.Object this$issuer = this.getIssuer();
        final java.lang.Object other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$preferredLocales = this.getPreferredLocales();
        final java.lang.Object other$preferredLocales = other.getPreferredLocales();
        if (this$preferredLocales == null ? other$preferredLocales != null : !this$preferredLocales.equals(other$preferredLocales)) return false;
        final java.lang.Object this$readMethod = this.getReadMethod();
        final java.lang.Object other$readMethod = other.getReadMethod();
        if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) return false;
        final java.lang.Object this$receipt = this.getReceipt();
        final java.lang.Object other$receipt = other.getReceipt();
        if (this$receipt == null ? other$receipt != null : !this$receipt.equals(other$receipt)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.InteracPresent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expMonth = this.getExpMonth();
        result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
        final java.lang.Object $expYear = this.getExpYear();
        result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
        final java.lang.Object $brand = this.getBrand();
        result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
        final java.lang.Object $cardholderName = this.getCardholderName();
        result = result * PRIME + ($cardholderName == null ? 43 : $cardholderName.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $emvAuthData = this.getEmvAuthData();
        result = result * PRIME + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $funding = this.getFunding();
        result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
        final java.lang.Object $generatedCard = this.getGeneratedCard();
        result = result * PRIME + ($generatedCard == null ? 43 : $generatedCard.hashCode());
        final java.lang.Object $iin = this.getIin();
        result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
        final java.lang.Object $issuer = this.getIssuer();
        result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $preferredLocales = this.getPreferredLocales();
        result = result * PRIME + ($preferredLocales == null ? 43 : $preferredLocales.hashCode());
        final java.lang.Object $readMethod = this.getReadMethod();
        result = result * PRIME + ($readMethod == null ? 43 : $readMethod.hashCode());
        final java.lang.Object $receipt = this.getReceipt();
        result = result * PRIME + ($receipt == null ? 43 : $receipt.hashCode());
        return result;
      }
    }


    /**
     * An indication of various EMV functions performed during the transaction.
     */
    public static class Klarna extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Klarna)) return false;
        final Charge.PaymentMethodDetails.Klarna other = (Charge.PaymentMethodDetails.Klarna) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Klarna;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class Multibanco extends StripeObject {
      /**
       * Entity number associated with this Multibanco payment.
       */
      @SerializedName("entity")
      String entity;
      /**
       * Reference number associated with this Multibanco payment.
       */
      @SerializedName("reference")
      String reference;

      /**
       * Entity number associated with this Multibanco payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEntity() {
        return this.entity;
      }

      /**
       * Reference number associated with this Multibanco payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReference() {
        return this.reference;
      }

      /**
       * Entity number associated with this Multibanco payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEntity(final String entity) {
        this.entity = entity;
      }

      /**
       * Reference number associated with this Multibanco payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReference(final String reference) {
        this.reference = reference;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Multibanco)) return false;
        final Charge.PaymentMethodDetails.Multibanco other = (Charge.PaymentMethodDetails.Multibanco) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$entity = this.getEntity();
        final java.lang.Object other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) return false;
        final java.lang.Object this$reference = this.getReference();
        final java.lang.Object other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Multibanco;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $entity = this.getEntity();
        result = result * PRIME + ($entity == null ? 43 : $entity.hashCode());
        final java.lang.Object $reference = this.getReference();
        result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
        return result;
      }
    }


    public static class Oxxo extends StripeObject {
      /**
       * OXXO reference number.
       */
      @SerializedName("number")
      String number;

      /**
       * OXXO reference number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNumber() {
        return this.number;
      }

      /**
       * OXXO reference number.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNumber(final String number) {
        this.number = number;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Oxxo)) return false;
        final Charge.PaymentMethodDetails.Oxxo other = (Charge.PaymentMethodDetails.Oxxo) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$number = this.getNumber();
        final java.lang.Object other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Oxxo;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $number = this.getNumber();
        result = result * PRIME + ($number == null ? 43 : $number.hashCode());
        return result;
      }
    }


    public static class P24 extends StripeObject {
      /**
       * Unique reference for this Przelewy24 payment.
       */
      @SerializedName("reference")
      String reference;
      /**
       * Owner's verified full name. Values are verified or provided by Przelewy24 directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Przelewy24 rarely provides this information so the attribute is usually empty.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Unique reference for this Przelewy24 payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReference() {
        return this.reference;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Przelewy24 directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Przelewy24 rarely provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * Unique reference for this Przelewy24 payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReference(final String reference) {
        this.reference = reference;
      }

      /**
       * Owner's verified full name. Values are verified or provided by Przelewy24 directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       * Przelewy24 rarely provides this information so the attribute is usually empty.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.P24)) return false;
        final Charge.PaymentMethodDetails.P24 other = (Charge.PaymentMethodDetails.P24) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$reference = this.getReference();
        final java.lang.Object other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.P24;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $reference = this.getReference();
        result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class SepaCreditTransfer extends StripeObject {
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @SerializedName("bic")
      String bic;
      /**
       * IBAN of the bank account to transfer funds to.
       */
      @SerializedName("iban")
      String iban;

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBic() {
        return this.bic;
      }

      /**
       * IBAN of the bank account to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIban() {
        return this.iban;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBic(final String bic) {
        this.bic = bic;
      }

      /**
       * IBAN of the bank account to transfer funds to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIban(final String iban) {
        this.iban = iban;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.SepaCreditTransfer)) return false;
        final Charge.PaymentMethodDetails.SepaCreditTransfer other = (Charge.PaymentMethodDetails.SepaCreditTransfer) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$bic = this.getBic();
        final java.lang.Object other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
        final java.lang.Object this$iban = this.getIban();
        final java.lang.Object other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.SepaCreditTransfer;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $bic = this.getBic();
        result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
        final java.lang.Object $iban = this.getIban();
        result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
        return result;
      }
    }


    public static class SepaDebit extends StripeObject {
      /**
       * Bank code of bank associated with the bank account.
       */
      @SerializedName("bank_code")
      String bankCode;
      /**
       * Branch code of bank associated with the bank account.
       */
      @SerializedName("branch_code")
      String branchCode;
      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @SerializedName("country")
      String country;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /**
       * Last four characters of the IBAN.
       */
      @SerializedName("last4")
      String last4;
      /**
       * ID of the mandate used to make this payment.
       */
      @SerializedName("mandate")
      String mandate;

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankCode() {
        return this.bankCode;
      }

      /**
       * Branch code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBranchCode() {
        return this.branchCode;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMandate() {
        return this.mandate;
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankCode(final String bankCode) {
        this.bankCode = bankCode;
      }

      /**
       * Branch code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBranchCode(final String branchCode) {
        this.branchCode = branchCode;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      /**
       * ID of the mandate used to make this payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandate(final String mandate) {
        this.mandate = mandate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.SepaDebit)) return false;
        final Charge.PaymentMethodDetails.SepaDebit other = (Charge.PaymentMethodDetails.SepaDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankCode = this.getBankCode();
        final java.lang.Object other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
        final java.lang.Object this$branchCode = this.getBranchCode();
        final java.lang.Object other$branchCode = other.getBranchCode();
        if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$mandate = this.getMandate();
        final java.lang.Object other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.SepaDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankCode = this.getBankCode();
        result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
        final java.lang.Object $branchCode = this.getBranchCode();
        result = result * PRIME + ($branchCode == null ? 43 : $branchCode.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $mandate = this.getMandate();
        result = result * PRIME + ($mandate == null ? 43 : $mandate.hashCode());
        return result;
      }
    }


    public static class Sofort extends StripeObject {
      /**
       * Bank code of bank associated with the bank account.
       */
      @SerializedName("bank_code")
      String bankCode;
      /**
       * Name of the bank associated with the bank account.
       */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @SerializedName("bic")
      String bic;
      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @SerializedName("country")
      String country;
      /**
       * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit")
      ExpandableField<PaymentMethod> generatedSepaDebit;
      /**
       * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
       */
      @SerializedName("generated_sepa_debit_mandate")
      ExpandableField<Mandate> generatedSepaDebitMandate;
      /**
       * Last four characters of the IBAN.
       */
      @SerializedName("iban_last4")
      String ibanLast4;
      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to. Can
       * be one of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}
       */
      @SerializedName("preferred_language")
      String preferredLanguage;
      /**
       * Owner's verified full name. Values are verified or provided by SOFORT directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @SerializedName("verified_name")
      String verifiedName;

      /**
       * Get ID of expandable {@code generatedSepaDebit} object.
       */
      public String getGeneratedSepaDebit() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getId() : null;
      }

      public void setGeneratedSepaDebit(String id) {
        this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
      }

      /**
       * Get expanded {@code generatedSepaDebit}.
       */
      public PaymentMethod getGeneratedSepaDebitObject() {
        return (this.generatedSepaDebit != null) ? this.generatedSepaDebit.getExpanded() : null;
      }

      public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
        this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
      }

      /**
       * Get ID of expandable {@code generatedSepaDebitMandate} object.
       */
      public String getGeneratedSepaDebitMandate() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getId() : null;
      }

      public void setGeneratedSepaDebitMandate(String id) {
        this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
      }

      /**
       * Get expanded {@code generatedSepaDebitMandate}.
       */
      public Mandate getGeneratedSepaDebitMandateObject() {
        return (this.generatedSepaDebitMandate != null) ? this.generatedSepaDebitMandate.getExpanded() : null;
      }

      public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
        this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankCode() {
        return this.bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBic() {
        return this.bic;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCountry() {
        return this.country;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIbanLast4() {
        return this.ibanLast4;
      }

      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to. Can
       * be one of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLanguage() {
        return this.preferredLanguage;
      }

      /**
       * Owner's verified full name. Values are verified or provided by SOFORT directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerifiedName() {
        return this.verifiedName;
      }

      /**
       * Bank code of bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankCode(final String bankCode) {
        this.bankCode = bankCode;
      }

      /**
       * Name of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      /**
       * Bank Identifier Code of the bank associated with the bank account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBic(final String bic) {
        this.bic = bic;
      }

      /**
       * Two-letter ISO code representing the country the bank account is located in.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCountry(final String country) {
        this.country = country;
      }

      /**
       * Last four characters of the IBAN.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIbanLast4(final String ibanLast4) {
        this.ibanLast4 = ibanLast4;
      }

      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to. Can
       * be one of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLanguage(final String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
      }

      /**
       * Owner's verified full name. Values are verified or provided by SOFORT directly (if
       * supported) at the time of authorization or settlement. They cannot be set or mutated.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerifiedName(final String verifiedName) {
        this.verifiedName = verifiedName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Sofort)) return false;
        final Charge.PaymentMethodDetails.Sofort other = (Charge.PaymentMethodDetails.Sofort) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankCode = this.getBankCode();
        final java.lang.Object other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$bic = this.getBic();
        final java.lang.Object other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
        final java.lang.Object this$country = this.getCountry();
        final java.lang.Object other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
        final java.lang.Object this$generatedSepaDebit = this.getGeneratedSepaDebit();
        final java.lang.Object other$generatedSepaDebit = other.getGeneratedSepaDebit();
        if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) return false;
        final java.lang.Object this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        final java.lang.Object other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
        if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) return false;
        final java.lang.Object this$ibanLast4 = this.getIbanLast4();
        final java.lang.Object other$ibanLast4 = other.getIbanLast4();
        if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
        final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
        final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
        final java.lang.Object this$verifiedName = this.getVerifiedName();
        final java.lang.Object other$verifiedName = other.getVerifiedName();
        if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Sofort;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankCode = this.getBankCode();
        result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $bic = this.getBic();
        result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
        final java.lang.Object $country = this.getCountry();
        result = result * PRIME + ($country == null ? 43 : $country.hashCode());
        final java.lang.Object $generatedSepaDebit = this.getGeneratedSepaDebit();
        result = result * PRIME + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
        final java.lang.Object $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
        result = result * PRIME + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
        final java.lang.Object $ibanLast4 = this.getIbanLast4();
        result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
        final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
        result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        final java.lang.Object $verifiedName = this.getVerifiedName();
        result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
        return result;
      }
    }


    public static class StripeAccount extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.StripeAccount)) return false;
        final Charge.PaymentMethodDetails.StripeAccount other = (Charge.PaymentMethodDetails.StripeAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.StripeAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class Wechat extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Charge.PaymentMethodDetails.Wechat)) return false;
        final Charge.PaymentMethodDetails.Wechat other = (Charge.PaymentMethodDetails.Wechat) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Charge.PaymentMethodDetails.Wechat;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AchCreditTransfer getAchCreditTransfer() {
      return this.achCreditTransfer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AchDebit getAchDebit() {
      return this.achDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcssDebit getAcssDebit() {
      return this.acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Alipay getAlipay() {
      return this.alipay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuBecsDebit getAuBecsDebit() {
      return this.auBecsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BacsDebit getBacsDebit() {
      return this.bacsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Bancontact getBancontact() {
      return this.bancontact;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CardPresent getCardPresent() {
      return this.cardPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Eps getEps() {
      return this.eps;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Fpx getFpx() {
      return this.fpx;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Giropay getGiropay() {
      return this.giropay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ideal getIdeal() {
      return this.ideal;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InteracPresent getInteracPresent() {
      return this.interacPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Klarna getKlarna() {
      return this.klarna;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Multibanco getMultibanco() {
      return this.multibanco;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Oxxo getOxxo() {
      return this.oxxo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public P24 getP24() {
      return this.p24;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaCreditTransfer getSepaCreditTransfer() {
      return this.sepaCreditTransfer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaDebit getSepaDebit() {
      return this.sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Sofort getSofort() {
      return this.sofort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public StripeAccount getStripeAccount() {
      return this.stripeAccount;
    }

    /**
     * The type of transaction-specific details of the payment method used in the payment, one of
     * {@code ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code au_becs_debit}, {@code
     * bancontact}, {@code card}, {@code card_present}, {@code eps}, {@code giropay}, {@code ideal},
     * {@code klarna}, {@code multibanco}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code
     * stripe_account}, or {@code wechat}. An additional hash is included on {@code
     * payment_method_details} with a name matching this value. It contains information specific to
     * the payment method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Wechat getWechat() {
      return this.wechat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAchCreditTransfer(final AchCreditTransfer achCreditTransfer) {
      this.achCreditTransfer = achCreditTransfer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAchDebit(final AchDebit achDebit) {
      this.achDebit = achDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAcssDebit(final AcssDebit acssDebit) {
      this.acssDebit = acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlipay(final Alipay alipay) {
      this.alipay = alipay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuBecsDebit(final AuBecsDebit auBecsDebit) {
      this.auBecsDebit = auBecsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBacsDebit(final BacsDebit bacsDebit) {
      this.bacsDebit = bacsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBancontact(final Bancontact bancontact) {
      this.bancontact = bancontact;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPresent(final CardPresent cardPresent) {
      this.cardPresent = cardPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEps(final Eps eps) {
      this.eps = eps;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFpx(final Fpx fpx) {
      this.fpx = fpx;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGiropay(final Giropay giropay) {
      this.giropay = giropay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdeal(final Ideal ideal) {
      this.ideal = ideal;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInteracPresent(final InteracPresent interacPresent) {
      this.interacPresent = interacPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKlarna(final Klarna klarna) {
      this.klarna = klarna;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMultibanco(final Multibanco multibanco) {
      this.multibanco = multibanco;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOxxo(final Oxxo oxxo) {
      this.oxxo = oxxo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setP24(final P24 p24) {
      this.p24 = p24;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaCreditTransfer(final SepaCreditTransfer sepaCreditTransfer) {
      this.sepaCreditTransfer = sepaCreditTransfer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaDebit(final SepaDebit sepaDebit) {
      this.sepaDebit = sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSofort(final Sofort sofort) {
      this.sofort = sofort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStripeAccount(final StripeAccount stripeAccount) {
      this.stripeAccount = stripeAccount;
    }

    /**
     * The type of transaction-specific details of the payment method used in the payment, one of
     * {@code ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code au_becs_debit}, {@code
     * bancontact}, {@code card}, {@code card_present}, {@code eps}, {@code giropay}, {@code ideal},
     * {@code klarna}, {@code multibanco}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code
     * stripe_account}, or {@code wechat}. An additional hash is included on {@code
     * payment_method_details} with a name matching this value. It contains information specific to
     * the payment method.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWechat(final Wechat wechat) {
      this.wechat = wechat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.PaymentMethodDetails)) return false;
      final Charge.PaymentMethodDetails other = (Charge.PaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$achCreditTransfer = this.getAchCreditTransfer();
      final java.lang.Object other$achCreditTransfer = other.getAchCreditTransfer();
      if (this$achCreditTransfer == null ? other$achCreditTransfer != null : !this$achCreditTransfer.equals(other$achCreditTransfer)) return false;
      final java.lang.Object this$achDebit = this.getAchDebit();
      final java.lang.Object other$achDebit = other.getAchDebit();
      if (this$achDebit == null ? other$achDebit != null : !this$achDebit.equals(other$achDebit)) return false;
      final java.lang.Object this$acssDebit = this.getAcssDebit();
      final java.lang.Object other$acssDebit = other.getAcssDebit();
      if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
      final java.lang.Object this$alipay = this.getAlipay();
      final java.lang.Object other$alipay = other.getAlipay();
      if (this$alipay == null ? other$alipay != null : !this$alipay.equals(other$alipay)) return false;
      final java.lang.Object this$auBecsDebit = this.getAuBecsDebit();
      final java.lang.Object other$auBecsDebit = other.getAuBecsDebit();
      if (this$auBecsDebit == null ? other$auBecsDebit != null : !this$auBecsDebit.equals(other$auBecsDebit)) return false;
      final java.lang.Object this$bacsDebit = this.getBacsDebit();
      final java.lang.Object other$bacsDebit = other.getBacsDebit();
      if (this$bacsDebit == null ? other$bacsDebit != null : !this$bacsDebit.equals(other$bacsDebit)) return false;
      final java.lang.Object this$bancontact = this.getBancontact();
      final java.lang.Object other$bancontact = other.getBancontact();
      if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$cardPresent = this.getCardPresent();
      final java.lang.Object other$cardPresent = other.getCardPresent();
      if (this$cardPresent == null ? other$cardPresent != null : !this$cardPresent.equals(other$cardPresent)) return false;
      final java.lang.Object this$eps = this.getEps();
      final java.lang.Object other$eps = other.getEps();
      if (this$eps == null ? other$eps != null : !this$eps.equals(other$eps)) return false;
      final java.lang.Object this$fpx = this.getFpx();
      final java.lang.Object other$fpx = other.getFpx();
      if (this$fpx == null ? other$fpx != null : !this$fpx.equals(other$fpx)) return false;
      final java.lang.Object this$giropay = this.getGiropay();
      final java.lang.Object other$giropay = other.getGiropay();
      if (this$giropay == null ? other$giropay != null : !this$giropay.equals(other$giropay)) return false;
      final java.lang.Object this$ideal = this.getIdeal();
      final java.lang.Object other$ideal = other.getIdeal();
      if (this$ideal == null ? other$ideal != null : !this$ideal.equals(other$ideal)) return false;
      final java.lang.Object this$interacPresent = this.getInteracPresent();
      final java.lang.Object other$interacPresent = other.getInteracPresent();
      if (this$interacPresent == null ? other$interacPresent != null : !this$interacPresent.equals(other$interacPresent)) return false;
      final java.lang.Object this$klarna = this.getKlarna();
      final java.lang.Object other$klarna = other.getKlarna();
      if (this$klarna == null ? other$klarna != null : !this$klarna.equals(other$klarna)) return false;
      final java.lang.Object this$multibanco = this.getMultibanco();
      final java.lang.Object other$multibanco = other.getMultibanco();
      if (this$multibanco == null ? other$multibanco != null : !this$multibanco.equals(other$multibanco)) return false;
      final java.lang.Object this$oxxo = this.getOxxo();
      final java.lang.Object other$oxxo = other.getOxxo();
      if (this$oxxo == null ? other$oxxo != null : !this$oxxo.equals(other$oxxo)) return false;
      final java.lang.Object this$p24 = this.getP24();
      final java.lang.Object other$p24 = other.getP24();
      if (this$p24 == null ? other$p24 != null : !this$p24.equals(other$p24)) return false;
      final java.lang.Object this$sepaCreditTransfer = this.getSepaCreditTransfer();
      final java.lang.Object other$sepaCreditTransfer = other.getSepaCreditTransfer();
      if (this$sepaCreditTransfer == null ? other$sepaCreditTransfer != null : !this$sepaCreditTransfer.equals(other$sepaCreditTransfer)) return false;
      final java.lang.Object this$sepaDebit = this.getSepaDebit();
      final java.lang.Object other$sepaDebit = other.getSepaDebit();
      if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) return false;
      final java.lang.Object this$sofort = this.getSofort();
      final java.lang.Object other$sofort = other.getSofort();
      if (this$sofort == null ? other$sofort != null : !this$sofort.equals(other$sofort)) return false;
      final java.lang.Object this$stripeAccount = this.getStripeAccount();
      final java.lang.Object other$stripeAccount = other.getStripeAccount();
      if (this$stripeAccount == null ? other$stripeAccount != null : !this$stripeAccount.equals(other$stripeAccount)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$wechat = this.getWechat();
      final java.lang.Object other$wechat = other.getWechat();
      if (this$wechat == null ? other$wechat != null : !this$wechat.equals(other$wechat)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.PaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $achCreditTransfer = this.getAchCreditTransfer();
      result = result * PRIME + ($achCreditTransfer == null ? 43 : $achCreditTransfer.hashCode());
      final java.lang.Object $achDebit = this.getAchDebit();
      result = result * PRIME + ($achDebit == null ? 43 : $achDebit.hashCode());
      final java.lang.Object $acssDebit = this.getAcssDebit();
      result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
      final java.lang.Object $alipay = this.getAlipay();
      result = result * PRIME + ($alipay == null ? 43 : $alipay.hashCode());
      final java.lang.Object $auBecsDebit = this.getAuBecsDebit();
      result = result * PRIME + ($auBecsDebit == null ? 43 : $auBecsDebit.hashCode());
      final java.lang.Object $bacsDebit = this.getBacsDebit();
      result = result * PRIME + ($bacsDebit == null ? 43 : $bacsDebit.hashCode());
      final java.lang.Object $bancontact = this.getBancontact();
      result = result * PRIME + ($bancontact == null ? 43 : $bancontact.hashCode());
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $cardPresent = this.getCardPresent();
      result = result * PRIME + ($cardPresent == null ? 43 : $cardPresent.hashCode());
      final java.lang.Object $eps = this.getEps();
      result = result * PRIME + ($eps == null ? 43 : $eps.hashCode());
      final java.lang.Object $fpx = this.getFpx();
      result = result * PRIME + ($fpx == null ? 43 : $fpx.hashCode());
      final java.lang.Object $giropay = this.getGiropay();
      result = result * PRIME + ($giropay == null ? 43 : $giropay.hashCode());
      final java.lang.Object $ideal = this.getIdeal();
      result = result * PRIME + ($ideal == null ? 43 : $ideal.hashCode());
      final java.lang.Object $interacPresent = this.getInteracPresent();
      result = result * PRIME + ($interacPresent == null ? 43 : $interacPresent.hashCode());
      final java.lang.Object $klarna = this.getKlarna();
      result = result * PRIME + ($klarna == null ? 43 : $klarna.hashCode());
      final java.lang.Object $multibanco = this.getMultibanco();
      result = result * PRIME + ($multibanco == null ? 43 : $multibanco.hashCode());
      final java.lang.Object $oxxo = this.getOxxo();
      result = result * PRIME + ($oxxo == null ? 43 : $oxxo.hashCode());
      final java.lang.Object $p24 = this.getP24();
      result = result * PRIME + ($p24 == null ? 43 : $p24.hashCode());
      final java.lang.Object $sepaCreditTransfer = this.getSepaCreditTransfer();
      result = result * PRIME + ($sepaCreditTransfer == null ? 43 : $sepaCreditTransfer.hashCode());
      final java.lang.Object $sepaDebit = this.getSepaDebit();
      result = result * PRIME + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
      final java.lang.Object $sofort = this.getSofort();
      result = result * PRIME + ($sofort == null ? 43 : $sofort.hashCode());
      final java.lang.Object $stripeAccount = this.getStripeAccount();
      result = result * PRIME + ($stripeAccount == null ? 43 : $stripeAccount.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $wechat = this.getWechat();
      result = result * PRIME + ($wechat == null ? 43 : $wechat.hashCode());
      return result;
    }
  }


  public static class TransferData extends StripeObject {
    /**
     * The amount transferred to the destination account, if specified. By default, the entire
     * charge amount is transferred to the destination account.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * ID of an existing, connected Stripe account to transfer funds to if {@code transfer_data} was
     * specified in the charge request.
     */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Charge.TransferData)) return false;
      final Charge.TransferData other = (Charge.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Charge.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AlternateStatementDescriptors getAlternateStatementDescriptors() {
    return this.alternateStatementDescriptors;
  }

  /**
   * Amount intended to be collected by this payment. A positive integer representing how much to
   * charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Amount in %s captured (can be less than the amount attribute on the charge if a partial capture
   * was made).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountCaptured() {
    return this.amountCaptured;
  }

  /**
   * Amount in %s refunded (can be less than the amount attribute on the charge if a partial refund
   * was issued).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountRefunded() {
    return this.amountRefunded;
  }

  /**
   * The amount of the application fee (if any) requested for the charge. <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">See the Connect
   * documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * Authorization code on the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthorizationCode() {
    return this.authorizationCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethod.BillingDetails getBillingDetails() {
    return this.billingDetails;
  }

  /**
   * The full statement descriptor that is passed to card networks, and that is displayed on your
   * customers' credit card and bank statements. Allows you to see what the statement descriptor
   * looks like after the static and dynamic portions are combined.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCalculatedStatementDescriptor() {
    return this.calculatedStatementDescriptor;
  }

  /**
   * If the charge was created without capturing, this Boolean represents whether it is still
   * uncaptured or has since been captured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCaptured() {
    return this.captured;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Whether the charge has been disputed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDisputed() {
    return this.disputed;
  }

  /**
   * Error code explaining reason for charge failure if available (see <a
   * href="https://stripe.com/docs/api#errors">the errors section</a> for a list of codes).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFailureCode() {
    return this.failureCode;
  }

  /**
   * Message to user further explaining reason for charge failure if available.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFailureMessage() {
    return this.failureMessage;
  }

  /**
   * Information on fraud assessments for the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FraudDetails getFraudDetails() {
    return this.fraudDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Level3 getLevel3() {
    return this.level3;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code charge}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Details about whether the payment was accepted, and why. See <a
   * href="https://stripe.com/docs/declines">understanding declines</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Outcome getOutcome() {
    return this.outcome;
  }

  /**
   * {@code true} if the charge succeeded, or was successfully authorized for later capture.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPaid() {
    return this.paid;
  }

  /**
   * ID of the payment method used in this charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentMethod() {
    return this.paymentMethod;
  }

  /**
   * Details about the payment method at the time of the transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodDetails getPaymentMethodDetails() {
    return this.paymentMethodDetails;
  }

  /**
   * This is the email address that the receipt for this charge was sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptEmail() {
    return this.receiptEmail;
  }

  /**
   * This is the transaction number that appears on email receipts sent for this charge. This
   * attribute will be {@code null} until a receipt has been sent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptNumber() {
    return this.receiptNumber;
  }

  /**
   * This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the
   * latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt
   * will be stylized as an Invoice receipt.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptUrl() {
    return this.receiptUrl;
  }

  /**
   * Whether the charge has been fully refunded. If the charge is only partially refunded, this
   * attribute will still be false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getRefunded() {
    return this.refunded;
  }

  /**
   * A list of refunds that have been applied to the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RefundCollection getRefunds() {
    return this.refunds;
  }

  /**
   * Shipping information for the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * This is a legacy field that will be removed in the future. It contains the Source, Card, or
   * BankAccount object used for the charge. For details about the payment method used for this
   * charge, refer to {@code payment_method} or {@code payment_method_details} instead.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentSource getSource() {
    return this.source;
  }

  /**
   * For card charges, use {@code statement_descriptor_suffix} instead. Otherwise, you can use this
   * value as the complete description of a charge on your customers’ statements. Must contain at
   * least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Provides information about the charge that customers see on their statements. Concatenated with
   * the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the
   * complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptorSuffix() {
    return this.statementDescriptorSuffix;
  }

  /**
   * The status of the payment is either {@code succeeded}, {@code pending}, or {@code failed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * An optional dictionary including the account to automatically transfer to as part of a
   * destination charge. <a href="https://stripe.com/docs/connect/destination-charges">See the
   * Connect documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers#transfer-options">Connect
   * documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTransferGroup() {
    return this.transferGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAlternateStatementDescriptors(final AlternateStatementDescriptors alternateStatementDescriptors) {
    this.alternateStatementDescriptors = alternateStatementDescriptors;
  }

  /**
   * Amount intended to be collected by this payment. A positive integer representing how much to
   * charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Amount in %s captured (can be less than the amount attribute on the charge if a partial capture
   * was made).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountCaptured(final Long amountCaptured) {
    this.amountCaptured = amountCaptured;
  }

  /**
   * Amount in %s refunded (can be less than the amount attribute on the charge if a partial refund
   * was issued).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountRefunded(final Long amountRefunded) {
    this.amountRefunded = amountRefunded;
  }

  /**
   * The amount of the application fee (if any) requested for the charge. <a
   * href="https://stripe.com/docs/connect/direct-charges#collecting-fees">See the Connect
   * documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * Authorization code on the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizationCode(final String authorizationCode) {
    this.authorizationCode = authorizationCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingDetails(final PaymentMethod.BillingDetails billingDetails) {
    this.billingDetails = billingDetails;
  }

  /**
   * The full statement descriptor that is passed to card networks, and that is displayed on your
   * customers' credit card and bank statements. Allows you to see what the statement descriptor
   * looks like after the static and dynamic portions are combined.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCalculatedStatementDescriptor(final String calculatedStatementDescriptor) {
    this.calculatedStatementDescriptor = calculatedStatementDescriptor;
  }

  /**
   * If the charge was created without capturing, this Boolean represents whether it is still
   * uncaptured or has since been captured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaptured(final Boolean captured) {
    this.captured = captured;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Whether the charge has been disputed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDisputed(final Boolean disputed) {
    this.disputed = disputed;
  }

  /**
   * Error code explaining reason for charge failure if available (see <a
   * href="https://stripe.com/docs/api#errors">the errors section</a> for a list of codes).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFailureCode(final String failureCode) {
    this.failureCode = failureCode;
  }

  /**
   * Message to user further explaining reason for charge failure if available.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFailureMessage(final String failureMessage) {
    this.failureMessage = failureMessage;
  }

  /**
   * Information on fraud assessments for the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFraudDetails(final FraudDetails fraudDetails) {
    this.fraudDetails = fraudDetails;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLevel3(final Level3 level3) {
    this.level3 = level3;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code charge}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Details about whether the payment was accepted, and why. See <a
   * href="https://stripe.com/docs/declines">understanding declines</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutcome(final Outcome outcome) {
    this.outcome = outcome;
  }

  /**
   * {@code true} if the charge succeeded, or was successfully authorized for later capture.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaid(final Boolean paid) {
    this.paid = paid;
  }

  /**
   * ID of the payment method used in this charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethod(final String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * Details about the payment method at the time of the transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodDetails(final PaymentMethodDetails paymentMethodDetails) {
    this.paymentMethodDetails = paymentMethodDetails;
  }

  /**
   * This is the email address that the receipt for this charge was sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptEmail(final String receiptEmail) {
    this.receiptEmail = receiptEmail;
  }

  /**
   * This is the transaction number that appears on email receipts sent for this charge. This
   * attribute will be {@code null} until a receipt has been sent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptNumber(final String receiptNumber) {
    this.receiptNumber = receiptNumber;
  }

  /**
   * This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the
   * latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt
   * will be stylized as an Invoice receipt.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptUrl(final String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }

  /**
   * Whether the charge has been fully refunded. If the charge is only partially refunded, this
   * attribute will still be false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunded(final Boolean refunded) {
    this.refunded = refunded;
  }

  /**
   * A list of refunds that have been applied to the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunds(final RefundCollection refunds) {
    this.refunds = refunds;
  }

  /**
   * Shipping information for the charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * This is a legacy field that will be removed in the future. It contains the Source, Card, or
   * BankAccount object used for the charge. For details about the payment method used for this
   * charge, refer to {@code payment_method} or {@code payment_method_details} instead.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSource(final PaymentSource source) {
    this.source = source;
  }

  /**
   * For card charges, use {@code statement_descriptor_suffix} instead. Otherwise, you can use this
   * value as the complete description of a charge on your customers’ statements. Must contain at
   * least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Provides information about the charge that customers see on their statements. Concatenated with
   * the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the
   * complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptorSuffix(final String statementDescriptorSuffix) {
    this.statementDescriptorSuffix = statementDescriptorSuffix;
  }

  /**
   * The status of the payment is either {@code succeeded}, {@code pending}, or {@code failed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * An optional dictionary including the account to automatically transfer to as part of a
   * destination charge. <a href="https://stripe.com/docs/connect/destination-charges">See the
   * Connect documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers#transfer-options">Connect
   * documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferGroup(final String transferGroup) {
    this.transferGroup = transferGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Charge)) return false;
    final Charge other = (Charge) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountCaptured = this.getAmountCaptured();
    final java.lang.Object other$amountCaptured = other.getAmountCaptured();
    if (this$amountCaptured == null ? other$amountCaptured != null : !this$amountCaptured.equals(other$amountCaptured)) return false;
    final java.lang.Object this$amountRefunded = this.getAmountRefunded();
    final java.lang.Object other$amountRefunded = other.getAmountRefunded();
    if (this$amountRefunded == null ? other$amountRefunded != null : !this$amountRefunded.equals(other$amountRefunded)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$captured = this.getCaptured();
    final java.lang.Object other$captured = other.getCaptured();
    if (this$captured == null ? other$captured != null : !this$captured.equals(other$captured)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$disputed = this.getDisputed();
    final java.lang.Object other$disputed = other.getDisputed();
    if (this$disputed == null ? other$disputed != null : !this$disputed.equals(other$disputed)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$paid = this.getPaid();
    final java.lang.Object other$paid = other.getPaid();
    if (this$paid == null ? other$paid != null : !this$paid.equals(other$paid)) return false;
    final java.lang.Object this$refunded = this.getRefunded();
    final java.lang.Object other$refunded = other.getRefunded();
    if (this$refunded == null ? other$refunded != null : !this$refunded.equals(other$refunded)) return false;
    final java.lang.Object this$alternateStatementDescriptors = this.getAlternateStatementDescriptors();
    final java.lang.Object other$alternateStatementDescriptors = other.getAlternateStatementDescriptors();
    if (this$alternateStatementDescriptors == null ? other$alternateStatementDescriptors != null : !this$alternateStatementDescriptors.equals(other$alternateStatementDescriptors)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$applicationFee = this.getApplicationFee();
    final java.lang.Object other$applicationFee = other.getApplicationFee();
    if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) return false;
    final java.lang.Object this$authorizationCode = this.getAuthorizationCode();
    final java.lang.Object other$authorizationCode = other.getAuthorizationCode();
    if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) return false;
    final java.lang.Object this$balanceTransaction = this.getBalanceTransaction();
    final java.lang.Object other$balanceTransaction = other.getBalanceTransaction();
    if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) return false;
    final java.lang.Object this$billingDetails = this.getBillingDetails();
    final java.lang.Object other$billingDetails = other.getBillingDetails();
    if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
    final java.lang.Object this$calculatedStatementDescriptor = this.getCalculatedStatementDescriptor();
    final java.lang.Object other$calculatedStatementDescriptor = other.getCalculatedStatementDescriptor();
    if (this$calculatedStatementDescriptor == null ? other$calculatedStatementDescriptor != null : !this$calculatedStatementDescriptor.equals(other$calculatedStatementDescriptor)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$destination = this.getDestination();
    final java.lang.Object other$destination = other.getDestination();
    if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
    final java.lang.Object this$dispute = this.getDispute();
    final java.lang.Object other$dispute = other.getDispute();
    if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) return false;
    final java.lang.Object this$failureCode = this.getFailureCode();
    final java.lang.Object other$failureCode = other.getFailureCode();
    if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) return false;
    final java.lang.Object this$failureMessage = this.getFailureMessage();
    final java.lang.Object other$failureMessage = other.getFailureMessage();
    if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) return false;
    final java.lang.Object this$fraudDetails = this.getFraudDetails();
    final java.lang.Object other$fraudDetails = other.getFraudDetails();
    if (this$fraudDetails == null ? other$fraudDetails != null : !this$fraudDetails.equals(other$fraudDetails)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$level3 = this.getLevel3();
    final java.lang.Object other$level3 = other.getLevel3();
    if (this$level3 == null ? other$level3 != null : !this$level3.equals(other$level3)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$order = this.getOrder();
    final java.lang.Object other$order = other.getOrder();
    if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
    final java.lang.Object this$outcome = this.getOutcome();
    final java.lang.Object other$outcome = other.getOutcome();
    if (this$outcome == null ? other$outcome != null : !this$outcome.equals(other$outcome)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodDetails = this.getPaymentMethodDetails();
    final java.lang.Object other$paymentMethodDetails = other.getPaymentMethodDetails();
    if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !this$paymentMethodDetails.equals(other$paymentMethodDetails)) return false;
    final java.lang.Object this$receiptEmail = this.getReceiptEmail();
    final java.lang.Object other$receiptEmail = other.getReceiptEmail();
    if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) return false;
    final java.lang.Object this$receiptNumber = this.getReceiptNumber();
    final java.lang.Object other$receiptNumber = other.getReceiptNumber();
    if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) return false;
    final java.lang.Object this$receiptUrl = this.getReceiptUrl();
    final java.lang.Object other$receiptUrl = other.getReceiptUrl();
    if (this$receiptUrl == null ? other$receiptUrl != null : !this$receiptUrl.equals(other$receiptUrl)) return false;
    final java.lang.Object this$refunds = this.getRefunds();
    final java.lang.Object other$refunds = other.getRefunds();
    if (this$refunds == null ? other$refunds != null : !this$refunds.equals(other$refunds)) return false;
    final java.lang.Object this$review = this.getReview();
    final java.lang.Object other$review = other.getReview();
    if (this$review == null ? other$review != null : !this$review.equals(other$review)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$sourceTransfer = this.getSourceTransfer();
    final java.lang.Object other$sourceTransfer = other.getSourceTransfer();
    if (this$sourceTransfer == null ? other$sourceTransfer != null : !this$sourceTransfer.equals(other$sourceTransfer)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    final java.lang.Object other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
    if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transfer = this.getTransfer();
    final java.lang.Object other$transfer = other.getTransfer();
    if (this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$transferGroup = this.getTransferGroup();
    final java.lang.Object other$transferGroup = other.getTransferGroup();
    if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Charge;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountCaptured = this.getAmountCaptured();
    result = result * PRIME + ($amountCaptured == null ? 43 : $amountCaptured.hashCode());
    final java.lang.Object $amountRefunded = this.getAmountRefunded();
    result = result * PRIME + ($amountRefunded == null ? 43 : $amountRefunded.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $captured = this.getCaptured();
    result = result * PRIME + ($captured == null ? 43 : $captured.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $disputed = this.getDisputed();
    result = result * PRIME + ($disputed == null ? 43 : $disputed.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $paid = this.getPaid();
    result = result * PRIME + ($paid == null ? 43 : $paid.hashCode());
    final java.lang.Object $refunded = this.getRefunded();
    result = result * PRIME + ($refunded == null ? 43 : $refunded.hashCode());
    final java.lang.Object $alternateStatementDescriptors = this.getAlternateStatementDescriptors();
    result = result * PRIME + ($alternateStatementDescriptors == null ? 43 : $alternateStatementDescriptors.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $applicationFee = this.getApplicationFee();
    result = result * PRIME + ($applicationFee == null ? 43 : $applicationFee.hashCode());
    final java.lang.Object $authorizationCode = this.getAuthorizationCode();
    result = result * PRIME + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
    final java.lang.Object $balanceTransaction = this.getBalanceTransaction();
    result = result * PRIME + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
    final java.lang.Object $billingDetails = this.getBillingDetails();
    result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
    final java.lang.Object $calculatedStatementDescriptor = this.getCalculatedStatementDescriptor();
    result = result * PRIME + ($calculatedStatementDescriptor == null ? 43 : $calculatedStatementDescriptor.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $destination = this.getDestination();
    result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
    final java.lang.Object $dispute = this.getDispute();
    result = result * PRIME + ($dispute == null ? 43 : $dispute.hashCode());
    final java.lang.Object $failureCode = this.getFailureCode();
    result = result * PRIME + ($failureCode == null ? 43 : $failureCode.hashCode());
    final java.lang.Object $failureMessage = this.getFailureMessage();
    result = result * PRIME + ($failureMessage == null ? 43 : $failureMessage.hashCode());
    final java.lang.Object $fraudDetails = this.getFraudDetails();
    result = result * PRIME + ($fraudDetails == null ? 43 : $fraudDetails.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $level3 = this.getLevel3();
    result = result * PRIME + ($level3 == null ? 43 : $level3.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $order = this.getOrder();
    result = result * PRIME + ($order == null ? 43 : $order.hashCode());
    final java.lang.Object $outcome = this.getOutcome();
    result = result * PRIME + ($outcome == null ? 43 : $outcome.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodDetails = this.getPaymentMethodDetails();
    result = result * PRIME + ($paymentMethodDetails == null ? 43 : $paymentMethodDetails.hashCode());
    final java.lang.Object $receiptEmail = this.getReceiptEmail();
    result = result * PRIME + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
    final java.lang.Object $receiptNumber = this.getReceiptNumber();
    result = result * PRIME + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
    final java.lang.Object $receiptUrl = this.getReceiptUrl();
    result = result * PRIME + ($receiptUrl == null ? 43 : $receiptUrl.hashCode());
    final java.lang.Object $refunds = this.getRefunds();
    result = result * PRIME + ($refunds == null ? 43 : $refunds.hashCode());
    final java.lang.Object $review = this.getReview();
    result = result * PRIME + ($review == null ? 43 : $review.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $sourceTransfer = this.getSourceTransfer();
    result = result * PRIME + ($sourceTransfer == null ? 43 : $sourceTransfer.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    result = result * PRIME + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transfer = this.getTransfer();
    result = result * PRIME + ($transfer == null ? 43 : $transfer.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $transferGroup = this.getTransferGroup();
    result = result * PRIME + ($transferGroup == null ? 43 : $transferGroup.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
